/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.CollectionProperty=exports.collectionOverridableAttributes=exports.ReferenceArrayProperty=exports.JsonReferenceProperty=exports.ReferenceProperty=exports.referenceOverridableAttributes=exports.ForeignNodeProperty=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),_=require("lodash"),decorators_1=require("../decorators"),decorator_utils_1=require("../decorators/decorator-utils"),loggers_1=require("../runtime/loggers"),property_1=require("./property"),logger=loggers_1.loggers.property;class ForeignNodeProperty extends property_1.Property{#e;constructor(e,t,r){super(e,t,r),this._decorator=t}get decorator(){return this._decorator}verify(){super.verify();if(this._factoryDecorators.node.isSharedByAllTenants&&!this.targetFactory.isSharedByAllTenants)throw this.systemError(`A ${this.type} property of a shared node cannot be linked to a non-shared node.`);if(this.isVital&&this.isReferenceArrayProperty())throw this.systemError(`A ${this.type} cannot be vital`);if(this.decorator.isMutable&&"external"!==this.factory.storage&&!this.targetFactory.isContentAddressable&&!this.targetFactory.isAssociationChild&&!this.isSystemProperty)throw this.systemError("A mutable property is only allowed on nodes with external storage or on content addressable nodes.");if(this.decorator.isMutable&&this.isReferenceArrayProperty())throw this.systemError(`A ${this.type} cannot be mutable`);if(this.isVital&&this.isTransientInput)throw this.systemError("A vital property cannot be a transient input");if(this.isVital&&this.decorator.isMutable)throw this.systemError("Remove the isMutable attribute, as it is implied by isVital.");if(this.targetFactory.isClearedByReset&&this.isClearedByReset)throw this.systemError("A property can only be tagged isClearedByReset if its target node is not tagged");if("json"===this.targetFactory.storage){if(!this.isVital)throw this.systemError("A reference property to a json node must be vital");const e=this.targetFactory.properties.find(e=>!(0,xtrem_shared_1.isColumnTypeName)(e.type));if(e)throw this.systemError(`${e.name}: json nodes can only have scalar properties`)}else if(this.isVital){if(!this.reverseReference)throw this.systemError("A vital property must have a 'reverseReference' attribute");if(this.isStored)throw this.systemError("A vital property cannot have 'isStored' set to true");if(this instanceof ReferenceProperty&&!this.targetFactory.isVitalReferenceChild)throw this.systemError("The referenced class does not have an isVitalReferenceChild attribute");if(this instanceof CollectionProperty&&!this.targetFactory.isVitalCollectionChild)throw this.systemError("The referenced class does not have an isVitalCollectionChild attribute");const e=this.targetFactory.properties.filter(e=>e.isReferenceProperty()&&(e.isVitalParent||e.isAssociationParent));if(0===e.length)throw this.targetFactory.systemError("No vital parent reference");else if(e.length>1){if(e.filter(e=>e.isVitalParent).length>1)throw this.targetFactory.systemError("Too many vital parent references")}else{const t=e[0];if(true===t.isNullable)throw this.systemError("This parent reference must be non nullable");if(t.name!==this.reverseReference)throw this.systemError(`The reverseReference attribute doesn't match the ${this.targetFactory.name}'s property flagged with isVitalParent`);if(!this.factory.isAssignableTo(t.targetFactory))throw this.systemError(`${this.factory.name} is not assignable to ${t.targetFactory.name}, the parent of ${this.targetFactory.name}`)}const t=this.targetFactory.findProperty(this.reverseReference);if(!t.isVitalParent&&!t.isAssociationParent)throw this.systemError("The 'reverseReference' attribute must point to the property flagged with 'isVitalParent' or 'isAssociationParent' in the target child node")}else if(this.isAssociation){if(!this.reverseReference)throw this.systemError("An association property must have a 'reverseReference' attribute");if(this.isStored)throw this.systemError("An association property cannot have 'isStored' set to true");if(!this.targetFactory.isAssociationChild)throw this.systemError("The referenced class does not have an isAssociationCollectionChild or isAssociationReferenceChild attribute");if(!this.targetFactory.findProperty(this.reverseReference).isAssociationParent)throw this.systemError("The 'reverseReference' attribute must point to the property flagged with 'isAssociationParent' in the target child node")}if(this.isInherited&&!this.isSystemProperty){const e=this.factory.baseFactory?.findProperty(this.name);if(!e?.isForeignNodeProperty())throw this.logicError("invalid override: mismatch with property in super class");if(!this.targetFactory.isAssignableTo(e.targetFactory))throw new xtrem_shared_1.LogicError(`${this.fullName}: invalid override: '${this.targetFactory.name}' is not a subclass of '${e.targetFactory.name}'`)}}needsJoin(){return!this.getValue&&!this.computeValue&&"json"!==this.targetFactory.storage}verifyJoin(){if(this.needsJoin()){if(!this.join)throw this.systemError("join missing");if(this.join)Object.keys(this.join).forEach(e=>this.targetFactory.findProperty(e))}}get reverseReference(){return this._decorator.reverseReference}get isVital(){return!!this._decorator.isVital}get isAssociation(){return!!this.decorator.isAssociation}get isMutable(){return!!this._decorator.isMutable||this.isVital||this.isAssociation}get targetFactory(){if(this.#e)return this.#e;const e=this._decorator.node();return this.#e=this.factory.application.getFactoryByConstructor(e),this.#e}get node(){const e=this._decorator.node();if(!e)throw this.systemError(`node() returns ${e}, probably caused by a circular dependency during require`);return e}overrideAttributes(e){if(super.overrideAttributes(e),e.node)this.#e=this.factory.application.getFactoryByConstructor(e.node())}getReverseReferenceFilter(){const e=this.reverseReference;return{[e]:"_id"}}}exports.ForeignNodeProperty=ForeignNodeProperty,exports.referenceOverridableAttributes=[...property_1.overridableAttributes,"filters"];class ReferenceProperty extends ForeignNodeProperty{#t;constructor(e,t,r){super(e,t,r),this._decorator=t,this.#t=this._decorator.filters}get isVitalParent(){return!!this._decorator.isVitalParent}get isVitalParentInput(){return!!this._decorator.isVitalParentInput}get canLookup(){return false!==this._decorator.canLookup}get isAssociationParent(){return!!this._decorator.isAssociationParent}get isSelfReference(){if(void 0===this._isSelfReference)this._isSelfReference=!this._decorator.isNullable&&"function"==typeof this._decorator.defaultValue&&(0,xtrem_shared_1.removeCodeCoverageInstrumentation)(this._decorator.defaultValue.toString()).replace(/\s+/g," ").replace("{return this;}","{ return this; }").replace("{return this}","{ return this; }").endsWith("{ return this; }");return this._isSelfReference}get isRequired(){return super.isRequired||!!this._decorator.isVitalParent||!!this._decorator.isAssociationParent}verifyExternalStorage(){if(this.isStored)if("external"!==this._factory.storage)throw this.systemError("A reference property linked to an external storage node cannot have the isStored attribute set to true, if the parent node is not an external storage node.")}get isHardDependency(){if(this.isSelfReference)return false;if(!this.isNullable)return true;if(this.allowedInUniqueIndex)return true;return false}get isToposortDependency(){if(this._decorator.ignoreInToposort)return false;if(this.isHardDependency)return true;if(this.targetFactory.isSetupNode)return true;return false}get ignoreIsActive(){return this._decorator.ignoreIsActive}verifyDelegatedToProperty(e){if(super.verifyDelegatedToProperty(e),!e.isForeignNodeProperty())throw this.logicError("delegated property is not a foreign node property");if(e.node!==this.node)throw this.logicError(`Invalid delegatesTo decorator attribute: target node mispatch, expected ${this.node.name}, got ${e.node.name}`)}verify(){super.verify();const e=this._factoryDecorators;if((e.node.tableName||e.node.name)&&!this.isMutable&&!this.isStored&&!this.isTransientInput&&null==this.delegatesTo&&null==this.getValue&&null==this.computeValue&&null==this.decorator.join&&this.isPublished)throw this.systemError("A published property needs either 'isStored', 'isVital', 'isMutable', 'isTransientInput', 'computeValue', 'getValue' or 'join' decorator member to be set.");if(!(this.isVital||this.isAssociation)&&this.reverseReference)throw this.systemError("Non vital reference properties do not have any 'reverseReference' attribute.");if(this.isVital&&this.targetFactory.isContentAddressable)throw this.systemError("isVital is forbidden on reference to a content addressable node, use isMutable instead");if("external"===this.targetFactory.storage)this.verifyExternalStorage();if(this.factory.canCreate&&!this.isNullable&&this.duplicatedValue===decorators_1.useDefaultValue&&!this.defaultValue)throw this.systemError("Non-nullable reference properties with duplicatedValue: useDefaultValue need a defaultValue.");if(this._decorator.ignoreInToposort)if(!this.targetFactory.isSetupNode||!this.isNullable)throw this.systemError("ignoreInToposort attribute can only be set on a nullable reference to a setup node")}get join(){switch(this.targetFactory.storage){case"sql":if(this.isVital||this.isAssociation)return this.getReverseReferenceFilter();if(this.decorator.join)return this.decorator.join;return{_id:this.name};case"external":return this._factoryDecorators.node.externalStorageManager?.getReferenceJoin(this.name);default:return}}get canTranslateToSql(){return super.canTranslateToSql||!!this.decorator.join}get columnType(){if("sql"!==this._factory.storage||this.isVital)return super.columnType;return"integer"}get filters(){return this.#t}isValueTypeValid(e){return _.isInteger(e)||"string"==typeof e||"object"==typeof e}getTargetIsActivePropertyName(){return this.isVitalParent||this.isAssociationParent?void 0:this.targetFactory.properties.find(e=>e.provides?.includes("isActive"))?.name}addExtension(e){this.verifyExtensionKeys(Object.keys(e),exports.referenceOverridableAttributes),this.overrideAttributes(e)}overrideAttributes(e){if(super.overrideAttributes(e),!e.filters)return;try{const t=this.#t,r=e.filters;this.#t={control:(0,decorator_utils_1.chainFilters)(t?.control,r?.control),lookup:(0,decorator_utils_1.chainFilters)(t?.lookup,r?.lookup)}}catch(e){throw this.systemError(e.message)}}}exports.ReferenceProperty=ReferenceProperty;class JsonReferenceProperty extends ReferenceProperty{constructor(e,t,r){super(e,t,r),this._decorator=t}get type(){return"jsonReference"}get columnType(){return"json"}}exports.JsonReferenceProperty=JsonReferenceProperty;class ReferenceArrayProperty extends ReferenceProperty{constructor(e,t,r){super(e,t,r),this._decorator=t}get type(){return"referenceArray"}get columnType(){return"referenceArray"}isValueTypeValid(e){return Array.isArray(e)&&e.every(e=>_.isInteger(e)||"string"==typeof e||"object"==typeof e)}needsTypeConversion(e){if("string"==typeof e){if(!e.length)return true;if(e.startsWith("[")&&e.endsWith("]"))return Array.isArray(this.mapInputValue(e))}return false}mapInputValue(e){const t=e;if(!t||!t.length)return[];return t.slice(1,t.length-1).split(",").map(e=>e.replace(/^'(.*)'$/,"$1").replace(/^"(.*)"$/,"$1").trim())}}exports.ReferenceArrayProperty=ReferenceArrayProperty,exports.collectionOverridableAttributes=[...property_1.overridableAttributes,"controlBegin","controlEnd","saveBegin","saveEnd"];class CollectionProperty extends ForeignNodeProperty{constructor(e,t,r){super(e,t,r),this._decorator=t}get decorator(){return this._decorator}verify(){if(super.verify(),this._decorator.orderBy&&this.isVital)throw this.systemError("orderBy attribute is forbidden on vital collections");if(this.targetFactory.isContentAddressable)throw this.systemError("Collections of content addressable nodes are not supported");if(this.reverseReference){const e=this.targetFactory.findProperty(this.reverseReference);if(!["reference","referenceArray","jsonReference"].includes(e.type))throw this.systemError(`Invalid 'reverseReference' decorator ('${this.targetFactory.name}.${this.reverseReference}' is not a reference)`)}if("external"===this.targetFactory.storage)this.verifyExternalStorage();if(this.getValue)logger.warn(`${this.fullName}: getValue is deprecated on collections (PERF KILLER)`);if(this.computeValue)logger.warn(`${this.fullName}: computeValue is deprecated on collections (PERF KILLER)`)}addExtension(e){this.verifyExtensionKeys(Object.keys(e),exports.collectionOverridableAttributes),this.overrideAttributes(e)}overrideAttributes(e){super.overrideAttributes(e);Object.keys(e).forEach(t=>{switch(t){case"controlBegin":case"controlEnd":case"saveBegin":case"saveEnd":try{this[t]=(0,decorator_utils_1.chainEvents)(this[t],e[t],t)}catch(e){throw this.systemError(e.message)}}})}verifyExternalStorage(){const findIndex=e=>{const t=this._factory.properties.findIndex(t=>t.name===e);if(t<0)throw this.systemError(`invalid join: property not found: ${e}`);return t},e=findIndex(this.name);Object.values(this.join||{}).filter(e=>"string"==typeof e).forEach(t=>{const r=findIndex(t);if(r===e)throw this.systemError("invalid join: collection property cannot join to itself");if(r>e)throw this.systemError(`missing property dependency: add "dependsOn: ['${this._factory.properties[r].name}']" to property '${this.name}'`)})}get join(){switch(this._factory.storage){case"sql":if(this.reverseReference)return this.getReverseReferenceFilter();if(this.decorator.join)return this.decorator.join;return;case"external":return this._factoryDecorators.node.externalStorageManager.getCollectionJoin(this.name);default:return}}get orderBy(){if("sql"===this._factory.storage&&this.isVital&&!this.targetFactory.isAssociationChild)return{_sortValue:1};return this._decorator.orderBy}get prepareBegin(){if(this._decorator.prepareBegin&&this._decorator.prepare&&this._decorator.prepare!==this._decorator.prepareBegin)throw this.logicError("prepare and prepareBegin are mutually exclusive");return this._decorator.prepareBegin=this._decorator.prepareBegin||this._decorator.prepare,void 0===this._prepareBegin?this._decorator.prepareBegin:this._prepareBegin}set prepareBegin(e){this._prepareBegin=e}get prepareEnd(){return void 0===this._prepareEnd?this._decorator.prepareEnd:this._prepareEnd}set prepareEnd(e){this._prepareEnd=e}get controlBegin(){return void 0===this._controlBegin?this._decorator.controlBegin:this._controlBegin}set controlBegin(e){this._controlBegin=e}get controlEnd(){return void 0===this._controlEnd?this._decorator.controlEnd:this._controlEnd}set controlEnd(e){this._controlEnd=e}get saveBegin(){return void 0===this._saveBegin?this._decorator.saveBegin:this._saveBegin}set saveBegin(e){this._saveBegin=e}get saveEnd(){return void 0===this._saveEnd?this._decorator.saveEnd:this._saveEnd}set saveEnd(e){this._saveEnd=e}get getFilter(){return this._decorator.getFilter}needsJoin(){return super.needsJoin()&&!this.getFilter}get forceFullSave(){return!!this._decorator.forceFullSave}isValueTypeValid(e){return Array.isArray(e)}}exports.CollectionProperty=CollectionProperty;
//# sourceMappingURL=foreign-node-property.js.map