import { AnyValue } from '@sage/xtrem-async-helper';
import { Package } from '../application';
import { DatePropertyDecorator, DateRangePropertyDecorator, DatetimePropertyDecorator, DatetimeRangePropertyDecorator, TimePropertyDecorator } from '../decorators';
import { NodeFactory } from '../runtime';
import { Property } from './property';
export declare class DateProperty extends Property {
    protected _decorator: DatePropertyDecorator;
    constructor(factory: NodeFactory, _decorator: DatePropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
}
export declare class DateRangeProperty extends Property {
    protected _decorator: DateRangePropertyDecorator;
    constructor(factory: NodeFactory, _decorator: DateRangePropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
}
export declare class DatetimeProperty extends Property {
    protected _decorator: DatetimePropertyDecorator;
    constructor(factory: NodeFactory, _decorator: DatetimePropertyDecorator, definingPackage: Package);
    needsTypeConversion(value: AnyValue): boolean;
    isValueTypeValid(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
}
export declare class DatetimeRangeProperty extends Property {
    protected _decorator: DatetimeRangePropertyDecorator;
    constructor(factory: NodeFactory, _decorator: DatetimeRangePropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
}
export declare class TimeProperty extends Property {
    protected _decorator: TimePropertyDecorator;
    constructor(factory: NodeFactory, _decorator: TimePropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
}
//# sourceMappingURL=date-time-property.d.ts.map