/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateJoin=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),ts_api_1=require("../ts-api"),state_load_1=require("./state-load"),state_set_value_1=require("./state-set-value");class StateJoin{static async getColumnValue(e,t){if(e.isThunk&&void 0===e.values[t])await state_load_1.StateLoad.load(e);return e.values[t]}static getExternalJoinValues(e,t,r){if(!e.factory.externalStorageManager)throw e.factory.logicError("external storage manager is missing");return e.factory.externalStorageManager.getJoinValues(e.node,e.values,t.name,r)}static addConstructorToJoinFilter(e,t,r){if(t.rootProperty.factory.baseFactory)return;if(e.targetFactory.isAbstract)throw e.logicError("property cannot be polymorphic because its reverse property is inherited");r._constructor=e.targetFactory.name}static buildJoinEntry(e,t,r,a,i){if("string"==typeof a)return StateJoin.getColumnValue(e,a);if("function"==typeof a)return a.call(e.node);if(a instanceof ts_api_1.JoinLiteralValue)return Promise.resolve(a.value);if("object"==typeof a){if(null===a)return Promise.resolve(null);if(Object.keys(a).every(e=>!!r.targetFactory.propertiesByName[e]))return(0,xtrem_async_helper_1.asyncArray)(Object.keys(a)).reduce(async(o,n)=>{const s=a[n];if("object"==typeof s&&!(a instanceof ts_api_1.JoinLiteralValue||"function"==typeof a||null===a)){const a=r.targetFactory.findProperty(n);if(!a.isForeignNodeProperty())throw a.logicError(`Invalid join element ${n}`);o[n]=await this.buildJoinEntry(e,t,a,s,[...i,n])}else o[n]=await this.buildJoinEntry(e,t,r,s,[...i,n]);return o},{})}throw t.logicError(`invalid join member. Expected string or function, got ${typeof a} for ${i.join(".")}`)}static async getSqlJoinValues(e,t){if(t.needsJoin()&&t.join){const{join:r}=t,a=await(0,xtrem_async_helper_1.asyncArray)(Object.keys(r)).reduce(async(a,i)=>{const o=r[i];return a[i]=await StateJoin.buildJoinEntry(e,t,t,o,[t.name,i]),a},{});if(t.reverseReference){const e=t.targetFactory.findProperty(t.reverseReference);if(e.isInherited)StateJoin.addConstructorToJoinFilter(t,e,a)}return a}if(t.isCollectionProperty()&&t.getFilter)return t.getFilter.call(e.node);return{_id:await StateJoin.getColumnValue(e,t.name)}}static getJoinValues(e,t){switch(e.factory.storage){case"external":return StateJoin.getExternalJoinValues(e,t);case"sql":return StateJoin.getSqlJoinValues(e,t);default:return{}}}static async getSqlArrayJoinValues(e,t,r){const a=await StateJoin.getColumnValue(e,t.name);if(!Array.isArray(a))throw e.propertyDataInputError(t,{message:"Invalid value in array property: {{value}}",key:"@sage/xtrem-core/invalid-value-in-array-property",data:{value:a}});return{_id:a[r]}}static getArrayJoinValues(e,t,r){switch(e.factory.storage){case"external":return StateJoin.getExternalJoinValues(e,t,r);case"sql":return StateJoin.getSqlArrayJoinValues(e,t,r);default:return{}}}static async assignJoinedProperties(e,t,r){if(!t.join)throw t.logicError("property has no join");const a=r.$.state,assign=async(t,r)=>{const a=e.factory.findProperty(t);if(void 0!==r)await state_set_value_1.StateSetValue.setRawValue(e,a,r)};await(0,xtrem_async_helper_1.asyncArray)(Object.keys(t.join)).forEach(async e=>{if(!t.join)return;const r=t.join[e];if("string"==typeof r){const t=await StateJoin.getColumnValue(a,e);await assign(r,t)}})}static initVitalReferenceJoin(e,t,r){Object.keys(t.join||{}).forEach(a=>{let i;if(!(a in r)){const r=t.join[a];if("function"==typeof r)i=r.call(e.node);else if("string"==typeof r)i=e.values[r]}if(void 0===i)return;if(void 0===r[a])r[a]=i;else if(r[a]!==i)throw e.propertyDataInputError(t,{message:"cannot initialize join: values for '{{k}}' differ: expected {{data}}, got {{value}}",key:"@sage/xtrem-core/cannot-initialize-join",data:{k:a,data:r[a],value:i}})})}}exports.StateJoin=StateJoin;
//# sourceMappingURL=state-join.js.map