/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateInvalidate=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),collections_1=require("../collections"),decorators_1=require("../decorators"),runtime_1=require("../runtime"),loggers_1=require("../runtime/loggers"),ts_api_1=require("../ts-api"),state_dependency_1=require("./state-dependency"),state_init_1=require("./state-init"),state_set_value_1=require("./state-set-value");class StateInvalidate{static async invalidatePropertyValues(e,t){const walk=async(a,i)=>{const r=t[i];if(i<t.length-1){if(!r.isMutable)loggers_1.loggers.runtime.warn(`${r.factory.name}.${r.name}: Non vital/mutable property in dependsOn`);await state_dependency_1.StateDependency.withDependenciesRestriction(e,r,async()=>{const e=await a.getPropertyValue(r);if(null==e)return;if(e instanceof collections_1.BaseCollection)await e.forEach(e=>walk(e.$.state,i+1));else if(e instanceof ts_api_1.Node)await walk(e.$.state,i+1);else throw a.propertySystemError(r,"property value is not a node: "+typeof e)})}else a.invalidProperties.add(r.name)};await walk(e,0)}static async invalidateDependantProperties(e,t){if(!t.propagatesTo)return;if(t.isVitalParent||t.isAssociationParent)return;await(0,xtrem_async_helper_1.asyncArray)(t.propagatesTo).forEach(t=>StateInvalidate.invalidatePropertyValues(e,t))}static clearInvalidated(e,t){if(e.invalidProperties.has(t.name))return e.invalidProperties.delete(t.name),true;return false}static async setPropertyValue(e,t,a,i){await e.context.withoutReadonlyScopes(()=>state_set_value_1.StateSetValue.setPropertyValue(e,t,a,i))}static async updatePropertyValue(e,t,a){const i=t.updatedValue;if(void 0===i)return;await state_dependency_1.StateDependency.withDependenciesRestriction(e,t,async()=>{const r=await e.getPropertyValue(t);let n=i;if("function"==typeof i)n=!t.isLocalized?await e.context.withoutLocalizedTextAsJson(()=>e.context.withReadonlyScope(()=>t.executeRule(e,"updatedValue"))):await e.context.withReadonlyScope(()=>t.executeRule(e,"updatedValue"));if(n===decorators_1.useDefaultValue)n=await state_init_1.StateInit.getDefaultValue(e,t);if(0!==(0,runtime_1.valueComparator)(n,r))await StateInvalidate.setPropertyValue(e,t,a,n),await StateInvalidate.invalidateDependantProperties(e,t)})}static async validatePropertyValue(e,t,a){if(StateInvalidate.clearInvalidated(e,t))await StateInvalidate.updatePropertyValue(e,t,a)}}exports.StateInvalidate=StateInvalidate;
//# sourceMappingURL=state-invalidate.js.map