/** @packageDocumentation @module runtime */
import { AnyRecord } from '@sage/xtrem-async-helper';
import { NodeState } from './node-state';
/** Method to duplicate a node */
export declare class StateDuplicate {
    /**
     * Negate vital references on vital graph for new records to be inserted
     * clear vendor values
     * @param factory
     * @param data
     * @returns
     */
    private static convertVitalData;
    /**
     * Negate non-vital references on vital graph
     * @param factory
     * @param data
     * @param mappedIds
     * @returns
     */
    private static convertNonVitalReferenceData;
    private static getForeignNodePropertyDuplicatedValue;
    private static getPropertyDuplicatedValue;
    /** Apply duplicatedValue */
    private static setDuplicatedValuesInData;
    private static duplicateState;
    /**
     * Duplicate the passed in node state. Returns the unsaved node state
     */
    static duplicate(state: NodeState, data?: AnyRecord): Promise<NodeState>;
    /**
     * Get a duplicated transient instance of the state passed in
     * The vital collection tree branches loaded can be limited with using the option limitCollections
     * This is to improve the performance of the getDuplicate query
     * @param state
     * @param options
     * @returns
     */
    static getDuplicate(state: NodeState, options?: {
        limitCollections?: number;
    }): Promise<NodeState>;
}
//# sourceMappingURL=state-duplicate.d.ts.map