/// <reference types="node" />
import { Express } from 'express';
import { OperationKind } from '../../decorators/decorator-utils';
import { NodeRuleName } from '../../decorators/node-decorators/node-events';
import { PropertyRuleName } from '../../decorators/property-decorators/base-property-events';
import EventEmitter = require('node:events');
export declare const allMetricsEnabled: boolean;
export type StatementKind = 'select' | 'insert' | 'update' | 'upsert' | 'delete';
export declare class CustomMetrics {
    static readonly emitter: EventEmitter<[never]>;
    static readonly rules: CustomCounters<{
        nodeName: string;
        propertyName: string;
        ruleName: NodeRuleName | PropertyRuleName;
    }>;
    static readonly graphql: CustomCounters<{
        nodeName: string;
        operationName: string;
        operationKind: OperationKind;
    }>;
    static readonly metadata: CustomCounters<{
        nodeName: string;
        operationName: string;
        operationKind: OperationKind;
    }>;
    static readonly sql: CustomCounters<{
        nodeName: string;
        statementKind: StatementKind;
    }>;
    static get expressApp(): Express;
}
//# sourceMappingURL=custom-metrics.d.ts.map