/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.recordXtremErrorToNewrelic=exports.recordXtremEventToNewrelic=exports.record3rdPartyEventToNewrelic=exports.RequestKind=exports.ThirdParty=void 0;const xtrem_log_1=require("@sage/xtrem-log"),logger=xtrem_log_1.Logger.getLogger(__filename,"newrelic-custom-event-emiter"),isNewrelicDisabled="true"!==process.env.NEW_RELIC_ENABLED;var ThirdParty,RequestKind;!function(e){e.intacct="Intacct",e.frp1000="FRP1000",e.avalara="Avalara",e.taxServiceFabric="TaxService"}(ThirdParty||(exports.ThirdParty=ThirdParty={})),function(e){e.read="Read",e.list="List",e.create="Create",e.delete="Delete",e.update="Update",e.execute="Execute",e.unknown="Unknown"}(RequestKind||(exports.RequestKind=RequestKind={}));const newrelicEventThirdParty="thirdPartyRequest",newrelicEventXtremEvent="xtremEvent";function record3rdPartyEventToNewrelic(e){try{if(isNewrelicDisabled)return;const r={...e,success:e.success?1:0,failure:e.success?0:1,async:e.async?1:0};require("newrelic").recordCustomEvent(newrelicEventThirdParty,r)}catch({stack:e,message:r}){logger.warn(`Failed to send 3rdparty event to newrelic ${e||r}`)}}function recordXtremEventToNewrelic(e){try{if(isNewrelicDisabled)return;if(!e.tenantId)e.tenantId="unknown";if(e.durationMs&&e.durationMs<0)delete e.durationMs;require("newrelic").recordCustomEvent(newrelicEventXtremEvent,{...e})}catch({stack:e,message:r}){logger.warn(`Failed to send xtrem event to newrelic ${e||r}`)}}function recordXtremErrorToNewrelic(e,r){try{if(isNewrelicDisabled)return;require("newrelic").noticeError(r,{cloudflareRayID:e.cloudflareRayID,tenantId:e.tenantId||"unknown"})}catch({stack:e,message:r}){logger.warn(`Failed to send xtrem error to newrelic ${e||r}`)}}exports.record3rdPartyEventToNewrelic=record3rdPartyEventToNewrelic,exports.recordXtremEventToNewrelic=recordXtremEventToNewrelic,exports.recordXtremErrorToNewrelic=recordXtremErrorToNewrelic;
//# sourceMappingURL=custom-event-emiter.js.map