/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.InteropAppHealthMonitor=void 0;const xtrem_config_1=require("@sage/xtrem-config"),interop_graphql_client_1=require("./interop-graphql-client");class InteropAppHealthMonitor{static{this._isStarted=false}static{this._apps={}}static get appsHealthCheckMillis(){return 1e3*(xtrem_config_1.ConfigManager.current.interop?.appsHealthCheckSeconds??60)}static get aliveApps(){return Object.keys(InteropAppHealthMonitor._apps).filter(t=>InteropAppHealthMonitor._apps[t].isAlive)}static async isAppAlive(t,e={}){if(!InteropAppHealthMonitor._apps[t]||e.force)await InteropAppHealthMonitor.setAppHealth(t);return InteropAppHealthMonitor._apps[t]?.isAlive??false}static get isStarted(){return InteropAppHealthMonitor._isStarted}static start(){if(xtrem_config_1.ConfigManager.current.storage?.managedExternal)throw new Error("Apps health check monitor not supported in the context of a managed external storage");const{app:t,apps:e}=xtrem_config_1.ConfigManager.current;if(!t)return;if(!e||0===Object.keys(e).length)return void interop_graphql_client_1.logger.warn("Cannot start apps health check: No apps defined in the configuration");if(InteropAppHealthMonitor._isStarted)return;InteropAppHealthMonitor._isStarted=true,setInterval(()=>InteropAppHealthMonitor._checkAppsHealth(e),InteropAppHealthMonitor.appsHealthCheckMillis),interop_graphql_client_1.logger.info("Apps health check monitor started")}static _checkAppsHealth(t){Promise.allSettled(Object.keys(t).map(t=>InteropAppHealthMonitor.setAppHealth(t))).catch(t=>{interop_graphql_client_1.logger.error(`Error while checking health of apps: ${t}`)})}static setAppHealth(t){return interop_graphql_client_1.InteropGraphqlClient.getAppHealth(t).then(e=>{InteropAppHealthMonitor._apps[t]=e}).catch(e=>{interop_graphql_client_1.logger.error(`Error while checking health of app ${t}: ${e}`)}).finally(()=>{const e=InteropAppHealthMonitor._apps[t];if(200!==e?.status)interop_graphql_client_1.logger.error(()=>`Check health of ${t} app: status ${e?.status} (${e?.isAlive?"alive":"unavailable"})`);else interop_graphql_client_1.logger.debug(()=>`Check health of ${t} app: status ${e?.status} (${e?.isAlive?"alive":"unavailable"})`)})}}exports.InteropAppHealthMonitor=InteropAppHealthMonitor;
//# sourceMappingURL=interop-app-health-monitor.js.map