/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.bodyLoggerMiddleware=exports.requestLoggerMiddleware=exports.loggerAllowsCompress=void 0;const xtrem_config_1=require("@sage/xtrem-config"),request_1=require("./request");function loggerAllowsCompress(e){return!e.isActive("verbose")}function truncate(e,r=80){const t=r<10?"":` (len=${e.length})`;return e.length>r?`${e.substring(0,r)}...${t}`:e}function getBodyJsonSanitizer(){if("development"===xtrem_config_1.ConfigManager.current.deploymentMode)return(e,r)=>r;return(e,r)=>{if("string"!=typeof r)return r;if("_id"===e)return r;return"..."}}exports.loggerAllowsCompress=loggerAllowsCompress;class HttpVerbose{constructor(e){this.service=e}static bodyStringSanitizer(e){try{return JSON.stringify(JSON.parse(e),getBodyJsonSanitizer())}catch{return truncate(e,3)}}logRequestBody(e){const r=(0,request_1.getRequestId)(e),t=JSON.stringify(e.body,getBodyJsonSanitizer());return`HTTP ${this.service} request  ${r} body: ${truncate(t)}`}logResponse(e,r,t){const s=(0,request_1.getRequestId)(e.req);if("string"==typeof t)return`HTTP ${this.service} response ${s} ${r}: ${t&&truncate(HttpVerbose.bodyStringSanitizer(t).replace(/\n/g,"\\n"))}`;const o=null==t?`${t}`:`0x${t.subarray(0,3).toString("hex")} [length: ${t.length}]`;return`HTTP ${this.service} response ${s} ${r}: ${o}`}}class HttpDebug{constructor(e){this.service=e}logRequestBody(e){const r=(0,request_1.getRequestId)(e),t=e.body.query?Object.keys(e.body).map(r=>`\n${r}: ${e.body[r]}`):JSON.stringify(e.body,getBodyJsonSanitizer());return`HTTP ${this.service} request  ${r} body: ${t}`}logRequestHeaders(e){const r=(0,request_1.getRequestId)(e);return`HTTP ${this.service} request  ${r} headers: ${JSON.stringify(e.headers)}`}logResponseHeaders(e){const r=(0,request_1.getRequestId)(e.req);return`HTTP ${this.service} response ${r} headers: ${JSON.stringify(e.getHeaders())}`}logResponse(e,r,t){const s=(0,request_1.getRequestId)(e.req);if("string"==typeof t)return`HTTP ${this.service} response ${s} ${r}: ${t}`;let o="";if(null==t)o=`${t}`;else if(t.length<50)o=`0x${t.toString("hex")} [length: ${t.length}]`;else o=`0x${t.subarray(0,50).toString("hex")}...[${t.length-50} more bytes, length: ${t.length}]`;return`HTTP ${this.service} response ${s} ${r}: ${o}`}}function requestLoggerMiddleware(e){let r=0;return(t,s,o)=>{r+=1,(0,request_1.setRequestId)(t,r);const n=Date.now(),i={cfRay:t.headers["cf-ray"],userAgent:t.headers["user-agent"]};return e.info(`HTTP request  ${r} ${t.method} ${t.originalUrl} ${JSON.stringify(i)}`),t.on("end",()=>e.info(`HTTP response ${r} ${s.statusCode} ${t.method} ${t.originalUrl} ${Date.now()-n}ms`)),o()}}function bodyLoggerMiddleware(e){const r=new HttpDebug(""),t=new HttpVerbose("");return(s,o,n)=>{if(!e.isActive("verbose"))return n();if(e.isActive("debug"))e.debug(()=>r.logRequestHeaders(s)),e.debug(()=>r.logRequestBody(s));else e.verbose(()=>t.logRequestBody(s));const i=o.write;o.write=(...s)=>{if(e.isActive("debug"))e.debug(()=>r.logResponse(o,"chunk",s[0]));else e.verbose(()=>t.logResponse(o,"chunk",s[0]));return i.apply(o,s)};const g=o.end;return o.end=(...s)=>{if(e.isActive("debug"))e.debug(()=>r.logResponse(o,"end",s[0])),e.debug(()=>r.logResponseHeaders(o));else e.verbose(()=>t.logResponse(o,"end",s[0]));return g.apply(o,s)},n()}}exports.requestLoggerMiddleware=requestLoggerMiddleware,exports.bodyLoggerMiddleware=bodyLoggerMiddleware;
//# sourceMappingURL=logger-middleware.js.map