import { Logger } from '@sage/xtrem-log';
import { Handler } from 'express';
/**
 * The compression middleware must be disabled in verbose and debug levels
 * because we need the response body in clear text.
 *
 * @returns whether the compression middleware should be loaded or not.
 */
export declare function loggerAllowsCompress(logger: Logger): boolean;
/**
 * The request logger middleware.
 * This middleware should be loaded first, so that we log all requests,
 * even those which may contain invalid JSON
 */
export declare function requestLoggerMiddleware(logger: Logger): Handler;
/**
 * The body logger middleware.
 * This middleware must be loaded after the middleware which parses the JSON body
 */
export declare function bodyLoggerMiddleware(logger: Logger): Handler;
//# sourceMappingURL=logger-middleware.d.ts.map