import { GraphQLType } from 'graphql';
import { Application } from '../../application/application';
/**
 * @disabled_internal
 *
 * Static class to cache GraphQL types so that we don't generate two copies of the same type.
 */
export declare class TypeCache {
    readonly application: Application;
    /**
     * typesCache is a dictionary such as:
     *        - each key is the name of a GraphQl type
     *        - each value is an actual GraphQl type.
     */
    private readonly typesCache;
    constructor(application: Application);
    /**
     * Adds a type named `name` in the `this.typesCache` cache as the result of executing `body`, only if the type has not been added yet.
     * Interning is a method of storing only one copy of each distinct string value (see https://en.wikipedia.org/wiki/String_interning)
     * @param name The name of the type to be defined
     * @param body The function that will be executed to define the new type
     */
    internType<T extends GraphQLType | undefined>(name: string, body: () => T): T;
    getCached<T extends GraphQLType | undefined>(name: string): T;
    /** @disabled_internal */
    addCacheEntry<T extends GraphQLType | undefined>(name: string, body: () => T): void;
}
//# sourceMappingURL=type-cache.d.ts.map