/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.PropertyType=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_shared_1=require("@sage/xtrem-shared"),graphql_1=require("graphql"),lodash_1=require("lodash"),properties_1=require("../../properties"),runtime_1=require("../../runtime"),loggers_1=require("../../runtime/loggers"),types_1=require("../../types"),aggregate_query_1=require("../aggregates/aggregate-query"),aggregate_read_1=require("../aggregates/aggregate-read"),collection_query_1=require("../queries/collection-query"),array_type_1=require("./array-type"),basic_types_1=require("./basic-types"),enum_type_1=require("./enum-type"),node_type_1=require("./node-type"),object_type_1=require("./object-type"),operation_type_1=require("./operation-type"),logger=loggers_1.loggers.graphQl;class PropertyType{static async getInputValue(e,r,t,a,n){let s=n?.type||a.type;if(null==r){if(void 0===r)return;switch(s){case"string":return"";case"stringArray":return[];case"textStream":return new types_1.TextStream("");default:return r}}const getArrayInputType=n=>{if(s=n,Array.isArray(r))return(0,xtrem_async_helper_1.asyncArray)(r).map(r=>PropertyType.getInputValue(e,r,t,a,{type:n})).toArray();return PropertyType.getInputValue(e,r,t,a,{type:n})};try{switch(s){case"boolean":return"boolean"==typeof r?!!r:"true"===r;case"enumArray":return await getArrayInputType("enum");case"enum":case"string":return"string"==typeof r?r:r.toString();case"integerArray":return await getArrayInputType("integer");case"stringArray":return await getArrayInputType("string");case"short":case"integer":if("_id"===a.name&&"string"==typeof r&&"#"===r[0])return(await e.read(t.nodeConstructor,{_id:r}))._id;return"number"==typeof r?r:(0,types_1.safeParseInt)(r,a.name);case"float":case"double":return"number"==typeof r?r:parseFloat(r);case"decimal":return xtrem_decimal_1.Decimal.isDecimal(r)?r:xtrem_decimal_1.Decimal.make(r);case"date":return xtrem_date_time_1.DateValue.isDate(r)?r:xtrem_date_time_1.DateValue.parse(r.substring(0,10),e.currentLocale);case"datetime":return xtrem_date_time_1.Datetime.isDatetime(r)?r:xtrem_date_time_1.Datetime.parse(r,e.currentLocale);case"time":return xtrem_date_time_1.Time.isTime(r)?r:xtrem_date_time_1.Time.parse(r.substring(0,8),e.currentLocale);case"integerRange":return xtrem_date_time_1.IntegerRange.isIntegerRange(r)?r:xtrem_date_time_1.IntegerRange.parse(r);case"decimalRange":return xtrem_date_time_1.DecimalRange.isDecimalRange(r)?r:xtrem_date_time_1.DecimalRange.parse(r);case"dateRange":return xtrem_date_time_1.DateRange.isDateRange(r)?r:xtrem_date_time_1.DateRange.parse(r);case"datetimeRange":return xtrem_date_time_1.DatetimeRange.isDatetimeRange(r)?r:xtrem_date_time_1.DatetimeRange.parse(r);case"textStream":return types_1.TextStream.fromString(r.value);case"binaryStream":return types_1.BinaryStream.fromBuffer(Buffer.from(r.value,"base64"));case"uuid":return types_1.Uuid.fromString(r);case"instance":{const t=a.targetFactory;if(!t)throw new Error(`${a.name}: missing class`);return await node_type_1.NodeType.nodeIn(e,r,t,{isTransientInput:a.isTransientInput})}case"referenceArray":return await getArrayInputType("reference");case"reference":return await PropertyType.getReferenceInputValue(e,r,a);case"object":{const t=a.targetFactory;if(!t)throw new Error(`${a.name}: missing class`);return await object_type_1.ObjectType.getObjectInputValue(e,"string"==typeof r?JSON.parse(r):r,t)}case"collection":return await PropertyType.getCollectionInputValue(e,r,a);case"array":case"json":case"jsonReference":return r;default:throw new Error(`${t.name}.${a.name}: invalid property type: ${a.type}`)}}catch(e){throw logger.debug(()=>e.stack),new xtrem_shared_1.DataInputError(e.message,e)}}static getCollectionInputValue(e,r,t){const a=t.targetFactory;if(!Array.isArray(r))throw new Error(`${t.name}: collection value is not an array`);if(!r.every(e=>"object"==typeof e))throw new Error(`${t.name}: collection invalid value`);return(0,xtrem_async_helper_1.asyncArray)(r).map(async r=>await object_type_1.ObjectType.getObjectInputValue(e,r,a)).toArray()}static getReferenceInputValue(e,r,t){const a=t.targetFactory;if(!a)throw new Error(`${t.name}: getInputValue reference: no REFERENCE`);if(!(a instanceof runtime_1.NodeFactory))throw new Error(`${t.name}: target factory is not a node factory`);if(null==r)return null;switch(typeof r){case"number":if("external"!==a.storage&&r>=0)return e.read(a.nodeConstructor,{_id:r},{forUpdate:t.isWritable});return r||null;case"string":if(r.startsWith("#"))return e.read(a.nodeConstructor,{_id:r},{forUpdate:t.isWritable});if(r.startsWith("_id:")){const n="external"===a.storage?r.substring(4):Number(r.substring(4));if(null==n||""===n||"external"!==a.storage&&!Number.isFinite(n))return null;if(Number(n)<0)return n;return e.read(a.nodeConstructor,{_id:n},{forUpdate:t.isWritable})}if("external"===a.storage)return r??null;return this.getReferenceInputValue(e,Number(r),t);case"object":if(null==r)return null;return object_type_1.ObjectType.getObjectInputValue(e,r,t.targetFactory);default:return r??null}}static getOutputValue(e,r,t,a){let n=a?.type||t.type;if(Array.isArray(r)&&"json"!==n){switch(n){case"integerArray":n="integer";break;case"enumArray":n="enum";break;case"referenceArray":n="reference";break;case"stringArray":n="string";break;default:loggers_1.loggers.graphQl.error(`${e.fullName}.${t.name}: UNEXPECTED ARRAY VALUE: ${r}`)}return r.map(r=>PropertyType.getOutputValue(e,r,t,{type:n}))}switch(n){case"date":case"dateRange":case"datetimeRange":case"time":case"datetime":case"uuid":return r?r.toString():null;case"decimal":return null==r?null:r.toString();default:return r}}static makePropertyGraphQLEnumType(e,r,t,a){const n=t.dataType;if(!n)return logger.warn(`${r&&r.fullName}.${t.name}: invalid property meta: enum member missing`),graphql_1.GraphQLString;const s=node_type_1.NodeType.isInput(a);return enum_type_1.EnumType.makeGraphQLEnumType(e,n,s)}static makeGraphQLEnumType(e,r,t){const a=`${(0,xtrem_shared_1.schemaTypeName)(r.enumFullName())}${t?"_EnumInput":""}`;return e.internType(a,()=>t?(0,basic_types_1.makeCustomEnumInputType)(a,r):(0,basic_types_1.makeCustomEnumOutputType)(a,r))}static makeSimplePropertyGraphQLType(e,r,t,a){if("_id"===t.name)return basic_types_1.idInputType;const n=node_type_1.NodeType.isInput(a);switch(t.type){case"string":case"time":case"uuid":return graphql_1.GraphQLString;case"short":case"integer":return n?basic_types_1.integerInputType:graphql_1.GraphQLInt;case"enum":return PropertyType.makePropertyGraphQLEnumType(e,r,t,a);case"integerRange":return basic_types_1.integerRangeType;case"decimalRange":return basic_types_1.decimalRangeType;case"decimal":return basic_types_1.decimalType;case"float":case"double":return n?basic_types_1.floatInputType:graphql_1.GraphQLFloat;case"boolean":return graphql_1.GraphQLBoolean;case"date":return basic_types_1.dateType;case"dateRange":return basic_types_1.dateRangeType;case"datetimeRange":return basic_types_1.datetimeRangeType;case"datetime":return basic_types_1.datetimeType;case"binaryStream":return n?basic_types_1.streamInputType:basic_types_1.binaryStreamOutputType;case"textStream":return n?basic_types_1.streamInputType:basic_types_1.textStreamOutputType;case"json":return basic_types_1.jsonType;case"integerArray":return n?new graphql_1.GraphQLList(basic_types_1.integerInputType):new graphql_1.GraphQLList(graphql_1.GraphQLInt);case"enumArray":return new graphql_1.GraphQLList(PropertyType.makePropertyGraphQLEnumType(e,r,t,a));case"stringArray":return new graphql_1.GraphQLList(graphql_1.GraphQLString);default:throw new xtrem_shared_1.LogicError(`${r.name}.${t.name}: unsupported GraphQL type: ${t.type}`)}}static makePropertyInputType(e,r,t,a,n){switch(t.type){case"collection":{const r=node_type_1.NodeType.makeInputType(e,a,n);return new graphql_1.GraphQLList(r)}case"instance":return node_type_1.NodeType.makeInputType(e,a,n);case"reference":if(t.isMutable||t.isVitalParentInput)return node_type_1.NodeType.makeInputType(e,a,n);if("external"===a.storage)return basic_types_1.externalReferenceInputType;return basic_types_1.referenceInputType;case"referenceArray":return new graphql_1.GraphQLList(basic_types_1.referenceInputType);default:throw new xtrem_shared_1.LogicError(`${a.fullName}.${t.name}: invalid type: ${t.type}`)}}static getCollectionFields(e,r,t){return{query:collection_query_1.CollectionQuery.makeResolver(e,r,t),readAggregate:aggregate_read_1.AggregateRead.makeResolver(e,r),queryAggregate:aggregate_query_1.AggregateQuery.makeResolver(e,r)}}static collectionPropertyType(e,r){const t=node_type_1.NodeType.makeOutputType(e,r,"nodeOutput"),a=`${(0,xtrem_shared_1.schemaTypeName)(r.fullName)}_Collection`,n=PropertyType.getCollectionFields(e,r,t);if(r.queries.filter(e=>e.isPublished).forEach(t=>{const a=(0,lodash_1.camelCase)(t.name);if(a.startsWith("_")||n[a])throw new Error(`${r.fullName}.${a}: query names conflicts with system query`);n[a]=operation_type_1.OperationType.makeResolver(e,r,t,false)}),0===Object.keys(n).length)return;return e.internType(a,()=>new graphql_1.GraphQLObjectType({name:a,fields:n}))}static makePropertyOutputType(e,r,t,a){if("collection"===r.type){const r=PropertyType.collectionPropertyType(e,t);if(r)return r}if("referenceArray"===r.type)return new graphql_1.GraphQLList(node_type_1.NodeType.makeOutputType(e,t,a));return node_type_1.NodeType.makeOutputType(e,t,a)}static makePropertyType(e,r,t,a){const n=node_type_1.NodeType.isInput(a);if(properties_1.foreignNodePropertyTypes.includes(t.type)){const s=t.targetFactory;if(!s)throw new Error(`${r.fullName}.${t.name}: no target factory`);if("sql"!==s.storage&&"external"!==s.storage&&"collection"===t.type&&!t.getValue&&!t.computeValue)return logger.error(`${r.fullName}.${t.name}: COLLECTION TARGETCLASS not persistent!!!`),graphql_1.GraphQLString;if(n)return PropertyType.makePropertyInputType(e,r,t,s,a);return this.makePropertyOutputType(e,t,s,a)}if("object"===t.type||"array"===t.type){if("object"===t.type)return object_type_1.ObjectType.makeObjectType(e,r,t,a);return array_type_1.ArrayType.makeArrayType(e,r,t,a)}return this.makeSimplePropertyGraphQLType(e,r,t,a)}}exports.PropertyType=PropertyType;
//# sourceMappingURL=property-type.js.map