/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.AccessRights=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_shared_1=require("@sage/xtrem-shared"),_=require("lodash"),concurrency_utils_1=require("../../concurrency-utils"),custom_metrics_1=require("../../metrics/prometheus/custom-metrics"),runtime_1=require("../../runtime"),loggers_1=require("../../runtime/loggers"),logger=loggers_1.loggers.authorization,loggerGraphQl=loggers_1.loggers.graphQl;class AccessRights{static runSecure(e,t,r,a){return logger.debug(()=>`runSecure -> operation: ${t}`),custom_metrics_1.CustomMetrics.graphql.withMetrics({nodeName:r.factory.name,operationName:t,operationKind:r.isMutation?"mutation":"query"},()=>(0,concurrency_utils_1.runResolver)(e,async()=>{if(r.isMutation)AccessRights.checkNotReadonly();if(await AccessRights.checkOperationAccessRight(e,{nodeName:r.factory.name,operationName:r.operation||t,isPropertyAccess:!!r.isPropertyAccess,isMutation:!!r.isMutation}),e.timeLimitAsTimestamp<=Date.now())throw new xtrem_shared_1.TimeoutError("Request Timeout");try{return await a()}catch(t){throw AccessRights.logInputData(e,r),t}}))}static isPackageAvailable(e,t){return xtrem_config_1.ConfigManager.current.storage?.managedExternal||"all"===t[0]||t.includes(e.name)}static checkNotReadonly(){if(xtrem_config_1.ConfigManager.current.graphql.isReadonly)throw new xtrem_shared_1.AuthorizationError("Mutations are not allowed. Endpoint is readonly")}static async isOperationAvailable(e,t){const{operationName:r,nodeName:a}=t,i=e.isServiceOptionEnabled.bind(e),o=e.application.getFactoryByName(a);if(o.serviceOptions&&!await(0,xtrem_async_helper_1.asyncArray)(o.serviceOptions).every(i))return false;if(t.isMutation){const e=o.mutations.find(e=>e.name===r);return(0,xtrem_async_helper_1.asyncArray)(e?.serviceOptions?.()||[]).every(i)}const s=o.queries.find(e=>e.name===r);return(0,xtrem_async_helper_1.asyncArray)(s?.serviceOptions?.()||[]).every(i)}static async checkOperationAccessRight(e,t){if(t.isPropertyAccess)return;const{nodeName:r,operationName:a}=t;if(!await AccessRights.isOperationAvailable(e,{operationName:t.operationName,nodeName:t.nodeName,isMutation:!!t.isMutation,isPropertyAccess:t.isPropertyAccess}))throw await logger.infoAsync(()=>`Operation ${r}.${a}' is not enabled by the current configuration of the application`),new xtrem_shared_1.AuthorizationError(e.localize("@sage/xtrem-core/operation-not-enabled","Operation {{nodeName}}.{{operationName}} is not enabled by the configuration of the application",{nodeName:r,operationName:a}));let i=await runtime_1.Context.accessRightsManager.getUserAccessFor(e,r,a);if(!i||"authorized"!==i.status){const t=e.application.getFactoryByName(r);if(!runtime_1.standardOperations.some(e=>e===a)){const o=t.queries.find(e=>e.name===a);if(o&&o.isGrantedByLookup)i=await runtime_1.Context.accessRightsManager.getUserAccessFor(e,r,"lookup")}if("read"===a&&!t.denyReadOnLookupOnlyAccess&&t.hasLookupAccess)i=await runtime_1.Context.accessRightsManager.getUserAccessFor(e,r,"lookup")}if(await e.user&&(!i||"authorized"!==i.status))throw new xtrem_shared_1.AuthorizationError(e.localize("@sage/xtrem-core/user-not-allowed-operation","You cannot perform this operation {{nodeName}}.{{operation}}",{nodeName:r,operation:a}));e.setAllowedAccessCodes(i)}static logInputData(e,t){if(t.args&&e.request)loggerGraphQl.error(`input data: ${JSON.stringify(t.args,(e,t)=>{if("filter"===e&&"string"==typeof t&&t.startsWith("{")&&t.endsWith("}"))return(0,runtime_1.friendlyJsonParse)(t);if(!_.isObject(t))return"***";return t})}`)}}exports.AccessRights=AccessRights;
//# sourceMappingURL=access-rights.js.map