/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SchemaBuilder=void 0;const graphql_1=require("graphql"),lodash_1=require("lodash"),loggers_1=require("../runtime/loggers"),types_1=require("../types"),node_mutations_1=require("./mutations/node-mutations"),node_queries_1=require("./queries/node-queries"),access_rights_1=require("./security/access-rights"),enum_type_1=require("./types/enum-type"),type_cache_1=require("./utils/type-cache"),logger=loggers_1.loggers.graphQl;class SchemaBuilder{static createQueries(e,t,a){if(!access_rights_1.AccessRights.isPackageAvailable(a,t.tenantPackages))return{};return a.factories.filter(e=>e.nodeDecorator.isPublished).reduce((t,a)=>{const r=node_queries_1.NodeQueries.makeResolver(e,a);if(r)t[(0,lodash_1.camelCase)(a.name)]=r;return t},{})}static createMutations(e,t,a){if(!access_rights_1.AccessRights.isPackageAvailable(a,t.tenantPackages))return{};return a.factories.filter(e=>e.isPublished).reduce((t,a)=>{const r=node_mutations_1.NodeMutations.makeResolver(e,a);if(r)t[(0,lodash_1.camelCase)(a.name)]=r;return t},{})}static createTypes(e,t){const a=[];return Object.values(e.dataTypes).filter(e=>e instanceof types_1.EnumDataType).forEach(e=>{const r=e,s=enum_type_1.EnumType.getTypeName(r,false),i=enum_type_1.EnumType.getTypeName(r,true);if(void 0===t.getCached(s))a.push(enum_type_1.EnumType.makeGraphQLEnumType(t,r,false));if(void 0===t.getCached(i))a.push(enum_type_1.EnumType.makeGraphQLEnumType(t,r,true))}),a}static getNamespace(e,t,a){const r={},s={},i=e.resolvePnpmLock().version||"",c=e.getPackages().filter(e=>e.factories.some(e=>!!e.isPublished)).reduce((e,t)=>{const i=a(t);if(0===Object.keys(i).length)return e;const c=t.name.split("/"),n=c[0].startsWith("@")?c.shift():"",checkSegment=e=>{if("@sage"!==n&&e?.startsWith("xtrem-"))throw new Error("'xtrem' prefix is reserved!")};let o=e;for(;c.length>1;){const e=c.shift();checkSegment(e);const t=(0,lodash_1.camelCase)(e);if(!o[t])o[t]={name:t,fields:{},marker:r};o=o[t].fields}const u=c.shift();checkSegment(u);const p=(0,lodash_1.camelCase)(u);return o[p]=i,s[p]=`Package Version : ${t.packageJson.version}`,e},{}),wrapFields=e=>{if(e.marker!==r)return e;return Object.keys(e.fields).reduce((a,r)=>(a[r]={type:new graphql_1.GraphQLObjectType({name:r+t,fields:wrapFields(e.fields[r])}),description:s[r]||`Application Version : ${i}`,resolve:()=>({})},a),{})};return wrapFields({fields:c,marker:r})}static async getSchema(e,t){logger.info(()=>`Creating GraphQL schema for application ${e.name}`);const a=t?await t.getActivePackageNames():["all"];logger.verbose(()=>`GraphQL active packages: ${a.join()}`),this.typeCache=new type_cache_1.TypeCache(e);const r=loggers_1.loggers.graphQl.verbose(()=>`Create schema ${e.name}`),s=SchemaBuilder.getNamespace(e,"Query",e=>SchemaBuilder.createQueries(this.typeCache,{tenantPackages:a},e)),i=SchemaBuilder.getNamespace(e,"Mutation",e=>SchemaBuilder.createMutations(this.typeCache,{tenantPackages:a},e));if((0,lodash_1.isEmpty)(s)&&(0,lodash_1.isEmpty)(i))throw new Error("Cannot create an empty Graphql schema: you are missing both queries and mutations!");const c=SchemaBuilder.createTypes(e,this.typeCache),n=new graphql_1.GraphQLSchema({query:new graphql_1.GraphQLObjectType({name:"RootQueryType",fields:s}),...!(0,lodash_1.isEmpty)(i)&&{mutation:new graphql_1.GraphQLObjectType({name:"MutationsType",fields:i})},types:c,directives:[graphql_1.GraphQLDeferDirective,graphql_1.GraphQLStreamDirective,graphql_1.GraphQLSkipDirective,graphql_1.GraphQLIncludeDirective],enableDeferStream:true});return r.success(),n}}exports.SchemaBuilder=SchemaBuilder;
//# sourceMappingURL=schema-builder.js.map