import { AggregateGroups, AggregateValues, Node, QueryAggregateReturn } from '../../ts-api';
export interface QueryPageInfo {
    endCursor?: string;
    hasNextPage: boolean;
    startCursor?: string;
    hasPreviousPage?: boolean;
    totalCount?: number;
}
export interface QueryEdge<T = any> {
    node: T;
    cursor: string;
}
export interface QueryNode<T = any> {
    query: QueryPage<T>;
}
export interface QueryPage<T = any> {
    totalCount?: number;
    edges?: QueryEdge<T>[];
    pageInfo?: QueryPageInfo;
}
export interface QueryAggregateNode<T extends Node> {
    queryAggregate: QueryAggregatePage<T>;
}
export interface QueryAggregatePage<T extends Node> {
    totalCount?: number;
    edges?: QueryAggregateEdge<T>[];
    pageInfo?: QueryPageInfo;
}
export interface QueryAggregateEdge<T extends Node> {
    node: QueryAggregateReturn<T, AggregateGroups<T>, AggregateValues<T>>;
    cursor: string;
}
//# sourceMappingURL=paging.d.ts.map