/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getSitemapSchemaFragment=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_i18n_1=require("@sage/xtrem-i18n"),graphql_1=require("graphql"),concurrency_utils_1=require("../../concurrency-utils"),metrics_1=require("../../metrics"),loggers_1=require("../../runtime/loggers"),client_service_1=require("../../system/pages/client-service"),logger=loggers_1.loggers.application,sitemapEntryType=new graphql_1.GraphQLObjectType({name:"_SitemapEntry",fields:()=>({id:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString},icon:{type:graphql_1.GraphQLString},isPage:{type:graphql_1.GraphQLBoolean},priority:{type:graphql_1.GraphQLInt},children:{type:sitemapEntryListType}})}),sitemapEntryListType=new graphql_1.GraphQLList(sitemapEntryType),resolveSitemapElements=async(e,t,r,i)=>{if(0===t.length)return t;let a=(0,xtrem_async_helper_1.asyncArray)(t).filter(e=>{const t=0===r.length||r.includes(e?.packageName);if(!t)logger.debug(()=>`resolveSitemapElements don't keep element title:${e.title} packageName:${e.packageName}`);return t}).filter(async t=>{if(t.isPage){const r=await client_service_1.ClientService.userHasAccessToPage(e,t.id);if(!r)logger.debug(()=>`resolveSitemapElements don't keep element ${t.title||t.id}`);return r}return true});if(await a.length>0)return a=a.map(async t=>{const a={...t};a.children=await resolveSitemapElements(e,a.children||[],r,i);const n=a.isPage?(0,xtrem_i18n_1.artifactReferenceToTitleStringKey)(a.id,"pages"):(0,xtrem_i18n_1.menuItemIdToStringKey)(a.id);return a.title=(0,xtrem_i18n_1.getLiteral)(n,i).content,a}),a.filter(e=>{const t=e.isPage||e.children&&e.children.length>0;if(!t)logger.debug(()=>`resolveSitemapElements don't keep element ${e.title} isPage:${e.isPage} children:${e.children?e.children.length:0}`);return!!t}).toArray();return[]},resolveSitemap=(e,t,r)=>metrics_1.CustomMetrics.metadata.withMetrics({nodeName:"sitemap",operationName:"read",operationKind:"query"},()=>(0,concurrency_utils_1.runResolver)(r,async()=>{const e=(0,xtrem_i18n_1.getLocaleFromHeader)(r.request.headers),t=await r.getActivePackageNames();return logger.debug(()=>`resolveSitemap(activePackages:${t})`),resolveSitemapElements(r,await client_service_1.ClientService.getSitemapTree(r),t,e)})),getSitemapSchemaFragment=()=>({queries:{sitemap:{type:sitemapEntryListType,resolve:resolveSitemap}}});exports.getSitemapSchemaFragment=getSitemapSchemaFragment;
//# sourceMappingURL=sitemap-fragment.js.map