/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getNodeDetailsSchemaFragment=exports.resolveNodeCustomDetailsList=exports.resolveNodeDetailsList=exports.resolveNodeCustomDetails=exports.resolveNodeDetails=exports.nodeCustomDetailsListType=exports.nodeCustomDetailsType=exports.nodeDetailsListArgs=exports.nodeDetailsListType=exports.nodeDetailsFilter=exports.nodeDetailsType=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),graphql_1=require("graphql"),_=require("lodash"),concurrency_utils_1=require("../../concurrency-utils"),metrics_1=require("../../metrics"),core_hooks_1=require("../../runtime/core-hooks"),reference_data_type_1=require("../../types/reference-data-type"),data_type_fragment_1=require("./data-type-fragment"),metadata_schema_utils_1=require("./metadata-schema-utils"),node_names_fragment_1=require("./node-names-fragment"),node_operations_1=require("./node-operations"),nodeDetailsPropertyType=new graphql_1.GraphQLObjectType({name:"_NodeDetailsProperty",fields:()=>({name:{type:graphql_1.GraphQLString},enumType:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString},canSort:{type:graphql_1.GraphQLBoolean},canFilter:{type:graphql_1.GraphQLBoolean},type:{type:graphql_1.GraphQLString},isCustom:{type:graphql_1.GraphQLBoolean},dataType:{type:graphql_1.GraphQLString},dataTypeDetails:{type:data_type_fragment_1.dataTypeGQType,resolve:(e,t,a)=>(0,data_type_fragment_1.resolveDataTypes)(a,[e.dataType])?.[0]},targetNode:{type:graphql_1.GraphQLString},targetNodeDetails:{type:exports.nodeDetailsType,resolve:(e,t,a)=>{const r=e.targetNode?.split("/"),s=r?.[2];if(s)return(0,exports.resolveNodeDetails)(a,s);return null}},isStored:{type:graphql_1.GraphQLBoolean},isOnInputType:{type:graphql_1.GraphQLBoolean},isOnOutputType:{type:graphql_1.GraphQLBoolean},isMutable:{type:graphql_1.GraphQLBoolean},isSystemProperty:{type:graphql_1.GraphQLBoolean}})}),nodeDetailOperationParameterType=new graphql_1.GraphQLObjectType({name:"_NodeDetailsOperationParameter",fields:{name:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString}}}),nodeDetailsOperationType=new graphql_1.GraphQLObjectType({name:"_NodeDetailsOperation",fields:{name:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString},parameters:{type:new graphql_1.GraphQLList(nodeDetailOperationParameterType)}}});exports.nodeDetailsType=new graphql_1.GraphQLObjectType({name:"_NodeDetails",fields:()=>({packageName:{type:graphql_1.GraphQLString},...node_names_fragment_1.nodeDetailsFields,hasAttachments:{type:graphql_1.GraphQLBoolean},defaultDataType:{type:graphql_1.GraphQLString},defaultDataTypeDetails:{type:data_type_fragment_1.dataTypeGQType,resolve:(e,t,a)=>(0,data_type_fragment_1.resolveDataTypes)(a,[e.defaultDataType])?.[0]},properties:{type:new graphql_1.GraphQLList(nodeDetailsPropertyType)},mutations:{type:new graphql_1.GraphQLList(nodeDetailsOperationType)},queries:{type:new graphql_1.GraphQLList(nodeDetailsOperationType)}})}),exports.nodeDetailsFilter={nodeName:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},exports.nodeDetailsListType=new graphql_1.GraphQLList(exports.nodeDetailsType),exports.nodeDetailsListArgs={missingNodeNames:{type:new graphql_1.GraphQLList(new graphql_1.GraphQLNonNull(graphql_1.GraphQLString))},knownNodeNames:{type:new graphql_1.GraphQLList(new graphql_1.GraphQLNonNull(graphql_1.GraphQLString))},depth:{type:graphql_1.GraphQLInt}},exports.nodeCustomDetailsType=new graphql_1.GraphQLObjectType({name:"_NodeCustomDetails",fields:()=>({name:{type:graphql_1.GraphQLString},properties:{type:new graphql_1.GraphQLList(nodeDetailsPropertyType)}})}),exports.nodeCustomDetailsListType=new graphql_1.GraphQLList(exports.nodeCustomDetailsType);const getNodeDetailsOperation=(e,t,a,r=[])=>({name:a.name,title:node_operations_1.NodeOperations.getLocalizedTitle(e,t,a),parameters:a.parameters.filter(e=>!r.includes(e.name)).map(r=>({name:r.name,title:node_operations_1.NodeOperations.getLocalizedParameter(e,t,a,r)}))}),resolveNodeDetails=(e,t)=>{const a=e.application.factoriesManager.getFactoryByName(t),r=a.properties.filter(e=>e.isPublished&&"_sortValue"!==e.name).map(t=>{const a=t.isEnumProperty()||t.isEnumArrayProperty()?t.dataType.enumFullName():null,r=t.dataType??(t.isForeignNodeProperty()?reference_data_type_1.ReferenceDataType.getNodeDefaultDataType(e.application,t.targetFactory):null),s=t.isReferenceProperty()?!!t.isMutable||!!t.isVitalParentInput:!!t.isMutable;return{name:t.name,title:t.getLocalizedTitle(e),canSort:t.canSort,canFilter:t.canFilter,enumType:a,type:t.type,isCustom:false,dataType:r?.name||"",dataTypeDetails:r?r.getMetaData({application:e.application,localize:(t,a)=>e.localize(t,a),context:e}):null,targetNode:t.isForeignNodeProperty()?t.targetFactory.fullName:"",targetNodeDetails:null,isStored:t.isStored,isOnInputType:t.isOnInputType,isOnOutputType:t.isOnOutputType,isMutable:s,isSystemProperty:t.isSystemProperty}}),s=a.mutations.filter(e=>e.isPublished&&("mutation"===e.operationKind||"asyncMutation"===e.operationKind)).map(t=>getNodeDetailsOperation(e,a,t,["trackingId","reason"])),o=a.queries.filter(e=>e.isPublished&&"query"===e.operationKind).map(t=>getNodeDetailsOperation(e,a,t)),p=reference_data_type_1.ReferenceDataType.getNodeDefaultDataType(e.application,a);return{packageName:a.package.name,name:t,title:a.getLocalizedTitle(e),hasAttachments:a.hasAttachments,defaultDataType:p?.name||"",defaultDataTypeDetails:p?p.getMetaData({application:e.application,localize:(t,a)=>e.localize(t,a),context:e}):null,properties:r,mutations:s,queries:o}};exports.resolveNodeDetails=resolveNodeDetails;const resolveNodeCustomDetails=async(e,t)=>{const a=e.application.factoriesManager.getFactoryByName(t),r=[];if(a.isCustomizable){const t=await core_hooks_1.CoreHooks.customizationManager.getCustomFields(e,a.fullName?[a.fullName]:[]);if(t)Object.keys(t).forEach(e=>{t[e].forEach(e=>{r.push({name:e.name,title:e.title,canSort:true,canFilter:true,enumType:"",type:e.dataType,isCustom:true,dataType:"",dataTypeDetails:null,targetNode:"",targetNodeDetails:null,isStored:true,isOnInputType:true,isOnOutputType:true,isMutable:false,isSystemProperty:false})})})}return{name:t,properties:r}};exports.resolveNodeCustomDetails=resolveNodeCustomDetails;const resolveNodeDetailsList=(e,t)=>{const a=(0,metadata_schema_utils_1.expandNodeNames)(e.application,t.missingNodeNames,t.depth),r=_.difference(a,t.knownNodeNames);return(0,xtrem_async_helper_1.asyncArray)(r).map(t=>(0,exports.resolveNodeDetails)(e,t)).toArray()};exports.resolveNodeDetailsList=resolveNodeDetailsList;const resolveNodeCustomDetailsList=(e,t)=>{const a=(0,metadata_schema_utils_1.expandNodeNames)(e.application,t.missingNodeNames,t.depth),r=_.difference(a,t.knownNodeNames);return(0,xtrem_async_helper_1.asyncArray)(r).map(t=>(0,exports.resolveNodeCustomDetails)(e,t)).filter(e=>e.properties.length>0).toArray()};exports.resolveNodeCustomDetailsList=resolveNodeCustomDetailsList;const getNodeDetailsSchemaFragment=()=>({queries:{getNodeDetails:{type:exports.nodeDetailsType,args:exports.nodeDetailsFilter,resolve:(e,t,a)=>metrics_1.CustomMetrics.metadata.withMetrics({nodeName:"getNodeDetails",operationName:"read",operationKind:"query"},()=>(0,concurrency_utils_1.runResolver)(a,()=>(0,exports.resolveNodeDetails)(a,t.nodeName)))},getNodeCustomDetails:{type:exports.nodeCustomDetailsType,args:exports.nodeDetailsFilter,resolve:(e,t,a)=>metrics_1.CustomMetrics.metadata.withMetrics({nodeName:"getNodeCustomDetails",operationName:"read",operationKind:"query"},()=>(0,concurrency_utils_1.runResolver)(a,()=>(0,exports.resolveNodeCustomDetails)(a,t.nodeName)))},getNodeDetailsList:{type:exports.nodeDetailsListType,args:exports.nodeDetailsListArgs,resolve:(e,t,a)=>metrics_1.CustomMetrics.metadata.withMetrics({nodeName:"getNodeDetailsList",operationName:"read",operationKind:"query"},()=>(0,concurrency_utils_1.runResolver)(a,()=>(0,exports.resolveNodeDetailsList)(a,t)))},getNodeCustomDetailsList:{type:exports.nodeCustomDetailsListType,args:exports.nodeDetailsListArgs,resolve:(e,t,a)=>metrics_1.CustomMetrics.metadata.withMetrics({nodeName:"getNodeCustomDetailsList",operationName:"read",operationKind:"query"},()=>(0,concurrency_utils_1.runResolver)(a,()=>(0,exports.resolveNodeCustomDetailsList)(a,t)))}}});exports.getNodeDetailsSchemaFragment=getNodeDetailsSchemaFragment;
//# sourceMappingURL=node-details-fragment.js.map