/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.expandNodeNames=exports.resolveArtifact=exports.pagesArgsWithFilter=exports.artifactArgsWithFilter=exports.getArtifactDescriptionConfig=exports.getArtifactTitleConfig=exports.getArtifactStringsConfig=exports.localizationsType=exports.accessListType=exports.pluginsType=exports.fragmentsType=exports.extensionsType=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_i18n_1=require("@sage/xtrem-i18n"),graphql_1=require("graphql"),lodash_1=require("lodash"),concurrency_utils_1=require("../../concurrency-utils"),metrics_1=require("../../metrics"),core_hooks_1=require("../../runtime/core-hooks"),artifact_manager_1=require("../../system/artifact-manager"),client_service_1=require("../../system/pages/client-service");exports.extensionsType=new graphql_1.GraphQLList(graphql_1.GraphQLString),exports.fragmentsType=new graphql_1.GraphQLList(new graphql_1.GraphQLObjectType({name:"_PageFragment",fields:{name:{type:graphql_1.GraphQLString},content:{type:graphql_1.GraphQLString}}})),exports.pluginsType=new graphql_1.GraphQLList(graphql_1.GraphQLString);const accessStatusType=new graphql_1.GraphQLObjectType({name:"_AccessStatus",fields:{name:{type:graphql_1.GraphQLString},status:{type:graphql_1.GraphQLString}}}),bindingsType=new graphql_1.GraphQLList(accessStatusType),accessType=new graphql_1.GraphQLObjectType({name:"_Access",fields:{node:{type:graphql_1.GraphQLString},bindings:{type:bindingsType}}});exports.accessListType=new graphql_1.GraphQLList(accessType);const localizationType=new graphql_1.GraphQLObjectType({name:"_Strings",fields:{key:{type:graphql_1.GraphQLString},content:{type:graphql_1.GraphQLString}}});exports.localizationsType=new graphql_1.GraphQLList(localizationType);const getArtifactStringsConfig=e=>({type:exports.localizationsType,resolve:(t,r,a)=>(0,concurrency_utils_1.runResolver)(a,()=>artifact_manager_1.ArtifactManager.resolveArtifactStrings(a,e,t))});exports.getArtifactStringsConfig=getArtifactStringsConfig;const getArtifactTitleConfig=e=>({type:graphql_1.GraphQLString,resolve:(t,r,a)=>(0,concurrency_utils_1.runResolver)(a,()=>artifact_manager_1.ArtifactManager.getArtifactTitle(a,e,t))});exports.getArtifactTitleConfig=getArtifactTitleConfig;const getArtifactDescriptionConfig=e=>({type:graphql_1.GraphQLString,resolve:(t,r,a)=>(0,concurrency_utils_1.runResolver)(a,()=>artifact_manager_1.ArtifactManager.getArtifactDescription(a,e,t))});exports.getArtifactDescriptionConfig=getArtifactDescriptionConfig,exports.artifactArgsWithFilter={filter:{type:new graphql_1.GraphQLInputObjectType({name:"_ArtifactFilter",fields:{packageOrPage:{type:graphql_1.GraphQLString},exactMatch:{type:graphql_1.GraphQLBoolean,defaultValue:false}}})}},exports.pagesArgsWithFilter={filter:{type:new graphql_1.GraphQLInputObjectType({name:"_PagesFilter",fields:{packageOrPage:{type:graphql_1.GraphQLString},exactMatch:{type:graphql_1.GraphQLBoolean,defaultValue:false},pageNode:{type:graphql_1.GraphQLString,defaultValue:""}}})}};const resolveArtifact=(e,t)=>(r,a,i)=>metrics_1.CustomMetrics.metadata.withMetrics({nodeName:t,operationName:"read",operationKind:"query"},()=>(0,concurrency_utils_1.runResolver)(i,async()=>{const r=(0,xtrem_i18n_1.getLocaleFromHeader)(i.request.headers);let s=[];if(a&&a.filter)if(a.filter.exactMatch){s=[await artifact_manager_1.ArtifactManager.readClientArtifact(i,t,a.filter)]}else s=await client_service_1.ClientService.searchClientArtifactsFromStorage(i,t,a.filter,r);else s=await artifact_manager_1.ArtifactManager.listAllClientArtifactsFromStorage(i,t);const n=await i.getActivePackageNames();return await(0,xtrem_async_helper_1.asyncArray)(s.filter(e=>0===n.length||n.includes(e?.packageName))).filter(async e=>{if(t!==client_service_1.ClientArtifactType.pages&&t!==client_service_1.ClientArtifactType.stickers)return true;return"authorized"===await client_service_1.ClientService.getPageAccess(i,e?.pageAccess,{authorizationCode:e?.authorizationCode})}).map(async r=>{const a={...r};if(t===client_service_1.ClientArtifactType.widgets&&a.key&&a.category){const t=await core_hooks_1.CoreHooks.createDashboardManager(e).getWidgetCategory(i,{_id:a.key,id:a.category});if(t)a.category=t.key,a.categoryLabel=t.title}return a}).toArray()}));exports.resolveArtifact=resolveArtifact;const expandNodeNames=(e,t,r)=>{const a={};return t.forEach(t=>expandNodeName(e,t,r||5,a)),Object.keys(a)};exports.expandNodeNames=expandNodeNames;const expandNodeName=(e,t,r,a)=>{if(!(0,lodash_1.isNil)(a[t])&&a[t]>=r)return;a[t]=r;e.getFactoryByName(t).properties.forEach(t=>{if(t.isForeignNodeProperty())if(r>1)expandNodeName(e,t.targetFactory.name,r-1,a)})};
//# sourceMappingURL=metadata-schema-utils.js.map