/// <reference types="@sage/xtrem-i18n" />
import { GraphQLFieldConfig, GraphQLFieldConfigArgumentMap, GraphQLFieldConfigMap, GraphQLList, GraphQLObjectType } from 'graphql';
import { Application } from '../../application/application';
import { Context } from '../../runtime';
import { ArtifactFilter } from '../../system/artifact-manager';
import { ApplicationArtifact, ClientArtifactType } from '../../system/pages/client-service';
export interface MetadataSchemaFragment {
    queries?: GraphQLFieldConfigMap<any, any>;
    mutations?: GraphQLFieldConfigMap<any, any>;
}
export declare const extensionsType: GraphQLList<import("graphql").GraphQLScalarType<string, string>>;
export declare const fragmentsType: GraphQLList<GraphQLObjectType<any, any>>;
export declare const pluginsType: GraphQLList<import("graphql").GraphQLScalarType<string, string>>;
export declare const accessListType: GraphQLList<GraphQLObjectType<any, any>>;
export declare const localizationsType: GraphQLList<GraphQLObjectType<any, any>>;
export declare const getArtifactStringsConfig: (artifactType: ClientArtifactType) => GraphQLFieldConfig<ApplicationArtifact, Context>;
export declare const getArtifactTitleConfig: (artifactType: ClientArtifactType) => GraphQLFieldConfig<ApplicationArtifact, Context>;
export declare const getArtifactDescriptionConfig: (artifactType: ClientArtifactType) => GraphQLFieldConfig<ApplicationArtifact, Context>;
export declare const artifactArgsWithFilter: GraphQLFieldConfigArgumentMap;
export declare const pagesArgsWithFilter: GraphQLFieldConfigArgumentMap;
export declare const resolveArtifact: (application: Application, artifactType: ClientArtifactType) => (_obj: unknown, args: {
    filter: ArtifactFilter;
}, context: Context) => Promise<{
    extensions?: string[] | undefined;
    plugins?: string[] | undefined;
    menuItem?: string | undefined;
    priority?: number | undefined;
    strings?: import("@sage/xtrem-i18n").LocalizedLiteral[] | undefined;
    className?: string | undefined;
    md5?: string | undefined;
    title?: string | undefined;
    authorizationCode?: string | undefined;
    pageAccess?: import("../..").AccessBinding | undefined;
    pageNode?: string | undefined;
    extensionAccess?: import("../..").AccessBinding | undefined;
    category?: string | undefined;
    group?: string | undefined;
    categoryLabel?: string | undefined;
    type?: string | undefined;
    extends?: string | undefined;
    fragments?: string[] | undefined;
    parentMenuItem?: string | undefined;
    listIcon?: string | undefined;
    description?: string | undefined;
    duplicateBindings?: string[] | undefined;
    literals?: import("@sage/xtrem-i18n").ClientArtifactUsedLiterals | undefined;
    nodes?: string[] | undefined;
    key?: string | undefined;
    packageName?: string | undefined;
    content?: import("../..").TextStream | undefined;
    artifactFilePath?: string | undefined;
}[]>;
export type SchemaFragmentFunction = (application: Application) => MetadataSchemaFragment;
export declare const expandNodeNames: (application: Application, nodeNames: string[], depth: number | null) => string[];
//# sourceMappingURL=metadata-schema-utils.d.ts.map