/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.graphQlMetadata=exports.getTenantId=exports.graphQlApp=exports.graphQlTimeLimitInSeconds=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_i18n_1=require("@sage/xtrem-i18n"),express=require("express"),express_graphql_1=require("express-graphql"),__1=require(".."),web_transaction_1=require("../metrics/newrelic/web-transaction"),runtime_1=require("../runtime"),security_1=require("../security"),test_1=require("../test"),metadata_schema_1=require("./metadata-schema"),request_1=require("./utils/request"),defaultGraphQlTimeLimitInSeconds=e=>e?.managedExternal?120:27.5,graphQlTimeLimitInSeconds=()=>xtrem_config_1.ConfigManager.current.graphql?.timeLimitInSeconds||defaultGraphQlTimeLimitInSeconds({managedExternal:!!xtrem_config_1.ConfigManager.current.storage?.managedExternal});function createExpressApp(){return express().disable("x-powered-by")}function setGraphQlTransactionName(e){(0,web_transaction_1.setWebTransactionName)(()=>(0,request_1.getGraphQlHint)(e))}async function checkTenantId(e,t){if(xtrem_config_1.ConfigManager.current.storage?.managedExternal)return true;if(!(await runtime_1.Context.tenantManager.listTenantsIds(e)).includes(e.tenantId??""))return security_1.logger.error(`${xtrem_config_1.ConfigManager.current.app}~${e.tenantId}: Tenant does not exist`),t.status(200).send({data:{},errors:[{extensions:{diagnoses:[{severity:__1.ValidationSeverity.error,message:`${xtrem_config_1.ConfigManager.current.app}: Tenant does not exist`}]}}]}),false;return true}function graphQlApp(e,t){const a=createExpressApp();return a.all("/*",(a,r)=>{setGraphQlTransactionName(a);const n=r.locals.config,s=(0,xtrem_i18n_1.getLocaleFromHeader)(a.headers),i=t?.graphqlTimeLimitInSeconds??(n.graphql?.timeLimitInSeconds||defaultGraphQlTimeLimitInSeconds({managedExternal:!!n.storage?.managedExternal})),o=Date.now()+1e3*i,executeRequest=async t=>{if(!await checkTenantId(t,r))return;const n=await e.getGraphQLSchema(t);await(0,express_graphql_1.graphqlHTTP)({schema:n,graphiql:false,context:t,extensions:()=>({diagnoses:t.diagnoses})})(a,r)};return e.requestFunnel(()=>e.withReadonlyContext(getTenantId(e,n),async e=>{const t=a.body?.isolationLevel;if(t&&"low"!==t)await e.withChildContext(executeRequest,{isReadonly:true,isolationLevel:t,isDeferrable:"high"===t});else await executeRequest(e)},{config:n,locale:s,request:a,response:r,source:"graphql",timeLimitAsTimestamp:o}))}),a}let metadataSchema;function getTenantId(e,t){if(t.tenantId)return t.tenantId;if("test"===e.applicationType)return test_1.Test.defaultTenantId;if(xtrem_config_1.ConfigManager.current.storage.managedExternal)return null;throw new Error("TenantId is not set - cannot execute graphQl Request")}function graphQlMetadata(e){const t=createExpressApp();return t.all("/*",(t,a)=>{setGraphQlTransactionName(t);const r=a.locals.config,n=(0,xtrem_i18n_1.getLocaleFromHeader)(t.headers);return e.requestFunnel(()=>e.withReadonlyContext(getTenantId(e,r),async r=>{if(!await checkTenantId(r,a))return;if(!metadataSchema)metadataSchema=(0,metadata_schema_1.createMetadataSchema)(e);await(0,express_graphql_1.graphqlHTTP)({schema:metadataSchema,graphiql:true,context:r,customFormatErrorFn:e=>(security_1.logger.error(e.stack||e.message),{message:e.message})})(t,a)},{config:r,locale:n,request:t,response:a}))}),t}exports.graphQlTimeLimitInSeconds=graphQlTimeLimitInSeconds,exports.graphQlApp=graphQlApp,exports.getTenantId=getTenantId,exports.graphQlMetadata=graphQlMetadata;
//# sourceMappingURL=graphql-express.js.map