/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.AggregateQuery=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),graphql_1=require("graphql"),_=require("lodash"),collections_1=require("../../collections"),types_1=require("../../types"),paging_1=require("../paging/paging"),paging_types_1=require("../paging/paging-types"),get_total_count_1=require("../queries/get-total-count"),access_rights_1=require("../security/access-rights"),node_type_1=require("../types/node-type"),aggregate_types_1=require("./aggregate-types");class AggregateQuery{static makeGroupCursor(e){const parseCursor=e=>Object.values(e).map(e=>_.isPlainObject(e)||_.isArray(e)?parseCursor(e):e),t=JSON.stringify(_.flattenDeep(parseCursor(Object.values(e))));return`${t}${(0,types_1.cursorChecksum)(t)}`}static makeGroupNode(e){return{...e,$:{state:{getCursorValue:()=>this.makeGroupCursor(e.group)}}}}static makePageValue(e,t){const r=e.map(e=>this.makeGroupNode(e));return paging_1.Paging.buildOutputPage({items:r,totalCount:r.length},t)}static resolveAggregateQuery(e,t,r,a,g,s){return access_rights_1.AccessRights.runSecure(e,"read",{factory:t,args:s},async()=>{const r=await e.query(t.nodeConstructor,{...a,first:a.first&&a.first+1,last:a.last&&a.last+1,aggregate:g}).toArray();return AggregateQuery.makePageValue(r,a)})}static makeEdgeNodeResolver(e,t,r){return{type:new graphql_1.GraphQLObjectType({name:`${r}_Query_Edges_Node`,fields:{group:{type:node_type_1.NodeType.makeOutputType(e,t,"group")},values:{type:node_type_1.NodeType.makeOutputType(e,t,"values")}}})}}static makeEdgesResolver(e,t,r){return{type:new graphql_1.GraphQLList(new graphql_1.GraphQLObjectType({name:`${r}_Query_Edges`,fields:{node:AggregateQuery.makeEdgeNodeResolver(e,t,r),cursor:{type:graphql_1.GraphQLString}}})),resolve:e=>e.pagePromise.then(e=>e.edges)}}static makePageInfoResolver(){return{type:paging_types_1.pageInfoType,resolve:e=>e.pagePromise?e.pagePromise.then(e=>e.pageInfo):e.pageInfo}}static makeResolver(e,t){const r=`${(0,xtrem_shared_1.schemaTypeName)(t.fullName)}_Agg`,a=`${r}_Query`;return{type:e.internType(a,()=>new graphql_1.GraphQLObjectType({name:a,fields:{edges:AggregateQuery.makeEdgesResolver(e,t,r),pageInfo:AggregateQuery.makePageInfoResolver(),totalCount:get_total_count_1.GetTotalCount.makeResolver(t)}})),args:paging_1.Paging.getPagingArgumentTypes(),resolve:(e,r,a,g)=>access_rights_1.AccessRights.runSecure(a,"read",{factory:t},async()=>{const s=e instanceof collections_1.BaseCollection?e.sourceNode.$.context:a,o=await aggregate_types_1.AggregateTypes.parseAggregate(s,g,t),n=await paging_1.Paging.parsePagingOptions(s,t,r,g,{},o);if(e instanceof collections_1.BaseCollection)await paging_1.Paging.addCollectionFilter(n,e);return{context:s,pagePromise:AggregateQuery.resolveAggregateQuery(s,t,e,n,o,r)}})}}}exports.AggregateQuery=AggregateQuery;
//# sourceMappingURL=aggregate-query.js.map