/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.FileStorageManager=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_shared_1=require("@sage/xtrem-shared"),fs=require("node:fs/promises"),fsp=require("path"),runtime_1=require("../runtime"),dev_upload_middleware_1=require("./dev-upload-middleware"),download_middleware_1=require("./download-middleware");class FileStorageManager{static{this._downloadHandlersByNodeName=(0,xtrem_shared_1.createDictionary)()}static addAuthenticatedRoutes(e,a){(0,download_middleware_1.addDownloadRoute)(e,a)}static addUnauthenticatedRoutes(e,a){if((0,xtrem_shared_1.isDevelopmentConfig)(xtrem_config_1.ConfigManager.current))(0,dev_upload_middleware_1.addDevUploadRoute)(e,a)}static registerDownloadHandler(e,a){const r=e.name;if(null!=this._downloadHandlersByNodeName[r]&&this._downloadHandlersByNodeName[r]!==a)throw new Error(`A download handler for node ${r} is already registered`);this._downloadHandlersByNodeName[r]=a}static getSandboxFilePath(e,a){return fsp.join(e.application.tmpDir,"tenant-data",".sandbox",e.tenantId??".",a)}static clearSandbox(e){return fs.rm(fsp.join(e.application.tmpDir,"tenant-data",".sandbox",e.tenantId??"."),{recursive:true})}static async getOnDemandDownloadUrl(e){const a=await e.$.context.vault.encrypt64(JSON.stringify({nodeName:e.$.factory.name,_id:e._id}));return(0,runtime_1.getServerUrl)(download_middleware_1.downloadBasePath,new URLSearchParams({t:a}))}static async getTargetDownloadUrl(e,a){try{const{nodeName:r,_id:t}=JSON.parse(await e.vault.decrypt64(a)),d=this._downloadHandlersByNodeName[r];if(null==d)throw new xtrem_shared_1.SystemError(`No download handler for node ${r} is registered`);const o=e.application.getFactoryByName(r),n=await e.read(o.nodeConstructor,{_id:t});return await d(n)}catch(e){throw new xtrem_shared_1.SecurityError("Invalid download target data",e)}}}exports.FileStorageManager=FileStorageManager;
//# sourceMappingURL=file-storage-manager.js.map