/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.addDevUploadRoute=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_shared_1=require("@sage/xtrem-shared"),fs=require("fs"),fsp=require("path"),application_1=require("../application"),loggers_1=require("../runtime/loggers"),test_1=require("../test"),logger=loggers_1.loggers.fileStorage;function addDevUploadRoute(e,t){const o=xtrem_config_1.ConfigManager.current;if(!(0,xtrem_shared_1.isDevelopmentConfig)(o))return;function parseDestination(e){const i=t.tmpDir,r=o.tenantId||test_1.Test.defaultTenantId,n=e.params.destination,a=JSON.parse(Buffer.from(e.params.key,"base64").toString()),s=a.objectKey;let d=`${n}/${s}`;const l=a.objectKey.split("/");if("uploads"===n&&l.length>1)d=s;const f=`${i}/${r}`,c=fsp.normalize(`${i}/${r}/${d}`);if(!c.startsWith(f))return{};return{destination:n,key:s,filePath:c}}const devUploadMiddleware=(e,t,i)=>{const r=o.s3Storage?.s3BucketUrlPrefix;if(r)t.setHeader("access-control-allow-origin",r);i()};e.put("/dev/:destination/:key",devUploadMiddleware,(e,o)=>{const{destination:i,key:r,filePath:n}=parseDestination(e);if(!i||!r||!n)return logger.error(`[Dev] Failed to upload destination=${i} file='${r}' to ${n}`),void o.status(404).end();logger.info(`[Dev] Uploading file destination=${i} file='${r}' to ${n}`),fs.mkdirSync(fsp.dirname(n),{recursive:true});const a=fs.createWriteStream(n);e.pipe(a).on("finish",()=>{let e="";switch(i){case"uploads":e="UploadedFile/InfrastructureComplete";break;case"attachments":e="Attachment/InfrastructureComplete";break;default:throw new Error(`Invalid destination ${i}`)}const a={contextId:r,result:"success",contextValue:{replyTopic:e}};fs.writeFileSync(`${n}.tags`,JSON.stringify({Key:r,LastModified:Date.now().toString(),ETag:r})),application_1.Application.emitter.emit("devFileUploaded",{application:t,payload:a}),o.status(200).end()}).on("error",e=>{logger.error(`[Dev] Failed to upload destination=${i} file='${r}' from ${n}: ${e.message}`),o.status(404).end(e.message)})}),e.get("/dev/:destination/:key",devUploadMiddleware,(e,t)=>{const{destination:o,key:i,filePath:r}=parseDestination(e);if(!o||!i||!r)return logger.error(`[Dev] Failed to download destination=${o} file='${i}' from ${r}`),void t.status(404).end();logger.info(`[Dev] Downloading destination=${o} file='${i}' from ${r}`),t.setHeader("content-disposition",`attachment; filename=${e.query.filename?encodeURIComponent(e.query.filename):fsp.basename(r)}`),t.sendFile(r,e=>{if(e)logger.error(`[Dev] Failed to download destination=${o} file='${i}' from ${r}: ${e.message}`),t.status(500).send(e.message)})})}exports.addDevUploadRoute=addDevUploadRoute;
//# sourceMappingURL=dev-upload-middleware.js.map