/** @packageDocumentation @module decorators */
import { ServiceOption } from '../../application';
import { Extend, Node, NodeExtension, SubNodeExtension1, SubNodeExtension2, SubNodeExtension3, SubNodeExtension4, SubNodeExtension5 } from '../../ts-api';
import { ExternalStorageManagerExtension } from '../external-storage-manager';
import { NodeIndexDecorator } from './node-decorator';
import { NodeEvents } from './node-events';
export interface NodeExtensionDecorator<This extends Node> extends NodeEvents<This> {
    extends: () => typeof Node;
    indexes?: NodeIndexDecorator<Extend<This>>[];
    externalStorageManagerExtension?: ExternalStorageManagerExtension<Extend<This>>;
    /** Class service options */
    serviceOptions?: () => ServiceOption[];
    /** Is it a target of a vital reference ? */
    isVitalReferenceChild?: boolean;
    /** Is it a target of an association collection ? */
    isAssociationCollectionChild?: boolean;
    /** Is it a target of an association reference ? */
    isAssociationReferenceChild?: boolean;
    /** node extension can override attachments */
    hasAttachments?: boolean;
    /** Is this node a source for synchronization */
    isSynchronizable?: true;
    /** Is this node a target for synchronization */
    isSynchronized?: true;
}
/** &#064;decorators.nodeExtension(arg) class extension decorator */
export declare function nodeExtension<This extends NodeExtension<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
/** &#064;decorators.subNodeExtension1(arg) class extension decorator */
export declare function subNodeExtension1<This extends SubNodeExtension1<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
/** &#064;decorators.subNodeExtension2(arg) class extension decorator */
export declare function subNodeExtension2<This extends SubNodeExtension2<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
/** &#064;decorators.subNodeExtension3(arg) class extension decorator */
export declare function subNodeExtension3<This extends SubNodeExtension3<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
/** &#064;decorators.subNodeExtension4(arg) class extension decorator */
export declare function subNodeExtension4<This extends SubNodeExtension4<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
/** &#064;decorators.subNodeExtension5(arg) class extension decorator */
export declare function subNodeExtension5<This extends SubNodeExtension5<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
//# sourceMappingURL=node-extension-decorator.d.ts.map