import { Package } from '../application/package';
import { NodeFactory } from '../runtime/node-factory';
import { node, nodeExtension, subNode, subNodeExtension1, subNodeExtension2, subNodeExtension3, subNodeExtension4, subNodeExtension5 } from './node-decorators';
import { mutation, query } from './operation-decorators';
import { binaryStreamProperty, binaryStreamPropertyOverride, booleanProperty, booleanPropertyOverride, collectionProperty, collectionPropertyOverride, dateProperty, datePropertyOverride, dateRangeProperty, dateRangePropertyOverride, datetimeProperty, datetimePropertyOverride, datetimeRangeProperty, datetimeRangePropertyOverride, decimalProperty, decimalPropertyOverride, decimalRangeProperty, decimalRangePropertyOverride, doubleProperty, doublePropertyOverride, enumArrayProperty, enumArrayPropertyOverride, enumProperty, enumPropertyOverride, floatProperty, floatPropertyOverride, integerArrayProperty, integerArrayPropertyOverride, integerProperty, integerPropertyOverride, integerRangeProperty, integerRangePropertyOverride, jsonProperty, jsonPropertyOverride, referenceArrayProperty, referenceArrayPropertyOverride, referenceProperty, referencePropertyOverride, shortProperty, shortPropertyOverride, stringArrayProperty, stringArrayPropertyOverride, stringProperty, stringPropertyOverride, textStreamProperty, textStreamPropertyOverride, timeProperty, timePropertyOverride, uuidProperty, uuidPropertyOverride } from './property-decorators';
export { useDefaultValue } from './property-decorators/base-property-events';
export { ColumnTypeName, Decorated, FilterTag, StaticMemberDecoratorFunction, StaticThis, TypeName, staticMemberDecorator, } from './decorator-utils';
export * from './external-storage-manager';
export * from './node-decorators';
export * from './operation-decorators';
export * from './property-decorators';
export interface NotificationListener {
    name: string;
    definingPackage: Package;
    register(factory: NodeFactory): void;
}
export interface MessageListener {
    name: string;
    definingPackage: Package;
    register(factory: NodeFactory): void;
}
export declare const coreDecorators: {
    node: typeof node;
    nodeExtension: typeof nodeExtension;
    subNodeExtension1: typeof subNodeExtension1;
    subNodeExtension2: typeof subNodeExtension2;
    subNodeExtension3: typeof subNodeExtension3;
    subNodeExtension4: typeof subNodeExtension4;
    subNodeExtension5: typeof subNodeExtension5;
    subNode: typeof subNode;
    mutation: typeof mutation;
    query: typeof query;
    binaryStreamProperty: typeof binaryStreamProperty;
    binaryStreamPropertyOverride: typeof binaryStreamPropertyOverride;
    booleanProperty: typeof booleanProperty;
    booleanPropertyOverride: typeof booleanPropertyOverride;
    collectionProperty: typeof collectionProperty;
    collectionPropertyOverride: typeof collectionPropertyOverride;
    dateProperty: typeof dateProperty;
    datePropertyOverride: typeof datePropertyOverride;
    dateRangeProperty: typeof dateRangeProperty;
    dateRangePropertyOverride: typeof dateRangePropertyOverride;
    datetimeProperty: typeof datetimeProperty;
    datetimePropertyOverride: typeof datetimePropertyOverride;
    datetimeRangeProperty: typeof datetimeRangeProperty;
    datetimeRangePropertyOverride: typeof datetimeRangePropertyOverride;
    decimalProperty: typeof decimalProperty;
    decimalPropertyOverride: typeof decimalPropertyOverride;
    decimalRangeProperty: typeof decimalRangeProperty;
    decimalRangePropertyOverride: typeof decimalRangePropertyOverride;
    doubleProperty: typeof doubleProperty;
    doublePropertyOverride: typeof doublePropertyOverride;
    enumProperty: typeof enumProperty;
    enumPropertyOverride: typeof enumPropertyOverride;
    enumArrayProperty: typeof enumArrayProperty;
    enumArrayPropertyOverride: typeof enumArrayPropertyOverride;
    floatProperty: typeof floatProperty;
    floatPropertyOverride: typeof floatPropertyOverride;
    integerProperty: typeof integerProperty;
    integerPropertyOverride: typeof integerPropertyOverride;
    integerRangeProperty: typeof integerRangeProperty;
    integerRangePropertyOverride: typeof integerRangePropertyOverride;
    integerArrayProperty: typeof integerArrayProperty;
    integerArrayPropertyOverride: typeof integerArrayPropertyOverride;
    jsonProperty: typeof jsonProperty;
    jsonPropertyOverride: typeof jsonPropertyOverride;
    referenceProperty: typeof referenceProperty;
    referencePropertyOverride: typeof referencePropertyOverride;
    referenceArrayProperty: typeof referenceArrayProperty;
    referenceArrayPropertyOverride: typeof referenceArrayPropertyOverride;
    shortProperty: typeof shortProperty;
    shortPropertyOverride: typeof shortPropertyOverride;
    stringProperty: typeof stringProperty;
    stringPropertyOverride: typeof stringPropertyOverride;
    stringArrayProperty: typeof stringArrayProperty;
    stringArrayPropertyOverride: typeof stringArrayPropertyOverride;
    textStreamProperty: typeof textStreamProperty;
    textStreamPropertyOverride: typeof textStreamPropertyOverride;
    timeProperty: typeof timeProperty;
    timePropertyOverride: typeof timePropertyOverride;
    uuidProperty: typeof uuidProperty;
    uuidPropertyOverride: typeof uuidPropertyOverride;
};
type CoreDecorators = typeof coreDecorators;
export interface Decorators extends CoreDecorators {
}
export declare const decorators: Decorators;
//# sourceMappingURL=index.d.ts.map