/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.withDetachedClsContext=exports.safeSetImmediate=exports.safeSetInterval=exports.runResolver=exports.runMiddleware=exports.wrapError=void 0;const xtrem_log_1=require("@sage/xtrem-log"),xtrem_shared_1=require("@sage/xtrem-shared"),custom_event_emiter_1=require("./metrics/newrelic/custom-event-emiter"),loggers_1=require("./runtime/loggers"),logger=loggers_1.loggers.core,logError=(r,e)=>{const t=e instanceof xtrem_shared_1.SecurityError?e.securityMessage(r):e.message;if(e instanceof xtrem_shared_1.BaseError&&e.innerError)logger.error(t),logError(r,e.innerError);else if(e.stack){if(t!==e.message)logger.error(t);logger.error(e.stack)}else logger.error(t)},wrapError=(r,e)=>{if(e instanceof xtrem_shared_1.ApplicationError)return e;logError(r,e),(0,custom_event_emiter_1.recordXtremErrorToNewrelic)(r,e);const t=r.cloudflareRayID&&xtrem_log_1.Logger.isLogAsJson()?r.localize("@sage/xtrem-core/generic-error-origin-id","An error occurred. Contact your administrator. Support ID: {{cloudflareRayID}}",{cloudflareRayID:r.cloudflareRayID}):r.localize("@sage/xtrem-core/generic-error","An error occurred. Contact your administrator.");if("logic"===(e instanceof xtrem_shared_1.LogicError?"logic":"system"))return new xtrem_shared_1.LogicError(t,e);else return new xtrem_shared_1.SystemError(t,e)};async function runWithNewClsContext(r,e){return(0,xtrem_log_1.withClsContext)(r,{context:e})}function runMiddleware(r,e,t){return runWithNewClsContext(e,r).catch(e=>{logError(r,e),t()})}function runResolver(r,e){return runWithNewClsContext(()=>loggers_1.loggers.graphQl.doAsync(e,{ignoreCallback:e=>r.shouldIgnoreDuplicateLogs(e)}),r).catch(e=>{throw(0,exports.wrapError)(r,e)})}function safeSetInterval(r,e){return global.setInterval(()=>{runWithNewClsContext(r).catch(r=>logger.error(r))},e)}function safeSetImmediate(r){return global.setImmediate(()=>{runWithNewClsContext(r).catch(r=>logger.error(r))})}async function withDetachedClsContext(r,e){const t=(0,xtrem_log_1.clsContext)().context;try{return(0,xtrem_log_1.clsContext)().context=r,await e(r)}finally{(0,xtrem_log_1.clsContext)().context=t}}exports.wrapError=wrapError,exports.runMiddleware=runMiddleware,exports.runResolver=runResolver,exports.safeSetInterval=safeSetInterval,exports.safeSetImmediate=safeSetImmediate,exports.withDetachedClsContext=withDetachedClsContext;
//# sourceMappingURL=concurrency-utils.js.map