/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.BaseCollection=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),node_state_1=require("../node-state"),state_get_value_1=require("../node-state/state-get-value"),state_old_1=require("../node-state/state-old"),array_utils_1=require("../runtime/array-utils"),sql_collection_1=require("./sql-collection");class BaseCollection extends xtrem_async_helper_1.AsyncArray{constructor(t,e){if(super(async()=>{if(this._nodes)return this._nodes;if(e.computeValue)this._nodes=await state_get_value_1.StateGetValue.callComputeValue(this.sourceState,e);else if(e.getValue)this._nodes=await state_get_value_1.StateGetValue.callGetValue(this.sourceState,e);else if(e.join||e.getFilter){const t=this.sourceState.status;if(t!==node_state_1.StateStatus.constructed&&t!==node_state_1.StateStatus.deleted)this._nodes=await this.queryFullCollection();else this._nodes=[]}else this._nodes=[];return this._nodes=await state_old_1.StateOld.mapNodesIfOld(t.$.state,this.property,this._nodes),this._nodes}),this.sourceNode=t,this.property=e,e.orderBy)this.orderBy=e.orderBy}get joinValues(){return this.sourceState.getJoinValues(this.property)}get name(){return this.property.name}get factory(){if(!this.property.node)throw this.error("class decorator missing");return this.property.targetFactory}get sourceState(){return this.sourceNode.$.state}get sourceFactory(){return this.sourceState.factory}error(t){return new Error(`${this.sourceFactory.name}.${this.property.name}: ${t}`)}async queryFullCollection(t){const e=this.getQueryForUpdate(t);return(await this.factory.createNodeQuery(this.sourceState.context,{forUpdate:e,filter:await this.combineFilters(),orderBy:t?.orderBy||this.orderBy,collection:this})).getNodeReader().map(t=>(t.$.state.collection=this,t)).readAll()}async combineFilters(t){const e=[];if(this.property.reverseReference||this.property.join)e.push(await this.joinValues);if(this.property.getFilter)e.push(await(this.property.getFilter?.call(this.sourceNode)));if(0===e.length)throw this.property.logicError("invalid collection decorator: reverseReference, getFilter, join, getValue and computeValue are all absent");if(t?.filter)e.push(t?.filter);return 1===e.length?e[0]:{_and:e}}async queryPage(t){if(!this._nodes&&!this.sourceState.context.transaction)return{items:[],totalCount:0};await this.getSource();const e=this._nodes||await this.queryFullCollection(t);return(0,array_utils_1.applyPagingOptions)(this.factory,this.sourceState.context,e,t)}async withReader(t){const e=this.getReader();try{return t(e)}finally{await e.stop()}}join(t){return this.join(t)}get fullName(){return`${this.sourceState.factory.name}.${this.name}`}get nodes(){return(async()=>{if(!this._nodes){const t=this.sourceState.status,e=t!==node_state_1.StateStatus.created&&t!==node_state_1.StateStatus.constructed&&t!==node_state_1.StateStatus.deleted;this._nodes=e?await this.getSource():[]}return this._nodes})()}get isLoaded(){return!!this._nodes}get length(){return(async()=>(await this.nodes).length)()}cannotModify(){throw this.error("cannot modify non vital collection")}reset(){this.cannotModify()}fill(t){this.cannotModify()}insert(t,e){this.cannotModify()}appendNode(t){this.cannotModify()}append(t){this.cannotModify()}delete(t,e=1){this.cannotModify()}async queryPagedCollection(t){const e=await this.combineFilters(t),r={orderBy:this.orderBy,...t,filter:e,collection:this};return this.sourceState.context.query(this.factory.nodeConstructor,r).toArray()}async queryTotalCount(t){const e=await this.combineFilters(t);return this.sourceState.context.queryCount(this.factory.nodeConstructor,{filter:e,collection:this})}async readPage(t){if(this._nodes||this.property.getValue||this.property.computeValue||this.getQueryForUpdate(t))return this.queryPage(t);const e=t.selections.includes("edges")?await this.queryPagedCollection(t):[],r=t.selections.includes("totalCount")?await this.queryTotalCount(t):0;if("external"===this.factory.storage){return{items:(await(0,array_utils_1.applyPagingOptions)(this.factory,this.sourceState.context,e,t)).items,totalCount:r}}return{items:e,totalCount:r}}query(t){return new xtrem_async_helper_1.AsyncArray(async()=>(await this.queryPage(t)).items)}where(t){return new sql_collection_1.SqlCollection(this,t)}async takeOne(t){if(!this.where)throw new Error("takeOne requires a where clause");return await this.find(t)??null}}exports.BaseCollection=BaseCollection;
//# sourceMappingURL=base-collection.js.map