import { PutObjectCommandInput, PutObjectCommandOutput } from '@aws-sdk/client-s3';
export type WithoutBucket<T> = Omit<T, 'Bucket'>;
export declare class S3Bucket {
    readonly bucketName: string;
    constructor(bucketName: string);
    /**
     * Returns the region to use
     * @param bucketName if set, will return the region specific for this bucket (from configuration)
     * @returns
     */
    static getRegion(bucketName?: string): string;
    private _addBucket;
    private _tryWait;
    /**
     * Streams a readableStream to S3
     *
     * @example
     * const res = await myBucket.putObject({
     *              Key: the_key_of_the_S3_object,
     *              Body: readStream,
     *          });
     */
    putObject(request: WithoutBucket<PutObjectCommandInput>): Promise<PutObjectCommandOutput>;
    private _writeObjectToStream;
}
//# sourceMappingURL=s3-bucket.d.ts.map