/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.PackageValidationContext=exports.XtremAboutHelper=exports.Package=exports.getPackageQueueName=exports.getPackageName=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),fs=require("fs"),lodash_1=require("lodash"),fsp=require("path"),decorator_utils_1=require("../decorators/decorator-utils"),loggers_1=require("../runtime/loggers"),types_1=require("../types"),logger=loggers_1.loggers.application;function getPackageName(e){return e.xtrem?.packageName||e.name}function getPackageQueueName(e){if(!e.xtrem?.queue)throw new Error(`No queue name defined for package ${e.name}, please set the queue property of the xtrem section in the package.json file.`);return e.xtrem?.queue}exports.getPackageName=getPackageName,exports.getPackageQueueName=getPackageQueueName;class Package{#e;get dir(){return this._dir}#t;constructor(e,t){if(this.application=e,this.options=t,this._nodeExtensions=[],this.checkXtremAttribute=(e,t)=>{if(e&&e.xtrem&&"object"!=typeof e.xtrem)throw new Error(t())},!t.buildDir)throw new Error("A build directory must be provided to create an Application.");if(this.buildDir=t.buildDir||"",t.api)this.api=t.api;this._dir=fsp.join(this.buildDir,"..");const i=fsp.join(this.dir,"package.json");if(this._packageJson=require(i),t.api&&!this._packageJson.xtrem)this._packageJson.isMainUnitTest=true;else if(this._packageJson.xtrem&&!this._packageJson.main)this.api={};else{const e=require.cache[fsp.join(this.dir,"index.ts")]?.exports||require(this.dir);this.api=(0,lodash_1.merge)({},e,t.api||{})}if(this.checkXtremAttribute(this._packageJson,()=>`xtrem property in ${i} should be an object`),!this._packageJson.xtrem&&!this._packageJson.isMainUnitTest)throw new Error(`${this._packageJson.name}: 'xtrem' key is missing in package.json`);if(this._packageJson.xtrem?.isMain&&!this._packageJson.xtrem?.appName);this._packageJson.main=this._packageJson.main||"build/index.js"}get isSealed(){return!!this._packageJson?.xtrem?.isSealed}get isHidden(){return!!this._packageJson?.xtrem?.isHidden||this.isAddOn}get isActiveByDefault(){return!this._packageJson?.xtrem?.isInactiveByDefault}get isReleased(){return!!this._packageJson?.xtrem?.isReleased}get sqlSchemaVersion(){return this._packageJson?.xtrem?.sqlSchemaVersion}get isMain(){return!!this._packageJson?.xtrem?.isMain}get isService(){return!!this._packageJson?.xtrem?.isService}get isAddOn(){return!!this.options?.isAddOn}get hasListeners(){return!!this._packageJson?.xtrem?.hasListeners||this.isService||this.isAddOn||this.factories.some(e=>e.notificationListeners.length>0||e.messageListeners.length>0)}get queue(){if(this.#e)return this.#e;return this.#e=getPackageQueueName(this._packageJson),this.#e}get dependencies(){return this._packageJson.dependencies||{}}get directDependencies(){return Object.keys(this.dependencies).map(e=>this.application.packagesByName[e]).filter(e=>!!e)}get apiDependencies(){return(0,lodash_1.uniq)([...this.allDependencies.map(e=>`${e.name}-api`),...Object.keys(this.packageJson.devDependencies||{}).filter(e=>/@sage\/[a-z][a-z0-9-]*-api$/.test(e))])}get allDependencies(){if(this.#t)return this.#t;const e=this.application.packagesByName,t=new Set,scan=i=>{if(i.dependencies)Object.keys(i.dependencies).filter(i=>e[i]&&!t.has(e[i])).forEach(i=>{t.add(e[i]),scan(e[i])})};return scan(this),this.#t=[...t],this.#t}get packageJson(){if(!this._packageJson)throw new xtrem_shared_1.LogicError("lazy loading of package.json");return this._packageJson}get name(){return getPackageName(this.packageJson)}get version(){return this.packageJson.version}get packageName(){return this.name}static getPackageJson(e){return require(fsp.join(e,"package.json"))}get xtremOptions(){return this.packageJson?.xtrem||{}}loadDecorators(){if(this.api)return;try{this.api=require(this.buildDir)}catch(e){logger.error(e.stack)}}get nodeExtensions(){return this._nodeExtensions}get activities(){return this.api.activities||{}}get activitiesExtensions(){return this.api.activityExtensions||{}}get serviceOptions(){return this.api.serviceOptions||{}}static decoratorFromFactory(e){return{...e.nodeDecorator,isVitalChild:e.isVitalChild,isVitalReferenceChild:e.isVitalReferenceChild,isVitalCollectionChild:e.isVitalCollectionChild,properties:e.properties,queries:e.queries,mutations:e.mutations,storage:e.storage,externalStorageManager:e.externalStorageManager,indexes:e.indexes,tableName:e.tableName,super:e.baseFactory?.name}}getNodeDecorators(){return this.factories.map(Package.decoratorFromFactory)}getEnumDescriptors(){const e=this.api.enums;if(!e)return[];return Object.keys(e).filter(t=>!(e[t]instanceof types_1.DataType)).map(t=>{const i=e[t];return{name:t,values:Object.keys(i).filter(e=>!/^\d/.test(e)).reduce((e,t)=>({...e,[t]:i[t]}),{})}})}getEnumDataTypes(){if(this.enumDataTypes)return this.enumDataTypes;const e=this.api.enums;if(!e)return[];return this.enumDataTypes=Object.keys(e).filter(t=>e[t]instanceof types_1.EnumDataType).map(t=>{const i=e[t];return i.pack=this.name,i.name=t,i}),this.enumDataTypes}getExtensionDecorators(){const e=this.api.nodeExtensions;if(!e)return[];return Object.keys(e||{}).map(t=>{const i=e[t];if("function"==typeof i){const e=(0,decorator_utils_1.getDecorators)(i),t=this.application.getFactoryByConstructor(e.nodeExtension.extends()),s=(e.properties||[]).filter(e=>!e.isOverride).map(e=>t.findProperty(e.name));return{...e.nodeExtension,name:this.application.getFactoryByConstructor(e.nodeExtension.extends()).name,properties:s,queries:e.queries,mutations:e.mutations,notificationListeners:e.notificationListeners,messageListeners:e.messageListeners}}return logger.warn(`${t}: Skipping decorator detection`),null}).filter(e=>!!e)}getLocalizedTitleKey(){return`${this.name}/package__name`}}exports.Package=Package;class XtremAboutHelper{static load(e,t=""){const i="package.json";let s={name:t,version:"",author:"",description:"",license:"",buildStamp:""},a=e.mainPackage.dir;for(;;){const e=fsp.join(a,i);if(fs.existsSync(e))try{const i=JSON.parse(fs.readFileSync(e,"utf8"));if(s=Object.keys(s).reduce((e,t)=>{let s=i[t]||"";if("object"==typeof s)s=s.name||"";return{...e,[t]:s||""}},{}),t.length&&i.name===s.name)break}catch(e){break}if(e===i)break;const r=fsp.join(a,"..");if(r===a)break;a=r}return s}}exports.XtremAboutHelper=XtremAboutHelper;class PackageValidationContext{constructor(){this.warnings=new Set}}exports.PackageValidationContext=PackageValidationContext;
//# sourceMappingURL=package.js.map