/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.PackageLoader=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_shared_1=require("@sage/xtrem-shared"),fs=require("fs"),lodash_1=require("lodash"),fsp=require("path"),loggers_1=require("../runtime/loggers"),utils_1=require("../utils"),package_1=require("./package"),logger=loggers_1.loggers.nodeFactory;class PackageLoader{constructor(e){this.application=e,this.packagesByName={}}getPackageFileOfDependency(e,a){const i=this.application.dir,n=[fsp.join(i,"node_modules",e),fsp.join(i,"..",fsp.parse(e).name),fsp.join(a,"node_modules",e),fsp.join(a,"..",fsp.parse(e).name),fsp.join(i,"..","..","node_modules",e),fsp.join(a,"..","..","node_modules",e),fsp.join(i,"..","..","..","node_modules",e),fsp.join(a,"..","..","..","node_modules",e)].map(e=>fsp.join(e,"package.json")).find(e=>fs.existsSync(e));return n?require(n):void 0}isPackageWithNodes(e,a){if(/^@sage\/test[\w\d-]+-app$/.test(e))return true;if("@"!==e[0]||e.startsWith("@types/")||/(xtrem|etna)-ui$/.test(e)||this.application.nonPackageDependencies[e])return this.application.nonPackageDependencies[e]=true,false;const i=this.packagesByName[e];if(i)return null!=i.packageJson.xtrem&&!i.packageJson.xtrem?.isFrontEndApp;if(!a)return this.application.nonPackageDependencies[e]=true,false;if(null!=a.xtrem&&!a.xtrem?.isFrontEndApp)return true;return this.application.nonPackageDependencies[e]=true,false}static getDependencyBuildDir(e,a,i=[]){const n=(0,lodash_1.uniq)([a,fsp.join(a,"../.."),...i]),s=require.resolve(`${e}/package.json`,{paths:n});return fsp.join(fsp.dirname(s),"build")}static checkForNameCollisions(e){e.getEnumDescriptors().forEach(a=>{const i=a.name;if("enum"===e.application.nodeAndEnumNames[i])throw new xtrem_shared_1.SystemError(`Enum names cannot be duplicated. The enum name: ${i} was already used.`);else if("node"===e.application.nodeAndEnumNames[i])throw new xtrem_shared_1.SystemError(`Enum names cannot match node names. The enum name: ${i} was already used as a node name.`);e.application.nodeAndEnumNames[i]="enum"})}_verifyPackage(e){if(this.application.skipVerifications)return;const a=[e,...e.allDependencies].filter(e=>e.isService&&"@sage/xtrem-communication"!==e.name);if(a.length>1&&!e.isMain){const i=`${e.name}: invalid dependency graph: several services found: ${a.map(e=>e.name)}`;logger.warn(i)}if(!(xtrem_config_1.ConfigManager.current.storage?.managedExternal||utils_1.testPackageExclusions.includes(e.application.mainPackage.name))&&Object.keys(e.api.enumExtensions||{}).length>0)throw new xtrem_shared_1.LogicError(`${e.name}: enum extensions are only allowed on external applications.`);PackageLoader.checkForNameCollisions(e)}createPackage(e){const a=new package_1.Package(this.application,e);return this.packagesByName[a.name]=a,this._verifyPackage(a),a.loadDecorators(),a}scanPackage(e,a,i,n,s){const t=package_1.Package.getPackageJson(e);a.push(e);const r=Object.keys(t.dependencies||{}),c=Object.keys(t.peerDependencies||{}),o=(0,lodash_1.uniq)([...r,...c]);if("test"===this.application.applicationType&&null!=t.devDependencies&&Object.keys(t.devDependencies).includes("@sage/xtrem-routing"))o.push("@sage/xtrem-routing");if(0===o.length)return;o.filter(e=>!i[e]).forEach(t=>{const r=this.getPackageFileOfDependency(t,e);if(this.isPackageWithNodes(t,r)){if(this.scanPackage(fsp.join(PackageLoader.getDependencyBuildDir(t,e,a),".."),a,i,n),!i[t]){const e=PackageLoader.getDependencyBuildDir(t,this.application.dir,a);this.createPackage({...s,buildDir:e}),i[t]=true}}else i[t]=true})}createAddOnPackages(e,a,i){if(this.application.addOnPackagePaths.length)this.application.addOnPackagePaths.forEach(n=>{const s=package_1.Package.getPackageJson(n),t=s.name;if(a[t])return;if(e.push(n),this.isPackageWithNodes(t,s)){const s=PackageLoader.getDependencyBuildDir(n,this.application.dir,e);a[t]=true,this.scanPackage(fsp.join(s,".."),e,a,i,{isAddOn:true}),this.createPackage({buildDir:s,isAddOn:true})}else a[t]=true})}createFactories(e){const a=Object.values(this.packagesByName);this.application.factoriesManager.createAllFactories(a,e),a.forEach(e=>{this.application.activityManager.createActivities(e)})}createPackages(){const e={},a=new package_1.PackageValidationContext,i=[];let n=logger.verbose(()=>"Loading packages");this.scanPackage(this.application.dir,i,e,a),n.success(),this.packagesByName[this.application.mainPackage.name]=this.application.mainPackage,e[this.application.mainPackage.name]=true,n=logger.verbose(()=>"Loading add on packages"),this.createAddOnPackages(i,e,a),n.success(),n=logger.verbose(()=>"Creating application factories"),this.createFactories(a),a.warnings.forEach(e=>logger.warn(`${e}`)),n.success(),this.application.factoriesManager.registerListeners(),Object.freeze(this.packagesByName),n=logger.verbose(()=>"Intializing localization resolver"),(0,xtrem_i18n_1.initializeLocalizationResolver)(Object.values(this.packagesByName),this.application.dir),n.success()}}exports.PackageLoader=PackageLoader;
//# sourceMappingURL=package-loader.js.map