import { Dict } from '@sage/xtrem-shared';
import { Application } from './application';
import { Package, PackageCreateOptions, PackageJsonFile } from './package';
export declare class PackageLoader {
    private application;
    readonly packagesByName: Dict<Package>;
    constructor(application: Application);
    getPackageFileOfDependency(packageName: string, dir: string): PackageJsonFile | undefined;
    /**
     * Returns whether a package contains some nodes and must be taken into account when compunting dependencies
     * @param packageName
     * @param dir
     */
    isPackageWithNodes(packageName: string, packageJson: PackageJsonFile | undefined): boolean;
    private static getDependencyBuildDir;
    /** Checks if there are any name collisions between enums and nodes */
    private static checkForNameCollisions;
    private _verifyPackage;
    createPackage(options: PackageCreateOptions): Package;
    /**
     * Scan package dependencies and load application packages
     * @param dir
     * @param knownPaths
     * @param processedPackages
     * @param packageValidationContext
     * @param options
     * @returns
     */
    private scanPackage;
    /**
     * Create add-on packages of application
     */
    private createAddOnPackages;
    private createFactories;
}
//# sourceMappingURL=package-loader.d.ts.map