import { InitialNotification, Notification, PromisifyProperties } from '@sage/xtrem-shared';
import { Context } from '../runtime';
export interface NotificationManager {
    getUserNotifications(context: Context): Promise<Array<PromisifyProperties<Notification>>>;
    markRead(context: Context, _id: string): Promise<boolean>;
    markUnread(context: Context, _id: string): Promise<boolean>;
    markAllRead(context: Context): Promise<boolean>;
    delete(context: Context, _id: string): Promise<boolean>;
    dispatchUserNotification(context: Context, notification?: InitialNotification): Promise<void>;
}
export declare class NotificationManagerStub implements NotificationManager {
    getUserNotifications: () => Promise<Array<PromisifyProperties<Notification>>>;
    markRead: () => Promise<boolean>;
    markUnread: () => Promise<boolean>;
    markAllRead: () => Promise<boolean>;
    delete: () => Promise<boolean>;
    dispatchUserNotification: () => Promise<void>;
}
//# sourceMappingURL=notification-manager.d.ts.map