import { AsyncResponse } from '@sage/xtrem-shared';
import { Context } from '../runtime/context';
/**
 * Management of CSV's checksum.
 * Every time a CSV file is loaded, its checksum is stored (sys_csv_checksum table). This allow
 * the system to skip the next loading of the same CSV file, if it was not changed.
 */
export interface CsvChecksumManager {
    /**
     * Return the checksum of the last successfully loaded Csv for a specific factory
     */
    getLastAppliedChecksum(context: Context, factoryName: string): AsyncResponse<string | undefined>;
    /**
     * Store the checksum of the last successfully loaded Csv for a specific factory
     */
    setLastAppliedChecksum(context: Context, factoryName: string, checksum: string): AsyncResponse<void>;
    /**
     * Compute the checksum of the content of a CSV file
     */
    computeChecksum(csvContent: string): string;
}
/**
 * A mock for TenantManager: should only be used for unit-tests
 */
export declare class CsvChecksumManagerStub implements CsvChecksumManager {
    /**
     * Return the checksum of the last successfully loaded Csv for a specific factory
     */
    getLastAppliedChecksum(_context: Context, _factoryName: string): string | undefined;
    /**
     * Store the checksum of the last successfully loaded Csv for a specific factory
     */
    setLastAppliedChecksum(_context: Context, _factoryName: string, _checksum: string): void;
    /**
     * Compute the checksum of the content of a CSV file
     */
    computeChecksum(_csvContent: string): string;
}
//# sourceMappingURL=csv-checksum-manager.d.ts.map