/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.main=exports.Application=exports.allowedStartChannels=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_toposort_1=require("@sage/xtrem-toposort"),fs=require("fs"),fsExtra=require("fs-extra"),glob=require("glob"),js_yaml_1=require("js-yaml"),lodash_1=require("lodash"),fsp=require("path"),global_cache_1=require("../cache/global-cache"),decorator_utils_1=require("../decorators/decorator-utils"),schema_builder_1=require("../graphql/schema-builder"),runtime_1=require("../runtime"),collation_cache_1=require("../runtime/collation-cache"),context_1=require("../runtime/context"),core_hooks_1=require("../runtime/core-hooks"),global_lock_1=require("../runtime/global-lock"),loggers_1=require("../runtime/loggers"),systemDataTypes=require("../runtime/system-data-types"),utils_1=require("../runtime/utils"),sql_statement_cache_1=require("../sql/mapper/sql-statement-cache"),database_sql_context_1=require("../sql/sql-context/database-sql-context"),types_1=require("../types"),utils_2=require("../utils"),activity_manager_1=require("./activity-manager"),node_factories_manager_1=require("./node-factories-manager"),package_1=require("./package"),package_loader_1=require("./package-loader");require("./unhandled-error-monitor");const EventEmitter=require("events");Error.stackTraceLimit=Math.max(Error.stackTraceLimit,100),exports.allowedStartChannels=["graphql","listeners","routing"];const logger=loggers_1.loggers.application,requestFunnelSize=()=>(xtrem_config_1.ConfigManager.current.storage?.sql?.max||xtrem_config_1.ConfigManager.current.storage?.maxConnections||20)*(xtrem_config_1.ConfigManager.current.server?.requestFunnelSizeFactor||1);class Application{#e;#t;#a;static{this.emitter=new EventEmitter}static{this.hasInstance=false}#r;constructor(e){if(this.options=e,this.packageLoader=new package_loader_1.PackageLoader(this),this.factoriesManager=new node_factories_manager_1.NodeFactoriesManager(this),this.activityManager=new activity_manager_1.ActivityManager(this),this.nonPackageDependencies={},this._pluginDependencies={},this.globalCache=new global_cache_1.GlobalCache,this.globalLock=new global_lock_1.GlobalLock(this),this.nodeAndEnumNames={},this.dataTypes={},this.notificationTopics={},this.graphqlSchemaFunnel=(0,xtrem_async_helper_1.funnel)(1),this.graphqlSchemas={},this.requestFunnel=(0,runtime_1.monitoredFunnel)("graphqlRequest",requestFunnelSize()),this.sqlStatementCache=new sql_statement_cache_1.SqlStatementCache,this.#r=false,"true"===process.env.XTREM_SKIP_FACTORY_CHECKS||"1"===process.env.XTREM_SKIP_FACTORY_CHECKS)this.skipVerifications=true,logger.warn("XTREM_SKIP_FACTORY_CHECKS is set: some checks will be skipped on packages/factories/properties");if(this.mainPackage=new package_1.Package(this,e),this.tryLoadTestApi(),logger.info(`[${this.schemaName}] starting application ${this.mainPackage.name} from folder ${this.mainPackage.dir}`),e.applicationType=e.applicationType||"dev-tool",runtime_1.globalRunningContext.configure(e?.applicationType),Application.hasInstance)logger.warn("Main application already set!");if(Application.hasInstance=true,this.packageLoader.createPackages(),this.workflowManager=core_hooks_1.CoreHooks.createWorkflowManager(this),this.registerMiscArtifacts(),this.packageManager=core_hooks_1.CoreHooks.createPackageManager(this),this.serviceOptionManager=core_hooks_1.CoreHooks.createServiceOptionManager(this),this.notificationManager=core_hooks_1.CoreHooks.createNotificationManager(this),this.clientSettingsManager=core_hooks_1.CoreHooks.createClientSettingsManager(this),"service"===this.applicationType)this.initFactoryCacheLogs()}tryLoadTestApi(){if("1"!==process.env.XTREM_USE_TEST_APPLICATION)return;const e=fsp.join(this.dir,"test/fixtures");if(!fs.existsSync(e))return;const t=fsp.join(e,"test-application.ts");if(!fs.existsSync(t))return;logger.info(`Loading test artifacts from ${e}`),this.options.testApplicationDir=e;const a=t.replace("test/fixtures","build/test/fixtures").replace(".ts",".js"),r=require.cache[t]?.exports||require(a);(0,lodash_1.merge)(this.mainPackage.api,r);const i=fsp.join(this.dir,"test/fixtures/test-application-options.yml");if(fs.existsSync(i)){const e=(0,js_yaml_1.load)(fs.readFileSync(i,"utf8"));(0,lodash_1.merge)(this.options,e)}}registerDataType(e,t,a){if(this.dataTypes[t])throw new Error(`Datatype ${t} in ${e.name} already declared in ${this.dataTypes[t]?.pack}`);a.pack=a.pack??e.name,a.name=a.name??t,this.dataTypes[t]=a}registerDefaultReferenceDataType(e,t,a){if("function"!=typeof a)return;const r=this.getFactoryByName(t);if(!r.isPublished)return;const i=(0,lodash_1.camelCase)(t);let s=this.dataTypes[i];if(s){if("reference"!==s.type)logger.warn(`Cannot define default reference data type ${i} in ${e.name}: name conflicts with ${s.type} data type defined in ${s.pack}`);return}const n=[],fillPaths=(e,t="",a=[])=>{a.push(e.name);const manageProperty=e=>{let r=t?`${t}.${e.name}`:e.name;if(e.isReferenceProperty())if(a.includes(e.targetFactory.name))n.push(t?`${t}._id`:"_id");else fillPaths(e.targetFactory,r,a);else{if(e.isTextStreamProperty()||e.isBinaryStreamProperty())r=`${r}.value`;n.push(r)}},r=e.isVitalChild?e.naturalKey?.filter(t=>t!==e.vitalParentProperty.name&&"_sortValue"!==t):e.naturalKey;if(!r||0===r.length){const a=e.properties.filter(t=>t.lookupAccess&&!t.isSystemProperty&&!t.isCollectionProperty()&&!t.isReferenceArrayProperty()&&"_sortValue"!==t.name&&!e.naturalKey?.includes(t.name)&&!t.isVitalParent);if(a.length>0)a.forEach(e=>{manageProperty(e)});else if(e.keyPropertyNames.length>0)e.keyPropertyNames.forEach(t=>{const a=e.findProperty(t);manageProperty(a)});else n.push(t?`${t}._id`:"_id")}else r.forEach(t=>{const a=e.findProperty(t);if(a.isSystemProperty||"_sortValue"===a.name)return;manageProperty(a)})};if(fillPaths(r),0===n.length)n.push("_id");s=new types_1.ReferenceDataType({reference:()=>r.nodeConstructor,lookup:{valuePath:n[0],helperTextPath:n[0],columnPaths:n}}),s.name=i,s.pack=e.name,this.dataTypes[i]=s}registerNotificationTopic(e,t,a){if(this.notificationTopics[t])throw new xtrem_shared_1.LogicError(`Notification topic ${t} in ${e.name} already declared in ${this.notificationTopics[t]?.definingPackage.name}`);a.completeRegistration(t,e),this.notificationTopics[t]=a,a.verify()}findNotificationTopic(e){const t=this.notificationTopics[e];if(!t)throw new xtrem_shared_1.LogicError(`Notification topic ${e} not found`);return t}registerMiscArtifacts(){Object.entries(systemDataTypes).forEach(([e,t])=>{if(t?.type)this.registerDataType(this.mainPackage,e,t)}),this.getPackages().forEach(e=>{Object.entries(e.api.dataTypes||{}).forEach(([t,a])=>{if(a?.type)this.registerDataType(e,t,a)}),Object.entries(e.api.nodes||{}).forEach(([t,a])=>{if(a[decorator_utils_1.decoratorsSymbol])this.registerDefaultReferenceDataType(e,t,a)}),e.getEnumDataTypes().forEach(t=>{if(t instanceof types_1.EnumDataType&&t.name)this.registerDataType(e,t.name,t)}),Object.entries(e.api.notificationTopics||{}).forEach(([t,a])=>{this.registerNotificationTopic(e,t,a)}),Object.values(e.api.workflowSteps||{}).forEach(t=>{this.workflowManager.registerWorkflowStep(e.name,t)})}),Object.values(this.dataTypes).forEach(e=>{if(e instanceof types_1.EnumDataType&&null!=e.rootDataType){if(!(xtrem_config_1.ConfigManager.current.storage?.managedExternal||utils_2.testPackageExclusions.includes(this.mainPackage.name)))throw new xtrem_shared_1.LogicError(`${e.name}: enum extensions are only allowed on external applications.`);e.mergeExtension()}})}get hotUpgradeManager(){if(!this.#e)this.#e=core_hooks_1.CoreHooks.createHotUpgradeManager(this);return this.#e}get isReady(){return this.#r}setReady(){this.#r=true}get csvChecksumManager(){if(!this.#t)this.#t=core_hooks_1.CoreHooks.createCsvChecksumManager(this);return this.#t}get applicationType(){return this.options.applicationType}#i;get addOnPackagePaths(){const e="true"===process.env.XTREM_USE_MULTI_WORKER,t=process.env.XTREM_WORKER_ID;if(e&&!t)return[];if(this.#i)return this.#i;const a=xtrem_config_1.ConfigManager.current.addOns?.folder,r=fsp.join(process.cwd(),"add-ons"),i=a??r,s=t?fsp.join(i,t):i;logger.info(`Looking for add-ons in: ${s}`);let n=glob.sync("./**/package.json",{cwd:s,realpath:true,absolute:true,ignore:"node_modules/**"}).filter(e=>!/node_modules/.test(e)).map(e=>{const t=require(e);return{name:t.name,dependsOn:Object.keys(t.dependencies),path:fsp.dirname(e)}});n=n.map(e=>({...e,dependsOn:e.dependsOn.filter(e=>n.find(t=>t.name===e))}));const o=(0,xtrem_toposort_1.topoSort)(n);if(this.#i=o.map(e=>e.path),this.#i.forEach(e=>logger.info(`Add-on package will be load from: ${e}`)),this.#i.length>0){const createSymlink=(e,t)=>{if(fs.existsSync(t))fs.rmSync(t,{recursive:true,force:true});logger.info(`Creating symlink  ${t} -> ${e}`),fsExtra.createSymlinkSync(e,t,"junction")},e=fsp.join(process.cwd(),"node_modules");if(fs.existsSync(e))createSymlink(e,fsp.join(s,"node_modules"));o.forEach(e=>{const t=fsp.join(e.path,"node_modules");if(!fs.existsSync(t))fs.mkdirSync(t);e.dependsOn.forEach(e=>{const a=o.find(t=>t.name===e);if(a)createSymlink(a.path,fsp.join(t,a.name))})})}return this.#i}get schemaName(){return this.options.schemaName}set schemaName(e){this.options.schemaName=e}get activities(){return this.activityManager.getActivities()}get serviceOptionsByName(){return this.serviceOptionManager.serviceOptionsByName}findServiceOption(e){const t=this.serviceOptionsByName[e];if(!t)throw new Error(`${e}: invalid service option name`);return t}get startOptions(){if(this._startOptions)return this._startOptions;const e=this.mainPackage.name,t="@sage/xtrem-communication",a="@sage/xtrem-routing",r="@sage/xtrem-scheduler",i="@sage/xtrem-workflow",s="@sage/xtrem-interop";let n=true;const o=xtrem_config_1.ConfigManager.current.storage?.managedExternal,fixServiceDomain=e=>e.startsWith("@")?e:`@sage/xtrem-${e}`;this._startOptions={channels:this.options?.startOptions?.channels||["graphql"],queues:this.options.startOptions?.queues,services:[]};const addService=e=>{if(![a,t,r,i,s].includes(e))n=false;if(!this._startOptions.services.includes(e))this._startOptions.services.push(e)};if(this.options.startOptions?.services?.length)this.options.startOptions.services.map(e=>fixServiceDomain(e)).forEach(e=>addService(e));if(!o&&this._startOptions.channels.includes("routing"))addService(a),addService(r);if(!o&&this._startOptions.channels.includes("listeners"))addService(t),addService(i);if(!o)addService(s);if(o||n)addService(e);return this._startOptions}get servicePackagesStarted(){if(!this._servicePackagesStarted){const e=this.getPackages().filter(e=>{if(this.startOptions.services?.length)return this.startOptions.services.includes(e.name);return true}),t=new Set;e.forEach(e=>{if(t.add(e),e.isMain)e.allDependencies.filter(e=>e.isService).forEach(e=>t.add(e))}),this._servicePackagesStarted=[...t]}return this._servicePackagesStarted}startListeners(e){if(Application.emitter.emit("listen",this),e)e.forEach(e=>{Application.emitter.emit(e,this)});Application.emitter.emit("ready",this)}static limitSqsQueueName(e){if(e.length<=75)return e;return`${e.substring(0,36)}---${e.substring(e.length-36)}`}rawSqsQueueName(e){if("test"===this.applicationType)return`test-${this.name.split("/").pop()}-${e}`;const t=xtrem_config_1.ConfigManager.current.app?.replace(/_/g,"-");if(t&&!e.startsWith(`${t}--`))return`${t}--${e}`;return e}sqsQueueName(e){return Application.limitSqsQueueName(this.rawSqsQueueName(e))}getPluginDependencies(){return{...this._pluginDependencies}}static resetMain(){this.hasInstance=false}getSqlPackageFactories(){if(!this._sqlPackageFactories||"test"===this.options.applicationType)this._sqlPackageFactories=(0,utils_1.sortFactories)(this.getAllFactories().filter(e=>"sql"===e.storage));return this._sqlPackageFactories}get name(){return this.mainPackage.name}get shortName(){return this.name.substring(this.name.lastIndexOf("/")+1)}get packageName(){return this.mainPackage.packageName}get dir(){return this.mainPackage.dir}get tmpDir(){return fsp.join(this.dir,"tmp")}get version(){return this.mainPackage.packageJson.version}get about(){if(!this._about)this._about=package_1.XtremAboutHelper.load(this,this.mainPackage.name);return this._about}get rootAbout(){if(!this._rootAbout)this._rootAbout=package_1.XtremAboutHelper.load(this);return this._rootAbout}checkIfPluginPackage(e){if(e?.xtremPlugin)this._pluginDependencies[e.name]=e.version}validateActivities(){const validateActivity=e=>{const t=this.activities[e];if(""===t.description)throw new Error(`Activity ${e} has no description defined.`);if(0===t.permissions.length)throw new Error(`Activity ${e} has no permissions defined.`);if(t.operationGrants)Object.values(t.operationGrants).forEach(e=>{e.forEach(e=>{(e.on||[()=>t.node]).forEach(t=>{const a=this.getFactoryByConstructor(t());e.operations.forEach(e=>activity_manager_1.ActivityManager.checkOperation(e,a,{throws:true}))})})})};Object.keys(this.activities).forEach(e=>{validateActivity(e)})}getPackages(){return Object.values(this.packageLoader.packagesByName)}get packagesByName(){return this.packageLoader.packagesByName}findPackage(e){const t=this.packagesByName[e];if(!t)throw new xtrem_shared_1.LogicError(`Package not found: ${e}`);return t}resolvePnpmLock(){let e=this.dir;for(;e;){const t=fsp.resolve(e,"pnpm-lock.yaml");if(fs.existsSync(t))return(0,js_yaml_1.load)(fs.readFileSync(t,"utf8"));if(e===fsp.dirname(e))return{};e=fsp.dirname(e)}throw new Error("detection of root directory failed")}getPlatformPackages(){if(this.#a)return this.#a;const e={};this.getPackages().forEach(t=>{e[t.name]=t});const t="development"===xtrem_config_1.ConfigManager.current.deploymentMode,a={},tryGetPackageJson=e=>{try{return package_1.Package.getPackageJson(e)}catch(e){if("MODULE_NOT_FOUND"!==e.code)throw e;return}},scan=(r,i)=>{const s=Object.keys(i.dependencies||{}),n=Object.keys(i.peerDependencies||{}),o=(0,lodash_1.uniq)([...s,...n]);if(o.length)o.filter(e=>e.startsWith("@sage/")).forEach(i=>{if(a[i])return;if(e[i])a[i]=e[i].packageJson,scan(e[i].dir,e[i].packageJson);else{let e=[fsp.join(r,"../..",i),fsp.join(r,"node_modules",i)];if(t)e=e.reverse();const s={};if(e.some(e=>(s.path=e,s.packageJson=tryGetPackageJson(e),null!=s.packageJson)),s.packageJson&&s.path)a[i]=s.packageJson,scan(s.path,s.packageJson)}})};return this.getPackages().forEach(e=>{scan(e.dir,e.packageJson)}),this.#a=Object.values(a).filter(e=>!e.xtrem&&!e.xtremPlugin).map(e=>(0,lodash_1.pick)(e,"name","version")),this.#a}getAllFactories(){return[].concat(...this.getPackages().map(e=>e.factories))}getTableByName(e){const t=this.getSqlPackageFactories().find(t=>t.table?.name===e);if(!t)throw new Error(`Factory '${e}' could not be found.`);return t.table}getFactoryByName(e){return this.factoriesManager.getFactoryByName(e)}tryToGetFactoryByName(e){return this.factoriesManager.tryToGetFactoryByName(e)}getFactoryByConstructor(e){return this.factoriesManager.getFactoryByConstructor(e)}getFactoryByTableName(e){return this.factoriesManager.getFactoryByTableName(e)}tryGetFactoryByTableName(e){try{return this.factoriesManager.getFactoryByTableName(e)}catch(e){return}}findFactoriesUsingDatatype(e){return this.getAllFactories().filter(t=>t.properties.some(t=>t.dataType===e))}isRecordUsed(e,t,a){const r=this.getFactoryByName(a),i=Array.from(new Set(r.referringProperties.map(e=>e.targetFactory.nodeConstructor)));return(0,xtrem_async_helper_1.asyncArray)(i).some(async a=>{const i={_or:r.referringProperties.filter(e=>e.targetFactory.nodeConstructor===a&&true===e.property.isStored).map(t=>({[t.property.name]:{_id:e}}))};return await t.query(a,{filter:i,first:1}).length>0})}getAllNodes(){return this.getAllFactories().map(e=>e.nodeConstructor)}isNodePublished(e){return!!this.getFactoryByConstructor(e).isPublished}getAllSortedFactories(){return(0,utils_1.sortFactories)([...this.getSqlPackageFactories()])}static async dropDbSchema(e){await(new database_sql_context_1.DatabaseSqlContext).dropSchemaIfExists(e)}static async renameSchema(e,t){await(new database_sql_context_1.DatabaseSqlContext).renameSchema(e,t)}static async createDbSchema(e){xtrem_config_1.ConfigManager.load(__dirname),await(new database_sql_context_1.DatabaseSqlContext).createSchemaIfNotExists(e)}async createAdminUser(e,t,a){await this.asRoot.withCommittedContext(e,e=>context_1.Context.localizationManager.createTenantLocale(e,t.locale),{config:xtrem_config_1.ConfigManager.current,locale:t.locale,description:()=>`Create locale for tenant ${e}`}),await this.asRoot.withCommittedContext(e,e=>context_1.Context.accessRightsManager.createAdminUser(e,t,a),{description:()=>`Create admin user for tenant ${e}`})}async getGraphQLSchema(e){const t=e?(await e.getActivePackageNames()).join():"all";if(this.graphqlSchemas[t])return this.graphqlSchemas[t];return this.graphqlSchemaFunnel(async()=>{if(!this.graphqlSchemas[t])this.graphqlSchemas[t]=await schema_builder_1.SchemaBuilder.getSchema(this,e);return this.graphqlSchemas[t]})}getPackageOfNodeConstructor(e){const t=this.getFactoryByConstructor(e);if(!t.package)throw new Error(`${e.name}: application not available`);return t.package}async withContext(e,t,a){const r={config:xtrem_config_1.ConfigManager.current,...a};if(!r.isolationLevel)r.isolationLevel="low";if(!(r.userEmail||r.auth?.login||"admin-tool"!==this.applicationType&&"test"!==this.applicationType||"ServerResponse"===r.response?.constructor?.name))r.userEmail=context_1.rootUserEmail;const i=await context_1.Context.create(this,r,e);if(!xtrem_config_1.ConfigManager.current.storage?.managedExternal)await collation_cache_1.CollationCache.init(i);try{if(r.isReadonly&&"low"===r.isolationLevel)return await t(i);return await i.withChildContext(t,r)}finally{await i.close()}}withCommittedContext(e,t,a){return this.withContext(e,t,{...a})}withUncommittedContext(e,t,a){return this.withContext(e,t,{...a,noCommit:true})}withReadonlyContext(e,t,a){return this.withContext(e,t,{...a,isReadonly:true})}get asRoot(){return new WithContextFrame(this,{userEmail:context_1.rootUserEmail})}createContextForDdl(e,t){return this.withContext(null,e,{...t,isReadonly:true})}initFactoryCacheLogs(){const logFactoryCacheCounters=()=>{this.getAllFactories().filter(e=>e.cache.counters.totalQueries>0).sort((e,t)=>t.cache.counters.totalMisses-e.cache.counters.totalMisses).slice(0,100).forEach(e=>e.cache.postToNewRelic())};setInterval(logFactoryCacheCounters,6e4),process.on("exit",logFactoryCacheCounters)}clearGlobalCache(){this.globalCache.clearAll()}invalidateGlobalCache(e){return this.globalCache.invalidateAllCategories(e)}async verifySqlConversions(){let e=0;return await(0,xtrem_async_helper_1.asyncArray)(this.getAllFactories()).forEach(t=>(0,xtrem_async_helper_1.asyncArray)(t.properties).forEach(async t=>{e+=await t.testSqlConversions()})),e}}exports.Application=Application;class WithContextFrame{constructor(e,t){this.application=e,this.frameOptions=t}withCommittedContext(e,t,a){return this.application.withCommittedContext(e,t,{...a,...this.frameOptions})}withUncommittedContext(e,t,a){return this.application.withUncommittedContext(e,t,{...a,...this.frameOptions})}withReadonlyContext(e,t,a){return this.application.withReadonlyContext(e,t,{...a,...this.frameOptions})}}function main(e){(async()=>{await e(),process.exit(0)})().catch(e=>{console.error(e),process.exit(1)})}exports.main=main;
//# sourceMappingURL=application.js.map