/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ApplicationCreateSqlSchema=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),loggers_1=require("../runtime/loggers"),read_table_sql_context_1=require("../sql/sql-context/read-table-sql-context");class ApplicationCreateSqlSchema{static async verifyAndCreateTables(e){await(0,xtrem_async_helper_1.asyncArray)(e.application.getAllFactories()).forEach(a=>a.verifyTable(e)),await this.createTables(e,[])}static async createTables(e,a){const t=await(0,xtrem_async_helper_1.asyncArray)(e.application.getSqlPackageFactories()).filter(async a=>!await a.table.tableExists(e)).toArray();await(0,xtrem_async_helper_1.asyncArray)(t).forEach(async a=>{loggers_1.loggers.application.info(`${a.name}: Creating new table: ${a.table.name}`),await a.table.createTable(e,{skipForeignKeys:true,skipDrop:true})});(await this.addForeignKeys(e,t.concat(a))).forEach((e,a)=>{a.table.foreignKeys=e})}static async addForeignKeys(e,a){const t=loggers_1.loggers.application.info(`Creating foreign keys (${a.length} tables)`),r=new Map;if(0===a.length)return r;let i=0;const s=await new read_table_sql_context_1.ReadTableSqlContext(e.application).readTableDefinitions(a.map(e=>e.table.name),{skipColumns:true,skipIndexes:true,skipSecurity:true,skipSequences:true});return await(0,xtrem_async_helper_1.asyncArray)(a).forEach(async a=>{const t=a.table.foreignKeys||[],shouldAddForeignKey=e=>!a.table.foreignKeys?.find(a=>a.columnNames.includes(e.columnName));if(a.properties.filter(e=>e.isStored&&e.isReferenceProperty()&&!e.isInherited).forEach(e=>{if(shouldAddForeignKey(e)){const r=e.targetFactory,i=a.createForeignKey(r,e);if(i)t.push(i)}}),t.length>0){const n=s[a.table.name];await(0,xtrem_async_helper_1.asyncArray)(t).forEach(async t=>{if(!await a.table.getMatchingForeignKeyDefinition(e,t,n))loggers_1.loggers.application.verbose(()=>`Adding foreign key constraints to table: ${a.table.name} (${t.targetTable})(${t.name})`),i+=1,await a.table.addForeignKey(e,t,n)}),r.set(a,t)}}),t?.success(`Created ${i} foreign keys for ${a.length} factories`),r}}exports.ApplicationCreateSqlSchema=ApplicationCreateSqlSchema;
//# sourceMappingURL=application-create-sql-schema.js.map