/** @module @sage/xtrem-x3-sql */
export interface Dict<T> {
    [name: string]: T;
}
export interface PoolReaderOptions {
}
export interface SqlExecuteOptions {
    decimalColumns?: string[];
    fetchInfo?: any;
    outputVars?: SqlColumnDesc[];
    fetchTypeHandler?: (metaData: any) => any;
}
export interface SqlReadTableSchemaOptions {
    skipColumns?: boolean;
    skipSecurity?: boolean;
    skipIndexes?: boolean;
    skipSequences?: boolean;
    $diagnoses?: {
        $severity: string;
        $message: string;
    }[];
}
export interface SqlCreateTableOptions {
    skipCommands?: boolean;
    onlyIndexes?: boolean;
    skipDrop?: boolean;
    skipCreate?: boolean;
    skipSequences?: boolean;
    skipIndexes?: boolean;
    skipTriggers?: boolean;
    skipGrant?: boolean;
}
export interface SqlColumnDesc {
    name?: string;
    type?: string;
    typtyp?: number;
}
export interface SqlColumnInfo {
    name?: string;
    type?: number;
    typtyp?: number;
}
export type SqlColumnsDesc = Dict<SqlColumnDesc>;
export type ColumnTypeName = 'enum' | 'short' | 'integer' | 'decimal' | 'float' | 'double' | 'string' | 'date' | 'binaryStream' | 'textStream' | 'uuid' | 'datetime' | 'boolean' | 'byte' | 'binary';
export interface ColumnDefinition {
    name: string;
    maxLength?: number;
    isNullable?: boolean;
    default?: any;
    colType?: string;
    type?: ColumnTypeName;
    precision?: number;
    scale?: number;
    useFloatingPointFormat?: boolean;
    loadPath?: string;
    friendlyName?: string;
    repeat?: number;
}
export interface Hint {
    tname: string;
    abbrev: string;
    revert: boolean;
    name?: string;
    nohint?: boolean;
}
export interface Record {
    [name: string]: any;
}
export type TypedRecord<T> = Record & T;
export interface IndexColumn {
    name: string;
    ascending?: boolean;
}
export interface IndexDefinition {
    name: string;
    isUnique: boolean;
    columns: IndexColumn[];
    isPrimaryKey?: boolean;
}
export interface TableDefinition {
    schemaName: string;
    tableName: string;
    columns?: ColumnDefinition[];
    indexes?: IndexDefinition[];
    isOpenAccess?: boolean;
    sequence?: number;
    lastUpdate?: Date;
    friendlyName?: string;
}
export interface TableFilter {
    key: string;
    operator: string;
    value: any;
}
export interface PoolConfig {
    driver: string;
    user: string;
    password?: string;
    connectString?: string;
    hostname?: string;
    port?: number;
    database?: string;
    trace?: (...args: any[]) => void;
    requestTimeout?: number;
    collation?: string;
    databaseDirs?: string[];
    databaseLayers?: string[];
    privilege?: number;
    usePool?: boolean;
    poolSize?: number;
    folderName?: string;
    encrypt?: boolean;
    trustServerCertificate?: boolean;
    connectionMaxRetries?: number;
    connectionRetryMillis?: number;
}
export interface BasePool {
}
//# sourceMappingURL=types.d.ts.map