/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Pool=void 0;const xtrem_core_1=require("@sage/xtrem-core");class Pool{constructor(e,t){this.logger=t,this.connections=[],this.initialCounters={alloc:0,used:0,discarded:0,warned:5},this.counters={...this.initialCounters},this._user=e.user,this.usePool=!!e.usePool,this.config=e}get user(){return this._user}asString(e){return`CAST(${e} AS varchar)`}async withConnection(e){const t=await this.allocConnection();try{return await e(t)}finally{await this.releaseConnection(t)}}async closeConnections(){await(0,xtrem_core_1.asyncArray)(this.connections).forEach(async e=>{e&&await this.closeConnection(e)}),this.connections=[],this.counters={...this.initialCounters}}async allocConnection(){const e=this.config.connectionMaxRetries||3,t=this.config.connectionRetryMillis||15e3;let n="";for(let r=1;r<=e;r+=1)try{let e=this.connections.pop();if(e=this.checkConnection(e),!e)this.logger?.debug(()=>`Connections in pool ${this.connections.length}`),e=await this.createConnection();return e}catch(o){this.logger&&this.logger.error(`Retry: try number ${r}/${e}: Error \r\n${JSON.stringify(o)}`),n+=`${o?.response?.data?.error||o.message||JSON.stringify(o)}\r\n\r\n`,await new Promise(e=>{setTimeout(e,t)})}throw new xtrem_core_1.SystemError(n)}async releaseConnection(e,t){if(this.counters.used--,t)this.logger&&this.logger.error(t.stack),await this.closeConnection(e);else if(this.usePool&&this.connections.length<=(this.config.poolSize||10))this.connections.push(e);else await this.closeConnection(e);return}quote(e){return`'${e.replace(/'/g,"''")}'`}sanitizeSqlPattern(e,t){return e.replace(/(\\.|\.\*?|%|_|\*)/g,(e,n)=>{if("\\"===n[0])return"$"===n[1]?"$$":n[1];if("."===n[0])return 2===n.length?"%":"_";if("%"===n||"_"===n)return`$${n}`;throw new Error(`${t}: regular expression cannot be converted to SQL: * must be escaped`)})}regexToSql(e){const t="^"===e[0];let n=t?e.substring(1):e;const r=/(^|[^\\])(\\\\)*\$$/.test(e);n=r?n.substring(0,n.length-1):n;const o=/(?:^|[^\\])([\^\$\+\?\|\(\)\{\}\[\]]|\\\w)/.exec(n);if(o)throw new Error(`${e}: regular expression cannot be converted to SQL: ${o[1]} must be escaped`);let s=this.sanitizeSqlPattern(n,e);if(!t)s=`%${s}`;if(!r)s=`${s}%`;return s}cast(e,t){return`CAST(${e} AS ${t})`}createTableReader(e,t){if(!e.columns)throw new Error("Must call readTableSchema() before.");let n,r=`SELECT ${e.columns.map(e=>`T.${e.name}`).join(",")} FROM ${this.getFullTableDefName(e)} T`;if(t)n=[],t.forEach((e,t)=>{if(0===t)r+=" WHERE ";else r+=" AND ";r+=`(T.${e.key} ${e.operator} ${this.param(t)})`,n.push(e.value)});if(e.indexes){const t=e.indexes.filter(e=>e.isUnique)[0];if(t)t.columns.forEach((e,t)=>{if(0===t)r+=" ORDER BY ";else r+=", ";r+=`T.${e.name}`})}return this.reader(r,n)}}exports.Pool=Pool;
//# sourceMappingURL=pool.js.map