import type { RootMenuItem } from '@sage/xtrem-shared';
import type { integration } from '@sage/xtrem-ui';
import type { TenantDetails } from '../service/tenants-service';
import type { AppThunkDispatch } from './action-types';
import { ActionType } from './action-types';
import type { XtremStandaloneState } from './state';
declare global {
    interface Window {
        GmsChatUi: any;
    }
}
export declare const setPath: (path: string) => {
    type: ActionType;
    value: string;
};
export declare const setSitemap: (sitemap: RootMenuItem[]) => {
    type: ActionType;
    value: RootMenuItem[];
};
export declare const setNavigationOpen: (isOpen: boolean) => {
    type: ActionType;
    value: boolean;
};
export declare const setChatbotOpen: (isOpen: boolean) => {
    type: ActionType;
    value: boolean;
};
export declare const setNotificationCenterOpen: (isOpen: boolean) => {
    type: ActionType;
    value: boolean;
};
export declare const setMenuItems: (menuItems: integration.Menu[]) => {
    type: ActionType;
    value: integration.Menu[];
};
export declare const setTenantsList: (tenantsList: TenantDetails[]) => {
    type: ActionType;
    value: TenantDetails[];
};
export declare const actionStub: () => never;
export declare const onDirtyStatusChange: (isApplicationDirty: boolean, preNavigationConfirmation: () => Promise<void>) => {
    type: ActionType;
    value: {
        isApplicationDirty: boolean;
        preNavigationConfirmation: () => Promise<void>;
    };
};
export declare const onInternalNavigationChange: (path: string, doDirtyCheck?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremStandaloneState) => Promise<void>;
export declare const goHome: () => (dispatch: AppThunkDispatch, getState: () => XtremStandaloneState) => Promise<void>;
export declare const updateNavStateBasedOnLocation: () => (dispatch: AppThunkDispatch, getState: () => XtremStandaloneState) => void;
export declare const init: () => (dispatch: AppThunkDispatch) => Promise<void>;
export declare const setPageTitle: (title: string | null) => (dispatch: AppThunkDispatch, getState: () => XtremStandaloneState) => {
    type: ActionType.SetPageTitle;
    value: string;
};
export declare const refreshNotifications: () => (dispatch: AppThunkDispatch, getState: () => XtremStandaloneState) => Promise<void>;
export declare const markNotificationAsRead: (notificationId: string) => (_: AppThunkDispatch, getState: () => XtremStandaloneState) => Promise<void>;
export declare const markAllNotificationsAsRead: () => (_: AppThunkDispatch, getState: () => XtremStandaloneState) => Promise<void>;
export declare const markNotificationAsUnread: (notificationId: string) => (_: AppThunkDispatch, getState: () => XtremStandaloneState) => Promise<void>;
export declare const deleteNotification: (notificationId: string) => (_: AppThunkDispatch, getState: () => XtremStandaloneState) => Promise<void>;
//# sourceMappingURL=actions.d.ts.map