import { integration } from '@sage/xtrem-ui';
import * as React from 'react';
import type { UserDetails } from './service/auth-service';
import type { Dict, StandaloneConfig } from '@sage/xtrem-shared';
import './style.scss';
export interface XtremStandaloneProps {
    path: string;
    user: UserDetails | null;
    loginService: string | null;
    updateNavStateBasedOnLocation: () => void;
    init: () => void;
    onInternalNavigationChange: (path: string, doDirtyCheck: boolean) => Promise<void>;
    setPageTitle: (newTitle: string) => void;
    setMenuItems: (menuItems: integration.Menu[]) => void;
    onDirtyStatusChange: (isApplicationDirty: boolean, preNavigationConfirmation: () => Promise<void>) => void;
    config: StandaloneConfig | null;
    isExtraSmall: boolean;
    translations: Dict<string>;
    isNavigationOpen: boolean;
}
export declare class XtremStandalone extends React.Component<XtremStandaloneProps, {
    removeXtremUi?: boolean;
}> {
    private intervalRef;
    private readonly iframeRef;
    private readonly xtremUiRef;
    private readonly appContext;
    constructor(props: XtremStandaloneProps);
    componentDidMount(): void;
    componentDidUpdate(): void;
    componentWillUnmount(): void;
    private readonly checkAuthTokenState;
    private readonly onTelemetryEvent;
    private readonly onUserLogout;
    private readonly onUserUpdate;
    private readonly onUserChangeLocale;
    render(): React.JSX.Element;
}
export declare const ConnectedXtremStandaloneComponent: import("react-redux").ConnectedComponent<typeof XtremStandalone, {
    ref?: React.LegacyRef<XtremStandalone> | undefined;
    key?: React.Key | null | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=index.d.ts.map