import * as React from 'react';
import { localize } from '../../service/standalone-i18n-service';
export function MyProfile({ user, translations }) {
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: "xe-profile-photo-container" }, user?.photo ? (React.createElement("img", { src: `data:image;base64,${user.photo}`, className: "xe-profile-photo" })) : (React.createElement("div", { className: "xe-profile-picture-large xe-profile-picture-empty" }))),
        React.createElement("div", { className: "xe-profile-text-container" },
            React.createElement("div", { className: "xe-profile-text-hello" }, localize('@sage/xtrem-standalone/hello', 'Hello', {}, translations, user?.locale ?? undefined)),
            React.createElement("div", { className: "xe-profile-text-name" }, user?.firstName ?? null),
            React.createElement("div", { className: "xe-profile-text-name" }, user?.lastName ?? null),
            React.createElement("div", { className: "xe-profile-text-email" }, user?.email ?? null))));
}
MyProfile.displayName = 'MyProfile';
//# sourceMappingURL=my-profile.js.map