import Button from 'carbon-react/esm/components/button';
import { RadioButton, RadioButtonGroup } from 'carbon-react/esm/components/radio-button';
import * as React from 'react';
import { localize } from '../../service/standalone-i18n-service';
import { getSupportedLocales } from './get-supported-locales';
export function LanguageSelector({ user, translations, localeOnChange }) {
    const [selectedLocale, setSelectedLocale] = React.useState(user?.locale || null);
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: "xe-profile-language-selector-radio-button-container", "data-testid": "xe-profile-language-selector" },
            React.createElement(RadioButtonGroup, { "data-testid": "xe-profile-language-selector-locale-selection", name: "locales", onChange: e => setSelectedLocale(e.target.value), value: selectedLocale ?? undefined }, getSupportedLocales(user, translations).map(locale => (React.createElement(RadioButton, { color: "colorsYang100", className: "xe-profile-language-selector-radio-button", "data-testid": `xe-profile-language-selector-locale-selection-${locale.key}`, fieldHelp: locale.key, fieldHelpInline: true, key: locale.key, label: locale.text, value: locale.key }))))),
        React.createElement("div", { className: "xe-profile-language-apply" },
            React.createElement(Button, { buttonType: "primary", "data-testid": "xe-profile-language-selector-apply", onClick: () => localeOnChange(selectedLocale) }, localize('@sage/xtrem-standalone/apply-locale-selection', 'Apply', {}, translations, user?.locale || undefined)))));
}
;
LanguageSelector.displayName = 'LanguageSelector';
//# sourceMappingURL=language-selector.js.map