import React, { useEffect, useState } from 'react';
import { connect } from 'react-redux';
import { NotificationPreviewCard } from './notification-preview-card';
import './notification-center.scss';
export function NotificationPreviews({ notifications }) {
    const [previews, setPreviews] = useState(() => {
        const initPreviews = notifications
            .filter((notification) => {
            return notification.shouldDisplayToast === true;
        })
            .map((notification) => {
            // INFO: This is a hack to ensure that the notification can be tested.
            return { ...notification, isStale: process.env.NODE_ENV !== 'test' };
        });
        return initPreviews;
    });
    const onClosePreview = (id) => () => {
        setPreviews((state) => {
            return state.map((preview) => {
                return preview._id === id ? { ...preview, isStale: true } : preview;
            });
        });
    };
    useEffect(() => {
        setPreviews((prevPreviews) => {
            const currPreviews = notifications
                .filter((notification) => {
                return notification.shouldDisplayToast === true;
            })
                .map((notification) => {
                const match = prevPreviews.find((preview) => {
                    return preview._id === notification._id;
                });
                return typeof match === 'undefined' ? { ...notification, isStale: false } : match;
            });
            return currPreviews;
        });
    }, [notifications]);
    return (React.createElement("div", { className: "xe-notification-preview-wrapper", "data-testid": "xe-notification-preview-wrapper" }, previews.map((preview) => (React.createElement(NotificationPreviewCard, { key: preview._id, preview: preview, onClose: onClosePreview(preview._id) })))));
}
const mapStateToProps = (state) => ({
    notifications: state.notifications,
});
export const ConnectedNotificationPreviews = connect(mapStateToProps)(NotificationPreviews);
//# sourceMappingURL=notification-previews.js.map