import React, { useEffect } from 'react';
import { ConnectedNotificationCenterItem } from './notification-center-item';
export const NOTIFICATION_PREVIEW_DURATAION = 7_000;
export function NotificationPreviewCard({ onClose, preview, }) {
    useEffect(() => {
        let timeoutId;
        if (!preview.isStale) {
            timeoutId = setTimeout(() => {
                onClose();
            }, NOTIFICATION_PREVIEW_DURATAION);
        }
        return () => {
            if (timeoutId) {
                clearTimeout(timeoutId);
            }
        };
        // INFO: Dependencies are ommitted on purpose to ensure notification timers don't interfere with
        //       each others.
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    return !preview.shouldDisplayToast || preview.isStale ? null : (React.createElement("div", { "aria-live": "polite", "aria-relevant": "additions", className: "xe-notification-card-preview", "data-testid": "xe-notification-card-preview", role: "status" },
        React.createElement(ConnectedNotificationCenterItem, { id: preview._id, onClose: onClose })));
}
//# sourceMappingURL=notification-preview-card.js.map