import { sortBy } from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import * as actions from '../standalone-redux/actions';
import './mobile-navigation.scss';
import { SitemapSubMenu } from './sitemap-submenu';
export function MobileNavigation(props) {
    if (!props.isNavigationOpen || !props.isExtraSmall) {
        return null;
    }
    const onSelectLink = (path) => (event) => {
        event.preventDefault();
        props.setNavigationOpen(false);
        props.onInternalNavigationChange(path);
    };
    return (React.createElement("nav", { className: "xe-navigation-mobile", "aria-label": "Navigation menu", "data-testid": "xe-navigation-menu" },
        React.createElement("ul", { className: "xe-navigation-secondary-body-list" }, sortBy(props.sitemap, ['priority', 'title']).map(p => (React.createElement(SitemapSubMenu, { key: p.id, sitemapEntry: p, level: 1, onSelectLink: onSelectLink, path: props.path }))))));
}
const mapStateToProps = (state) => ({
    path: state.path,
    sitemap: state.sitemap,
    isNavigationOpen: state.isNavigationOpen,
    isExtraSmall: state.browser.is.xs,
    onInternalNavigationChange: actions.actionStub,
    setNavigationOpen: actions.actionStub,
});
const mapDispatchToProps = (dispatch) => ({
    onInternalNavigationChange: (path) => dispatch(actions.onInternalNavigationChange(path, true)),
    setNavigationOpen: (isOpen) => dispatch(actions.setNavigationOpen(isOpen)),
});
// tslint:disable-next-line:variable-name
export const ConnectedMobileNavigation = connect(mapStateToProps, mapDispatchToProps)(MobileNavigation);
//# sourceMappingURL=mobile-navigation.js.map