import * as ui from '@sage/xtrem-ui';

/**
 * Display a dialog typed info with given page instance, dialog level, message and optionals options and title
 * @param pageInstance
 * @param dialogLevel must be error, info, success or warn.
 * @param title current title
 * @param message message to display.
 * @param options optional options.
 * @returns
 */
export async function dialogMessage(
    pageInstance: any,
    dialogLevel: ui.dialogs.DialogLevel,
    title: string,
    message: string,
    options?: ui.dialogs.DialogOptions,
): Promise<boolean> {
    return (await pageInstance.$.dialog
        .message(dialogLevel, title, message, options)
        .then(() => true)
        .catch(() => false)) as boolean;
}

/**
 * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title
 * @param pageInstance
 * @param dialogLevel must be error, info, success or warn.
 * @param title current title
 * @param message message to display.
 * @param options optional options.
 * @returns
 */
export async function dialogConfirmation(
    pageInstance: any,
    dialogLevel: ui.dialogs.DialogLevel,
    title: string,
    message: string,
    options?: ui.dialogs.DialogOptions,
): Promise<boolean> {
    return (await pageInstance.$.dialog
        .confirmation(dialogLevel, title, message, options)
        .then(() => true)
        .catch(() => false)) as boolean;
}
