// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/index.d.ts
declare module '@sage/x3-master-data/index' {
	export * from '@sage/x3-master-data/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/index.d.ts
declare module '@sage/x3-master-data/lib/index' {
	export * as enums from '@sage/x3-master-data/lib/enums/index';
	export * as functions from '@sage/x3-master-data/lib/functions/index';
	export * as nodeExtensions from '@sage/x3-master-data/lib/node-extensions/index';
	export * as nodes from '@sage/x3-master-data/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-master-data/lib/service-options/index';
	export * as sharedFunctions from '@sage/x3-master-data/lib/shared-functions/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/shared-functions/index.d.ts
declare module '@sage/x3-master-data/lib/shared-functions/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/service-options/index.d.ts
declare module '@sage/x3-master-data/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/weekly-structure.d.ts
declare module '@sage/x3-master-data/lib/nodes/weekly-structure' {
	import { Node, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class WeeklyStructure extends Node {
	    readonly code: Promise<string>;
	    readonly standardCapicity: Promise<decimal | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly weeklyCapacity: Promise<decimal | null>;
	    readonly weeklyStructureDailyCapacity: Collection<sageX3MasterData.nodes.WeeklyStructureWeeklyStructureDailyCapacity>;
	}
	//# sourceMappingURL=weekly-structure.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/weekly-structure-weekly-structure-daily-capacity.d.ts
declare module '@sage/x3-master-data/lib/nodes/weekly-structure-weekly-structure-daily-capacity' {
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class WeeklyStructureWeeklyStructureDailyCapacity extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.WeeklyStructure>;
	    readonly dailyCapicity: Promise<decimal | null>;
	    readonly timeTableSchema: Reference<sageX3MasterData.nodes.TimeTableSchema | null>;
	    readonly capacityDayName: Promise<string>;
	}
	//# sourceMappingURL=weekly-structure-weekly-structure-daily-capacity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/unit-of-measure.d.ts
declare module '@sage/x3-master-data/lib/nodes/unit-of-measure' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	export class UnitOfMeasure extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly numberOfDecimals: Promise<integer | null>;
	    readonly unitType: Promise<sageX3System.enums.UnitType | null>;
	    readonly codeCeeOnu: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=unit-of-measure.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/unavailable-periods.d.ts
declare module '@sage/x3-master-data/lib/nodes/unavailable-periods' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class UnavailablePeriods extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly siteCompanyGroup: Reference<sageX3Structure.nodes.SiteGroupings | null>;
	    readonly lines: Collection<sageX3MasterData.nodes.UnavailablePeriodsLines>;
	}
	//# sourceMappingURL=unavailable-periods.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/unavailable-periods-lines.d.ts
declare module '@sage/x3-master-data/lib/nodes/unavailable-periods-lines' {
	import { Node, integer, Reference, date } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class UnavailablePeriodsLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.UnavailablePeriods>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly dateDescription: Promise<string>;
	}
	//# sourceMappingURL=unavailable-periods-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/transit-area.d.ts
declare module '@sage/x3-master-data/lib/nodes/transit-area' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class TransitArea extends Node {
	    readonly code: Promise<string>;
	    readonly placeType: Promise<sageX3MasterData.enums.PlaceType>;
	    readonly longDescription: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly releaseTime: Promise<integer>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly supplier: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly transitAreaAddress: Reference<sageX3MasterData.nodes.TransitAreaAddress | null>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=transit-area.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/transit-area-address.d.ts
declare module '@sage/x3-master-data/lib/nodes/transit-area-address' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class TransitAreaAddress extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly transitArea: Reference<sageX3MasterData.nodes.TransitArea | null>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly defaultBankId: Promise<string>;
	    readonly isDefault: Promise<boolean>;
	    readonly zipCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly state: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly website: Promise<string>;
	    readonly externalIdentifier: Promise<string>;
	    readonly addressEmails: Collection<sageX3MasterData.nodes.TransitAreaAddressAddressEmails>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.TransitAreaAddressAddressLines>;
	    readonly addressPhoneNumbers: Collection<sageX3MasterData.nodes.TransitAreaAddressAddressPhoneNumbers>;
	}
	//# sourceMappingURL=transit-area-address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/transit-area-address-address-phone-numbers.d.ts
declare module '@sage/x3-master-data/lib/nodes/transit-area-address-address-phone-numbers' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class TransitAreaAddressAddressPhoneNumbers extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly transitArea: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.TransitAreaAddress>;
	    readonly addressPhoneNumber: Promise<string>;
	}
	//# sourceMappingURL=transit-area-address-address-phone-numbers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/transit-area-address-address-lines.d.ts
declare module '@sage/x3-master-data/lib/nodes/transit-area-address-address-lines' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class TransitAreaAddressAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly transitArea: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.TransitAreaAddress>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=transit-area-address-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/transit-area-address-address-emails.d.ts
declare module '@sage/x3-master-data/lib/nodes/transit-area-address-address-emails' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class TransitAreaAddressAddressEmails extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly transitArea: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.TransitAreaAddress>;
	    readonly addressEmail: Promise<string>;
	}
	//# sourceMappingURL=transit-area-address-address-emails.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/time-table-schema.d.ts
declare module '@sage/x3-master-data/lib/nodes/time-table-schema' {
	import { Node, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class TimeTableSchema extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly times: Collection<sageX3MasterData.nodes.TimeTableSchemaTimes>;
	}
	//# sourceMappingURL=time-table-schema.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/time-table-schema-times.d.ts
declare module '@sage/x3-master-data/lib/nodes/time-table-schema-times' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class TimeTableSchemaTimes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.TimeTableSchema>;
	    readonly startTime: Promise<string>;
	    readonly endTime: Promise<string>;
	}
	//# sourceMappingURL=time-table-schema-times.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/technical-sheet.d.ts
declare module '@sage/x3-master-data/lib/nodes/technical-sheet' {
	import { Node, integer } from '@sage/xtrem-core';
	export class TechnicalSheet extends Node {
	    readonly technicalSheet: Promise<string>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly sequence: Promise<integer | null>;
	}
	//# sourceMappingURL=technical-sheet.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/supplier.d.ts
declare module '@sage/x3-master-data/lib/nodes/supplier' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, decimal, date, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class Supplier extends Node {
	    readonly code: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly category: Reference<sageX3MasterData.nodes.SupplierCategory | null>;
	    readonly payToBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly payToBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly groupSupplier: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly riskSupplier: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly ourCustomerNumberForSupplier: Promise<string>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly defaultContact: Reference<sageX3MasterData.nodes.SupplierContact | null>;
	    readonly location: Promise<string>;
	    readonly supplierABCClass: Promise<sageX3MasterData.enums.ProductAbcClass | null>;
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
	    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
	    readonly addressByDefault: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly isMultiLineOrder: Promise<boolean>;
	    readonly purchaseOrderTextKey: Promise<string>;
	    readonly returnOrderTextKey: Promise<string>;
	    readonly leadTimeRankingCoefficient: Promise<decimal | null>;
	    readonly priceRankingCoefficient: Promise<decimal | null>;
	    readonly qualityRankingCoefficient: Promise<decimal | null>;
	    readonly quantityRankingCoefficient: Promise<decimal | null>;
	    readonly freeRankingCoefficient: Promise<decimal | null>;
	    readonly leadTimeRanking: Promise<decimal | null>;
	    readonly priceRanking: Promise<decimal | null>;
	    readonly qualityRanking: Promise<decimal | null>;
	    readonly quantityRanking: Promise<decimal | null>;
	    readonly freeRanking: Promise<decimal | null>;
	    readonly totalRanking: Promise<decimal | null>;
	    readonly creditControl: Promise<sageX3MasterData.enums.WorkInProgressControl | null>;
	    readonly intrastatIncreaseCoefficient: Promise<decimal | null>;
	    readonly mustRemindDelivery: Promise<boolean>;
	    readonly mustRemindAcknowledgment: Promise<boolean>;
	    readonly isDas2Submitted: Promise<boolean>;
	    readonly isActive: Promise<boolean>;
	    readonly isPaymentHeld: Promise<boolean>;
	    readonly mustPrintOrderForm: Promise<boolean>;
	    readonly mustPrintReceiptNote: Promise<boolean>;
	    readonly mustPrintReturnSlip: Promise<boolean>;
	    readonly ourCustomerNameForSupplier: Promise<string>;
	    readonly is281Submitted: Promise<boolean>;
	    readonly amountType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
	    readonly isCashVat: Promise<boolean>;
	    readonly cashVatDeadline: Promise<date | null>;
	    readonly selfBillingCode: Promise<string>;
	    readonly rexNumber: Promise<string>;
	    readonly hasNoWhiteListVerification: Promise<boolean>;
	    readonly isElectronicInvoicingAllowed: Promise<boolean>;
	    readonly contact: Reference<sageX3MasterData.nodes.SupplierContact | null>;
	    readonly startDateForElectronicInvoice: Promise<date | null>;
	    readonly addresses: Collection<sageX3MasterData.nodes.SupplierAddress>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly contacts: Collection<sageX3MasterData.nodes.SupplierContact>;
	    readonly purchaseOrderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly returnOrderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly acronym: Promise<string>;
	    readonly businessPartnerSite: Reference<sageX3System.nodes.Site | null>;
	    readonly cfonbPaymentMethod: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly companyName1: Promise<string>;
	    readonly companyName2: Promise<string>;
	    readonly companyNames: Collection<sageX3MasterData.nodes.BusinessPartnerCompanyNames>;
	    readonly consolidationCode: Promise<string>;
	    readonly consolidationGroup: Reference<sageX3Structure.nodes.SiteGroupings | null>;
	    readonly consolidationPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly customerOrSupplierOriginCategory: Promise<string>;
	    readonly documentType: Promise<sageX3MasterData.enums.DocumentType | null>;
	    readonly economicOperatorRegistrationAndIdNumber: Promise<string>;
	    readonly europeanUnionVatNumber: Promise<string>;
	    readonly fiscalCode: Promise<string>;
	    readonly isCashExcluded: Promise<boolean>;
	    readonly isIntersite: Promise<boolean>;
	    readonly isMailingProhibited: Promise<boolean>;
	    readonly isPhysicalPerson: Promise<boolean>;
	    readonly isPublicSector: Promise<boolean>;
	    readonly isServiceCaller: Promise<boolean>;
	    readonly isServiceSupplier: Promise<boolean>;
	    readonly italianTaxNumber: Promise<string>;
	    readonly language: Reference<sageX3System.nodes.Language>;
	    readonly nonResidentAccount: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly purchaseOrderText: Promise<TextStream>;
	    readonly registrationNumber: Promise<string>;
	    readonly relatedCompany: Promise<sageX3MasterData.enums.RelatedCompanySettings | null>;
	    readonly reportAccessCode: Reference<sageX3System.nodes.Access | null>;
	    readonly returnOrderText: Promise<TextStream>;
	    readonly shortCompanyName: Promise<string>;
	    readonly siteIdentificationNumber: Promise<string>;
	    readonly standardIndustrialClassificationCode: Promise<string>;
	    readonly vatNumber: Promise<string>;
	}
	//# sourceMappingURL=supplier.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/supplier-product.d.ts
declare module '@sage/x3-master-data/lib/nodes/supplier-product' {
	import { Node, Reference, integer, decimal, TextStream } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SupplierProduct extends Node {
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly supplier: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly priority: Promise<integer | null>;
	    readonly supplierProduct: Promise<string>;
	    readonly supplierProductDescription: Promise<string>;
	    readonly supplierUpc: Promise<string>;
	    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly purchaseUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly packingUnitToPurchaseUnitConversionFactor: Promise<decimal | null>;
	    readonly euStatisticsIncrease: Promise<decimal | null>;
	    readonly minimumPurchaseQuantity: Promise<decimal | null>;
	    readonly landingCostCoefficient: Promise<decimal | null>;
	    readonly fixedCostPerUnit: Promise<decimal | null>;
	    readonly qualityRank: Promise<integer | null>;
	    readonly qualityControlManagementMode: Promise<sageX3MasterData.enums.SubjectToControl | null>;
	    readonly isBackToBackOrder: Promise<boolean>;
	    readonly purchasingTextKey: Promise<string>;
	    readonly configurationJournal: Promise<string>;
	    readonly subcontractLeadTime: Promise<integer | null>;
	    readonly qualityControlFrequency: Promise<integer | null>;
	    readonly qualityControlNumberEntries: Promise<integer | null>;
	    readonly qualityProcessIdFrequency: Promise<integer | null>;
	    readonly qualityProcessIdEntries: Promise<integer | null>;
	    readonly isVersionPreloaded: Promise<boolean>;
	    readonly text1004082: Promise<boolean>;
	    readonly text1004085: Promise<boolean>;
	    readonly purchasingTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly purchasingText: Promise<TextStream>;
	}
	//# sourceMappingURL=supplier-product.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/supplier-contact.d.ts
declare module '@sage/x3-master-data/lib/nodes/supplier-contact' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection, date } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SupplierContact extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly supplier: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly code: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly position: Promise<sageX3MasterData.enums.FunctionContact | null>;
	    readonly department: Promise<string>;
	    readonly role: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly defaultAddress: Promise<string>;
	    readonly landline: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly email: Promise<string>;
	    readonly cellPhone: Promise<string>;
	    readonly isDataProtectionOfficer: Promise<boolean>;
	    readonly contactRelationship: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.ContactRelationshipAddressLines>;
	    readonly relationshipCellPhone: Promise<string>;
	    readonly relationshipCity: Promise<string>;
	    readonly relationshipCountry: Reference<sageX3Structure.nodes.Country>;
	    readonly relationshipCountryName: Promise<string>;
	    readonly relationshipDateOfBirth: Promise<date | null>;
	    readonly relationshipEmail: Promise<string>;
	    readonly relationshipFax: Promise<string>;
	    readonly relationshipFirstName: Promise<string>;
	    readonly relationshipFullNameSearchKey: Promise<string>;
	    readonly relationshipIsMailingProhibited: Promise<boolean>;
	    readonly relationshipLandline: Promise<string>;
	    readonly relationshipLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly relationshipLastName: Promise<string>;
	    readonly relationshipProfessionalCategory: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly relationshipState: Promise<string>;
	    readonly relationshipTitle: Promise<sageX3System.enums.Title | null>;
	    readonly relationshipType: Promise<sageX3System.enums.ContactType | null>;
	    readonly relationshipZipCode: Promise<string>;
	}
	//# sourceMappingURL=supplier-contact.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/supplier-category.d.ts
declare module '@sage/x3-master-data/lib/nodes/supplier-category' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SupplierCategory extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	}
	//# sourceMappingURL=supplier-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/supplier-bank-detail.d.ts
declare module '@sage/x3-master-data/lib/nodes/supplier-bank-detail' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SupplierBankDetail extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly supplier: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly bankId: Promise<string>;
	    readonly address: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly byDefault: Promise<boolean>;
	    readonly beneficiary: Promise<string>;
	    readonly payingBank1: Promise<string>;
	    readonly payingBank2: Promise<string>;
	    readonly payingBank3: Promise<string>;
	    readonly payingBank4: Promise<string>;
	    readonly ibanPrefix: Promise<string>;
	    readonly bic: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly intermediaryBankName: Promise<string>;
	    readonly intermediaryBankAddress1: Promise<string>;
	    readonly intermediaryBankAddress2: Promise<string>;
	    readonly intermediaryBankAddress3: Promise<string>;
	    readonly intermediaryBankBic: Promise<string>;
	    readonly intermediaryBankCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly nonResidentAccount: Promise<boolean>;
	    readonly isrCustomerNumber: Promise<string>;
	}
	//# sourceMappingURL=supplier-bank-detail.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/supplier-address.d.ts
declare module '@sage/x3-master-data/lib/nodes/supplier-address' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SupplierAddress extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly supplier: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly defaultBankId: Reference<sageX3MasterData.nodes.SupplierBankDetail | null>;
	    readonly isDefault: Promise<boolean>;
	    readonly zipCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly state: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly website: Promise<string>;
	    readonly externalIdentifier: Promise<string>;
	    readonly isValid: Promise<boolean>;
	    readonly addressEmails: Collection<sageX3MasterData.nodes.SupplierAddressAddressEmails>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.SupplierAddressAddressLines>;
	    readonly addressPhoneNumbers: Collection<sageX3MasterData.nodes.SupplierAddressAddressPhoneNumbers>;
	}
	//# sourceMappingURL=supplier-address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/supplier-address-address-phone-numbers.d.ts
declare module '@sage/x3-master-data/lib/nodes/supplier-address-address-phone-numbers' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SupplierAddressAddressPhoneNumbers extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly supplier: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.SupplierAddress>;
	    readonly addressPhoneNumber: Promise<string>;
	    readonly phoneType: Promise<sageX3System.enums.TelephoneType | null>;
	}
	//# sourceMappingURL=supplier-address-address-phone-numbers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/supplier-address-address-lines.d.ts
declare module '@sage/x3-master-data/lib/nodes/supplier-address-address-lines' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SupplierAddressAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly supplier: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.SupplierAddress>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=supplier-address-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/supplier-address-address-emails.d.ts
declare module '@sage/x3-master-data/lib/nodes/supplier-address-address-emails' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SupplierAddressAddressEmails extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly supplier: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.SupplierAddress>;
	    readonly addressEmail: Promise<string>;
	    readonly emailType: Promise<sageX3System.enums.EmailAddressType | null>;
	}
	//# sourceMappingURL=supplier-address-address-emails.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/site-contact.d.ts
declare module '@sage/x3-master-data/lib/nodes/site-contact' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection, date } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SiteContact extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly code: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly position: Promise<sageX3MasterData.enums.FunctionContact | null>;
	    readonly department: Promise<string>;
	    readonly role: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly defaultAddress: Promise<string>;
	    readonly landline: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly email: Promise<string>;
	    readonly cellPhone: Promise<string>;
	    readonly isDataProtectionOfficer: Promise<boolean>;
	    readonly contactRelationship: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.ContactRelationshipAddressLines>;
	    readonly relationshipCellPhone: Promise<string>;
	    readonly relationshipCity: Promise<string>;
	    readonly relationshipCountry: Reference<sageX3Structure.nodes.Country>;
	    readonly relationshipCountryName: Promise<string>;
	    readonly relationshipDateOfBirth: Promise<date | null>;
	    readonly relationshipEmail: Promise<string>;
	    readonly relationshipFax: Promise<string>;
	    readonly relationshipFirstName: Promise<string>;
	    readonly relationshipFullNameSearchKey: Promise<string>;
	    readonly relationshipIsMailingProhibited: Promise<boolean>;
	    readonly relationshipLandline: Promise<string>;
	    readonly relationshipLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly relationshipLastName: Promise<string>;
	    readonly relationshipProfessionalCategory: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly relationshipState: Promise<string>;
	    readonly relationshipTitle: Promise<sageX3System.enums.Title | null>;
	    readonly relationshipType: Promise<sageX3System.enums.ContactType | null>;
	    readonly relationshipZipCode: Promise<string>;
	}
	//# sourceMappingURL=site-contact.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/site-bank-detail.d.ts
declare module '@sage/x3-master-data/lib/nodes/site-bank-detail' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SiteBankDetail extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly bankId: Promise<string>;
	    readonly address: Reference<sageX3MasterData.nodes.SiteAddress | null>;
	    readonly byDefault: Promise<boolean>;
	    readonly beneficiary: Promise<string>;
	    readonly payingBank1: Promise<string>;
	    readonly payingBank2: Promise<string>;
	    readonly payingBank3: Promise<string>;
	    readonly payingBank4: Promise<string>;
	    readonly ibanPrefix: Promise<string>;
	    readonly bic: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly intermediaryBankName: Promise<string>;
	    readonly intermediaryBankAddress1: Promise<string>;
	    readonly intermediaryBankAddress2: Promise<string>;
	    readonly intermediaryBankAddress3: Promise<string>;
	    readonly intermediaryBankBic: Promise<string>;
	    readonly intermediaryBankCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly nonResidentAccount: Promise<boolean>;
	    readonly isrCustomerNumber: Promise<string>;
	}
	//# sourceMappingURL=site-bank-detail.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/site-address.d.ts
declare module '@sage/x3-master-data/lib/nodes/site-address' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SiteAddress extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly defaultBankId: Reference<sageX3MasterData.nodes.SiteBankDetail | null>;
	    readonly isDefault: Promise<boolean>;
	    readonly zipCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly state: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly website: Promise<string>;
	    readonly externalIdentifier: Promise<string>;
	    readonly isValid: Promise<boolean>;
	    readonly addressEmails: Collection<sageX3MasterData.nodes.SiteAddressAddressEmails>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.SiteAddressAddressLines>;
	    readonly addressPhoneNumbers: Collection<sageX3MasterData.nodes.SiteAddressAddressPhoneNumbers>;
	}
	//# sourceMappingURL=site-address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/site-address-address-phone-numbers.d.ts
declare module '@sage/x3-master-data/lib/nodes/site-address-address-phone-numbers' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SiteAddressAddressPhoneNumbers extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.SiteAddress>;
	    readonly addressPhoneNumber: Promise<string>;
	    readonly phoneType: Promise<sageX3System.enums.TelephoneType | null>;
	}
	//# sourceMappingURL=site-address-address-phone-numbers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/site-address-address-lines.d.ts
declare module '@sage/x3-master-data/lib/nodes/site-address-address-lines' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SiteAddressAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.SiteAddress>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=site-address-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/site-address-address-emails.d.ts
declare module '@sage/x3-master-data/lib/nodes/site-address-address-emails' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SiteAddressAddressEmails extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.SiteAddress>;
	    readonly addressEmail: Promise<string>;
	    readonly emailType: Promise<sageX3System.enums.EmailAddressType | null>;
	}
	//# sourceMappingURL=site-address-address-emails.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/ship-to-customer-address.d.ts
declare module '@sage/x3-master-data/lib/nodes/ship-to-customer-address' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, TextStream, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ShipToCustomerAddress extends Node {
	    readonly customer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly shipToAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly company: Reference<sageX3System.nodes.Company | null>;
	    readonly isActive: Promise<boolean>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly receiptSite: Reference<sageX3System.nodes.Site | null>;
	    readonly language: Reference<sageX3System.nodes.Language | null>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
	    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
	    readonly deliveryLeadTime: Promise<integer | null>;
	    readonly isMondayWorkday: Promise<boolean>;
	    readonly isTuesdayWorkday: Promise<boolean>;
	    readonly isWednesdayWorkday: Promise<boolean>;
	    readonly isThursdayWorkday: Promise<boolean>;
	    readonly isFridayWorkday: Promise<boolean>;
	    readonly isSaturdayWorkday: Promise<boolean>;
	    readonly isSundayWorkday: Promise<boolean>;
	    readonly unavailablePeriod: Reference<sageX3MasterData.nodes.UnavailablePeriods | null>;
	    readonly intrastatIncreaseCoefficient: Promise<decimal | null>;
	    readonly europeanUnionVatNumber: Promise<string>;
	    readonly incotermTown: Promise<string>;
	    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.Address | null>;
	    readonly geographicCode: Promise<string>;
	    readonly insideCityLimits: Promise<string>;
	    readonly taxExemptionNumber: Promise<string>;
	    readonly exemptionFlag: Promise<string>;
	    readonly pickingHeaderTextKey: Promise<string>;
	    readonly deliveryHeaderTextKey: Promise<string>;
	    readonly mustPrintPickTicket: Promise<boolean>;
	    readonly mustPrintPackingSlip: Promise<boolean>;
	    readonly entityUse: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly pickingHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly deliveryHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly deliveryHeaderText: Promise<TextStream>;
	    readonly pickingHeaderText: Promise<TextStream>;
	    readonly companyNames: Collection<sageX3MasterData.nodes.ShipToCustomerAddressCompanyNames>;
	    readonly salesReps: Collection<sageX3MasterData.nodes.ShipToCustomerAddressSalesReps>;
	}
	//# sourceMappingURL=ship-to-customer-address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/ship-to-customer-address-sales-reps.d.ts
declare module '@sage/x3-master-data/lib/nodes/ship-to-customer-address-sales-reps' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ShipToCustomerAddressSalesReps extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly customer: Promise<string>;
	    readonly shipToAddress: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
	    readonly salesRep: Reference<sageX3MasterData.nodes.SalesRep | null>;
	}
	//# sourceMappingURL=ship-to-customer-address-sales-reps.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/ship-to-customer-address-company-names.d.ts
declare module '@sage/x3-master-data/lib/nodes/ship-to-customer-address-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ShipToCustomerAddressCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly customer: Promise<string>;
	    readonly shipToAddress: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=ship-to-customer-address-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/sales-rep.d.ts
declare module '@sage/x3-master-data/lib/nodes/sales-rep' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SalesRep extends Node {
	    readonly code: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly name: Promise<string>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
	}
	//# sourceMappingURL=sales-rep.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/prospect.d.ts
declare module '@sage/x3-master-data/lib/nodes/prospect' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class Prospect extends Node {
	    readonly code: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly customerCategory: Reference<sageX3MasterData.nodes.CustomerCategory | null>;
	    readonly groupCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly defaultAddress: Reference<sageX3MasterData.nodes.ProspectAddress | null>;
	    readonly defaultContact: Reference<sageX3MasterData.nodes.ProspectContact | null>;
	    readonly isActive: Promise<boolean>;
	    readonly isProspect: Promise<boolean>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly commissionCategory: Promise<sageX3MasterData.enums.CommissionCategory | null>;
	    readonly addresses: Collection<sageX3MasterData.nodes.ProspectAddress>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly contacts: Collection<sageX3MasterData.nodes.ProspectContact>;
	    readonly acronym: Promise<string>;
	    readonly companyName1: Promise<string>;
	    readonly companyName2: Promise<string>;
	    readonly companyNames: Collection<sageX3MasterData.nodes.BusinessPartnerCompanyNames>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly europeanUnionVatNumber: Promise<string>;
	    readonly fiscalCode: Promise<string>;
	    readonly isMailingProhibited: Promise<boolean>;
	    readonly isPhysicalPerson: Promise<boolean>;
	    readonly language: Reference<sageX3System.nodes.Language>;
	    readonly salesReps: Collection<sageX3MasterData.nodes.ProspectSalesReps>;
	    readonly statisticalGroups: Collection<sageX3MasterData.nodes.ProspectStatisticalGroups>;
	}
	//# sourceMappingURL=prospect.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/prospect-statistical-groups.d.ts
declare module '@sage/x3-master-data/lib/nodes/prospect-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProspectStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Prospect>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=prospect-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/prospect-sales-reps.d.ts
declare module '@sage/x3-master-data/lib/nodes/prospect-sales-reps' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProspectSalesReps extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Prospect>;
	    readonly salesRep: Reference<sageX3MasterData.nodes.SalesRep | null>;
	}
	//# sourceMappingURL=prospect-sales-reps.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/prospect-contact.d.ts
declare module '@sage/x3-master-data/lib/nodes/prospect-contact' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection, date } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProspectContact extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly prospect: Reference<sageX3MasterData.nodes.Prospect | null>;
	    readonly code: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly position: Promise<sageX3MasterData.enums.FunctionContact | null>;
	    readonly department: Promise<string>;
	    readonly role: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly defaultAddress: Promise<string>;
	    readonly landline: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly email: Promise<string>;
	    readonly cellPhone: Promise<string>;
	    readonly isDataProtectionOfficer: Promise<boolean>;
	    readonly contactRelationship: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.ContactRelationshipAddressLines>;
	    readonly relationshipCellPhone: Promise<string>;
	    readonly relationshipCity: Promise<string>;
	    readonly relationshipCountry: Reference<sageX3Structure.nodes.Country>;
	    readonly relationshipCountryName: Promise<string>;
	    readonly relationshipDateOfBirth: Promise<date | null>;
	    readonly relationshipEmail: Promise<string>;
	    readonly relationshipFax: Promise<string>;
	    readonly relationshipFirstName: Promise<string>;
	    readonly relationshipFullNameSearchKey: Promise<string>;
	    readonly relationshipIsMailingProhibited: Promise<boolean>;
	    readonly relationshipLandline: Promise<string>;
	    readonly relationshipLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly relationshipLastName: Promise<string>;
	    readonly relationshipProfessionalCategory: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly relationshipState: Promise<string>;
	    readonly relationshipTitle: Promise<sageX3System.enums.Title | null>;
	    readonly relationshipType: Promise<sageX3System.enums.ContactType | null>;
	    readonly relationshipZipCode: Promise<string>;
	}
	//# sourceMappingURL=prospect-contact.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/prospect-address.d.ts
declare module '@sage/x3-master-data/lib/nodes/prospect-address' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProspectAddress extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly prospect: Reference<sageX3MasterData.nodes.Prospect | null>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly defaultBankId: Promise<string>;
	    readonly isDefault: Promise<boolean>;
	    readonly zipCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly state: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly website: Promise<string>;
	    readonly addressEmails: Collection<sageX3MasterData.nodes.ProspectAddressAddressEmails>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.ProspectAddressAddressLines>;
	    readonly addressPhoneNumbers: Collection<sageX3MasterData.nodes.ProspectAddressAddressPhoneNumbers>;
	}
	//# sourceMappingURL=prospect-address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/prospect-address-address-phone-numbers.d.ts
declare module '@sage/x3-master-data/lib/nodes/prospect-address-address-phone-numbers' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProspectAddressAddressPhoneNumbers extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly prospect: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ProspectAddress>;
	    readonly addressPhoneNumber: Promise<string>;
	    readonly phoneType: Promise<sageX3System.enums.TelephoneType | null>;
	}
	//# sourceMappingURL=prospect-address-address-phone-numbers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/prospect-address-address-lines.d.ts
declare module '@sage/x3-master-data/lib/nodes/prospect-address-address-lines' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProspectAddressAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly prospect: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ProspectAddress>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=prospect-address-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/prospect-address-address-emails.d.ts
declare module '@sage/x3-master-data/lib/nodes/prospect-address-address-emails' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProspectAddressAddressEmails extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly prospect: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ProspectAddress>;
	    readonly addressEmail: Promise<string>;
	    readonly emailType: Promise<sageX3System.enums.EmailAddressType | null>;
	}
	//# sourceMappingURL=prospect-address-address-emails.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/product.d.ts
declare module '@sage/x3-master-data/lib/nodes/product' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, decimal, date, integer, Collection, TextStream, BinaryStream } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class Product extends Node {
	    readonly code: Promise<string>;
	    readonly company: Reference<sageX3System.nodes.Company | null>;
	    readonly productCategory: Reference<sageX3MasterData.nodes.ProductCategory>;
	    readonly searchKey: Promise<string>;
	    readonly description1: Promise<string>;
	    readonly description2: Promise<string>;
	    readonly description3: Promise<string>;
	    readonly localizedDescription1: Promise<string>;
	    readonly localizedDescription2: Promise<string>;
	    readonly localizedDescription3: Promise<string>;
	    readonly managementMode: Promise<sageX3MasterData.enums.StandardProductCode | null>;
	    readonly standard: Promise<string>;
	    readonly upc: Promise<string>;
	    readonly productStatus: Promise<sageX3MasterData.enums.ProductStatus | null>;
	    readonly isPrototype: Promise<boolean>;
	    readonly defaultPotencyInPercentage: Promise<decimal | null>;
	    readonly defaultPotencyInInternationalUnit: Promise<decimal | null>;
	    readonly serviceLifeStartDate: Promise<date | null>;
	    readonly serviceLifeEndDate: Promise<date | null>;
	    readonly storageSheet: Promise<string>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly statisticalUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly eeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly purchaseUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly isPurchaseFactorEntryAllowed: Promise<boolean>;
	    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly isSalesFactorEntryAllowed: Promise<boolean>;
	    readonly statisticalUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly eeUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly productWeight: Promise<decimal | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly productVolume: Promise<decimal | null>;
	    readonly lotSequenceNumber: Promise<string>;
	    readonly serialSequenceNumber: Promise<string>;
	    readonly serialNumberManagementMode: Promise<sageX3MasterData.enums.SerialNumberManagement | null>;
	    readonly expirationManagementMode: Promise<sageX3MasterData.enums.ExpirationManagement | null>;
	    readonly expirationStockStatus: Promise<string>;
	    readonly expirationLeadTime: Promise<integer | null>;
	    readonly checkLeadTime: Promise<integer | null>;
	    readonly isNegativeStockAuthorized: Promise<boolean>;
	    readonly costGroup: Promise<string>;
	    readonly userAccessCode: Reference<sageX3System.nodes.Access | null>;
	    readonly alternateProduct: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly isIntrastatDeclarationSubmitted: Promise<boolean>;
	    readonly intrastatCommodity: Promise<string>;
	    readonly purchasingPlanningHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
	    readonly purchasingPlanningHorizon: Promise<integer | null>;
	    readonly purchasingFirmHorizon: Promise<integer | null>;
	    readonly purchasingFirmHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
	    readonly buyer: Reference<sageX3System.nodes.User | null>;
	    readonly planner: Reference<sageX3System.nodes.User | null>;
	    readonly reorderLeadTime: Promise<integer | null>;
	    readonly purchaseBasePrice: Promise<decimal | null>;
	    readonly landedCostCoefficient: Promise<decimal | null>;
	    readonly fixedLandedCostPerUnit: Promise<decimal | null>;
	    readonly purchaseDeliveryTolerance: Promise<decimal | null>;
	    readonly isReceived: Promise<boolean>;
	    readonly isMandatoryPurchaseOrderRequest: Promise<boolean>;
	    readonly purchasingTextKey: Promise<string>;
	    readonly manufacturingTextKey: Promise<string>;
	    readonly exemptionFlag: Promise<string>;
	    readonly taxFlagStatusLocal: Promise<string>;
	    readonly configuratorProductLine: Promise<string>;
	    readonly configuratorNumericField1: Promise<decimal | null>;
	    readonly configuratorNumericField2: Promise<decimal | null>;
	    readonly configuratorNumericField3: Promise<decimal | null>;
	    readonly configuratorNumericField4: Promise<decimal | null>;
	    readonly configuratorNumericField5: Promise<decimal | null>;
	    readonly configuratorNumericField6: Promise<decimal | null>;
	    readonly configuratorAlphaField1: Promise<string>;
	    readonly configuratorAlphaField2: Promise<string>;
	    readonly configuratorAlphaField3: Promise<string>;
	    readonly configuratorAlphaField4: Promise<string>;
	    readonly configuratorAlphaField5: Promise<string>;
	    readonly configuratorAlphaField6: Promise<string>;
	    readonly configurationJournal: Promise<string>;
	    readonly configuratorBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly configuratorBusinessPartnerReference: Promise<string>;
	    readonly configuratorReferenceProduct: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly configuratorPurgeDate: Promise<date | null>;
	    readonly isInstalledBaseCreated: Promise<boolean>;
	    readonly voucherCategory: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly tokensToBeCredited: Promise<integer | null>;
	    readonly creditUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly labelFormatForStockUnit: Reference<sageX3System.nodes.GenericPrintReport | null>;
	    readonly bomCodeForAfterSales: Reference<sageX3MasterData.nodes.BomCodes | null>;
	    readonly productTypeForAfterSales: Promise<sageX3MasterData.enums.TypeOfProduct | null>;
	    readonly isAfterSalesProductIssuedByDefault: Promise<boolean>;
	    readonly daysUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly hourUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly minuteUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly productDensity: Promise<decimal | null>;
	    readonly isPurchased: Promise<boolean>;
	    readonly isManufactured: Promise<boolean>;
	    readonly isSubcontracted: Promise<boolean>;
	    readonly isService: Promise<boolean>;
	    readonly isPhantom: Promise<boolean>;
	    readonly isGeneric: Promise<boolean>;
	    readonly isTools: Promise<boolean>;
	    readonly isDeliverable: Promise<boolean>;
	    readonly isSold: Promise<boolean>;
	    readonly isIntermediary: Promise<boolean>;
	    readonly isCapitalized: Promise<boolean>;
	    readonly newStockStatusAfterRecontrol: Promise<string>;
	    readonly useByDateCoefficient: Promise<decimal | null>;
	    readonly intrastatFederalStateOrRegion: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly plmProductReference: Promise<string>;
	    readonly plmLinkedDocuments: Promise<string>;
	    readonly plmProductHistory: Promise<string>;
	    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly allergens: Promise<string>;
	    readonly allergenChangeDate: Promise<date | null>;
	    readonly allergenBomCode: Promise<integer | null>;
	    readonly saftProductType: Promise<sageX3MasterData.enums.SafTProductType | null>;
	    readonly isVersionManaged: Promise<boolean>;
	    readonly minorVersionSequence: Promise<string>;
	    readonly majorVersionSequence: Promise<string>;
	    readonly isVersionPreloaded: Promise<boolean>;
	    readonly productType: Promise<sageX3MasterData.enums.ProductType | null>;
	    readonly globalTradeItemNumber: Promise<string>;
	    readonly productSites: Collection<sageX3MasterData.nodes.ProductSite>;
	    readonly supplierProduct: Collection<sageX3MasterData.nodes.SupplierProduct>;
	    readonly customerProduct: Collection<sageX3MasterData.nodes.CustomerProduct>;
	    readonly pictureRef: Reference<sageX3MasterData.nodes.CommonImage | null>;
	    readonly purchasingTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly manufacturingTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly manufacturingText: Promise<TextStream>;
	    readonly picture: Promise<BinaryStream>;
	    readonly purchasingText: Promise<TextStream>;
	    readonly packingUnits: Collection<sageX3MasterData.nodes.ProductPackingUnits>;
	    readonly statisticalGroups: Collection<sageX3MasterData.nodes.ProductStatisticalGroups>;
	}
	//# sourceMappingURL=product.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/product-version.d.ts
declare module '@sage/x3-master-data/lib/nodes/product-version' {
	import { Node, Reference, integer, date } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProductVersion extends Node {
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly majorVersion: Promise<string>;
	    readonly minorVersion: Promise<string>;
	    readonly type: Promise<sageX3MasterData.enums.Flow>;
	    readonly sequence: Promise<integer>;
	    readonly useStatus: Promise<sageX3MasterData.enums.UseStatus | null>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly isSubjectToException: Promise<boolean>;
	    readonly exceptionDate: Promise<date | null>;
	}
	//# sourceMappingURL=product-version.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/product-statistical-groups.d.ts
declare module '@sage/x3-master-data/lib/nodes/product-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProductStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Product>;
	    readonly statisticalGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=product-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/product-site.d.ts
declare module '@sage/x3-master-data/lib/nodes/product-site' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProductSite extends Node {
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly isBeingCounted: Promise<boolean>;
	    readonly countWorksheet: Promise<string>;
	    readonly abcClass: Promise<sageX3MasterData.enums.ProductAbcClass | null>;
	    readonly isLocationManaged: Promise<boolean>;
	    readonly stockWithdrawalMode: Promise<sageX3MasterData.enums.StockWithdrawal | null>;
	    readonly countManagementMode: Promise<sageX3MasterData.enums.Count | null>;
	    readonly trendProfile: Promise<string>;
	    readonly numberOfStockCoverageWeeks: Promise<integer | null>;
	    readonly multilevelLeadTime: Promise<decimal | null>;
	    readonly qualityControlLeadTime: Promise<decimal | null>;
	    readonly planningFirmHorizon: Promise<integer | null>;
	    readonly planningFirmHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
	    readonly planningDemandHorizon: Promise<integer | null>;
	    readonly planningDemandHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
	    readonly reorderLeadTime: Promise<decimal | null>;
	    readonly productionLeadTime: Promise<decimal | null>;
	    readonly pickingLeadTime: Promise<decimal | null>;
	    readonly reductionFactor: Promise<integer | null>;
	    readonly reorderingPeriodicity: Promise<integer | null>;
	    readonly reorderingSuggestionType: Promise<sageX3MasterData.enums.SuggestionType | null>;
	    readonly reorderingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly reorderingPolicy: Promise<string>;
	    readonly safetyStock: Promise<decimal | null>;
	    readonly calculatedSafetyStock: Promise<decimal | null>;
	    readonly reorderingThreshold: Promise<decimal | null>;
	    readonly calculatedReorderingThreshold: Promise<decimal | null>;
	    readonly reorderingMaximumStock: Promise<decimal | null>;
	    readonly calculatedReorderingMaximumStock: Promise<decimal | null>;
	    readonly economicOrderQuantity: Promise<decimal | null>;
	    readonly calculatedEconomicOrderQuantity: Promise<decimal | null>;
	    readonly technicalLotQuantity: Promise<decimal | null>;
	    readonly shrinkagePercentage: Promise<decimal | null>;
	    readonly planner: Reference<sageX3System.nodes.User | null>;
	    readonly buyer: Reference<sageX3System.nodes.User | null>;
	    readonly standardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
	    readonly revisedStandardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
	    readonly budgetStandardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
	    readonly simulatedCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
	    readonly productionRouting: Promise<string>;
	    readonly costRouting: Promise<string>;
	    readonly roughCut: Promise<string>;
	    readonly productionRoutingCode: Reference<sageX3MasterData.nodes.BomRouting | null>;
	    readonly costRoutingCode: Reference<sageX3MasterData.nodes.BomRouting | null>;
	    readonly roughCutCapacityPlanningRoutingCode: Reference<sageX3MasterData.nodes.BomRouting | null>;
	    readonly isReleasedIfShortage: Promise<boolean>;
	    readonly isShrinkedWithRelease: Promise<boolean>;
	    readonly yearOfLastMonthlyUpdate: Promise<integer | null>;
	    readonly monthOfLastMonthlyUpdate: Promise<integer | null>;
	    readonly lastAnnualUpdate: Promise<integer | null>;
	    readonly automaticClosingPercentage: Promise<decimal | null>;
	    readonly configurationCode: Promise<string>;
	    readonly storageHandling: Promise<string>;
	    readonly weighingAccessCode: Promise<string>;
	    readonly weighingTolerance: Promise<decimal | null>;
	    readonly productTolerance: Promise<decimal | null>;
	    readonly valuationMethod: Promise<string>;
	    readonly prorataQuantityAdjustment: Promise<decimal | null>;
	    readonly protectionWip: Promise<boolean>;
	    readonly packagingCapacity: Promise<decimal | null>;
	    readonly stockManagementMode: Promise<sageX3MasterData.enums.StockManagement | null>;
	    readonly assignmentRule: Promise<string>;
	    readonly isStockDetailedInPacking: Promise<boolean>;
	    readonly qualityControlManagementMode: Promise<sageX3MasterData.enums.SubjectToControl | null>;
	    readonly qualityControlAccessCode: Promise<string>;
	    readonly qualityControlFrequency: Promise<integer | null>;
	    readonly numberOfEntriesSinceLastQualityControl: Promise<integer | null>;
	    readonly sampling: Promise<sageX3MasterData.enums.SamplingType | null>;
	    readonly samplingMode: Promise<sageX3MasterData.enums.SamplingMode | null>;
	    readonly samplingGeneralCheckLevel: Promise<sageX3MasterData.enums.GeneralControlLevel | null>;
	    readonly samplingAcceptableQualityLevel: Promise<sageX3MasterData.enums.AcceptableQualityLevel | null>;
	    readonly qualityControlFrequencyToReview: Promise<integer | null>;
	    readonly qualityEntriesProcess: Promise<integer | null>;
	    readonly recontrolLeadTime: Promise<integer | null>;
	    readonly newStockStatusAfterRecontrol: Promise<string>;
	    readonly useByDateCoefficient: Promise<decimal | null>;
	    readonly orderWarehouse: Promise<string>;
	    readonly workOrderWarehouse: Promise<string>;
	    readonly shippingWarehouse: Promise<string>;
	    readonly materialConsumptionsWarehouse: Promise<string>;
	    readonly internalMovementWarehouse: Promise<string>;
	    readonly subcontractShipmentWarehouse: Promise<string>;
	    readonly subcontractConsumptionWarehouse: Promise<string>;
	    readonly isPackingManaged: Promise<boolean>;
	    readonly freightClass: Promise<string>;
	    readonly freightCommodityCode: Promise<string>;
	    readonly isLicensePlateNumberManaged: Promise<boolean>;
	    readonly products: Collection<sageX3MasterData.nodes.Product>;
	}
	//# sourceMappingURL=product-site.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/product-packing-units.d.ts
declare module '@sage/x3-master-data/lib/nodes/product-packing-units' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProductPackingUnits extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Product>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly isPackingFactorEntryAllowed: Promise<boolean>;
	    readonly issuingPackingRule: Promise<sageX3MasterData.enums.UnpackingRulesPac | null>;
	    readonly labelFormat: Reference<sageX3System.nodes.GenericPrintReport | null>;
	}
	//# sourceMappingURL=product-packing-units.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/product-category.d.ts
declare module '@sage/x3-master-data/lib/nodes/product-category' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, decimal, integer, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProductCategory extends Node {
	    readonly stockSite: Reference<sageX3System.nodes.Site | null>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isSold: Promise<boolean>;
	    readonly productSequenceNumber: Promise<string>;
	    readonly creationMethod: Promise<sageX3MasterData.enums.ProductCreationMode | null>;
	    readonly qualityControlManagementMode: Promise<sageX3MasterData.enums.SubjectToControl | null>;
	    readonly qualityControlAccessCode: Promise<string>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly statisticUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly euUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly purchaseUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly statisticalUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly euUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly isPurchaseConversionFactorEntryAllowed: Promise<boolean>;
	    readonly isSalesConversionFactorEntryAllowed: Promise<boolean>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly stockUnitWeight: Promise<decimal | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly stockUnitVolume: Promise<decimal | null>;
	    readonly labelFormatForStockUnit: Reference<sageX3System.nodes.GenericPrintReport | null>;
	    readonly stockManagementMode: Promise<sageX3MasterData.enums.StockManagement | null>;
	    readonly managementMode: Promise<sageX3MasterData.enums.StandardProductCode | null>;
	    readonly isNegativeStockAuthorized: Promise<boolean>;
	    readonly lotSequenceNumber: Promise<string>;
	    readonly serialNumberManagementMode: Promise<sageX3MasterData.enums.SerialNumberManagement | null>;
	    readonly serialSequenceNumber: Promise<string>;
	    readonly valuationMethod: Promise<string>;
	    readonly expirationManagementMode: Promise<sageX3MasterData.enums.ExpirationManagement | null>;
	    readonly expirationStockStatus: Promise<string>;
	    readonly userAccessCode: Promise<string>;
	    readonly purchasingPlanningHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
	    readonly purchasingPlanningHorizon: Promise<integer | null>;
	    readonly purchasingFirmHorizon: Promise<integer | null>;
	    readonly purchasingFirmHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
	    readonly reorderLeadTime: Promise<decimal | null>;
	    readonly buyer: Reference<sageX3System.nodes.User | null>;
	    readonly planner: Reference<sageX3System.nodes.User | null>;
	    readonly purchaseDeliveryTolerance: Promise<decimal | null>;
	    readonly isReceived: Promise<boolean>;
	    readonly isMandatoryPurchaseOrderRequest: Promise<boolean>;
	    readonly landedCostCoefficient: Promise<decimal | null>;
	    readonly fixedLandedCostPerUnit: Promise<decimal | null>;
	    readonly salesPriceOrigin: Promise<sageX3MasterData.enums.PriceOrigin | null>;
	    readonly percentagePricePurchaseApplied: Promise<decimal | null>;
	    readonly configuratorProductLine: Promise<string>;
	    readonly isLocationManaged: Promise<boolean>;
	    readonly salesOrderAllocationRule: Promise<string>;
	    readonly workOrderAllocationRule: Promise<string>;
	    readonly shipmentAllocationRule: Promise<string>;
	    readonly materialConsumptionAllocationRule: Promise<string>;
	    readonly transferAllocationRule: Promise<string>;
	    readonly subcontractReplenishmentAllocationRule: Promise<string>;
	    readonly subcontractConsumptionAllocationRule: Promise<string>;
	    readonly afterSalesAllocationRule: Promise<string>;
	    readonly isStatusAAuthorizedInGlobalAllocation: Promise<boolean>;
	    readonly isStatusQAuthorizedInGlobalAllocation: Promise<boolean>;
	    readonly isStatusRAuthorizedInGlobalAllocation: Promise<boolean>;
	    readonly abcClass: Promise<sageX3MasterData.enums.ProductAbcClass | null>;
	    readonly stockWithdrawalMode: Promise<sageX3MasterData.enums.StockWithdrawal | null>;
	    readonly countManagementMode: Promise<sageX3MasterData.enums.Count | null>;
	    readonly trendProfile: Promise<string>;
	    readonly shrinkagePercent: Promise<decimal | null>;
	    readonly planningFirmHorizon: Promise<integer | null>;
	    readonly planningFirmHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
	    readonly planningRequestHorizon: Promise<integer | null>;
	    readonly planningRequestHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
	    readonly reorderingPeriodicity: Promise<integer | null>;
	    readonly reorderingSuggestionType: Promise<sageX3MasterData.enums.SuggestionType | null>;
	    readonly reorderingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly reorderingPolicy: Promise<string>;
	    readonly stockCoverageInWeeks: Promise<integer | null>;
	    readonly safetyStock: Promise<decimal | null>;
	    readonly reorderingThreshold: Promise<decimal | null>;
	    readonly reorderingMaximumStock: Promise<decimal | null>;
	    readonly economicOrderQuantity: Promise<decimal | null>;
	    readonly technicalLotQuantity: Promise<decimal | null>;
	    readonly standardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
	    readonly revisedStandardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
	    readonly budgetStandardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
	    readonly simulatedCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
	    readonly isReleasedIfShortage: Promise<boolean>;
	    readonly automaticClosingPercentage: Promise<decimal | null>;
	    readonly salesDeliveryTolerance: Promise<decimal | null>;
	    readonly salesMinimumQuantity: Promise<decimal | null>;
	    readonly salesMaximumQuantity: Promise<decimal | null>;
	    readonly isLoanAuthorized: Promise<boolean>;
	    readonly isBackToBackOrderManaged: Promise<boolean>;
	    readonly directBackToBackOrderQuantity: Promise<decimal | null>;
	    readonly isPurchased: Promise<boolean>;
	    readonly isManufactured: Promise<boolean>;
	    readonly isSubcontracted: Promise<boolean>;
	    readonly isService: Promise<boolean>;
	    readonly isPhantom: Promise<boolean>;
	    readonly isGeneric: Promise<boolean>;
	    readonly isTool: Promise<boolean>;
	    readonly isDeliverable: Promise<boolean>;
	    readonly isIntermediary: Promise<boolean>;
	    readonly isMaintenance: Promise<boolean>;
	    readonly packagingCapacity: Promise<decimal | null>;
	    readonly assignmentRules: Promise<string>;
	    readonly isStockDetailedInPacking: Promise<boolean>;
	    readonly technicalSheet: Reference<sageX3MasterData.nodes.TechnicalSheet | null>;
	    readonly orderWarehouse: Promise<string>;
	    readonly workOrderWarehouse: Promise<string>;
	    readonly shippingWarehouse: Promise<string>;
	    readonly materialConsumptionWarehouse: Promise<string>;
	    readonly internalMovementWarehouse: Promise<string>;
	    readonly subcontractShipmentWarehouse: Promise<string>;
	    readonly subcontractConsumptionWarehouse: Promise<string>;
	    readonly afterSalesWarehouse: Promise<string>;
	    readonly canBeCapitalized: Promise<boolean>;
	    readonly isPackingManaged: Promise<boolean>;
	    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly saftProductType: Promise<sageX3MasterData.enums.SafTProductType | null>;
	    readonly freightClass: Promise<string>;
	    readonly freightCommodityCode: Promise<string>;
	    readonly isVersionManaged: Promise<boolean>;
	    readonly minorVersionSequence: Promise<string>;
	    readonly majorVersionSequence: Promise<string>;
	    readonly isVersionPreloaded: Promise<boolean>;
	    readonly inventoryProductType: Promise<sageX3MasterData.enums.ProductType | null>;
	    readonly containerManagement: Promise<boolean>;
	    readonly statisticalGroups: Collection<sageX3MasterData.nodes.ProductCategoryStatisticalGroups>;
	}
	//# sourceMappingURL=product-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/product-category-statistical-groups.d.ts
declare module '@sage/x3-master-data/lib/nodes/product-category-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ProductCategoryStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly stockSite: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ProductCategory>;
	    readonly statisticalGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=product-category-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/print-template.d.ts
declare module '@sage/x3-master-data/lib/nodes/print-template' {
	import { Node } from '@sage/xtrem-core';
	export class PrintTemplate extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=print-template.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/mobile-automation-setup.d.ts
declare module '@sage/x3-master-data/lib/nodes/mobile-automation-setup' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class MobileAutomationSetup extends Node {
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly criteria1: Promise<sageX3MasterData.enums.ProductSearchCriteria | null>;
	    readonly criteria2: Promise<sageX3MasterData.enums.ProductSearchCriteria | null>;
	    readonly stockLabel: Reference<sageX3System.nodes.GenericPrintReport | null>;
	    readonly productionLabel: Reference<sageX3System.nodes.GenericPrintReport | null>;
	    readonly isAlwaysLabelDestination: Promise<boolean>;
	    readonly isTheoreticalQuantityDisplayed: Promise<boolean>;
	    readonly isLocationPreloaded: Promise<boolean>;
	}
	//# sourceMappingURL=mobile-automation-setup.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/mapping.d.ts
declare module '@sage/x3-master-data/lib/nodes/mapping' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class Mapping extends Node {
	    readonly code: Promise<string>;
	    readonly mappingCode: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly company: Reference<sageX3System.nodes.Company | null>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable>;
	    readonly version: Promise<string>;
	    readonly direction: Promise<sageX3MasterData.enums.Sense>;
	}
	//# sourceMappingURL=mapping.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/index.d.ts
declare module '@sage/x3-master-data/lib/nodes/index' {
	export * from '@sage/x3-master-data/lib/nodes/address-address-emails';
	export * from '@sage/x3-master-data/lib/nodes/address-address-lines';
	export * from '@sage/x3-master-data/lib/nodes/address-address-phone-numbers';
	export * from '@sage/x3-master-data/lib/nodes/address';
	export * from '@sage/x3-master-data/lib/nodes/bank-detail';
	export * from '@sage/x3-master-data/lib/nodes/bom-codes';
	export * from '@sage/x3-master-data/lib/nodes/bom-detail';
	export * from '@sage/x3-master-data/lib/nodes/bom-header';
	export * from '@sage/x3-master-data/lib/nodes/bom-product';
	export * from '@sage/x3-master-data/lib/nodes/bom-routing';
	export * from '@sage/x3-master-data/lib/nodes/business-partner-address-address-emails';
	export * from '@sage/x3-master-data/lib/nodes/business-partner-address-address-lines';
	export * from '@sage/x3-master-data/lib/nodes/business-partner-address-address-phone-numbers';
	export * from '@sage/x3-master-data/lib/nodes/business-partner-address';
	export * from '@sage/x3-master-data/lib/nodes/business-partner-bank-detail';
	export * from '@sage/x3-master-data/lib/nodes/business-partner-company-exception';
	export * from '@sage/x3-master-data/lib/nodes/business-partner-company-names';
	export * from '@sage/x3-master-data/lib/nodes/business-partner-contact';
	export * from '@sage/x3-master-data/lib/nodes/business-partner';
	export * from '@sage/x3-master-data/lib/nodes/carrier';
	export * from '@sage/x3-master-data/lib/nodes/common-image';
	export * from '@sage/x3-master-data/lib/nodes/common-text';
	export * from '@sage/x3-master-data/lib/nodes/company-address-address-emails';
	export * from '@sage/x3-master-data/lib/nodes/company-address-address-lines';
	export * from '@sage/x3-master-data/lib/nodes/company-address-address-phone-numbers';
	export * from '@sage/x3-master-data/lib/nodes/company-address';
	export * from '@sage/x3-master-data/lib/nodes/company-bank-detail';
	export * from '@sage/x3-master-data/lib/nodes/company-contact';
	export * from '@sage/x3-master-data/lib/nodes/contact-relationship-address-lines';
	export * from '@sage/x3-master-data/lib/nodes/contact-relationship';
	export * from '@sage/x3-master-data/lib/nodes/contact';
	export * from '@sage/x3-master-data/lib/nodes/container';
	export * from '@sage/x3-master-data/lib/nodes/currency-rate';
	export * from '@sage/x3-master-data/lib/nodes/currency';
	export * from '@sage/x3-master-data/lib/nodes/customer-address-address-emails';
	export * from '@sage/x3-master-data/lib/nodes/customer-address-address-lines';
	export * from '@sage/x3-master-data/lib/nodes/customer-address-address-phone-numbers';
	export * from '@sage/x3-master-data/lib/nodes/customer-address';
	export * from '@sage/x3-master-data/lib/nodes/customer-bank-detail';
	export * from '@sage/x3-master-data/lib/nodes/customer-cash-tax-rules';
	export * from '@sage/x3-master-data/lib/nodes/customer-category';
	export * from '@sage/x3-master-data/lib/nodes/customer-contact';
	export * from '@sage/x3-master-data/lib/nodes/customer-payment-days';
	export * from '@sage/x3-master-data/lib/nodes/customer-product';
	export * from '@sage/x3-master-data/lib/nodes/customer-sales-reps';
	export * from '@sage/x3-master-data/lib/nodes/customer-statistical-groups';
	export * from '@sage/x3-master-data/lib/nodes/customer';
	export * from '@sage/x3-master-data/lib/nodes/incoterm';
	export * from '@sage/x3-master-data/lib/nodes/mapping';
	export * from '@sage/x3-master-data/lib/nodes/mobile-automation-setup';
	export * from '@sage/x3-master-data/lib/nodes/print-template';
	export * from '@sage/x3-master-data/lib/nodes/product-category-statistical-groups';
	export * from '@sage/x3-master-data/lib/nodes/product-category';
	export * from '@sage/x3-master-data/lib/nodes/product-packing-units';
	export * from '@sage/x3-master-data/lib/nodes/product-site';
	export * from '@sage/x3-master-data/lib/nodes/product-statistical-groups';
	export * from '@sage/x3-master-data/lib/nodes/product-version';
	export * from '@sage/x3-master-data/lib/nodes/product';
	export * from '@sage/x3-master-data/lib/nodes/prospect-address-address-emails';
	export * from '@sage/x3-master-data/lib/nodes/prospect-address-address-lines';
	export * from '@sage/x3-master-data/lib/nodes/prospect-address-address-phone-numbers';
	export * from '@sage/x3-master-data/lib/nodes/prospect-address';
	export * from '@sage/x3-master-data/lib/nodes/prospect-contact';
	export * from '@sage/x3-master-data/lib/nodes/prospect-sales-reps';
	export * from '@sage/x3-master-data/lib/nodes/prospect-statistical-groups';
	export * from '@sage/x3-master-data/lib/nodes/prospect';
	export * from '@sage/x3-master-data/lib/nodes/sales-rep';
	export * from '@sage/x3-master-data/lib/nodes/ship-to-customer-address-company-names';
	export * from '@sage/x3-master-data/lib/nodes/ship-to-customer-address-sales-reps';
	export * from '@sage/x3-master-data/lib/nodes/ship-to-customer-address';
	export * from '@sage/x3-master-data/lib/nodes/site-address-address-emails';
	export * from '@sage/x3-master-data/lib/nodes/site-address-address-lines';
	export * from '@sage/x3-master-data/lib/nodes/site-address-address-phone-numbers';
	export * from '@sage/x3-master-data/lib/nodes/site-address';
	export * from '@sage/x3-master-data/lib/nodes/site-bank-detail';
	export * from '@sage/x3-master-data/lib/nodes/site-contact';
	export * from '@sage/x3-master-data/lib/nodes/supplier-address-address-emails';
	export * from '@sage/x3-master-data/lib/nodes/supplier-address-address-lines';
	export * from '@sage/x3-master-data/lib/nodes/supplier-address-address-phone-numbers';
	export * from '@sage/x3-master-data/lib/nodes/supplier-address';
	export * from '@sage/x3-master-data/lib/nodes/supplier-bank-detail';
	export * from '@sage/x3-master-data/lib/nodes/supplier-category';
	export * from '@sage/x3-master-data/lib/nodes/supplier-contact';
	export * from '@sage/x3-master-data/lib/nodes/supplier-product';
	export * from '@sage/x3-master-data/lib/nodes/supplier';
	export * from '@sage/x3-master-data/lib/nodes/technical-sheet';
	export * from '@sage/x3-master-data/lib/nodes/time-table-schema-times';
	export * from '@sage/x3-master-data/lib/nodes/time-table-schema';
	export * from '@sage/x3-master-data/lib/nodes/transit-area-address-address-emails';
	export * from '@sage/x3-master-data/lib/nodes/transit-area-address-address-lines';
	export * from '@sage/x3-master-data/lib/nodes/transit-area-address-address-phone-numbers';
	export * from '@sage/x3-master-data/lib/nodes/transit-area-address';
	export * from '@sage/x3-master-data/lib/nodes/transit-area';
	export * from '@sage/x3-master-data/lib/nodes/unavailable-periods-lines';
	export * from '@sage/x3-master-data/lib/nodes/unavailable-periods';
	export * from '@sage/x3-master-data/lib/nodes/unit-of-measure';
	export * from '@sage/x3-master-data/lib/nodes/weekly-structure-weekly-structure-daily-capacity';
	export * from '@sage/x3-master-data/lib/nodes/weekly-structure';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/incoterm.d.ts
declare module '@sage/x3-master-data/lib/nodes/incoterm' {
	import { Node } from '@sage/xtrem-core';
	export class Incoterm extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=incoterm.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, decimal, date, integer, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class Customer extends Node {
	    readonly code: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly customerCategory: Reference<sageX3MasterData.nodes.CustomerCategory | null>;
	    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly billToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly payByCustomer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly payByCustomerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly groupCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly riskCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly defaultAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly defaultShipToAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress | null>;
	    readonly defaultContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly isActive: Promise<boolean>;
	    readonly isProspect: Promise<boolean>;
	    readonly ourSupplierCode: Promise<string>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly commissionCategory: Promise<sageX3MasterData.enums.CommissionCategory | null>;
	    readonly exemptionTaxNumber: Promise<string>;
	    readonly priceOrAmountType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
	    readonly creditControl: Promise<sageX3MasterData.enums.WorkInProgressControl | null>;
	    readonly authorizedCreditAmount: Promise<decimal | null>;
	    readonly minimumOrderAmount: Promise<decimal | null>;
	    readonly creditInsuranceAmount: Promise<decimal | null>;
	    readonly insuranceDate: Promise<date | null>;
	    readonly insuranceCompany: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly reminderType: Promise<sageX3MasterData.enums.ReminderType | null>;
	    readonly minimumReminderAmount: Promise<decimal | null>;
	    readonly canBeMatched: Promise<boolean>;
	    readonly orderHeaderTextKey: Promise<string>;
	    readonly invoiceHeaderTextKey: Promise<string>;
	    readonly isLoanAllowed: Promise<boolean>;
	    readonly mustPrintAcknowledgment: Promise<boolean>;
	    readonly isOrderClosingAllowed: Promise<boolean>;
	    readonly mustContainOneOrderPerDelivery: Promise<boolean>;
	    readonly businessSector: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly prospectOrigin: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly tokenCredit: Promise<integer | null>;
	    readonly manualAdditionalToken: Promise<integer | null>;
	    readonly totalTokenCredit: Promise<integer | null>;
	    readonly necessaryTokensForServiceContract: Promise<integer | null>;
	    readonly firstContactDate: Promise<date | null>;
	    readonly firstOrderDate: Promise<date | null>;
	    readonly lastQuoteDate: Promise<date | null>;
	    readonly lastContactDate: Promise<date | null>;
	    readonly nextContactDate: Promise<date | null>;
	    readonly customerAbcClass: Promise<sageX3MasterData.enums.ProductAbcClass | null>;
	    readonly printTemplate: Reference<sageX3MasterData.nodes.PrintTemplate | null>;
	    readonly initialDateSinceCustomer: Promise<date | null>;
	    readonly unavailablePaymentPeriod: Reference<sageX3MasterData.nodes.UnavailablePeriods | null>;
	    readonly isSubjectToTax: Promise<boolean>;
	    readonly isEfatElectronicInvoicingAllowed: Promise<boolean>;
	    readonly contact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly startDateforElectronicInvoice: Promise<date | null>;
	    readonly isElectronicInvoiceAllowed: Promise<boolean>;
	    readonly addresses: Collection<sageX3MasterData.nodes.CustomerAddress>;
	    readonly contacts: Collection<sageX3MasterData.nodes.CustomerContact>;
	    readonly bankDetails: Collection<sageX3MasterData.nodes.CustomerBankDetail>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly shipToCustomers: Collection<sageX3MasterData.nodes.ShipToCustomerAddress>;
	    readonly orderHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly invoiceHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly acronym: Promise<string>;
	    readonly businessPartnerSite: Reference<sageX3System.nodes.Site | null>;
	    readonly cfonbPaymentMethod: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly companyName1: Promise<string>;
	    readonly companyName2: Promise<string>;
	    readonly companyNames: Collection<sageX3MasterData.nodes.BusinessPartnerCompanyNames>;
	    readonly consolidationCode: Promise<string>;
	    readonly consolidationGroup: Reference<sageX3Structure.nodes.SiteGroupings | null>;
	    readonly consolidationPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly customerOrSupplierOriginCategory: Promise<string>;
	    readonly documentType: Promise<sageX3MasterData.enums.DocumentType | null>;
	    readonly economicOperatorRegistrationAndIdNumber: Promise<string>;
	    readonly electronicAddress: Promise<string>;
	    readonly electronicInvoiceType: Promise<sageX3MasterData.enums.ElectronicInvoiceType | null>;
	    readonly europeanUnionVatNumber: Promise<string>;
	    readonly fiscalCode: Promise<string>;
	    readonly invoiceHeaderText: Promise<TextStream>;
	    readonly isCashExcluded: Promise<boolean>;
	    readonly isIntersite: Promise<boolean>;
	    readonly isMailingProhibited: Promise<boolean>;
	    readonly isPhysicalPerson: Promise<boolean>;
	    readonly isPublicSector: Promise<boolean>;
	    readonly isServiceCaller: Promise<boolean>;
	    readonly isServiceSupplier: Promise<boolean>;
	    readonly italianTaxNumber: Promise<string>;
	    readonly language: Reference<sageX3System.nodes.Language>;
	    readonly nonResidentAccount: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly orderHeaderText: Promise<TextStream>;
	    readonly registrationNumber: Promise<string>;
	    readonly relatedCompany: Promise<sageX3MasterData.enums.RelatedCompanySettings | null>;
	    readonly reportAccessCode: Reference<sageX3System.nodes.Access | null>;
	    readonly routingCode: Promise<string>;
	    readonly serviceCode: Promise<string>;
	    readonly shortCompanyName: Promise<string>;
	    readonly siteIdentificationNumber: Promise<string>;
	    readonly standardIndustrialClassificationCode: Promise<string>;
	    readonly vatNumber: Promise<string>;
	    readonly cashTaxRules: Collection<sageX3MasterData.nodes.CustomerCashTaxRules>;
	    readonly paymentDays: Collection<sageX3MasterData.nodes.CustomerPaymentDays>;
	    readonly salesReps: Collection<sageX3MasterData.nodes.CustomerSalesReps>;
	    readonly statisticalGroups: Collection<sageX3MasterData.nodes.CustomerStatisticalGroups>;
	}
	//# sourceMappingURL=customer.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-statistical-groups.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Customer>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=customer-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-sales-reps.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-sales-reps' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerSalesReps extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Customer>;
	    readonly salesRep: Reference<sageX3MasterData.nodes.SalesRep | null>;
	}
	//# sourceMappingURL=customer-sales-reps.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-product.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-product' {
	import { Node, Reference, decimal, TextStream } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerProduct extends Node {
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly customer: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly isActive: Promise<boolean>;
	    readonly customerProduct: Promise<string>;
	    readonly customerProductDescription: Promise<string>;
	    readonly salesTextKey: Promise<string>;
	    readonly pickingTextKey: Promise<string>;
	    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly salesUnitToStockUnitConversion: Promise<decimal | null>;
	    readonly packingUnit1: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly packingUnit1ToSalesUnitConversion: Promise<decimal | null>;
	    readonly packingUnit2: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly packingUnit2ToSalesUnitConversion: Promise<decimal | null>;
	    readonly customerUseByDateCoefficient: Promise<decimal | null>;
	    readonly journalNumberConfigurator: Promise<string>;
	    readonly isVersionPreloaded: Promise<boolean>;
	    readonly pickingTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly salesTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly pickingText: Promise<TextStream>;
	    readonly salesText: Promise<TextStream>;
	}
	//# sourceMappingURL=customer-product.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-payment-days.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-payment-days' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerPaymentDays extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Customer>;
	    readonly paymentDay: Promise<integer | null>;
	}
	//# sourceMappingURL=customer-payment-days.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-contact.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-contact' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection, date } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerContact extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly customer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly code: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly position: Promise<sageX3MasterData.enums.FunctionContact | null>;
	    readonly department: Promise<string>;
	    readonly role: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly defaultAddress: Promise<string>;
	    readonly landline: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly email: Promise<string>;
	    readonly cellPhone: Promise<string>;
	    readonly isDataProtectionOfficer: Promise<boolean>;
	    readonly contactRelationship: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.ContactRelationshipAddressLines>;
	    readonly relationshipCellPhone: Promise<string>;
	    readonly relationshipCity: Promise<string>;
	    readonly relationshipCountry: Reference<sageX3Structure.nodes.Country>;
	    readonly relationshipCountryName: Promise<string>;
	    readonly relationshipDateOfBirth: Promise<date | null>;
	    readonly relationshipEmail: Promise<string>;
	    readonly relationshipFax: Promise<string>;
	    readonly relationshipFirstName: Promise<string>;
	    readonly relationshipFullNameSearchKey: Promise<string>;
	    readonly relationshipIsMailingProhibited: Promise<boolean>;
	    readonly relationshipLandline: Promise<string>;
	    readonly relationshipLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly relationshipLastName: Promise<string>;
	    readonly relationshipProfessionalCategory: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly relationshipState: Promise<string>;
	    readonly relationshipTitle: Promise<sageX3System.enums.Title | null>;
	    readonly relationshipType: Promise<sageX3System.enums.ContactType | null>;
	    readonly relationshipZipCode: Promise<string>;
	}
	//# sourceMappingURL=customer-contact.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-category.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-category' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerCategory extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	}
	//# sourceMappingURL=customer-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-cash-tax-rules.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-cash-tax-rules' {
	import { Node, integer, Reference, date } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerCashTaxRules extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Customer>;
	    readonly isActive: Promise<boolean>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	}
	//# sourceMappingURL=customer-cash-tax-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-bank-detail.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-bank-detail' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerBankDetail extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly customer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly bankId: Promise<string>;
	    readonly address: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly byDefault: Promise<boolean>;
	    readonly beneficiary: Promise<string>;
	    readonly payingBank1: Promise<string>;
	    readonly payingBank2: Promise<string>;
	    readonly payingBank3: Promise<string>;
	    readonly payingBank4: Promise<string>;
	    readonly ibanPrefix: Promise<string>;
	    readonly bic: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly intermediaryBankName: Promise<string>;
	    readonly intermediaryBankAddress1: Promise<string>;
	    readonly intermediaryBankAddress2: Promise<string>;
	    readonly intermediaryBankAddress3: Promise<string>;
	    readonly intermediaryBankBic: Promise<string>;
	    readonly intermediaryBankCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly nonResidentAccount: Promise<boolean>;
	    readonly isrCustomerNumber: Promise<string>;
	}
	//# sourceMappingURL=customer-bank-detail.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-address.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-address' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerAddress extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly customer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly defaultBankId: Reference<sageX3MasterData.nodes.CustomerBankDetail | null>;
	    readonly isDefault: Promise<boolean>;
	    readonly zipCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly state: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly website: Promise<string>;
	    readonly externalIdentifier: Promise<string>;
	    readonly isValid: Promise<boolean>;
	    readonly addressEmails: Collection<sageX3MasterData.nodes.CustomerAddressAddressEmails>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.CustomerAddressAddressLines>;
	    readonly addressPhoneNumbers: Collection<sageX3MasterData.nodes.CustomerAddressAddressPhoneNumbers>;
	}
	//# sourceMappingURL=customer-address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-address-address-phone-numbers.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-address-address-phone-numbers' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerAddressAddressPhoneNumbers extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly customer: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.CustomerAddress>;
	    readonly addressPhoneNumber: Promise<string>;
	    readonly phoneType: Promise<sageX3System.enums.TelephoneType | null>;
	}
	//# sourceMappingURL=customer-address-address-phone-numbers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-address-address-lines.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-address-address-lines' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerAddressAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly customer: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.CustomerAddress>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=customer-address-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/customer-address-address-emails.d.ts
declare module '@sage/x3-master-data/lib/nodes/customer-address-address-emails' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CustomerAddressAddressEmails extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly customer: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.CustomerAddress>;
	    readonly addressEmail: Promise<string>;
	    readonly emailType: Promise<sageX3System.enums.EmailAddressType | null>;
	}
	//# sourceMappingURL=customer-address-address-emails.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/currency.d.ts
declare module '@sage/x3-master-data/lib/nodes/currency' {
	import { Node, date, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class Currency extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isEuro: Promise<boolean>;
	    readonly euroDate: Promise<date | null>;
	    readonly currencyRates: Collection<sageX3MasterData.nodes.CurrencyRate>;
	}
	//# sourceMappingURL=currency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/currency-rate.d.ts
declare module '@sage/x3-master-data/lib/nodes/currency-rate' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, decimal } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CurrencyRate extends Node {
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly sourceCurrency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly destinationCurrency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly rateDate: Promise<date>;
	    readonly inverseRate: Promise<decimal | null>;
	    readonly rate: Promise<decimal | null>;
	    readonly divisor: Promise<decimal | null>;
	}
	//# sourceMappingURL=currency-rate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/container.d.ts
declare module '@sage/x3-master-data/lib/nodes/container' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, decimal, integer } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class Container extends Node {
	    readonly code: Promise<string>;
	    readonly containerType: Promise<sageX3MasterData.enums.InternalContainerType | null>;
	    readonly isActive: Promise<boolean>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly sizeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly tareWeight: Promise<decimal | null>;
	    readonly maxWeight: Promise<decimal | null>;
	    readonly length: Promise<decimal | null>;
	    readonly width: Promise<decimal | null>;
	    readonly height: Promise<decimal | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly usableVolume: Promise<decimal | null>;
	    readonly twentyFootEquivalentUnit: Promise<integer | null>;
	    readonly isRefrigerated: Promise<boolean>;
	    readonly isInternal: Promise<boolean>;
	    readonly isFreight: Promise<boolean>;
	    readonly isSingleProduct: Promise<boolean>;
	    readonly isSingleLot: Promise<boolean>;
	    readonly labelFormat: Reference<sageX3System.nodes.GenericPrintReport | null>;
	}
	//# sourceMappingURL=container.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/contact.d.ts
declare module '@sage/x3-master-data/lib/nodes/contact' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection, date } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class Contact extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly entityNumber: Promise<string>;
	    readonly code: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly position: Promise<sageX3MasterData.enums.FunctionContact | null>;
	    readonly department: Promise<string>;
	    readonly role: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly defaultAddress: Promise<string>;
	    readonly landline: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly email: Promise<string>;
	    readonly cellPhone: Promise<string>;
	    readonly isDataProtectionOfficer: Promise<boolean>;
	    readonly contactRelationship: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.ContactRelationshipAddressLines>;
	    readonly relationshipCellPhone: Promise<string>;
	    readonly relationshipCity: Promise<string>;
	    readonly relationshipCountry: Reference<sageX3Structure.nodes.Country>;
	    readonly relationshipCountryName: Promise<string>;
	    readonly relationshipDateOfBirth: Promise<date | null>;
	    readonly relationshipEmail: Promise<string>;
	    readonly relationshipFax: Promise<string>;
	    readonly relationshipFirstName: Promise<string>;
	    readonly relationshipFullNameSearchKey: Promise<string>;
	    readonly relationshipIsMailingProhibited: Promise<boolean>;
	    readonly relationshipLandline: Promise<string>;
	    readonly relationshipLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly relationshipLastName: Promise<string>;
	    readonly relationshipProfessionalCategory: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly relationshipState: Promise<string>;
	    readonly relationshipTitle: Promise<sageX3System.enums.Title | null>;
	    readonly relationshipType: Promise<sageX3System.enums.ContactType | null>;
	    readonly relationshipZipCode: Promise<string>;
	}
	//# sourceMappingURL=contact.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/contact-relationship.d.ts
declare module '@sage/x3-master-data/lib/nodes/contact-relationship' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, date, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ContactRelationship extends Node {
	    readonly code: Promise<string>;
	    readonly fullNameSearchKey: Promise<string>;
	    readonly title: Promise<sageX3System.enums.Title | null>;
	    readonly type: Promise<sageX3System.enums.ContactType | null>;
	    readonly lastName: Promise<string>;
	    readonly firstName: Promise<string>;
	    readonly dateOfBirth: Promise<date | null>;
	    readonly language: Reference<sageX3System.nodes.Language | null>;
	    readonly professionalCategory: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly country: Reference<sageX3Structure.nodes.Country>;
	    readonly countryName: Promise<string>;
	    readonly zipCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly state: Promise<string>;
	    readonly landline: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly cellPhone: Promise<string>;
	    readonly email: Promise<string>;
	    readonly isMailingProhibited: Promise<boolean>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.ContactRelationshipAddressLines>;
	}
	//# sourceMappingURL=contact-relationship.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/contact-relationship-address-lines.d.ts
declare module '@sage/x3-master-data/lib/nodes/contact-relationship-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class ContactRelationshipAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly line: Promise<string>;
	}
	//# sourceMappingURL=contact-relationship-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/company-contact.d.ts
declare module '@sage/x3-master-data/lib/nodes/company-contact' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection, date } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CompanyContact extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly company: Reference<sageX3System.nodes.Company | null>;
	    readonly code: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly position: Promise<sageX3MasterData.enums.FunctionContact | null>;
	    readonly department: Promise<string>;
	    readonly role: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly defaultAddress: Promise<string>;
	    readonly landline: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly email: Promise<string>;
	    readonly cellPhone: Promise<string>;
	    readonly isDataProtectionOfficer: Promise<boolean>;
	    readonly contactRelationship: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.ContactRelationshipAddressLines>;
	    readonly relationshipCellPhone: Promise<string>;
	    readonly relationshipCity: Promise<string>;
	    readonly relationshipCountry: Reference<sageX3Structure.nodes.Country>;
	    readonly relationshipCountryName: Promise<string>;
	    readonly relationshipDateOfBirth: Promise<date | null>;
	    readonly relationshipEmail: Promise<string>;
	    readonly relationshipFax: Promise<string>;
	    readonly relationshipFirstName: Promise<string>;
	    readonly relationshipFullNameSearchKey: Promise<string>;
	    readonly relationshipIsMailingProhibited: Promise<boolean>;
	    readonly relationshipLandline: Promise<string>;
	    readonly relationshipLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly relationshipLastName: Promise<string>;
	    readonly relationshipProfessionalCategory: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly relationshipState: Promise<string>;
	    readonly relationshipTitle: Promise<sageX3System.enums.Title | null>;
	    readonly relationshipType: Promise<sageX3System.enums.ContactType | null>;
	    readonly relationshipZipCode: Promise<string>;
	}
	//# sourceMappingURL=company-contact.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/company-bank-detail.d.ts
declare module '@sage/x3-master-data/lib/nodes/company-bank-detail' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CompanyBankDetail extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly company: Reference<sageX3System.nodes.Company | null>;
	    readonly bankId: Promise<string>;
	    readonly address: Reference<sageX3MasterData.nodes.CompanyAddress | null>;
	    readonly byDefault: Promise<boolean>;
	    readonly beneficiary: Promise<string>;
	    readonly payingBank1: Promise<string>;
	    readonly payingBank2: Promise<string>;
	    readonly payingBank3: Promise<string>;
	    readonly payingBank4: Promise<string>;
	    readonly ibanPrefix: Promise<string>;
	    readonly bic: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly intermediaryBankName: Promise<string>;
	    readonly intermediaryBankAddress1: Promise<string>;
	    readonly intermediaryBankAddress2: Promise<string>;
	    readonly intermediaryBankAddress3: Promise<string>;
	    readonly intermediaryBankBic: Promise<string>;
	    readonly intermediaryBankCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly nonResidentAccount: Promise<boolean>;
	    readonly isrCustomerNumber: Promise<string>;
	}
	//# sourceMappingURL=company-bank-detail.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/company-address.d.ts
declare module '@sage/x3-master-data/lib/nodes/company-address' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CompanyAddress extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly company: Reference<sageX3System.nodes.Company | null>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly defaultBankId: Reference<sageX3MasterData.nodes.CompanyBankDetail | null>;
	    readonly isDefault: Promise<boolean>;
	    readonly zipCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly state: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly website: Promise<string>;
	    readonly externalIdentifier: Promise<string>;
	    readonly isValid: Promise<boolean>;
	    readonly addressEmails: Collection<sageX3MasterData.nodes.CompanyAddressAddressEmails>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.CompanyAddressAddressLines>;
	    readonly addressPhoneNumbers: Collection<sageX3MasterData.nodes.CompanyAddressAddressPhoneNumbers>;
	}
	//# sourceMappingURL=company-address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/company-address-address-phone-numbers.d.ts
declare module '@sage/x3-master-data/lib/nodes/company-address-address-phone-numbers' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CompanyAddressAddressPhoneNumbers extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly company: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.CompanyAddress>;
	    readonly addressPhoneNumber: Promise<string>;
	    readonly phoneType: Promise<sageX3System.enums.TelephoneType | null>;
	}
	//# sourceMappingURL=company-address-address-phone-numbers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/company-address-address-lines.d.ts
declare module '@sage/x3-master-data/lib/nodes/company-address-address-lines' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CompanyAddressAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly company: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.CompanyAddress>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=company-address-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/company-address-address-emails.d.ts
declare module '@sage/x3-master-data/lib/nodes/company-address-address-emails' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CompanyAddressAddressEmails extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly company: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.CompanyAddress>;
	    readonly addressEmail: Promise<string>;
	    readonly emailType: Promise<sageX3System.enums.EmailAddressType | null>;
	}
	//# sourceMappingURL=company-address-address-emails.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/common-text.d.ts
declare module '@sage/x3-master-data/lib/nodes/common-text' {
	import { Node, TextStream } from '@sage/xtrem-core';
	export class CommonText extends Node {
	    readonly code: Promise<string>;
	    readonly text: Promise<TextStream>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly identifier3: Promise<string>;
	}
	//# sourceMappingURL=common-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/common-image.d.ts
declare module '@sage/x3-master-data/lib/nodes/common-image' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, BinaryStream } from '@sage/xtrem-core';
	export class CommonImage extends Node {
	    readonly code: Promise<string>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly fileName: Promise<string>;
	    readonly data: Promise<BinaryStream>;
	    readonly specialFileType: Promise<sageX3System.enums.TypeOfNonStandardFile | null>;
	}
	//# sourceMappingURL=common-image.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/carrier.d.ts
declare module '@sage/x3-master-data/lib/nodes/carrier' {
	import { Node, Reference, decimal, integer } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class Carrier extends Node {
	    readonly code: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly companyName: Promise<string>;
	    readonly shortCompanyName: Promise<string>;
	    readonly priceListManagement: Promise<boolean>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly coefficient: Promise<decimal | null>;
	    readonly printTransportNote: Promise<boolean>;
	    readonly noOfPriceColumns: Promise<integer | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly defaultAddress: Reference<sageX3MasterData.nodes.Address | null>;
	}
	//# sourceMappingURL=carrier.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/business-partner.d.ts
declare module '@sage/x3-master-data/lib/nodes/business-partner' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BusinessPartner extends Node {
	    readonly code: Promise<string>;
	    readonly isActive: Promise<boolean>;
	    readonly category: Reference<sageX3MasterData.nodes.CustomerCategory | null>;
	    readonly customerOrSupplierOriginCategory: Promise<string>;
	    readonly companyName1: Promise<string>;
	    readonly companyName2: Promise<string>;
	    readonly shortCompanyName: Promise<string>;
	    readonly europeanUnionVatNumber: Promise<string>;
	    readonly isIntersite: Promise<boolean>;
	    readonly businessPartnerSite: Reference<sageX3System.nodes.Site | null>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly siteIdentificationNumber: Promise<string>;
	    readonly standardIndustrialClassificationCode: Promise<string>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly language: Reference<sageX3System.nodes.Language>;
	    readonly acronym: Promise<string>;
	    readonly italianTaxNumber: Promise<string>;
	    readonly fiscalCode: Promise<string>;
	    readonly consolidationGroup: Reference<sageX3Structure.nodes.SiteGroupings | null>;
	    readonly consolidationCode: Promise<string>;
	    readonly isCustomer: Promise<boolean>;
	    readonly isSupplier: Promise<boolean>;
	    readonly isGrantor: Promise<boolean>;
	    readonly isCarrier: Promise<boolean>;
	    readonly isFactor: Promise<boolean>;
	    readonly isSalesRep: Promise<boolean>;
	    readonly isMiscellaneousBusinessPartner: Promise<boolean>;
	    readonly isProspect: Promise<boolean>;
	    readonly isServiceSupplier: Promise<boolean>;
	    readonly isServiceCaller: Promise<boolean>;
	    readonly defaultAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly defaultContact: Reference<sageX3MasterData.nodes.BusinessPartnerContact | null>;
	    readonly defaultBankId: Reference<sageX3MasterData.nodes.BusinessPartnerBankDetail | null>;
	    readonly bankIdCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly reportAccessCode: Reference<sageX3System.nodes.Access | null>;
	    readonly isMailingProhibited: Promise<boolean>;
	    readonly cfonbPaymentMethod: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly nonResidentAccount: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly isPhysicalPerson: Promise<boolean>;
	    readonly isCashExcluded: Promise<boolean>;
	    readonly documentType: Promise<sageX3MasterData.enums.DocumentType | null>;
	    readonly isPublicSector: Promise<boolean>;
	    readonly relatedCompany: Promise<sageX3MasterData.enums.RelatedCompanySettings | null>;
	    readonly consolidationPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly registrationNumber: Promise<string>;
	    readonly vatNumber: Promise<string>;
	    readonly economicOperatorRegistrationAndIdNumber: Promise<string>;
	    readonly serviceCode: Promise<string>;
	    readonly routingCode: Promise<string>;
	    readonly electronicInvoiceType: Promise<sageX3MasterData.enums.ElectronicInvoiceType | null>;
	    readonly mappingCode: Reference<sageX3MasterData.nodes.Mapping | null>;
	    readonly electronicAddress: Promise<string>;
	    readonly addresses: Collection<sageX3MasterData.nodes.BusinessPartnerAddress>;
	    readonly contacts: Collection<sageX3MasterData.nodes.BusinessPartnerContact>;
	    readonly bankDetails: Collection<sageX3MasterData.nodes.BusinessPartnerBankDetail>;
	    readonly companyException: Collection<sageX3MasterData.nodes.BusinessPartnerCompanyException>;
	    readonly companyNames: Collection<sageX3MasterData.nodes.BusinessPartnerCompanyNames>;
	}
	//# sourceMappingURL=business-partner.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/business-partner-contact.d.ts
declare module '@sage/x3-master-data/lib/nodes/business-partner-contact' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection, date } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BusinessPartnerContact extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly code: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly position: Promise<sageX3MasterData.enums.FunctionContact | null>;
	    readonly department: Promise<string>;
	    readonly role: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly defaultAddress: Promise<string>;
	    readonly landline: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly email: Promise<string>;
	    readonly cellPhone: Promise<string>;
	    readonly isDataProtectionOfficer: Promise<boolean>;
	    readonly contactRelationship: Reference<sageX3MasterData.nodes.ContactRelationship>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.ContactRelationshipAddressLines>;
	    readonly relationshipCellPhone: Promise<string>;
	    readonly relationshipCity: Promise<string>;
	    readonly relationshipCountry: Reference<sageX3Structure.nodes.Country>;
	    readonly relationshipCountryName: Promise<string>;
	    readonly relationshipDateOfBirth: Promise<date | null>;
	    readonly relationshipEmail: Promise<string>;
	    readonly relationshipFax: Promise<string>;
	    readonly relationshipFirstName: Promise<string>;
	    readonly relationshipFullNameSearchKey: Promise<string>;
	    readonly relationshipIsMailingProhibited: Promise<boolean>;
	    readonly relationshipLandline: Promise<string>;
	    readonly relationshipLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly relationshipLastName: Promise<string>;
	    readonly relationshipProfessionalCategory: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly relationshipState: Promise<string>;
	    readonly relationshipTitle: Promise<sageX3System.enums.Title | null>;
	    readonly relationshipType: Promise<sageX3System.enums.ContactType | null>;
	    readonly relationshipZipCode: Promise<string>;
	}
	//# sourceMappingURL=business-partner-contact.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/business-partner-company-names.d.ts
declare module '@sage/x3-master-data/lib/nodes/business-partner-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BusinessPartnerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=business-partner-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/business-partner-company-exception.d.ts
declare module '@sage/x3-master-data/lib/nodes/business-partner-company-exception' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BusinessPartnerCompanyException extends Node {
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly isAuthorizedEntry: Promise<boolean>;
	    readonly contractualPeriod: Promise<integer | null>;
	    readonly isCashExcluded: Promise<boolean>;
	    readonly electronicInvoiceType: Promise<sageX3MasterData.enums.ElectronicInvoiceType | null>;
	    readonly mappingCode: Reference<sageX3MasterData.nodes.Mapping | null>;
	    readonly registrationAgreement: Promise<string>;
	}
	//# sourceMappingURL=business-partner-company-exception.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/business-partner-bank-detail.d.ts
declare module '@sage/x3-master-data/lib/nodes/business-partner-bank-detail' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BusinessPartnerBankDetail extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly bankId: Promise<string>;
	    readonly address: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly byDefault: Promise<boolean>;
	    readonly beneficiary: Promise<string>;
	    readonly payingBank1: Promise<string>;
	    readonly payingBank2: Promise<string>;
	    readonly payingBank3: Promise<string>;
	    readonly payingBank4: Promise<string>;
	    readonly ibanPrefix: Promise<string>;
	    readonly bic: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly intermediaryBankName: Promise<string>;
	    readonly intermediaryBankAddress1: Promise<string>;
	    readonly intermediaryBankAddress2: Promise<string>;
	    readonly intermediaryBankAddress3: Promise<string>;
	    readonly intermediaryBankBic: Promise<string>;
	    readonly intermediaryBankCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly nonResidentAccount: Promise<boolean>;
	    readonly isrCustomerNumber: Promise<string>;
	}
	//# sourceMappingURL=business-partner-bank-detail.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/business-partner-address.d.ts
declare module '@sage/x3-master-data/lib/nodes/business-partner-address' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BusinessPartnerAddress extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly defaultBankId: Reference<sageX3MasterData.nodes.BusinessPartnerBankDetail | null>;
	    readonly isDefault: Promise<boolean>;
	    readonly zipCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly state: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly website: Promise<string>;
	    readonly externalIdentifier: Promise<string>;
	    readonly isValid: Promise<boolean>;
	    readonly addressEmails: Collection<sageX3MasterData.nodes.BusinessPartnerAddressAddressEmails>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.BusinessPartnerAddressAddressLines>;
	    readonly addressPhoneNumbers: Collection<sageX3MasterData.nodes.BusinessPartnerAddressAddressPhoneNumbers>;
	}
	//# sourceMappingURL=business-partner-address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/business-partner-address-address-phone-numbers.d.ts
declare module '@sage/x3-master-data/lib/nodes/business-partner-address-address-phone-numbers' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BusinessPartnerAddressAddressPhoneNumbers extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly businessPartner: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.BusinessPartnerAddress>;
	    readonly addressPhoneNumber: Promise<string>;
	    readonly phoneType: Promise<sageX3System.enums.TelephoneType | null>;
	}
	//# sourceMappingURL=business-partner-address-address-phone-numbers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/business-partner-address-address-lines.d.ts
declare module '@sage/x3-master-data/lib/nodes/business-partner-address-address-lines' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BusinessPartnerAddressAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly businessPartner: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.BusinessPartnerAddress>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=business-partner-address-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/business-partner-address-address-emails.d.ts
declare module '@sage/x3-master-data/lib/nodes/business-partner-address-address-emails' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BusinessPartnerAddressAddressEmails extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly businessPartner: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.BusinessPartnerAddress>;
	    readonly addressEmail: Promise<string>;
	    readonly emailType: Promise<sageX3System.enums.EmailAddressType | null>;
	}
	//# sourceMappingURL=business-partner-address-address-emails.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/bom-routing.d.ts
declare module '@sage/x3-master-data/lib/nodes/bom-routing' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BomRouting extends Node {
	    readonly code: Promise<integer | null>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly accessCode: Reference<sageX3System.nodes.Access | null>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly isProductionUtilization: Promise<boolean>;
	    readonly isCostUtilization: Promise<boolean>;
	    readonly isRccpUtilization: Promise<boolean>;
	    readonly bomCode1: Reference<sageX3MasterData.nodes.BomCodes | null>;
	    readonly bomCode2: Reference<sageX3MasterData.nodes.BomCodes | null>;
	    readonly bomCode3: Reference<sageX3MasterData.nodes.BomCodes | null>;
	}
	//# sourceMappingURL=bom-routing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/bom-product.d.ts
declare module '@sage/x3-master-data/lib/nodes/bom-product' {
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BomProduct extends Node {
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly bomCode: Promise<integer | null>;
	    readonly lowestLevelCodeType: Promise<sageX3MasterData.enums.LowLevelType>;
	    readonly lowestLevelCode: Promise<integer | null>;
	    readonly isBomExistence: Promise<boolean>;
	    readonly isWhereUsedExistence: Promise<boolean>;
	}
	//# sourceMappingURL=bom-product.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/bom-header.d.ts
declare module '@sage/x3-master-data/lib/nodes/bom-header' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BomHeader extends Node {
	    readonly parentProduct: Reference<sageX3MasterData.nodes.Product>;
	    readonly bomCode: Reference<sageX3MasterData.nodes.BomCodes>;
	    readonly bomType: Promise<sageX3MasterData.enums.BomCodeType | null>;
	    readonly description: Promise<string>;
	    readonly useStatus: Promise<sageX3MasterData.enums.UseStatus | null>;
	    readonly isPrototype: Promise<boolean>;
	    readonly validityStartDate: Promise<date | null>;
	    readonly validityEndDate: Promise<date | null>;
	    readonly reviewLevel: Promise<string>;
	    readonly baseQuantity: Promise<decimal | null>;
	    readonly managementUnit: Promise<sageX3MasterData.enums.ManagementUnit | null>;
	    readonly headerText: Promise<string>;
	    readonly journalNumberConfig: Promise<string>;
	    readonly accessCode: Reference<sageX3System.nodes.Access | null>;
	    readonly linkedDocuments: Promise<string>;
	    readonly details: Collection<sageX3MasterData.nodes.BomDetail>;
	}
	//# sourceMappingURL=bom-header.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/bom-detail.d.ts
declare module '@sage/x3-master-data/lib/nodes/bom-detail' {
	import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BomDetail extends Node {
	    readonly parentProduct: Reference<sageX3MasterData.nodes.Product>;
	    readonly bomCode: Reference<sageX3MasterData.nodes.BomHeader>;
	    readonly sequence: Promise<integer>;
	    readonly componentProduct: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly bomType: Promise<sageX3MasterData.enums.BomCodeType>;
	    readonly sequenceRemainder: Promise<integer | null>;
	    readonly componentType: Promise<sageX3MasterData.enums.ComponentType | null>;
	    readonly linkDescription: Promise<string>;
	    readonly firstValidLot: Promise<string>;
	    readonly lastValidLot: Promise<string>;
	    readonly validityStartDate: Promise<date | null>;
	    readonly validityEndDate: Promise<date | null>;
	    readonly linkQuantityCode: Promise<sageX3MasterData.enums.BomQuantityLink | null>;
	    readonly quantityRounding: Promise<sageX3MasterData.enums.ComponentRounded | null>;
	    readonly uom: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly uomStockFactor: Promise<decimal | null>;
	    readonly uomLinkQuantity: Promise<decimal | null>;
	    readonly linkQuantity: Promise<decimal | null>;
	    readonly scrapFactorPercentage: Promise<decimal | null>;
	    readonly routingOperation: Promise<integer | null>;
	    readonly routingOperationSuffix: Promise<integer | null>;
	    readonly operationLeadTime: Promise<integer | null>;
	    readonly isPrintMaterialNote: Promise<boolean>;
	    readonly isPrintAcknowledgment: Promise<boolean>;
	    readonly isPrintPackingSlip: Promise<boolean>;
	    readonly isPrintInvoice: Promise<boolean>;
	    readonly linkReviewIndex: Promise<string>;
	    readonly isValuation: Promise<boolean>;
	    readonly pickListCode: Promise<sageX3MasterData.enums.CodeToServe | null>;
	    readonly weighingPositiveTolerancePercentage: Promise<decimal | null>;
	    readonly weighingNegativeTolerancePercentage: Promise<decimal | null>;
	    readonly setupLevel: Promise<sageX3MasterData.enums.ToleranceDefinitionLevel | null>;
	    readonly typeOfSupply: Promise<sageX3MasterData.enums.MaterialReplenishType | null>;
	    readonly selectionFormula: Promise<string>;
	    readonly quantityFormula: Promise<string>;
	    readonly majorVersion: Promise<string>;
	    readonly minorVersion: Promise<string>;
	    readonly revisionGroup: Promise<integer | null>;
	    readonly masterContainer: Promise<string>;
	}
	//# sourceMappingURL=bom-detail.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/bom-codes.d.ts
declare module '@sage/x3-master-data/lib/nodes/bom-codes' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BomCodes extends Node {
	    readonly bomType: Promise<sageX3MasterData.enums.BomCodeType>;
	    readonly code: Promise<integer>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly accessCode: Reference<sageX3System.nodes.Access | null>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly isProductionUtilization: Promise<boolean>;
	    readonly isCostUtilization: Promise<boolean>;
	    readonly isMrpUtilization: Promise<boolean>;
	    readonly isMpsUtilization: Promise<boolean>;
	}
	//# sourceMappingURL=bom-codes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/bank-detail.d.ts
declare module '@sage/x3-master-data/lib/nodes/bank-detail' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class BankDetail extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly entityNumber: Promise<string>;
	    readonly bankId: Promise<string>;
	    readonly address: Reference<sageX3MasterData.nodes.Address | null>;
	    readonly byDefault: Promise<boolean>;
	    readonly beneficiary: Promise<string>;
	    readonly payingBank1: Promise<string>;
	    readonly payingBank2: Promise<string>;
	    readonly payingBank3: Promise<string>;
	    readonly payingBank4: Promise<string>;
	    readonly ibanPrefix: Promise<string>;
	    readonly bic: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly intermediaryBankName: Promise<string>;
	    readonly intermediaryBankAddress1: Promise<string>;
	    readonly intermediaryBankAddress2: Promise<string>;
	    readonly intermediaryBankAddress3: Promise<string>;
	    readonly intermediaryBankBic: Promise<string>;
	    readonly intermediaryBankCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly nonResidentAccount: Promise<boolean>;
	    readonly isrCustomerNumber: Promise<string>;
	}
	//# sourceMappingURL=bank-detail.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/address.d.ts
declare module '@sage/x3-master-data/lib/nodes/address' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class Address extends Node {
	    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
	    readonly entityNumber: Promise<string>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly defaultBankId: Reference<sageX3MasterData.nodes.BankDetail | null>;
	    readonly isDefault: Promise<boolean>;
	    readonly zipCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly state: Promise<string>;
	    readonly country: Reference<sageX3Structure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly website: Promise<string>;
	    readonly externalIdentifier: Promise<string>;
	    readonly isValid: Promise<boolean>;
	    readonly addressEmails: Collection<sageX3MasterData.nodes.AddressAddressEmails>;
	    readonly addressLines: Collection<sageX3MasterData.nodes.AddressAddressLines>;
	    readonly addressPhoneNumbers: Collection<sageX3MasterData.nodes.AddressAddressPhoneNumbers>;
	}
	//# sourceMappingURL=address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/address-address-phone-numbers.d.ts
declare module '@sage/x3-master-data/lib/nodes/address-address-phone-numbers' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class AddressAddressPhoneNumbers extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly entityNumber: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Address>;
	    readonly addressPhoneNumber: Promise<string>;
	    readonly phoneType: Promise<sageX3System.enums.TelephoneType | null>;
	}
	//# sourceMappingURL=address-address-phone-numbers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/address-address-lines.d.ts
declare module '@sage/x3-master-data/lib/nodes/address-address-lines' {
	import * as sageX3Structure from '@sage/x3-structure';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class AddressAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly entityNumber: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Address>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=address-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/nodes/address-address-emails.d.ts
declare module '@sage/x3-master-data/lib/nodes/address-address-emails' {
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class AddressAddressEmails extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entityType: Promise<sageX3Structure.enums.EntityType>;
	    readonly entityNumber: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Address>;
	    readonly addressEmail: Promise<string>;
	    readonly emailType: Promise<sageX3System.enums.EmailAddressType | null>;
	}
	//# sourceMappingURL=address-address-emails.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/node-extensions/site-extension.d.ts
declare module '@sage/x3-master-data/lib/node-extensions/site-extension' {
	import * as sageX3System from '@sage/x3-system';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class SiteExtension extends NodeExtension<sageX3System.nodes.Site> {
	    readonly unavailabilityCode: Reference<sageX3MasterData.nodes.UnavailablePeriods | null>;
	    readonly routingCode: Promise<string>;
	    readonly electronicAddress: Promise<string>;
	    readonly addresses: Collection<sageX3MasterData.nodes.SiteAddress>;
	    readonly contacts: Collection<sageX3MasterData.nodes.SiteContact>;
	    readonly bankDetails: Collection<sageX3MasterData.nodes.SiteBankDetail>;
	}
	declare module '@sage/x3-system/lib/nodes/site' {
	    interface Site extends SiteExtension {
	    }
	}
	//# sourceMappingURL=site-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-master-data/lib/node-extensions/index' {
	export * from '@sage/x3-master-data/lib/node-extensions/company-extension';
	export * from '@sage/x3-master-data/lib/node-extensions/generic-print-report-extension';
	export * from '@sage/x3-master-data/lib/node-extensions/site-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/node-extensions/generic-print-report-extension.d.ts
declare module '@sage/x3-master-data/lib/node-extensions/generic-print-report-extension' {
	import * as sageX3System from '@sage/x3-system';
	import { NodeExtension, Context } from '@sage/xtrem-core';
	export class GenericPrintReportExtension extends NodeExtension<sageX3System.nodes.GenericPrintReport> {
	    static printReport(context: Context, parameters: {
	        reportName: string;
	        language: string;
	        destination: string;
	        parametersNames: string[];
	        parametersValues: string[];
	        errorCode: number;
	    }): Promise<{
	        errorCode: number;
	    }>;
	}
	declare module '@sage/x3-system/lib/nodes/generic-print-report' {
	    interface GenericPrintReport extends GenericPrintReportExtension {
	    }
	}
	//# sourceMappingURL=generic-print-report-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/node-extensions/company-extension.d.ts
declare module '@sage/x3-master-data/lib/node-extensions/company-extension' {
	import * as sageX3System from '@sage/x3-system';
	import { NodeExtension, Collection } from '@sage/xtrem-core';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export class CompanyExtension extends NodeExtension<sageX3System.nodes.Company> {
	    readonly serviceId: Promise<string>;
	    readonly addresses: Collection<sageX3MasterData.nodes.CompanyAddress>;
	    readonly contacts: Collection<sageX3MasterData.nodes.CompanyContact>;
	    readonly bankDetails: Collection<sageX3MasterData.nodes.CompanyBankDetail>;
	}
	declare module '@sage/x3-system/lib/nodes/company' {
	    interface Company extends CompanyExtension {
	    }
	}
	//# sourceMappingURL=company-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/functions/node-status.d.ts
declare module '@sage/x3-master-data/lib/functions/node-status' {
	import { Node } from '@sage/xtrem-core';
	export function getNodeStatus(_this: Node): "C" | "U" | "D" | "R";
	//# sourceMappingURL=node-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/functions/index.d.ts
declare module '@sage/x3-master-data/lib/functions/index' {
	export * from '@sage/x3-master-data/lib/functions/address';
	export * from '@sage/x3-master-data/lib/functions/compute-capacity-day-name';
	export * from '@sage/x3-master-data/lib/functions/compute-weekly-capacity';
	export * from '@sage/x3-master-data/lib/functions/node-status';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/functions/compute-weekly-capacity.d.ts
declare module '@sage/x3-master-data/lib/functions/compute-weekly-capacity' {
	import { WeeklyStructure } from '@sage/x3-master-data/lib/nodes/index';
	export function computeWeeklyCapacity(_this: WeeklyStructure): Promise<number>;
	//# sourceMappingURL=compute-weekly-capacity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/functions/compute-capacity-day-name.d.ts
declare module '@sage/x3-master-data/lib/functions/compute-capacity-day-name' {
	import { WeeklyStructureWeeklyStructureDailyCapacity } from '@sage/x3-master-data/lib/nodes/index';
	export function computeCapacityDayName(_this: WeeklyStructureWeeklyStructureDailyCapacity): Promise<string>;
	//# sourceMappingURL=compute-capacity-day-name.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/functions/address.d.ts
declare module '@sage/x3-master-data/lib/functions/address' {
	import * as sageX3System from '@sage/x3-system';
	import * as sageX3MasterData from '@sage/x3-master-data/lib/index';
	export function getPhoneNumberType(_this: sageX3MasterData.nodes.BusinessPartnerAddressAddressPhoneNumbers | sageX3MasterData.nodes.AddressAddressPhoneNumbers | sageX3MasterData.nodes.CompanyAddressAddressPhoneNumbers | sageX3MasterData.nodes.SiteAddressAddressPhoneNumbers | sageX3MasterData.nodes.CustomerAddressAddressPhoneNumbers | sageX3MasterData.nodes.SupplierAddressAddressPhoneNumbers | sageX3MasterData.nodes.ProspectAddressAddressPhoneNumbers | null): Promise<sageX3System.enums.TelephoneType | null>;
	export function getEmailType(_this: sageX3MasterData.nodes.BusinessPartnerAddressAddressEmails | sageX3MasterData.nodes.AddressAddressEmails | sageX3MasterData.nodes.CompanyAddressAddressEmails | sageX3MasterData.nodes.SiteAddressAddressEmails | sageX3MasterData.nodes.CustomerAddressAddressEmails | sageX3MasterData.nodes.SupplierAddressAddressEmails | sageX3MasterData.nodes.ProspectAddressAddressEmails | null): Promise<sageX3System.enums.EmailAddressType | null>;
	//# sourceMappingURL=address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/work-in-progress-control.d.ts
declare module '@sage/x3-master-data/lib/enums/work-in-progress-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkInProgressControlEnum {
	    check = 1,
	    noCheck = 2,
	    hold = 3
	}
	export interface WorkInProgressControl$EnumInterface {
	    check: 1;
	    noCheck: 2;
	    hold: 3;
	}
	export type WorkInProgressControl = keyof WorkInProgressControl$EnumInterface;
	export const workInProgressControlDatatype: X3EnumDataType<keyof WorkInProgressControl$EnumInterface, unknown>;
	//# sourceMappingURL=work-in-progress-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/withholding-type.d.ts
declare module '@sage/x3-master-data/lib/enums/withholding-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WithholdingTypeEnum {
	    onPayment = 1,
	    onInvoice = 2
	}
	export interface WithholdingType$EnumInterface {
	    onPayment: 1;
	    onInvoice: 2;
	}
	export type WithholdingType = keyof WithholdingType$EnumInterface;
	export const withholdingTypeDatatype: X3EnumDataType<keyof WithholdingType$EnumInterface, unknown>;
	//# sourceMappingURL=withholding-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/withholding-category.d.ts
declare module '@sage/x3-master-data/lib/enums/withholding-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WithholdingCategoryEnum {
	    atSource = 1,
	    inps = 2,
	    enasarco = 3,
	    firr = 4,
	    other = 5,
	    vat = 6,
	    grossIncome = 7,
	    gains = 8,
	    suss = 9,
	    w3 = 10,
	    w4 = 11
	}
	export interface WithholdingCategory$EnumInterface {
	    atSource: 1;
	    inps: 2;
	    enasarco: 3;
	    firr: 4;
	    other: 5;
	    vat: 6;
	    grossIncome: 7;
	    gains: 8;
	    suss: 9;
	    w3: 10;
	    w4: 11;
	}
	export type WithholdingCategory = keyof WithholdingCategory$EnumInterface;
	export const withholdingCategoryDatatype: X3EnumDataType<keyof WithholdingCategory$EnumInterface, unknown>;
	//# sourceMappingURL=withholding-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/wip-selection.d.ts
declare module '@sage/x3-master-data/lib/enums/wip-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WipSelectionEnum {
	    globalWipStatus = 1,
	    statusOfPostedWip = 2
	}
	export interface WipSelection$EnumInterface {
	    globalWipStatus: 1;
	    statusOfPostedWip: 2;
	}
	export type WipSelection = keyof WipSelection$EnumInterface;
	export const wipSelectionDatatype: X3EnumDataType<keyof WipSelection$EnumInterface, unknown>;
	//# sourceMappingURL=wip-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/wip-control-exchange-rate.d.ts
declare module '@sage/x3-master-data/lib/enums/wip-control-exchange-rate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WipControlExchangeRateEnum {
	    historicalRate = 1,
	    revisedRate = 2
	}
	export interface WipControlExchangeRate$EnumInterface {
	    historicalRate: 1;
	    revisedRate: 2;
	}
	export type WipControlExchangeRate = keyof WipControlExchangeRate$EnumInterface;
	export const wipControlExchangeRateDatatype: X3EnumDataType<keyof WipControlExchangeRate$EnumInterface, unknown>;
	//# sourceMappingURL=wip-control-exchange-rate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/webservice-for-eu-vat-id-check.d.ts
declare module '@sage/x3-master-data/lib/enums/webservice-for-eu-vat-id-check' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WebserviceForEuVatIdCheckEnum {
	    none = 1,
	    eu = 2,
	    germany = 3
	}
	export interface WebserviceForEuVatIdCheck$EnumInterface {
	    none: 1;
	    eu: 2;
	    germany: 3;
	}
	export type WebserviceForEuVatIdCheck = keyof WebserviceForEuVatIdCheck$EnumInterface;
	export const webserviceForEuVatIdCheckDatatype: X3EnumDataType<keyof WebserviceForEuVatIdCheck$EnumInterface, unknown>;
	//# sourceMappingURL=webservice-for-eu-vat-id-check.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/waste-disposal-management.d.ts
declare module '@sage/x3-master-data/lib/enums/waste-disposal-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WasteDisposalManagementEnum {
	    germany = 1,
	    austria = 2
	}
	export interface WasteDisposalManagement$EnumInterface {
	    germany: 1;
	    austria: 2;
	}
	export type WasteDisposalManagement = keyof WasteDisposalManagement$EnumInterface;
	export const wasteDisposalManagementDatatype: X3EnumDataType<keyof WasteDisposalManagement$EnumInterface, unknown>;
	//# sourceMappingURL=waste-disposal-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/waste-disposal-management-3687.d.ts
declare module '@sage/x3-master-data/lib/enums/waste-disposal-management-3687' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WasteDisposalManagement3687Enum {
	    productGroup = 1,
	    packingMaterial = 2,
	    packSize = 3,
	    tariffType = 4,
	    tariffCategory = 5
	}
	export interface WasteDisposalManagement3687$EnumInterface {
	    productGroup: 1;
	    packingMaterial: 2;
	    packSize: 3;
	    tariffType: 4;
	    tariffCategory: 5;
	}
	export type WasteDisposalManagement3687 = keyof WasteDisposalManagement3687$EnumInterface;
	export const wasteDisposalManagement3687Datatype: X3EnumDataType<keyof WasteDisposalManagement3687$EnumInterface, unknown>;
	//# sourceMappingURL=waste-disposal-management-3687.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/warranty-voucher-source.d.ts
declare module '@sage/x3-master-data/lib/enums/warranty-voucher-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WarrantyVoucherSourceEnum {
	    salesOrder = 1,
	    salesDelivery = 2,
	    salesInvoice = 3
	}
	export interface WarrantyVoucherSource$EnumInterface {
	    salesOrder: 1;
	    salesDelivery: 2;
	    salesInvoice: 3;
	}
	export type WarrantyVoucherSource = keyof WarrantyVoucherSource$EnumInterface;
	export const warrantyVoucherSourceDatatype: X3EnumDataType<keyof WarrantyVoucherSource$EnumInterface, unknown>;
	//# sourceMappingURL=warranty-voucher-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/voucher-creation.d.ts
declare module '@sage/x3-master-data/lib/enums/voucher-creation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VoucherCreationEnum {
	    none = 1,
	    all = 2,
	    productsManagedBySerialNumber = 3,
	    productsNotManagedBySerialNumber = 4,
	    productsManagedInSerialNumberWithWarranty = 5,
	    productsNotManagedInSerialNumberWithWarranty = 6,
	    productsManagedInSerialNumberWithoutWarranty = 7,
	    productsNotManagedInSerialNumberWithoutWarranty = 8,
	    productsWithWarranty = 9,
	    productsWithoutWarranty = 10
	}
	export interface VoucherCreation$EnumInterface {
	    none: 1;
	    all: 2;
	    productsManagedBySerialNumber: 3;
	    productsNotManagedBySerialNumber: 4;
	    productsManagedInSerialNumberWithWarranty: 5;
	    productsNotManagedInSerialNumberWithWarranty: 6;
	    productsManagedInSerialNumberWithoutWarranty: 7;
	    productsNotManagedInSerialNumberWithoutWarranty: 8;
	    productsWithWarranty: 9;
	    productsWithoutWarranty: 10;
	}
	export type VoucherCreation = keyof VoucherCreation$EnumInterface;
	export const voucherCreationDatatype: X3EnumDataType<keyof VoucherCreation$EnumInterface, unknown>;
	//# sourceMappingURL=voucher-creation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/version-status.d.ts
declare module '@sage/x3-master-data/lib/enums/version-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VersionStatusEnum {
	    prototypeVersion = 1,
	    activeVersion = 2,
	    stoppedVersion = 3,
	    toActivateVersion = 4
	}
	export interface VersionStatus$EnumInterface {
	    prototypeVersion: 1;
	    activeVersion: 2;
	    stoppedVersion: 3;
	    toActivateVersion: 4;
	}
	export type VersionStatus = keyof VersionStatus$EnumInterface;
	export const versionStatusDatatype: X3EnumDataType<keyof VersionStatus$EnumInterface, unknown>;
	//# sourceMappingURL=version-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/verification-status.d.ts
declare module '@sage/x3-master-data/lib/enums/verification-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VerificationStatusEnum {
	    cannotBeVerified = 1,
	    verificationInProgress = 2,
	    notYetVerified = 3,
	    partiallyVerified = 4,
	    verified = 5,
	    allStatuses = 6
	}
	export interface VerificationStatus$EnumInterface {
	    cannotBeVerified: 1;
	    verificationInProgress: 2;
	    notYetVerified: 3;
	    partiallyVerified: 4;
	    verified: 5;
	    allStatuses: 6;
	}
	export type VerificationStatus = keyof VerificationStatus$EnumInterface;
	export const verificationStatusDatatype: X3EnumDataType<keyof VerificationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=verification-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/vehicle-tax-rate.d.ts
declare module '@sage/x3-master-data/lib/enums/vehicle-tax-rate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VehicleTaxRateEnum {
	    fullRate = 1,
	    substituteValue2 = 2,
	    totalExemption = 3,
	    co2Exemtion = 4,
	    ageExemption = 5
	}
	export interface VehicleTaxRate$EnumInterface {
	    fullRate: 1;
	    substituteValue2: 2;
	    totalExemption: 3;
	    co2Exemtion: 4;
	    ageExemption: 5;
	}
	export type VehicleTaxRate = keyof VehicleTaxRate$EnumInterface;
	export const vehicleTaxRateDatatype: X3EnumDataType<keyof VehicleTaxRate$EnumInterface, unknown>;
	//# sourceMappingURL=vehicle-tax-rate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/vehicle-receipt-type.d.ts
declare module '@sage/x3-master-data/lib/enums/vehicle-receipt-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VehicleReceiptTypeEnum {
	    nationalReception = 1,
	    euReception = 2,
	    other = 3
	}
	export interface VehicleReceiptType$EnumInterface {
	    nationalReception: 1;
	    euReception: 2;
	    other: 3;
	}
	export type VehicleReceiptType = keyof VehicleReceiptType$EnumInterface;
	export const vehicleReceiptTypeDatatype: X3EnumDataType<keyof VehicleReceiptType$EnumInterface, unknown>;
	//# sourceMappingURL=vehicle-receipt-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/vehicle-category-for-expenses.d.ts
declare module '@sage/x3-master-data/lib/enums/vehicle-category-for-expenses' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VehicleCategoryForExpensesEnum {
	    category1 = 1,
	    category2 = 2,
	    category3 = 3
	}
	export interface VehicleCategoryForExpenses$EnumInterface {
	    category1: 1;
	    category2: 2;
	    category3: 3;
	}
	export type VehicleCategoryForExpenses = keyof VehicleCategoryForExpenses$EnumInterface;
	export const vehicleCategoryForExpensesDatatype: X3EnumDataType<keyof VehicleCategoryForExpenses$EnumInterface, unknown>;
	//# sourceMappingURL=vehicle-category-for-expenses.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/vat-rule-for-dispoal.d.ts
declare module '@sage/x3-master-data/lib/enums/vat-rule-for-dispoal' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatRuleForDispoalEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    noVatAdjustment = 4,
	    deductibleVatAmountAdjustmentIncrease = 5,
	    deductibleVatAmountAdjustmentDecrease = 6
	}
	export interface VatRuleForDispoal$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    noVatAdjustment: 4;
	    deductibleVatAmountAdjustmentIncrease: 5;
	    deductibleVatAmountAdjustmentDecrease: 6;
	}
	export type VatRuleForDispoal = keyof VatRuleForDispoal$EnumInterface;
	export const vatRuleForDispoalDatatype: X3EnumDataType<keyof VatRuleForDispoal$EnumInterface, unknown>;
	//# sourceMappingURL=vat-rule-for-dispoal.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/variance-recovery-strategy.d.ts
declare module '@sage/x3-master-data/lib/enums/variance-recovery-strategy' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VarianceRecoveryStrategyEnum {
	    futureEffectiveDateFyStart = 1,
	    futureEffectiveDatePeriodStart = 2,
	    immediateRecoveryOverThePeriod = 3,
	    immediateRecoveryOverThePeriodExceptional = 4
	}
	export interface VarianceRecoveryStrategy$EnumInterface {
	    futureEffectiveDateFyStart: 1;
	    futureEffectiveDatePeriodStart: 2;
	    immediateRecoveryOverThePeriod: 3;
	    immediateRecoveryOverThePeriodExceptional: 4;
	}
	export type VarianceRecoveryStrategy = keyof VarianceRecoveryStrategy$EnumInterface;
	export const varianceRecoveryStrategyDatatype: X3EnumDataType<keyof VarianceRecoveryStrategy$EnumInterface, unknown>;
	//# sourceMappingURL=variance-recovery-strategy.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/value-type.d.ts
declare module '@sage/x3-master-data/lib/enums/value-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValueTypeEnum {
	    taxExcluded = 1,
	    taxIncluded = 2,
	    substituteValue3 = 3
	}
	export interface ValueType$EnumInterface {
	    taxExcluded: 1;
	    taxIncluded: 2;
	    substituteValue3: 3;
	}
	export type ValueType = keyof ValueType$EnumInterface;
	export const valueTypeDatatype: X3EnumDataType<keyof ValueType$EnumInterface, unknown>;
	//# sourceMappingURL=value-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/valuation.d.ts
declare module '@sage/x3-master-data/lib/enums/valuation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValuationEnum {
	    origin = 1,
	    destination = 2
	}
	export interface Valuation$EnumInterface {
	    origin: 1;
	    destination: 2;
	}
	export type Valuation = keyof Valuation$EnumInterface;
	export const valuationDatatype: X3EnumDataType<keyof Valuation$EnumInterface, unknown>;
	//# sourceMappingURL=valuation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/valuation-type.d.ts
declare module '@sage/x3-master-data/lib/enums/valuation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValuationTypeEnum {
	    fixedValue = 1,
	    userValue = 2,
	    mileage = 3
	}
	export interface ValuationType$EnumInterface {
	    fixedValue: 1;
	    userValue: 2;
	    mileage: 3;
	}
	export type ValuationType = keyof ValuationType$EnumInterface;
	export const valuationTypeDatatype: X3EnumDataType<keyof ValuationType$EnumInterface, unknown>;
	//# sourceMappingURL=valuation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/user-status.d.ts
declare module '@sage/x3-master-data/lib/enums/user-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UserStatusEnum {
	    permanent = 1,
	    temporary = 2,
	    partTime = 3
	}
	export interface UserStatus$EnumInterface {
	    permanent: 1;
	    temporary: 2;
	    partTime: 3;
	}
	export type UserStatus = keyof UserStatus$EnumInterface;
	export const userStatusDatatype: X3EnumDataType<keyof UserStatus$EnumInterface, unknown>;
	//# sourceMappingURL=user-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/user-role-2036.d.ts
declare module '@sage/x3-master-data/lib/enums/user-role-2036' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UserRole2036Enum {
	    select = 1,
	    juniorDeveloper = 2,
	    seniorDeveloper = 3,
	    teamLeader = 4,
	    productDevelopmentManager = 5,
	    juniorTester = 6,
	    seniorTester = 7,
	    author = 8
	}
	export interface UserRole2036$EnumInterface {
	    select: 1;
	    juniorDeveloper: 2;
	    seniorDeveloper: 3;
	    teamLeader: 4;
	    productDevelopmentManager: 5;
	    juniorTester: 6;
	    seniorTester: 7;
	    author: 8;
	}
	export type UserRole2036 = keyof UserRole2036$EnumInterface;
	export const userRole2036Datatype: X3EnumDataType<keyof UserRole2036$EnumInterface, unknown>;
	//# sourceMappingURL=user-role-2036.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/user-functions-enum.d.ts
declare module '@sage/x3-master-data/lib/enums/user-functions-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UserFunctionsEnumEnum {
	    salesEngineer = 1,
	    telesales = 2,
	    salesDirector = 3,
	    customerSupport = 4,
	    other = 5
	}
	export interface UserFunctionsEnum$EnumInterface {
	    salesEngineer: 1;
	    telesales: 2;
	    salesDirector: 3;
	    customerSupport: 4;
	    other: 5;
	}
	export type UserFunctionsEnum = keyof UserFunctionsEnum$EnumInterface;
	export const userFunctionsEnumDatatype: X3EnumDataType<keyof UserFunctionsEnum$EnumInterface, unknown>;
	//# sourceMappingURL=user-functions-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/user-functions-3022.d.ts
declare module '@sage/x3-master-data/lib/enums/user-functions-3022' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UserFunctions3022Enum {
	    other = 1,
	    salesEngineer = 2,
	    teleSales = 3,
	    commercialManager = 4,
	    customerSupport = 5,
	    followUp = 6
	}
	export interface UserFunctions3022$EnumInterface {
	    other: 1;
	    salesEngineer: 2;
	    teleSales: 3;
	    commercialManager: 4;
	    customerSupport: 5;
	    followUp: 6;
	}
	export type UserFunctions3022 = keyof UserFunctions3022$EnumInterface;
	export const userFunctions3022Datatype: X3EnumDataType<keyof UserFunctions3022$EnumInterface, unknown>;
	//# sourceMappingURL=user-functions-3022.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/user-department.d.ts
declare module '@sage/x3-master-data/lib/enums/user-department' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UserDepartmentEnum {
	    select = 1,
	    rD = 2,
	    support = 3,
	    sales = 4
	}
	export interface UserDepartment$EnumInterface {
	    select: 1;
	    rD: 2;
	    support: 3;
	    sales: 4;
	}
	export type UserDepartment = keyof UserDepartment$EnumInterface;
	export const userDepartmentDatatype: X3EnumDataType<keyof UserDepartment$EnumInterface, unknown>;
	//# sourceMappingURL=user-department.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/use.d.ts
declare module '@sage/x3-master-data/lib/enums/use' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UseEnum {
	    substituteValue1 = 1,
	    lastLevel = 2,
	    multilevel = 3,
	    multilevelCumulative = 4,
	    phantomSAt1stLevel = 5
	}
	export interface Use$EnumInterface {
	    substituteValue1: 1;
	    lastLevel: 2;
	    multilevel: 3;
	    multilevelCumulative: 4;
	    phantomSAt1stLevel: 5;
	}
	export type Use = keyof Use$EnumInterface;
	export const useDatatype: X3EnumDataType<keyof Use$EnumInterface, unknown>;
	//# sourceMappingURL=use.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/use-status.d.ts
declare module '@sage/x3-master-data/lib/enums/use-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UseStatusEnum {
	    inDevelopment = 1,
	    availableToUse = 2
	}
	export interface UseStatus$EnumInterface {
	    inDevelopment: 1;
	    availableToUse: 2;
	}
	export type UseStatus = keyof UseStatus$EnumInterface;
	export const useStatusDatatype: X3EnumDataType<keyof UseStatus$EnumInterface, unknown>;
	//# sourceMappingURL=use-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/use-search-term-list.d.ts
declare module '@sage/x3-master-data/lib/enums/use-search-term-list' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UseSearchTermListEnum {
	    no = 1,
	    firstPass = 2,
	    lastPass = 3
	}
	export interface UseSearchTermList$EnumInterface {
	    no: 1;
	    firstPass: 2;
	    lastPass: 3;
	}
	export type UseSearchTermList = keyof UseSearchTermList$EnumInterface;
	export const useSearchTermListDatatype: X3EnumDataType<keyof UseSearchTermList$EnumInterface, unknown>;
	//# sourceMappingURL=use-search-term-list.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/update-during-count.d.ts
declare module '@sage/x3-master-data/lib/enums/update-during-count' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UpdateDuringCountEnum {
	    held = 1,
	    deferred = 2,
	    direct = 3
	}
	export interface UpdateDuringCount$EnumInterface {
	    held: 1;
	    deferred: 2;
	    direct: 3;
	}
	export type UpdateDuringCount = keyof UpdateDuringCount$EnumInterface;
	export const updateDuringCountDatatype: X3EnumDataType<keyof UpdateDuringCount$EnumInterface, unknown>;
	//# sourceMappingURL=update-during-count.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/upd-fields-split.d.ts
declare module '@sage/x3-master-data/lib/enums/upd-fields-split' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UpdFieldsSplitEnum {
	    substituteValue1 = 1,
	    description1 = 2,
	    description2 = 3,
	    group = 4,
	    accountingCode = 5,
	    freeField1 = 6,
	    freeField2 = 7,
	    freeField3 = 8,
	    freeField4 = 9,
	    freeField5 = 10,
	    freeField6 = 11,
	    freeField7 = 12,
	    freeField8 = 13,
	    freeField9 = 14,
	    freeField10 = 15
	}
	export interface UpdFieldsSplit$EnumInterface {
	    substituteValue1: 1;
	    description1: 2;
	    description2: 3;
	    group: 4;
	    accountingCode: 5;
	    freeField1: 6;
	    freeField2: 7;
	    freeField3: 8;
	    freeField4: 9;
	    freeField5: 10;
	    freeField6: 11;
	    freeField7: 12;
	    freeField8: 13;
	    freeField9: 14;
	    freeField10: 15;
	}
	export type UpdFieldsSplit = keyof UpdFieldsSplit$EnumInterface;
	export const updFieldsSplitDatatype: X3EnumDataType<keyof UpdFieldsSplit$EnumInterface, unknown>;
	//# sourceMappingURL=upd-fields-split.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/unpacking-rules-pac.d.ts
declare module '@sage/x3-master-data/lib/enums/unpacking-rules-pac' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UnpackingRulesPacEnum {
	    unpack = 1,
	    adjustCoefficientRecalcPacCoeff = 2,
	    fractionCalculateDecimalPac = 3
	}
	export interface UnpackingRulesPac$EnumInterface {
	    unpack: 1;
	    adjustCoefficientRecalcPacCoeff: 2;
	    fractionCalculateDecimalPac: 3;
	}
	export type UnpackingRulesPac = keyof UnpackingRulesPac$EnumInterface;
	export const unpackingRulesPacDatatype: X3EnumDataType<keyof UnpackingRulesPac$EnumInterface, unknown>;
	//# sourceMappingURL=unpacking-rules-pac.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/unbalanced-payment.d.ts
declare module '@sage/x3-master-data/lib/enums/unbalanced-payment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UnbalancedPaymentEnum {
	    bankAdjustment = 1,
	    roundingVariance = 2,
	    manualCorrection = 3
	}
	export interface UnbalancedPayment$EnumInterface {
	    bankAdjustment: 1;
	    roundingVariance: 2;
	    manualCorrection: 3;
	}
	export type UnbalancedPayment = keyof UnbalancedPayment$EnumInterface;
	export const unbalancedPaymentDatatype: X3EnumDataType<keyof UnbalancedPayment$EnumInterface, unknown>;
	//# sourceMappingURL=unbalanced-payment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/types-of-vat-update.d.ts
declare module '@sage/x3-master-data/lib/enums/types-of-vat-update' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypesOfVatUpdateEnum {
	    creationOrIntegration = 1,
	    determinationOfRealDeductionCoefficient = 2,
	    variationOfTheDeductionCoeffOverTime = 3,
	    saleNotTaxed = 4,
	    transferOfSector = 5,
	    taxedSale = 6,
	    legalModificationsOfTheExclusionRules = 7,
	    assetBecomingUsed = 8,
	    assetNoLongerUsed = 9,
	    assetNoLongerUsedIssued = 10,
	    cancellationOfCoefficientVarianceInTime = 11,
	    saleCancelled = 12,
	    cancellationOfRealDeductionCoefficientDetermination = 13
	}
	export interface TypesOfVatUpdate$EnumInterface {
	    creationOrIntegration: 1;
	    determinationOfRealDeductionCoefficient: 2;
	    variationOfTheDeductionCoeffOverTime: 3;
	    saleNotTaxed: 4;
	    transferOfSector: 5;
	    taxedSale: 6;
	    legalModificationsOfTheExclusionRules: 7;
	    assetBecomingUsed: 8;
	    assetNoLongerUsed: 9;
	    assetNoLongerUsedIssued: 10;
	    cancellationOfCoefficientVarianceInTime: 11;
	    saleCancelled: 12;
	    cancellationOfRealDeductionCoefficientDetermination: 13;
	}
	export type TypesOfVatUpdate = keyof TypesOfVatUpdate$EnumInterface;
	export const typesOfVatUpdateDatatype: X3EnumDataType<keyof TypesOfVatUpdate$EnumInterface, unknown>;
	//# sourceMappingURL=types-of-vat-update.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/types-of-support-of-selection.d.ts
declare module '@sage/x3-master-data/lib/enums/types-of-support-of-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypesOfSupportOfSelectionEnum {
	    regroupingOfTables = 1,
	    process = 2,
	    allRecords = 3,
	    firstLevelLink = 4
	}
	export interface TypesOfSupportOfSelection$EnumInterface {
	    regroupingOfTables: 1;
	    process: 2;
	    allRecords: 3;
	    firstLevelLink: 4;
	}
	export type TypesOfSupportOfSelection = keyof TypesOfSupportOfSelection$EnumInterface;
	export const typesOfSupportOfSelectionDatatype: X3EnumDataType<keyof TypesOfSupportOfSelection$EnumInterface, unknown>;
	//# sourceMappingURL=types-of-support-of-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/types-of-response.d.ts
declare module '@sage/x3-master-data/lib/enums/types-of-response' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypesOfResponseEnum {
	    alphanumeric = 1,
	    numeric = 2,
	    date = 3,
	    boolean = 4
	}
	export interface TypesOfResponse$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	    date: 3;
	    boolean: 4;
	}
	export type TypesOfResponse = keyof TypesOfResponse$EnumInterface;
	export const typesOfResponseDatatype: X3EnumDataType<keyof TypesOfResponse$EnumInterface, unknown>;
	//# sourceMappingURL=types-of-response.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/types-of-distances.d.ts
declare module '@sage/x3-master-data/lib/enums/types-of-distances' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypesOfDistancesEnum {
	    kilometers = 1,
	    miles = 2
	}
	export interface TypesOfDistances$EnumInterface {
	    kilometers: 1;
	    miles: 2;
	}
	export type TypesOfDistances = keyof TypesOfDistances$EnumInterface;
	export const typesOfDistancesDatatype: X3EnumDataType<keyof TypesOfDistances$EnumInterface, unknown>;
	//# sourceMappingURL=types-of-distances.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/types-of-actions.d.ts
declare module '@sage/x3-master-data/lib/enums/types-of-actions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypesOfActionsEnum {
	    projects = 1,
	    appointment = 2,
	    call = 3,
	    task = 4,
	    helpDeskCall = 5,
	    helpDeskAction = 6,
	    massMailing = 7
	}
	export interface TypesOfActions$EnumInterface {
	    projects: 1;
	    appointment: 2;
	    call: 3;
	    task: 4;
	    helpDeskCall: 5;
	    helpDeskAction: 6;
	    massMailing: 7;
	}
	export type TypesOfActions = keyof TypesOfActions$EnumInterface;
	export const typesOfActionsDatatype: X3EnumDataType<keyof TypesOfActions$EnumInterface, unknown>;
	//# sourceMappingURL=types-of-actions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/types-of-actions-2963.d.ts
declare module '@sage/x3-master-data/lib/enums/types-of-actions-2963' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypesOfActions2963Enum {
	    actionsPerformed = 1,
	    actionsToBePerformed = 2
	}
	export interface TypesOfActions2963$EnumInterface {
	    actionsPerformed: 1;
	    actionsToBePerformed: 2;
	}
	export type TypesOfActions2963 = keyof TypesOfActions2963$EnumInterface;
	export const typesOfActions2963Datatype: X3EnumDataType<keyof TypesOfActions2963$EnumInterface, unknown>;
	//# sourceMappingURL=types-of-actions-2963.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type.d.ts
declare module '@sage/x3-master-data/lib/enums/type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeEnum {
	    functional = 1,
	    technical = 2,
	    transfer = 3
	}
	export interface Type$EnumInterface {
	    functional: 1;
	    technical: 2;
	    transfer: 3;
	}
	export type Type = keyof Type$EnumInterface;
	export const typeDatatype: X3EnumDataType<keyof Type$EnumInterface, unknown>;
	//# sourceMappingURL=type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-suggestion.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-suggestion' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfSuggestionEnum {
	    noProcessing = 1,
	    withMrpPegging = 2,
	    wthoutMrpPegging = 3,
	    mrpPeggingOnly = 4
	}
	export interface TypeOfSuggestion$EnumInterface {
	    noProcessing: 1;
	    withMrpPegging: 2;
	    wthoutMrpPegging: 3;
	    mrpPeggingOnly: 4;
	}
	export type TypeOfSuggestion = keyof TypeOfSuggestion$EnumInterface;
	export const typeOfSuggestionDatatype: X3EnumDataType<keyof TypeOfSuggestion$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-suggestion.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-prorata-temporis.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-prorata-temporis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfProrataTemporisEnum {
	    day = 1,
	    month = 2,
	    week = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6
	}
	export interface TypeOfProrataTemporis$EnumInterface {
	    day: 1;
	    month: 2;
	    week: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	}
	export type TypeOfProrataTemporis = keyof TypeOfProrataTemporis$EnumInterface;
	export const typeOfProrataTemporisDatatype: X3EnumDataType<keyof TypeOfProrataTemporis$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-prorata-temporis.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-product.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-product' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfProductEnum {
	    other = 1,
	    part = 2,
	    labor = 3,
	    expenses = 4,
	    serviceContract = 5
	}
	export interface TypeOfProduct$EnumInterface {
	    other: 1;
	    part: 2;
	    labor: 3;
	    expenses: 4;
	    serviceContract: 5;
	}
	export type TypeOfProduct = keyof TypeOfProduct$EnumInterface;
	export const typeOfProductDatatype: X3EnumDataType<keyof TypeOfProduct$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-product.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-merge.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-merge' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfMergeEnum {
	    useSeagateCrystalReport = 1,
	    useMicrosoftWord = 2,
	    generatedOnTheClientMachine = 3,
	    generatedOnTheServer = 4
	}
	export interface TypeOfMerge$EnumInterface {
	    useSeagateCrystalReport: 1;
	    useMicrosoftWord: 2;
	    generatedOnTheClientMachine: 3;
	    generatedOnTheServer: 4;
	}
	export type TypeOfMerge = keyof TypeOfMerge$EnumInterface;
	export const typeOfMergeDatatype: X3EnumDataType<keyof TypeOfMerge$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-merge.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-mailing-address.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-mailing-address' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfMailingAddressEnum {
	    byBusinessPartner = 1,
	    byContact = 2
	}
	export interface TypeOfMailingAddress$EnumInterface {
	    byBusinessPartner: 1;
	    byContact: 2;
	}
	export type TypeOfMailingAddress = keyof TypeOfMailingAddress$EnumInterface;
	export const typeOfMailingAddressDatatype: X3EnumDataType<keyof TypeOfMailingAddress$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-mailing-address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-edi-field.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-edi-field' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfEdiFieldEnum {
	    alphanumeric = 1,
	    numeric = 2,
	    alpha = 3
	}
	export interface TypeOfEdiField$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	    alpha: 3;
	}
	export type TypeOfEdiField = keyof TypeOfEdiField$EnumInterface;
	export const typeOfEdiFieldDatatype: X3EnumDataType<keyof TypeOfEdiField$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-edi-field.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-draft-managment.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-draft-managment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfDraftManagmentEnum {
	    french = 1,
	    spanish = 2,
	    portuguese = 3
	}
	export interface TypeOfDraftManagment$EnumInterface {
	    french: 1;
	    spanish: 2;
	    portuguese: 3;
	}
	export type TypeOfDraftManagment = keyof TypeOfDraftManagment$EnumInterface;
	export const typeOfDraftManagmentDatatype: X3EnumDataType<keyof TypeOfDraftManagment$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-draft-managment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-document.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-document' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfDocumentEnum {
	    customerQuote = 1,
	    customerOrder = 2,
	    supplierOrder = 3,
	    customerPackingSlip = 4,
	    supplierPackingSlip = 5,
	    customerInvoice = 6,
	    supplierInvoice = 7,
	    customerLoanOrder = 8,
	    customerLoanPackingSlip = 9
	}
	export interface TypeOfDocument$EnumInterface {
	    customerQuote: 1;
	    customerOrder: 2;
	    supplierOrder: 3;
	    customerPackingSlip: 4;
	    supplierPackingSlip: 5;
	    customerInvoice: 6;
	    supplierInvoice: 7;
	    customerLoanOrder: 8;
	    customerLoanPackingSlip: 9;
	}
	export type TypeOfDocument = keyof TypeOfDocument$EnumInterface;
	export const typeOfDocumentDatatype: X3EnumDataType<keyof TypeOfDocument$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-document.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-cover.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-cover' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfCoverEnum {
	    accordingToBase = 1,
	    accordingToProductReference = 2,
	    accordingToCommercialGroup = 3
	}
	export interface TypeOfCover$EnumInterface {
	    accordingToBase: 1;
	    accordingToProductReference: 2;
	    accordingToCommercialGroup: 3;
	}
	export type TypeOfCover = keyof TypeOfCover$EnumInterface;
	export const typeOfCoverDatatype: X3EnumDataType<keyof TypeOfCover$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-cover.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-consumption-default.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-consumption-default' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfConsumptionDefaultEnum {
	    part = 1,
	    labor = 2,
	    expenses = 3
	}
	export interface TypeOfConsumptionDefault$EnumInterface {
	    part: 1;
	    labor: 2;
	    expenses: 3;
	}
	export type TypeOfConsumptionDefault = keyof TypeOfConsumptionDefault$EnumInterface;
	export const typeOfConsumptionDefaultDatatype: X3EnumDataType<keyof TypeOfConsumptionDefault$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-consumption-default.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-concession-input.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-concession-input' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfConcessionInputEnum {
	    substituteValue1 = 1,
	    renewal = 2
	}
	export interface TypeOfConcessionInput$EnumInterface {
	    substituteValue1: 1;
	    renewal: 2;
	}
	export type TypeOfConcessionInput = keyof TypeOfConcessionInput$EnumInterface;
	export const typeOfConcessionInputDatatype: X3EnumDataType<keyof TypeOfConcessionInput$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-concession-input.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-charges.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-charges' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfChargesEnum {
	    freight = 1,
	    miscellaneous = 2,
	    fixed = 3
	}
	export interface TypeOfCharges$EnumInterface {
	    freight: 1;
	    miscellaneous: 2;
	    fixed: 3;
	}
	export type TypeOfCharges = keyof TypeOfCharges$EnumInterface;
	export const typeOfChargesDatatype: X3EnumDataType<keyof TypeOfCharges$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-charges.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-charge.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-charge' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfChargeEnum {
	    exempt = 1,
	    benefits = 2,
	    charges = 3,
	    commission = 4,
	    inps = 5,
	    vat = 6,
	    other = 7
	}
	export interface TypeOfCharge$EnumInterface {
	    exempt: 1;
	    benefits: 2;
	    charges: 3;
	    commission: 4;
	    inps: 5;
	    vat: 6;
	    other: 7;
	}
	export type TypeOfCharge = keyof TypeOfCharge$EnumInterface;
	export const typeOfChargeDatatype: X3EnumDataType<keyof TypeOfCharge$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-charge.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-asset-under-concession.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-asset-under-concession' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfAssetUnderConcessionEnum {
	    outOfNetwork = 1,
	    networked = 2
	}
	export interface TypeOfAssetUnderConcession$EnumInterface {
	    outOfNetwork: 1;
	    networked: 2;
	}
	export type TypeOfAssetUnderConcession = keyof TypeOfAssetUnderConcession$EnumInterface;
	export const typeOfAssetUnderConcessionDatatype: X3EnumDataType<keyof TypeOfAssetUnderConcession$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-asset-under-concession.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-allocation.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-allocation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfAllocationEnum {
	    global = 1,
	    detailed = 2,
	    notUsed1 = 3,
	    detailedShortage = 4,
	    globalShortage = 5,
	    notUsed2 = 6
	}
	export interface TypeOfAllocation$EnumInterface {
	    global: 1;
	    detailed: 2;
	    notUsed1: 3;
	    detailedShortage: 4;
	    globalShortage: 5;
	    notUsed2: 6;
	}
	export type TypeOfAllocation = keyof TypeOfAllocation$EnumInterface;
	export const typeOfAllocationDatatype: X3EnumDataType<keyof TypeOfAllocation$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-allocation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-after-sales-services-employee.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-after-sales-services-employee' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfAfterSalesServicesEmployeeEnum {
	    internalContact = 1,
	    externalServiceProvider = 2
	}
	export interface TypeOfAfterSalesServicesEmployee$EnumInterface {
	    internalContact: 1;
	    externalServiceProvider: 2;
	}
	export type TypeOfAfterSalesServicesEmployee = keyof TypeOfAfterSalesServicesEmployee$EnumInterface;
	export const typeOfAfterSalesServicesEmployeeDatatype: X3EnumDataType<keyof TypeOfAfterSalesServicesEmployee$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-after-sales-services-employee.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-address.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-address' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfAddressEnum {
	    contact = 1,
	    bp = 2,
	    company = 3,
	    site = 4
	}
	export interface TypeOfAddress$EnumInterface {
	    contact: 1;
	    bp: 2;
	    company: 3;
	    site: 4;
	}
	export type TypeOfAddress = keyof TypeOfAddress$EnumInterface;
	export const typeOfAddressDatatype: X3EnumDataType<keyof TypeOfAddress$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-address.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-of-accounting-codes.d.ts
declare module '@sage/x3-master-data/lib/enums/type-of-accounting-codes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfAccountingCodesEnum {
	    account = 1,
	    modifier = 2,
	    control = 3
	}
	export interface TypeOfAccountingCodes$EnumInterface {
	    account: 1;
	    modifier: 2;
	    control: 3;
	}
	export type TypeOfAccountingCodes = keyof TypeOfAccountingCodes$EnumInterface;
	export const typeOfAccountingCodesDatatype: X3EnumDataType<keyof TypeOfAccountingCodes$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-accounting-codes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-code.d.ts
declare module '@sage/x3-master-data/lib/enums/type-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeCodeEnum {
	    status = 1,
	    summary = 2,
	    detail = 3
	}
	export interface TypeCode$EnumInterface {
	    status: 1;
	    summary: 2;
	    detail: 3;
	}
	export type TypeCode = keyof TypeCode$EnumInterface;
	export const typeCodeDatatype: X3EnumDataType<keyof TypeCode$EnumInterface, unknown>;
	//# sourceMappingURL=type-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/type-3667.d.ts
declare module '@sage/x3-master-data/lib/enums/type-3667' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Type3667Enum {
	    data = 1,
	    segmentId = 2,
	    fieldId = 3,
	    constant = 4
	}
	export interface Type3667$EnumInterface {
	    data: 1;
	    segmentId: 2;
	    fieldId: 3;
	    constant: 4;
	}
	export type Type3667 = keyof Type3667$EnumInterface;
	export const type3667Datatype: X3EnumDataType<keyof Type3667$EnumInterface, unknown>;
	//# sourceMappingURL=type-3667.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/trigger.d.ts
declare module '@sage/x3-master-data/lib/enums/trigger' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TriggerEnum {
	    document = 1,
	    sourceDocument = 2
	}
	export interface Trigger$EnumInterface {
	    document: 1;
	    sourceDocument: 2;
	}
	export type Trigger = keyof Trigger$EnumInterface;
	export const triggerDatatype: X3EnumDataType<keyof Trigger$EnumInterface, unknown>;
	//# sourceMappingURL=trigger.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/transaction-type-2039.d.ts
declare module '@sage/x3-master-data/lib/enums/transaction-type-2039' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransactionType2039Enum {
	    select = 1,
	    all = 2,
	    bom = 3,
	    customer = 4,
	    demandForecast = 5,
	    purchaseRequest = 6,
	    purchaseOrder = 7,
	    salesQuote = 8,
	    routing = 9,
	    salesOrder = 10,
	    stock = 11,
	    subcontractOrder = 12,
	    supplier = 13,
	    workOrder = 14,
	    other = 15
	}
	export interface TransactionType2039$EnumInterface {
	    select: 1;
	    all: 2;
	    bom: 3;
	    customer: 4;
	    demandForecast: 5;
	    purchaseRequest: 6;
	    purchaseOrder: 7;
	    salesQuote: 8;
	    routing: 9;
	    salesOrder: 10;
	    stock: 11;
	    subcontractOrder: 12;
	    supplier: 13;
	    workOrder: 14;
	    other: 15;
	}
	export type TransactionType2039 = keyof TransactionType2039$EnumInterface;
	export const transactionType2039Datatype: X3EnumDataType<keyof TransactionType2039$EnumInterface, unknown>;
	//# sourceMappingURL=transaction-type-2039.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/tp-tf-basis-rule-target-company.d.ts
declare module '@sage/x3-master-data/lib/enums/tp-tf-basis-rule-target-company' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TpTfBasisRuleTargetCompanyEnum {
	    renewal = 1,
	    maxContributionValue80SrfTaxBasis = 2,
	    substituteValue3 = 3,
	    contributionValue4 = 4,
	    substituteValue5 = 5,
	    contributionValue = 6
	}
	export interface TpTfBasisRuleTargetCompany$EnumInterface {
	    renewal: 1;
	    maxContributionValue80SrfTaxBasis: 2;
	    substituteValue3: 3;
	    contributionValue4: 4;
	    substituteValue5: 5;
	    contributionValue: 6;
	}
	export type TpTfBasisRuleTargetCompany = keyof TpTfBasisRuleTargetCompany$EnumInterface;
	export const tpTfBasisRuleTargetCompanyDatatype: X3EnumDataType<keyof TpTfBasisRuleTargetCompany$EnumInterface, unknown>;
	//# sourceMappingURL=tp-tf-basis-rule-target-company.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/tolerance-definition-level.d.ts
declare module '@sage/x3-master-data/lib/enums/tolerance-definition-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ToleranceDefinitionLevelEnum {
	    substituteValue1 = 1,
	    shiSheetRecord = 2,
	    productSite = 3,
	    bom = 4
	}
	export interface ToleranceDefinitionLevel$EnumInterface {
	    substituteValue1: 1;
	    shiSheetRecord: 2;
	    productSite: 3;
	    bom: 4;
	}
	export type ToleranceDefinitionLevel = keyof ToleranceDefinitionLevel$EnumInterface;
	export const toleranceDefinitionLevelDatatype: X3EnumDataType<keyof ToleranceDefinitionLevel$EnumInterface, unknown>;
	//# sourceMappingURL=tolerance-definition-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/timing.d.ts
declare module '@sage/x3-master-data/lib/enums/timing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TimingEnum {
	    day = 1,
	    week = 2,
	    month = 3
	}
	export interface Timing$EnumInterface {
	    day: 1;
	    week: 2;
	    month: 3;
	}
	export type Timing = keyof Timing$EnumInterface;
	export const timingDatatype: X3EnumDataType<keyof Timing$EnumInterface, unknown>;
	//# sourceMappingURL=timing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/time-format.d.ts
declare module '@sage/x3-master-data/lib/enums/time-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TimeFormatEnum {
	    hhmm = 1,
	    hhmmss = 2,
	    hhMm = 3,
	    hhMmSs = 4
	}
	export interface TimeFormat$EnumInterface {
	    hhmm: 1;
	    hhmmss: 2;
	    hhMm: 3;
	    hhMmSs: 4;
	}
	export type TimeFormat = keyof TimeFormat$EnumInterface;
	export const timeFormatDatatype: X3EnumDataType<keyof TimeFormat$EnumInterface, unknown>;
	//# sourceMappingURL=time-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/texts-to-translate.d.ts
declare module '@sage/x3-master-data/lib/enums/texts-to-translate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TextsToTranslateEnum {
	    priceColumns = 1,
	    invoiceElements = 2,
	    productDescriptions = 3,
	    configurator = 4,
	    units = 5,
	    packagings = 6,
	    deliveryModes = 7,
	    paymentTerms = 8,
	    miscellaneousTables = 9,
	    other = 10
	}
	export interface TextsToTranslate$EnumInterface {
	    priceColumns: 1;
	    invoiceElements: 2;
	    productDescriptions: 3;
	    configurator: 4;
	    units: 5;
	    packagings: 6;
	    deliveryModes: 7;
	    paymentTerms: 8;
	    miscellaneousTables: 9;
	    other: 10;
	}
	export type TextsToTranslate = keyof TextsToTranslate$EnumInterface;
	export const textsToTranslateDatatype: X3EnumDataType<keyof TextsToTranslate$EnumInterface, unknown>;
	//# sourceMappingURL=texts-to-translate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/text-types.d.ts
declare module '@sage/x3-master-data/lib/enums/text-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TextTypesEnum {
	    comments = 1,
	    remarks = 2,
	    quoteText = 3,
	    greetings = 4,
	    etc = 5
	}
	export interface TextTypes$EnumInterface {
	    comments: 1;
	    remarks: 2;
	    quoteText: 3;
	    greetings: 4;
	    etc: 5;
	}
	export type TextTypes = keyof TextTypes$EnumInterface;
	export const textTypesDatatype: X3EnumDataType<keyof TextTypes$EnumInterface, unknown>;
	//# sourceMappingURL=text-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/test-cp.d.ts
declare module '@sage/x3-master-data/lib/enums/test-cp' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TestCpEnum {
	    excludeNonListedProducts = 1,
	    includeNonListedProducts = 2
	}
	export interface TestCp$EnumInterface {
	    excludeNonListedProducts: 1;
	    includeNonListedProducts: 2;
	}
	export type TestCp = keyof TestCp$EnumInterface;
	export const testCpDatatype: X3EnumDataType<keyof TestCp$EnumInterface, unknown>;
	//# sourceMappingURL=test-cp.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/territory-of-declaration.d.ts
declare module '@sage/x3-master-data/lib/enums/territory-of-declaration' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TerritoryOfDeclarationEnum {
	    commonTerritory = 1,
	    navarre = 2,
	    bizkaia = 3,
	    gipuzkoa = 4,
	    alava = 5,
	    canaryIslands = 6
	}
	export interface TerritoryOfDeclaration$EnumInterface {
	    commonTerritory: 1;
	    navarre: 2;
	    bizkaia: 3;
	    gipuzkoa: 4;
	    alava: 5;
	    canaryIslands: 6;
	}
	export type TerritoryOfDeclaration = keyof TerritoryOfDeclaration$EnumInterface;
	export const territoryOfDeclarationDatatype: X3EnumDataType<keyof TerritoryOfDeclaration$EnumInterface, unknown>;
	//# sourceMappingURL=territory-of-declaration.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/technical-sheet-tracking-type.d.ts
declare module '@sage/x3-master-data/lib/enums/technical-sheet-tracking-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TechnicalSheetTrackingTypeEnum {
	    qualityControlTracking = 1,
	    workOrderTracking = 2
	}
	export interface TechnicalSheetTrackingType$EnumInterface {
	    qualityControlTracking: 1;
	    workOrderTracking: 2;
	}
	export type TechnicalSheetTrackingType = keyof TechnicalSheetTrackingType$EnumInterface;
	export const technicalSheetTrackingTypeDatatype: X3EnumDataType<keyof TechnicalSheetTrackingType$EnumInterface, unknown>;
	//# sourceMappingURL=technical-sheet-tracking-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/taxation-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/taxation-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxationRuleEnum {
	    incomeTax = 1,
	    corporateIncomeTax = 2
	}
	export interface TaxationRule$EnumInterface {
	    incomeTax: 1;
	    corporateIncomeTax: 2;
	}
	export type TaxationRule = keyof TaxationRule$EnumInterface;
	export const taxationRuleDatatype: X3EnumDataType<keyof TaxationRule$EnumInterface, unknown>;
	//# sourceMappingURL=taxation-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/taxable-horse-power.d.ts
declare module '@sage/x3-master-data/lib/enums/taxable-horse-power' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxableHorsePowerEnum {
	    lessThanOrEqualTo4 = 1,
	    from5To7 = 2,
	    from8To11 = 3,
	    from12To16 = 4,
	    higherThan16 = 5
	}
	export interface TaxableHorsePower$EnumInterface {
	    lessThanOrEqualTo4: 1;
	    from5To7: 2;
	    from8To11: 3;
	    from12To16: 4;
	    higherThan16: 5;
	}
	export type TaxableHorsePower = keyof TaxableHorsePower$EnumInterface;
	export const taxableHorsePowerDatatype: X3EnumDataType<keyof TaxableHorsePower$EnumInterface, unknown>;
	//# sourceMappingURL=taxable-horse-power.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/tax-type.d.ts
declare module '@sage/x3-master-data/lib/enums/tax-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxTypeEnum {
	    vat = 1,
	    additionalTax = 2,
	    specialTax = 3,
	    localTax = 4
	}
	export interface TaxType$EnumInterface {
	    vat: 1;
	    additionalTax: 2;
	    specialTax: 3;
	    localTax: 4;
	}
	export type TaxType = keyof TaxType$EnumInterface;
	export const taxTypeDatatype: X3EnumDataType<keyof TaxType$EnumInterface, unknown>;
	//# sourceMappingURL=tax-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/tax-type-2079.d.ts
declare module '@sage/x3-master-data/lib/enums/tax-type-2079' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxType2079Enum {
	    notApplicable = 1,
	    vat = 2,
	    taxStamp = 3,
	    iec = 4,
	    other = 5
	}
	export interface TaxType2079$EnumInterface {
	    notApplicable: 1;
	    vat: 2;
	    taxStamp: 3;
	    iec: 4;
	    other: 5;
	}
	export type TaxType2079 = keyof TaxType2079$EnumInterface;
	export const taxType2079Datatype: X3EnumDataType<keyof TaxType2079$EnumInterface, unknown>;
	//# sourceMappingURL=tax-type-2079.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/tax-rule-enum.d.ts
declare module '@sage/x3-master-data/lib/enums/tax-rule-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxRuleEnumEnum {
	    product = 1,
	    maximumRate = 2,
	    minimumRate = 3,
	    fixedRate = 4,
	    distribution = 5
	}
	export interface TaxRuleEnum$EnumInterface {
	    product: 1;
	    maximumRate: 2;
	    minimumRate: 3;
	    fixedRate: 4;
	    distribution: 5;
	}
	export type TaxRuleEnum = keyof TaxRuleEnum$EnumInterface;
	export const taxRuleEnumDatatype: X3EnumDataType<keyof TaxRuleEnum$EnumInterface, unknown>;
	//# sourceMappingURL=tax-rule-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/tax-rule-3165.d.ts
declare module '@sage/x3-master-data/lib/enums/tax-rule-3165' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxRule3165Enum {
	    fiscalEngineSizeHp = 1,
	    co2EmissionRate = 2
	}
	export interface TaxRule3165$EnumInterface {
	    fiscalEngineSizeHp: 1;
	    co2EmissionRate: 2;
	}
	export type TaxRule3165 = keyof TaxRule3165$EnumInterface;
	export const taxRule3165Datatype: X3EnumDataType<keyof TaxRule3165$EnumInterface, unknown>;
	//# sourceMappingURL=tax-rule-3165.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/tax-level-enum.d.ts
declare module '@sage/x3-master-data/lib/enums/tax-level-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxLevelEnumEnum {
	    reduced = 1,
	    intermediate = 2,
	    normal = 3,
	    exemption = 4,
	    other = 5,
	    notApplicable = 6
	}
	export interface TaxLevelEnum$EnumInterface {
	    reduced: 1;
	    intermediate: 2;
	    normal: 3;
	    exemption: 4;
	    other: 5;
	    notApplicable: 6;
	}
	export type TaxLevelEnum = keyof TaxLevelEnum$EnumInterface;
	export const taxLevelEnumDatatype: X3EnumDataType<keyof TaxLevelEnum$EnumInterface, unknown>;
	//# sourceMappingURL=tax-level-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/tax-country-region.d.ts
declare module '@sage/x3-master-data/lib/enums/tax-country-region' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxCountryRegionEnum {
	    mainland = 1,
	    azores = 2,
	    madeira = 3,
	    nonApplicable = 4,
	    oneStopShop = 5
	}
	export interface TaxCountryRegion$EnumInterface {
	    mainland: 1;
	    azores: 2;
	    madeira: 3;
	    nonApplicable: 4;
	    oneStopShop: 5;
	}
	export type TaxCountryRegion = keyof TaxCountryRegion$EnumInterface;
	export const taxCountryRegionDatatype: X3EnumDataType<keyof TaxCountryRegion$EnumInterface, unknown>;
	//# sourceMappingURL=tax-country-region.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/tax-authority-status.d.ts
declare module '@sage/x3-master-data/lib/enums/tax-authority-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxAuthorityStatusEnum {
	    pending = 1,
	    accepted = 2,
	    acceptedWithErrors = 3,
	    rejected = 4
	}
	export interface TaxAuthorityStatus$EnumInterface {
	    pending: 1;
	    accepted: 2;
	    acceptedWithErrors: 3;
	    rejected: 4;
	}
	export type TaxAuthorityStatus = keyof TaxAuthorityStatus$EnumInterface;
	export const taxAuthorityStatusDatatype: X3EnumDataType<keyof TaxAuthorityStatus$EnumInterface, unknown>;
	//# sourceMappingURL=tax-authority-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/task-link.d.ts
declare module '@sage/x3-master-data/lib/enums/task-link' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaskLinkEnum {
	    none = 1,
	    serviceRequest = 2,
	    massMailing = 3,
	    callCampaign = 4,
	    tradeShow = 5,
	    mediaCampaign = 6,
	    followUpCampaign = 7,
	    marketingCampaign = 8
	}
	export interface TaskLink$EnumInterface {
	    none: 1;
	    serviceRequest: 2;
	    massMailing: 3;
	    callCampaign: 4;
	    tradeShow: 5;
	    mediaCampaign: 6;
	    followUpCampaign: 7;
	    marketingCampaign: 8;
	}
	export type TaskLink = keyof TaskLink$EnumInterface;
	export const taskLinkDatatype: X3EnumDataType<keyof TaskLink$EnumInterface, unknown>;
	//# sourceMappingURL=task-link.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/target-company-asset-status.d.ts
declare module '@sage/x3-master-data/lib/enums/target-company-asset-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TargetCompanyAssetStatusEnum {
	    secondHand = 1,
	    renewalOfPreviousStatus = 2
	}
	export interface TargetCompanyAssetStatus$EnumInterface {
	    secondHand: 1;
	    renewalOfPreviousStatus: 2;
	}
	export type TargetCompanyAssetStatus = keyof TargetCompanyAssetStatus$EnumInterface;
	export const targetCompanyAssetStatusDatatype: X3EnumDataType<keyof TargetCompanyAssetStatus$EnumInterface, unknown>;
	//# sourceMappingURL=target-company-asset-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/target-comp-deprec-duration-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/target-comp-deprec-duration-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TargetCompDeprecDurationRuleEnum {
	    remainingDuration = 1,
	    previousRenewalDuration = 2
	}
	export interface TargetCompDeprecDurationRule$EnumInterface {
	    remainingDuration: 1;
	    previousRenewalDuration: 2;
	}
	export type TargetCompDeprecDurationRule = keyof TargetCompDeprecDurationRule$EnumInterface;
	export const targetCompDeprecDurationRuleDatatype: X3EnumDataType<keyof TargetCompDeprecDurationRule$EnumInterface, unknown>;
	//# sourceMappingURL=target-comp-deprec-duration-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/tables-of-criteria.d.ts
declare module '@sage/x3-master-data/lib/enums/tables-of-criteria' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TablesOfCriteriaEnum {
	    bPs = 1,
	    prospectsCustomers = 2,
	    addresses = 3,
	    contacts = 4
	}
	export interface TablesOfCriteria$EnumInterface {
	    bPs: 1;
	    prospectsCustomers: 2;
	    addresses: 3;
	    contacts: 4;
	}
	export type TablesOfCriteria = keyof TablesOfCriteria$EnumInterface;
	export const tablesOfCriteriaDatatype: X3EnumDataType<keyof TablesOfCriteria$EnumInterface, unknown>;
	//# sourceMappingURL=tables-of-criteria.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/ta-communication-status.d.ts
declare module '@sage/x3-master-data/lib/enums/ta-communication-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaCommunicationStatusEnum {
	    all = 1,
	    sentWithSuccess = 2,
	    sentWithErrors = 3,
	    notSent = 4,
	    notSentAndSentWithErrors = 5
	}
	export interface TaCommunicationStatus$EnumInterface {
	    all: 1;
	    sentWithSuccess: 2;
	    sentWithErrors: 3;
	    notSent: 4;
	    notSentAndSentWithErrors: 5;
	}
	export type TaCommunicationStatus = keyof TaCommunicationStatus$EnumInterface;
	export const taCommunicationStatusDatatype: X3EnumDataType<keyof TaCommunicationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=ta-communication-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/swiss-type-codes.d.ts
declare module '@sage/x3-master-data/lib/enums/swiss-type-codes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SwissTypeCodesEnum {
	    nonIsr = 1,
	    print = 2,
	    dta = 3,
	    ezag = 4,
	    iso = 5
	}
	export interface SwissTypeCodes$EnumInterface {
	    nonIsr: 1;
	    print: 2;
	    dta: 3;
	    ezag: 4;
	    iso: 5;
	}
	export type SwissTypeCodes = keyof SwissTypeCodes$EnumInterface;
	export const swissTypeCodesDatatype: X3EnumDataType<keyof SwissTypeCodes$EnumInterface, unknown>;
	//# sourceMappingURL=swiss-type-codes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/swiss-payment-types.d.ts
declare module '@sage/x3-master-data/lib/enums/swiss-payment-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SwissPaymentTypesEnum {
	    normal = 1,
	    dta = 2,
	    ezag = 3,
	    iso = 4
	}
	export interface SwissPaymentTypes$EnumInterface {
	    normal: 1;
	    dta: 2;
	    ezag: 3;
	    iso: 4;
	}
	export type SwissPaymentTypes = keyof SwissPaymentTypes$EnumInterface;
	export const swissPaymentTypesDatatype: X3EnumDataType<keyof SwissPaymentTypes$EnumInterface, unknown>;
	//# sourceMappingURL=swiss-payment-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/supply-by.d.ts
declare module '@sage/x3-master-data/lib/enums/supply-by' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplyByEnum {
	    grantor = 1,
	    grantee = 2
	}
	export interface SupplyBy$EnumInterface {
	    grantor: 1;
	    grantee: 2;
	}
	export type SupplyBy = keyof SupplyBy$EnumInterface;
	export const supplyByDatatype: X3EnumDataType<keyof SupplyBy$EnumInterface, unknown>;
	//# sourceMappingURL=supply-by.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/suppliers-statistics-groups.d.ts
declare module '@sage/x3-master-data/lib/enums/suppliers-statistics-groups' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SuppliersStatisticsGroupsEnum {
	    supplierStat1 = 1,
	    supplierStat2 = 2,
	    supplierStat3 = 3,
	    supplierStat4 = 4,
	    supplierStat5 = 5
	}
	export interface SuppliersStatisticsGroups$EnumInterface {
	    supplierStat1: 1;
	    supplierStat2: 2;
	    supplierStat3: 3;
	    supplierStat4: 4;
	    supplierStat5: 5;
	}
	export type SuppliersStatisticsGroups = keyof SuppliersStatisticsGroups$EnumInterface;
	export const suppliersStatisticsGroupsDatatype: X3EnumDataType<keyof SuppliersStatisticsGroups$EnumInterface, unknown>;
	//# sourceMappingURL=suppliers-statistics-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/supplier-situation-risks.d.ts
declare module '@sage/x3-master-data/lib/enums/supplier-situation-risks' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierSituationRisksEnum {
	    onOrder = 1,
	    shippedNotInvoiced = 2,
	    nonPostedInvoices = 3,
	    unmatchedCreditMemos = 4,
	    dueDatesApprovedForPayment = 5,
	    dueDatesNotApprovedForPayment = 6,
	    temporaryPayments = 7,
	    notesPR1 = 8,
	    notesPR2 = 9,
	    notesPR3 = 10
	}
	export interface SupplierSituationRisks$EnumInterface {
	    onOrder: 1;
	    shippedNotInvoiced: 2;
	    nonPostedInvoices: 3;
	    unmatchedCreditMemos: 4;
	    dueDatesApprovedForPayment: 5;
	    dueDatesNotApprovedForPayment: 6;
	    temporaryPayments: 7;
	    notesPR1: 8;
	    notesPR2: 9;
	    notesPR3: 10;
	}
	export type SupplierSituationRisks = keyof SupplierSituationRisks$EnumInterface;
	export const supplierSituationRisksDatatype: X3EnumDataType<keyof SupplierSituationRisks$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-situation-risks.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/supplier-customer-type.d.ts
declare module '@sage/x3-master-data/lib/enums/supplier-customer-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierCustomerTypeEnum {
	    customer = 1,
	    supplier = 2
	}
	export interface SupplierCustomerType$EnumInterface {
	    customer: 1;
	    supplier: 2;
	}
	export type SupplierCustomerType = keyof SupplierCustomerType$EnumInterface;
	export const supplierCustomerTypeDatatype: X3EnumDataType<keyof SupplierCustomerType$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-customer-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/supplementary-invoicing.d.ts
declare module '@sage/x3-master-data/lib/enums/supplementary-invoicing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplementaryInvoicingEnum {
	    accordingToContractDueDates = 1,
	    onClosingOfTheServiceRequest = 2
	}
	export interface SupplementaryInvoicing$EnumInterface {
	    accordingToContractDueDates: 1;
	    onClosingOfTheServiceRequest: 2;
	}
	export type SupplementaryInvoicing = keyof SupplementaryInvoicing$EnumInterface;
	export const supplementaryInvoicingDatatype: X3EnumDataType<keyof SupplementaryInvoicing$EnumInterface, unknown>;
	//# sourceMappingURL=supplementary-invoicing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/suggestion-type.d.ts
declare module '@sage/x3-master-data/lib/enums/suggestion-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SuggestionTypeEnum {
	    noSuggestion = 1,
	    purchase = 2,
	    manufacturing = 3,
	    intersite = 4,
	    subcontracting = 5
	}
	export interface SuggestionType$EnumInterface {
	    noSuggestion: 1;
	    purchase: 2;
	    manufacturing: 3;
	    intersite: 4;
	    subcontracting: 5;
	}
	export type SuggestionType = keyof SuggestionType$EnumInterface;
	export const suggestionTypeDatatype: X3EnumDataType<keyof SuggestionType$EnumInterface, unknown>;
	//# sourceMappingURL=suggestion-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/subsidy-type.d.ts
declare module '@sage/x3-master-data/lib/enums/subsidy-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubsidyTypeEnum {
	    fixedRate = 1,
	    percentage = 2,
	    cappedPercentage = 3
	}
	export interface SubsidyType$EnumInterface {
	    fixedRate: 1;
	    percentage: 2;
	    cappedPercentage: 3;
	}
	export type SubsidyType = keyof SubsidyType$EnumInterface;
	export const subsidyTypeDatatype: X3EnumDataType<keyof SubsidyType$EnumInterface, unknown>;
	//# sourceMappingURL=subsidy-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/subsidy-status.d.ts
declare module '@sage/x3-master-data/lib/enums/subsidy-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubsidyStatusEnum {
	    inProcess = 1,
	    investmentComplete = 2,
	    deleted = 3,
	    totallyReintegrated = 4
	}
	export interface SubsidyStatus$EnumInterface {
	    inProcess: 1;
	    investmentComplete: 2;
	    deleted: 3;
	    totallyReintegrated: 4;
	}
	export type SubsidyStatus = keyof SubsidyStatus$EnumInterface;
	export const subsidyStatusDatatype: X3EnumDataType<keyof SubsidyStatus$EnumInterface, unknown>;
	//# sourceMappingURL=subsidy-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/subject-to-control.d.ts
declare module '@sage/x3-master-data/lib/enums/subject-to-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubjectToControlEnum {
	    noControl = 1,
	    nonChangeableControl = 2,
	    changeableControl = 3,
	    periodicControl = 4
	}
	export interface SubjectToControl$EnumInterface {
	    noControl: 1;
	    nonChangeableControl: 2;
	    changeableControl: 3;
	    periodicControl: 4;
	}
	export type SubjectToControl = keyof SubjectToControl$EnumInterface;
	export const subjectToControlDatatype: X3EnumDataType<keyof SubjectToControl$EnumInterface, unknown>;
	//# sourceMappingURL=subject-to-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/subject-campaign-calls.d.ts
declare module '@sage/x3-master-data/lib/enums/subject-campaign-calls' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubjectCampaignCallsEnum {
	    readObjectOnMarketingCampaign = 1,
	    readObjectOnCallCampaign = 2
	}
	export interface SubjectCampaignCalls$EnumInterface {
	    readObjectOnMarketingCampaign: 1;
	    readObjectOnCallCampaign: 2;
	}
	export type SubjectCampaignCalls = keyof SubjectCampaignCalls$EnumInterface;
	export const subjectCampaignCallsDatatype: X3EnumDataType<keyof SubjectCampaignCalls$EnumInterface, unknown>;
	//# sourceMappingURL=subject-campaign-calls.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/subcontracted-product-status.d.ts
declare module '@sage/x3-master-data/lib/enums/subcontracted-product-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubcontractedProductStatusEnum {
	    onHold = 1,
	    underProgress = 2,
	    ordered = 3,
	    received = 4,
	    closed = 5
	}
	export interface SubcontractedProductStatus$EnumInterface {
	    onHold: 1;
	    underProgress: 2;
	    ordered: 3;
	    received: 4;
	    closed: 5;
	}
	export type SubcontractedProductStatus = keyof SubcontractedProductStatus$EnumInterface;
	export const subcontractedProductStatusDatatype: X3EnumDataType<keyof SubcontractedProductStatus$EnumInterface, unknown>;
	//# sourceMappingURL=subcontracted-product-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/subcontract-sort.d.ts
declare module '@sage/x3-master-data/lib/enums/subcontract-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubcontractSortEnum {
	    bySubcontractOrderNo = 1,
	    bySubcontractedProduct = 2,
	    byService = 3,
	    byPurchaseOrderNo = 4,
	    byPurchaseOrderDate = 5,
	    bySupplier = 6,
	    byMaterial = 7,
	    byDeliveryDate = 8
	}
	export interface SubcontractSort$EnumInterface {
	    bySubcontractOrderNo: 1;
	    bySubcontractedProduct: 2;
	    byService: 3;
	    byPurchaseOrderNo: 4;
	    byPurchaseOrderDate: 5;
	    bySupplier: 6;
	    byMaterial: 7;
	    byDeliveryDate: 8;
	}
	export type SubcontractSort = keyof SubcontractSort$EnumInterface;
	export const subcontractSortDatatype: X3EnumDataType<keyof SubcontractSort$EnumInterface, unknown>;
	//# sourceMappingURL=subcontract-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/subcontract-material-status.d.ts
declare module '@sage/x3-master-data/lib/enums/subcontract-material-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubcontractMaterialStatusEnum {
	    onHold = 1,
	    underProgress = 2,
	    closed = 3,
	    excluded = 4,
	    ordered = 5,
	    received = 6
	}
	export interface SubcontractMaterialStatus$EnumInterface {
	    onHold: 1;
	    underProgress: 2;
	    closed: 3;
	    excluded: 4;
	    ordered: 5;
	    received: 6;
	}
	export type SubcontractMaterialStatus = keyof SubcontractMaterialStatus$EnumInterface;
	export const subcontractMaterialStatusDatatype: X3EnumDataType<keyof SubcontractMaterialStatus$EnumInterface, unknown>;
	//# sourceMappingURL=subcontract-material-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sub-contract-order-status.d.ts
declare module '@sage/x3-master-data/lib/enums/sub-contract-order-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubContractOrderStatusEnum {
	    onHold = 1,
	    beingOptimized = 2,
	    printed = 3,
	    inProgress = 4,
	    closed = 5,
	    costPriceCalculated = 6
	}
	export interface SubContractOrderStatus$EnumInterface {
	    onHold: 1;
	    beingOptimized: 2;
	    printed: 3;
	    inProgress: 4;
	    closed: 5;
	    costPriceCalculated: 6;
	}
	export type SubContractOrderStatus = keyof SubContractOrderStatus$EnumInterface;
	export const subContractOrderStatusDatatype: X3EnumDataType<keyof SubContractOrderStatus$EnumInterface, unknown>;
	//# sourceMappingURL=sub-contract-order-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/stored-intermediate-amount.d.ts
declare module '@sage/x3-master-data/lib/enums/stored-intermediate-amount' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StoredIntermediateAmountEnum {
	    no = 1,
	    amount1 = 2,
	    amount2 = 3
	}
	export interface StoredIntermediateAmount$EnumInterface {
	    no: 1;
	    amount1: 2;
	    amount2: 3;
	}
	export type StoredIntermediateAmount = keyof StoredIntermediateAmount$EnumInterface;
	export const storedIntermediateAmountDatatype: X3EnumDataType<keyof StoredIntermediateAmount$EnumInterface, unknown>;
	//# sourceMappingURL=stored-intermediate-amount.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/stock-withdrawal.d.ts
declare module '@sage/x3-master-data/lib/enums/stock-withdrawal' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockWithdrawalEnum {
	    immediate = 1,
	    backflush = 2,
	    notManaged = 3
	}
	export interface StockWithdrawal$EnumInterface {
	    immediate: 1;
	    backflush: 2;
	    notManaged: 3;
	}
	export type StockWithdrawal = keyof StockWithdrawal$EnumInterface;
	export const stockWithdrawalDatatype: X3EnumDataType<keyof StockWithdrawal$EnumInterface, unknown>;
	//# sourceMappingURL=stock-withdrawal.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/stock-withdrawal-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/stock-withdrawal-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockWithdrawalModeEnum {
	    immediate = 1,
	    backflush = 2,
	    all = 3
	}
	export interface StockWithdrawalMode$EnumInterface {
	    immediate: 1;
	    backflush: 2;
	    all: 3;
	}
	export type StockWithdrawalMode = keyof StockWithdrawalMode$EnumInterface;
	export const stockWithdrawalModeDatatype: X3EnumDataType<keyof StockWithdrawalMode$EnumInterface, unknown>;
	//# sourceMappingURL=stock-withdrawal-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/stock-valuation.d.ts
declare module '@sage/x3-master-data/lib/enums/stock-valuation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockValuationEnum {
	    averageCost = 1,
	    fifo = 2,
	    standardCost = 3,
	    revisedStandardCost = 4,
	    lastCost = 5
	}
	export interface StockValuation$EnumInterface {
	    averageCost: 1;
	    fifo: 2;
	    standardCost: 3;
	    revisedStandardCost: 4;
	    lastCost: 5;
	}
	export type StockValuation = keyof StockValuation$EnumInterface;
	export const stockValuationDatatype: X3EnumDataType<keyof StockValuation$EnumInterface, unknown>;
	//# sourceMappingURL=stock-valuation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/stock-transactions-status.d.ts
declare module '@sage/x3-master-data/lib/enums/stock-transactions-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockTransactionsStatusEnum {
	    open = 1,
	    deferred = 2,
	    balanceAdjustment = 3,
	    closed = 4
	}
	export interface StockTransactionsStatus$EnumInterface {
	    open: 1;
	    deferred: 2;
	    balanceAdjustment: 3;
	    closed: 4;
	}
	export type StockTransactionsStatus = keyof StockTransactionsStatus$EnumInterface;
	export const stockTransactionsStatusDatatype: X3EnumDataType<keyof StockTransactionsStatus$EnumInterface, unknown>;
	//# sourceMappingURL=stock-transactions-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/stock-management.d.ts
declare module '@sage/x3-master-data/lib/enums/stock-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockManagementEnum {
	    notManaged = 1,
	    managed = 2,
	    potencyManaged = 3
	}
	export interface StockManagement$EnumInterface {
	    notManaged: 1;
	    managed: 2;
	    potencyManaged: 3;
	}
	export type StockManagement = keyof StockManagement$EnumInterface;
	export const stockManagementDatatype: X3EnumDataType<keyof StockManagement$EnumInterface, unknown>;
	//# sourceMappingURL=stock-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/status-of-the-funds.d.ts
declare module '@sage/x3-master-data/lib/enums/status-of-the-funds' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatusOfTheFundsEnum {
	    nonGeneratedFunds = 1,
	    provisionalFunds = 2,
	    finalFunds = 3
	}
	export interface StatusOfTheFunds$EnumInterface {
	    nonGeneratedFunds: 1;
	    provisionalFunds: 2;
	    finalFunds: 3;
	}
	export type StatusOfTheFunds = keyof StatusOfTheFunds$EnumInterface;
	export const statusOfTheFundsDatatype: X3EnumDataType<keyof StatusOfTheFunds$EnumInterface, unknown>;
	//# sourceMappingURL=status-of-the-funds.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/status-of-expeditions.d.ts
declare module '@sage/x3-master-data/lib/enums/status-of-expeditions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatusOfExpeditionsEnum {
	    successfulTermination = 1,
	    waitingDispatch = 2
	}
	export interface StatusOfExpeditions$EnumInterface {
	    successfulTermination: 1;
	    waitingDispatch: 2;
	}
	export type StatusOfExpeditions = keyof StatusOfExpeditions$EnumInterface;
	export const statusOfExpeditionsDatatype: X3EnumDataType<keyof StatusOfExpeditions$EnumInterface, unknown>;
	//# sourceMappingURL=status-of-expeditions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/status-edi-field.d.ts
declare module '@sage/x3-master-data/lib/enums/status-edi-field' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatusEdiFieldEnum {
	    mandatory = 1,
	    required = 2,
	    dependant = 3,
	    advised = 4,
	    optional = 5,
	    notUsed = 6
	}
	export interface StatusEdiField$EnumInterface {
	    mandatory: 1;
	    required: 2;
	    dependant: 3;
	    advised: 4;
	    optional: 5;
	    notUsed: 6;
	}
	export type StatusEdiField = keyof StatusEdiField$EnumInterface;
	export const statusEdiFieldDatatype: X3EnumDataType<keyof StatusEdiField$EnumInterface, unknown>;
	//# sourceMappingURL=status-edi-field.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/status-2824.d.ts
declare module '@sage/x3-master-data/lib/enums/status-2824' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Status2824Enum {
	    entered = 1,
	    inProgress = 2,
	    closed = 3
	}
	export interface Status2824$EnumInterface {
	    entered: 1;
	    inProgress: 2;
	    closed: 3;
	}
	export type Status2824 = keyof Status2824$EnumInterface;
	export const status2824Datatype: X3EnumDataType<keyof Status2824$EnumInterface, unknown>;
	//# sourceMappingURL=status-2824.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/status-2806.d.ts
declare module '@sage/x3-master-data/lib/enums/status-2806' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Status2806Enum {
	    notPosted = 1,
	    postedSimulation = 2,
	    postedActual = 3
	}
	export interface Status2806$EnumInterface {
	    notPosted: 1;
	    postedSimulation: 2;
	    postedActual: 3;
	}
	export type Status2806 = keyof Status2806$EnumInterface;
	export const status2806Datatype: X3EnumDataType<keyof Status2806$EnumInterface, unknown>;
	//# sourceMappingURL=status-2806.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/statement-status.d.ts
declare module '@sage/x3-master-data/lib/enums/statement-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatementStatusEnum {
	    notMatched = 1,
	    matched = 2,
	    validated = 3,
	    reconcile = 4
	}
	export interface StatementStatus$EnumInterface {
	    notMatched: 1;
	    matched: 2;
	    validated: 3;
	    reconcile: 4;
	}
	export type StatementStatus = keyof StatementStatus$EnumInterface;
	export const statementStatusDatatype: X3EnumDataType<keyof StatementStatus$EnumInterface, unknown>;
	//# sourceMappingURL=statement-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/standard-product-code.d.ts
declare module '@sage/x3-master-data/lib/enums/standard-product-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StandardProductCodeEnum {
	    notManaged = 1,
	    byProject = 2,
	    availableStock = 3,
	    byOrder = 4
	}
	export interface StandardProductCode$EnumInterface {
	    notManaged: 1;
	    byProject: 2;
	    availableStock: 3;
	    byOrder: 4;
	}
	export type StandardProductCode = keyof StandardProductCode$EnumInterface;
	export const standardProductCodeDatatype: X3EnumDataType<keyof StandardProductCode$EnumInterface, unknown>;
	//# sourceMappingURL=standard-product-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/standard-depreciation-variant.d.ts
declare module '@sage/x3-master-data/lib/enums/standard-depreciation-variant' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StandardDepreciationVariantEnum {
	    depreciationCalculatedByFinancialYear = 1,
	    depreciationCalculatedByPeriod = 2
	}
	export interface StandardDepreciationVariant$EnumInterface {
	    depreciationCalculatedByFinancialYear: 1;
	    depreciationCalculatedByPeriod: 2;
	}
	export type StandardDepreciationVariant = keyof StandardDepreciationVariant$EnumInterface;
	export const standardDepreciationVariantDatatype: X3EnumDataType<keyof StandardDepreciationVariant$EnumInterface, unknown>;
	//# sourceMappingURL=standard-depreciation-variant.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/standard-depreciation-methods.d.ts
declare module '@sage/x3-master-data/lib/enums/standard-depreciation-methods' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StandardDepreciationMethodsEnum {
	    straightLine = 1,
	    amortGrossVal = 2,
	    germanDeclining = 3,
	    belgianDeclining = 4,
	    decliningBalance = 5,
	    spanishDeclining = 6,
	    frenchDeclining = 7,
	    mixedGermanDeclining = 8,
	    portugueseDeclining = 9,
	    mixedSpanishDeclining = 10,
	    residual = 11,
	    formsAndMolds = 12,
	    spanishStraightlineMonth = 13,
	    laundry = 14,
	    frenchStraightline = 15,
	    gradual = 16,
	    withoutDepreciation = 17,
	    softy = 18,
	    productionUnit = 19,
	    straightlineBeyondNullSalvageUnit = 20,
	    portugueseMixedDeclining = 21,
	    ordinarioAnticipato = 22,
	    portugueseConstants = 23,
	    portugueseDuodecimos = 24,
	    amortNetVal = 25,
	    belgianStraightline = 26,
	    moroccanDeclining = 27,
	    russianStraightline = 28,
	    russianDeclining = 29,
	    russianConstant = 30,
	    russianSofty = 31,
	    russianUnits = 32,
	    polishStraightline = 33,
	    polishDeclining = 34,
	    romanianStraightline = 35,
	    romanianAccelerated = 36,
	    romanianDeclining = 37,
	    spanishStraightlineDay = 38,
	    onePeriod = 39,
	    primeCost = 40,
	    diminishingValue = 41,
	    swissStraightline = 42,
	    swissDeclining = 43,
	    turkishStraightline = 44,
	    turkishDeclining = 45,
	    austrianHalfYear = 46
	}
	export interface StandardDepreciationMethods$EnumInterface {
	    straightLine: 1;
	    amortGrossVal: 2;
	    germanDeclining: 3;
	    belgianDeclining: 4;
	    decliningBalance: 5;
	    spanishDeclining: 6;
	    frenchDeclining: 7;
	    mixedGermanDeclining: 8;
	    portugueseDeclining: 9;
	    mixedSpanishDeclining: 10;
	    residual: 11;
	    formsAndMolds: 12;
	    spanishStraightlineMonth: 13;
	    laundry: 14;
	    frenchStraightline: 15;
	    gradual: 16;
	    withoutDepreciation: 17;
	    softy: 18;
	    productionUnit: 19;
	    straightlineBeyondNullSalvageUnit: 20;
	    portugueseMixedDeclining: 21;
	    ordinarioAnticipato: 22;
	    portugueseConstants: 23;
	    portugueseDuodecimos: 24;
	    amortNetVal: 25;
	    belgianStraightline: 26;
	    moroccanDeclining: 27;
	    russianStraightline: 28;
	    russianDeclining: 29;
	    russianConstant: 30;
	    russianSofty: 31;
	    russianUnits: 32;
	    polishStraightline: 33;
	    polishDeclining: 34;
	    romanianStraightline: 35;
	    romanianAccelerated: 36;
	    romanianDeclining: 37;
	    spanishStraightlineDay: 38;
	    onePeriod: 39;
	    primeCost: 40;
	    diminishingValue: 41;
	    swissStraightline: 42;
	    swissDeclining: 43;
	    turkishStraightline: 44;
	    turkishDeclining: 45;
	    austrianHalfYear: 46;
	}
	export type StandardDepreciationMethods = keyof StandardDepreciationMethods$EnumInterface;
	export const standardDepreciationMethodsDatatype: X3EnumDataType<keyof StandardDepreciationMethods$EnumInterface, unknown>;
	//# sourceMappingURL=standard-depreciation-methods.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/src-comp-sale-price-calcul.d.ts
declare module '@sage/x3-master-data/lib/enums/src-comp-sale-price-calcul' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SrcCompSalePriceCalculEnum {
	    nvAtEffectiveDateForSpecPlan = 1,
	    gvOfSpecifiedPlan = 2,
	    distribEnvelopeAccordingToSpecPlanNv = 3,
	    distribEnvelopeAccordingToSpecPlanGv = 4,
	    salePriceIdenticalToThatEnteredByUser = 5
	}
	export interface SrcCompSalePriceCalcul$EnumInterface {
	    nvAtEffectiveDateForSpecPlan: 1;
	    gvOfSpecifiedPlan: 2;
	    distribEnvelopeAccordingToSpecPlanNv: 3;
	    distribEnvelopeAccordingToSpecPlanGv: 4;
	    salePriceIdenticalToThatEnteredByUser: 5;
	}
	export type SrcCompSalePriceCalcul = keyof SrcCompSalePriceCalcul$EnumInterface;
	export const srcCompSalePriceCalculDatatype: X3EnumDataType<keyof SrcCompSalePriceCalcul$EnumInterface, unknown>;
	//# sourceMappingURL=src-comp-sale-price-calcul.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/split-object-numbering.d.ts
declare module '@sage/x3-master-data/lib/enums/split-object-numbering' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SplitObjectNumberingEnum {
	    none = 1,
	    byLineNumberIncrement = 2,
	    addANumericIncrement = 3,
	    newNumber = 4
	}
	export interface SplitObjectNumbering$EnumInterface {
	    none: 1;
	    byLineNumberIncrement: 2;
	    addANumericIncrement: 3;
	    newNumber: 4;
	}
	export type SplitObjectNumbering = keyof SplitObjectNumbering$EnumInterface;
	export const splitObjectNumberingDatatype: X3EnumDataType<keyof SplitObjectNumbering$EnumInterface, unknown>;
	//# sourceMappingURL=split-object-numbering.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/specific-deprec-rules.d.ts
declare module '@sage/x3-master-data/lib/enums/specific-deprec-rules' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SpecificDeprecRulesEnum {
	    none = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    depreciationChargeX2 = 4,
	    cancelDepreciationChargeX2 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    energySaving = 8,
	    substituteValue9 = 9,
	    press39Bis = 10,
	    dedicatedToResearch = 11,
	    substituteValue12 = 12,
	    software12Months = 13,
	    depreciationAdjustReint = 14,
	    cancelAmortizationExpense = 15,
	    basedOnPeriod = 16,
	    basedOnFy = 17,
	    bonus = 18,
	    substituteValue19 = 19
	}
	export interface SpecificDeprecRules$EnumInterface {
	    none: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    depreciationChargeX2: 4;
	    cancelDepreciationChargeX2: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    energySaving: 8;
	    substituteValue9: 9;
	    press39Bis: 10;
	    dedicatedToResearch: 11;
	    substituteValue12: 12;
	    software12Months: 13;
	    depreciationAdjustReint: 14;
	    cancelAmortizationExpense: 15;
	    basedOnPeriod: 16;
	    basedOnFy: 17;
	    bonus: 18;
	    substituteValue19: 19;
	}
	export type SpecificDeprecRules = keyof SpecificDeprecRules$EnumInterface;
	export const specificDeprecRulesDatatype: X3EnumDataType<keyof SpecificDeprecRules$EnumInterface, unknown>;
	//# sourceMappingURL=specific-deprec-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/spanish-invoice-type.d.ts
declare module '@sage/x3-master-data/lib/enums/spanish-invoice-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SpanishInvoiceTypeEnum {
	    f1FacturaArt677Y73DelRd16192012 = 1,
	    f2FacturaSimplificadaTicketYFacturasArt61DRd16192012 = 2,
	    r1RectificativaArt801Y802YErrorFundadoEnDerecho = 3,
	    r2RectificativaArt803 = 4,
	    r3RectificativaArt804 = 5,
	    r4RectificativaResto = 6,
	    r5RectificativaEnFacturasSimplificadas = 7,
	    f3FacturaEmitidaEnSustitucionDeSimplificadas = 8,
	    f4AsientoResumenDeFacturas = 9,
	    f5ImportacionesDua = 10,
	    f6OtrosJustificantesContables = 11,
	    lcAduanasLiquidacionComplementaria = 12
	}
	export interface SpanishInvoiceType$EnumInterface {
	    f1FacturaArt677Y73DelRd16192012: 1;
	    f2FacturaSimplificadaTicketYFacturasArt61DRd16192012: 2;
	    r1RectificativaArt801Y802YErrorFundadoEnDerecho: 3;
	    r2RectificativaArt803: 4;
	    r3RectificativaArt804: 5;
	    r4RectificativaResto: 6;
	    r5RectificativaEnFacturasSimplificadas: 7;
	    f3FacturaEmitidaEnSustitucionDeSimplificadas: 8;
	    f4AsientoResumenDeFacturas: 9;
	    f5ImportacionesDua: 10;
	    f6OtrosJustificantesContables: 11;
	    lcAduanasLiquidacionComplementaria: 12;
	}
	export type SpanishInvoiceType = keyof SpanishInvoiceType$EnumInterface;
	export const spanishInvoiceTypeDatatype: X3EnumDataType<keyof SpanishInvoiceType$EnumInterface, unknown>;
	//# sourceMappingURL=spanish-invoice-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/source.d.ts
declare module '@sage/x3-master-data/lib/enums/source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SourceEnum {
	    manual = 1,
	    salesOrder = 2,
	    supplierOrder = 3
	}
	export interface Source$EnumInterface {
	    manual: 1;
	    salesOrder: 2;
	    supplierOrder: 3;
	}
	export type Source = keyof Source$EnumInterface;
	export const sourceDatatype: X3EnumDataType<keyof Source$EnumInterface, unknown>;
	//# sourceMappingURL=source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sort-traitenr.d.ts
declare module '@sage/x3-master-data/lib/enums/sort-traitenr' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortTraitenrEnum {
	    dueDate = 1,
	    customer = 2
	}
	export interface SortTraitenr$EnumInterface {
	    dueDate: 1;
	    customer: 2;
	}
	export type SortTraitenr = keyof SortTraitenr$EnumInterface;
	export const sortTraitenrDatatype: X3EnumDataType<keyof SortTraitenr$EnumInterface, unknown>;
	//# sourceMappingURL=sort-traitenr.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sort-sequence-2624.d.ts
declare module '@sage/x3-master-data/lib/enums/sort-sequence-2624' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortSequence2624Enum {
	    bPs = 1,
	    payment = 2
	}
	export interface SortSequence2624$EnumInterface {
	    bPs: 1;
	    payment: 2;
	}
	export type SortSequence2624 = keyof SortSequence2624$EnumInterface;
	export const sortSequence2624Datatype: X3EnumDataType<keyof SortSequence2624$EnumInterface, unknown>;
	//# sourceMappingURL=sort-sequence-2624.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sort-payment.d.ts
declare module '@sage/x3-master-data/lib/enums/sort-payment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortPaymentEnum {
	    site = 1,
	    date = 2,
	    paymentType = 3,
	    bank = 4,
	    openItem = 5
	}
	export interface SortPayment$EnumInterface {
	    site: 1;
	    date: 2;
	    paymentType: 3;
	    bank: 4;
	    openItem: 5;
	}
	export type SortPayment = keyof SortPayment$EnumInterface;
	export const sortPaymentDatatype: X3EnumDataType<keyof SortPayment$EnumInterface, unknown>;
	//# sourceMappingURL=sort-payment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sort-order-3176.d.ts
declare module '@sage/x3-master-data/lib/enums/sort-order-3176' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortOrder3176Enum {
	    number = 1,
	    title = 2,
	    shortTitle = 3
	}
	export interface SortOrder3176$EnumInterface {
	    number: 1;
	    title: 2;
	    shortTitle: 3;
	}
	export type SortOrder3176 = keyof SortOrder3176$EnumInterface;
	export const sortOrder3176Datatype: X3EnumDataType<keyof SortOrder3176$EnumInterface, unknown>;
	//# sourceMappingURL=sort-order-3176.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sort-order-2627.d.ts
declare module '@sage/x3-master-data/lib/enums/sort-order-2627' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortOrder2627Enum {
	    paymentDateAccountingDate = 1,
	    transactionType = 2
	}
	export interface SortOrder2627$EnumInterface {
	    paymentDateAccountingDate: 1;
	    transactionType: 2;
	}
	export type SortOrder2627 = keyof SortOrder2627$EnumInterface;
	export const sortOrder2627Datatype: X3EnumDataType<keyof SortOrder2627$EnumInterface, unknown>;
	//# sourceMappingURL=sort-order-2627.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sort-options-print.d.ts
declare module '@sage/x3-master-data/lib/enums/sort-options-print' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortOptionsPrintEnum {
	    classificationBySiteLocation = 1,
	    classificationBySiteGroup = 2
	}
	export interface SortOptionsPrint$EnumInterface {
	    classificationBySiteLocation: 1;
	    classificationBySiteGroup: 2;
	}
	export type SortOptionsPrint = keyof SortOptionsPrint$EnumInterface;
	export const sortOptionsPrintDatatype: X3EnumDataType<keyof SortOptionsPrint$EnumInterface, unknown>;
	//# sourceMappingURL=sort-options-print.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sort-option.d.ts
declare module '@sage/x3-master-data/lib/enums/sort-option' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortOptionEnum {
	    dueDate = 1,
	    sourceDate = 2,
	    documentType = 3
	}
	export interface SortOption$EnumInterface {
	    dueDate: 1;
	    sourceDate: 2;
	    documentType: 3;
	}
	export type SortOption = keyof SortOption$EnumInterface;
	export const sortOptionDatatype: X3EnumDataType<keyof SortOption$EnumInterface, unknown>;
	//# sourceMappingURL=sort-option.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sort-bp-invoices.d.ts
declare module '@sage/x3-master-data/lib/enums/sort-bp-invoices' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortBpInvoicesEnum {
	    byNumber = 1,
	    byCustomer = 2
	}
	export interface SortBpInvoices$EnumInterface {
	    byNumber: 1;
	    byCustomer: 2;
	}
	export type SortBpInvoices = keyof SortBpInvoices$EnumInterface;
	export const sortBpInvoicesDatatype: X3EnumDataType<keyof SortBpInvoices$EnumInterface, unknown>;
	//# sourceMappingURL=sort-bp-invoices.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sort-bp-invoices-858.d.ts
declare module '@sage/x3-master-data/lib/enums/sort-bp-invoices-858' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortBpInvoices858Enum {
	    byNumber = 1,
	    bySupplier = 2
	}
	export interface SortBpInvoices858$EnumInterface {
	    byNumber: 1;
	    bySupplier: 2;
	}
	export type SortBpInvoices858 = keyof SortBpInvoices858$EnumInterface;
	export const sortBpInvoices858Datatype: X3EnumDataType<keyof SortBpInvoices858$EnumInterface, unknown>;
	//# sourceMappingURL=sort-bp-invoices-858.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sort-asset-reports.d.ts
declare module '@sage/x3-master-data/lib/enums/sort-asset-reports' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortAssetReportsEnum {
	    financialSite = 1,
	    accountingCode = 2,
	    coAAccount = 3,
	    ifrsAccount = 4,
	    group = 5,
	    analyticalDistribKey = 6,
	    cgu = 7,
	    geographicSite = 8,
	    none = 9
	}
	export interface SortAssetReports$EnumInterface {
	    financialSite: 1;
	    accountingCode: 2;
	    coAAccount: 3;
	    ifrsAccount: 4;
	    group: 5;
	    analyticalDistribKey: 6;
	    cgu: 7;
	    geographicSite: 8;
	    none: 9;
	}
	export type SortAssetReports = keyof SortAssetReports$EnumInterface;
	export const sortAssetReportsDatatype: X3EnumDataType<keyof SortAssetReports$EnumInterface, unknown>;
	//# sourceMappingURL=sort-asset-reports.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sii-operation.d.ts
declare module '@sage/x3-master-data/lib/enums/sii-operation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SiiOperationEnum {
	    creation = 1,
	    modification = 2,
	    cancellation = 3,
	    inquiry = 4
	}
	export interface SiiOperation$EnumInterface {
	    creation: 1;
	    modification: 2;
	    cancellation: 3;
	    inquiry: 4;
	}
	export type SiiOperation = keyof SiiOperation$EnumInterface;
	export const siiOperationDatatype: X3EnumDataType<keyof SiiOperation$EnumInterface, unknown>;
	//# sourceMappingURL=sii-operation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sii-messages.d.ts
declare module '@sage/x3-master-data/lib/enums/sii-messages' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SiiMessagesEnum {
	    resynchronizeTheTaxTableVatAndCash = 1,
	    theDatesMustBeIncludedInTheSameYear = 2,
	    emptyInvoiceNumberUseTheModificationOptionToUpdateIt = 3,
	    emptySourceDocumentNumberUseTheModificationOptionToUpdateIt = 4,
	    theAmountMustBeLargerThan = 5,
	    thisBpAlreadyExistsForThisOperationType = 6,
	    thisInvoiceDoesNotExistInTheReceivedInvoicesBook = 7,
	    aRecordAlreadyExistsForThisYear = 8,
	    manualInsertionIsNotAllowedWhenTheDataSourceIsNotX3 = 9,
	    onlyTheseValuesAreAllowed = 10,
	    thisValueIsNotAllowedInIssuedInvoices = 11,
	    youHaveModifiedTheIdentifierDoYouWantToDeleteTheCurrentRecordForThisIdentifierAndCreateANewOne = 12,
	    annualInsurancesAreNotUsedInTheCanaryIslands = 13,
	    modificationIsNotAllowedIfThisValueIsIncorrectUseTheModificationOptionToCancelTheLine = 14,
	    selectAllRecords = 15,
	    clearAllRecords = 16,
	    reactivateTheRejectedRecordsOfUnregisteredCustomers = 17,
	    reactivateAllTheRecordsForThisError = 18,
	    identificationIsMandatoryForThisRecordType = 19,
	    valueNotAllowedWhenDeleteOrSendOptionsAreActive = 20,
	    valueIsNotAllowedReactivateCancelAndSendOptionsMustBeInactive = 21,
	    valueIsNotAllowedReactivateCancelAndDeleteOptionsMustBeInactive = 22,
	    thisInvoiceAlreadyExistsWithThisAsset = 23,
	    nothingSelectedForTransmission = 24,
	    messageTransmission = 25,
	    messageTransmissionSummary = 26,
	    messageTransmissionCompleted = 27,
	    totalInvoicesIssued = 28,
	    totalInvoicesReceived = 29,
	    totalEuOperations = 30,
	    totalFixedAssetsOperations = 31,
	    totalCashVatCollections = 32,
	    totalCashVatPayments = 33,
	    totalAnnualOperations = 34,
	    documentWithoutSourceDocumentNumber = 35,
	    problemInProcessingTheAnswerStatusNotFound = 36,
	    problemProcessingThisDocument = 37,
	    problemProcessingThisInvoice = 38,
	    thisInvoiceHasBeenProcessed = 39,
	    thisDocumentHasBeenProcessed = 40,
	    invoiceReceivedWithoutSourceDocumentNumber = 41,
	    cashVatPaymentWithoutSourceDocument = 42,
	    siiUpdateInProgress = 43,
	    siiControl = 44,
	    processedDateRange = 45,
	    controlOfSiiRecordsWithoutTransmission = 46,
	    siiControlSummary = 47,
	    expired = 48,
	    controlOfRecordsInSiiCompleted = 49,
	    theDocumentDoesNotExistInTheVatTable = 50,
	    operationDate = 51,
	    daysBeforeTheExpirationDate = 52,
	    accountingEntriesWithVatAndWithoutInvoice = 53,
	    documentNotTransmitted = 54,
	    theValueMustBeANumberFrom1To4 = 55,
	    informationTransmissionError = 56,
	    errorMessage = 57,
	    globalTransmissionStatus = 58,
	    inquiryResult = 59,
	    documentSelection = 60,
	    companyCertificateNotFound = 61,
	    processedBPs = 62,
	    unidentifiedTiNs = 63,
	    identifiedAsRevokedTiNs = 64,
	    identifiedAsCancelledTiNs = 65,
	    unidentifiedButSimilarTiNs = 66,
	    differentTiNsFound = 67,
	    allTheTiNsHaveBeenIdentified = 68,
	    webserviceExecutionErrorPleaseContactTheX3SupportAndProvideThemWithTheFollowingMessage = 69,
	    recordReadingError = 70,
	    recordsRecoveredFromAeat = 71,
	    updatingFromAeatTotalUpdatedRecords = 72,
	    problemWhenTryingToDisplayTheAeatData = 73,
	    noData = 74,
	    errorInTheStructureOfTheFileToBeSentUseTheWrijsonEntryPointToCheckTheTestJsonFile = 75,
	    problemWithTheCertificatePrivateKey = 76,
	    bookType = 77,
	    receiverTin = 78,
	    receiverIdentification = 79,
	    totalConsignment = 80
	}
	export interface SiiMessages$EnumInterface {
	    resynchronizeTheTaxTableVatAndCash: 1;
	    theDatesMustBeIncludedInTheSameYear: 2;
	    emptyInvoiceNumberUseTheModificationOptionToUpdateIt: 3;
	    emptySourceDocumentNumberUseTheModificationOptionToUpdateIt: 4;
	    theAmountMustBeLargerThan: 5;
	    thisBpAlreadyExistsForThisOperationType: 6;
	    thisInvoiceDoesNotExistInTheReceivedInvoicesBook: 7;
	    aRecordAlreadyExistsForThisYear: 8;
	    manualInsertionIsNotAllowedWhenTheDataSourceIsNotX3: 9;
	    onlyTheseValuesAreAllowed: 10;
	    thisValueIsNotAllowedInIssuedInvoices: 11;
	    youHaveModifiedTheIdentifierDoYouWantToDeleteTheCurrentRecordForThisIdentifierAndCreateANewOne: 12;
	    annualInsurancesAreNotUsedInTheCanaryIslands: 13;
	    modificationIsNotAllowedIfThisValueIsIncorrectUseTheModificationOptionToCancelTheLine: 14;
	    selectAllRecords: 15;
	    clearAllRecords: 16;
	    reactivateTheRejectedRecordsOfUnregisteredCustomers: 17;
	    reactivateAllTheRecordsForThisError: 18;
	    identificationIsMandatoryForThisRecordType: 19;
	    valueNotAllowedWhenDeleteOrSendOptionsAreActive: 20;
	    valueIsNotAllowedReactivateCancelAndSendOptionsMustBeInactive: 21;
	    valueIsNotAllowedReactivateCancelAndDeleteOptionsMustBeInactive: 22;
	    thisInvoiceAlreadyExistsWithThisAsset: 23;
	    nothingSelectedForTransmission: 24;
	    messageTransmission: 25;
	    messageTransmissionSummary: 26;
	    messageTransmissionCompleted: 27;
	    totalInvoicesIssued: 28;
	    totalInvoicesReceived: 29;
	    totalEuOperations: 30;
	    totalFixedAssetsOperations: 31;
	    totalCashVatCollections: 32;
	    totalCashVatPayments: 33;
	    totalAnnualOperations: 34;
	    documentWithoutSourceDocumentNumber: 35;
	    problemInProcessingTheAnswerStatusNotFound: 36;
	    problemProcessingThisDocument: 37;
	    problemProcessingThisInvoice: 38;
	    thisInvoiceHasBeenProcessed: 39;
	    thisDocumentHasBeenProcessed: 40;
	    invoiceReceivedWithoutSourceDocumentNumber: 41;
	    cashVatPaymentWithoutSourceDocument: 42;
	    siiUpdateInProgress: 43;
	    siiControl: 44;
	    processedDateRange: 45;
	    controlOfSiiRecordsWithoutTransmission: 46;
	    siiControlSummary: 47;
	    expired: 48;
	    controlOfRecordsInSiiCompleted: 49;
	    theDocumentDoesNotExistInTheVatTable: 50;
	    operationDate: 51;
	    daysBeforeTheExpirationDate: 52;
	    accountingEntriesWithVatAndWithoutInvoice: 53;
	    documentNotTransmitted: 54;
	    theValueMustBeANumberFrom1To4: 55;
	    informationTransmissionError: 56;
	    errorMessage: 57;
	    globalTransmissionStatus: 58;
	    inquiryResult: 59;
	    documentSelection: 60;
	    companyCertificateNotFound: 61;
	    processedBPs: 62;
	    unidentifiedTiNs: 63;
	    identifiedAsRevokedTiNs: 64;
	    identifiedAsCancelledTiNs: 65;
	    unidentifiedButSimilarTiNs: 66;
	    differentTiNsFound: 67;
	    allTheTiNsHaveBeenIdentified: 68;
	    webserviceExecutionErrorPleaseContactTheX3SupportAndProvideThemWithTheFollowingMessage: 69;
	    recordReadingError: 70;
	    recordsRecoveredFromAeat: 71;
	    updatingFromAeatTotalUpdatedRecords: 72;
	    problemWhenTryingToDisplayTheAeatData: 73;
	    noData: 74;
	    errorInTheStructureOfTheFileToBeSentUseTheWrijsonEntryPointToCheckTheTestJsonFile: 75;
	    problemWithTheCertificatePrivateKey: 76;
	    bookType: 77;
	    receiverTin: 78;
	    receiverIdentification: 79;
	    totalConsignment: 80;
	}
	export type SiiMessages = keyof SiiMessages$EnumInterface;
	export const siiMessagesDatatype: X3EnumDataType<keyof SiiMessages$EnumInterface, unknown>;
	//# sourceMappingURL=sii-messages.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/signature-format.d.ts
declare module '@sage/x3-master-data/lib/enums/signature-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SignatureFormatEnum {
	    withoutSignature = 1,
	    xAdEs = 2
	}
	export interface SignatureFormat$EnumInterface {
	    withoutSignature: 1;
	    xAdEs: 2;
	}
	export type SignatureFormat = keyof SignatureFormat$EnumInterface;
	export const signatureFormatDatatype: X3EnumDataType<keyof SignatureFormat$EnumInterface, unknown>;
	//# sourceMappingURL=signature-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sign.d.ts
declare module '@sage/x3-master-data/lib/enums/sign' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SignEnum {
	    credit = 1,
	    debit = 2
	}
	export interface Sign$EnumInterface {
	    credit: 1;
	    debit: 2;
	}
	export type Sign = keyof Sign$EnumInterface;
	export const signDatatype: X3EnumDataType<keyof Sign$EnumInterface, unknown>;
	//# sourceMappingURL=sign.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/shortage-delivery.d.ts
declare module '@sage/x3-master-data/lib/enums/shortage-delivery' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ShortageDeliveryEnum {
	    no = 1,
	    yes = 2,
	    yesProductWithNegativeStockProhibited = 3
	}
	export interface ShortageDelivery$EnumInterface {
	    no: 1;
	    yes: 2;
	    yesProductWithNegativeStockProhibited: 3;
	}
	export type ShortageDelivery = keyof ShortageDelivery$EnumInterface;
	export const shortageDeliveryDatatype: X3EnumDataType<keyof ShortageDelivery$EnumInterface, unknown>;
	//# sourceMappingURL=shortage-delivery.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/severity.d.ts
declare module '@sage/x3-master-data/lib/enums/severity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SeverityEnum {
	    information = 1,
	    warning = 2,
	    error = 3
	}
	export interface Severity$EnumInterface {
	    information: 1;
	    warning: 2;
	    error: 3;
	}
	export type Severity = keyof Severity$EnumInterface;
	export const severityDatatype: X3EnumDataType<keyof Severity$EnumInterface, unknown>;
	//# sourceMappingURL=severity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/severity-level.d.ts
declare module '@sage/x3-master-data/lib/enums/severity-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SeverityLevelEnum {
	    select = 1,
	    critical = 2,
	    major = 3,
	    moderate = 4,
	    minorCosmetic = 5
	}
	export interface SeverityLevel$EnumInterface {
	    select: 1;
	    critical: 2;
	    major: 3;
	    moderate: 4;
	    minorCosmetic: 5;
	}
	export type SeverityLevel = keyof SeverityLevel$EnumInterface;
	export const severityLevelDatatype: X3EnumDataType<keyof SeverityLevel$EnumInterface, unknown>;
	//# sourceMappingURL=severity-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/set-up-option-type.d.ts
declare module '@sage/x3-master-data/lib/enums/set-up-option-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SetUpOptionTypeEnum {
	    replacementOfConstantRate = 1,
	    increaseOfConstantRate = 2,
	    decreaseOfConstantRate = 3,
	    replacementOfMinimumValue = 4,
	    replacementOfCeilingValue = 5,
	    replacementOfExceptionalDepreciation = 6,
	    optionBelgianMode = 7,
	    optionItalianMode = 8,
	    optionGermanMode = 9,
	    optionStraightLineMode = 10
	}
	export interface SetUpOptionType$EnumInterface {
	    replacementOfConstantRate: 1;
	    increaseOfConstantRate: 2;
	    decreaseOfConstantRate: 3;
	    replacementOfMinimumValue: 4;
	    replacementOfCeilingValue: 5;
	    replacementOfExceptionalDepreciation: 6;
	    optionBelgianMode: 7;
	    optionItalianMode: 8;
	    optionGermanMode: 9;
	    optionStraightLineMode: 10;
	}
	export type SetUpOptionType = keyof SetUpOptionType$EnumInterface;
	export const setUpOptionTypeDatatype: X3EnumDataType<keyof SetUpOptionType$EnumInterface, unknown>;
	//# sourceMappingURL=set-up-option-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/service-status.d.ts
declare module '@sage/x3-master-data/lib/enums/service-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ServiceStatusEnum {
	    onHold = 1,
	    inProgress = 2,
	    closed = 3,
	    ordered = 4,
	    received = 5,
	    inoviced = 6
	}
	export interface ServiceStatus$EnumInterface {
	    onHold: 1;
	    inProgress: 2;
	    closed: 3;
	    ordered: 4;
	    received: 5;
	    inoviced: 6;
	}
	export type ServiceStatus = keyof ServiceStatus$EnumInterface;
	export const serviceStatusDatatype: X3EnumDataType<keyof ServiceStatus$EnumInterface, unknown>;
	//# sourceMappingURL=service-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/service-request-source.d.ts
declare module '@sage/x3-master-data/lib/enums/service-request-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ServiceRequestSourceEnum {
	    manualCreation = 1,
	    maintenancePlan = 2
	}
	export interface ServiceRequestSource$EnumInterface {
	    manualCreation: 1;
	    maintenancePlan: 2;
	}
	export type ServiceRequestSource = keyof ServiceRequestSource$EnumInterface;
	export const serviceRequestSourceDatatype: X3EnumDataType<keyof ServiceRequestSource$EnumInterface, unknown>;
	//# sourceMappingURL=service-request-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/service-request-invoicing.d.ts
declare module '@sage/x3-master-data/lib/enums/service-request-invoicing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ServiceRequestInvoicingEnum {
	    nonInvoicable = 1,
	    invoicable = 2,
	    invoiced = 3
	}
	export interface ServiceRequestInvoicing$EnumInterface {
	    nonInvoicable: 1;
	    invoicable: 2;
	    invoiced: 3;
	}
	export type ServiceRequestInvoicing = keyof ServiceRequestInvoicing$EnumInterface;
	export const serviceRequestInvoicingDatatype: X3EnumDataType<keyof ServiceRequestInvoicing$EnumInterface, unknown>;
	//# sourceMappingURL=service-request-invoicing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/service-request-allocation.d.ts
declare module '@sage/x3-master-data/lib/enums/service-request-allocation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ServiceRequestAllocationEnum {
	    dispatching = 1,
	    employee = 2,
	    queue = 3
	}
	export interface ServiceRequestAllocation$EnumInterface {
	    dispatching: 1;
	    employee: 2;
	    queue: 3;
	}
	export type ServiceRequestAllocation = keyof ServiceRequestAllocation$EnumInterface;
	export const serviceRequestAllocationDatatype: X3EnumDataType<keyof ServiceRequestAllocation$EnumInterface, unknown>;
	//# sourceMappingURL=service-request-allocation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/service-contract-source.d.ts
declare module '@sage/x3-master-data/lib/enums/service-contract-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ServiceContractSourceEnum {
	    manualCreation = 1,
	    salesOrder = 2,
	    salesShipment = 3,
	    salesInvoice = 4,
	    warrantyRequest = 5,
	    serviceContractDuplication = 6,
	    pointsCredit = 7
	}
	export interface ServiceContractSource$EnumInterface {
	    manualCreation: 1;
	    salesOrder: 2;
	    salesShipment: 3;
	    salesInvoice: 4;
	    warrantyRequest: 5;
	    serviceContractDuplication: 6;
	    pointsCredit: 7;
	}
	export type ServiceContractSource = keyof ServiceContractSource$EnumInterface;
	export const serviceContractSourceDatatype: X3EnumDataType<keyof ServiceContractSource$EnumInterface, unknown>;
	//# sourceMappingURL=service-contract-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/service-contract-sort.d.ts
declare module '@sage/x3-master-data/lib/enums/service-contract-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ServiceContractSortEnum {
	    number = 1,
	    date = 2,
	    customer = 3,
	    category = 4
	}
	export interface ServiceContractSort$EnumInterface {
	    number: 1;
	    date: 2;
	    customer: 3;
	    category: 4;
	}
	export type ServiceContractSort = keyof ServiceContractSort$EnumInterface;
	export const serviceContractSortDatatype: X3EnumDataType<keyof ServiceContractSort$EnumInterface, unknown>;
	//# sourceMappingURL=service-contract-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/service-contract-invoice-date.d.ts
declare module '@sage/x3-master-data/lib/enums/service-contract-invoice-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ServiceContractInvoiceDateEnum {
	    todaysDate = 1,
	    nextInvoiceDate = 2
	}
	export interface ServiceContractInvoiceDate$EnumInterface {
	    todaysDate: 1;
	    nextInvoiceDate: 2;
	}
	export type ServiceContractInvoiceDate = keyof ServiceContractInvoiceDate$EnumInterface;
	export const serviceContractInvoiceDateDatatype: X3EnumDataType<keyof ServiceContractInvoiceDate$EnumInterface, unknown>;
	//# sourceMappingURL=service-contract-invoice-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/service-contract-categories.d.ts
declare module '@sage/x3-master-data/lib/enums/service-contract-categories' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ServiceContractCategoriesEnum {
	    warranty = 1,
	    meeting = 2,
	    maintenance = 3,
	    byPoints = 4
	}
	export interface ServiceContractCategories$EnumInterface {
	    warranty: 1;
	    meeting: 2;
	    maintenance: 3;
	    byPoints: 4;
	}
	export type ServiceContractCategories = keyof ServiceContractCategories$EnumInterface;
	export const serviceContractCategoriesDatatype: X3EnumDataType<keyof ServiceContractCategories$EnumInterface, unknown>;
	//# sourceMappingURL=service-contract-categories.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/serial-number-management.d.ts
declare module '@sage/x3-master-data/lib/enums/serial-number-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SerialNumberManagementEnum {
	    notManaged = 1,
	    issued = 2,
	    receivedIssued = 3,
	    globalReceivedIssued = 4
	}
	export interface SerialNumberManagement$EnumInterface {
	    notManaged: 1;
	    issued: 2;
	    receivedIssued: 3;
	    globalReceivedIssued: 4;
	}
	export type SerialNumberManagement = keyof SerialNumberManagement$EnumInterface;
	export const serialNumberManagementDatatype: X3EnumDataType<keyof SerialNumberManagement$EnumInterface, unknown>;
	//# sourceMappingURL=serial-number-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sequence-calculation-method.d.ts
declare module '@sage/x3-master-data/lib/enums/sequence-calculation-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SequenceCalculationMethodEnum {
	    substituteValue1 = 1,
	    aToZ2 = 2,
	    aToZ = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5
	}
	export interface SequenceCalculationMethod$EnumInterface {
	    substituteValue1: 1;
	    aToZ2: 2;
	    aToZ: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	}
	export type SequenceCalculationMethod = keyof SequenceCalculationMethod$EnumInterface;
	export const sequenceCalculationMethodDatatype: X3EnumDataType<keyof SequenceCalculationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=sequence-calculation-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/separator-type.d.ts
declare module '@sage/x3-master-data/lib/enums/separator-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SeparatorTypeEnum {
	    character = 1,
	    asciiCode = 2
	}
	export interface SeparatorType$EnumInterface {
	    character: 1;
	    asciiCode: 2;
	}
	export type SeparatorType = keyof SeparatorType$EnumInterface;
	export const separatorTypeDatatype: X3EnumDataType<keyof SeparatorType$EnumInterface, unknown>;
	//# sourceMappingURL=separator-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sense.d.ts
declare module '@sage/x3-master-data/lib/enums/sense' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SenseEnum {
	    outbound = 1,
	    inbound = 2
	}
	export interface Sense$EnumInterface {
	    outbound: 1;
	    inbound: 2;
	}
	export type Sense = keyof Sense$EnumInterface;
	export const senseDatatype: X3EnumDataType<keyof Sense$EnumInterface, unknown>;
	//# sourceMappingURL=sense.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/selection-of-the-issued-assets.d.ts
declare module '@sage/x3-master-data/lib/enums/selection-of-the-issued-assets' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionOfTheIssuedAssetsEnum {
	    issuedAndNonIssuedAssets = 1,
	    nonIssuedAssets = 2,
	    issuedAssets = 3
	}
	export interface SelectionOfTheIssuedAssets$EnumInterface {
	    issuedAndNonIssuedAssets: 1;
	    nonIssuedAssets: 2;
	    issuedAssets: 3;
	}
	export type SelectionOfTheIssuedAssets = keyof SelectionOfTheIssuedAssets$EnumInterface;
	export const selectionOfTheIssuedAssetsDatatype: X3EnumDataType<keyof SelectionOfTheIssuedAssets$EnumInterface, unknown>;
	//# sourceMappingURL=selection-of-the-issued-assets.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/selection-master.d.ts
declare module '@sage/x3-master-data/lib/enums/selection-master' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionMasterEnum {
	    prospectsCustomers = 1,
	    businessPartners = 2,
	    contacts = 3
	}
	export interface SelectionMaster$EnumInterface {
	    prospectsCustomers: 1;
	    businessPartners: 2;
	    contacts: 3;
	}
	export type SelectionMaster = keyof SelectionMaster$EnumInterface;
	export const selectionMasterDatatype: X3EnumDataType<keyof SelectionMaster$EnumInterface, unknown>;
	//# sourceMappingURL=selection-master.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/selection-master-966.d.ts
declare module '@sage/x3-master-data/lib/enums/selection-master-966' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionMaster966Enum {
	    prospectsCustomers = 1,
	    businessPartners = 2
	}
	export interface SelectionMaster966$EnumInterface {
	    prospectsCustomers: 1;
	    businessPartners: 2;
	}
	export type SelectionMaster966 = keyof SelectionMaster966$EnumInterface;
	export const selectionMaster966Datatype: X3EnumDataType<keyof SelectionMaster966$EnumInterface, unknown>;
	//# sourceMappingURL=selection-master-966.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/selection-assets-entered.d.ts
declare module '@sage/x3-master-data/lib/enums/selection-assets-entered' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionAssetsEnteredEnum {
	    allAssetsPresentInFiscalYearPeriod = 1,
	    assetsEnteredInFiscalYearPeriod = 2,
	    assetsEnteredBeforeCurrentFyPeriod = 3
	}
	export interface SelectionAssetsEntered$EnumInterface {
	    allAssetsPresentInFiscalYearPeriod: 1;
	    assetsEnteredInFiscalYearPeriod: 2;
	    assetsEnteredBeforeCurrentFyPeriod: 3;
	}
	export type SelectionAssetsEntered = keyof SelectionAssetsEntered$EnumInterface;
	export const selectionAssetsEnteredDatatype: X3EnumDataType<keyof SelectionAssetsEntered$EnumInterface, unknown>;
	//# sourceMappingURL=selection-assets-entered.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/select-lead-time-3390.d.ts
declare module '@sage/x3-master-data/lib/enums/select-lead-time-3390' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectLeadTime3390Enum {
	    product = 1,
	    routing = 2
	}
	export interface SelectLeadTime3390$EnumInterface {
	    product: 1;
	    routing: 2;
	}
	export type SelectLeadTime3390 = keyof SelectLeadTime3390$EnumInterface;
	export const selectLeadTime3390Datatype: X3EnumDataType<keyof SelectLeadTime3390$EnumInterface, unknown>;
	//# sourceMappingURL=select-lead-time-3390.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sectors-management.d.ts
declare module '@sage/x3-master-data/lib/enums/sectors-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SectorsManagementEnum {
	    none = 1,
	    dynamic = 2,
	    manual = 3
	}
	export interface SectorsManagement$EnumInterface {
	    none: 1;
	    dynamic: 2;
	    manual: 3;
	}
	export type SectorsManagement = keyof SectorsManagement$EnumInterface;
	export const sectorsManagementDatatype: X3EnumDataType<keyof SectorsManagement$EnumInterface, unknown>;
	//# sourceMappingURL=sectors-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/seasonality-type.d.ts
declare module '@sage/x3-master-data/lib/enums/seasonality-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SeasonalityTypeEnum {
	    decreasing = 1,
	    increasing = 2
	}
	export interface SeasonalityType$EnumInterface {
	    decreasing: 1;
	    increasing: 2;
	}
	export type SeasonalityType = keyof SeasonalityType$EnumInterface;
	export const seasonalityTypeDatatype: X3EnumDataType<keyof SeasonalityType$EnumInterface, unknown>;
	//# sourceMappingURL=seasonality-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/search-destination.d.ts
declare module '@sage/x3-master-data/lib/enums/search-destination' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SearchDestinationEnum {
	    sageX3 = 1,
	    file = 2
	}
	export interface SearchDestination$EnumInterface {
	    sageX3: 1;
	    file: 2;
	}
	export type SearchDestination = keyof SearchDestination$EnumInterface;
	export const searchDestinationDatatype: X3EnumDataType<keyof SearchDestination$EnumInterface, unknown>;
	//# sourceMappingURL=search-destination.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/script-response-storage.d.ts
declare module '@sage/x3-master-data/lib/enums/script-response-storage' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ScriptResponseStorageEnum {
	    businessPartners = 1,
	    prospectsCustomers = 2,
	    contacts = 3
	}
	export interface ScriptResponseStorage$EnumInterface {
	    businessPartners: 1;
	    prospectsCustomers: 2;
	    contacts: 3;
	}
	export type ScriptResponseStorage = keyof ScriptResponseStorage$EnumInterface;
	export const scriptResponseStorageDatatype: X3EnumDataType<keyof ScriptResponseStorage$EnumInterface, unknown>;
	//# sourceMappingURL=script-response-storage.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/schedule.d.ts
declare module '@sage/x3-master-data/lib/enums/schedule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ScheduleEnum {
	    perUnit = 1,
	    amount = 2
	}
	export interface Schedule$EnumInterface {
	    perUnit: 1;
	    amount: 2;
	}
	export type Schedule = keyof Schedule$EnumInterface;
	export const scheduleDatatype: X3EnumDataType<keyof Schedule$EnumInterface, unknown>;
	//# sourceMappingURL=schedule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/scanning-device.d.ts
declare module '@sage/x3-master-data/lib/enums/scanning-device' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ScanningDeviceEnum {
	    pdt3100 = 1,
	    sageInventoryTools = 2
	}
	export interface ScanningDevice$EnumInterface {
	    pdt3100: 1;
	    sageInventoryTools: 2;
	}
	export type ScanningDevice = keyof ScanningDevice$EnumInterface;
	export const scanningDeviceDatatype: X3EnumDataType<keyof ScanningDevice$EnumInterface, unknown>;
	//# sourceMappingURL=scanning-device.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/scaling-control.d.ts
declare module '@sage/x3-master-data/lib/enums/scaling-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ScalingControlEnum {
	    byServerBatch = 1,
	    serverBatchManualRequestModifications = 2
	}
	export interface ScalingControl$EnumInterface {
	    byServerBatch: 1;
	    serverBatchManualRequestModifications: 2;
	}
	export type ScalingControl = keyof ScalingControl$EnumInterface;
	export const scalingControlDatatype: X3EnumDataType<keyof ScalingControl$EnumInterface, unknown>;
	//# sourceMappingURL=scaling-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/scaling-analytical-period.d.ts
declare module '@sage/x3-master-data/lib/enums/scaling-analytical-period' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ScalingAnalyticalPeriodEnum {
	    startOfYear = 1,
	    firstRequest = 2,
	    fixedDate = 3,
	    numberDaysCurrentDay = 4
	}
	export interface ScalingAnalyticalPeriod$EnumInterface {
	    startOfYear: 1;
	    firstRequest: 2;
	    fixedDate: 3;
	    numberDaysCurrentDay: 4;
	}
	export type ScalingAnalyticalPeriod = keyof ScalingAnalyticalPeriod$EnumInterface;
	export const scalingAnalyticalPeriodDatatype: X3EnumDataType<keyof ScalingAnalyticalPeriod$EnumInterface, unknown>;
	//# sourceMappingURL=scaling-analytical-period.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sampling-type.d.ts
declare module '@sage/x3-master-data/lib/enums/sampling-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SamplingTypeEnum {
	    none = 1,
	    single = 2
	}
	export interface SamplingType$EnumInterface {
	    none: 1;
	    single: 2;
	}
	export type SamplingType = keyof SamplingType$EnumInterface;
	export const samplingTypeDatatype: X3EnumDataType<keyof SamplingType$EnumInterface, unknown>;
	//# sourceMappingURL=sampling-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sampling-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/sampling-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SamplingModeEnum {
	    global = 1,
	    lot = 2,
	    noManagement = 3
	}
	export interface SamplingMode$EnumInterface {
	    global: 1;
	    lot: 2;
	    noManagement: 3;
	}
	export type SamplingMode = keyof SamplingMode$EnumInterface;
	export const samplingModeDatatype: X3EnumDataType<keyof SamplingMode$EnumInterface, unknown>;
	//# sourceMappingURL=sampling-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sales-rep-site.d.ts
declare module '@sage/x3-master-data/lib/enums/sales-rep-site' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesRepSiteEnum {
	    doNothing = 1,
	    suggestThatOfTheSalesRep = 2,
	    replaceByThatOfTheSalesRep = 3
	}
	export interface SalesRepSite$EnumInterface {
	    doNothing: 1;
	    suggestThatOfTheSalesRep: 2;
	    replaceByThatOfTheSalesRep: 3;
	}
	export type SalesRepSite = keyof SalesRepSite$EnumInterface;
	export const salesRepSiteDatatype: X3EnumDataType<keyof SalesRepSite$EnumInterface, unknown>;
	//# sourceMappingURL=sales-rep-site.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sales-order-stage.d.ts
declare module '@sage/x3-master-data/lib/enums/sales-order-stage' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesOrderStageEnum {
	    order = 1,
	    preparation = 2,
	    delivery = 3
	}
	export interface SalesOrderStage$EnumInterface {
	    order: 1;
	    preparation: 2;
	    delivery: 3;
	}
	export type SalesOrderStage = keyof SalesOrderStage$EnumInterface;
	export const salesOrderStageDatatype: X3EnumDataType<keyof SalesOrderStage$EnumInterface, unknown>;
	//# sourceMappingURL=sales-order-stage.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sales-journal-type.d.ts
declare module '@sage/x3-master-data/lib/enums/sales-journal-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesJournalTypeEnum {
	    invoice = 1,
	    creditMemo = 2,
	    return = 3,
	    delivery = 4,
	    pickTicket = 5,
	    preparationList = 6,
	    openOrder = 7,
	    order = 8,
	    quote = 9,
	    journal = 10,
	    project = 11,
	    openItem = 12,
	    payment = 13,
	    statement = 14,
	    prepayment = 15,
	    task = 16,
	    call = 17,
	    appointment = 18,
	    serviceContract = 19,
	    installedBase = 20,
	    serviceRequest = 21,
	    serviceResponse = 22,
	    solution = 23,
	    purchaseInvoice = 24,
	    purchaseCreditMemo = 25,
	    purchaseReturn = 26,
	    purchaseReceipt = 27,
	    purchaseOpenOrder = 28,
	    purchaseOrder = 29,
	    subcontractOrder = 30,
	    purchaseRequest = 31,
	    rfQs = 32,
	    purchaseAdditionalInvoice = 33,
	    expense = 34,
	    asset = 35,
	    supplierBpInvoice = 36,
	    container = 37,
	    shipping = 38,
	    transport = 39,
	    projectManagement = 40
	}
	export interface SalesJournalType$EnumInterface {
	    invoice: 1;
	    creditMemo: 2;
	    return: 3;
	    delivery: 4;
	    pickTicket: 5;
	    preparationList: 6;
	    openOrder: 7;
	    order: 8;
	    quote: 9;
	    journal: 10;
	    project: 11;
	    openItem: 12;
	    payment: 13;
	    statement: 14;
	    prepayment: 15;
	    task: 16;
	    call: 17;
	    appointment: 18;
	    serviceContract: 19;
	    installedBase: 20;
	    serviceRequest: 21;
	    serviceResponse: 22;
	    solution: 23;
	    purchaseInvoice: 24;
	    purchaseCreditMemo: 25;
	    purchaseReturn: 26;
	    purchaseReceipt: 27;
	    purchaseOpenOrder: 28;
	    purchaseOrder: 29;
	    subcontractOrder: 30;
	    purchaseRequest: 31;
	    rfQs: 32;
	    purchaseAdditionalInvoice: 33;
	    expense: 34;
	    asset: 35;
	    supplierBpInvoice: 36;
	    container: 37;
	    shipping: 38;
	    transport: 39;
	    projectManagement: 40;
	}
	export type SalesJournalType = keyof SalesJournalType$EnumInterface;
	export const salesJournalTypeDatatype: X3EnumDataType<keyof SalesJournalType$EnumInterface, unknown>;
	//# sourceMappingURL=sales-journal-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/sales-amount-type.d.ts
declare module '@sage/x3-master-data/lib/enums/sales-amount-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesAmountTypeEnum {
	    none = 1,
	    amountToEnter = 2,
	    netValueOfThePlan = 3
	}
	export interface SalesAmountType$EnumInterface {
	    none: 1;
	    amountToEnter: 2;
	    netValueOfThePlan: 3;
	}
	export type SalesAmountType = keyof SalesAmountType$EnumInterface;
	export const salesAmountTypeDatatype: X3EnumDataType<keyof SalesAmountType$EnumInterface, unknown>;
	//# sourceMappingURL=sales-amount-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/saft-document.d.ts
declare module '@sage/x3-master-data/lib/enums/saft-document' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SaftDocumentEnum {
	    invoice = 1,
	    simplifiedInvoice = 2,
	    debitNote = 3,
	    creditNote = 4,
	    fixedAssetsSale = 5,
	    fixedAssetsReturn = 6,
	    invoiceReceipt = 7,
	    proforma = 8,
	    consignmentInvoice = 9
	}
	export interface SaftDocument$EnumInterface {
	    invoice: 1;
	    simplifiedInvoice: 2;
	    debitNote: 3;
	    creditNote: 4;
	    fixedAssetsSale: 5;
	    fixedAssetsReturn: 6;
	    invoiceReceipt: 7;
	    proforma: 8;
	    consignmentInvoice: 9;
	}
	export type SaftDocument = keyof SaftDocument$EnumInterface;
	export const saftDocumentDatatype: X3EnumDataType<keyof SaftDocument$EnumInterface, unknown>;
	//# sourceMappingURL=saft-document.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/saft-document-type.d.ts
declare module '@sage/x3-master-data/lib/enums/saft-document-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SaftDocumentTypeEnum {
	    gtTransportNote = 1,
	    grPackingSlip = 2,
	    gaAssetsTransport = 3,
	    gcLoanPackingSlip = 4,
	    gdSupplierReturns = 5
	}
	export interface SaftDocumentType$EnumInterface {
	    gtTransportNote: 1;
	    grPackingSlip: 2;
	    gaAssetsTransport: 3;
	    gcLoanPackingSlip: 4;
	    gdSupplierReturns: 5;
	}
	export type SaftDocumentType = keyof SaftDocumentType$EnumInterface;
	export const saftDocumentTypeDatatype: X3EnumDataType<keyof SaftDocumentType$EnumInterface, unknown>;
	//# sourceMappingURL=saft-document-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/saft-audit-file-schema.d.ts
declare module '@sage/x3-master-data/lib/enums/saft-audit-file-schema' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SaftAuditFileSchemaEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2
	}
	export interface SaftAuditFileSchema$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	}
	export type SaftAuditFileSchema = keyof SaftAuditFileSchema$EnumInterface;
	export const saftAuditFileSchemaDatatype: X3EnumDataType<keyof SaftAuditFileSchema$EnumInterface, unknown>;
	//# sourceMappingURL=saft-audit-file-schema.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/saf-t-type.d.ts
declare module '@sage/x3-master-data/lib/enums/saf-t-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SafTTypeEnum {
	    none = 1,
	    safTPtIntegrated = 2,
	    safTPtInvoicing = 3,
	    safTPtAccounting = 4,
	    safTPtSelfBilling = 5,
	    safTPtCommunicationTa = 6,
	    safTPtSelfBillingTa = 7,
	    safTPtShippingDocumentsTa = 8
	}
	export interface SafTType$EnumInterface {
	    none: 1;
	    safTPtIntegrated: 2;
	    safTPtInvoicing: 3;
	    safTPtAccounting: 4;
	    safTPtSelfBilling: 5;
	    safTPtCommunicationTa: 6;
	    safTPtSelfBillingTa: 7;
	    safTPtShippingDocumentsTa: 8;
	}
	export type SafTType = keyof SafTType$EnumInterface;
	export const safTTypeDatatype: X3EnumDataType<keyof SafTType$EnumInterface, unknown>;
	//# sourceMappingURL=saf-t-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/saf-t-product-type.d.ts
declare module '@sage/x3-master-data/lib/enums/saf-t-product-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SafTProductTypeEnum {
	    none = 1,
	    product = 2,
	    service = 3,
	    other = 4
	}
	export interface SafTProductType$EnumInterface {
	    none: 1;
	    product: 2;
	    service: 3;
	    other: 4;
	}
	export type SafTProductType = keyof SafTProductType$EnumInterface;
	export const safTProductTypeDatatype: X3EnumDataType<keyof SafTProductType$EnumInterface, unknown>;
	//# sourceMappingURL=saf-t-product-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/rule-flow.d.ts
declare module '@sage/x3-master-data/lib/enums/rule-flow' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RuleFlowEnum {
	    receipt = 1,
	    shipment = 2
	}
	export interface RuleFlow$EnumInterface {
	    receipt: 1;
	    shipment: 2;
	}
	export type RuleFlow = keyof RuleFlow$EnumInterface;
	export const ruleFlowDatatype: X3EnumDataType<keyof RuleFlow$EnumInterface, unknown>;
	//# sourceMappingURL=rule-flow.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/routing-conditions.d.ts
declare module '@sage/x3-master-data/lib/enums/routing-conditions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RoutingConditionsEnum {
	    next = 1,
	    exit = 2,
	    startingWith = 3,
	    containing = 4,
	    endingWith = 5,
	    greaterThan = 6,
	    greaterThanOrEqualTo = 7,
	    lessThan = 8,
	    lessThanOrEqualTo = 9,
	    between = 10,
	    isTrue = 11,
	    isFalse = 12,
	    beforeThe = 13,
	    afterThe = 14,
	    other = 15
	}
	export interface RoutingConditions$EnumInterface {
	    next: 1;
	    exit: 2;
	    startingWith: 3;
	    containing: 4;
	    endingWith: 5;
	    greaterThan: 6;
	    greaterThanOrEqualTo: 7;
	    lessThan: 8;
	    lessThanOrEqualTo: 9;
	    between: 10;
	    isTrue: 11;
	    isFalse: 12;
	    beforeThe: 13;
	    afterThe: 14;
	    other: 15;
	}
	export type RoutingConditions = keyof RoutingConditions$EnumInterface;
	export const routingConditionsDatatype: X3EnumDataType<keyof RoutingConditions$EnumInterface, unknown>;
	//# sourceMappingURL=routing-conditions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/rounding-breakdown.d.ts
declare module '@sage/x3-master-data/lib/enums/rounding-breakdown' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RoundingBreakdownEnum {
	    product = 1,
	    lowLevelCode = 2
	}
	export interface RoundingBreakdown$EnumInterface {
	    product: 1;
	    lowLevelCode: 2;
	}
	export type RoundingBreakdown = keyof RoundingBreakdown$EnumInterface;
	export const roundingBreakdownDatatype: X3EnumDataType<keyof RoundingBreakdown$EnumInterface, unknown>;
	//# sourceMappingURL=rounding-breakdown.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/rounded-type.d.ts
declare module '@sage/x3-master-data/lib/enums/rounded-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RoundedTypeEnum {
	    roundUp = 1,
	    roundDown = 2,
	    roundToTheNearest = 3
	}
	export interface RoundedType$EnumInterface {
	    roundUp: 1;
	    roundDown: 2;
	    roundToTheNearest: 3;
	}
	export type RoundedType = keyof RoundedType$EnumInterface;
	export const roundedTypeDatatype: X3EnumDataType<keyof RoundedType$EnumInterface, unknown>;
	//# sourceMappingURL=rounded-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/rounded-lot.d.ts
declare module '@sage/x3-master-data/lib/enums/rounded-lot' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RoundedLotEnum {
	    none = 1,
	    roundUp = 2,
	    roundDown = 3,
	    oneLotMinimum = 4
	}
	export interface RoundedLot$EnumInterface {
	    none: 1;
	    roundUp: 2;
	    roundDown: 3;
	    oneLotMinimum: 4;
	}
	export type RoundedLot = keyof RoundedLot$EnumInterface;
	export const roundedLotDatatype: X3EnumDataType<keyof RoundedLot$EnumInterface, unknown>;
	//# sourceMappingURL=rounded-lot.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/revision-reason.d.ts
declare module '@sage/x3-master-data/lib/enums/revision-reason' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RevisionReasonEnum {
	    add = 1,
	    modify = 2,
	    exclude = 3,
	    reinstate = 4
	}
	export interface RevisionReason$EnumInterface {
	    add: 1;
	    modify: 2;
	    exclude: 3;
	    reinstate: 4;
	}
	export type RevisionReason = keyof RevisionReason$EnumInterface;
	export const revisionReasonDatatype: X3EnumDataType<keyof RevisionReason$EnumInterface, unknown>;
	//# sourceMappingURL=revision-reason.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/revision-parameter-menu.d.ts
declare module '@sage/x3-master-data/lib/enums/revision-parameter-menu' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RevisionParameterMenuEnum {
	    notManaged = 1,
	    managedOnDemand = 2,
	    managedAutomatically = 3
	}
	export interface RevisionParameterMenu$EnumInterface {
	    notManaged: 1;
	    managedOnDemand: 2;
	    managedAutomatically: 3;
	}
	export type RevisionParameterMenu = keyof RevisionParameterMenu$EnumInterface;
	export const revisionParameterMenuDatatype: X3EnumDataType<keyof RevisionParameterMenu$EnumInterface, unknown>;
	//# sourceMappingURL=revision-parameter-menu.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/review-type.d.ts
declare module '@sage/x3-master-data/lib/enums/review-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReviewTypeEnum {
	    major = 1,
	    minor = 2
	}
	export interface ReviewType$EnumInterface {
	    major: 1;
	    minor: 2;
	}
	export type ReviewType = keyof ReviewType$EnumInterface;
	export const reviewTypeDatatype: X3EnumDataType<keyof ReviewType$EnumInterface, unknown>;
	//# sourceMappingURL=review-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/resource-reservation-origin.d.ts
declare module '@sage/x3-master-data/lib/enums/resource-reservation-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ResourceReservationOriginEnum {
	    manualCreation = 1,
	    appointment = 2,
	    afterSalesServiceAction = 3
	}
	export interface ResourceReservationOrigin$EnumInterface {
	    manualCreation: 1;
	    appointment: 2;
	    afterSalesServiceAction: 3;
	}
	export type ResourceReservationOrigin = keyof ResourceReservationOrigin$EnumInterface;
	export const resourceReservationOriginDatatype: X3EnumDataType<keyof ResourceReservationOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=resource-reservation-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/resource-availability.d.ts
declare module '@sage/x3-master-data/lib/enums/resource-availability' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ResourceAvailabilityEnum {
	    available = 1,
	    proposal = 2,
	    unavailable = 3,
	    reserved = 4
	}
	export interface ResourceAvailability$EnumInterface {
	    available: 1;
	    proposal: 2;
	    unavailable: 3;
	    reserved: 4;
	}
	export type ResourceAvailability = keyof ResourceAvailability$EnumInterface;
	export const resourceAvailabilityDatatype: X3EnumDataType<keyof ResourceAvailability$EnumInterface, unknown>;
	//# sourceMappingURL=resource-availability.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/resolution-types.d.ts
declare module '@sage/x3-master-data/lib/enums/resolution-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ResolutionTypesEnum {
	    large = 1,
	    small = 2
	}
	export interface ResolutionTypes$EnumInterface {
	    large: 1;
	    small: 2;
	}
	export type ResolutionTypes = keyof ResolutionTypes$EnumInterface;
	export const resolutionTypesDatatype: X3EnumDataType<keyof ResolutionTypes$EnumInterface, unknown>;
	//# sourceMappingURL=resolution-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/requested-closing-type.d.ts
declare module '@sage/x3-master-data/lib/enums/requested-closing-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RequestedClosingTypeEnum {
	    noClosing = 1,
	    fyClosing = 2,
	    periodClosing = 3
	}
	export interface RequestedClosingType$EnumInterface {
	    noClosing: 1;
	    fyClosing: 2;
	    periodClosing: 3;
	}
	export type RequestedClosingType = keyof RequestedClosingType$EnumInterface;
	export const requestedClosingTypeDatatype: X3EnumDataType<keyof RequestedClosingType$EnumInterface, unknown>;
	//# sourceMappingURL=requested-closing-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/request-stats-grp.d.ts
declare module '@sage/x3-master-data/lib/enums/request-stats-grp' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RequestStatsGrpEnum {
	    serviceReqStatGroupNo1 = 1,
	    serviceReqStatGroupNo2 = 2,
	    serviceReqStatGroupNo3 = 3,
	    serviceReqStatGroupNo4 = 4,
	    serviceReqStatGroupNo5 = 5
	}
	export interface RequestStatsGrp$EnumInterface {
	    serviceReqStatGroupNo1: 1;
	    serviceReqStatGroupNo2: 2;
	    serviceReqStatGroupNo3: 3;
	    serviceReqStatGroupNo4: 4;
	    serviceReqStatGroupNo5: 5;
	}
	export type RequestStatsGrp = keyof RequestStatsGrp$EnumInterface;
	export const requestStatsGrpDatatype: X3EnumDataType<keyof RequestStatsGrp$EnumInterface, unknown>;
	//# sourceMappingURL=request-stats-grp.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/request-response.d.ts
declare module '@sage/x3-master-data/lib/enums/request-response' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RequestResponseEnum {
	    request = 1,
	    response = 2
	}
	export interface RequestResponse$EnumInterface {
	    request: 1;
	    response: 2;
	}
	export type RequestResponse = keyof RequestResponse$EnumInterface;
	export const requestResponseDatatype: X3EnumDataType<keyof RequestResponse$EnumInterface, unknown>;
	//# sourceMappingURL=request-response.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/request-origin.d.ts
declare module '@sage/x3-master-data/lib/enums/request-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RequestOriginEnum {
	    none = 1,
	    transfertFasImpactantPhy = 2,
	    detachementDepuisFasDePhy = 3,
	    rattachementDepuisFasDePhy = 4,
	    annulationTransfertFasImpactantPhy = 5,
	    annulationSortieFasImpactantPhy = 6,
	    sortieFasImpactantPhy = 7
	}
	export interface RequestOrigin$EnumInterface {
	    none: 1;
	    transfertFasImpactantPhy: 2;
	    detachementDepuisFasDePhy: 3;
	    rattachementDepuisFasDePhy: 4;
	    annulationTransfertFasImpactantPhy: 5;
	    annulationSortieFasImpactantPhy: 6;
	    sortieFasImpactantPhy: 7;
	}
	export type RequestOrigin = keyof RequestOrigin$EnumInterface;
	export const requestOriginDatatype: X3EnumDataType<keyof RequestOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=request-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/report-sort-assets.d.ts
declare module '@sage/x3-master-data/lib/enums/report-sort-assets' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReportSortAssetsEnum {
	    financialSite = 1,
	    accountingCode = 2,
	    coAAccount = 3,
	    ifrsAccount = 4,
	    group = 5,
	    anaDistributionKey = 6,
	    analyticalDimensionType1 = 7,
	    analyticalDimensionType2 = 8,
	    analyticalDimensionType3 = 9,
	    analyticalDimensionType4 = 10,
	    analyticalDimensionType5 = 11,
	    analyticalDimensionType6 = 12,
	    analyticalDimensionType7 = 13,
	    analyticalDimensionType8 = 14,
	    analyticalDimensionType9 = 15,
	    cgu = 16,
	    geographicSite = 17,
	    none = 18
	}
	export interface ReportSortAssets$EnumInterface {
	    financialSite: 1;
	    accountingCode: 2;
	    coAAccount: 3;
	    ifrsAccount: 4;
	    group: 5;
	    anaDistributionKey: 6;
	    analyticalDimensionType1: 7;
	    analyticalDimensionType2: 8;
	    analyticalDimensionType3: 9;
	    analyticalDimensionType4: 10;
	    analyticalDimensionType5: 11;
	    analyticalDimensionType6: 12;
	    analyticalDimensionType7: 13;
	    analyticalDimensionType8: 14;
	    analyticalDimensionType9: 15;
	    cgu: 16;
	    geographicSite: 17;
	    none: 18;
	}
	export type ReportSortAssets = keyof ReportSortAssets$EnumInterface;
	export const reportSortAssetsDatatype: X3EnumDataType<keyof ReportSortAssets$EnumInterface, unknown>;
	//# sourceMappingURL=report-sort-assets.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/reorder-quantity.d.ts
declare module '@sage/x3-master-data/lib/enums/reorder-quantity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReorderQuantityEnum {
	    netQuantity = 1,
	    minimumQuantityWithoutRounding = 2,
	    minimumQuantityWithRounding = 3
	}
	export interface ReorderQuantity$EnumInterface {
	    netQuantity: 1;
	    minimumQuantityWithoutRounding: 2;
	    minimumQuantityWithRounding: 3;
	}
	export type ReorderQuantity = keyof ReorderQuantity$EnumInterface;
	export const reorderQuantityDatatype: X3EnumDataType<keyof ReorderQuantity$EnumInterface, unknown>;
	//# sourceMappingURL=reorder-quantity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/renewal-history.d.ts
declare module '@sage/x3-master-data/lib/enums/renewal-history' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RenewalHistoryEnum {
	    withPreviousPeriod = 1,
	    withNewPeriod = 2
	}
	export interface RenewalHistory$EnumInterface {
	    withPreviousPeriod: 1;
	    withNewPeriod: 2;
	}
	export type RenewalHistory = keyof RenewalHistory$EnumInterface;
	export const renewalHistoryDatatype: X3EnumDataType<keyof RenewalHistory$EnumInterface, unknown>;
	//# sourceMappingURL=renewal-history.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/reminder-type.d.ts
declare module '@sage/x3-master-data/lib/enums/reminder-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReminderTypeEnum {
	    noReminder = 1,
	    byInvoice = 2,
	    global = 3,
	    globalByLevel = 4,
	    globalByDate = 5
	}
	export interface ReminderType$EnumInterface {
	    noReminder: 1;
	    byInvoice: 2;
	    global: 3;
	    globalByLevel: 4;
	    globalByDate: 5;
	}
	export type ReminderType = keyof ReminderType$EnumInterface;
	export const reminderTypeDatatype: X3EnumDataType<keyof ReminderType$EnumInterface, unknown>;
	//# sourceMappingURL=reminder-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/reminder-frequency-types.d.ts
declare module '@sage/x3-master-data/lib/enums/reminder-frequency-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReminderFrequencyTypesEnum {
	    threshold = 1,
	    interval = 2
	}
	export interface ReminderFrequencyTypes$EnumInterface {
	    threshold: 1;
	    interval: 2;
	}
	export type ReminderFrequencyTypes = keyof ReminderFrequencyTypes$EnumInterface;
	export const reminderFrequencyTypesDatatype: X3EnumDataType<keyof ReminderFrequencyTypes$EnumInterface, unknown>;
	//# sourceMappingURL=reminder-frequency-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/release-status.d.ts
declare module '@sage/x3-master-data/lib/enums/release-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReleaseStatusEnum {
	    pending = 1,
	    abandoned = 2,
	    released = 3
	}
	export interface ReleaseStatus$EnumInterface {
	    pending: 1;
	    abandoned: 2;
	    released: 3;
	}
	export type ReleaseStatus = keyof ReleaseStatus$EnumInterface;
	export const releaseStatusDatatype: X3EnumDataType<keyof ReleaseStatus$EnumInterface, unknown>;
	//# sourceMappingURL=release-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/relation-type.d.ts
declare module '@sage/x3-master-data/lib/enums/relation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RelationTypeEnum {
	    contact = 1,
	    lead = 2
	}
	export interface RelationType$EnumInterface {
	    contact: 1;
	    lead: 2;
	}
	export type RelationType = keyof RelationType$EnumInterface;
	export const relationTypeDatatype: X3EnumDataType<keyof RelationType$EnumInterface, unknown>;
	//# sourceMappingURL=relation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/related-company-settings.d.ts
declare module '@sage/x3-master-data/lib/enums/related-company-settings' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RelatedCompanySettingsEnum {
	    notRelated = 1,
	    votingRightsMoreThanOrEqual10Percent = 2,
	    votingRightsLessThan10Percent = 3
	}
	export interface RelatedCompanySettings$EnumInterface {
	    notRelated: 1;
	    votingRightsMoreThanOrEqual10Percent: 2;
	    votingRightsLessThan10Percent: 3;
	}
	export type RelatedCompanySettings = keyof RelatedCompanySettings$EnumInterface;
	export const relatedCompanySettingsDatatype: X3EnumDataType<keyof RelatedCompanySettings$EnumInterface, unknown>;
	//# sourceMappingURL=related-company-settings.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/region-taxes-application.d.ts
declare module '@sage/x3-master-data/lib/enums/region-taxes-application' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RegionTaxesApplicationEnum {
	    receipt = 1,
	    issue = 2,
	    always = 3
	}
	export interface RegionTaxesApplication$EnumInterface {
	    receipt: 1;
	    issue: 2;
	    always: 3;
	}
	export type RegionTaxesApplication = keyof RegionTaxesApplication$EnumInterface;
	export const regionTaxesApplicationDatatype: X3EnumDataType<keyof RegionTaxesApplication$EnumInterface, unknown>;
	//# sourceMappingURL=region-taxes-application.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/reference.d.ts
declare module '@sage/x3-master-data/lib/enums/reference' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReferenceEnum {
	    expiration = 1,
	    ubd = 2,
	    recontrol = 3
	}
	export interface Reference$EnumInterface {
	    expiration: 1;
	    ubd: 2;
	    recontrol: 3;
	}
	export type Reference = keyof Reference$EnumInterface;
	export const referenceDatatype: X3EnumDataType<keyof Reference$EnumInterface, unknown>;
	//# sourceMappingURL=reference.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/reference-date-type.d.ts
declare module '@sage/x3-master-data/lib/enums/reference-date-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReferenceDateTypeEnum {
	    depreciationStartDate = 1,
	    assetPurchaseDate = 2,
	    referenceDateForTheCalculationOfTheValue = 3,
	    noReferenceDate = 4
	}
	export interface ReferenceDateType$EnumInterface {
	    depreciationStartDate: 1;
	    assetPurchaseDate: 2;
	    referenceDateForTheCalculationOfTheValue: 3;
	    noReferenceDate: 4;
	}
	export type ReferenceDateType = keyof ReferenceDateType$EnumInterface;
	export const referenceDateTypeDatatype: X3EnumDataType<keyof ReferenceDateType$EnumInterface, unknown>;
	//# sourceMappingURL=reference-date-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/reevaluation-method.d.ts
declare module '@sage/x3-master-data/lib/enums/reevaluation-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReevaluationMethodEnum {
	    coefficient = 1,
	    index = 2,
	    marketValue = 3
	}
	export interface ReevaluationMethod$EnumInterface {
	    coefficient: 1;
	    index: 2;
	    marketValue: 3;
	}
	export type ReevaluationMethod = keyof ReevaluationMethod$EnumInterface;
	export const reevaluationMethodDatatype: X3EnumDataType<keyof ReevaluationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=reevaluation-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/reevaluation-effective-date.d.ts
declare module '@sage/x3-master-data/lib/enums/reevaluation-effective-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReevaluationEffectiveDateEnum {
	    fyStart = 1,
	    periodStart = 2,
	    fyEnd = 3
	}
	export interface ReevaluationEffectiveDate$EnumInterface {
	    fyStart: 1;
	    periodStart: 2;
	    fyEnd: 3;
	}
	export type ReevaluationEffectiveDate = keyof ReevaluationEffectiveDate$EnumInterface;
	export const reevaluationEffectiveDateDatatype: X3EnumDataType<keyof ReevaluationEffectiveDate$EnumInterface, unknown>;
	//# sourceMappingURL=reevaluation-effective-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/recurring-invoice-status.d.ts
declare module '@sage/x3-master-data/lib/enums/recurring-invoice-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecurringInvoiceStatusEnum {
	    pending = 1,
	    inProcess = 2,
	    completed = 3,
	    canceled = 4
	}
	export interface RecurringInvoiceStatus$EnumInterface {
	    pending: 1;
	    inProcess: 2;
	    completed: 3;
	    canceled: 4;
	}
	export type RecurringInvoiceStatus = keyof RecurringInvoiceStatus$EnumInterface;
	export const recurringInvoiceStatusDatatype: X3EnumDataType<keyof RecurringInvoiceStatus$EnumInterface, unknown>;
	//# sourceMappingURL=recurring-invoice-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/recurrence.d.ts
declare module '@sage/x3-master-data/lib/enums/recurrence' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecurrenceEnum {
	    customerBpInvoice = 1,
	    supplierBpInvoice = 2
	}
	export interface Recurrence$EnumInterface {
	    customerBpInvoice: 1;
	    supplierBpInvoice: 2;
	}
	export type Recurrence = keyof Recurrence$EnumInterface;
	export const recurrenceDatatype: X3EnumDataType<keyof Recurrence$EnumInterface, unknown>;
	//# sourceMappingURL=recurrence.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/recurrence-pattern.d.ts
declare module '@sage/x3-master-data/lib/enums/recurrence-pattern' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecurrencePatternEnum {
	    daily = 1,
	    weekly = 2,
	    monthly = 3
	}
	export interface RecurrencePattern$EnumInterface {
	    daily: 1;
	    weekly: 2;
	    monthly: 3;
	}
	export type RecurrencePattern = keyof RecurrencePattern$EnumInterface;
	export const recurrencePatternDatatype: X3EnumDataType<keyof RecurrencePattern$EnumInterface, unknown>;
	//# sourceMappingURL=recurrence-pattern.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/recov-rule-target-comp-plans.d.ts
declare module '@sage/x3-master-data/lib/enums/recov-rule-target-comp-plans' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecovRuleTargetCompPlansEnum {
	    identicalValuesToTemplatePlan = 1,
	    valuesTakenAsIdentical = 2,
	    grossValueSalePrice = 3,
	    grossValueTemplatePlanNetValue = 4
	}
	export interface RecovRuleTargetCompPlans$EnumInterface {
	    identicalValuesToTemplatePlan: 1;
	    valuesTakenAsIdentical: 2;
	    grossValueSalePrice: 3;
	    grossValueTemplatePlanNetValue: 4;
	}
	export type RecovRuleTargetCompPlans = keyof RecovRuleTargetCompPlans$EnumInterface;
	export const recovRuleTargetCompPlansDatatype: X3EnumDataType<keyof RecovRuleTargetCompPlans$EnumInterface, unknown>;
	//# sourceMappingURL=recov-rule-target-comp-plans.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/record-type.d.ts
declare module '@sage/x3-master-data/lib/enums/record-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecordTypeEnum {
	    header = 1,
	    detail = 2,
	    total = 3,
	    subtotal = 4,
	    detail2 = 5
	}
	export interface RecordType$EnumInterface {
	    header: 1;
	    detail: 2;
	    total: 3;
	    subtotal: 4;
	    detail2: 5;
	}
	export type RecordType = keyof RecordType$EnumInterface;
	export const recordTypeDatatype: X3EnumDataType<keyof RecordType$EnumInterface, unknown>;
	//# sourceMappingURL=record-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/record-type-2029.d.ts
declare module '@sage/x3-master-data/lib/enums/record-type-2029' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecordType2029Enum {
	    normal = 1,
	    manualDocumentRecovery = 2,
	    backupDocumentRecovery = 3,
	    externalDocument = 4
	}
	export interface RecordType2029$EnumInterface {
	    normal: 1;
	    manualDocumentRecovery: 2;
	    backupDocumentRecovery: 3;
	    externalDocument: 4;
	}
	export type RecordType2029 = keyof RecordType2029$EnumInterface;
	export const recordType2029Datatype: X3EnumDataType<keyof RecordType2029$EnumInterface, unknown>;
	//# sourceMappingURL=record-type-2029.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/record-status.d.ts
declare module '@sage/x3-master-data/lib/enums/record-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecordStatusEnum {
	    pending = 1,
	    submitted = 2
	}
	export interface RecordStatus$EnumInterface {
	    pending: 1;
	    submitted: 2;
	}
	export type RecordStatus = keyof RecordStatus$EnumInterface;
	export const recordStatusDatatype: X3EnumDataType<keyof RecordStatus$EnumInterface, unknown>;
	//# sourceMappingURL=record-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/recoding-status.d.ts
declare module '@sage/x3-master-data/lib/enums/recoding-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecodingStatusEnum {
	    toBeProcessed = 1,
	    toBeProcessedIntraGroupSale = 2,
	    processed = 3,
	    processedIntraGroupSale = 4
	}
	export interface RecodingStatus$EnumInterface {
	    toBeProcessed: 1;
	    toBeProcessedIntraGroupSale: 2;
	    processed: 3;
	    processedIntraGroupSale: 4;
	}
	export type RecodingStatus = keyof RecodingStatus$EnumInterface;
	export const recodingStatusDatatype: X3EnumDataType<keyof RecodingStatus$EnumInterface, unknown>;
	//# sourceMappingURL=recoding-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/recipient-type-495.d.ts
declare module '@sage/x3-master-data/lib/enums/recipient-type-495' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecipientType495Enum {
	    othersSii = 1,
	    batuzVizcaya = 2,
	    tbaiGuipuzcoa = 3,
	    tbaiAlava = 4,
	    tbaiNavarra = 5,
	    verifactu = 6
	}
	export interface RecipientType495$EnumInterface {
	    othersSii: 1;
	    batuzVizcaya: 2;
	    tbaiGuipuzcoa: 3;
	    tbaiAlava: 4;
	    tbaiNavarra: 5;
	    verifactu: 6;
	}
	export type RecipientType495 = keyof RecipientType495$EnumInterface;
	export const recipientType495Datatype: X3EnumDataType<keyof RecipientType495$EnumInterface, unknown>;
	//# sourceMappingURL=recipient-type-495.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/receiving-authorized-status.d.ts
declare module '@sage/x3-master-data/lib/enums/receiving-authorized-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReceivingAuthorizedStatusEnum {
	    statusA = 1,
	    statusQ = 2,
	    statusR = 3,
	    statusAQ = 4,
	    statusAR = 5,
	    statusQR = 6,
	    statusAQR = 7
	}
	export interface ReceivingAuthorizedStatus$EnumInterface {
	    statusA: 1;
	    statusQ: 2;
	    statusR: 3;
	    statusAQ: 4;
	    statusAR: 5;
	    statusQR: 6;
	    statusAQR: 7;
	}
	export type ReceivingAuthorizedStatus = keyof ReceivingAuthorizedStatus$EnumInterface;
	export const receivingAuthorizedStatusDatatype: X3EnumDataType<keyof ReceivingAuthorizedStatus$EnumInterface, unknown>;
	//# sourceMappingURL=receiving-authorized-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/reasons.d.ts
declare module '@sage/x3-master-data/lib/enums/reasons' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReasonsEnum {
	    reason1 = 1,
	    reason2 = 2,
	    reason3 = 3
	}
	export interface Reasons$EnumInterface {
	    reason1: 1;
	    reason2: 2;
	    reason3: 3;
	}
	export type Reasons = keyof Reasons$EnumInterface;
	export const reasonsDatatype: X3EnumDataType<keyof Reasons$EnumInterface, unknown>;
	//# sourceMappingURL=reasons.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/reason-for-rejection.d.ts
declare module '@sage/x3-master-data/lib/enums/reason-for-rejection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReasonForRejectionEnum {
	    select = 1,
	    notEnoughEvidence = 2,
	    notCostEffective = 3,
	    changeIsOutOfScopeBudget = 4,
	    requestConflictsWithOtherScheduledChange = 5,
	    theImplementationDateIsInAnUnavailablePeriod = 6,
	    other = 7,
	    notSelected = 8
	}
	export interface ReasonForRejection$EnumInterface {
	    select: 1;
	    notEnoughEvidence: 2;
	    notCostEffective: 3;
	    changeIsOutOfScopeBudget: 4;
	    requestConflictsWithOtherScheduledChange: 5;
	    theImplementationDateIsInAnUnavailablePeriod: 6;
	    other: 7;
	    notSelected: 8;
	}
	export type ReasonForRejection = keyof ReasonForRejection$EnumInterface;
	export const reasonForRejectionDatatype: X3EnumDataType<keyof ReasonForRejection$EnumInterface, unknown>;
	//# sourceMappingURL=reason-for-rejection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/re-evaluation-method.d.ts
declare module '@sage/x3-master-data/lib/enums/re-evaluation-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReEvaluationMethodEnum {
	    postReEvaluation = 1,
	    preReEvaluation = 2
	}
	export interface ReEvaluationMethod$EnumInterface {
	    postReEvaluation: 1;
	    preReEvaluation: 2;
	}
	export type ReEvaluationMethod = keyof ReEvaluationMethod$EnumInterface;
	export const reEvaluationMethodDatatype: X3EnumDataType<keyof ReEvaluationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=re-evaluation-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/re-evaluation-aids.d.ts
declare module '@sage/x3-master-data/lib/enums/re-evaluation-aids' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReEvaluationAidsEnum {
	    indexDevelopment = 1,
	    mathematicalFormula = 2
	}
	export interface ReEvaluationAids$EnumInterface {
	    indexDevelopment: 1;
	    mathematicalFormula: 2;
	}
	export type ReEvaluationAids = keyof ReEvaluationAids$EnumInterface;
	export const reEvaluationAidsDatatype: X3EnumDataType<keyof ReEvaluationAids$EnumInterface, unknown>;
	//# sourceMappingURL=re-evaluation-aids.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/rate-entry-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/rate-entry-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RateEntryModeEnum {
	    multiplier = 1,
	    divisor = 2,
	    both = 3
	}
	export interface RateEntryMode$EnumInterface {
	    multiplier: 1;
	    divisor: 2;
	    both: 3;
	}
	export type RateEntryMode = keyof RateEntryMode$EnumInterface;
	export const rateEntryModeDatatype: X3EnumDataType<keyof RateEntryMode$EnumInterface, unknown>;
	//# sourceMappingURL=rate-entry-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/rate-amount.d.ts
declare module '@sage/x3-master-data/lib/enums/rate-amount' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RateAmountEnum {
	    percent = 1,
	    amount = 2
	}
	export interface RateAmount$EnumInterface {
	    percent: 1;
	    amount: 2;
	}
	export type RateAmount = keyof RateAmount$EnumInterface;
	export const rateAmountDatatype: X3EnumDataType<keyof RateAmount$EnumInterface, unknown>;
	//# sourceMappingURL=rate-amount.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/quarter.d.ts
declare module '@sage/x3-master-data/lib/enums/quarter' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QuarterEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4
	}
	export interface Quarter$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	}
	export type Quarter = keyof Quarter$EnumInterface;
	export const quarterDatatype: X3EnumDataType<keyof Quarter$EnumInterface, unknown>;
	//# sourceMappingURL=quarter.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/purchase-invoice-category.d.ts
declare module '@sage/x3-master-data/lib/enums/purchase-invoice-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseInvoiceCategoryEnum {
	    invoice = 1,
	    additionalInvoice = 2,
	    creditMemo = 3,
	    creditMemoReturn = 4
	}
	export interface PurchaseInvoiceCategory$EnumInterface {
	    invoice: 1;
	    additionalInvoice: 2;
	    creditMemo: 3;
	    creditMemoReturn: 4;
	}
	export type PurchaseInvoiceCategory = keyof PurchaseInvoiceCategory$EnumInterface;
	export const purchaseInvoiceCategoryDatatype: X3EnumDataType<keyof PurchaseInvoiceCategory$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-invoice-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/purchase-in-service-date-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/purchase-in-service-date-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseInServiceDateRuleEnum {
	    saleEffectiveDate = 1,
	    renewalDateSourceCompany = 2
	}
	export interface PurchaseInServiceDateRule$EnumInterface {
	    saleEffectiveDate: 1;
	    renewalDateSourceCompany: 2;
	}
	export type PurchaseInServiceDateRule = keyof PurchaseInServiceDateRule$EnumInterface;
	export const purchaseInServiceDateRuleDatatype: X3EnumDataType<keyof PurchaseInServiceDateRule$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-in-service-date-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/provision-type.d.ts
declare module '@sage/x3-master-data/lib/enums/provision-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProvisionTypeEnum {
	    tax = 1,
	    account = 2
	}
	export interface ProvisionType$EnumInterface {
	    tax: 1;
	    account: 2;
	}
	export type ProvisionType = keyof ProvisionType$EnumInterface;
	export const provisionTypeDatatype: X3EnumDataType<keyof ProvisionType$EnumInterface, unknown>;
	//# sourceMappingURL=provision-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/protocol-type.d.ts
declare module '@sage/x3-master-data/lib/enums/protocol-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProtocolTypeEnum {
	    emails = 1,
	    directories = 2
	}
	export interface ProtocolType$EnumInterface {
	    emails: 1;
	    directories: 2;
	}
	export type ProtocolType = keyof ProtocolType$EnumInterface;
	export const protocolTypeDatatype: X3EnumDataType<keyof ProtocolType$EnumInterface, unknown>;
	//# sourceMappingURL=protocol-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/prospect-customer.d.ts
declare module '@sage/x3-master-data/lib/enums/prospect-customer' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProspectCustomerEnum {
	    prospect = 1,
	    customer = 2
	}
	export interface ProspectCustomer$EnumInterface {
	    prospect: 1;
	    customer: 2;
	}
	export type ProspectCustomer = keyof ProspectCustomer$EnumInterface;
	export const prospectCustomerDatatype: X3EnumDataType<keyof ProspectCustomer$EnumInterface, unknown>;
	//# sourceMappingURL=prospect-customer.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/prospect-customer-3043.d.ts
declare module '@sage/x3-master-data/lib/enums/prospect-customer-3043' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProspectCustomer3043Enum {
	    prospect = 1,
	    customer = 2
	}
	export interface ProspectCustomer3043$EnumInterface {
	    prospect: 1;
	    customer: 2;
	}
	export type ProspectCustomer3043 = keyof ProspectCustomer3043$EnumInterface;
	export const prospectCustomer3043Datatype: X3EnumDataType<keyof ProspectCustomer3043$EnumInterface, unknown>;
	//# sourceMappingURL=prospect-customer-3043.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/proposal-order.d.ts
declare module '@sage/x3-master-data/lib/enums/proposal-order' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProposalOrderEnum {
	    businessPartner = 1,
	    companyName = 2,
	    transaction = 3,
	    openItem = 4
	}
	export interface ProposalOrder$EnumInterface {
	    businessPartner: 1;
	    companyName: 2;
	    transaction: 3;
	    openItem: 4;
	}
	export type ProposalOrder = keyof ProposalOrder$EnumInterface;
	export const proposalOrderDatatype: X3EnumDataType<keyof ProposalOrder$EnumInterface, unknown>;
	//# sourceMappingURL=proposal-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/property-types.d.ts
declare module '@sage/x3-master-data/lib/enums/property-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PropertyTypesEnum {
	    chemical = 1,
	    paint = 2,
	    food = 3,
	    coatings = 4,
	    manualEntry = 5,
	    nutrients = 6,
	    beverage = 7,
	    other = 8
	}
	export interface PropertyTypes$EnumInterface {
	    chemical: 1;
	    paint: 2;
	    food: 3;
	    coatings: 4;
	    manualEntry: 5;
	    nutrients: 6;
	    beverage: 7;
	    other: 8;
	}
	export type PropertyTypes = keyof PropertyTypes$EnumInterface;
	export const propertyTypesDatatype: X3EnumDataType<keyof PropertyTypes$EnumInterface, unknown>;
	//# sourceMappingURL=property-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/project-stages.d.ts
declare module '@sage/x3-master-data/lib/enums/project-stages' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectStagesEnum {
	    noAssociatedAction = 1,
	    firstStageOfSalesCycle = 2,
	    sendingAQuote = 3,
	    negotiation = 4,
	    projectGained = 5,
	    projectLost = 6,
	    projectAbandoned = 7
	}
	export interface ProjectStages$EnumInterface {
	    noAssociatedAction: 1;
	    firstStageOfSalesCycle: 2;
	    sendingAQuote: 3;
	    negotiation: 4;
	    projectGained: 5;
	    projectLost: 6;
	    projectAbandoned: 7;
	}
	export type ProjectStages = keyof ProjectStages$EnumInterface;
	export const projectStagesDatatype: X3EnumDataType<keyof ProjectStages$EnumInterface, unknown>;
	//# sourceMappingURL=project-stages.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/project-origins.d.ts
declare module '@sage/x3-master-data/lib/enums/project-origins' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectOriginsEnum {
	    manualCreation = 1,
	    massMail = 2,
	    callCampaign = 3,
	    tradeShow = 4,
	    mediaCampaign = 5,
	    serviceRequest = 6,
	    marketingCampaign = 7
	}
	export interface ProjectOrigins$EnumInterface {
	    manualCreation: 1;
	    massMail: 2;
	    callCampaign: 3;
	    tradeShow: 4;
	    mediaCampaign: 5;
	    serviceRequest: 6;
	    marketingCampaign: 7;
	}
	export type ProjectOrigins = keyof ProjectOrigins$EnumInterface;
	export const projectOriginsDatatype: X3EnumDataType<keyof ProjectOrigins$EnumInterface, unknown>;
	//# sourceMappingURL=project-origins.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/project-allocation-type.d.ts
declare module '@sage/x3-master-data/lib/enums/project-allocation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectAllocationTypeEnum {
	    crm = 1,
	    project = 2,
	    mixedProject = 3,
	    budget = 4,
	    laborTask = 5,
	    materialTask = 6,
	    mixedTask = 7,
	    miscellaneous = 8
	}
	export interface ProjectAllocationType$EnumInterface {
	    crm: 1;
	    project: 2;
	    mixedProject: 3;
	    budget: 4;
	    laborTask: 5;
	    materialTask: 6;
	    mixedTask: 7;
	    miscellaneous: 8;
	}
	export type ProjectAllocationType = keyof ProjectAllocationType$EnumInterface;
	export const projectAllocationTypeDatatype: X3EnumDataType<keyof ProjectAllocationType$EnumInterface, unknown>;
	//# sourceMappingURL=project-allocation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/product-version-impact.d.ts
declare module '@sage/x3-master-data/lib/enums/product-version-impact' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductVersionImpactEnum {
	    select = 1,
	    major = 2,
	    minor = 3,
	    unknown = 4
	}
	export interface ProductVersionImpact$EnumInterface {
	    select: 1;
	    major: 2;
	    minor: 3;
	    unknown: 4;
	}
	export type ProductVersionImpact = keyof ProductVersionImpact$EnumInterface;
	export const productVersionImpactDatatype: X3EnumDataType<keyof ProductVersionImpact$EnumInterface, unknown>;
	//# sourceMappingURL=product-version-impact.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/product-type.d.ts
declare module '@sage/x3-master-data/lib/enums/product-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductTypeEnum {
	    goods = 1,
	    rawMaterialsSubsidiariesAndConsumables = 2,
	    finishedAndIntermediateGoods = 3,
	    byProductsWasteAndScrap = 4,
	    productsAndWorksInProgress = 5,
	    notApplicable = 6
	}
	export interface ProductType$EnumInterface {
	    goods: 1;
	    rawMaterialsSubsidiariesAndConsumables: 2;
	    finishedAndIntermediateGoods: 3;
	    byProductsWasteAndScrap: 4;
	    productsAndWorksInProgress: 5;
	    notApplicable: 6;
	}
	export type ProductType = keyof ProductType$EnumInterface;
	export const productTypeDatatype: X3EnumDataType<keyof ProductType$EnumInterface, unknown>;
	//# sourceMappingURL=product-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/product-status.d.ts
declare module '@sage/x3-master-data/lib/enums/product-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductStatusEnum {
	    active = 1,
	    inDevelopment = 2,
	    onShortage = 3,
	    notRenewed = 4,
	    obsolete = 5,
	    notUsable = 6
	}
	export interface ProductStatus$EnumInterface {
	    active: 1;
	    inDevelopment: 2;
	    onShortage: 3;
	    notRenewed: 4;
	    obsolete: 5;
	    notUsable: 6;
	}
	export type ProductStatus = keyof ProductStatus$EnumInterface;
	export const productStatusDatatype: X3EnumDataType<keyof ProductStatus$EnumInterface, unknown>;
	//# sourceMappingURL=product-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/product-statistical-groups-enum.d.ts
declare module '@sage/x3-master-data/lib/enums/product-statistical-groups-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductStatisticalGroupsEnumEnum {
	    group1 = 1,
	    group2 = 2,
	    group3 = 3,
	    group4 = 4,
	    group5 = 5
	}
	export interface ProductStatisticalGroupsEnum$EnumInterface {
	    group1: 1;
	    group2: 2;
	    group3: 3;
	    group4: 4;
	    group5: 5;
	}
	export type ProductStatisticalGroupsEnum = keyof ProductStatisticalGroupsEnum$EnumInterface;
	export const productStatisticalGroupsEnumDatatype: X3EnumDataType<keyof ProductStatisticalGroupsEnum$EnumInterface, unknown>;
	//# sourceMappingURL=product-statistical-groups-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/product-search-criteria.d.ts
declare module '@sage/x3-master-data/lib/enums/product-search-criteria' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductSearchCriteriaEnum {
	    none = 1,
	    supplierUpcCode = 2,
	    supplierProductCode = 3,
	    x3UpcCode = 4,
	    x3ProductDescription = 5
	}
	export interface ProductSearchCriteria$EnumInterface {
	    none: 1;
	    supplierUpcCode: 2;
	    supplierProductCode: 3;
	    x3UpcCode: 4;
	    x3ProductDescription: 5;
	}
	export type ProductSearchCriteria = keyof ProductSearchCriteria$EnumInterface;
	export const productSearchCriteriaDatatype: X3EnumDataType<keyof ProductSearchCriteria$EnumInterface, unknown>;
	//# sourceMappingURL=product-search-criteria.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/product-design-status.d.ts
declare module '@sage/x3-master-data/lib/enums/product-design-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductDesignStatusEnum {
	    inDevelopment = 1,
	    developmentCompleted = 2,
	    submittedForApproval = 3,
	    pilot = 4,
	    production = 5,
	    suspended = 6,
	    obsolete = 7
	}
	export interface ProductDesignStatus$EnumInterface {
	    inDevelopment: 1;
	    developmentCompleted: 2;
	    submittedForApproval: 3;
	    pilot: 4;
	    production: 5;
	    suspended: 6;
	    obsolete: 7;
	}
	export type ProductDesignStatus = keyof ProductDesignStatus$EnumInterface;
	export const productDesignStatusDatatype: X3EnumDataType<keyof ProductDesignStatus$EnumInterface, unknown>;
	//# sourceMappingURL=product-design-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/product-creation-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/product-creation-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductCreationModeEnum {
	    direct = 1,
	    withValidation = 2
	}
	export interface ProductCreationMode$EnumInterface {
	    direct: 1;
	    withValidation: 2;
	}
	export type ProductCreationMode = keyof ProductCreationMode$EnumInterface;
	export const productCreationModeDatatype: X3EnumDataType<keyof ProductCreationMode$EnumInterface, unknown>;
	//# sourceMappingURL=product-creation-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/product-category-type.d.ts
declare module '@sage/x3-master-data/lib/enums/product-category-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductCategoryTypeEnum {
	    bought = 1,
	    manufactured = 2,
	    purchaseManufacture = 3,
	    manufacturePurchase = 4,
	    subcontractedProduct = 5,
	    subcontractedService = 6,
	    phantom = 7,
	    generic = 8,
	    tool = 9
	}
	export interface ProductCategoryType$EnumInterface {
	    bought: 1;
	    manufactured: 2;
	    purchaseManufacture: 3;
	    manufacturePurchase: 4;
	    subcontractedProduct: 5;
	    subcontractedService: 6;
	    phantom: 7;
	    generic: 8;
	    tool: 9;
	}
	export type ProductCategoryType = keyof ProductCategoryType$EnumInterface;
	export const productCategoryTypeDatatype: X3EnumDataType<keyof ProductCategoryType$EnumInterface, unknown>;
	//# sourceMappingURL=product-category-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/product-abc-class.d.ts
declare module '@sage/x3-master-data/lib/enums/product-abc-class' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductAbcClassEnum {
	    classA = 1,
	    classB = 2,
	    classC = 3,
	    classD = 4
	}
	export interface ProductAbcClass$EnumInterface {
	    classA: 1;
	    classB: 2;
	    classC: 3;
	    classD: 4;
	}
	export type ProductAbcClass = keyof ProductAbcClass$EnumInterface;
	export const productAbcClassDatatype: X3EnumDataType<keyof ProductAbcClass$EnumInterface, unknown>;
	//# sourceMappingURL=product-abc-class.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/processing.d.ts
declare module '@sage/x3-master-data/lib/enums/processing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessingEnum {
	    resetToZero = 1,
	    constant = 2,
	    factor = 3,
	    formula = 4
	}
	export interface Processing$EnumInterface {
	    resetToZero: 1;
	    constant: 2;
	    factor: 3;
	    formula: 4;
	}
	export type Processing = keyof Processing$EnumInterface;
	export const processingDatatype: X3EnumDataType<keyof Processing$EnumInterface, unknown>;
	//# sourceMappingURL=processing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/processing-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/processing-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessingModeEnum {
	    modifiable = 1,
	    notModifiable = 2,
	    inactive = 3
	}
	export interface ProcessingMode$EnumInterface {
	    modifiable: 1;
	    notModifiable: 2;
	    inactive: 3;
	}
	export type ProcessingMode = keyof ProcessingMode$EnumInterface;
	export const processingModeDatatype: X3EnumDataType<keyof ProcessingMode$EnumInterface, unknown>;
	//# sourceMappingURL=processing-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/processing-mode-288.d.ts
declare module '@sage/x3-master-data/lib/enums/processing-mode-288' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessingMode288Enum {
	    direct = 1,
	    deferred = 2
	}
	export interface ProcessingMode288$EnumInterface {
	    direct: 1;
	    deferred: 2;
	}
	export type ProcessingMode288 = keyof ProcessingMode288$EnumInterface;
	export const processingMode288Datatype: X3EnumDataType<keyof ProcessingMode288$EnumInterface, unknown>;
	//# sourceMappingURL=processing-mode-288.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/processed-product.d.ts
declare module '@sage/x3-master-data/lib/enums/processed-product' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessedProductEnum {
	    unique = 1,
	    all = 2,
	    selection = 3
	}
	export interface ProcessedProduct$EnumInterface {
	    unique: 1;
	    all: 2;
	    selection: 3;
	}
	export type ProcessedProduct = keyof ProcessedProduct$EnumInterface;
	export const processedProductDatatype: X3EnumDataType<keyof ProcessedProduct$EnumInterface, unknown>;
	//# sourceMappingURL=processed-product.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/process-type.d.ts
declare module '@sage/x3-master-data/lib/enums/process-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessTypeEnum {
	    integration = 1,
	    validation = 2,
	    import = 3,
	    restoration = 4
	}
	export interface ProcessType$EnumInterface {
	    integration: 1;
	    validation: 2;
	    import: 3;
	    restoration: 4;
	}
	export type ProcessType = keyof ProcessType$EnumInterface;
	export const processTypeDatatype: X3EnumDataType<keyof ProcessType$EnumInterface, unknown>;
	//# sourceMappingURL=process-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/priority-3735.d.ts
declare module '@sage/x3-master-data/lib/enums/priority-3735' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Priority3735Enum {
	    oldestDateFirst = 1,
	    earliestDateFirst = 2
	}
	export interface Priority3735$EnumInterface {
	    oldestDateFirst: 1;
	    earliestDateFirst: 2;
	}
	export type Priority3735 = keyof Priority3735$EnumInterface;
	export const priority3735Datatype: X3EnumDataType<keyof Priority3735$EnumInterface, unknown>;
	//# sourceMappingURL=priority-3735.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/print-code.d.ts
declare module '@sage/x3-master-data/lib/enums/print-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrintCodeEnum {
	    print = 1,
	    reprint = 2
	}
	export interface PrintCode$EnumInterface {
	    print: 1;
	    reprint: 2;
	}
	export type PrintCode = keyof PrintCode$EnumInterface;
	export const printCodeDatatype: X3EnumDataType<keyof PrintCode$EnumInterface, unknown>;
	//# sourceMappingURL=print-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/price.d.ts
declare module '@sage/x3-master-data/lib/enums/price' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PriceEnum {
	    no = 1,
	    value = 2,
	    valueForN = 3,
	    factor = 4,
	    calculation = 5
	}
	export interface Price$EnumInterface {
	    no: 1;
	    value: 2;
	    valueForN: 3;
	    factor: 4;
	    calculation: 5;
	}
	export type Price = keyof Price$EnumInterface;
	export const priceDatatype: X3EnumDataType<keyof Price$EnumInterface, unknown>;
	//# sourceMappingURL=price.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/price-update-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/price-update-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PriceUpdateModeEnum {
	    calculated = 1,
	    entered = 2
	}
	export interface PriceUpdateMode$EnumInterface {
	    calculated: 1;
	    entered: 2;
	}
	export type PriceUpdateMode = keyof PriceUpdateMode$EnumInterface;
	export const priceUpdateModeDatatype: X3EnumDataType<keyof PriceUpdateMode$EnumInterface, unknown>;
	//# sourceMappingURL=price-update-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/price-type.d.ts
declare module '@sage/x3-master-data/lib/enums/price-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PriceTypeEnum {
	    normal = 1,
	    grouped = 2,
	    restricted = 3,
	    component = 4
	}
	export interface PriceType$EnumInterface {
	    normal: 1;
	    grouped: 2;
	    restricted: 3;
	    component: 4;
	}
	export type PriceType = keyof PriceType$EnumInterface;
	export const priceTypeDatatype: X3EnumDataType<keyof PriceType$EnumInterface, unknown>;
	//# sourceMappingURL=price-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/price-origin.d.ts
declare module '@sage/x3-master-data/lib/enums/price-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PriceOriginEnum {
	    entered = 1,
	    purchasePrice = 2
	}
	export interface PriceOrigin$EnumInterface {
	    entered: 1;
	    purchasePrice: 2;
	}
	export type PriceOrigin = keyof PriceOrigin$EnumInterface;
	export const priceOriginDatatype: X3EnumDataType<keyof PriceOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=price-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/price-classes.d.ts
declare module '@sage/x3-master-data/lib/enums/price-classes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PriceClassesEnum {
	    no = 1,
	    yes = 2,
	    quantityBands = 3,
	    grossPriceBands = 4,
	    netPriceBands = 5
	}
	export interface PriceClasses$EnumInterface {
	    no: 1;
	    yes: 2;
	    quantityBands: 3;
	    grossPriceBands: 4;
	    netPriceBands: 5;
	}
	export type PriceClasses = keyof PriceClasses$EnumInterface;
	export const priceClassesDatatype: X3EnumDataType<keyof PriceClasses$EnumInterface, unknown>;
	//# sourceMappingURL=price-classes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/price-amount-tax-tax.d.ts
declare module '@sage/x3-master-data/lib/enums/price-amount-tax-tax' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PriceAmountTaxTaxEnum {
	    excludeTax = 1,
	    includeTax = 2
	}
	export interface PriceAmountTaxTax$EnumInterface {
	    excludeTax: 1;
	    includeTax: 2;
	}
	export type PriceAmountTaxTax = keyof PriceAmountTaxTax$EnumInterface;
	export const priceAmountTaxTaxDatatype: X3EnumDataType<keyof PriceAmountTaxTax$EnumInterface, unknown>;
	//# sourceMappingURL=price-amount-tax-tax.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/price-adjustment.d.ts
declare module '@sage/x3-master-data/lib/enums/price-adjustment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PriceAdjustmentEnum {
	    no = 1,
	    receiptCost = 2,
	    receiptAndIssueCost = 3
	}
	export interface PriceAdjustment$EnumInterface {
	    no: 1;
	    receiptCost: 2;
	    receiptAndIssueCost: 3;
	}
	export type PriceAdjustment = keyof PriceAdjustment$EnumInterface;
	export const priceAdjustmentDatatype: X3EnumDataType<keyof PriceAdjustment$EnumInterface, unknown>;
	//# sourceMappingURL=price-adjustment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/prev-code-management-recoding.d.ts
declare module '@sage/x3-master-data/lib/enums/prev-code-management-recoding' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrevCodeManagementRecodingEnum {
	    saved = 1,
	    inactive = 2,
	    deleted = 3
	}
	export interface PrevCodeManagementRecoding$EnumInterface {
	    saved: 1;
	    inactive: 2;
	    deleted: 3;
	}
	export type PrevCodeManagementRecoding = keyof PrevCodeManagementRecoding$EnumInterface;
	export const prevCodeManagementRecodingDatatype: X3EnumDataType<keyof PrevCodeManagementRecoding$EnumInterface, unknown>;
	//# sourceMappingURL=prev-code-management-recoding.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/prepayment-status.d.ts
declare module '@sage/x3-master-data/lib/enums/prepayment-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrepaymentStatusEnum {
	    none = 1,
	    created = 2,
	    invoiced = 3,
	    paid = 4
	}
	export interface PrepaymentStatus$EnumInterface {
	    none: 1;
	    created: 2;
	    invoiced: 3;
	    paid: 4;
	}
	export type PrepaymentStatus = keyof PrepaymentStatus$EnumInterface;
	export const prepaymentStatusDatatype: X3EnumDataType<keyof PrepaymentStatus$EnumInterface, unknown>;
	//# sourceMappingURL=prepayment-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/prepayment-management.d.ts
declare module '@sage/x3-master-data/lib/enums/prepayment-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrepaymentManagementEnum {
	    prepayments = 1,
	    prepaymentInvoices = 2
	}
	export interface PrepaymentManagement$EnumInterface {
	    prepayments: 1;
	    prepaymentInvoices: 2;
	}
	export type PrepaymentManagement = keyof PrepaymentManagement$EnumInterface;
	export const prepaymentManagementDatatype: X3EnumDataType<keyof PrepaymentManagement$EnumInterface, unknown>;
	//# sourceMappingURL=prepayment-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/posting-type.d.ts
declare module '@sage/x3-master-data/lib/enums/posting-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PostingTypeEnum {
	    actual = 1,
	    simulation = 2
	}
	export interface PostingType$EnumInterface {
	    actual: 1;
	    simulation: 2;
	}
	export type PostingType = keyof PostingType$EnumInterface;
	export const postingTypeDatatype: X3EnumDataType<keyof PostingType$EnumInterface, unknown>;
	//# sourceMappingURL=posting-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/positive-pay-record-type.d.ts
declare module '@sage/x3-master-data/lib/enums/positive-pay-record-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PositivePayRecordTypeEnum {
	    header = 1,
	    detail = 2,
	    trailer = 3
	}
	export interface PositivePayRecordType$EnumInterface {
	    header: 1;
	    detail: 2;
	    trailer: 3;
	}
	export type PositivePayRecordType = keyof PositivePayRecordType$EnumInterface;
	export const positivePayRecordTypeDatatype: X3EnumDataType<keyof PositivePayRecordType$EnumInterface, unknown>;
	//# sourceMappingURL=positive-pay-record-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/positive-pay-file-generation.d.ts
declare module '@sage/x3-master-data/lib/enums/positive-pay-file-generation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PositivePayFileGenerationEnum {
	    generateNewFile = 1,
	    regenerateFile = 2
	}
	export interface PositivePayFileGeneration$EnumInterface {
	    generateNewFile: 1;
	    regenerateFile: 2;
	}
	export type PositivePayFileGeneration = keyof PositivePayFileGeneration$EnumInterface;
	export const positivePayFileGenerationDatatype: X3EnumDataType<keyof PositivePayFileGeneration$EnumInterface, unknown>;
	//# sourceMappingURL=positive-pay-file-generation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/poland-document-type.d.ts
declare module '@sage/x3-master-data/lib/enums/poland-document-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PolandDocumentTypeEnum {
	    allTypes = 1,
	    deliveries = 2,
	    customerReturns = 3,
	    loanReturns = 4,
	    subContMaterialReturns = 5,
	    interSiteTransfers = 6,
	    subContractTransfers = 7,
	    subContractReturns = 8,
	    purchaseReturns = 9,
	    transportNote = 10,
	    orders = 11,
	    quotes = 12,
	    proforma = 13
	}
	export interface PolandDocumentType$EnumInterface {
	    allTypes: 1;
	    deliveries: 2;
	    customerReturns: 3;
	    loanReturns: 4;
	    subContMaterialReturns: 5;
	    interSiteTransfers: 6;
	    subContractTransfers: 7;
	    subContractReturns: 8;
	    purchaseReturns: 9;
	    transportNote: 10;
	    orders: 11;
	    quotes: 12;
	    proforma: 13;
	}
	export type PolandDocumentType = keyof PolandDocumentType$EnumInterface;
	export const polandDocumentTypeDatatype: X3EnumDataType<keyof PolandDocumentType$EnumInterface, unknown>;
	//# sourceMappingURL=poland-document-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/points-type.d.ts
declare module '@sage/x3-master-data/lib/enums/points-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PointsTypeEnum {
	    fixed = 1,
	    supplementary = 2
	}
	export interface PointsType$EnumInterface {
	    fixed: 1;
	    supplementary: 2;
	}
	export type PointsType = keyof PointsType$EnumInterface;
	export const pointsTypeDatatype: X3EnumDataType<keyof PointsType$EnumInterface, unknown>;
	//# sourceMappingURL=points-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/points-report.d.ts
declare module '@sage/x3-master-data/lib/enums/points-report' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PointsReportEnum {
	    mobilized = 1,
	    consumed = 2
	}
	export interface PointsReport$EnumInterface {
	    mobilized: 1;
	    consumed: 2;
	}
	export type PointsReport = keyof PointsReport$EnumInterface;
	export const pointsReportDatatype: X3EnumDataType<keyof PointsReport$EnumInterface, unknown>;
	//# sourceMappingURL=points-report.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/plan-status.d.ts
declare module '@sage/x3-master-data/lib/enums/plan-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PlanStatusEnum {
	    pending = 1,
	    inProgress = 2,
	    completed = 3
	}
	export interface PlanStatus$EnumInterface {
	    pending: 1;
	    inProgress: 2;
	    completed: 3;
	}
	export type PlanStatus = keyof PlanStatus$EnumInterface;
	export const planStatusDatatype: X3EnumDataType<keyof PlanStatus$EnumInterface, unknown>;
	//# sourceMappingURL=plan-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/plan-status-2045.d.ts
declare module '@sage/x3-master-data/lib/enums/plan-status-2045' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PlanStatus2045Enum {
	    inPlanning = 1,
	    beingImplemented = 2,
	    completed = 3,
	    notApplicable = 4
	}
	export interface PlanStatus2045$EnumInterface {
	    inPlanning: 1;
	    beingImplemented: 2;
	    completed: 3;
	    notApplicable: 4;
	}
	export type PlanStatus2045 = keyof PlanStatus2045$EnumInterface;
	export const planStatus2045Datatype: X3EnumDataType<keyof PlanStatus2045$EnumInterface, unknown>;
	//# sourceMappingURL=plan-status-2045.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/plan-complete-email-text.d.ts
declare module '@sage/x3-master-data/lib/enums/plan-complete-email-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PlanCompleteEmailTextEnum {
	    planForChangeRequest1IsComplete = 1,
	    thePlanForThisChangeRequestIsCompleteAndSetToStatus = 2,
	    toViewTheChangeRequestClickTheLink = 3
	}
	export interface PlanCompleteEmailText$EnumInterface {
	    planForChangeRequest1IsComplete: 1;
	    thePlanForThisChangeRequestIsCompleteAndSetToStatus: 2;
	    toViewTheChangeRequestClickTheLink: 3;
	}
	export type PlanCompleteEmailText = keyof PlanCompleteEmailText$EnumInterface;
	export const planCompleteEmailTextDatatype: X3EnumDataType<keyof PlanCompleteEmailText$EnumInterface, unknown>;
	//# sourceMappingURL=plan-complete-email-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/place-type.d.ts
declare module '@sage/x3-master-data/lib/enums/place-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PlaceTypeEnum {
	    harbor = 1,
	    airport = 2,
	    station = 3,
	    warehouse = 4,
	    customs = 5,
	    site = 6,
	    supplier = 7,
	    other = 8
	}
	export interface PlaceType$EnumInterface {
	    harbor: 1;
	    airport: 2;
	    station: 3;
	    warehouse: 4;
	    customs: 5;
	    site: 6;
	    supplier: 7;
	    other: 8;
	}
	export type PlaceType = keyof PlaceType$EnumInterface;
	export const placeTypeDatatype: X3EnumDataType<keyof PlaceType$EnumInterface, unknown>;
	//# sourceMappingURL=place-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/place-of-appointment.d.ts
declare module '@sage/x3-master-data/lib/enums/place-of-appointment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PlaceOfAppointmentEnum {
	    atCustomersSite = 1,
	    onOurPremises = 2,
	    other = 3
	}
	export interface PlaceOfAppointment$EnumInterface {
	    atCustomersSite: 1;
	    onOurPremises: 2;
	    other: 3;
	}
	export type PlaceOfAppointment = keyof PlaceOfAppointment$EnumInterface;
	export const placeOfAppointmentDatatype: X3EnumDataType<keyof PlaceOfAppointment$EnumInterface, unknown>;
	//# sourceMappingURL=place-of-appointment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/pivot-types.d.ts
declare module '@sage/x3-master-data/lib/enums/pivot-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PivotTypesEnum {
	    plmProducts = 1,
	    plmBoMs = 2,
	    woDetailedScheduling = 3,
	    operationsDetailedScheduling = 4,
	    successionsDetailedScheduling = 5,
	    productsDetailedScheduling = 6,
	    workCenterGroupDetailedScheduling = 7,
	    workCenterDetailedScheduling = 8,
	    workCenterDetailedSchedulingByGroup = 9,
	    secondaryResourceDetailedScheduling = 10,
	    replacementWorkCenterDetailedScheduling = 11,
	    capacityVariationDetailedSchedulingByWorkCenter = 12,
	    customerDetailedScheduling = 13,
	    projectDetailedScheduling = 14,
	    orderDetailedScheduling = 15,
	    bomDetailedScheduling = 16,
	    purchaseDetailedScheduling = 17,
	    stocksDetailedScheduling = 18,
	    mmsProductsSpareParts = 19,
	    mmsCostCentersDimensions = 20,
	    mmsStorageSites = 21,
	    mmsProductStockSite = 22,
	    mmsStockJournal = 23,
	    mmsMovements = 24,
	    mmsSuppliers = 25,
	    mmsSupplierContacts = 26,
	    mmsSupplierClassifications = 27,
	    mmsSupplierProducts = 28,
	    mmsPurchaseRequests = 29,
	    mmsPurchaseRequestProgress = 30,
	    mmsProjects = 31,
	    mmsUnits = 32,
	    mmsUsers = 33,
	    mmsUnitConversions = 34,
	    scmItemsProducts = 35,
	    scmItemsConversions = 36,
	    scmItemsCriteria = 37,
	    scmCustomers = 38,
	    scmSites = 39,
	    scmSitesCriteria = 40,
	    scmSalesHistory = 41,
	    scmOrdersInProgress = 42,
	    scmSalesForecasts = 43,
	    scmItemsSites = 44,
	    reachItems = 45,
	    reachSuppliers = 46,
	    energyEntries = 47,
	    accountingEntryFile = 48
	}
	export interface PivotTypes$EnumInterface {
	    plmProducts: 1;
	    plmBoMs: 2;
	    woDetailedScheduling: 3;
	    operationsDetailedScheduling: 4;
	    successionsDetailedScheduling: 5;
	    productsDetailedScheduling: 6;
	    workCenterGroupDetailedScheduling: 7;
	    workCenterDetailedScheduling: 8;
	    workCenterDetailedSchedulingByGroup: 9;
	    secondaryResourceDetailedScheduling: 10;
	    replacementWorkCenterDetailedScheduling: 11;
	    capacityVariationDetailedSchedulingByWorkCenter: 12;
	    customerDetailedScheduling: 13;
	    projectDetailedScheduling: 14;
	    orderDetailedScheduling: 15;
	    bomDetailedScheduling: 16;
	    purchaseDetailedScheduling: 17;
	    stocksDetailedScheduling: 18;
	    mmsProductsSpareParts: 19;
	    mmsCostCentersDimensions: 20;
	    mmsStorageSites: 21;
	    mmsProductStockSite: 22;
	    mmsStockJournal: 23;
	    mmsMovements: 24;
	    mmsSuppliers: 25;
	    mmsSupplierContacts: 26;
	    mmsSupplierClassifications: 27;
	    mmsSupplierProducts: 28;
	    mmsPurchaseRequests: 29;
	    mmsPurchaseRequestProgress: 30;
	    mmsProjects: 31;
	    mmsUnits: 32;
	    mmsUsers: 33;
	    mmsUnitConversions: 34;
	    scmItemsProducts: 35;
	    scmItemsConversions: 36;
	    scmItemsCriteria: 37;
	    scmCustomers: 38;
	    scmSites: 39;
	    scmSitesCriteria: 40;
	    scmSalesHistory: 41;
	    scmOrdersInProgress: 42;
	    scmSalesForecasts: 43;
	    scmItemsSites: 44;
	    reachItems: 45;
	    reachSuppliers: 46;
	    energyEntries: 47;
	    accountingEntryFile: 48;
	}
	export type PivotTypes = keyof PivotTypes$EnumInterface;
	export const pivotTypesDatatype: X3EnumDataType<keyof PivotTypes$EnumInterface, unknown>;
	//# sourceMappingURL=pivot-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/pivot-headers.d.ts
declare module '@sage/x3-master-data/lib/enums/pivot-headers' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PivotHeadersEnum {
	    noHeader = 1,
	    standardHeader = 2,
	    specificHeader = 3,
	    headerWithTitles = 4
	}
	export interface PivotHeaders$EnumInterface {
	    noHeader: 1;
	    standardHeader: 2;
	    specificHeader: 3;
	    headerWithTitles: 4;
	}
	export type PivotHeaders = keyof PivotHeaders$EnumInterface;
	export const pivotHeadersDatatype: X3EnumDataType<keyof PivotHeaders$EnumInterface, unknown>;
	//# sourceMappingURL=pivot-headers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/physical-asset-count-type.d.ts
declare module '@sage/x3-master-data/lib/enums/physical-asset-count-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PhysicalAssetCountTypeEnum {
	    control = 1,
	    initial = 2,
	    notCounted = 3
	}
	export interface PhysicalAssetCountType$EnumInterface {
	    control: 1;
	    initial: 2;
	    notCounted: 3;
	}
	export type PhysicalAssetCountType = keyof PhysicalAssetCountType$EnumInterface;
	export const physicalAssetCountTypeDatatype: X3EnumDataType<keyof PhysicalAssetCountType$EnumInterface, unknown>;
	//# sourceMappingURL=physical-asset-count-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/physical-asset-count-status.d.ts
declare module '@sage/x3-master-data/lib/enums/physical-asset-count-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PhysicalAssetCountStatusEnum {
	    cNotProcessed = 1,
	    cAssetNotFoundInDatabase = 2,
	    cAssetDeclaredAsIssuedInTheDatabase = 3,
	    cChangeToGeographicAllocation = 4,
	    cChangeToAnalyticalAllocation = 5,
	    cChangeToAnalyGeogAllocation = 6,
	    noteMatchingTheDBase = 7,
	    cAssetCountedInNonExistentLoc = 8,
	    cAssetCountedInAnotherCompany = 9,
	    iNotProcessed = 10,
	    iAssetReconciledWithANonRegisteredAsset = 11,
	    iAssetReconciledWithARegisteredAsset = 12,
	    iAssetNotReconciledWithAssetInDbase = 13,
	    iCountedAssetInNonExistentLoc = 14,
	    iCountedAssetAlreadyExistsInDatabase = 15,
	    assetInDatabaseNotFoundDuringPhysicalAssetCount = 16,
	    cPhysAssetDeclaredIssuedInDatabaseGeoChange = 17
	}
	export interface PhysicalAssetCountStatus$EnumInterface {
	    cNotProcessed: 1;
	    cAssetNotFoundInDatabase: 2;
	    cAssetDeclaredAsIssuedInTheDatabase: 3;
	    cChangeToGeographicAllocation: 4;
	    cChangeToAnalyticalAllocation: 5;
	    cChangeToAnalyGeogAllocation: 6;
	    noteMatchingTheDBase: 7;
	    cAssetCountedInNonExistentLoc: 8;
	    cAssetCountedInAnotherCompany: 9;
	    iNotProcessed: 10;
	    iAssetReconciledWithANonRegisteredAsset: 11;
	    iAssetReconciledWithARegisteredAsset: 12;
	    iAssetNotReconciledWithAssetInDbase: 13;
	    iCountedAssetInNonExistentLoc: 14;
	    iCountedAssetAlreadyExistsInDatabase: 15;
	    assetInDatabaseNotFoundDuringPhysicalAssetCount: 16;
	    cPhysAssetDeclaredIssuedInDatabaseGeoChange: 17;
	}
	export type PhysicalAssetCountStatus = keyof PhysicalAssetCountStatus$EnumInterface;
	export const physicalAssetCountStatusDatatype: X3EnumDataType<keyof PhysicalAssetCountStatus$EnumInterface, unknown>;
	//# sourceMappingURL=physical-asset-count-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/physical-asset-count-result.d.ts
declare module '@sage/x3-master-data/lib/enums/physical-asset-count-result' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PhysicalAssetCountResultEnum {
	    disposalCancelled = 1,
	    geographicChange = 2,
	    analyticalChange = 3,
	    analyticalAndGeographicChange = 4,
	    barCodeAllocation = 5,
	    barCodeChange = 6,
	    assetNotFound = 7,
	    countedAsset = 8
	}
	export interface PhysicalAssetCountResult$EnumInterface {
	    disposalCancelled: 1;
	    geographicChange: 2;
	    analyticalChange: 3;
	    analyticalAndGeographicChange: 4;
	    barCodeAllocation: 5;
	    barCodeChange: 6;
	    assetNotFound: 7;
	    countedAsset: 8;
	}
	export type PhysicalAssetCountResult = keyof PhysicalAssetCountResult$EnumInterface;
	export const physicalAssetCountResultDatatype: X3EnumDataType<keyof PhysicalAssetCountResult$EnumInterface, unknown>;
	//# sourceMappingURL=physical-asset-count-result.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/physical-asset-count-operation-status.d.ts
declare module '@sage/x3-master-data/lib/enums/physical-asset-count-operation-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PhysicalAssetCountOperationStatusEnum {
	    planned = 1,
	    inProcess = 2,
	    complete = 3
	}
	export interface PhysicalAssetCountOperationStatus$EnumInterface {
	    planned: 1;
	    inProcess: 2;
	    complete: 3;
	}
	export type PhysicalAssetCountOperationStatus = keyof PhysicalAssetCountOperationStatus$EnumInterface;
	export const physicalAssetCountOperationStatusDatatype: X3EnumDataType<keyof PhysicalAssetCountOperationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=physical-asset-count-operation-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/physical-asset-count-entry-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/physical-asset-count-entry-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PhysicalAssetCountEntryRuleEnum {
	    mandatory = 1,
	    optional = 2,
	    prohibited = 3
	}
	export interface PhysicalAssetCountEntryRule$EnumInterface {
	    mandatory: 1;
	    optional: 2;
	    prohibited: 3;
	}
	export type PhysicalAssetCountEntryRule = keyof PhysicalAssetCountEntryRule$EnumInterface;
	export const physicalAssetCountEntryRuleDatatype: X3EnumDataType<keyof PhysicalAssetCountEntryRule$EnumInterface, unknown>;
	//# sourceMappingURL=physical-asset-count-entry-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/physical-asset-count-entry-method.d.ts
declare module '@sage/x3-master-data/lib/enums/physical-asset-count-entry-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PhysicalAssetCountEntryMethodEnum {
	    laser = 1,
	    keyboard = 2,
	    laserKeyboard = 3
	}
	export interface PhysicalAssetCountEntryMethod$EnumInterface {
	    laser: 1;
	    keyboard: 2;
	    laserKeyboard: 3;
	}
	export type PhysicalAssetCountEntryMethod = keyof PhysicalAssetCountEntryMethod$EnumInterface;
	export const physicalAssetCountEntryMethodDatatype: X3EnumDataType<keyof PhysicalAssetCountEntryMethod$EnumInterface, unknown>;
	//# sourceMappingURL=physical-asset-count-entry-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/phys-asset-entry-persistence.d.ts
declare module '@sage/x3-master-data/lib/enums/phys-asset-entry-persistence' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PhysAssetEntryPersistenceEnum {
	    no = 1,
	    yes = 2
	}
	export interface PhysAssetEntryPersistence$EnumInterface {
	    no: 1;
	    yes: 2;
	}
	export type PhysAssetEntryPersistence = keyof PhysAssetEntryPersistence$EnumInterface;
	export const physAssetEntryPersistenceDatatype: X3EnumDataType<keyof PhysAssetEntryPersistence$EnumInterface, unknown>;
	//# sourceMappingURL=phys-asset-entry-persistence.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/phone-number-type.d.ts
declare module '@sage/x3-master-data/lib/enums/phone-number-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PhoneNumberTypeEnum {
	    switchboardOperator = 1,
	    directLine = 2
	}
	export interface PhoneNumberType$EnumInterface {
	    switchboardOperator: 1;
	    directLine: 2;
	}
	export type PhoneNumberType = keyof PhoneNumberType$EnumInterface;
	export const phoneNumberTypeDatatype: X3EnumDataType<keyof PhoneNumberType$EnumInterface, unknown>;
	//# sourceMappingURL=phone-number-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/periodicity-type-2990.d.ts
declare module '@sage/x3-master-data/lib/enums/periodicity-type-2990' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PeriodicityType2990Enum {
	    recurrance = 1,
	    valueCheck = 2,
	    entryPoint = 3
	}
	export interface PeriodicityType2990$EnumInterface {
	    recurrance: 1;
	    valueCheck: 2;
	    entryPoint: 3;
	}
	export type PeriodicityType2990 = keyof PeriodicityType2990$EnumInterface;
	export const periodicityType2990Datatype: X3EnumDataType<keyof PeriodicityType2990$EnumInterface, unknown>;
	//# sourceMappingURL=periodicity-type-2990.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/period-status.d.ts
declare module '@sage/x3-master-data/lib/enums/period-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PeriodStatusEnum {
	    notOpen = 1,
	    current = 2,
	    open = 3,
	    closed = 4
	}
	export interface PeriodStatus$EnumInterface {
	    notOpen: 1;
	    current: 2;
	    open: 3;
	    closed: 4;
	}
	export type PeriodStatus = keyof PeriodStatus$EnumInterface;
	export const periodStatusDatatype: X3EnumDataType<keyof PeriodStatus$EnumInterface, unknown>;
	//# sourceMappingURL=period-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/period-fiscal-year-status.d.ts
declare module '@sage/x3-master-data/lib/enums/period-fiscal-year-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PeriodFiscalYearStatusEnum {
	    notOpen = 1,
	    open = 2,
	    closed = 3
	}
	export interface PeriodFiscalYearStatus$EnumInterface {
	    notOpen: 1;
	    open: 2;
	    closed: 3;
	}
	export type PeriodFiscalYearStatus = keyof PeriodFiscalYearStatus$EnumInterface;
	export const periodFiscalYearStatusDatatype: X3EnumDataType<keyof PeriodFiscalYearStatus$EnumInterface, unknown>;
	//# sourceMappingURL=period-fiscal-year-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/pending-movement.d.ts
declare module '@sage/x3-master-data/lib/enums/pending-movement' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PendingMovementEnum {
	    none = 1,
	    disposal = 2,
	    disposalCancellation = 3,
	    geographicTransfer = 4,
	    geographicTransferCancellation = 5
	}
	export interface PendingMovement$EnumInterface {
	    none: 1;
	    disposal: 2;
	    disposalCancellation: 3;
	    geographicTransfer: 4;
	    geographicTransferCancellation: 5;
	}
	export type PendingMovement = keyof PendingMovement$EnumInterface;
	export const pendingMovementDatatype: X3EnumDataType<keyof PendingMovement$EnumInterface, unknown>;
	//# sourceMappingURL=pending-movement.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/pending-movement-control.d.ts
declare module '@sage/x3-master-data/lib/enums/pending-movement-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PendingMovementControlEnum {
	    notBlocking = 1,
	    blockingUponClosing = 2,
	    blockingUponCostPriceCalculation = 3
	}
	export interface PendingMovementControl$EnumInterface {
	    notBlocking: 1;
	    blockingUponClosing: 2;
	    blockingUponCostPriceCalculation: 3;
	}
	export type PendingMovementControl = keyof PendingMovementControl$EnumInterface;
	export const pendingMovementControlDatatype: X3EnumDataType<keyof PendingMovementControl$EnumInterface, unknown>;
	//# sourceMappingURL=pending-movement-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-type.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentTypeEnum {
	    recurring = 1,
	    oneOff = 2
	}
	export interface PaymentType$EnumInterface {
	    recurring: 1;
	    oneOff: 2;
	}
	export type PaymentType = keyof PaymentType$EnumInterface;
	export const paymentTypeDatatype: X3EnumDataType<keyof PaymentType$EnumInterface, unknown>;
	//# sourceMappingURL=payment-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-status-3690.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-status-3690' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentStatus3690Enum {
	    notValidated = 1,
	    validated = 2,
	    partiallyValidated = 3,
	    manuallyCompleted = 4
	}
	export interface PaymentStatus3690$EnumInterface {
	    notValidated: 1;
	    validated: 2;
	    partiallyValidated: 3;
	    manuallyCompleted: 4;
	}
	export type PaymentStatus3690 = keyof PaymentStatus3690$EnumInterface;
	export const paymentStatus3690Datatype: X3EnumDataType<keyof PaymentStatus3690$EnumInterface, unknown>;
	//# sourceMappingURL=payment-status-3690.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-selection.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentSelectionEnum {
	    allPayments = 1,
	    validatedPayments = 2,
	    paymentsInBank = 3,
	    reconciledItems = 4
	}
	export interface PaymentSelection$EnumInterface {
	    allPayments: 1;
	    validatedPayments: 2;
	    paymentsInBank: 3;
	    reconciledItems: 4;
	}
	export type PaymentSelection = keyof PaymentSelection$EnumInterface;
	export const paymentSelectionDatatype: X3EnumDataType<keyof PaymentSelection$EnumInterface, unknown>;
	//# sourceMappingURL=payment-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-processor.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-processor' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentProcessorEnum {
	    sageExchange = 1,
	    sagePay = 2
	}
	export interface PaymentProcessor$EnumInterface {
	    sageExchange: 1;
	    sagePay: 2;
	}
	export type PaymentProcessor = keyof PaymentProcessor$EnumInterface;
	export const paymentProcessorDatatype: X3EnumDataType<keyof PaymentProcessor$EnumInterface, unknown>;
	//# sourceMappingURL=payment-processor.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-processor-selection.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-processor-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentProcessorSelectionEnum {
	    sageExchange = 1,
	    sagePay = 2,
	    all = 3
	}
	export interface PaymentProcessorSelection$EnumInterface {
	    sageExchange: 1;
	    sagePay: 2;
	    all: 3;
	}
	export type PaymentProcessorSelection = keyof PaymentProcessorSelection$EnumInterface;
	export const paymentProcessorSelectionDatatype: X3EnumDataType<keyof PaymentProcessorSelection$EnumInterface, unknown>;
	//# sourceMappingURL=payment-processor-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-order-receipt.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-order-receipt' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentOrderReceiptEnum {
	    paymentOrder = 1,
	    receipt = 2
	}
	export interface PaymentOrderReceipt$EnumInterface {
	    paymentOrder: 1;
	    receipt: 2;
	}
	export type PaymentOrderReceipt = keyof PaymentOrderReceipt$EnumInterface;
	export const paymentOrderReceiptDatatype: X3EnumDataType<keyof PaymentOrderReceipt$EnumInterface, unknown>;
	//# sourceMappingURL=payment-order-receipt.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-order-receipt-report.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-order-receipt-report' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentOrderReceiptReportEnum {
	    pending = 1,
	    printed = 2,
	    validated = 3
	}
	export interface PaymentOrderReceiptReport$EnumInterface {
	    pending: 1;
	    printed: 2;
	    validated: 3;
	}
	export type PaymentOrderReceiptReport = keyof PaymentOrderReceiptReport$EnumInterface;
	export const paymentOrderReceiptReportDatatype: X3EnumDataType<keyof PaymentOrderReceiptReport$EnumInterface, unknown>;
	//# sourceMappingURL=payment-order-receipt-report.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-item-reference.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-item-reference' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentItemReferenceEnum {
	    mainAccount = 1,
	    accountJournalBusinessPartner = 2,
	    bankJournalAccount = 3,
	    treasuryCurrencyMo = 4,
	    currencyMo = 5,
	    businessPartnerMo = 6,
	    accountTransfer = 7,
	    discountedDrafts = 8,
	    draftTransfer = 9,
	    taxStamp = 10
	}
	export interface PaymentItemReference$EnumInterface {
	    mainAccount: 1;
	    accountJournalBusinessPartner: 2;
	    bankJournalAccount: 3;
	    treasuryCurrencyMo: 4;
	    currencyMo: 5;
	    businessPartnerMo: 6;
	    accountTransfer: 7;
	    discountedDrafts: 8;
	    draftTransfer: 9;
	    taxStamp: 10;
	}
	export type PaymentItemReference = keyof PaymentItemReference$EnumInterface;
	export const paymentItemReferenceDatatype: X3EnumDataType<keyof PaymentItemReference$EnumInterface, unknown>;
	//# sourceMappingURL=payment-item-reference.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-entry-type.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-entry-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentEntryTypeEnum {
	    nA = 1,
	    cashRegister = 2,
	    bankRegister = 3
	}
	export interface PaymentEntryType$EnumInterface {
	    nA: 1;
	    cashRegister: 2;
	    bankRegister: 3;
	}
	export type PaymentEntryType = keyof PaymentEntryType$EnumInterface;
	export const paymentEntryTypeDatatype: X3EnumDataType<keyof PaymentEntryType$EnumInterface, unknown>;
	//# sourceMappingURL=payment-entry-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-card-status.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-card-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentCardStatusEnum {
	    selected = 1,
	    verified = 2,
	    authorized = 3,
	    rejected = 4,
	    voided = 5,
	    captured = 6,
	    settled = 7,
	    manual = 8
	}
	export interface PaymentCardStatus$EnumInterface {
	    selected: 1;
	    verified: 2;
	    authorized: 3;
	    rejected: 4;
	    voided: 5;
	    captured: 6;
	    settled: 7;
	    manual: 8;
	}
	export type PaymentCardStatus = keyof PaymentCardStatus$EnumInterface;
	export const paymentCardStatusDatatype: X3EnumDataType<keyof PaymentCardStatus$EnumInterface, unknown>;
	//# sourceMappingURL=payment-card-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-approval.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-approval' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentApprovalEnum {
	    approved = 1,
	    partiallyApproved = 2,
	    notApproved = 3
	}
	export interface PaymentApproval$EnumInterface {
	    approved: 1;
	    partiallyApproved: 2;
	    notApproved: 3;
	}
	export type PaymentApproval = keyof PaymentApproval$EnumInterface;
	export const paymentApprovalDatatype: X3EnumDataType<keyof PaymentApproval$EnumInterface, unknown>;
	//# sourceMappingURL=payment-approval.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/payment-approval-type.d.ts
declare module '@sage/x3-master-data/lib/enums/payment-approval-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentApprovalTypeEnum {
	    pending = 1,
	    conflict = 2,
	    delayed = 3,
	    authorizedToPay = 4
	}
	export interface PaymentApprovalType$EnumInterface {
	    pending: 1;
	    conflict: 2;
	    delayed: 3;
	    authorizedToPay: 4;
	}
	export type PaymentApprovalType = keyof PaymentApprovalType$EnumInterface;
	export const paymentApprovalTypeDatatype: X3EnumDataType<keyof PaymentApprovalType$EnumInterface, unknown>;
	//# sourceMappingURL=payment-approval-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/packing-slip-types.d.ts
declare module '@sage/x3-master-data/lib/enums/packing-slip-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PackingSlipTypesEnum {
	    customer = 1,
	    supplier = 2,
	    miscellaneous = 3
	}
	export interface PackingSlipTypes$EnumInterface {
	    customer: 1;
	    supplier: 2;
	    miscellaneous: 3;
	}
	export type PackingSlipTypes = keyof PackingSlipTypes$EnumInterface;
	export const packingSlipTypesDatatype: X3EnumDataType<keyof PackingSlipTypes$EnumInterface, unknown>;
	//# sourceMappingURL=packing-slip-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/outlook-contact-type.d.ts
declare module '@sage/x3-master-data/lib/enums/outlook-contact-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OutlookContactTypeEnum {
	    contact = 1,
	    lead = 2,
	    salesRep = 3
	}
	export interface OutlookContactType$EnumInterface {
	    contact: 1;
	    lead: 2;
	    salesRep: 3;
	}
	export type OutlookContactType = keyof OutlookContactType$EnumInterface;
	export const outlookContactTypeDatatype: X3EnumDataType<keyof OutlookContactType$EnumInterface, unknown>;
	//# sourceMappingURL=outlook-contact-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/original-entry-supplement.d.ts
declare module '@sage/x3-master-data/lib/enums/original-entry-supplement' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OriginalEntrySupplementEnum {
	    purchaseInvoices = 1,
	    bpInvoices = 2,
	    journal = 3,
	    payment = 4,
	    import = 5,
	    stockIssue = 6
	}
	export interface OriginalEntrySupplement$EnumInterface {
	    purchaseInvoices: 1;
	    bpInvoices: 2;
	    journal: 3;
	    payment: 4;
	    import: 5;
	    stockIssue: 6;
	}
	export type OriginalEntrySupplement = keyof OriginalEntrySupplement$EnumInterface;
	export const originalEntrySupplementDatatype: X3EnumDataType<keyof OriginalEntrySupplement$EnumInterface, unknown>;
	//# sourceMappingURL=original-entry-supplement.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/original-depreciation-basis.d.ts
declare module '@sage/x3-master-data/lib/enums/original-depreciation-basis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OriginalDepreciationBasisEnum {
	    coAValuation = 1,
	    iasValuation = 2,
	    subsidyAmount = 3,
	    toBeEntered = 4
	}
	export interface OriginalDepreciationBasis$EnumInterface {
	    coAValuation: 1;
	    iasValuation: 2;
	    subsidyAmount: 3;
	    toBeEntered: 4;
	}
	export type OriginalDepreciationBasis = keyof OriginalDepreciationBasis$EnumInterface;
	export const originalDepreciationBasisDatatype: X3EnumDataType<keyof OriginalDepreciationBasis$EnumInterface, unknown>;
	//# sourceMappingURL=original-depreciation-basis.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/origin-type.d.ts
declare module '@sage/x3-master-data/lib/enums/origin-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OriginTypeEnum {
	    manual = 1,
	    generated = 2,
	    synchronization = 3,
	    import = 4
	}
	export interface OriginType$EnumInterface {
	    manual: 1;
	    generated: 2;
	    synchronization: 3;
	    import: 4;
	}
	export type OriginType = keyof OriginType$EnumInterface;
	export const originTypeDatatype: X3EnumDataType<keyof OriginType$EnumInterface, unknown>;
	//# sourceMappingURL=origin-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/orders-action-status.d.ts
declare module '@sage/x3-master-data/lib/enums/orders-action-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrdersActionStatusEnum {
	    pending = 1,
	    blocking = 2,
	    noAction = 3,
	    complete = 4
	}
	export interface OrdersActionStatus$EnumInterface {
	    pending: 1;
	    blocking: 2;
	    noAction: 3;
	    complete: 4;
	}
	export type OrdersActionStatus = keyof OrdersActionStatus$EnumInterface;
	export const ordersActionStatusDatatype: X3EnumDataType<keyof OrdersActionStatus$EnumInterface, unknown>;
	//# sourceMappingURL=orders-action-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/ord-invoice.d.ts
declare module '@sage/x3-master-data/lib/enums/ord-invoice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrdInvoiceEnum {
	    order = 1,
	    invoice = 2,
	    unallocated = 3
	}
	export interface OrdInvoice$EnumInterface {
	    order: 1;
	    invoice: 2;
	    unallocated: 3;
	}
	export type OrdInvoice = keyof OrdInvoice$EnumInterface;
	export const ordInvoiceDatatype: X3EnumDataType<keyof OrdInvoice$EnumInterface, unknown>;
	//# sourceMappingURL=ord-invoice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/option-table.d.ts
declare module '@sage/x3-master-data/lib/enums/option-table' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OptionTableEnum {
	    entryPoints = 1,
	    listGenerator = 2,
	    deferredPrinting = 3,
	    importExport = 4,
	    extensionDictionary = 5,
	    crmActivities = 6,
	    automaticAllocation = 7,
	    loans = 8,
	    reservations = 9,
	    billOfMaterials = 10,
	    freightPrice = 11,
	    pricingDiscount = 12,
	    shipToCustomers = 13,
	    recurringInvoices = 14,
	    statisticsForecasts = 15,
	    generalPurchases = 16,
	    directOrder = 17,
	    multisite = 18,
	    serialNumberLot = 19,
	    automaticReordering = 20,
	    barCodeEntry = 21,
	    bankingConnections = 22,
	    bankStatements = 23,
	    paymentProposal = 24,
	    factoring = 25,
	    multideclarationSiteAccounting = 26,
	    analyticalAccounting = 27,
	    budgetaryAccounting = 28,
	    analyticalMultidimensionTypes = 29,
	    recurringEntries = 30,
	    simulations = 31,
	    taxStatements = 32,
	    exchangeOfGoods = 33,
	    postalCode = 34,
	    userManagement = 35,
	    tDS = 36,
	    multideclarationSiteSalary = 37,
	    reversePayment = 38,
	    free39 = 39,
	    free40 = 40,
	    spemiReserved = 41,
	    free = 42,
	    development = 43,
	    substituteValue44 = 44,
	    multicurrencyAccounting = 45,
	    consolidation = 46,
	    financialDataExtraction = 47,
	    analyticalFinancialDataExtraction = 48,
	    commitments = 49,
	    dimensionGrouping = 50,
	    nonfinancialUnit = 51,
	    dimensionDistribution = 52,
	    payByBusinessPartners = 53,
	    bankingPool = 54,
	    unpaid = 55,
	    batchServer = 56,
	    gescomAccounting = 57,
	    onlineUserHelp = 58,
	    faxInterface = 59,
	    almacomInterface = 60,
	    cergInterface = 61,
	    pay62 = 62,
	    pay63 = 63,
	    pay = 64,
	    time65 = 65,
	    time66 = 66,
	    time = 67,
	    fixedAssets68 = 68,
	    fixedAssets69 = 69,
	    fixedAssets = 70,
	    multilocation = 71
	}
	export interface OptionTable$EnumInterface {
	    entryPoints: 1;
	    listGenerator: 2;
	    deferredPrinting: 3;
	    importExport: 4;
	    extensionDictionary: 5;
	    crmActivities: 6;
	    automaticAllocation: 7;
	    loans: 8;
	    reservations: 9;
	    billOfMaterials: 10;
	    freightPrice: 11;
	    pricingDiscount: 12;
	    shipToCustomers: 13;
	    recurringInvoices: 14;
	    statisticsForecasts: 15;
	    generalPurchases: 16;
	    directOrder: 17;
	    multisite: 18;
	    serialNumberLot: 19;
	    automaticReordering: 20;
	    barCodeEntry: 21;
	    bankingConnections: 22;
	    bankStatements: 23;
	    paymentProposal: 24;
	    factoring: 25;
	    multideclarationSiteAccounting: 26;
	    analyticalAccounting: 27;
	    budgetaryAccounting: 28;
	    analyticalMultidimensionTypes: 29;
	    recurringEntries: 30;
	    simulations: 31;
	    taxStatements: 32;
	    exchangeOfGoods: 33;
	    postalCode: 34;
	    userManagement: 35;
	    tDS: 36;
	    multideclarationSiteSalary: 37;
	    reversePayment: 38;
	    free39: 39;
	    free40: 40;
	    spemiReserved: 41;
	    free: 42;
	    development: 43;
	    substituteValue44: 44;
	    multicurrencyAccounting: 45;
	    consolidation: 46;
	    financialDataExtraction: 47;
	    analyticalFinancialDataExtraction: 48;
	    commitments: 49;
	    dimensionGrouping: 50;
	    nonfinancialUnit: 51;
	    dimensionDistribution: 52;
	    payByBusinessPartners: 53;
	    bankingPool: 54;
	    unpaid: 55;
	    batchServer: 56;
	    gescomAccounting: 57;
	    onlineUserHelp: 58;
	    faxInterface: 59;
	    almacomInterface: 60;
	    cergInterface: 61;
	    pay62: 62;
	    pay63: 63;
	    pay: 64;
	    time65: 65;
	    time66: 66;
	    time: 67;
	    fixedAssets68: 68;
	    fixedAssets69: 69;
	    fixedAssets: 70;
	    multilocation: 71;
	}
	export type OptionTable = keyof OptionTable$EnumInterface;
	export const optionTableDatatype: X3EnumDataType<keyof OptionTable$EnumInterface, unknown>;
	//# sourceMappingURL=option-table.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/option-for-bd-and-bs-modes.d.ts
declare module '@sage/x3-master-data/lib/enums/option-for-bd-and-bs-modes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OptionForBdAndBsModesEnum {
	    withoutProRata = 1,
	    monthlyProRata = 2,
	    dailyProRata = 3
	}
	export interface OptionForBdAndBsModes$EnumInterface {
	    withoutProRata: 1;
	    monthlyProRata: 2;
	    dailyProRata: 3;
	}
	export type OptionForBdAndBsModes = keyof OptionForBdAndBsModes$EnumInterface;
	export const optionForBdAndBsModesDatatype: X3EnumDataType<keyof OptionForBdAndBsModes$EnumInterface, unknown>;
	//# sourceMappingURL=option-for-bd-and-bs-modes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/operators.d.ts
declare module '@sage/x3-master-data/lib/enums/operators' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperatorsEnum {
	    valueRange = 1,
	    equalTo = 2,
	    greaterThanOrEqualTo = 3,
	    lessThanOrEqualTo = 4
	}
	export interface Operators$EnumInterface {
	    valueRange: 1;
	    equalTo: 2;
	    greaterThanOrEqualTo: 3;
	    lessThanOrEqualTo: 4;
	}
	export type Operators = keyof Operators$EnumInterface;
	export const operatorsDatatype: X3EnumDataType<keyof Operators$EnumInterface, unknown>;
	//# sourceMappingURL=operators.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/operators-2960.d.ts
declare module '@sage/x3-master-data/lib/enums/operators-2960' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Operators2960Enum {
	    equal = 1,
	    different = 2,
	    startingWith = 3,
	    containing = 4,
	    endingWith = 5,
	    greaterThan = 6,
	    greaterThanOrEqualTo = 7,
	    lessThan = 8,
	    lessThanOrEqualTo = 9,
	    includedBetween = 10
	}
	export interface Operators2960$EnumInterface {
	    equal: 1;
	    different: 2;
	    startingWith: 3;
	    containing: 4;
	    endingWith: 5;
	    greaterThan: 6;
	    greaterThanOrEqualTo: 7;
	    lessThan: 8;
	    lessThanOrEqualTo: 9;
	    includedBetween: 10;
	}
	export type Operators2960 = keyof Operators2960$EnumInterface;
	export const operators2960Datatype: X3EnumDataType<keyof Operators2960$EnumInterface, unknown>;
	//# sourceMappingURL=operators-2960.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/operation-type.d.ts
declare module '@sage/x3-master-data/lib/enums/operation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperationTypeEnum {
	    notIncludedOnType4 = 1,
	    notUsed2 = 2,
	    notUsed = 3,
	    triangularOperations = 4,
	    services = 5
	}
	export interface OperationType$EnumInterface {
	    notIncludedOnType4: 1;
	    notUsed2: 2;
	    notUsed: 3;
	    triangularOperations: 4;
	    services: 5;
	}
	export type OperationType = keyof OperationType$EnumInterface;
	export const operationTypeDatatype: X3EnumDataType<keyof OperationType$EnumInterface, unknown>;
	//# sourceMappingURL=operation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/operation-enum.d.ts
declare module '@sage/x3-master-data/lib/enums/operation-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperationEnumEnum {
	    read = 1,
	    create = 2,
	    delete = 3,
	    update = 4
	}
	export interface OperationEnum$EnumInterface {
	    read: 1;
	    create: 2;
	    delete: 3;
	    update: 4;
	}
	export type OperationEnum = keyof OperationEnum$EnumInterface;
	export const operationEnumDatatype: X3EnumDataType<keyof OperationEnum$EnumInterface, unknown>;
	//# sourceMappingURL=operation-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/open-item-type.d.ts
declare module '@sage/x3-master-data/lib/enums/open-item-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OpenItemTypeEnum {
	    openItem = 1,
	    prepayment = 2,
	    holdback = 3
	}
	export interface OpenItemType$EnumInterface {
	    openItem: 1;
	    prepayment: 2;
	    holdback: 3;
	}
	export type OpenItemType = keyof OpenItemType$EnumInterface;
	export const openItemTypeDatatype: X3EnumDataType<keyof OpenItemType$EnumInterface, unknown>;
	//# sourceMappingURL=open-item-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/open-item-selection.d.ts
declare module '@sage/x3-master-data/lib/enums/open-item-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OpenItemSelectionEnum {
	    none1 = 1,
	    partial = 2,
	    total = 3,
	    dimensionAxis1 = 4,
	    dimensionAxis2 = 5,
	    dimensionAxis3 = 6,
	    dimensionAxis4 = 7,
	    dimensionAxis5 = 8,
	    dimensionAxis6 = 9,
	    dimensionAxis7 = 10,
	    dimensionAxis8 = 11,
	    dimensionAxis9 = 12,
	    none = 13
	}
	export interface OpenItemSelection$EnumInterface {
	    none1: 1;
	    partial: 2;
	    total: 3;
	    dimensionAxis1: 4;
	    dimensionAxis2: 5;
	    dimensionAxis3: 6;
	    dimensionAxis4: 7;
	    dimensionAxis5: 8;
	    dimensionAxis6: 9;
	    dimensionAxis7: 10;
	    dimensionAxis8: 11;
	    dimensionAxis9: 12;
	    none: 13;
	}
	export type OpenItemSelection = keyof OpenItemSelection$EnumInterface;
	export const openItemSelectionDatatype: X3EnumDataType<keyof OpenItemSelection$EnumInterface, unknown>;
	//# sourceMappingURL=open-item-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/old-planner-email-text.d.ts
declare module '@sage/x3-master-data/lib/enums/old-planner-email-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OldPlannerEmailTextEnum {
	    changeRequestToPlan1 = 1,
	    youAreNoLongerAssignedAsThePlannerForThisChangeRequest = 2,
	    toViewThePlanClickTheLink = 3
	}
	export interface OldPlannerEmailText$EnumInterface {
	    changeRequestToPlan1: 1;
	    youAreNoLongerAssignedAsThePlannerForThisChangeRequest: 2;
	    toViewThePlanClickTheLink: 3;
	}
	export type OldPlannerEmailText = keyof OldPlannerEmailText$EnumInterface;
	export const oldPlannerEmailTextDatatype: X3EnumDataType<keyof OldPlannerEmailText$EnumInterface, unknown>;
	//# sourceMappingURL=old-planner-email-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/old-change-manager-email-text.d.ts
declare module '@sage/x3-master-data/lib/enums/old-change-manager-email-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OldChangeManagerEmailTextEnum {
	    changeRequestToManage1 = 1,
	    youAreNoLongerTheChangeManagerForThisChangeRequest = 2,
	    toViewTheChangeRequestClickTheLink = 3
	}
	export interface OldChangeManagerEmailText$EnumInterface {
	    changeRequestToManage1: 1;
	    youAreNoLongerTheChangeManagerForThisChangeRequest: 2;
	    toViewTheChangeRequestClickTheLink: 3;
	}
	export type OldChangeManagerEmailText = keyof OldChangeManagerEmailText$EnumInterface;
	export const oldChangeManagerEmailTextDatatype: X3EnumDataType<keyof OldChangeManagerEmailText$EnumInterface, unknown>;
	//# sourceMappingURL=old-change-manager-email-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/old-approver-email-text.d.ts
declare module '@sage/x3-master-data/lib/enums/old-approver-email-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OldApproverEmailTextEnum {
	    changeRequestToApprove1 = 1,
	    youAreNoLongerAssignedAsAnApproverForThisChangeRequest = 2,
	    youAreNoLongerAnApproverForTheEntities = 3,
	    toViewTheChangeRequestClickTheLink = 4
	}
	export interface OldApproverEmailText$EnumInterface {
	    changeRequestToApprove1: 1;
	    youAreNoLongerAssignedAsAnApproverForThisChangeRequest: 2;
	    youAreNoLongerAnApproverForTheEntities: 3;
	    toViewTheChangeRequestClickTheLink: 4;
	}
	export type OldApproverEmailText = keyof OldApproverEmailText$EnumInterface;
	export const oldApproverEmailTextDatatype: X3EnumDataType<keyof OldApproverEmailText$EnumInterface, unknown>;
	//# sourceMappingURL=old-approver-email-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/object-to-be-processed-recodi.d.ts
declare module '@sage/x3-master-data/lib/enums/object-to-be-processed-recodi' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ObjectToBeProcessedRecodiEnum {
	    assets = 1,
	    expenses = 2,
	    fundingContracts = 3,
	    subsidies = 4,
	    physicalAssetCountNotes = 5
	}
	export interface ObjectToBeProcessedRecodi$EnumInterface {
	    assets: 1;
	    expenses: 2;
	    fundingContracts: 3;
	    subsidies: 4;
	    physicalAssetCountNotes: 5;
	}
	export type ObjectToBeProcessedRecodi = keyof ObjectToBeProcessedRecodi$EnumInterface;
	export const objectToBeProcessedRecodiDatatype: X3EnumDataType<keyof ObjectToBeProcessedRecodi$EnumInterface, unknown>;
	//# sourceMappingURL=object-to-be-processed-recodi.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/object-creation-origin.d.ts
declare module '@sage/x3-master-data/lib/enums/object-creation-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ObjectCreationOriginEnum {
	    transactionalEntry = 1,
	    split = 2,
	    return = 3,
	    interface = 4,
	    others = 5,
	    intraGroupSale = 6,
	    automaticCreation = 7,
	    expenseGrouping = 8
	}
	export interface ObjectCreationOrigin$EnumInterface {
	    transactionalEntry: 1;
	    split: 2;
	    return: 3;
	    interface: 4;
	    others: 5;
	    intraGroupSale: 6;
	    automaticCreation: 7;
	    expenseGrouping: 8;
	}
	export type ObjectCreationOrigin = keyof ObjectCreationOrigin$EnumInterface;
	export const objectCreationOriginDatatype: X3EnumDataType<keyof ObjectCreationOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=object-creation-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/notes-pr-sorting.d.ts
declare module '@sage/x3-master-data/lib/enums/notes-pr-sorting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NotesPRSortingEnum {
	    openItemsBPs = 1,
	    bPsOpenItems = 2,
	    bankOpenItemsBPs = 3
	}
	export interface NotesPRSorting$EnumInterface {
	    openItemsBPs: 1;
	    bPsOpenItems: 2;
	    bankOpenItemsBPs: 3;
	}
	export type NotesPRSorting = keyof NotesPRSorting$EnumInterface;
	export const notesPrSortingDatatype: X3EnumDataType<keyof NotesPRSorting$EnumInterface, unknown>;
	//# sourceMappingURL=notes-pr-sorting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/notes-functions.d.ts
declare module '@sage/x3-master-data/lib/enums/notes-functions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NotesFunctionsEnum {
	    salesQuotes = 1,
	    salesOrders = 2,
	    shipments = 3,
	    salesInvoices = 4,
	    salesOpenOrders = 5,
	    customerBpInvoices = 6,
	    supplierBpInvoices = 7,
	    purchaseRequest = 8,
	    purchaseOrders = 9,
	    purchaseOpenOrders = 10,
	    purchaseReceipts = 11,
	    purchaseInvoices = 12,
	    subcontractOrders = 13,
	    rfQs = 14,
	    workOrders = 15,
	    boMs = 16,
	    multilevelPlanning = 17,
	    tasks = 18,
	    calls = 19,
	    appointment = 20,
	    projects = 21,
	    serviceRequests = 22,
	    installedBase = 23,
	    warrantyRequests = 24,
	    serviceContracts = 25,
	    serviceResponses = 26
	}
	export interface NotesFunctions$EnumInterface {
	    salesQuotes: 1;
	    salesOrders: 2;
	    shipments: 3;
	    salesInvoices: 4;
	    salesOpenOrders: 5;
	    customerBpInvoices: 6;
	    supplierBpInvoices: 7;
	    purchaseRequest: 8;
	    purchaseOrders: 9;
	    purchaseOpenOrders: 10;
	    purchaseReceipts: 11;
	    purchaseInvoices: 12;
	    subcontractOrders: 13;
	    rfQs: 14;
	    workOrders: 15;
	    boMs: 16;
	    multilevelPlanning: 17;
	    tasks: 18;
	    calls: 19;
	    appointment: 20;
	    projects: 21;
	    serviceRequests: 22;
	    installedBase: 23;
	    warrantyRequests: 24;
	    serviceContracts: 25;
	    serviceResponses: 26;
	}
	export type NotesFunctions = keyof NotesFunctions$EnumInterface;
	export const notesFunctionsDatatype: X3EnumDataType<keyof NotesFunctions$EnumInterface, unknown>;
	//# sourceMappingURL=notes-functions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/notes-categories.d.ts
declare module '@sage/x3-master-data/lib/enums/notes-categories' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NotesCategoriesEnum {
	    product = 1,
	    customer = 2,
	    supplier = 3
	}
	export interface NotesCategories$EnumInterface {
	    product: 1;
	    customer: 2;
	    supplier: 3;
	}
	export type NotesCategories = keyof NotesCategories$EnumInterface;
	export const notesCategoriesDatatype: X3EnumDataType<keyof NotesCategories$EnumInterface, unknown>;
	//# sourceMappingURL=notes-categories.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/not.d.ts
declare module '@sage/x3-master-data/lib/enums/not' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NotEnum {
	    substituteValue1 = 1,
	    not = 2
	}
	export interface Not$EnumInterface {
	    substituteValue1: 1;
	    not: 2;
	}
	export type Not = keyof Not$EnumInterface;
	export const notDatatype: X3EnumDataType<keyof Not$EnumInterface, unknown>;
	//# sourceMappingURL=not.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/non-conformance-origin.d.ts
declare module '@sage/x3-master-data/lib/enums/non-conformance-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NonConformanceOriginEnum {
	    select = 1,
	    customer = 2,
	    supplier = 3,
	    internal = 4,
	    external = 5
	}
	export interface NonConformanceOrigin$EnumInterface {
	    select: 1;
	    customer: 2;
	    supplier: 3;
	    internal: 4;
	    external: 5;
	}
	export type NonConformanceOrigin = keyof NonConformanceOrigin$EnumInterface;
	export const nonConformanceOriginDatatype: X3EnumDataType<keyof NonConformanceOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=non-conformance-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/non-conformance-document.d.ts
declare module '@sage/x3-master-data/lib/enums/non-conformance-document' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NonConformanceDocumentEnum {
	    purchaseReceipt = 1,
	    customerReturn = 2,
	    productionTracking = 3,
	    qualityControl = 4,
	    operationTrackingResource = 5,
	    operationTrackingProcess = 6
	}
	export interface NonConformanceDocument$EnumInterface {
	    purchaseReceipt: 1;
	    customerReturn: 2;
	    productionTracking: 3;
	    qualityControl: 4;
	    operationTrackingResource: 5;
	    operationTrackingProcess: 6;
	}
	export type NonConformanceDocument = keyof NonConformanceDocument$EnumInterface;
	export const nonConformanceDocumentDatatype: X3EnumDataType<keyof NonConformanceDocument$EnumInterface, unknown>;
	//# sourceMappingURL=non-conformance-document.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/non-conformance-creation-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/non-conformance-creation-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NonConformanceCreationModeEnum {
	    basic = 1,
	    full = 2
	}
	export interface NonConformanceCreationMode$EnumInterface {
	    basic: 1;
	    full: 2;
	}
	export type NonConformanceCreationMode = keyof NonConformanceCreationMode$EnumInterface;
	export const nonConformanceCreationModeDatatype: X3EnumDataType<keyof NonConformanceCreationMode$EnumInterface, unknown>;
	//# sourceMappingURL=non-conformance-creation-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/no-yes-on-request.d.ts
declare module '@sage/x3-master-data/lib/enums/no-yes-on-request' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NoYesOnRequestEnum {
	    no = 1,
	    yes = 2,
	    onRequest = 3
	}
	export interface NoYesOnRequest$EnumInterface {
	    no: 1;
	    yes: 2;
	    onRequest: 3;
	}
	export type NoYesOnRequest = keyof NoYesOnRequest$EnumInterface;
	export const noYesOnRequestDatatype: X3EnumDataType<keyof NoYesOnRequest$EnumInterface, unknown>;
	//# sourceMappingURL=no-yes-on-request.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/no-yes-all.d.ts
declare module '@sage/x3-master-data/lib/enums/no-yes-all' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NoYesAllEnum {
	    no = 1,
	    yes = 2,
	    all = 3
	}
	export interface NoYesAll$EnumInterface {
	    no: 1;
	    yes: 2;
	    all: 3;
	}
	export type NoYesAll = keyof NoYesAll$EnumInterface;
	export const noYesAllDatatype: X3EnumDataType<keyof NoYesAll$EnumInterface, unknown>;
	//# sourceMappingURL=no-yes-all.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/no-in-part-in-full.d.ts
declare module '@sage/x3-master-data/lib/enums/no-in-part-in-full' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NoInPartInFullEnum {
	    no = 1,
	    inPart = 2,
	    inFull = 3,
	    notManaged = 4,
	    automatic = 5
	}
	export interface NoInPartInFull$EnumInterface {
	    no: 1;
	    inPart: 2;
	    inFull: 3;
	    notManaged: 4;
	    automatic: 5;
	}
	export type NoInPartInFull = keyof NoInPartInFull$EnumInterface;
	export const noInPartInFullDatatype: X3EnumDataType<keyof NoInPartInFull$EnumInterface, unknown>;
	//# sourceMappingURL=no-in-part-in-full.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/new-planner-email-text.d.ts
declare module '@sage/x3-master-data/lib/enums/new-planner-email-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NewPlannerEmailTextEnum {
	    changeRequestToPlan1 = 1,
	    youAreAssignedAsThePlannerForThisChangeRequest = 2,
	    toViewThePlanClickTheLink = 3
	}
	export interface NewPlannerEmailText$EnumInterface {
	    changeRequestToPlan1: 1;
	    youAreAssignedAsThePlannerForThisChangeRequest: 2;
	    toViewThePlanClickTheLink: 3;
	}
	export type NewPlannerEmailText = keyof NewPlannerEmailText$EnumInterface;
	export const newPlannerEmailTextDatatype: X3EnumDataType<keyof NewPlannerEmailText$EnumInterface, unknown>;
	//# sourceMappingURL=new-planner-email-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/new-change-manager-email-text.d.ts
declare module '@sage/x3-master-data/lib/enums/new-change-manager-email-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NewChangeManagerEmailTextEnum {
	    changeRequestToManage1 = 1,
	    youAreAssignedAsTheChangeManagerForThisChangeRequest = 2,
	    toViewTheChangeRequestClickTheLink = 3
	}
	export interface NewChangeManagerEmailText$EnumInterface {
	    changeRequestToManage1: 1;
	    youAreAssignedAsTheChangeManagerForThisChangeRequest: 2;
	    toViewTheChangeRequestClickTheLink: 3;
	}
	export type NewChangeManagerEmailText = keyof NewChangeManagerEmailText$EnumInterface;
	export const newChangeManagerEmailTextDatatype: X3EnumDataType<keyof NewChangeManagerEmailText$EnumInterface, unknown>;
	//# sourceMappingURL=new-change-manager-email-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/new-approver-email-text.d.ts
declare module '@sage/x3-master-data/lib/enums/new-approver-email-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NewApproverEmailTextEnum {
	    changeRequestToApprove1 = 1,
	    youAreAssignedAsAnApproverForThisChangeRequest = 2,
	    youAreAnApproverForTheEntities = 3,
	    toViewTheChangeRequestClickTheLink = 4
	}
	export interface NewApproverEmailText$EnumInterface {
	    changeRequestToApprove1: 1;
	    youAreAssignedAsAnApproverForThisChangeRequest: 2;
	    youAreAnApproverForTheEntities: 3;
	    toViewTheChangeRequestClickTheLink: 4;
	}
	export type NewApproverEmailText = keyof NewApproverEmailText$EnumInterface;
	export const newApproverEmailTextDatatype: X3EnumDataType<keyof NewApproverEmailText$EnumInterface, unknown>;
	//# sourceMappingURL=new-approver-email-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/nature-chosen-for-reevaluation.d.ts
declare module '@sage/x3-master-data/lib/enums/nature-chosen-for-reevaluation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NatureChosenForReevaluationEnum {
	    assetGroup = 1,
	    accountingCode = 2
	}
	export interface NatureChosenForReevaluation$EnumInterface {
	    assetGroup: 1;
	    accountingCode: 2;
	}
	export type NatureChosenForReevaluation = keyof NatureChosenForReevaluation$EnumInterface;
	export const natureChosenForReevaluationDatatype: X3EnumDataType<keyof NatureChosenForReevaluation$EnumInterface, unknown>;
	//# sourceMappingURL=nature-chosen-for-reevaluation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/name-structure.d.ts
declare module '@sage/x3-master-data/lib/enums/name-structure' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NameStructureEnum {
	    fileName = 1,
	    mainKey = 2,
	    mergeKey = 3,
	    date = 4,
	    time = 5,
	    constant = 6,
	    batchNumber = 7,
	    extension = 8,
	    month = 9,
	    year = 10,
	    day = 11
	}
	export interface NameStructure$EnumInterface {
	    fileName: 1;
	    mainKey: 2;
	    mergeKey: 3;
	    date: 4;
	    time: 5;
	    constant: 6;
	    batchNumber: 7;
	    extension: 8;
	    month: 9;
	    year: 10;
	    day: 11;
	}
	export type NameStructure = keyof NameStructure$EnumInterface;
	export const nameStructureDatatype: X3EnumDataType<keyof NameStructure$EnumInterface, unknown>;
	//# sourceMappingURL=name-structure.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/multip-copy-ext-doc-management.d.ts
declare module '@sage/x3-master-data/lib/enums/multip-copy-ext-doc-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MultipCopyExtDocManagementEnum {
	    original = 1,
	    duplicate = 2,
	    triplicate = 3,
	    quadruplicate = 4,
	    quintuplicate = 5,
	    additionalCopy = 6
	}
	export interface MultipCopyExtDocManagement$EnumInterface {
	    original: 1;
	    duplicate: 2;
	    triplicate: 3;
	    quadruplicate: 4;
	    quintuplicate: 5;
	    additionalCopy: 6;
	}
	export type MultipCopyExtDocManagement = keyof MultipCopyExtDocManagement$EnumInterface;
	export const multipCopyExtDocManagementDatatype: X3EnumDataType<keyof MultipCopyExtDocManagement$EnumInterface, unknown>;
	//# sourceMappingURL=multip-copy-ext-doc-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/movements-and-flows.d.ts
declare module '@sage/x3-master-data/lib/enums/movements-and-flows' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MovementsAndFlowsEnum {
	    standardDelivery = 1,
	    intercompanyDelivery = 2,
	    loanDelivery = 3,
	    deliveryForSubcontracting = 4,
	    intersiteDelivery = 5,
	    exportDeliveryWithForwardingAgent = 6,
	    directOrderDelivery = 7,
	    standardReceipt = 8,
	    subcontractReceipt = 9,
	    intersiteReceipt = 10,
	    intercompanyReceipt = 11,
	    customerReturn = 12,
	    loanReturn = 13,
	    supplierReturn = 14,
	    salesInvoices = 15,
	    salesCreditMemos = 16,
	    loanInvoices = 17,
	    freeProductDelivery = 18,
	    subcontractMaterialReturn = 19,
	    receiptForSubcontracting = 20,
	    subcontractDelivery = 21,
	    subcontractEndProductSupplierReturn = 22,
	    materialForSubcontractSupplierReturn = 23,
	    subcontractEndProductCustomerReturn = 24,
	    nonbillableDelivery = 25,
	    nonbillableReturn = 26
	}
	export interface MovementsAndFlows$EnumInterface {
	    standardDelivery: 1;
	    intercompanyDelivery: 2;
	    loanDelivery: 3;
	    deliveryForSubcontracting: 4;
	    intersiteDelivery: 5;
	    exportDeliveryWithForwardingAgent: 6;
	    directOrderDelivery: 7;
	    standardReceipt: 8;
	    subcontractReceipt: 9;
	    intersiteReceipt: 10;
	    intercompanyReceipt: 11;
	    customerReturn: 12;
	    loanReturn: 13;
	    supplierReturn: 14;
	    salesInvoices: 15;
	    salesCreditMemos: 16;
	    loanInvoices: 17;
	    freeProductDelivery: 18;
	    subcontractMaterialReturn: 19;
	    receiptForSubcontracting: 20;
	    subcontractDelivery: 21;
	    subcontractEndProductSupplierReturn: 22;
	    materialForSubcontractSupplierReturn: 23;
	    subcontractEndProductCustomerReturn: 24;
	    nonbillableDelivery: 25;
	    nonbillableReturn: 26;
	}
	export type MovementsAndFlows = keyof MovementsAndFlows$EnumInterface;
	export const movementsAndFlowsDatatype: X3EnumDataType<keyof MovementsAndFlows$EnumInterface, unknown>;
	//# sourceMappingURL=movements-and-flows.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/movement-type.d.ts
declare module '@sage/x3-master-data/lib/enums/movement-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MovementTypeEnum {
	    disposal = 1,
	    transfer = 2,
	    allocationChange = 3,
	    methodChange = 4,
	    modification = 5,
	    all = 6
	}
	export interface MovementType$EnumInterface {
	    disposal: 1;
	    transfer: 2;
	    allocationChange: 3;
	    methodChange: 4;
	    modification: 5;
	    all: 6;
	}
	export type MovementType = keyof MovementType$EnumInterface;
	export const movementTypeDatatype: X3EnumDataType<keyof MovementType$EnumInterface, unknown>;
	//# sourceMappingURL=movement-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/movement-status.d.ts
declare module '@sage/x3-master-data/lib/enums/movement-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MovementStatusEnum {
	    toBeProcessed = 1,
	    importInProgress = 2,
	    archived = 3,
	    rejected = 4
	}
	export interface MovementStatus$EnumInterface {
	    toBeProcessed: 1;
	    importInProgress: 2;
	    archived: 3;
	    rejected: 4;
	}
	export type MovementStatus = keyof MovementStatus$EnumInterface;
	export const movementStatusDatatype: X3EnumDataType<keyof MovementStatus$EnumInterface, unknown>;
	//# sourceMappingURL=movement-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/movement-origin.d.ts
declare module '@sage/x3-master-data/lib/enums/movement-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MovementOriginEnum {
	    import = 1,
	    screenEntry = 2,
	    other = 3
	}
	export interface MovementOrigin$EnumInterface {
	    import: 1;
	    screenEntry: 2;
	    other: 3;
	}
	export type MovementOrigin = keyof MovementOrigin$EnumInterface;
	export const movementOriginDatatype: X3EnumDataType<keyof MovementOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=movement-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/movement-import.d.ts
declare module '@sage/x3-master-data/lib/enums/movement-import' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MovementImportEnum {
	    errorInTheRowMax1 = 1,
	    invalidNumericFormat12 = 2,
	    invalidDateFormat12 = 3,
	    impossibleToSelectSeveralObjectTypesWithSelectionRanges = 4,
	    movement1 = 5,
	    errorInObjectMovementType1 = 6,
	    nonExistentObject = 7,
	    previousMovementInErrorObjectNotProcessed = 8,
	    substituteValue9 = 9,
	    expenseNotRead12 = 10,
	    assedNotRead1 = 11,
	    modificationImpossibleIssuedAsset = 12,
	    physicalAssetNotRead1 = 13,
	    substituteValue14 = 14,
	    fieldValue12NotSpecifiedInMiscellaneousTableNo3 = 15,
	    failureUponUpdateOf1 = 16,
	    nonExistentField1 = 17,
	    disposalCancellationImpossibleAssetNotDisposedOf = 18,
	    disposalImpossibleAssetAlreadyDisposedOf = 19,
	    transferCancellationImpossibleNonTransferredAsset = 20,
	    transferCancellationImpossibleIssuedAsset = 21,
	    transferImpossibleIssuedAsset = 22,
	    planNo1NotFound = 23,
	    field1CannotBeModifiedValue2 = 24,
	    noFieldSetUp = 25,
	    field12 = 26,
	    companyMandatory = 27,
	    siteMandatory = 28,
	    updated = 29,
	    notUpdated = 30,
	    analyticalDimensionType1NotFound = 31,
	    objectLocked = 32,
	    movementLockedIdmvt1 = 33,
	    limitedRights = 34,
	    someMovementsMayNotBeIntegrated = 35,
	    depreciationPlanNotSelectedForField1Value2 = 36,
	    before = 37,
	    after = 38,
	    splitAsset = 39,
	    generatedAssetS = 40,
	    index1ForSection2GreaterThanTheNumberOfAssetsCreated3 = 41,
	    dateFormat = 42,
	    decimalSeparator = 43,
	    splitExpenseS = 44,
	    generatedExpenseS = 45,
	    splitImpossibleAssetLinkedToAPhysicalAsset = 46
	}
	export interface MovementImport$EnumInterface {
	    errorInTheRowMax1: 1;
	    invalidNumericFormat12: 2;
	    invalidDateFormat12: 3;
	    impossibleToSelectSeveralObjectTypesWithSelectionRanges: 4;
	    movement1: 5;
	    errorInObjectMovementType1: 6;
	    nonExistentObject: 7;
	    previousMovementInErrorObjectNotProcessed: 8;
	    substituteValue9: 9;
	    expenseNotRead12: 10;
	    assedNotRead1: 11;
	    modificationImpossibleIssuedAsset: 12;
	    physicalAssetNotRead1: 13;
	    substituteValue14: 14;
	    fieldValue12NotSpecifiedInMiscellaneousTableNo3: 15;
	    failureUponUpdateOf1: 16;
	    nonExistentField1: 17;
	    disposalCancellationImpossibleAssetNotDisposedOf: 18;
	    disposalImpossibleAssetAlreadyDisposedOf: 19;
	    transferCancellationImpossibleNonTransferredAsset: 20;
	    transferCancellationImpossibleIssuedAsset: 21;
	    transferImpossibleIssuedAsset: 22;
	    planNo1NotFound: 23;
	    field1CannotBeModifiedValue2: 24;
	    noFieldSetUp: 25;
	    field12: 26;
	    companyMandatory: 27;
	    siteMandatory: 28;
	    updated: 29;
	    notUpdated: 30;
	    analyticalDimensionType1NotFound: 31;
	    objectLocked: 32;
	    movementLockedIdmvt1: 33;
	    limitedRights: 34;
	    someMovementsMayNotBeIntegrated: 35;
	    depreciationPlanNotSelectedForField1Value2: 36;
	    before: 37;
	    after: 38;
	    splitAsset: 39;
	    generatedAssetS: 40;
	    index1ForSection2GreaterThanTheNumberOfAssetsCreated3: 41;
	    dateFormat: 42;
	    decimalSeparator: 43;
	    splitExpenseS: 44;
	    generatedExpenseS: 45;
	    splitImpossibleAssetLinkedToAPhysicalAsset: 46;
	}
	export type MovementImport = keyof MovementImport$EnumInterface;
	export const movementImportDatatype: X3EnumDataType<keyof MovementImport$EnumInterface, unknown>;
	//# sourceMappingURL=movement-import.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/months-of-the-year.d.ts
declare module '@sage/x3-master-data/lib/enums/months-of-the-year' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MonthsOfTheYearEnum {
	    january = 1,
	    february = 2,
	    march = 3,
	    april = 4,
	    may = 5,
	    june = 6,
	    july = 7,
	    august = 8,
	    september = 9,
	    october = 10,
	    november = 11,
	    december = 12
	}
	export interface MonthsOfTheYear$EnumInterface {
	    january: 1;
	    february: 2;
	    march: 3;
	    april: 4;
	    may: 5;
	    june: 6;
	    july: 7;
	    august: 8;
	    september: 9;
	    october: 10;
	    november: 11;
	    december: 12;
	}
	export type MonthsOfTheYear = keyof MonthsOfTheYear$EnumInterface;
	export const monthsOfTheYearDatatype: X3EnumDataType<keyof MonthsOfTheYear$EnumInterface, unknown>;
	//# sourceMappingURL=months-of-the-year.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/mode.d.ts
declare module '@sage/x3-master-data/lib/enums/mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ModeEnum {
	    manual = 1,
	    automatic = 2
	}
	export interface Mode$EnumInterface {
	    manual: 1;
	    automatic: 2;
	}
	export type Mode = keyof Mode$EnumInterface;
	export const modeDatatype: X3EnumDataType<keyof Mode$EnumInterface, unknown>;
	//# sourceMappingURL=mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/miscellaneous-dimensions.d.ts
declare module '@sage/x3-master-data/lib/enums/miscellaneous-dimensions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MiscellaneousDimensionsEnum {
	    intermediateDimensionForAllocation = 1
	}
	export interface MiscellaneousDimensions$EnumInterface {
	    intermediateDimensionForAllocation: 1;
	}
	export type MiscellaneousDimensions = keyof MiscellaneousDimensions$EnumInterface;
	export const miscellaneousDimensionsDatatype: X3EnumDataType<"intermediateDimensionForAllocation", unknown>;
	//# sourceMappingURL=miscellaneous-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/miscellaneous-accounts.d.ts
declare module '@sage/x3-master-data/lib/enums/miscellaneous-accounts' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MiscellaneousAccountsEnum {
	    suspenseAccountConso = 1,
	    defaultAccount = 2,
	    overflowOffsetAccount = 3,
	    carryForwardAccount = 4,
	    debitBalanceDecrease = 5,
	    debitBalanceIncrease = 6,
	    creditBalanceDecrease = 7,
	    creditBalanceIncrease = 8,
	    exchangeGain = 9,
	    exchangeLoss = 10,
	    profitAndLossAccounts = 11,
	    debtorRoundingVariance = 12,
	    creditorRoundingVariance = 13,
	    roundingGainMatching = 14,
	    roundingLossMatching = 15,
	    suspenseAccountForCashCurrencyMOs = 16,
	    suspenseAccountForCurrency = 17,
	    unpaidExpenseAccount = 18
	}
	export interface MiscellaneousAccounts$EnumInterface {
	    suspenseAccountConso: 1;
	    defaultAccount: 2;
	    overflowOffsetAccount: 3;
	    carryForwardAccount: 4;
	    debitBalanceDecrease: 5;
	    debitBalanceIncrease: 6;
	    creditBalanceDecrease: 7;
	    creditBalanceIncrease: 8;
	    exchangeGain: 9;
	    exchangeLoss: 10;
	    profitAndLossAccounts: 11;
	    debtorRoundingVariance: 12;
	    creditorRoundingVariance: 13;
	    roundingGainMatching: 14;
	    roundingLossMatching: 15;
	    suspenseAccountForCashCurrencyMOs: 16;
	    suspenseAccountForCurrency: 17;
	    unpaidExpenseAccount: 18;
	}
	export type MiscellaneousAccounts = keyof MiscellaneousAccounts$EnumInterface;
	export const miscellaneousAccountsDatatype: X3EnumDataType<keyof MiscellaneousAccounts$EnumInterface, unknown>;
	//# sourceMappingURL=miscellaneous-accounts.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/misc-info-processing-option.d.ts
declare module '@sage/x3-master-data/lib/enums/misc-info-processing-option' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MiscInfoProcessingOptionEnum {
	    doNotTakeIntoAccount = 1,
	    forActionCodesValidatedAndRefused = 2,
	    onlyForTheActionCodeValidated = 3
	}
	export interface MiscInfoProcessingOption$EnumInterface {
	    doNotTakeIntoAccount: 1;
	    forActionCodesValidatedAndRefused: 2;
	    onlyForTheActionCodeValidated: 3;
	}
	export type MiscInfoProcessingOption = keyof MiscInfoProcessingOption$EnumInterface;
	export const miscInfoProcessingOptionDatatype: X3EnumDataType<keyof MiscInfoProcessingOption$EnumInterface, unknown>;
	//# sourceMappingURL=misc-info-processing-option.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/milleage-bracket.d.ts
declare module '@sage/x3-master-data/lib/enums/milleage-bracket' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MilleageBracketEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3
	}
	export interface MilleageBracket$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	}
	export type MilleageBracket = keyof MilleageBracket$EnumInterface;
	export const milleageBracketDatatype: X3EnumDataType<keyof MilleageBracket$EnumInterface, unknown>;
	//# sourceMappingURL=milleage-bracket.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/migration-parameters.d.ts
declare module '@sage/x3-master-data/lib/enums/migration-parameters' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MigrationParametersEnum {
	    no = 1,
	    yes = 2,
	    toBeDefined = 3
	}
	export interface MigrationParameters$EnumInterface {
	    no: 1;
	    yes: 2;
	    toBeDefined: 3;
	}
	export type MigrationParameters = keyof MigrationParameters$EnumInterface;
	export const migrationParametersDatatype: X3EnumDataType<keyof MigrationParameters$EnumInterface, unknown>;
	//# sourceMappingURL=migration-parameters.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/migration-parameters-3118.d.ts
declare module '@sage/x3-master-data/lib/enums/migration-parameters-3118' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MigrationParameters3118Enum {
	    temporary = 1,
	    final = 2,
	    toBeDefined = 3
	}
	export interface MigrationParameters3118$EnumInterface {
	    temporary: 1;
	    final: 2;
	    toBeDefined: 3;
	}
	export type MigrationParameters3118 = keyof MigrationParameters3118$EnumInterface;
	export const migrationParameters3118Datatype: X3EnumDataType<keyof MigrationParameters3118$EnumInterface, unknown>;
	//# sourceMappingURL=migration-parameters-3118.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/method.d.ts
declare module '@sage/x3-master-data/lib/enums/method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MethodEnum {
	    clientServer = 1,
	    web = 2
	}
	export interface Method$EnumInterface {
	    clientServer: 1;
	    web: 2;
	}
	export type Method = keyof Method$EnumInterface;
	export const methodDatatype: X3EnumDataType<keyof Method$EnumInterface, unknown>;
	//# sourceMappingURL=method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/method-change-effective-date.d.ts
declare module '@sage/x3-master-data/lib/enums/method-change-effective-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MethodChangeEffectiveDateEnum {
	    depreciationStart = 1,
	    fyStart = 2,
	    periodStart = 3
	}
	export interface MethodChangeEffectiveDate$EnumInterface {
	    depreciationStart: 1;
	    fyStart: 2;
	    periodStart: 3;
	}
	export type MethodChangeEffectiveDate = keyof MethodChangeEffectiveDate$EnumInterface;
	export const methodChangeEffectiveDateDatatype: X3EnumDataType<keyof MethodChangeEffectiveDate$EnumInterface, unknown>;
	//# sourceMappingURL=method-change-effective-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/methd-chge-variance-recovery.d.ts
declare module '@sage/x3-master-data/lib/enums/methd-chge-variance-recovery' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MethdChgeVarianceRecoveryEnum {
	    carryforward = 1,
	    exceptionalDepreFiscalYear = 2,
	    exceptionalDeprePeriod = 3,
	    chargeFiscalYear = 4,
	    chargePeriod = 5
	}
	export interface MethdChgeVarianceRecovery$EnumInterface {
	    carryforward: 1;
	    exceptionalDepreFiscalYear: 2;
	    exceptionalDeprePeriod: 3;
	    chargeFiscalYear: 4;
	    chargePeriod: 5;
	}
	export type MethdChgeVarianceRecovery = keyof MethdChgeVarianceRecovery$EnumInterface;
	export const methdChgeVarianceRecoveryDatatype: X3EnumDataType<keyof MethdChgeVarianceRecovery$EnumInterface, unknown>;
	//# sourceMappingURL=methd-chge-variance-recovery.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/message.d.ts
declare module '@sage/x3-master-data/lib/enums/message' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MessageEnum {
	    projectStatus = 1,
	    projectTask = 2,
	    projectBudget = 3,
	    lastAdd = 4
	}
	export interface Message$EnumInterface {
	    projectStatus: 1;
	    projectTask: 2;
	    projectBudget: 3;
	    lastAdd: 4;
	}
	export type Message = keyof Message$EnumInterface;
	export const messageDatatype: X3EnumDataType<keyof Message$EnumInterface, unknown>;
	//# sourceMappingURL=message.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/message-type.d.ts
declare module '@sage/x3-master-data/lib/enums/message-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MessageTypeEnum {
	    issuedInvoices = 1,
	    receivedInvoices = 2,
	    euOperations = 3,
	    fixedAssetOperations = 4,
	    cashVatCollections = 5,
	    cashVatPayments = 6,
	    annualOperations = 7,
	    consignmentGoods = 8
	}
	export interface MessageType$EnumInterface {
	    issuedInvoices: 1;
	    receivedInvoices: 2;
	    euOperations: 3;
	    fixedAssetOperations: 4;
	    cashVatCollections: 5;
	    cashVatPayments: 6;
	    annualOperations: 7;
	    consignmentGoods: 8;
	}
	export type MessageType = keyof MessageType$EnumInterface;
	export const messageTypeDatatype: X3EnumDataType<keyof MessageType$EnumInterface, unknown>;
	//# sourceMappingURL=message-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/message-mapping-type.d.ts
declare module '@sage/x3-master-data/lib/enums/message-mapping-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MessageMappingTypeEnum {
	    query = 1,
	    attachment = 2
	}
	export interface MessageMappingType$EnumInterface {
	    query: 1;
	    attachment: 2;
	}
	export type MessageMappingType = keyof MessageMappingType$EnumInterface;
	export const messageMappingTypeDatatype: X3EnumDataType<keyof MessageMappingType$EnumInterface, unknown>;
	//# sourceMappingURL=message-mapping-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/message-file-format.d.ts
declare module '@sage/x3-master-data/lib/enums/message-file-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MessageFileFormatEnum {
	    sequential = 1,
	    xml = 2,
	    none = 3
	}
	export interface MessageFileFormat$EnumInterface {
	    sequential: 1;
	    xml: 2;
	    none: 3;
	}
	export type MessageFileFormat = keyof MessageFileFormat$EnumInterface;
	export const messageFileFormatDatatype: X3EnumDataType<keyof MessageFileFormat$EnumInterface, unknown>;
	//# sourceMappingURL=message-file-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/merge-description-field.d.ts
declare module '@sage/x3-master-data/lib/enums/merge-description-field' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MergeDescriptionFieldEnum {
	    no = 1,
	    always = 2,
	    secondPass = 3
	}
	export interface MergeDescriptionField$EnumInterface {
	    no: 1;
	    always: 2;
	    secondPass: 3;
	}
	export type MergeDescriptionField = keyof MergeDescriptionField$EnumInterface;
	export const mergeDescriptionFieldDatatype: X3EnumDataType<keyof MergeDescriptionField$EnumInterface, unknown>;
	//# sourceMappingURL=merge-description-field.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/material-replenish-type.d.ts
declare module '@sage/x3-master-data/lib/enums/material-replenish-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialReplenishTypeEnum {
	    internal = 1,
	    toBeSentToTheSubcontractor = 2,
	    suppliedByTheSubcontractor = 3
	}
	export interface MaterialReplenishType$EnumInterface {
	    internal: 1;
	    toBeSentToTheSubcontractor: 2;
	    suppliedByTheSubcontractor: 3;
	}
	export type MaterialReplenishType = keyof MaterialReplenishType$EnumInterface;
	export const materialReplenishTypeDatatype: X3EnumDataType<keyof MaterialReplenishType$EnumInterface, unknown>;
	//# sourceMappingURL=material-replenish-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/matching-option.d.ts
declare module '@sage/x3-master-data/lib/enums/matching-option' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MatchingOptionEnum {
	    allocation = 1,
	    roundingVariance = 2
	}
	export interface MatchingOption$EnumInterface {
	    allocation: 1;
	    roundingVariance: 2;
	}
	export type MatchingOption = keyof MatchingOption$EnumInterface;
	export const matchingOptionDatatype: X3EnumDataType<keyof MatchingOption$EnumInterface, unknown>;
	//# sourceMappingURL=matching-option.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/mass-mailing-type.d.ts
declare module '@sage/x3-master-data/lib/enums/mass-mailing-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MassMailingTypeEnum {
	    bPs = 1,
	    contacts = 2
	}
	export interface MassMailingType$EnumInterface {
	    bPs: 1;
	    contacts: 2;
	}
	export type MassMailingType = keyof MassMailingType$EnumInterface;
	export const massMailingTypeDatatype: X3EnumDataType<keyof MassMailingType$EnumInterface, unknown>;
	//# sourceMappingURL=mass-mailing-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/marketing-responses-type.d.ts
declare module '@sage/x3-master-data/lib/enums/marketing-responses-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MarketingResponsesTypeEnum {
	    tasks = 1,
	    calls = 2,
	    appointments = 3,
	    projects = 4,
	    salesOrders = 5,
	    directInvoices = 6
	}
	export interface MarketingResponsesType$EnumInterface {
	    tasks: 1;
	    calls: 2;
	    appointments: 3;
	    projects: 4;
	    salesOrders: 5;
	    directInvoices: 6;
	}
	export type MarketingResponsesType = keyof MarketingResponsesType$EnumInterface;
	export const marketingResponsesTypeDatatype: X3EnumDataType<keyof MarketingResponsesType$EnumInterface, unknown>;
	//# sourceMappingURL=marketing-responses-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/marketing-operation-types.d.ts
declare module '@sage/x3-master-data/lib/enums/marketing-operation-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MarketingOperationTypesEnum {
	    massMailing = 1,
	    callCampaign = 2,
	    tradeShow = 3,
	    mediaCampaign = 4,
	    substituteValue5 = 5
	}
	export interface MarketingOperationTypes$EnumInterface {
	    massMailing: 1;
	    callCampaign: 2;
	    tradeShow: 3;
	    mediaCampaign: 4;
	    substituteValue5: 5;
	}
	export type MarketingOperationTypes = keyof MarketingOperationTypes$EnumInterface;
	export const marketingOperationTypesDatatype: X3EnumDataType<keyof MarketingOperationTypes$EnumInterface, unknown>;
	//# sourceMappingURL=marketing-operation-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/manual-sector-allocation.d.ts
declare module '@sage/x3-master-data/lib/enums/manual-sector-allocation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ManualSectorAllocationEnum {
	    alwaysRetain = 1,
	    replaceOnRequest = 2,
	    alwaysReplace = 3
	}
	export interface ManualSectorAllocation$EnumInterface {
	    alwaysRetain: 1;
	    replaceOnRequest: 2;
	    alwaysReplace: 3;
	}
	export type ManualSectorAllocation = keyof ManualSectorAllocation$EnumInterface;
	export const manualSectorAllocationDatatype: X3EnumDataType<keyof ManualSectorAllocation$EnumInterface, unknown>;
	//# sourceMappingURL=manual-sector-allocation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/mandatory.d.ts
declare module '@sage/x3-master-data/lib/enums/mandatory' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MandatoryEnum {
	    optional = 1,
	    mandatory = 2,
	    warning = 3
	}
	export interface Mandatory$EnumInterface {
	    optional: 1;
	    mandatory: 2;
	    warning: 3;
	}
	export type Mandatory = keyof Mandatory$EnumInterface;
	export const mandatoryDatatype: X3EnumDataType<keyof Mandatory$EnumInterface, unknown>;
	//# sourceMappingURL=mandatory.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/mandate-status.d.ts
declare module '@sage/x3-master-data/lib/enums/mandate-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MandateStatusEnum {
	    initial = 1,
	    approved = 2,
	    adjourned = 3,
	    revoked = 4,
	    expired = 5,
	    closed = 6
	}
	export interface MandateStatus$EnumInterface {
	    initial: 1;
	    approved: 2;
	    adjourned: 3;
	    revoked: 4;
	    expired: 5;
	    closed: 6;
	}
	export type MandateStatus = keyof MandateStatus$EnumInterface;
	export const mandateStatusDatatype: X3EnumDataType<keyof MandateStatus$EnumInterface, unknown>;
	//# sourceMappingURL=mandate-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/management-unit.d.ts
declare module '@sage/x3-master-data/lib/enums/management-unit' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ManagementUnitEnum {
	    one = 1,
	    perHundred = 2,
	    perThousand = 3,
	    percentage = 4,
	    byLot = 5
	}
	export interface ManagementUnit$EnumInterface {
	    one: 1;
	    perHundred: 2;
	    perThousand: 3;
	    percentage: 4;
	    byLot: 5;
	}
	export type ManagementUnit = keyof ManagementUnit$EnumInterface;
	export const managementUnitDatatype: X3EnumDataType<keyof ManagementUnit$EnumInterface, unknown>;
	//# sourceMappingURL=management-unit.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/main-expense.d.ts
declare module '@sage/x3-master-data/lib/enums/main-expense' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MainExpenseEnum {
	    upperExclTaxAmount = 1,
	    mostRecentInvoiceDate = 2,
	    oldestInvoiceDate = 3,
	    mostRecentAccountingDate = 4,
	    oldestAccountingDate = 5
	}
	export interface MainExpense$EnumInterface {
	    upperExclTaxAmount: 1;
	    mostRecentInvoiceDate: 2;
	    oldestInvoiceDate: 3;
	    mostRecentAccountingDate: 4;
	    oldestAccountingDate: 5;
	}
	export type MainExpense = keyof MainExpense$EnumInterface;
	export const mainExpenseDatatype: X3EnumDataType<keyof MainExpense$EnumInterface, unknown>;
	//# sourceMappingURL=main-expense.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/mailing-type.d.ts
declare module '@sage/x3-master-data/lib/enums/mailing-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MailingTypeEnum {
	    sentByTextProcessing = 1,
	    sentByLabels = 2,
	    sentByEMail = 3,
	    sentByFax = 4
	}
	export interface MailingType$EnumInterface {
	    sentByTextProcessing: 1;
	    sentByLabels: 2;
	    sentByEMail: 3;
	    sentByFax: 4;
	}
	export type MailingType = keyof MailingType$EnumInterface;
	export const mailingTypeDatatype: X3EnumDataType<keyof MailingType$EnumInterface, unknown>;
	//# sourceMappingURL=mailing-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/mailing-shipment-methods.d.ts
declare module '@sage/x3-master-data/lib/enums/mailing-shipment-methods' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MailingShipmentMethodsEnum {
	    post = 1,
	    eMail = 2,
	    fax = 3,
	    xml = 4
	}
	export interface MailingShipmentMethods$EnumInterface {
	    post: 1;
	    eMail: 2;
	    fax: 3;
	    xml: 4;
	}
	export type MailingShipmentMethods = keyof MailingShipmentMethods$EnumInterface;
	export const mailingShipmentMethodsDatatype: X3EnumDataType<keyof MailingShipmentMethods$EnumInterface, unknown>;
	//# sourceMappingURL=mailing-shipment-methods.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lva-management.d.ts
declare module '@sage/x3-master-data/lib/enums/lva-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LvaManagementEnum {
	    none = 1,
	    lva = 2,
	    pool = 3
	}
	export interface LvaManagement$EnumInterface {
	    none: 1;
	    lva: 2;
	    pool: 3;
	}
	export type LvaManagement = keyof LvaManagement$EnumInterface;
	export const lvaManagementDatatype: X3EnumDataType<keyof LvaManagement$EnumInterface, unknown>;
	//# sourceMappingURL=lva-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/low-level-type.d.ts
declare module '@sage/x3-master-data/lib/enums/low-level-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LowLevelTypeEnum {
	    business = 1,
	    manufacturingSubcontracting = 2
	}
	export interface LowLevelType$EnumInterface {
	    business: 1;
	    manufacturingSubcontracting: 2;
	}
	export type LowLevelType = keyof LowLevelType$EnumInterface;
	export const lowLevelTypeDatatype: X3EnumDataType<keyof LowLevelType$EnumInterface, unknown>;
	//# sourceMappingURL=low-level-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lot-number-management.d.ts
declare module '@sage/x3-master-data/lib/enums/lot-number-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LotNumberManagementEnum {
	    notManaged = 1,
	    groupNumbering = 2,
	    genericNumbering = 3,
	    byTransaction = 4
	}
	export interface LotNumberManagement$EnumInterface {
	    notManaged: 1;
	    groupNumbering: 2;
	    genericNumbering: 3;
	    byTransaction: 4;
	}
	export type LotNumberManagement = keyof LotNumberManagement$EnumInterface;
	export const lotNumberManagementDatatype: X3EnumDataType<keyof LotNumberManagement$EnumInterface, unknown>;
	//# sourceMappingURL=lot-number-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lot-issue-expiration-ubd.d.ts
declare module '@sage/x3-master-data/lib/enums/lot-issue-expiration-ubd' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LotIssueExpirationUbdEnum {
	    noExpirationDateControl = 1,
	    noUseByDateControl = 2,
	    yes = 3
	}
	export interface LotIssueExpirationUbd$EnumInterface {
	    noExpirationDateControl: 1;
	    noUseByDateControl: 2;
	    yes: 3;
	}
	export type LotIssueExpirationUbd = keyof LotIssueExpirationUbd$EnumInterface;
	export const lotIssueExpirationUbdDatatype: X3EnumDataType<keyof LotIssueExpirationUbd$EnumInterface, unknown>;
	//# sourceMappingURL=lot-issue-expiration-ubd.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/location-type-phys-asset.d.ts
declare module '@sage/x3-master-data/lib/enums/location-type-phys-asset' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LocationTypePhysAssetEnum {
	    singleLocation = 1,
	    multipleLocation = 2
	}
	export interface LocationTypePhysAsset$EnumInterface {
	    singleLocation: 1;
	    multipleLocation: 2;
	}
	export type LocationTypePhysAsset = keyof LocationTypePhysAsset$EnumInterface;
	export const locationTypePhysAssetDatatype: X3EnumDataType<keyof LocationTypePhysAsset$EnumInterface, unknown>;
	//# sourceMappingURL=location-type-phys-asset.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/location-management.d.ts
declare module '@sage/x3-master-data/lib/enums/location-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LocationManagementEnum {
	    notManaged = 1,
	    dynamicManagement = 2,
	    accordingToTransaction = 3
	}
	export interface LocationManagement$EnumInterface {
	    notManaged: 1;
	    dynamicManagement: 2;
	    accordingToTransaction: 3;
	}
	export type LocationManagement = keyof LocationManagement$EnumInterface;
	export const locationManagementDatatype: X3EnumDataType<keyof LocationManagement$EnumInterface, unknown>;
	//# sourceMappingURL=location-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/link-direction.d.ts
declare module '@sage/x3-master-data/lib/enums/link-direction' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinkDirectionEnum {
	    towards = 1,
	    from = 2
	}
	export interface LinkDirection$EnumInterface {
	    towards: 1;
	    from: 2;
	}
	export type LinkDirection = keyof LinkDirection$EnumInterface;
	export const linkDirectionDatatype: X3EnumDataType<keyof LinkDirection$EnumInterface, unknown>;
	//# sourceMappingURL=link-direction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/line-status.d.ts
declare module '@sage/x3-master-data/lib/enums/line-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LineStatusEnum {
	    pending = 1,
	    late = 2,
	    closed = 3
	}
	export interface LineStatus$EnumInterface {
	    pending: 1;
	    late: 2;
	    closed: 3;
	}
	export type LineStatus = keyof LineStatus$EnumInterface;
	export const lineStatusDatatype: X3EnumDataType<keyof LineStatus$EnumInterface, unknown>;
	//# sourceMappingURL=line-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/line-status-3719.d.ts
declare module '@sage/x3-master-data/lib/enums/line-status-3719' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LineStatus3719Enum {
	    active = 1,
	    deactivated = 2,
	    deleted = 3
	}
	export interface LineStatus3719$EnumInterface {
	    active: 1;
	    deactivated: 2;
	    deleted: 3;
	}
	export type LineStatus3719 = keyof LineStatus3719$EnumInterface;
	export const lineStatus3719Datatype: X3EnumDataType<keyof LineStatus3719$EnumInterface, unknown>;
	//# sourceMappingURL=line-status-3719.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/line-pricing-short-descriptio.d.ts
declare module '@sage/x3-master-data/lib/enums/line-pricing-short-descriptio' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinePricingShortDescriptioEnum {
	    port = 1,
	    packaging = 2,
	    warehousing = 3,
	    d1Expenses = 4,
	    increase = 5,
	    discount1 = 6,
	    discount2 = 7,
	    discount3 = 8,
	    motorway = 9,
	    discount4 = 10
	}
	export interface LinePricingShortDescriptio$EnumInterface {
	    port: 1;
	    packaging: 2;
	    warehousing: 3;
	    d1Expenses: 4;
	    increase: 5;
	    discount1: 6;
	    discount2: 7;
	    discount3: 8;
	    motorway: 9;
	    discount4: 10;
	}
	export type LinePricingShortDescriptio = keyof LinePricingShortDescriptio$EnumInterface;
	export const linePricingShortDescriptioDatatype: X3EnumDataType<keyof LinePricingShortDescriptio$EnumInterface, unknown>;
	//# sourceMappingURL=line-pricing-short-descriptio.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/line-pricing-long-description.d.ts
declare module '@sage/x3-master-data/lib/enums/line-pricing-long-description' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinePricingLongDescriptionEnum {
	    freightLineChanges = 1,
	    linePackaging = 2,
	    storing = 3,
	    miscellaneousExpenses1 = 4,
	    increase = 5,
	    discountNumber1 = 6,
	    discountNumber2 = 7,
	    discountNumber3 = 8,
	    expressway = 9,
	    discountNumber4 = 10
	}
	export interface LinePricingLongDescription$EnumInterface {
	    freightLineChanges: 1;
	    linePackaging: 2;
	    storing: 3;
	    miscellaneousExpenses1: 4;
	    increase: 5;
	    discountNumber1: 6;
	    discountNumber2: 7;
	    discountNumber3: 8;
	    expressway: 9;
	    discountNumber4: 10;
	}
	export type LinePricingLongDescription = keyof LinePricingLongDescription$EnumInterface;
	export const linePricingLongDescriptionDatatype: X3EnumDataType<keyof LinePricingLongDescription$EnumInterface, unknown>;
	//# sourceMappingURL=line-pricing-long-description.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/life-cycle-invoice-type.d.ts
declare module '@sage/x3-master-data/lib/enums/life-cycle-invoice-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LifeCycleInvoiceTypeEnum {
	    aPInvoice = 1,
	    aRInvoice = 2,
	    purchaseInvoice = 3,
	    salesInvoice = 4,
	    manual = 5
	}
	export interface LifeCycleInvoiceType$EnumInterface {
	    aPInvoice: 1;
	    aRInvoice: 2;
	    purchaseInvoice: 3;
	    salesInvoice: 4;
	    manual: 5;
	}
	export type LifeCycleInvoiceType = keyof LifeCycleInvoiceType$EnumInterface;
	export const lifeCycleInvoiceTypeDatatype: X3EnumDataType<keyof LifeCycleInvoiceType$EnumInterface, unknown>;
	//# sourceMappingURL=life-cycle-invoice-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/life-cycle-internal-status.d.ts
declare module '@sage/x3-master-data/lib/enums/life-cycle-internal-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LifeCycleInternalStatusEnum {
	    pending = 1,
	    processed = 2
	}
	export interface LifeCycleInternalStatus$EnumInterface {
	    pending: 1;
	    processed: 2;
	}
	export type LifeCycleInternalStatus = keyof LifeCycleInternalStatus$EnumInterface;
	export const lifeCycleInternalStatusDatatype: X3EnumDataType<keyof LifeCycleInternalStatus$EnumInterface, unknown>;
	//# sourceMappingURL=life-cycle-internal-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/licence-info.d.ts
declare module '@sage/x3-master-data/lib/enums/licence-info' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LicenceInfoEnum {
	    fixedAssets = 1,
	    configurator = 2,
	    scheduling = 3,
	    optimization = 4,
	    weighingStation = 5,
	    productType = 6,
	    ias = 7
	}
	export interface LicenceInfo$EnumInterface {
	    fixedAssets: 1;
	    configurator: 2;
	    scheduling: 3;
	    optimization: 4;
	    weighingStation: 5;
	    productType: 6;
	    ias: 7;
	}
	export type LicenceInfo = keyof LicenceInfo$EnumInterface;
	export const licenceInfoDatatype: X3EnumDataType<keyof LicenceInfo$EnumInterface, unknown>;
	//# sourceMappingURL=licence-info.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/level-of-interest.d.ts
declare module '@sage/x3-master-data/lib/enums/level-of-interest' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LevelOfInterestEnum {
	    low = 1,
	    medium = 2,
	    strong = 3
	}
	export interface LevelOfInterest$EnumInterface {
	    low: 1;
	    medium: 2;
	    strong: 3;
	}
	export type LevelOfInterest = keyof LevelOfInterest$EnumInterface;
	export const levelOfInterestDatatype: X3EnumDataType<keyof LevelOfInterest$EnumInterface, unknown>;
	//# sourceMappingURL=level-of-interest.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lease-contract-type.d.ts
declare module '@sage/x3-master-data/lib/enums/lease-contract-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LeaseContractTypeEnum {
	    lease = 1,
	    longTermRent = 2,
	    rent = 3
	}
	export interface LeaseContractType$EnumInterface {
	    lease: 1;
	    longTermRent: 2;
	    rent: 3;
	}
	export type LeaseContractType = keyof LeaseContractType$EnumInterface;
	export const leaseContractTypeDatatype: X3EnumDataType<keyof LeaseContractType$EnumInterface, unknown>;
	//# sourceMappingURL=lease-contract-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lease-contract-status.d.ts
declare module '@sage/x3-master-data/lib/enums/lease-contract-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LeaseContractStatusEnum {
	    toBeValidated = 1,
	    inProcess = 2,
	    completed = 3,
	    buyback = 4,
	    terminated = 5,
	    sold = 6
	}
	export interface LeaseContractStatus$EnumInterface {
	    toBeValidated: 1;
	    inProcess: 2;
	    completed: 3;
	    buyback: 4;
	    terminated: 5;
	    sold: 6;
	}
	export type LeaseContractStatus = keyof LeaseContractStatus$EnumInterface;
	export const leaseContractStatusDatatype: X3EnumDataType<keyof LeaseContractStatus$EnumInterface, unknown>;
	//# sourceMappingURL=lease-contract-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lease-contract-source.d.ts
declare module '@sage/x3-master-data/lib/enums/lease-contract-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LeaseContractSourceEnum {
	    newContract = 1,
	    transferredContract = 2
	}
	export interface LeaseContractSource$EnumInterface {
	    newContract: 1;
	    transferredContract: 2;
	}
	export type LeaseContractSource = keyof LeaseContractSource$EnumInterface;
	export const leaseContractSourceDatatype: X3EnumDataType<keyof LeaseContractSource$EnumInterface, unknown>;
	//# sourceMappingURL=lease-contract-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lease-contract-nature.d.ts
declare module '@sage/x3-master-data/lib/enums/lease-contract-nature' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LeaseContractNatureEnum {
	    fixedAssets = 1,
	    movableAssets = 2
	}
	export interface LeaseContractNature$EnumInterface {
	    fixedAssets: 1;
	    movableAssets: 2;
	}
	export type LeaseContractNature = keyof LeaseContractNature$EnumInterface;
	export const leaseContractNatureDatatype: X3EnumDataType<keyof LeaseContractNature$EnumInterface, unknown>;
	//# sourceMappingURL=lease-contract-nature.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lease-contract-balance-sheet-line.d.ts
declare module '@sage/x3-master-data/lib/enums/lease-contract-balance-sheet-line' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LeaseContractBalanceSheetLineEnum {
	    landConstruction = 1,
	    transportEquipment = 2,
	    equipmentAndTools = 3,
	    itOfficeFurnitureEquip = 4,
	    layoutAndInstallation = 5
	}
	export interface LeaseContractBalanceSheetLine$EnumInterface {
	    landConstruction: 1;
	    transportEquipment: 2;
	    equipmentAndTools: 3;
	    itOfficeFurnitureEquip: 4;
	    layoutAndInstallation: 5;
	}
	export type LeaseContractBalanceSheetLine = keyof LeaseContractBalanceSheetLine$EnumInterface;
	export const leaseContractBalanceSheetLineDatatype: X3EnumDataType<keyof LeaseContractBalanceSheetLine$EnumInterface, unknown>;
	//# sourceMappingURL=lease-contract-balance-sheet-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lead-time-unit.d.ts
declare module '@sage/x3-master-data/lib/enums/lead-time-unit' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LeadTimeUnitEnum {
	    calendarDays = 1,
	    workDays = 2,
	    weeks = 3,
	    fortnights = 4,
	    months = 5
	}
	export interface LeadTimeUnit$EnumInterface {
	    calendarDays: 1;
	    workDays: 2;
	    weeks: 3;
	    fortnights: 4;
	    months: 5;
	}
	export type LeadTimeUnit = keyof LeadTimeUnit$EnumInterface;
	export const leadTimeUnitDatatype: X3EnumDataType<keyof LeadTimeUnit$EnumInterface, unknown>;
	//# sourceMappingURL=lead-time-unit.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lead-status.d.ts
declare module '@sage/x3-master-data/lib/enums/lead-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LeadStatusEnum {
	    disqualified = 1,
	    onHold = 2,
	    qualified = 3,
	    contacted = 4
	}
	export interface LeadStatus$EnumInterface {
	    disqualified: 1;
	    onHold: 2;
	    qualified: 3;
	    contacted: 4;
	}
	export type LeadStatus = keyof LeadStatus$EnumInterface;
	export const leadStatusDatatype: X3EnumDataType<keyof LeadStatus$EnumInterface, unknown>;
	//# sourceMappingURL=lead-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lead-management.d.ts
declare module '@sage/x3-master-data/lib/enums/lead-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LeadManagementEnum {
	    noCriteria = 1,
	    excludeLeads = 2,
	    includeLeadsOnly = 3
	}
	export interface LeadManagement$EnumInterface {
	    noCriteria: 1;
	    excludeLeads: 2;
	    includeLeadsOnly: 3;
	}
	export type LeadManagement = keyof LeadManagement$EnumInterface;
	export const leadManagementDatatype: X3EnumDataType<keyof LeadManagement$EnumInterface, unknown>;
	//# sourceMappingURL=lead-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/lead-link.d.ts
declare module '@sage/x3-master-data/lib/enums/lead-link' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LeadLinkEnum {
	    none = 1,
	    massMailing = 2,
	    callCampaign = 3,
	    tradeShow = 4,
	    mediaCampaign = 5,
	    marketingCampaign = 6
	}
	export interface LeadLink$EnumInterface {
	    none: 1;
	    massMailing: 2;
	    callCampaign: 3;
	    tradeShow: 4;
	    mediaCampaign: 5;
	    marketingCampaign: 6;
	}
	export type LeadLink = keyof LeadLink$EnumInterface;
	export const leadLinkDatatype: X3EnumDataType<keyof LeadLink$EnumInterface, unknown>;
	//# sourceMappingURL=lead-link.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/late-charges-execution-type.d.ts
declare module '@sage/x3-master-data/lib/enums/late-charges-execution-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LateChargesExecutionTypeEnum {
	    thePayment = 1,
	    byInterestNote = 2
	}
	export interface LateChargesExecutionType$EnumInterface {
	    thePayment: 1;
	    byInterestNote: 2;
	}
	export type LateChargesExecutionType = keyof LateChargesExecutionType$EnumInterface;
	export const lateChargesExecutionTypeDatatype: X3EnumDataType<keyof LateChargesExecutionType$EnumInterface, unknown>;
	//# sourceMappingURL=late-charges-execution-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/kza-localization.d.ts
declare module '@sage/x3-master-data/lib/enums/kza-localization' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum KzaLocalizationEnum {
	    paramRsacertCertificateNotDefinedFor = 1,
	    paramRsasmtpSmtpNotificationServerNotDefinedFor = 2,
	    doesNotAcceptElectronicInvoicesTransmissionCancelled = 3,
	    defaultCustomerEmailAddressNotDefined = 4,
	    errorInTransmittingDocumentTransmissionCanceled = 5,
	    transmittedTo = 6,
	    signAndEmail = 7,
	    defaultReportNotDefinedOnEntryTransaction = 8,
	    paramRsadestArchiveDestinationNotDefined = 9,
	    destinationDoesNotExist = 10,
	    destinationOutputTypeNeedsToBeArchivingAndExportFormatPdf = 11,
	    preferentialProcurementTemplateFileGeneration = 12,
	    couldNotGenerateLineForSupplier1 = 13,
	    vatNumberIsMandatory = 14,
	    registrationNumberIsMandatory = 15,
	    supplierNameIsMandatory = 16,
	    totalSpentIsEqualTo0 = 17,
	    errorUploadingFile1Status2 = 18,
	    substituteValue19 = 19,
	    substituteValue20 = 20,
	    noSupplierLinesWillBeGeneratedForCompany1DueToMandatoryFieldsBeingEmpty = 21,
	    preferentialProcurementTemplateFileGenerationForCompany1 = 22,
	    totalNumberOfCompanies1 = 23,
	    preferentialProcurementTemplateFileGenerationNotPossibleThereAreNoSupplierLines = 24,
	    thereAreNoSupplierLinesToGenerate = 25,
	    urlParameterNotSetForThisCompany = 26,
	    base64OfUsernameAndPasswordParameterNotSetForThisCompany = 27,
	    thisCompanyIsNotOfASouthAfricanLegislation = 28
	}
	export interface KzaLocalization$EnumInterface {
	    paramRsacertCertificateNotDefinedFor: 1;
	    paramRsasmtpSmtpNotificationServerNotDefinedFor: 2;
	    doesNotAcceptElectronicInvoicesTransmissionCancelled: 3;
	    defaultCustomerEmailAddressNotDefined: 4;
	    errorInTransmittingDocumentTransmissionCanceled: 5;
	    transmittedTo: 6;
	    signAndEmail: 7;
	    defaultReportNotDefinedOnEntryTransaction: 8;
	    paramRsadestArchiveDestinationNotDefined: 9;
	    destinationDoesNotExist: 10;
	    destinationOutputTypeNeedsToBeArchivingAndExportFormatPdf: 11;
	    preferentialProcurementTemplateFileGeneration: 12;
	    couldNotGenerateLineForSupplier1: 13;
	    vatNumberIsMandatory: 14;
	    registrationNumberIsMandatory: 15;
	    supplierNameIsMandatory: 16;
	    totalSpentIsEqualTo0: 17;
	    errorUploadingFile1Status2: 18;
	    substituteValue19: 19;
	    substituteValue20: 20;
	    noSupplierLinesWillBeGeneratedForCompany1DueToMandatoryFieldsBeingEmpty: 21;
	    preferentialProcurementTemplateFileGenerationForCompany1: 22;
	    totalNumberOfCompanies1: 23;
	    preferentialProcurementTemplateFileGenerationNotPossibleThereAreNoSupplierLines: 24;
	    thereAreNoSupplierLinesToGenerate: 25;
	    urlParameterNotSetForThisCompany: 26;
	    base64OfUsernameAndPasswordParameterNotSetForThisCompany: 27;
	    thisCompanyIsNotOfASouthAfricanLegislation: 28;
	}
	export type KzaLocalization = keyof KzaLocalization$EnumInterface;
	export const kzaLocalizationDatatype: X3EnumDataType<keyof KzaLocalization$EnumInterface, unknown>;
	//# sourceMappingURL=kza-localization.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/journal-entry-types.d.ts
declare module '@sage/x3-master-data/lib/enums/journal-entry-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum JournalEntryTypesEnum {
	    definitiveEntries = 1,
	    provisionalEntries = 2,
	    canceledEntries = 3,
	    allEntries = 4
	}
	export interface JournalEntryTypes$EnumInterface {
	    definitiveEntries: 1;
	    provisionalEntries: 2;
	    canceledEntries: 3;
	    allEntries: 4;
	}
	export type JournalEntryTypes = keyof JournalEntryTypes$EnumInterface;
	export const journalEntryTypesDatatype: X3EnumDataType<keyof JournalEntryTypes$EnumInterface, unknown>;
	//# sourceMappingURL=journal-entry-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/invoicing-type.d.ts
declare module '@sage/x3-master-data/lib/enums/invoicing-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicingTypeEnum {
	    accordingToCoverage = 1,
	    alwaysInvoiced = 2,
	    neverInvoiced = 3
	}
	export interface InvoicingType$EnumInterface {
	    accordingToCoverage: 1;
	    alwaysInvoiced: 2;
	    neverInvoiced: 3;
	}
	export type InvoicingType = keyof InvoicingType$EnumInterface;
	export const invoicingTypeDatatype: X3EnumDataType<keyof InvoicingType$EnumInterface, unknown>;
	//# sourceMappingURL=invoicing-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/invoicing-method-requested.d.ts
declare module '@sage/x3-master-data/lib/enums/invoicing-method-requested' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicingMethodRequestedEnum {
	    withAggregation = 1,
	    withoutAggregation = 2
	}
	export interface InvoicingMethodRequested$EnumInterface {
	    withAggregation: 1;
	    withoutAggregation: 2;
	}
	export type InvoicingMethodRequested = keyof InvoicingMethodRequested$EnumInterface;
	export const invoicingMethodRequestedDatatype: X3EnumDataType<keyof InvoicingMethodRequested$EnumInterface, unknown>;
	//# sourceMappingURL=invoicing-method-requested.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/invoicing-method-2978.d.ts
declare module '@sage/x3-master-data/lib/enums/invoicing-method-2978' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicingMethod2978Enum {
	    preInvoicingTermToMature = 1,
	    postInvoicingOverDueTerm = 2
	}
	export interface InvoicingMethod2978$EnumInterface {
	    preInvoicingTermToMature: 1;
	    postInvoicingOverDueTerm: 2;
	}
	export type InvoicingMethod2978 = keyof InvoicingMethod2978$EnumInterface;
	export const invoicingMethod2978Datatype: X3EnumDataType<keyof InvoicingMethod2978$EnumInterface, unknown>;
	//# sourceMappingURL=invoicing-method-2978.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/invoicing-element.d.ts
declare module '@sage/x3-master-data/lib/enums/invoicing-element' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicingElementEnum {
	    distributionBasedOnInvoicingElement = 1,
	    noDistribution = 2
	}
	export interface InvoicingElement$EnumInterface {
	    distributionBasedOnInvoicingElement: 1;
	    noDistribution: 2;
	}
	export type InvoicingElement = keyof InvoicingElement$EnumInterface;
	export const invoicingElementDatatype: X3EnumDataType<keyof InvoicingElement$EnumInterface, unknown>;
	//# sourceMappingURL=invoicing-element.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/invoice-unit-requested.d.ts
declare module '@sage/x3-master-data/lib/enums/invoice-unit-requested' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceUnitRequestedEnum {
	    inConsumptionUnit = 1,
	    inSalesUnit = 2
	}
	export interface InvoiceUnitRequested$EnumInterface {
	    inConsumptionUnit: 1;
	    inSalesUnit: 2;
	}
	export type InvoiceUnitRequested = keyof InvoiceUnitRequested$EnumInterface;
	export const invoiceUnitRequestedDatatype: X3EnumDataType<keyof InvoiceUnitRequested$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-unit-requested.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/invoice-type-3117.d.ts
declare module '@sage/x3-master-data/lib/enums/invoice-type-3117' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceType3117Enum {
	    invoice = 1,
	    creditNote = 2,
	    prePayment = 3,
	    toBeReceived = 4,
	    return = 5,
	    earlyDiscountLateCharge = 6,
	    stockIssue = 7
	}
	export interface InvoiceType3117$EnumInterface {
	    invoice: 1;
	    creditNote: 2;
	    prePayment: 3;
	    toBeReceived: 4;
	    return: 5;
	    earlyDiscountLateCharge: 6;
	    stockIssue: 7;
	}
	export type InvoiceType3117 = keyof InvoiceType3117$EnumInterface;
	export const invoiceType3117Datatype: X3EnumDataType<keyof InvoiceType3117$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-type-3117.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/invoice-type-267.d.ts
declare module '@sage/x3-master-data/lib/enums/invoice-type-267' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceType267Enum {
	    invoice = 1,
	    creditNote = 2
	}
	export interface InvoiceType267$EnumInterface {
	    invoice: 1;
	    creditNote: 2;
	}
	export type InvoiceType267 = keyof InvoiceType267$EnumInterface;
	export const invoiceType267Datatype: X3EnumDataType<keyof InvoiceType267$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-type-267.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/invoice-status.d.ts
declare module '@sage/x3-master-data/lib/enums/invoice-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceStatusEnum {
	    notPosted = 1,
	    notUsed = 2,
	    posted = 3
	}
	export interface InvoiceStatus$EnumInterface {
	    notPosted: 1;
	    notUsed: 2;
	    posted: 3;
	}
	export type InvoiceStatus = keyof InvoiceStatus$EnumInterface;
	export const invoiceStatusDatatype: X3EnumDataType<keyof InvoiceStatus$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/invoice-print-mandatory.d.ts
declare module '@sage/x3-master-data/lib/enums/invoice-print-mandatory' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicePrintMandatoryEnum {
	    no = 1,
	    yes = 2,
	    yesAfterPosting = 3
	}
	export interface InvoicePrintMandatory$EnumInterface {
	    no: 1;
	    yes: 2;
	    yesAfterPosting: 3;
	}
	export type InvoicePrintMandatory = keyof InvoicePrintMandatory$EnumInterface;
	export const invoicePrintMandatoryDatatype: X3EnumDataType<keyof InvoicePrintMandatory$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-print-mandatory.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/invoice-accounting-status.d.ts
declare module '@sage/x3-master-data/lib/enums/invoice-accounting-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceAccountingStatusEnum {
	    validated = 1,
	    nonvalidated = 2
	}
	export interface InvoiceAccountingStatus$EnumInterface {
	    validated: 1;
	    nonvalidated: 2;
	}
	export type InvoiceAccountingStatus = keyof InvoiceAccountingStatus$EnumInterface;
	export const invoiceAccountingStatusDatatype: X3EnumDataType<keyof InvoiceAccountingStatus$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-accounting-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/intrastat-transport-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/intrastat-transport-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IntrastatTransportModeEnum {
	    bySea = 1,
	    byRail = 2,
	    byRoad = 3,
	    byAir = 4,
	    byMail = 5,
	    substituteValue6 = 6,
	    byInlandNavigation = 7,
	    internalNavigation = 8,
	    selfPropelled = 9
	}
	export interface IntrastatTransportMode$EnumInterface {
	    bySea: 1;
	    byRail: 2;
	    byRoad: 3;
	    byAir: 4;
	    byMail: 5;
	    substituteValue6: 6;
	    byInlandNavigation: 7;
	    internalNavigation: 8;
	    selfPropelled: 9;
	}
	export type IntrastatTransportMode = keyof IntrastatTransportMode$EnumInterface;
	export const intrastatTransportModeDatatype: X3EnumDataType<keyof IntrastatTransportMode$EnumInterface, unknown>;
	//# sourceMappingURL=intrastat-transport-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/intra-group-sale-type.d.ts
declare module '@sage/x3-master-data/lib/enums/intra-group-sale-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IntraGroupSaleTypeEnum {
	    partialTransferOfAssets = 1,
	    merger = 2,
	    split = 3,
	    intraGroupSales = 4
	}
	export interface IntraGroupSaleType$EnumInterface {
	    partialTransferOfAssets: 1;
	    merger: 2;
	    split: 3;
	    intraGroupSales: 4;
	}
	export type IntraGroupSaleType = keyof IntraGroupSaleType$EnumInterface;
	export const intraGroupSaleTypeDatatype: X3EnumDataType<keyof IntraGroupSaleType$EnumInterface, unknown>;
	//# sourceMappingURL=intra-group-sale-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/intra-group-sale-status.d.ts
declare module '@sage/x3-master-data/lib/enums/intra-group-sale-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IntraGroupSaleStatusEnum {
	    inPreparation = 1,
	    processedIssues = 2,
	    processedReceipts = 3
	}
	export interface IntraGroupSaleStatus$EnumInterface {
	    inPreparation: 1;
	    processedIssues: 2;
	    processedReceipts: 3;
	}
	export type IntraGroupSaleStatus = keyof IntraGroupSaleStatus$EnumInterface;
	export const intraGroupSaleStatusDatatype: X3EnumDataType<keyof IntraGroupSaleStatus$EnumInterface, unknown>;
	//# sourceMappingURL=intra-group-sale-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/intra-group-sale-fiscal-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/intra-group-sale-fiscal-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IntraGroupSaleFiscalRuleEnum {
	    favorableRule = 1,
	    ordinaryRule = 2,
	    others = 3
	}
	export interface IntraGroupSaleFiscalRule$EnumInterface {
	    favorableRule: 1;
	    ordinaryRule: 2;
	    others: 3;
	}
	export type IntraGroupSaleFiscalRule = keyof IntraGroupSaleFiscalRule$EnumInterface;
	export const intraGroupSaleFiscalRuleDatatype: X3EnumDataType<keyof IntraGroupSaleFiscalRule$EnumInterface, unknown>;
	//# sourceMappingURL=intra-group-sale-fiscal-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/internal-text-modification.d.ts
declare module '@sage/x3-master-data/lib/enums/internal-text-modification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InternalTextModificationEnum {
	    newText = 1,
	    question = 2
	}
	export interface InternalTextModification$EnumInterface {
	    newText: 1;
	    question: 2;
	}
	export type InternalTextModification = keyof InternalTextModification$EnumInterface;
	export const internalTextModificationDatatype: X3EnumDataType<keyof InternalTextModification$EnumInterface, unknown>;
	//# sourceMappingURL=internal-text-modification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/internal-external.d.ts
declare module '@sage/x3-master-data/lib/enums/internal-external' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InternalExternalEnum {
	    internal = 1,
	    external = 2
	}
	export interface InternalExternal$EnumInterface {
	    internal: 1;
	    external: 2;
	}
	export type InternalExternal = keyof InternalExternal$EnumInterface;
	export const internalExternalDatatype: X3EnumDataType<keyof InternalExternal$EnumInterface, unknown>;
	//# sourceMappingURL=internal-external.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/internal-container-type.d.ts
declare module '@sage/x3-master-data/lib/enums/internal-container-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InternalContainerTypeEnum {
	    container = 1,
	    pallet = 2,
	    pack = 3,
	    parcel = 4,
	    other = 5,
	    bigBags = 6,
	    barrel = 7
	}
	export interface InternalContainerType$EnumInterface {
	    container: 1;
	    pallet: 2;
	    pack: 3;
	    parcel: 4;
	    other: 5;
	    bigBags: 6;
	    barrel: 7;
	}
	export type InternalContainerType = keyof InternalContainerType$EnumInterface;
	export const internalContainerTypeDatatype: X3EnumDataType<keyof InternalContainerType$EnumInterface, unknown>;
	//# sourceMappingURL=internal-container-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/inter-ledger-control.d.ts
declare module '@sage/x3-master-data/lib/enums/inter-ledger-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InterLedgerControlEnum {
	    balanceControl = 1,
	    amountControl = 2,
	    quantityControl = 3
	}
	export interface InterLedgerControl$EnumInterface {
	    balanceControl: 1;
	    amountControl: 2;
	    quantityControl: 3;
	}
	export type InterLedgerControl = keyof InterLedgerControl$EnumInterface;
	export const interLedgerControlDatatype: X3EnumDataType<keyof InterLedgerControl$EnumInterface, unknown>;
	//# sourceMappingURL=inter-ledger-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/insurance-type.d.ts
declare module '@sage/x3-master-data/lib/enums/insurance-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InsuranceTypeEnum {
	    notInsured = 1,
	    otherInsurance = 2,
	    buildingInsurance = 3
	}
	export interface InsuranceType$EnumInterface {
	    notInsured: 1;
	    otherInsurance: 2;
	    buildingInsurance: 3;
	}
	export type InsuranceType = keyof InsuranceType$EnumInterface;
	export const insuranceTypeDatatype: X3EnumDataType<keyof InsuranceType$EnumInterface, unknown>;
	//# sourceMappingURL=insurance-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/insurance-calc-basis.d.ts
declare module '@sage/x3-master-data/lib/enums/insurance-calc-basis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InsuranceCalcBasisEnum {
	    professionalTaxBasis = 1,
	    referenceBasisValue = 2,
	    coAReceiptValue = 3,
	    coABalanceSheetValue = 4
	}
	export interface InsuranceCalcBasis$EnumInterface {
	    professionalTaxBasis: 1;
	    referenceBasisValue: 2;
	    coAReceiptValue: 3;
	    coABalanceSheetValue: 4;
	}
	export type InsuranceCalcBasis = keyof InsuranceCalcBasis$EnumInterface;
	export const insuranceCalcBasisDatatype: X3EnumDataType<keyof InsuranceCalcBasis$EnumInterface, unknown>;
	//# sourceMappingURL=insurance-calc-basis.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/installation-type.d.ts
declare module '@sage/x3-master-data/lib/enums/installation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InstallationTypeEnum {
	    endUser = 1,
	    reseller = 2,
	    wholesaler = 3,
	    inStock = 4,
	    rejected = 5
	}
	export interface InstallationType$EnumInterface {
	    endUser: 1;
	    reseller: 2;
	    wholesaler: 3;
	    inStock: 4;
	    rejected: 5;
	}
	export type InstallationType = keyof InstallationType$EnumInterface;
	export const installationTypeDatatype: X3EnumDataType<keyof InstallationType$EnumInterface, unknown>;
	//# sourceMappingURL=installation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/indirect-coverage-type.d.ts
declare module '@sage/x3-master-data/lib/enums/indirect-coverage-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IndirectCoverageTypeEnum {
	    accordingToBase = 1,
	    accordingToProductReference = 2,
	    accordingToCommercialGroup = 3,
	    allTheBase = 4
	}
	export interface IndirectCoverageType$EnumInterface {
	    accordingToBase: 1;
	    accordingToProductReference: 2;
	    accordingToCommercialGroup: 3;
	    allTheBase: 4;
	}
	export type IndirectCoverageType = keyof IndirectCoverageType$EnumInterface;
	export const indirectCoverageTypeDatatype: X3EnumDataType<keyof IndirectCoverageType$EnumInterface, unknown>;
	//# sourceMappingURL=indirect-coverage-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/index.d.ts
declare module '@sage/x3-master-data/lib/enums/index' {
	export * from '@sage/x3-master-data/lib/enums/abel-entreprise-plans';
	export * from '@sage/x3-master-data/lib/enums/acc-source-type';
	export * from '@sage/x3-master-data/lib/enums/acceptable-quality-level';
	export * from '@sage/x3-master-data/lib/enums/account-field';
	export * from '@sage/x3-master-data/lib/enums/account-structure';
	export * from '@sage/x3-master-data/lib/enums/account-type';
	export * from '@sage/x3-master-data/lib/enums/accounting-code-type';
	export * from '@sage/x3-master-data/lib/enums/accounting-date-rules';
	export * from '@sage/x3-master-data/lib/enums/accounting-journal-category';
	export * from '@sage/x3-master-data/lib/enums/accounting-nature';
	export * from '@sage/x3-master-data/lib/enums/accounting-referential';
	export * from '@sage/x3-master-data/lib/enums/action-2011';
	export * from '@sage/x3-master-data/lib/enums/action-2070';
	export * from '@sage/x3-master-data/lib/enums/action-on-physical-asset-count';
	export * from '@sage/x3-master-data/lib/enums/action-origins';
	export * from '@sage/x3-master-data/lib/enums/actioner-email-text';
	export * from '@sage/x3-master-data/lib/enums/actions-of-navigation';
	export * from '@sage/x3-master-data/lib/enums/actions-on-disposal';
	export * from '@sage/x3-master-data/lib/enums/actions';
	export * from '@sage/x3-master-data/lib/enums/active-inactive';
	export * from '@sage/x3-master-data/lib/enums/addressee-types';
	export * from '@sage/x3-master-data/lib/enums/after-sales-service-action-typ';
	export * from '@sage/x3-master-data/lib/enums/after-sales-service-departments';
	export * from '@sage/x3-master-data/lib/enums/aggregation-level';
	export * from '@sage/x3-master-data/lib/enums/all-approver-email-text';
	export * from '@sage/x3-master-data/lib/enums/allocation-status';
	export * from '@sage/x3-master-data/lib/enums/allocation-type-3621';
	export * from '@sage/x3-master-data/lib/enums/allocation-type';
	export * from '@sage/x3-master-data/lib/enums/almacom-protocols';
	export * from '@sage/x3-master-data/lib/enums/amount-for-asset-split';
	export * from '@sage/x3-master-data/lib/enums/analytical-init-type';
	export * from '@sage/x3-master-data/lib/enums/analytical-sort';
	export * from '@sage/x3-master-data/lib/enums/and-or-2955';
	export * from '@sage/x3-master-data/lib/enums/and-or-not-3024';
	export * from '@sage/x3-master-data/lib/enums/and-or-not';
	export * from '@sage/x3-master-data/lib/enums/annual-operation-type';
	export * from '@sage/x3-master-data/lib/enums/applicable-rate';
	export * from '@sage/x3-master-data/lib/enums/applicable-rule-upon-disposal';
	export * from '@sage/x3-master-data/lib/enums/appointments-origins';
	export * from '@sage/x3-master-data/lib/enums/approval-status-3510';
	export * from '@sage/x3-master-data/lib/enums/approval-status';
	export * from '@sage/x3-master-data/lib/enums/approver-rejection-email-text';
	export * from '@sage/x3-master-data/lib/enums/asset-holding-type';
	export * from '@sage/x3-master-data/lib/enums/asset-nature-for-the-tp-tf';
	export * from '@sage/x3-master-data/lib/enums/asset-receipt-nature';
	export * from '@sage/x3-master-data/lib/enums/asset-split-method-3139';
	export * from '@sage/x3-master-data/lib/enums/asset-split-method';
	export * from '@sage/x3-master-data/lib/enums/asset-stability-type';
	export * from '@sage/x3-master-data/lib/enums/asset-status-at-purchase';
	export * from '@sage/x3-master-data/lib/enums/asset-status';
	export * from '@sage/x3-master-data/lib/enums/assignment-type-sre';
	export * from '@sage/x3-master-data/lib/enums/at-record-type';
	export * from '@sage/x3-master-data/lib/enums/attachement';
	export * from '@sage/x3-master-data/lib/enums/attachment-categories';
	export * from '@sage/x3-master-data/lib/enums/authorization-step';
	export * from '@sage/x3-master-data/lib/enums/automatic-journal-enum';
	export * from '@sage/x3-master-data/lib/enums/automatic-journal-type';
	export * from '@sage/x3-master-data/lib/enums/automatic-numbers';
	export * from '@sage/x3-master-data/lib/enums/bank-cash';
	export * from '@sage/x3-master-data/lib/enums/bank-file-field-type';
	export * from '@sage/x3-master-data/lib/enums/bank-file-generation-mode';
	export * from '@sage/x3-master-data/lib/enums/bank-sign';
	export * from '@sage/x3-master-data/lib/enums/bank-statement-import';
	export * from '@sage/x3-master-data/lib/enums/base-of-expression';
	export * from '@sage/x3-master-data/lib/enums/base-record-source';
	export * from '@sage/x3-master-data/lib/enums/base-rule-value-comp-target';
	export * from '@sage/x3-master-data/lib/enums/base-type-2983';
	export * from '@sage/x3-master-data/lib/enums/basis';
	export * from '@sage/x3-master-data/lib/enums/begin-search-at';
	export * from '@sage/x3-master-data/lib/enums/belgian-bank-statement-format';
	export * from '@sage/x3-master-data/lib/enums/below-exceed-all';
	export * from '@sage/x3-master-data/lib/enums/bi-flow';
	export * from '@sage/x3-master-data/lib/enums/bi-line-type';
	export * from '@sage/x3-master-data/lib/enums/bom-code-type';
	export * from '@sage/x3-master-data/lib/enums/bom-quantity-link';
	export * from '@sage/x3-master-data/lib/enums/bp-concerned-by-price-list';
	export * from '@sage/x3-master-data/lib/enums/bp-risk-initialization';
	export * from '@sage/x3-master-data/lib/enums/business-object';
	export * from '@sage/x3-master-data/lib/enums/business-partner-rule';
	export * from '@sage/x3-master-data/lib/enums/business-partner-sequence-nos';
	export * from '@sage/x3-master-data/lib/enums/calculation-chronology';
	export * from '@sage/x3-master-data/lib/enums/calculation-closing-status';
	export * from '@sage/x3-master-data/lib/enums/calculation-method';
	export * from '@sage/x3-master-data/lib/enums/calculation-methods';
	export * from '@sage/x3-master-data/lib/enums/calendar-display-type-3052';
	export * from '@sage/x3-master-data/lib/enums/calendar-display-type';
	export * from '@sage/x3-master-data/lib/enums/calendar-information-3048';
	export * from '@sage/x3-master-data/lib/enums/calendar-information';
	export * from '@sage/x3-master-data/lib/enums/call-cover';
	export * from '@sage/x3-master-data/lib/enums/call-origin';
	export * from '@sage/x3-master-data/lib/enums/call-run-later-2980';
	export * from '@sage/x3-master-data/lib/enums/call-run-later';
	export * from '@sage/x3-master-data/lib/enums/call-type';
	export * from '@sage/x3-master-data/lib/enums/campaign-display';
	export * from '@sage/x3-master-data/lib/enums/cancellation-status';
	export * from '@sage/x3-master-data/lib/enums/carbon-emission-rate';
	export * from '@sage/x3-master-data/lib/enums/cash-forecast-types';
	export * from '@sage/x3-master-data/lib/enums/category';
	export * from '@sage/x3-master-data/lib/enums/certificate';
	export * from '@sage/x3-master-data/lib/enums/change-request-status';
	export * from '@sage/x3-master-data/lib/enums/change-status';
	export * from '@sage/x3-master-data/lib/enums/charge-discount-calculation';
	export * from '@sage/x3-master-data/lib/enums/check-document-type';
	export * from '@sage/x3-master-data/lib/enums/check-format';
	export * from '@sage/x3-master-data/lib/enums/check-status';
	export * from '@sage/x3-master-data/lib/enums/check-type-2761';
	export * from '@sage/x3-master-data/lib/enums/civility-type';
	export * from '@sage/x3-master-data/lib/enums/clause-selection';
	export * from '@sage/x3-master-data/lib/enums/closed-status';
	export * from '@sage/x3-master-data/lib/enums/code-description-extraction';
	export * from '@sage/x3-master-data/lib/enums/code-to-serve';
	export * from '@sage/x3-master-data/lib/enums/commercial-action-type';
	export * from '@sage/x3-master-data/lib/enums/commission-category';
	export * from '@sage/x3-master-data/lib/enums/commission-type';
	export * from '@sage/x3-master-data/lib/enums/common-data-sequence-numbers';
	export * from '@sage/x3-master-data/lib/enums/communication-provider';
	export * from '@sage/x3-master-data/lib/enums/communication-type-2427';
	export * from '@sage/x3-master-data/lib/enums/communication-type';
	export * from '@sage/x3-master-data/lib/enums/complete-name-of-contact';
	export * from '@sage/x3-master-data/lib/enums/component-rounded';
	export * from '@sage/x3-master-data/lib/enums/component-type-3513';
	export * from '@sage/x3-master-data/lib/enums/component-type';
	export * from '@sage/x3-master-data/lib/enums/concession-info-modification';
	export * from '@sage/x3-master-data/lib/enums/concession-management-mode';
	export * from '@sage/x3-master-data/lib/enums/concession-status';
	export * from '@sage/x3-master-data/lib/enums/consignment-goods-type';
	export * from '@sage/x3-master-data/lib/enums/context-recalculation';
	export * from '@sage/x3-master-data/lib/enums/context';
	export * from '@sage/x3-master-data/lib/enums/contract-selection-date';
	export * from '@sage/x3-master-data/lib/enums/contract-statistics-group';
	export * from '@sage/x3-master-data/lib/enums/contract-type';
	export * from '@sage/x3-master-data/lib/enums/control-3668';
	export * from '@sage/x3-master-data/lib/enums/control-level';
	export * from '@sage/x3-master-data/lib/enums/control-system-status';
	export * from '@sage/x3-master-data/lib/enums/control-type-253';
	export * from '@sage/x3-master-data/lib/enums/cost-calculation-method';
	export * from '@sage/x3-master-data/lib/enums/cost-distribution';
	export * from '@sage/x3-master-data/lib/enums/cost-nature';
	export * from '@sage/x3-master-data/lib/enums/cost-type-482';
	export * from '@sage/x3-master-data/lib/enums/cost-type-enum';
	export * from '@sage/x3-master-data/lib/enums/costing-method';
	export * from '@sage/x3-master-data/lib/enums/costs-payable-by';
	export * from '@sage/x3-master-data/lib/enums/count';
	export * from '@sage/x3-master-data/lib/enums/country-location';
	export * from '@sage/x3-master-data/lib/enums/creation-modification';
	export * from '@sage/x3-master-data/lib/enums/creator-email-text';
	export * from '@sage/x3-master-data/lib/enums/crm-activities-counters';
	export * from '@sage/x3-master-data/lib/enums/crm-activities-entry-trxs';
	export * from '@sage/x3-master-data/lib/enums/crm-entry-transactions';
	export * from '@sage/x3-master-data/lib/enums/crm';
	export * from '@sage/x3-master-data/lib/enums/crystal-report-support-cli';
	export * from '@sage/x3-master-data/lib/enums/crystal-reports-common';
	export * from '@sage/x3-master-data/lib/enums/crystal-reports-lists';
	export * from '@sage/x3-master-data/lib/enums/customer-categories';
	export * from '@sage/x3-master-data/lib/enums/customer-hold-release';
	export * from '@sage/x3-master-data/lib/enums/customer-information-type';
	export * from '@sage/x3-master-data/lib/enums/customer-movement-type';
	export * from '@sage/x3-master-data/lib/enums/customer-situation-risks';
	export * from '@sage/x3-master-data/lib/enums/customer-source';
	export * from '@sage/x3-master-data/lib/enums/customers-statistics-groups';
	export * from '@sage/x3-master-data/lib/enums/customs-file-doc-taken-into-ac';
	export * from '@sage/x3-master-data/lib/enums/daily';
	export * from '@sage/x3-master-data/lib/enums/data-type';
	export * from '@sage/x3-master-data/lib/enums/database-operation';
	export * from '@sage/x3-master-data/lib/enums/date-chosen-for-reevaluation';
	export * from '@sage/x3-master-data/lib/enums/date-format';
	export * from '@sage/x3-master-data/lib/enums/date-selection-mode';
	export * from '@sage/x3-master-data/lib/enums/date-selection';
	export * from '@sage/x3-master-data/lib/enums/date-types';
	export * from '@sage/x3-master-data/lib/enums/debit-collection-type';
	export * from '@sage/x3-master-data/lib/enums/deduction-type';
	export * from '@sage/x3-master-data/lib/enums/default-currency';
	export * from '@sage/x3-master-data/lib/enums/default-dimension-type';
	export * from '@sage/x3-master-data/lib/enums/deferred-depreciation-rule';
	export * from '@sage/x3-master-data/lib/enums/deferred-depreciation-type';
	export * from '@sage/x3-master-data/lib/enums/dematerialization-status';
	export * from '@sage/x3-master-data/lib/enums/deposit-rate';
	export * from '@sage/x3-master-data/lib/enums/deprec-calc-priority-rule';
	export * from '@sage/x3-master-data/lib/enums/deprec-calculation-type-reques';
	export * from '@sage/x3-master-data/lib/enums/deprec-end-and-disp-date-rule';
	export * from '@sage/x3-master-data/lib/enums/depreciation-basis-type';
	export * from '@sage/x3-master-data/lib/enums/depreciation-contexts';
	export * from '@sage/x3-master-data/lib/enums/depreciation-method-type';
	export * from '@sage/x3-master-data/lib/enums/depreciation-plan-standards';
	export * from '@sage/x3-master-data/lib/enums/depreciation-plans';
	export * from '@sage/x3-master-data/lib/enums/depreciation-priority-rule';
	export * from '@sage/x3-master-data/lib/enums/depreciation-start-date-type';
	export * from '@sage/x3-master-data/lib/enums/depreciation-stop-status';
	export * from '@sage/x3-master-data/lib/enums/destination-enum';
	export * from '@sage/x3-master-data/lib/enums/detail-level-3635';
	export * from '@sage/x3-master-data/lib/enums/digital-signature-control';
	export * from '@sage/x3-master-data/lib/enums/dimension-types';
	export * from '@sage/x3-master-data/lib/enums/direct-associations';
	export * from '@sage/x3-master-data/lib/enums/direct-debit-sequence';
	export * from '@sage/x3-master-data/lib/enums/direct-debit-type';
	export * from '@sage/x3-master-data/lib/enums/discount-calculation-rules';
	export * from '@sage/x3-master-data/lib/enums/discount-calculation';
	export * from '@sage/x3-master-data/lib/enums/discount-charge';
	export * from '@sage/x3-master-data/lib/enums/discount-date-type';
	export * from '@sage/x3-master-data/lib/enums/discount-management-mode';
	export * from '@sage/x3-master-data/lib/enums/disposal-reason-3175';
	export * from '@sage/x3-master-data/lib/enums/disposal-reason';
	export * from '@sage/x3-master-data/lib/enums/dispute-reason';
	export * from '@sage/x3-master-data/lib/enums/distribution-key-rule';
	export * from '@sage/x3-master-data/lib/enums/distribution-key-split';
	export * from '@sage/x3-master-data/lib/enums/distribution-rule';
	export * from '@sage/x3-master-data/lib/enums/document-batch-status';
	export * from '@sage/x3-master-data/lib/enums/document-classification';
	export * from '@sage/x3-master-data/lib/enums/document-source';
	export * from '@sage/x3-master-data/lib/enums/document-status';
	export * from '@sage/x3-master-data/lib/enums/document-type';
	export * from '@sage/x3-master-data/lib/enums/document-types';
	export * from '@sage/x3-master-data/lib/enums/due-date-in-discount-block';
	export * from '@sage/x3-master-data/lib/enums/duplicate-authorization';
	export * from '@sage/x3-master-data/lib/enums/e-invoicing-status';
	export * from '@sage/x3-master-data/lib/enums/edi-events';
	export * from '@sage/x3-master-data/lib/enums/edi-partner-type';
	export * from '@sage/x3-master-data/lib/enums/edi-status';
	export * from '@sage/x3-master-data/lib/enums/efat-status';
	export * from '@sage/x3-master-data/lib/enums/einvoicing-mapping';
	export * from '@sage/x3-master-data/lib/enums/einvoicing-partial-matching';
	export * from '@sage/x3-master-data/lib/enums/einvoicing-status';
	export * from '@sage/x3-master-data/lib/enums/electronic-invoice-type';
	export * from '@sage/x3-master-data/lib/enums/elements-concerned';
	export * from '@sage/x3-master-data/lib/enums/employee-availability-992';
	export * from '@sage/x3-master-data/lib/enums/employee-availability';
	export * from '@sage/x3-master-data/lib/enums/employee-search-type';
	export * from '@sage/x3-master-data/lib/enums/employee-type';
	export * from '@sage/x3-master-data/lib/enums/empty-or-main';
	export * from '@sage/x3-master-data/lib/enums/end-of-month-calculation';
	export * from '@sage/x3-master-data/lib/enums/entities-managed-by-company';
	export * from '@sage/x3-master-data/lib/enums/entities';
	export * from '@sage/x3-master-data/lib/enums/entity-type-business-partner-site';
	export * from '@sage/x3-master-data/lib/enums/entry-of-grid-data';
	export * from '@sage/x3-master-data/lib/enums/enum';
	export * from '@sage/x3-master-data/lib/enums/escalation-type';
	export * from '@sage/x3-master-data/lib/enums/evaluation-type';
	export * from '@sage/x3-master-data/lib/enums/event-types';
	export * from '@sage/x3-master-data/lib/enums/exception-type';
	export * from '@sage/x3-master-data/lib/enums/execution-type-2998';
	export * from '@sage/x3-master-data/lib/enums/expense-split-method';
	export * from '@sage/x3-master-data/lib/enums/expiration-management';
	export * from '@sage/x3-master-data/lib/enums/facfounba-sort-criterion';
	export * from '@sage/x3-master-data/lib/enums/factoring-type';
	export * from '@sage/x3-master-data/lib/enums/field-type-245';
	export * from '@sage/x3-master-data/lib/enums/field-type-252';
	export * from '@sage/x3-master-data/lib/enums/field-type-3683';
	export * from '@sage/x3-master-data/lib/enums/field-type-for-statuses';
	export * from '@sage/x3-master-data/lib/enums/file-sort';
	export * from '@sage/x3-master-data/lib/enums/file-type-swiss-isr-import';
	export * from '@sage/x3-master-data/lib/enums/file-type';
	export * from '@sage/x3-master-data/lib/enums/filter-on-actions';
	export * from '@sage/x3-master-data/lib/enums/filter-on-order';
	export * from '@sage/x3-master-data/lib/enums/financial-statement-pages-3618';
	export * from '@sage/x3-master-data/lib/enums/financial-year-or-period';
	export * from '@sage/x3-master-data/lib/enums/financial-year-type';
	export * from '@sage/x3-master-data/lib/enums/fiscal-year-period-status';
	export * from '@sage/x3-master-data/lib/enums/fixed-asset-numbering';
	export * from '@sage/x3-master-data/lib/enums/fixed-asset-type';
	export * from '@sage/x3-master-data/lib/enums/flow-classes';
	export * from '@sage/x3-master-data/lib/enums/flow-rule';
	export * from '@sage/x3-master-data/lib/enums/flow-tracking-type';
	export * from '@sage/x3-master-data/lib/enums/flow-type-3694';
	export * from '@sage/x3-master-data/lib/enums/flow-type';
	export * from '@sage/x3-master-data/lib/enums/flow';
	export * from '@sage/x3-master-data/lib/enums/follow-up-mode';
	export * from '@sage/x3-master-data/lib/enums/follow-up-text-type';
	export * from '@sage/x3-master-data/lib/enums/forecast-status';
	export * from '@sage/x3-master-data/lib/enums/form-selection';
	export * from '@sage/x3-master-data/lib/enums/format';
	export * from '@sage/x3-master-data/lib/enums/formula-type';
	export * from '@sage/x3-master-data/lib/enums/free-amount-currency';
	export * from '@sage/x3-master-data/lib/enums/free-miscellaneous-method-code';
	export * from '@sage/x3-master-data/lib/enums/free-product-type';
	export * from '@sage/x3-master-data/lib/enums/free-products';
	export * from '@sage/x3-master-data/lib/enums/freight-application-threshold';
	export * from '@sage/x3-master-data/lib/enums/freight-calculation-rounding';
	export * from '@sage/x3-master-data/lib/enums/freight-commodity-code';
	export * from '@sage/x3-master-data/lib/enums/frequency-2231';
	export * from '@sage/x3-master-data/lib/enums/frequency-3638';
	export * from '@sage/x3-master-data/lib/enums/frequency';
	export * from '@sage/x3-master-data/lib/enums/fuel-type';
	export * from '@sage/x3-master-data/lib/enums/function-2073';
	export * from '@sage/x3-master-data/lib/enums/function-contact';
	export * from '@sage/x3-master-data/lib/enums/fy-or-period';
	export * from '@sage/x3-master-data/lib/enums/general-control-level';
	export * from '@sage/x3-master-data/lib/enums/general-journal-sort-3264';
	export * from '@sage/x3-master-data/lib/enums/general-ledger-types';
	export * from '@sage/x3-master-data/lib/enums/generated-document';
	export * from '@sage/x3-master-data/lib/enums/global-request-coverage-3003';
	export * from '@sage/x3-master-data/lib/enums/global-request-coverage';
	export * from '@sage/x3-master-data/lib/enums/group-non-group';
	export * from '@sage/x3-master-data/lib/enums/grouping-criterion';
	export * from '@sage/x3-master-data/lib/enums/grouping-indicators';
	export * from '@sage/x3-master-data/lib/enums/grouping-level';
	export * from '@sage/x3-master-data/lib/enums/help-desk-call-assignment';
	export * from '@sage/x3-master-data/lib/enums/help-desk-counters';
	export * from '@sage/x3-master-data/lib/enums/hold-type';
	export * from '@sage/x3-master-data/lib/enums/identification-type';
	export * from '@sage/x3-master-data/lib/enums/identifier-type';
	export * from '@sage/x3-master-data/lib/enums/igs-company-type-3174';
	export * from '@sage/x3-master-data/lib/enums/igs-company-type';
	export * from '@sage/x3-master-data/lib/enums/igs-disposal-status';
	export * from '@sage/x3-master-data/lib/enums/image-enum';
	export * from '@sage/x3-master-data/lib/enums/impairment-loss-type';
	export * from '@sage/x3-master-data/lib/enums/import-export';
	export * from '@sage/x3-master-data/lib/enums/include-exclude-2999';
	export * from '@sage/x3-master-data/lib/enums/include-exclude';
	export * from '@sage/x3-master-data/lib/enums/inclusive-exclusive-3002';
	export * from '@sage/x3-master-data/lib/enums/inclusive-exclusive';
	export * from '@sage/x3-master-data/lib/enums/increase-decrease';
	export * from '@sage/x3-master-data/lib/enums/indirect-coverage-type';
	export * from '@sage/x3-master-data/lib/enums/installation-type';
	export * from '@sage/x3-master-data/lib/enums/insurance-calc-basis';
	export * from '@sage/x3-master-data/lib/enums/insurance-type';
	export * from '@sage/x3-master-data/lib/enums/inter-ledger-control';
	export * from '@sage/x3-master-data/lib/enums/internal-container-type';
	export * from '@sage/x3-master-data/lib/enums/internal-external';
	export * from '@sage/x3-master-data/lib/enums/internal-text-modification';
	export * from '@sage/x3-master-data/lib/enums/intra-group-sale-fiscal-rule';
	export * from '@sage/x3-master-data/lib/enums/intra-group-sale-status';
	export * from '@sage/x3-master-data/lib/enums/intra-group-sale-type';
	export * from '@sage/x3-master-data/lib/enums/intrastat-transport-mode';
	export * from '@sage/x3-master-data/lib/enums/invoice-accounting-status';
	export * from '@sage/x3-master-data/lib/enums/invoice-print-mandatory';
	export * from '@sage/x3-master-data/lib/enums/invoice-status';
	export * from '@sage/x3-master-data/lib/enums/invoice-type-267';
	export * from '@sage/x3-master-data/lib/enums/invoice-type-3117';
	export * from '@sage/x3-master-data/lib/enums/invoice-unit-requested';
	export * from '@sage/x3-master-data/lib/enums/invoicing-element';
	export * from '@sage/x3-master-data/lib/enums/invoicing-method-2978';
	export * from '@sage/x3-master-data/lib/enums/invoicing-method-requested';
	export * from '@sage/x3-master-data/lib/enums/invoicing-type';
	export * from '@sage/x3-master-data/lib/enums/journal-entry-types';
	export * from '@sage/x3-master-data/lib/enums/kza-localization';
	export * from '@sage/x3-master-data/lib/enums/late-charges-execution-type';
	export * from '@sage/x3-master-data/lib/enums/lead-link';
	export * from '@sage/x3-master-data/lib/enums/lead-management';
	export * from '@sage/x3-master-data/lib/enums/lead-status';
	export * from '@sage/x3-master-data/lib/enums/lead-time-unit';
	export * from '@sage/x3-master-data/lib/enums/lease-contract-balance-sheet-line';
	export * from '@sage/x3-master-data/lib/enums/lease-contract-nature';
	export * from '@sage/x3-master-data/lib/enums/lease-contract-source';
	export * from '@sage/x3-master-data/lib/enums/lease-contract-status';
	export * from '@sage/x3-master-data/lib/enums/lease-contract-type';
	export * from '@sage/x3-master-data/lib/enums/level-of-interest';
	export * from '@sage/x3-master-data/lib/enums/licence-info';
	export * from '@sage/x3-master-data/lib/enums/life-cycle-internal-status';
	export * from '@sage/x3-master-data/lib/enums/life-cycle-invoice-type';
	export * from '@sage/x3-master-data/lib/enums/line-pricing-long-description';
	export * from '@sage/x3-master-data/lib/enums/line-pricing-short-descriptio';
	export * from '@sage/x3-master-data/lib/enums/line-status-3719';
	export * from '@sage/x3-master-data/lib/enums/line-status';
	export * from '@sage/x3-master-data/lib/enums/link-direction';
	export * from '@sage/x3-master-data/lib/enums/location-management';
	export * from '@sage/x3-master-data/lib/enums/location-type-phys-asset';
	export * from '@sage/x3-master-data/lib/enums/lot-issue-expiration-ubd';
	export * from '@sage/x3-master-data/lib/enums/lot-number-management';
	export * from '@sage/x3-master-data/lib/enums/low-level-type';
	export * from '@sage/x3-master-data/lib/enums/lva-management';
	export * from '@sage/x3-master-data/lib/enums/mailing-shipment-methods';
	export * from '@sage/x3-master-data/lib/enums/mailing-type';
	export * from '@sage/x3-master-data/lib/enums/main-expense';
	export * from '@sage/x3-master-data/lib/enums/management-unit';
	export * from '@sage/x3-master-data/lib/enums/mandate-status';
	export * from '@sage/x3-master-data/lib/enums/mandatory';
	export * from '@sage/x3-master-data/lib/enums/manual-sector-allocation';
	export * from '@sage/x3-master-data/lib/enums/marketing-operation-types';
	export * from '@sage/x3-master-data/lib/enums/marketing-responses-type';
	export * from '@sage/x3-master-data/lib/enums/mass-mailing-type';
	export * from '@sage/x3-master-data/lib/enums/matching-option';
	export * from '@sage/x3-master-data/lib/enums/material-replenish-type';
	export * from '@sage/x3-master-data/lib/enums/merge-description-field';
	export * from '@sage/x3-master-data/lib/enums/message-file-format';
	export * from '@sage/x3-master-data/lib/enums/message-mapping-type';
	export * from '@sage/x3-master-data/lib/enums/message-type';
	export * from '@sage/x3-master-data/lib/enums/message';
	export * from '@sage/x3-master-data/lib/enums/methd-chge-variance-recovery';
	export * from '@sage/x3-master-data/lib/enums/method-change-effective-date';
	export * from '@sage/x3-master-data/lib/enums/method';
	export * from '@sage/x3-master-data/lib/enums/migration-parameters-3118';
	export * from '@sage/x3-master-data/lib/enums/migration-parameters';
	export * from '@sage/x3-master-data/lib/enums/milleage-bracket';
	export * from '@sage/x3-master-data/lib/enums/misc-info-processing-option';
	export * from '@sage/x3-master-data/lib/enums/miscellaneous-accounts';
	export * from '@sage/x3-master-data/lib/enums/miscellaneous-dimensions';
	export * from '@sage/x3-master-data/lib/enums/mode';
	export * from '@sage/x3-master-data/lib/enums/months-of-the-year';
	export * from '@sage/x3-master-data/lib/enums/movement-import';
	export * from '@sage/x3-master-data/lib/enums/movement-origin';
	export * from '@sage/x3-master-data/lib/enums/movement-status';
	export * from '@sage/x3-master-data/lib/enums/movement-type';
	export * from '@sage/x3-master-data/lib/enums/movements-and-flows';
	export * from '@sage/x3-master-data/lib/enums/multip-copy-ext-doc-management';
	export * from '@sage/x3-master-data/lib/enums/name-structure';
	export * from '@sage/x3-master-data/lib/enums/nature-chosen-for-reevaluation';
	export * from '@sage/x3-master-data/lib/enums/new-approver-email-text';
	export * from '@sage/x3-master-data/lib/enums/new-change-manager-email-text';
	export * from '@sage/x3-master-data/lib/enums/new-planner-email-text';
	export * from '@sage/x3-master-data/lib/enums/no-in-part-in-full';
	export * from '@sage/x3-master-data/lib/enums/no-yes-all';
	export * from '@sage/x3-master-data/lib/enums/no-yes-on-request';
	export * from '@sage/x3-master-data/lib/enums/non-conformance-creation-mode';
	export * from '@sage/x3-master-data/lib/enums/non-conformance-document';
	export * from '@sage/x3-master-data/lib/enums/non-conformance-origin';
	export * from '@sage/x3-master-data/lib/enums/not';
	export * from '@sage/x3-master-data/lib/enums/notes-categories';
	export * from '@sage/x3-master-data/lib/enums/notes-functions';
	export * from '@sage/x3-master-data/lib/enums/notes-pr-sorting';
	export * from '@sage/x3-master-data/lib/enums/object-creation-origin';
	export * from '@sage/x3-master-data/lib/enums/object-to-be-processed-recodi';
	export * from '@sage/x3-master-data/lib/enums/old-approver-email-text';
	export * from '@sage/x3-master-data/lib/enums/old-change-manager-email-text';
	export * from '@sage/x3-master-data/lib/enums/old-planner-email-text';
	export * from '@sage/x3-master-data/lib/enums/open-item-selection';
	export * from '@sage/x3-master-data/lib/enums/open-item-type';
	export * from '@sage/x3-master-data/lib/enums/operation-enum';
	export * from '@sage/x3-master-data/lib/enums/operation-type';
	export * from '@sage/x3-master-data/lib/enums/operators-2960';
	export * from '@sage/x3-master-data/lib/enums/operators';
	export * from '@sage/x3-master-data/lib/enums/option-for-bd-and-bs-modes';
	export * from '@sage/x3-master-data/lib/enums/option-table';
	export * from '@sage/x3-master-data/lib/enums/ord-invoice';
	export * from '@sage/x3-master-data/lib/enums/orders-action-status';
	export * from '@sage/x3-master-data/lib/enums/origin-type';
	export * from '@sage/x3-master-data/lib/enums/original-depreciation-basis';
	export * from '@sage/x3-master-data/lib/enums/original-entry-supplement';
	export * from '@sage/x3-master-data/lib/enums/outlook-contact-type';
	export * from '@sage/x3-master-data/lib/enums/packing-slip-types';
	export * from '@sage/x3-master-data/lib/enums/payment-approval-type';
	export * from '@sage/x3-master-data/lib/enums/payment-approval';
	export * from '@sage/x3-master-data/lib/enums/payment-card-status';
	export * from '@sage/x3-master-data/lib/enums/payment-entry-type';
	export * from '@sage/x3-master-data/lib/enums/payment-item-reference';
	export * from '@sage/x3-master-data/lib/enums/payment-order-receipt-report';
	export * from '@sage/x3-master-data/lib/enums/payment-order-receipt';
	export * from '@sage/x3-master-data/lib/enums/payment-processor-selection';
	export * from '@sage/x3-master-data/lib/enums/payment-processor';
	export * from '@sage/x3-master-data/lib/enums/payment-selection';
	export * from '@sage/x3-master-data/lib/enums/payment-status-3690';
	export * from '@sage/x3-master-data/lib/enums/payment-type';
	export * from '@sage/x3-master-data/lib/enums/pending-movement-control';
	export * from '@sage/x3-master-data/lib/enums/pending-movement';
	export * from '@sage/x3-master-data/lib/enums/period-fiscal-year-status';
	export * from '@sage/x3-master-data/lib/enums/period-status';
	export * from '@sage/x3-master-data/lib/enums/periodicity-type-2990';
	export * from '@sage/x3-master-data/lib/enums/phone-number-type';
	export * from '@sage/x3-master-data/lib/enums/phys-asset-entry-persistence';
	export * from '@sage/x3-master-data/lib/enums/physical-asset-count-entry-method';
	export * from '@sage/x3-master-data/lib/enums/physical-asset-count-entry-rule';
	export * from '@sage/x3-master-data/lib/enums/physical-asset-count-operation-status';
	export * from '@sage/x3-master-data/lib/enums/physical-asset-count-result';
	export * from '@sage/x3-master-data/lib/enums/physical-asset-count-status';
	export * from '@sage/x3-master-data/lib/enums/physical-asset-count-type';
	export * from '@sage/x3-master-data/lib/enums/pivot-headers';
	export * from '@sage/x3-master-data/lib/enums/pivot-types';
	export * from '@sage/x3-master-data/lib/enums/place-of-appointment';
	export * from '@sage/x3-master-data/lib/enums/place-type';
	export * from '@sage/x3-master-data/lib/enums/plan-complete-email-text';
	export * from '@sage/x3-master-data/lib/enums/plan-status-2045';
	export * from '@sage/x3-master-data/lib/enums/plan-status';
	export * from '@sage/x3-master-data/lib/enums/points-report';
	export * from '@sage/x3-master-data/lib/enums/points-type';
	export * from '@sage/x3-master-data/lib/enums/poland-document-type';
	export * from '@sage/x3-master-data/lib/enums/positive-pay-file-generation';
	export * from '@sage/x3-master-data/lib/enums/positive-pay-record-type';
	export * from '@sage/x3-master-data/lib/enums/posting-type';
	export * from '@sage/x3-master-data/lib/enums/prepayment-management';
	export * from '@sage/x3-master-data/lib/enums/prepayment-status';
	export * from '@sage/x3-master-data/lib/enums/prev-code-management-recoding';
	export * from '@sage/x3-master-data/lib/enums/price-adjustment';
	export * from '@sage/x3-master-data/lib/enums/price-amount-tax-tax';
	export * from '@sage/x3-master-data/lib/enums/price-classes';
	export * from '@sage/x3-master-data/lib/enums/price-origin';
	export * from '@sage/x3-master-data/lib/enums/price-type';
	export * from '@sage/x3-master-data/lib/enums/price-update-mode';
	export * from '@sage/x3-master-data/lib/enums/price';
	export * from '@sage/x3-master-data/lib/enums/print-code';
	export * from '@sage/x3-master-data/lib/enums/priority-3735';
	export * from '@sage/x3-master-data/lib/enums/process-type';
	export * from '@sage/x3-master-data/lib/enums/processed-product';
	export * from '@sage/x3-master-data/lib/enums/processing-mode-288';
	export * from '@sage/x3-master-data/lib/enums/processing-mode';
	export * from '@sage/x3-master-data/lib/enums/processing';
	export * from '@sage/x3-master-data/lib/enums/product-abc-class';
	export * from '@sage/x3-master-data/lib/enums/product-category-type';
	export * from '@sage/x3-master-data/lib/enums/product-creation-mode';
	export * from '@sage/x3-master-data/lib/enums/product-design-status';
	export * from '@sage/x3-master-data/lib/enums/product-search-criteria';
	export * from '@sage/x3-master-data/lib/enums/product-statistical-groups-enum';
	export * from '@sage/x3-master-data/lib/enums/product-status';
	export * from '@sage/x3-master-data/lib/enums/product-type';
	export * from '@sage/x3-master-data/lib/enums/product-version-impact';
	export * from '@sage/x3-master-data/lib/enums/project-allocation-type';
	export * from '@sage/x3-master-data/lib/enums/project-origins';
	export * from '@sage/x3-master-data/lib/enums/project-stages';
	export * from '@sage/x3-master-data/lib/enums/property-types';
	export * from '@sage/x3-master-data/lib/enums/proposal-order';
	export * from '@sage/x3-master-data/lib/enums/prospect-customer-3043';
	export * from '@sage/x3-master-data/lib/enums/prospect-customer';
	export * from '@sage/x3-master-data/lib/enums/protocol-type';
	export * from '@sage/x3-master-data/lib/enums/provision-type';
	export * from '@sage/x3-master-data/lib/enums/purchase-in-service-date-rule';
	export * from '@sage/x3-master-data/lib/enums/purchase-invoice-category';
	export * from '@sage/x3-master-data/lib/enums/quarter';
	export * from '@sage/x3-master-data/lib/enums/rate-amount';
	export * from '@sage/x3-master-data/lib/enums/rate-entry-mode';
	export * from '@sage/x3-master-data/lib/enums/re-evaluation-aids';
	export * from '@sage/x3-master-data/lib/enums/re-evaluation-method';
	export * from '@sage/x3-master-data/lib/enums/reason-for-rejection';
	export * from '@sage/x3-master-data/lib/enums/reasons';
	export * from '@sage/x3-master-data/lib/enums/receiving-authorized-status';
	export * from '@sage/x3-master-data/lib/enums/recipient-type-495';
	export * from '@sage/x3-master-data/lib/enums/recoding-status';
	export * from '@sage/x3-master-data/lib/enums/record-status';
	export * from '@sage/x3-master-data/lib/enums/record-type-2029';
	export * from '@sage/x3-master-data/lib/enums/record-type';
	export * from '@sage/x3-master-data/lib/enums/recov-rule-target-comp-plans';
	export * from '@sage/x3-master-data/lib/enums/recurrence-pattern';
	export * from '@sage/x3-master-data/lib/enums/recurrence';
	export * from '@sage/x3-master-data/lib/enums/recurring-invoice-status';
	export * from '@sage/x3-master-data/lib/enums/reevaluation-effective-date';
	export * from '@sage/x3-master-data/lib/enums/reevaluation-method';
	export * from '@sage/x3-master-data/lib/enums/reference-date-type';
	export * from '@sage/x3-master-data/lib/enums/reference';
	export * from '@sage/x3-master-data/lib/enums/region-taxes-application';
	export * from '@sage/x3-master-data/lib/enums/related-company-settings';
	export * from '@sage/x3-master-data/lib/enums/relation-type';
	export * from '@sage/x3-master-data/lib/enums/release-status';
	export * from '@sage/x3-master-data/lib/enums/reminder-frequency-types';
	export * from '@sage/x3-master-data/lib/enums/reminder-type';
	export * from '@sage/x3-master-data/lib/enums/renewal-history';
	export * from '@sage/x3-master-data/lib/enums/reorder-quantity';
	export * from '@sage/x3-master-data/lib/enums/report-sort-assets';
	export * from '@sage/x3-master-data/lib/enums/request-origin';
	export * from '@sage/x3-master-data/lib/enums/request-response';
	export * from '@sage/x3-master-data/lib/enums/request-stats-grp';
	export * from '@sage/x3-master-data/lib/enums/requested-closing-type';
	export * from '@sage/x3-master-data/lib/enums/resolution-types';
	export * from '@sage/x3-master-data/lib/enums/resource-availability';
	export * from '@sage/x3-master-data/lib/enums/resource-reservation-origin';
	export * from '@sage/x3-master-data/lib/enums/review-type';
	export * from '@sage/x3-master-data/lib/enums/revision-parameter-menu';
	export * from '@sage/x3-master-data/lib/enums/revision-reason';
	export * from '@sage/x3-master-data/lib/enums/rounded-lot';
	export * from '@sage/x3-master-data/lib/enums/rounded-type';
	export * from '@sage/x3-master-data/lib/enums/rounding-breakdown';
	export * from '@sage/x3-master-data/lib/enums/routing-conditions';
	export * from '@sage/x3-master-data/lib/enums/rule-flow';
	export * from '@sage/x3-master-data/lib/enums/saf-t-product-type';
	export * from '@sage/x3-master-data/lib/enums/saf-t-type';
	export * from '@sage/x3-master-data/lib/enums/saft-audit-file-schema';
	export * from '@sage/x3-master-data/lib/enums/saft-document-type';
	export * from '@sage/x3-master-data/lib/enums/saft-document';
	export * from '@sage/x3-master-data/lib/enums/sales-amount-type';
	export * from '@sage/x3-master-data/lib/enums/sales-journal-type';
	export * from '@sage/x3-master-data/lib/enums/sales-order-stage';
	export * from '@sage/x3-master-data/lib/enums/sales-rep-site';
	export * from '@sage/x3-master-data/lib/enums/sampling-mode';
	export * from '@sage/x3-master-data/lib/enums/sampling-type';
	export * from '@sage/x3-master-data/lib/enums/scaling-analytical-period';
	export * from '@sage/x3-master-data/lib/enums/scaling-control';
	export * from '@sage/x3-master-data/lib/enums/scanning-device';
	export * from '@sage/x3-master-data/lib/enums/schedule';
	export * from '@sage/x3-master-data/lib/enums/script-response-storage';
	export * from '@sage/x3-master-data/lib/enums/search-destination';
	export * from '@sage/x3-master-data/lib/enums/seasonality-type';
	export * from '@sage/x3-master-data/lib/enums/sectors-management';
	export * from '@sage/x3-master-data/lib/enums/select-lead-time-3390';
	export * from '@sage/x3-master-data/lib/enums/selection-assets-entered';
	export * from '@sage/x3-master-data/lib/enums/selection-master-966';
	export * from '@sage/x3-master-data/lib/enums/selection-master';
	export * from '@sage/x3-master-data/lib/enums/selection-of-the-issued-assets';
	export * from '@sage/x3-master-data/lib/enums/sense';
	export * from '@sage/x3-master-data/lib/enums/separator-type';
	export * from '@sage/x3-master-data/lib/enums/sequence-calculation-method';
	export * from '@sage/x3-master-data/lib/enums/serial-number-management';
	export * from '@sage/x3-master-data/lib/enums/service-contract-categories';
	export * from '@sage/x3-master-data/lib/enums/service-contract-invoice-date';
	export * from '@sage/x3-master-data/lib/enums/service-contract-sort';
	export * from '@sage/x3-master-data/lib/enums/service-contract-source';
	export * from '@sage/x3-master-data/lib/enums/service-request-allocation';
	export * from '@sage/x3-master-data/lib/enums/service-request-invoicing';
	export * from '@sage/x3-master-data/lib/enums/service-request-source';
	export * from '@sage/x3-master-data/lib/enums/service-status';
	export * from '@sage/x3-master-data/lib/enums/set-up-option-type';
	export * from '@sage/x3-master-data/lib/enums/severity-level';
	export * from '@sage/x3-master-data/lib/enums/severity';
	export * from '@sage/x3-master-data/lib/enums/shortage-delivery';
	export * from '@sage/x3-master-data/lib/enums/sign';
	export * from '@sage/x3-master-data/lib/enums/signature-format';
	export * from '@sage/x3-master-data/lib/enums/sii-messages';
	export * from '@sage/x3-master-data/lib/enums/sii-operation';
	export * from '@sage/x3-master-data/lib/enums/sort-asset-reports';
	export * from '@sage/x3-master-data/lib/enums/sort-bp-invoices-858';
	export * from '@sage/x3-master-data/lib/enums/sort-bp-invoices';
	export * from '@sage/x3-master-data/lib/enums/sort-option';
	export * from '@sage/x3-master-data/lib/enums/sort-options-print';
	export * from '@sage/x3-master-data/lib/enums/sort-order-2627';
	export * from '@sage/x3-master-data/lib/enums/sort-order-3176';
	export * from '@sage/x3-master-data/lib/enums/sort-payment';
	export * from '@sage/x3-master-data/lib/enums/sort-sequence-2624';
	export * from '@sage/x3-master-data/lib/enums/sort-traitenr';
	export * from '@sage/x3-master-data/lib/enums/source';
	export * from '@sage/x3-master-data/lib/enums/spanish-invoice-type';
	export * from '@sage/x3-master-data/lib/enums/specific-deprec-rules';
	export * from '@sage/x3-master-data/lib/enums/split-object-numbering';
	export * from '@sage/x3-master-data/lib/enums/src-comp-sale-price-calcul';
	export * from '@sage/x3-master-data/lib/enums/standard-depreciation-methods';
	export * from '@sage/x3-master-data/lib/enums/standard-depreciation-variant';
	export * from '@sage/x3-master-data/lib/enums/standard-product-code';
	export * from '@sage/x3-master-data/lib/enums/statement-status';
	export * from '@sage/x3-master-data/lib/enums/status-2806';
	export * from '@sage/x3-master-data/lib/enums/status-2824';
	export * from '@sage/x3-master-data/lib/enums/status-edi-field';
	export * from '@sage/x3-master-data/lib/enums/status-of-expeditions';
	export * from '@sage/x3-master-data/lib/enums/status-of-the-funds';
	export * from '@sage/x3-master-data/lib/enums/stock-management';
	export * from '@sage/x3-master-data/lib/enums/stock-transactions-status';
	export * from '@sage/x3-master-data/lib/enums/stock-valuation';
	export * from '@sage/x3-master-data/lib/enums/stock-withdrawal-mode';
	export * from '@sage/x3-master-data/lib/enums/stock-withdrawal';
	export * from '@sage/x3-master-data/lib/enums/stored-intermediate-amount';
	export * from '@sage/x3-master-data/lib/enums/sub-contract-order-status';
	export * from '@sage/x3-master-data/lib/enums/subcontract-material-status';
	export * from '@sage/x3-master-data/lib/enums/subcontract-sort';
	export * from '@sage/x3-master-data/lib/enums/subcontracted-product-status';
	export * from '@sage/x3-master-data/lib/enums/subject-campaign-calls';
	export * from '@sage/x3-master-data/lib/enums/subject-to-control';
	export * from '@sage/x3-master-data/lib/enums/subsidy-status';
	export * from '@sage/x3-master-data/lib/enums/subsidy-type';
	export * from '@sage/x3-master-data/lib/enums/suggestion-type';
	export * from '@sage/x3-master-data/lib/enums/supplementary-invoicing';
	export * from '@sage/x3-master-data/lib/enums/supplier-customer-type';
	export * from '@sage/x3-master-data/lib/enums/supplier-situation-risks';
	export * from '@sage/x3-master-data/lib/enums/suppliers-statistics-groups';
	export * from '@sage/x3-master-data/lib/enums/supply-by';
	export * from '@sage/x3-master-data/lib/enums/swiss-payment-types';
	export * from '@sage/x3-master-data/lib/enums/swiss-type-codes';
	export * from '@sage/x3-master-data/lib/enums/ta-communication-status';
	export * from '@sage/x3-master-data/lib/enums/tables-of-criteria';
	export * from '@sage/x3-master-data/lib/enums/target-comp-deprec-duration-rule';
	export * from '@sage/x3-master-data/lib/enums/target-company-asset-status';
	export * from '@sage/x3-master-data/lib/enums/task-link';
	export * from '@sage/x3-master-data/lib/enums/tax-authority-status';
	export * from '@sage/x3-master-data/lib/enums/tax-country-region';
	export * from '@sage/x3-master-data/lib/enums/tax-level-enum';
	export * from '@sage/x3-master-data/lib/enums/tax-rule-3165';
	export * from '@sage/x3-master-data/lib/enums/tax-rule-enum';
	export * from '@sage/x3-master-data/lib/enums/tax-type-2079';
	export * from '@sage/x3-master-data/lib/enums/tax-type';
	export * from '@sage/x3-master-data/lib/enums/taxable-horse-power';
	export * from '@sage/x3-master-data/lib/enums/taxation-rule';
	export * from '@sage/x3-master-data/lib/enums/technical-sheet-tracking-type';
	export * from '@sage/x3-master-data/lib/enums/territory-of-declaration';
	export * from '@sage/x3-master-data/lib/enums/test-cp';
	export * from '@sage/x3-master-data/lib/enums/text-types';
	export * from '@sage/x3-master-data/lib/enums/texts-to-translate';
	export * from '@sage/x3-master-data/lib/enums/time-format';
	export * from '@sage/x3-master-data/lib/enums/timing';
	export * from '@sage/x3-master-data/lib/enums/tolerance-definition-level';
	export * from '@sage/x3-master-data/lib/enums/tp-tf-basis-rule-target-company';
	export * from '@sage/x3-master-data/lib/enums/transaction-type-2039';
	export * from '@sage/x3-master-data/lib/enums/trigger';
	export * from '@sage/x3-master-data/lib/enums/type-3667';
	export * from '@sage/x3-master-data/lib/enums/type-code';
	export * from '@sage/x3-master-data/lib/enums/type-of-accounting-codes';
	export * from '@sage/x3-master-data/lib/enums/type-of-address';
	export * from '@sage/x3-master-data/lib/enums/type-of-after-sales-services-employee';
	export * from '@sage/x3-master-data/lib/enums/type-of-allocation';
	export * from '@sage/x3-master-data/lib/enums/type-of-asset-under-concession';
	export * from '@sage/x3-master-data/lib/enums/type-of-charge';
	export * from '@sage/x3-master-data/lib/enums/type-of-charges';
	export * from '@sage/x3-master-data/lib/enums/type-of-concession-input';
	export * from '@sage/x3-master-data/lib/enums/type-of-consumption-default';
	export * from '@sage/x3-master-data/lib/enums/type-of-cover';
	export * from '@sage/x3-master-data/lib/enums/type-of-document';
	export * from '@sage/x3-master-data/lib/enums/type-of-draft-managment';
	export * from '@sage/x3-master-data/lib/enums/type-of-edi-field';
	export * from '@sage/x3-master-data/lib/enums/type-of-mailing-address';
	export * from '@sage/x3-master-data/lib/enums/type-of-merge';
	export * from '@sage/x3-master-data/lib/enums/type-of-product';
	export * from '@sage/x3-master-data/lib/enums/type-of-prorata-temporis';
	export * from '@sage/x3-master-data/lib/enums/type-of-suggestion';
	export * from '@sage/x3-master-data/lib/enums/type';
	export * from '@sage/x3-master-data/lib/enums/types-of-actions-2963';
	export * from '@sage/x3-master-data/lib/enums/types-of-actions';
	export * from '@sage/x3-master-data/lib/enums/types-of-distances';
	export * from '@sage/x3-master-data/lib/enums/types-of-response';
	export * from '@sage/x3-master-data/lib/enums/types-of-support-of-selection';
	export * from '@sage/x3-master-data/lib/enums/types-of-vat-update';
	export * from '@sage/x3-master-data/lib/enums/unbalanced-payment';
	export * from '@sage/x3-master-data/lib/enums/unpacking-rules-pac';
	export * from '@sage/x3-master-data/lib/enums/upd-fields-split';
	export * from '@sage/x3-master-data/lib/enums/update-during-count';
	export * from '@sage/x3-master-data/lib/enums/use-search-term-list';
	export * from '@sage/x3-master-data/lib/enums/use-status';
	export * from '@sage/x3-master-data/lib/enums/use';
	export * from '@sage/x3-master-data/lib/enums/user-department';
	export * from '@sage/x3-master-data/lib/enums/user-functions-3022';
	export * from '@sage/x3-master-data/lib/enums/user-functions-enum';
	export * from '@sage/x3-master-data/lib/enums/user-role-2036';
	export * from '@sage/x3-master-data/lib/enums/user-status';
	export * from '@sage/x3-master-data/lib/enums/valuation-type';
	export * from '@sage/x3-master-data/lib/enums/valuation';
	export * from '@sage/x3-master-data/lib/enums/value-type';
	export * from '@sage/x3-master-data/lib/enums/variance-recovery-strategy';
	export * from '@sage/x3-master-data/lib/enums/vat-rule-for-dispoal';
	export * from '@sage/x3-master-data/lib/enums/vehicle-category-for-expenses';
	export * from '@sage/x3-master-data/lib/enums/vehicle-receipt-type';
	export * from '@sage/x3-master-data/lib/enums/vehicle-tax-rate';
	export * from '@sage/x3-master-data/lib/enums/verification-status';
	export * from '@sage/x3-master-data/lib/enums/version-status';
	export * from '@sage/x3-master-data/lib/enums/voucher-creation';
	export * from '@sage/x3-master-data/lib/enums/warranty-voucher-source';
	export * from '@sage/x3-master-data/lib/enums/waste-disposal-management-3687';
	export * from '@sage/x3-master-data/lib/enums/waste-disposal-management';
	export * from '@sage/x3-master-data/lib/enums/webservice-for-eu-vat-id-check';
	export * from '@sage/x3-master-data/lib/enums/wip-control-exchange-rate';
	export * from '@sage/x3-master-data/lib/enums/wip-selection';
	export * from '@sage/x3-master-data/lib/enums/withholding-category';
	export * from '@sage/x3-master-data/lib/enums/withholding-type';
	export * from '@sage/x3-master-data/lib/enums/work-in-progress-control';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/increase-decrease.d.ts
declare module '@sage/x3-master-data/lib/enums/increase-decrease' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IncreaseDecreaseEnum {
	    increase = 1,
	    decrease = 2
	}
	export interface IncreaseDecrease$EnumInterface {
	    increase: 1;
	    decrease: 2;
	}
	export type IncreaseDecrease = keyof IncreaseDecrease$EnumInterface;
	export const increaseDecreaseDatatype: X3EnumDataType<keyof IncreaseDecrease$EnumInterface, unknown>;
	//# sourceMappingURL=increase-decrease.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/inclusive-exclusive.d.ts
declare module '@sage/x3-master-data/lib/enums/inclusive-exclusive' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InclusiveExclusiveEnum {
	    excludeNonListedLabor = 1,
	    includeNonListedLabor = 2
	}
	export interface InclusiveExclusive$EnumInterface {
	    excludeNonListedLabor: 1;
	    includeNonListedLabor: 2;
	}
	export type InclusiveExclusive = keyof InclusiveExclusive$EnumInterface;
	export const inclusiveExclusiveDatatype: X3EnumDataType<keyof InclusiveExclusive$EnumInterface, unknown>;
	//# sourceMappingURL=inclusive-exclusive.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/inclusive-exclusive-3002.d.ts
declare module '@sage/x3-master-data/lib/enums/inclusive-exclusive-3002' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InclusiveExclusive3002Enum {
	    excludeTheExpensesNotListed = 1,
	    includeTheExpensesNotListed = 2
	}
	export interface InclusiveExclusive3002$EnumInterface {
	    excludeTheExpensesNotListed: 1;
	    includeTheExpensesNotListed: 2;
	}
	export type InclusiveExclusive3002 = keyof InclusiveExclusive3002$EnumInterface;
	export const inclusiveExclusive3002Datatype: X3EnumDataType<keyof InclusiveExclusive3002$EnumInterface, unknown>;
	//# sourceMappingURL=inclusive-exclusive-3002.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/include-exclude.d.ts
declare module '@sage/x3-master-data/lib/enums/include-exclude' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IncludeExcludeEnum {
	    exclude = 1,
	    include = 2
	}
	export interface IncludeExclude$EnumInterface {
	    exclude: 1;
	    include: 2;
	}
	export type IncludeExclude = keyof IncludeExclude$EnumInterface;
	export const includeExcludeDatatype: X3EnumDataType<keyof IncludeExclude$EnumInterface, unknown>;
	//# sourceMappingURL=include-exclude.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/include-exclude-2999.d.ts
declare module '@sage/x3-master-data/lib/enums/include-exclude-2999' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IncludeExclude2999Enum {
	    excludeNonListedComponents = 1,
	    includeNonListedComponents = 2
	}
	export interface IncludeExclude2999$EnumInterface {
	    excludeNonListedComponents: 1;
	    includeNonListedComponents: 2;
	}
	export type IncludeExclude2999 = keyof IncludeExclude2999$EnumInterface;
	export const includeExclude2999Datatype: X3EnumDataType<keyof IncludeExclude2999$EnumInterface, unknown>;
	//# sourceMappingURL=include-exclude-2999.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/import-export.d.ts
declare module '@sage/x3-master-data/lib/enums/import-export' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ImportExportEnum {
	    import = 1,
	    export = 2
	}
	export interface ImportExport$EnumInterface {
	    import: 1;
	    export: 2;
	}
	export type ImportExport = keyof ImportExport$EnumInterface;
	export const importExportDatatype: X3EnumDataType<keyof ImportExport$EnumInterface, unknown>;
	//# sourceMappingURL=import-export.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/impairment-loss-type.d.ts
declare module '@sage/x3-master-data/lib/enums/impairment-loss-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ImpairmentLossTypeEnum {
	    exceptional = 1,
	    aVoir = 2
	}
	export interface ImpairmentLossType$EnumInterface {
	    exceptional: 1;
	    aVoir: 2;
	}
	export type ImpairmentLossType = keyof ImpairmentLossType$EnumInterface;
	export const impairmentLossTypeDatatype: X3EnumDataType<keyof ImpairmentLossType$EnumInterface, unknown>;
	//# sourceMappingURL=impairment-loss-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/image-enum.d.ts
declare module '@sage/x3-master-data/lib/enums/image-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ImageEnumEnum {
	    image1 = 1,
	    image2 = 2,
	    none = 3
	}
	export interface ImageEnum$EnumInterface {
	    image1: 1;
	    image2: 2;
	    none: 3;
	}
	export type ImageEnum = keyof ImageEnum$EnumInterface;
	export const imageEnumDatatype: X3EnumDataType<keyof ImageEnum$EnumInterface, unknown>;
	//# sourceMappingURL=image-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/igs-disposal-status.d.ts
declare module '@sage/x3-master-data/lib/enums/igs-disposal-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IgsDisposalStatusEnum {
	    assetToBeIssued = 1,
	    issuedAssetToBeModified = 2,
	    assetToBeCancelled = 3
	}
	export interface IgsDisposalStatus$EnumInterface {
	    assetToBeIssued: 1;
	    issuedAssetToBeModified: 2;
	    assetToBeCancelled: 3;
	}
	export type IgsDisposalStatus = keyof IgsDisposalStatus$EnumInterface;
	export const igsDisposalStatusDatatype: X3EnumDataType<keyof IgsDisposalStatus$EnumInterface, unknown>;
	//# sourceMappingURL=igs-disposal-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/igs-company-type.d.ts
declare module '@sage/x3-master-data/lib/enums/igs-company-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IgsCompanyTypeEnum {
	    sourceCompany = 1,
	    targetCompany = 2
	}
	export interface IgsCompanyType$EnumInterface {
	    sourceCompany: 1;
	    targetCompany: 2;
	}
	export type IgsCompanyType = keyof IgsCompanyType$EnumInterface;
	export const igsCompanyTypeDatatype: X3EnumDataType<keyof IgsCompanyType$EnumInterface, unknown>;
	//# sourceMappingURL=igs-company-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/igs-company-type-3174.d.ts
declare module '@sage/x3-master-data/lib/enums/igs-company-type-3174' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IgsCompanyType3174Enum {
	    source = 1,
	    target = 2
	}
	export interface IgsCompanyType3174$EnumInterface {
	    source: 1;
	    target: 2;
	}
	export type IgsCompanyType3174 = keyof IgsCompanyType3174$EnumInterface;
	export const igsCompanyType3174Datatype: X3EnumDataType<keyof IgsCompanyType3174$EnumInterface, unknown>;
	//# sourceMappingURL=igs-company-type-3174.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/identifier-type.d.ts
declare module '@sage/x3-master-data/lib/enums/identifier-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IdentifierTypeEnum {
	    fiscalCode = 1,
	    localCode = 2,
	    gln = 3,
	    duns = 4,
	    vatNumber = 5,
	    free = 6
	}
	export interface IdentifierType$EnumInterface {
	    fiscalCode: 1;
	    localCode: 2;
	    gln: 3;
	    duns: 4;
	    vatNumber: 5;
	    free: 6;
	}
	export type IdentifierType = keyof IdentifierType$EnumInterface;
	export const identifierTypeDatatype: X3EnumDataType<keyof IdentifierType$EnumInterface, unknown>;
	//# sourceMappingURL=identifier-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/identification-type.d.ts
declare module '@sage/x3-master-data/lib/enums/identification-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IdentificationTypeEnum {
	    tin = 1,
	    other = 2
	}
	export interface IdentificationType$EnumInterface {
	    tin: 1;
	    other: 2;
	}
	export type IdentificationType = keyof IdentificationType$EnumInterface;
	export const identificationTypeDatatype: X3EnumDataType<keyof IdentificationType$EnumInterface, unknown>;
	//# sourceMappingURL=identification-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/hold-type.d.ts
declare module '@sage/x3-master-data/lib/enums/hold-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum HoldTypeEnum {
	    noBlock = 1,
	    operationBlock = 2,
	    statusBlock = 3,
	    nextSheet = 4
	}
	export interface HoldType$EnumInterface {
	    noBlock: 1;
	    operationBlock: 2;
	    statusBlock: 3;
	    nextSheet: 4;
	}
	export type HoldType = keyof HoldType$EnumInterface;
	export const holdTypeDatatype: X3EnumDataType<keyof HoldType$EnumInterface, unknown>;
	//# sourceMappingURL=hold-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/help-desk-counters.d.ts
declare module '@sage/x3-master-data/lib/enums/help-desk-counters' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum HelpDeskCountersEnum {
	    serviceContracts = 1,
	    helpDeskCalls = 2,
	    customerBase = 3,
	    solutions = 4,
	    queues = 5,
	    skillGroups = 6,
	    serviceContractTemplates = 7,
	    warrantyRequests = 8,
	    serviceRequestTemplates = 9,
	    maintenancePlans = 10,
	    afterSalesServiceConsumptions = 11,
	    sequences = 12,
	    warrantyVouchers = 13,
	    escalations = 14
	}
	export interface HelpDeskCounters$EnumInterface {
	    serviceContracts: 1;
	    helpDeskCalls: 2;
	    customerBase: 3;
	    solutions: 4;
	    queues: 5;
	    skillGroups: 6;
	    serviceContractTemplates: 7;
	    warrantyRequests: 8;
	    serviceRequestTemplates: 9;
	    maintenancePlans: 10;
	    afterSalesServiceConsumptions: 11;
	    sequences: 12;
	    warrantyVouchers: 13;
	    escalations: 14;
	}
	export type HelpDeskCounters = keyof HelpDeskCounters$EnumInterface;
	export const helpDeskCountersDatatype: X3EnumDataType<keyof HelpDeskCounters$EnumInterface, unknown>;
	//# sourceMappingURL=help-desk-counters.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/help-desk-call-assignment.d.ts
declare module '@sage/x3-master-data/lib/enums/help-desk-call-assignment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum HelpDeskCallAssignmentEnum {
	    dispatching = 1,
	    employee = 2,
	    queue = 3,
	    commercial = 4,
	    closed = 5
	}
	export interface HelpDeskCallAssignment$EnumInterface {
	    dispatching: 1;
	    employee: 2;
	    queue: 3;
	    commercial: 4;
	    closed: 5;
	}
	export type HelpDeskCallAssignment = keyof HelpDeskCallAssignment$EnumInterface;
	export const helpDeskCallAssignmentDatatype: X3EnumDataType<keyof HelpDeskCallAssignment$EnumInterface, unknown>;
	//# sourceMappingURL=help-desk-call-assignment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/grouping-level.d.ts
declare module '@sage/x3-master-data/lib/enums/grouping-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GroupingLevelEnum {
	    company = 1,
	    bankGroup = 2,
	    bank = 3,
	    site = 4
	}
	export interface GroupingLevel$EnumInterface {
	    company: 1;
	    bankGroup: 2;
	    bank: 3;
	    site: 4;
	}
	export type GroupingLevel = keyof GroupingLevel$EnumInterface;
	export const groupingLevelDatatype: X3EnumDataType<keyof GroupingLevel$EnumInterface, unknown>;
	//# sourceMappingURL=grouping-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/grouping-indicators.d.ts
declare module '@sage/x3-master-data/lib/enums/grouping-indicators' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GroupingIndicatorsEnum {
	    none = 1,
	    groupAndCumulate = 2,
	    groupTheLinesIntoASingleDocument = 3,
	    cancelTheWholeDocumentInCaseOfErrorOnOneOfTheLines = 4
	}
	export interface GroupingIndicators$EnumInterface {
	    none: 1;
	    groupAndCumulate: 2;
	    groupTheLinesIntoASingleDocument: 3;
	    cancelTheWholeDocumentInCaseOfErrorOnOneOfTheLines: 4;
	}
	export type GroupingIndicators = keyof GroupingIndicators$EnumInterface;
	export const groupingIndicatorsDatatype: X3EnumDataType<keyof GroupingIndicators$EnumInterface, unknown>;
	//# sourceMappingURL=grouping-indicators.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/grouping-criterion.d.ts
declare module '@sage/x3-master-data/lib/enums/grouping-criterion' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GroupingCriterionEnum {
	    undefined = 1,
	    group = 2,
	    sGroup = 3,
	    currencyGroup = 4,
	    currencySGroup = 5
	}
	export interface GroupingCriterion$EnumInterface {
	    undefined: 1;
	    group: 2;
	    sGroup: 3;
	    currencyGroup: 4;
	    currencySGroup: 5;
	}
	export type GroupingCriterion = keyof GroupingCriterion$EnumInterface;
	export const groupingCriterionDatatype: X3EnumDataType<keyof GroupingCriterion$EnumInterface, unknown>;
	//# sourceMappingURL=grouping-criterion.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/group-non-group.d.ts
declare module '@sage/x3-master-data/lib/enums/group-non-group' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GroupNonGroupEnum {
	    group = 1,
	    nonGroup = 2
	}
	export interface GroupNonGroup$EnumInterface {
	    group: 1;
	    nonGroup: 2;
	}
	export type GroupNonGroup = keyof GroupNonGroup$EnumInterface;
	export const groupNonGroupDatatype: X3EnumDataType<keyof GroupNonGroup$EnumInterface, unknown>;
	//# sourceMappingURL=group-non-group.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/global-request-coverage.d.ts
declare module '@sage/x3-master-data/lib/enums/global-request-coverage' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GlobalRequestCoverageEnum {
	    totallyCovered = 1,
	    partiallyCovered = 2,
	    notCovered = 3
	}
	export interface GlobalRequestCoverage$EnumInterface {
	    totallyCovered: 1;
	    partiallyCovered: 2;
	    notCovered: 3;
	}
	export type GlobalRequestCoverage = keyof GlobalRequestCoverage$EnumInterface;
	export const globalRequestCoverageDatatype: X3EnumDataType<keyof GlobalRequestCoverage$EnumInterface, unknown>;
	//# sourceMappingURL=global-request-coverage.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/global-request-coverage-3003.d.ts
declare module '@sage/x3-master-data/lib/enums/global-request-coverage-3003' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GlobalRequestCoverage3003Enum {
	    totallyCovered = 1,
	    partiallyCovered = 2,
	    notCovered = 3,
	    coveredByServiceContract = 4,
	    coveredBySalesOrder = 5,
	    coveredCommercially = 6,
	    coveredByDirectInvoicing = 7
	}
	export interface GlobalRequestCoverage3003$EnumInterface {
	    totallyCovered: 1;
	    partiallyCovered: 2;
	    notCovered: 3;
	    coveredByServiceContract: 4;
	    coveredBySalesOrder: 5;
	    coveredCommercially: 6;
	    coveredByDirectInvoicing: 7;
	}
	export type GlobalRequestCoverage3003 = keyof GlobalRequestCoverage3003$EnumInterface;
	export const globalRequestCoverage3003Datatype: X3EnumDataType<keyof GlobalRequestCoverage3003$EnumInterface, unknown>;
	//# sourceMappingURL=global-request-coverage-3003.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/generated-document.d.ts
declare module '@sage/x3-master-data/lib/enums/generated-document' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GeneratedDocumentEnum {
	    purchasingInvoice = 1,
	    bpSupplierInvoice = 2,
	    manual = 3
	}
	export interface GeneratedDocument$EnumInterface {
	    purchasingInvoice: 1;
	    bpSupplierInvoice: 2;
	    manual: 3;
	}
	export type GeneratedDocument = keyof GeneratedDocument$EnumInterface;
	export const generatedDocumentDatatype: X3EnumDataType<keyof GeneratedDocument$EnumInterface, unknown>;
	//# sourceMappingURL=generated-document.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/general-ledger-types.d.ts
declare module '@sage/x3-master-data/lib/enums/general-ledger-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GeneralLedgerTypesEnum {
	    legal = 1,
	    analytical = 2,
	    ias = 3,
	    genLedger4 = 4,
	    genLedger5 = 5,
	    genLedger6 = 6,
	    genLedger7 = 7,
	    genLedger8 = 8,
	    genLedger9 = 9,
	    genLedger10 = 10
	}
	export interface GeneralLedgerTypes$EnumInterface {
	    legal: 1;
	    analytical: 2;
	    ias: 3;
	    genLedger4: 4;
	    genLedger5: 5;
	    genLedger6: 6;
	    genLedger7: 7;
	    genLedger8: 8;
	    genLedger9: 9;
	    genLedger10: 10;
	}
	export type GeneralLedgerTypes = keyof GeneralLedgerTypes$EnumInterface;
	export const generalLedgerTypesDatatype: X3EnumDataType<keyof GeneralLedgerTypes$EnumInterface, unknown>;
	//# sourceMappingURL=general-ledger-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/general-journal-sort-3264.d.ts
declare module '@sage/x3-master-data/lib/enums/general-journal-sort-3264' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GeneralJournalSort3264Enum {
	    sitePeriod = 1,
	    periodSite = 2
	}
	export interface GeneralJournalSort3264$EnumInterface {
	    sitePeriod: 1;
	    periodSite: 2;
	}
	export type GeneralJournalSort3264 = keyof GeneralJournalSort3264$EnumInterface;
	export const generalJournalSort3264Datatype: X3EnumDataType<keyof GeneralJournalSort3264$EnumInterface, unknown>;
	//# sourceMappingURL=general-journal-sort-3264.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/general-control-level.d.ts
declare module '@sage/x3-master-data/lib/enums/general-control-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GeneralControlLevelEnum {
	    i = 1,
	    ii = 2,
	    iii = 3,
	    undefined = 4
	}
	export interface GeneralControlLevel$EnumInterface {
	    i: 1;
	    ii: 2;
	    iii: 3;
	    undefined: 4;
	}
	export type GeneralControlLevel = keyof GeneralControlLevel$EnumInterface;
	export const generalControlLevelDatatype: X3EnumDataType<keyof GeneralControlLevel$EnumInterface, unknown>;
	//# sourceMappingURL=general-control-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/fy-or-period.d.ts
declare module '@sage/x3-master-data/lib/enums/fy-or-period' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FyOrPeriodEnum {
	    fiscalYear = 1,
	    period = 2,
	    periodTotal = 3
	}
	export interface FyOrPeriod$EnumInterface {
	    fiscalYear: 1;
	    period: 2;
	    periodTotal: 3;
	}
	export type FyOrPeriod = keyof FyOrPeriod$EnumInterface;
	export const fyOrPeriodDatatype: X3EnumDataType<keyof FyOrPeriod$EnumInterface, unknown>;
	//# sourceMappingURL=fy-or-period.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/function-contact.d.ts
declare module '@sage/x3-master-data/lib/enums/function-contact' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FunctionContactEnum {
	    ceo = 1,
	    salesManager = 2,
	    technicalManager = 3,
	    purchasingManager = 4,
	    buyer = 5,
	    stockManager = 6,
	    financialAndLegalManager = 7,
	    importExportManager = 8,
	    siteManager = 9,
	    externalActor = 10,
	    other = 11,
	    chiefHumanResourcesOfficer = 12
	}
	export interface FunctionContact$EnumInterface {
	    ceo: 1;
	    salesManager: 2;
	    technicalManager: 3;
	    purchasingManager: 4;
	    buyer: 5;
	    stockManager: 6;
	    financialAndLegalManager: 7;
	    importExportManager: 8;
	    siteManager: 9;
	    externalActor: 10;
	    other: 11;
	    chiefHumanResourcesOfficer: 12;
	}
	export type FunctionContact = keyof FunctionContact$EnumInterface;
	export const functionContactDatatype: X3EnumDataType<keyof FunctionContact$EnumInterface, unknown>;
	//# sourceMappingURL=function-contact.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/function-2073.d.ts
declare module '@sage/x3-master-data/lib/enums/function-2073' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Function2073Enum {
	    serviceRequest = 1,
	    intervention = 2
	}
	export interface Function2073$EnumInterface {
	    serviceRequest: 1;
	    intervention: 2;
	}
	export type Function2073 = keyof Function2073$EnumInterface;
	export const function2073Datatype: X3EnumDataType<keyof Function2073$EnumInterface, unknown>;
	//# sourceMappingURL=function-2073.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/fuel-type.d.ts
declare module '@sage/x3-master-data/lib/enums/fuel-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FuelTypeEnum {
	    fuelAndSimilarProducts = 1,
	    dieselAndSimilarProducts = 2,
	    electric = 3,
	    other = 4
	}
	export interface FuelType$EnumInterface {
	    fuelAndSimilarProducts: 1;
	    dieselAndSimilarProducts: 2;
	    electric: 3;
	    other: 4;
	}
	export type FuelType = keyof FuelType$EnumInterface;
	export const fuelTypeDatatype: X3EnumDataType<keyof FuelType$EnumInterface, unknown>;
	//# sourceMappingURL=fuel-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/frequency.d.ts
declare module '@sage/x3-master-data/lib/enums/frequency' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FrequencyEnum {
	    day = 1,
	    week = 2,
	    month = 3,
	    quarter = 4,
	    year = 5
	}
	export interface Frequency$EnumInterface {
	    day: 1;
	    week: 2;
	    month: 3;
	    quarter: 4;
	    year: 5;
	}
	export type Frequency = keyof Frequency$EnumInterface;
	export const frequencyDatatype: X3EnumDataType<keyof Frequency$EnumInterface, unknown>;
	//# sourceMappingURL=frequency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/frequency-3638.d.ts
declare module '@sage/x3-master-data/lib/enums/frequency-3638' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Frequency3638Enum {
	    weekly = 1,
	    monthly = 2,
	    first = 3,
	    last = 4
	}
	export interface Frequency3638$EnumInterface {
	    weekly: 1;
	    monthly: 2;
	    first: 3;
	    last: 4;
	}
	export type Frequency3638 = keyof Frequency3638$EnumInterface;
	export const frequency3638Datatype: X3EnumDataType<keyof Frequency3638$EnumInterface, unknown>;
	//# sourceMappingURL=frequency-3638.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/frequency-2231.d.ts
declare module '@sage/x3-master-data/lib/enums/frequency-2231' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Frequency2231Enum {
	    day = 1,
	    week = 2,
	    halfMonth = 3,
	    month = 4,
	    quarter = 5,
	    halfYear = 6,
	    year = 7,
	    decade = 8
	}
	export interface Frequency2231$EnumInterface {
	    day: 1;
	    week: 2;
	    halfMonth: 3;
	    month: 4;
	    quarter: 5;
	    halfYear: 6;
	    year: 7;
	    decade: 8;
	}
	export type Frequency2231 = keyof Frequency2231$EnumInterface;
	export const frequency2231Datatype: X3EnumDataType<keyof Frequency2231$EnumInterface, unknown>;
	//# sourceMappingURL=frequency-2231.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/freight-commodity-code.d.ts
declare module '@sage/x3-master-data/lib/enums/freight-commodity-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FreightCommodityCodeEnum {
	    nmfcNumber = 1,
	    hsCode = 2
	}
	export interface FreightCommodityCode$EnumInterface {
	    nmfcNumber: 1;
	    hsCode: 2;
	}
	export type FreightCommodityCode = keyof FreightCommodityCode$EnumInterface;
	export const freightCommodityCodeDatatype: X3EnumDataType<keyof FreightCommodityCode$EnumInterface, unknown>;
	//# sourceMappingURL=freight-commodity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/freight-calculation-rounding.d.ts
declare module '@sage/x3-master-data/lib/enums/freight-calculation-rounding' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FreightCalculationRoundingEnum {
	    band1 = 1,
	    band = 2,
	    nearestBand = 3
	}
	export interface FreightCalculationRounding$EnumInterface {
	    band1: 1;
	    band: 2;
	    nearestBand: 3;
	}
	export type FreightCalculationRounding = keyof FreightCalculationRounding$EnumInterface;
	export const freightCalculationRoundingDatatype: X3EnumDataType<keyof FreightCalculationRounding$EnumInterface, unknown>;
	//# sourceMappingURL=freight-calculation-rounding.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/freight-application-threshold.d.ts
declare module '@sage/x3-master-data/lib/enums/freight-application-threshold' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FreightApplicationThresholdEnum {
	    orderedExTax = 1,
	    shippedExTax = 2
	}
	export interface FreightApplicationThreshold$EnumInterface {
	    orderedExTax: 1;
	    shippedExTax: 2;
	}
	export type FreightApplicationThreshold = keyof FreightApplicationThreshold$EnumInterface;
	export const freightApplicationThresholdDatatype: X3EnumDataType<keyof FreightApplicationThreshold$EnumInterface, unknown>;
	//# sourceMappingURL=freight-application-threshold.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/free-products.d.ts
declare module '@sage/x3-master-data/lib/enums/free-products' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FreeProductsEnum {
	    no = 1,
	    sameProduct = 2,
	    otherProducts = 3,
	    orderTotal = 4
	}
	export interface FreeProducts$EnumInterface {
	    no: 1;
	    sameProduct: 2;
	    otherProducts: 3;
	    orderTotal: 4;
	}
	export type FreeProducts = keyof FreeProducts$EnumInterface;
	export const freeProductsDatatype: X3EnumDataType<keyof FreeProducts$EnumInterface, unknown>;
	//# sourceMappingURL=free-products.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/free-product-type.d.ts
declare module '@sage/x3-master-data/lib/enums/free-product-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FreeProductTypeEnum {
	    threshold = 1,
	    multiple = 2
	}
	export interface FreeProductType$EnumInterface {
	    threshold: 1;
	    multiple: 2;
	}
	export type FreeProductType = keyof FreeProductType$EnumInterface;
	export const freeProductTypeDatatype: X3EnumDataType<keyof FreeProductType$EnumInterface, unknown>;
	//# sourceMappingURL=free-product-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/free-miscellaneous-method-code.d.ts
declare module '@sage/x3-master-data/lib/enums/free-miscellaneous-method-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FreeMiscellaneousMethodCodeEnum {
	    none = 1,
	    rateByAnnuity = 2,
	    basisFixedTax3 = 3,
	    basisFixedTax = 4,
	    basisMonthlyTax = 5,
	    depreciationBasis = 6,
	    previousFyEndNetValue = 7,
	    balanceSheetValueDepreciationDuration = 8,
	    netValueResidualDuration9 = 9,
	    toBeReintegratedInFirstFy = 10,
	    toBeReintegratedInFirstPeriod = 11,
	    simplificationRule = 12,
	    withoutProrataCalculation = 13,
	    investmentFinancialYearProrata = 14,
	    investmentWithdrawalFinancialYearProrata = 15,
	    prorataCalculationInMonths = 16,
	    prorataCalculationInDays = 17,
	    netValueResidualDuration = 18,
	    netValueAtTheEndOfThePreviousFy = 19,
	    depreciationBasisDepreciationDuration = 20,
	    priorityToTheRate = 21
	}
	export interface FreeMiscellaneousMethodCode$EnumInterface {
	    none: 1;
	    rateByAnnuity: 2;
	    basisFixedTax3: 3;
	    basisFixedTax: 4;
	    basisMonthlyTax: 5;
	    depreciationBasis: 6;
	    previousFyEndNetValue: 7;
	    balanceSheetValueDepreciationDuration: 8;
	    netValueResidualDuration9: 9;
	    toBeReintegratedInFirstFy: 10;
	    toBeReintegratedInFirstPeriod: 11;
	    simplificationRule: 12;
	    withoutProrataCalculation: 13;
	    investmentFinancialYearProrata: 14;
	    investmentWithdrawalFinancialYearProrata: 15;
	    prorataCalculationInMonths: 16;
	    prorataCalculationInDays: 17;
	    netValueResidualDuration: 18;
	    netValueAtTheEndOfThePreviousFy: 19;
	    depreciationBasisDepreciationDuration: 20;
	    priorityToTheRate: 21;
	}
	export type FreeMiscellaneousMethodCode = keyof FreeMiscellaneousMethodCode$EnumInterface;
	export const freeMiscellaneousMethodCodeDatatype: X3EnumDataType<keyof FreeMiscellaneousMethodCode$EnumInterface, unknown>;
	//# sourceMappingURL=free-miscellaneous-method-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/free-amount-currency.d.ts
declare module '@sage/x3-master-data/lib/enums/free-amount-currency' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FreeAmountCurrencyEnum {
	    company = 1,
	    object = 2
	}
	export interface FreeAmountCurrency$EnumInterface {
	    company: 1;
	    object: 2;
	}
	export type FreeAmountCurrency = keyof FreeAmountCurrency$EnumInterface;
	export const freeAmountCurrencyDatatype: X3EnumDataType<keyof FreeAmountCurrency$EnumInterface, unknown>;
	//# sourceMappingURL=free-amount-currency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/formula-type.d.ts
declare module '@sage/x3-master-data/lib/enums/formula-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FormulaTypeEnum {
	    tax = 1,
	    routingOperations = 2,
	    salesRepCommissions = 3,
	    freightCharges = 4,
	    overheadCosts = 5,
	    abcClass = 6,
	    configurator = 7,
	    documents = 8,
	    modifyTechnicalFiles = 9,
	    enterprisePlanning = 10,
	    stockSelections = 11,
	    weighingPlan = 12,
	    returns = 13,
	    timeTracking = 14,
	    manufacturingPlan = 15,
	    materialTrackingPlan = 16,
	    putAwayPlan = 17,
	    productsCount = 18,
	    consumptionReorderCalculation = 19,
	    locationsSubjectToReorder = 20,
	    automaticJournals = 21,
	    trackingWorkbenchMonitoring = 22,
	    technicalRecordWorkbench = 23,
	    consumptionAreas = 24,
	    shortageOnLocation = 25,
	    ordersToPick = 26,
	    stockCount = 27,
	    locationsCount = 28,
	    totalsCount = 29,
	    categoryChange = 30,
	    bom = 31,
	    qualityRecordsQuestion = 32,
	    packageContent = 33,
	    salesSelections = 34,
	    purchaseSelection = 35,
	    subcontractOrder = 36,
	    workCenters = 37,
	    productsWorkOrders = 38,
	    operationsWorkOrders = 39,
	    materialsWorkOrders = 40,
	    products = 41,
	    stockCountProductsWarehouses = 42,
	    stockCountWarehouses = 43,
	    workOrders = 44,
	    scmOrders = 45,
	    scmDeliveriesInvoices = 46,
	    productsSubcontractOrders = 47,
	    servicesSubcontractOrders = 48,
	    materialSubcontractOrders = 49,
	    bp = 50,
	    massCreationOfProductSite = 51,
	    viewRoutes = 52,
	    selectComponents = 53,
	    componentQuantities = 54,
	    costs = 55,
	    costStructure = 56,
	    licensePlateNumber = 57
	}
	export interface FormulaType$EnumInterface {
	    tax: 1;
	    routingOperations: 2;
	    salesRepCommissions: 3;
	    freightCharges: 4;
	    overheadCosts: 5;
	    abcClass: 6;
	    configurator: 7;
	    documents: 8;
	    modifyTechnicalFiles: 9;
	    enterprisePlanning: 10;
	    stockSelections: 11;
	    weighingPlan: 12;
	    returns: 13;
	    timeTracking: 14;
	    manufacturingPlan: 15;
	    materialTrackingPlan: 16;
	    putAwayPlan: 17;
	    productsCount: 18;
	    consumptionReorderCalculation: 19;
	    locationsSubjectToReorder: 20;
	    automaticJournals: 21;
	    trackingWorkbenchMonitoring: 22;
	    technicalRecordWorkbench: 23;
	    consumptionAreas: 24;
	    shortageOnLocation: 25;
	    ordersToPick: 26;
	    stockCount: 27;
	    locationsCount: 28;
	    totalsCount: 29;
	    categoryChange: 30;
	    bom: 31;
	    qualityRecordsQuestion: 32;
	    packageContent: 33;
	    salesSelections: 34;
	    purchaseSelection: 35;
	    subcontractOrder: 36;
	    workCenters: 37;
	    productsWorkOrders: 38;
	    operationsWorkOrders: 39;
	    materialsWorkOrders: 40;
	    products: 41;
	    stockCountProductsWarehouses: 42;
	    stockCountWarehouses: 43;
	    workOrders: 44;
	    scmOrders: 45;
	    scmDeliveriesInvoices: 46;
	    productsSubcontractOrders: 47;
	    servicesSubcontractOrders: 48;
	    materialSubcontractOrders: 49;
	    bp: 50;
	    massCreationOfProductSite: 51;
	    viewRoutes: 52;
	    selectComponents: 53;
	    componentQuantities: 54;
	    costs: 55;
	    costStructure: 56;
	    licensePlateNumber: 57;
	}
	export type FormulaType = keyof FormulaType$EnumInterface;
	export const formulaTypeDatatype: X3EnumDataType<keyof FormulaType$EnumInterface, unknown>;
	//# sourceMappingURL=formula-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/format.d.ts
declare module '@sage/x3-master-data/lib/enums/format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FormatEnum {
	    fixed = 1,
	    variable = 2,
	    csv = 3
	}
	export interface Format$EnumInterface {
	    fixed: 1;
	    variable: 2;
	    csv: 3;
	}
	export type Format = keyof Format$EnumInterface;
	export const formatDatatype: X3EnumDataType<keyof Format$EnumInterface, unknown>;
	//# sourceMappingURL=format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/form-selection.d.ts
declare module '@sage/x3-master-data/lib/enums/form-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FormSelectionEnum {
	    summary = 1,
	    detail = 2
	}
	export interface FormSelection$EnumInterface {
	    summary: 1;
	    detail: 2;
	}
	export type FormSelection = keyof FormSelection$EnumInterface;
	export const formSelectionDatatype: X3EnumDataType<keyof FormSelection$EnumInterface, unknown>;
	//# sourceMappingURL=form-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/forecast-status.d.ts
declare module '@sage/x3-master-data/lib/enums/forecast-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ForecastStatusEnum {
	    active = 1,
	    inactive = 2,
	    modified = 3,
	    obsolete = 4
	}
	export interface ForecastStatus$EnumInterface {
	    active: 1;
	    inactive: 2;
	    modified: 3;
	    obsolete: 4;
	}
	export type ForecastStatus = keyof ForecastStatus$EnumInterface;
	export const forecastStatusDatatype: X3EnumDataType<keyof ForecastStatus$EnumInterface, unknown>;
	//# sourceMappingURL=forecast-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/follow-up-text-type.d.ts
declare module '@sage/x3-master-data/lib/enums/follow-up-text-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FollowUpTextTypeEnum {
	    byInvoice = 1,
	    global = 2,
	    byMail = 3
	}
	export interface FollowUpTextType$EnumInterface {
	    byInvoice: 1;
	    global: 2;
	    byMail: 3;
	}
	export type FollowUpTextType = keyof FollowUpTextType$EnumInterface;
	export const followUpTextTypeDatatype: X3EnumDataType<keyof FollowUpTextType$EnumInterface, unknown>;
	//# sourceMappingURL=follow-up-text-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/follow-up-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/follow-up-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FollowUpModeEnum {
	    letter = 1,
	    email = 2,
	    telephone = 3,
	    fax = 4
	}
	export interface FollowUpMode$EnumInterface {
	    letter: 1;
	    email: 2;
	    telephone: 3;
	    fax: 4;
	}
	export type FollowUpMode = keyof FollowUpMode$EnumInterface;
	export const followUpModeDatatype: X3EnumDataType<keyof FollowUpMode$EnumInterface, unknown>;
	//# sourceMappingURL=follow-up-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/flow.d.ts
declare module '@sage/x3-master-data/lib/enums/flow' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FlowEnum {
	    kit = 1,
	    manufacturingBom = 2,
	    subContractBom = 3,
	    stock = 4
	}
	export interface Flow$EnumInterface {
	    kit: 1;
	    manufacturingBom: 2;
	    subContractBom: 3;
	    stock: 4;
	}
	export type Flow = keyof Flow$EnumInterface;
	export const flowDatatype: X3EnumDataType<keyof Flow$EnumInterface, unknown>;
	//# sourceMappingURL=flow.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/flow-type.d.ts
declare module '@sage/x3-master-data/lib/enums/flow-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FlowTypeEnum {
	    intersite = 1,
	    intercompany = 2
	}
	export interface FlowType$EnumInterface {
	    intersite: 1;
	    intercompany: 2;
	}
	export type FlowType = keyof FlowType$EnumInterface;
	export const flowTypeDatatype: X3EnumDataType<keyof FlowType$EnumInterface, unknown>;
	//# sourceMappingURL=flow-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/flow-type-3694.d.ts
declare module '@sage/x3-master-data/lib/enums/flow-type-3694' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FlowType3694Enum {
	    standard = 1,
	    reconciliationOnly = 2,
	    postValidationTransfer = 3
	}
	export interface FlowType3694$EnumInterface {
	    standard: 1;
	    reconciliationOnly: 2;
	    postValidationTransfer: 3;
	}
	export type FlowType3694 = keyof FlowType3694$EnumInterface;
	export const flowType3694Datatype: X3EnumDataType<keyof FlowType3694$EnumInterface, unknown>;
	//# sourceMappingURL=flow-type-3694.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/flow-tracking-type.d.ts
declare module '@sage/x3-master-data/lib/enums/flow-tracking-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FlowTrackingTypeEnum {
	    accountGroup = 1,
	    account = 2
	}
	export interface FlowTrackingType$EnumInterface {
	    accountGroup: 1;
	    account: 2;
	}
	export type FlowTrackingType = keyof FlowTrackingType$EnumInterface;
	export const flowTrackingTypeDatatype: X3EnumDataType<keyof FlowTrackingType$EnumInterface, unknown>;
	//# sourceMappingURL=flow-tracking-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/flow-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/flow-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FlowRuleEnum {
	    arrivals = 1,
	    dispatches = 2,
	    arrivalsAndDispatches = 3,
	    substituteValue4 = 4
	}
	export interface FlowRule$EnumInterface {
	    arrivals: 1;
	    dispatches: 2;
	    arrivalsAndDispatches: 3;
	    substituteValue4: 4;
	}
	export type FlowRule = keyof FlowRule$EnumInterface;
	export const flowRuleDatatype: X3EnumDataType<keyof FlowRule$EnumInterface, unknown>;
	//# sourceMappingURL=flow-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/flow-classes.d.ts
declare module '@sage/x3-master-data/lib/enums/flow-classes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FlowClassesEnum {
	    intangible = 1,
	    tangible = 2,
	    inProcess = 3,
	    financial = 4
	}
	export interface FlowClasses$EnumInterface {
	    intangible: 1;
	    tangible: 2;
	    inProcess: 3;
	    financial: 4;
	}
	export type FlowClasses = keyof FlowClasses$EnumInterface;
	export const flowClassesDatatype: X3EnumDataType<keyof FlowClasses$EnumInterface, unknown>;
	//# sourceMappingURL=flow-classes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/fixed-asset-type.d.ts
declare module '@sage/x3-master-data/lib/enums/fixed-asset-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FixedAssetTypeEnum {
	    tangible = 1,
	    intangible = 2,
	    goodwill = 3,
	    financial = 4,
	    investmentProperties = 5,
	    biologicalAssets = 6
	}
	export interface FixedAssetType$EnumInterface {
	    tangible: 1;
	    intangible: 2;
	    goodwill: 3;
	    financial: 4;
	    investmentProperties: 5;
	    biologicalAssets: 6;
	}
	export type FixedAssetType = keyof FixedAssetType$EnumInterface;
	export const fixedAssetTypeDatatype: X3EnumDataType<keyof FixedAssetType$EnumInterface, unknown>;
	//# sourceMappingURL=fixed-asset-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/fixed-asset-numbering.d.ts
declare module '@sage/x3-master-data/lib/enums/fixed-asset-numbering' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FixedAssetNumberingEnum {
	    assetReference = 1,
	    expenseReference = 2,
	    barCodes = 3,
	    productionScheduleReference = 4,
	    physicalAssetReference = 5,
	    contractReference = 6,
	    grantReference = 7,
	    concessionContractReference = 8,
	    priorDistributionReference = 9,
	    locationReference = 10
	}
	export interface FixedAssetNumbering$EnumInterface {
	    assetReference: 1;
	    expenseReference: 2;
	    barCodes: 3;
	    productionScheduleReference: 4;
	    physicalAssetReference: 5;
	    contractReference: 6;
	    grantReference: 7;
	    concessionContractReference: 8;
	    priorDistributionReference: 9;
	    locationReference: 10;
	}
	export type FixedAssetNumbering = keyof FixedAssetNumbering$EnumInterface;
	export const fixedAssetNumberingDatatype: X3EnumDataType<keyof FixedAssetNumbering$EnumInterface, unknown>;
	//# sourceMappingURL=fixed-asset-numbering.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/fiscal-year-period-status.d.ts
declare module '@sage/x3-master-data/lib/enums/fiscal-year-period-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FiscalYearPeriodStatusEnum {
	    notOpen = 1,
	    open = 2,
	    closed = 3
	}
	export interface FiscalYearPeriodStatus$EnumInterface {
	    notOpen: 1;
	    open: 2;
	    closed: 3;
	}
	export type FiscalYearPeriodStatus = keyof FiscalYearPeriodStatus$EnumInterface;
	export const fiscalYearPeriodStatusDatatype: X3EnumDataType<keyof FiscalYearPeriodStatus$EnumInterface, unknown>;
	//# sourceMappingURL=fiscal-year-period-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/financial-year-type.d.ts
declare module '@sage/x3-master-data/lib/enums/financial-year-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FinancialYearTypeEnum {
	    closed = 1,
	    current = 2,
	    next = 3,
	    next1 = 4
	}
	export interface FinancialYearType$EnumInterface {
	    closed: 1;
	    current: 2;
	    next: 3;
	    next1: 4;
	}
	export type FinancialYearType = keyof FinancialYearType$EnumInterface;
	export const financialYearTypeDatatype: X3EnumDataType<keyof FinancialYearType$EnumInterface, unknown>;
	//# sourceMappingURL=financial-year-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/financial-year-or-period.d.ts
declare module '@sage/x3-master-data/lib/enums/financial-year-or-period' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FinancialYearOrPeriodEnum {
	    financialYear = 1,
	    period = 2,
	    periodTotal = 3
	}
	export interface FinancialYearOrPeriod$EnumInterface {
	    financialYear: 1;
	    period: 2;
	    periodTotal: 3;
	}
	export type FinancialYearOrPeriod = keyof FinancialYearOrPeriod$EnumInterface;
	export const financialYearOrPeriodDatatype: X3EnumDataType<keyof FinancialYearOrPeriod$EnumInterface, unknown>;
	//# sourceMappingURL=financial-year-or-period.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/financial-statement-pages-3618.d.ts
declare module '@sage/x3-master-data/lib/enums/financial-statement-pages-3618' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FinancialStatementPages3618Enum {
	    main = 1,
	    annexR1 = 2,
	    annexR2 = 3
	}
	export interface FinancialStatementPages3618$EnumInterface {
	    main: 1;
	    annexR1: 2;
	    annexR2: 3;
	}
	export type FinancialStatementPages3618 = keyof FinancialStatementPages3618$EnumInterface;
	export const financialStatementPages3618Datatype: X3EnumDataType<keyof FinancialStatementPages3618$EnumInterface, unknown>;
	//# sourceMappingURL=financial-statement-pages-3618.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/filter-on-order.d.ts
declare module '@sage/x3-master-data/lib/enums/filter-on-order' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FilterOnOrderEnum {
	    accordingToTheCustomer = 1,
	    accordingToTheRequest = 2
	}
	export interface FilterOnOrder$EnumInterface {
	    accordingToTheCustomer: 1;
	    accordingToTheRequest: 2;
	}
	export type FilterOnOrder = keyof FilterOnOrder$EnumInterface;
	export const filterOnOrderDatatype: X3EnumDataType<keyof FilterOnOrder$EnumInterface, unknown>;
	//# sourceMappingURL=filter-on-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/filter-on-actions.d.ts
declare module '@sage/x3-master-data/lib/enums/filter-on-actions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FilterOnActionsEnum {
	    accordingToBase = 1,
	    accordingToRequest = 2,
	    accordingToCustomer = 3
	}
	export interface FilterOnActions$EnumInterface {
	    accordingToBase: 1;
	    accordingToRequest: 2;
	    accordingToCustomer: 3;
	}
	export type FilterOnActions = keyof FilterOnActions$EnumInterface;
	export const filterOnActionsDatatype: X3EnumDataType<keyof FilterOnActions$EnumInterface, unknown>;
	//# sourceMappingURL=filter-on-actions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/file-type.d.ts
declare module '@sage/x3-master-data/lib/enums/file-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FileTypeEnum {
	    mt940 = 1,
	    csv = 2,
	    camt = 3,
	    bai = 4,
	    cfonb = 5,
	    fixedLength = 6
	}
	export interface FileType$EnumInterface {
	    mt940: 1;
	    csv: 2;
	    camt: 3;
	    bai: 4;
	    cfonb: 5;
	    fixedLength: 6;
	}
	export type FileType = keyof FileType$EnumInterface;
	export const fileTypeDatatype: X3EnumDataType<keyof FileType$EnumInterface, unknown>;
	//# sourceMappingURL=file-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/file-type-swiss-isr-import.d.ts
declare module '@sage/x3-master-data/lib/enums/file-type-swiss-isr-import' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FileTypeSwissIsrImportEnum {
	    fileType3 = 1,
	    fileType4 = 2
	}
	export interface FileTypeSwissIsrImport$EnumInterface {
	    fileType3: 1;
	    fileType4: 2;
	}
	export type FileTypeSwissIsrImport = keyof FileTypeSwissIsrImport$EnumInterface;
	export const fileTypeSwissIsrImportDatatype: X3EnumDataType<keyof FileTypeSwissIsrImport$EnumInterface, unknown>;
	//# sourceMappingURL=file-type-swiss-isr-import.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/file-sort.d.ts
declare module '@sage/x3-master-data/lib/enums/file-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FileSortEnum {
	    product = 1,
	    supplier = 2
	}
	export interface FileSort$EnumInterface {
	    product: 1;
	    supplier: 2;
	}
	export type FileSort = keyof FileSort$EnumInterface;
	export const fileSortDatatype: X3EnumDataType<keyof FileSort$EnumInterface, unknown>;
	//# sourceMappingURL=file-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/field-type-for-statuses.d.ts
declare module '@sage/x3-master-data/lib/enums/field-type-for-statuses' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldTypeForStatusesEnum {
	    displayed = 1,
	    hidden = 2
	}
	export interface FieldTypeForStatuses$EnumInterface {
	    displayed: 1;
	    hidden: 2;
	}
	export type FieldTypeForStatuses = keyof FieldTypeForStatuses$EnumInterface;
	export const fieldTypeForStatusesDatatype: X3EnumDataType<keyof FieldTypeForStatuses$EnumInterface, unknown>;
	//# sourceMappingURL=field-type-for-statuses.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/field-type-3683.d.ts
declare module '@sage/x3-master-data/lib/enums/field-type-3683' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldType3683Enum {
	    alphanumeric = 1,
	    numeric = 2,
	    date = 3
	}
	export interface FieldType3683$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	    date: 3;
	}
	export type FieldType3683 = keyof FieldType3683$EnumInterface;
	export const fieldType3683Datatype: X3EnumDataType<keyof FieldType3683$EnumInterface, unknown>;
	//# sourceMappingURL=field-type-3683.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/field-type-252.d.ts
declare module '@sage/x3-master-data/lib/enums/field-type-252' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldType252Enum {
	    alphanumeric = 1,
	    numeric = 2,
	    date = 3,
	    boolean = 4,
	    text = 5,
	    photoImageFile = 6,
	    textFile = 7
	}
	export interface FieldType252$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	    date: 3;
	    boolean: 4;
	    text: 5;
	    photoImageFile: 6;
	    textFile: 7;
	}
	export type FieldType252 = keyof FieldType252$EnumInterface;
	export const fieldType252Datatype: X3EnumDataType<keyof FieldType252$EnumInterface, unknown>;
	//# sourceMappingURL=field-type-252.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/field-type-245.d.ts
declare module '@sage/x3-master-data/lib/enums/field-type-245' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldType245Enum {
	    alphanumeric = 1,
	    numeric = 2,
	    date = 3
	}
	export interface FieldType245$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	    date: 3;
	}
	export type FieldType245 = keyof FieldType245$EnumInterface;
	export const fieldType245Datatype: X3EnumDataType<keyof FieldType245$EnumInterface, unknown>;
	//# sourceMappingURL=field-type-245.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/factoring-type.d.ts
declare module '@sage/x3-master-data/lib/enums/factoring-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FactoringTypeEnum {
	    standard = 1,
	    recourse = 2,
	    noRecourse = 3
	}
	export interface FactoringType$EnumInterface {
	    standard: 1;
	    recourse: 2;
	    noRecourse: 3;
	}
	export type FactoringType = keyof FactoringType$EnumInterface;
	export const factoringTypeDatatype: X3EnumDataType<keyof FactoringType$EnumInterface, unknown>;
	//# sourceMappingURL=factoring-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/facfounba-sort-criterion.d.ts
declare module '@sage/x3-master-data/lib/enums/facfounba-sort-criterion' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FacfounbaSortCriterionEnum {
	    date = 1,
	    dueDate = 2,
	    supplier = 3
	}
	export interface FacfounbaSortCriterion$EnumInterface {
	    date: 1;
	    dueDate: 2;
	    supplier: 3;
	}
	export type FacfounbaSortCriterion = keyof FacfounbaSortCriterion$EnumInterface;
	export const facfounbaSortCriterionDatatype: X3EnumDataType<keyof FacfounbaSortCriterion$EnumInterface, unknown>;
	//# sourceMappingURL=facfounba-sort-criterion.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/expiration-management.d.ts
declare module '@sage/x3-master-data/lib/enums/expiration-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExpirationManagementEnum {
	    notManaged = 1,
	    withoutRounding = 2,
	    roundingMonthEnd = 3,
	    roundingBeginningMonth1 = 4,
	    mandatoryEntry = 5,
	    manualEntry = 6
	}
	export interface ExpirationManagement$EnumInterface {
	    notManaged: 1;
	    withoutRounding: 2;
	    roundingMonthEnd: 3;
	    roundingBeginningMonth1: 4;
	    mandatoryEntry: 5;
	    manualEntry: 6;
	}
	export type ExpirationManagement = keyof ExpirationManagement$EnumInterface;
	export const expirationManagementDatatype: X3EnumDataType<keyof ExpirationManagement$EnumInterface, unknown>;
	//# sourceMappingURL=expiration-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/expense-split-method.d.ts
declare module '@sage/x3-master-data/lib/enums/expense-split-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExpenseSplitMethodEnum {
	    quantity = 1,
	    amount = 2
	}
	export interface ExpenseSplitMethod$EnumInterface {
	    quantity: 1;
	    amount: 2;
	}
	export type ExpenseSplitMethod = keyof ExpenseSplitMethod$EnumInterface;
	export const expenseSplitMethodDatatype: X3EnumDataType<keyof ExpenseSplitMethod$EnumInterface, unknown>;
	//# sourceMappingURL=expense-split-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/execution-type-2998.d.ts
declare module '@sage/x3-master-data/lib/enums/execution-type-2998' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExecutionType2998Enum {
	    global = 1,
	    byBase = 2
	}
	export interface ExecutionType2998$EnumInterface {
	    global: 1;
	    byBase: 2;
	}
	export type ExecutionType2998 = keyof ExecutionType2998$EnumInterface;
	export const executionType2998Datatype: X3EnumDataType<keyof ExecutionType2998$EnumInterface, unknown>;
	//# sourceMappingURL=execution-type-2998.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/exception-type.d.ts
declare module '@sage/x3-master-data/lib/enums/exception-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExceptionTypeEnum {
	    withoutCorrespondence = 1,
	    multipleCorrespondence = 2
	}
	export interface ExceptionType$EnumInterface {
	    withoutCorrespondence: 1;
	    multipleCorrespondence: 2;
	}
	export type ExceptionType = keyof ExceptionType$EnumInterface;
	export const exceptionTypeDatatype: X3EnumDataType<keyof ExceptionType$EnumInterface, unknown>;
	//# sourceMappingURL=exception-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/event-types.d.ts
declare module '@sage/x3-master-data/lib/enums/event-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EventTypesEnum {
	    action = 1,
	    actionCancellation = 2
	}
	export interface EventTypes$EnumInterface {
	    action: 1;
	    actionCancellation: 2;
	}
	export type EventTypes = keyof EventTypes$EnumInterface;
	export const eventTypesDatatype: X3EnumDataType<keyof EventTypes$EnumInterface, unknown>;
	//# sourceMappingURL=event-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/evaluation-type.d.ts
declare module '@sage/x3-master-data/lib/enums/evaluation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EvaluationTypeEnum {
	    fixedRate = 1,
	    lowerValuePrinciple = 2,
	    higherValuePrinciple = 3
	}
	export interface EvaluationType$EnumInterface {
	    fixedRate: 1;
	    lowerValuePrinciple: 2;
	    higherValuePrinciple: 3;
	}
	export type EvaluationType = keyof EvaluationType$EnumInterface;
	export const evaluationTypeDatatype: X3EnumDataType<keyof EvaluationType$EnumInterface, unknown>;
	//# sourceMappingURL=evaluation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/escalation-type.d.ts
declare module '@sage/x3-master-data/lib/enums/escalation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EscalationTypeEnum {
	    hidden = 1,
	    archived = 2,
	    incremental = 3
	}
	export interface EscalationType$EnumInterface {
	    hidden: 1;
	    archived: 2;
	    incremental: 3;
	}
	export type EscalationType = keyof EscalationType$EnumInterface;
	export const escalationTypeDatatype: X3EnumDataType<keyof EscalationType$EnumInterface, unknown>;
	//# sourceMappingURL=escalation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/enum.d.ts
declare module '@sage/x3-master-data/lib/enums/enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EnumEnum {
	    outboundMessageVolume = 1,
	    inboundMessageVolume = 2,
	    archivedMessageVolume = 3,
	    failedMessageVolume = 4,
	    importVolume = 5,
	    volumeMustBeDefined = 6,
	    successful = 7,
	    warning = 8,
	    failed = 9,
	    statusUpdate = 10,
	    deletingTemporaryLog = 11,
	    deletingTemporaryStorageSpace = 12,
	    deletingDocumentTracking = 13,
	    copyOfTemporaryDocumentTracking1ToFinalDocumentTracking2 = 14,
	    copyOfTemporaryStorageSpace1ToFinalStorageSpace2 = 15,
	    readingNewStorageSpace = 16,
	    readingTemporaryStorageSpace = 17,
	    transferOfTemporaryStorageSpaces = 18,
	    noFilterDefined = 19,
	    noIndexDefinedInCategorySetup = 20,
	    noInstanceExported = 21,
	    noInstanceGenerated = 22,
	    noInstanceLoaded = 23,
	    errorCodeNonexistent = 24,
	    processing = 25,
	    endOfProcessing = 26,
	    summaryOfGlobalProcessing = 27,
	    processingDocumentList = 28,
	    noDocumentToProcess = 29,
	    flowControl = 30,
	    messageMappingControl = 31,
	    sequentialFileControl = 32,
	    recoveringCategoryFilters = 33,
	    recoveringFlowProperties = 34,
	    decoding = 35,
	    generatingPrototype = 36,
	    generatingDocumentListToProcess = 37,
	    insertionIntoTemporaryLog = 38,
	    serializingEntityUsingRepresentation = 39,
	    launchingEdiOutboundMessageProcessing = 40,
	    launchingEdiInboundProcessing = 41,
	    numberOfCheckedDocuments = 42,
	    numberOfDocumentsSuccessfullyGenerated = 43,
	    numberOfDocumentsSuccessfullyGeneratedInImportFile = 44,
	    numberOfDocumentsSuccessfullyInstantiated = 45,
	    numberOfDocumentsSuccessfullyProcessed = 46,
	    numberOfDocumentsSuccessfullySaved = 47,
	    numberOfDocumentsSuccessfullySavedInMongo = 48,
	    numberOfDocumentsSuccessfullySavedInStorageSpace = 49,
	    numberOfDocumentsSuccessfullySent = 50,
	    numberOfDocumentsToCheckFoundByTheQuery = 51,
	    numberOfDocumentsToProcess = 52,
	    numberOfValidAndActiveFlowsFound = 53,
	    creationOfALogLine = 54,
	    endOfLogFile = 55,
	    copyingEntityInCache = 56,
	    updatingEntityInCache = 57,
	    deletingEntityInCache = 58,
	    processingDocument = 59,
	    stage = 60,
	    testOutboundMessageVolume = 61,
	    testInboundMessageVolume = 62,
	    signedDocumentVolume = 63,
	    launchedSuccessfully = 64,
	    documentAlreadyInProgress = 65,
	    documentAlreadyProcessed = 66,
	    blindCopy = 67,
	    notificationMustBeIndicated = 68,
	    notificationDoesNotExist = 69,
	    processingRecords = 70,
	    preparingLogFile = 71,
	    launchingTheUpdateProcessingOfTheMongoDbBase = 72,
	    closingLogFile = 73,
	    numberOfWarnings = 74,
	    numberOfErrors = 75,
	    viewLogFile = 76,
	    noError = 77,
	    theProcessingFoundNoError = 78,
	    records = 79,
	    ediProtocolSetup = 80,
	    ediMessageMappingSetup = 81,
	    ediSequentialFileSetup = 82,
	    ediXsdFileSetup = 83,
	    ediXmlFileSetup = 84,
	    ediFlowSetup = 85,
	    objectNotFound = 86,
	    deletingUuidFromTheRecord = 87,
	    xsdPaths = 88,
	    dataClassDoesNotExist = 89,
	    readingRecord = 90,
	    checkingTheFileInTheMongoDbBase = 91,
	    testModeEnabledNoDocumentRecorded = 92,
	    numberOfRecordedDocuments = 93,
	    ediProcessCompleted = 94,
	    attachmentVolume = 95,
	    smtpServerNotification = 96,
	    notificationTheme = 97,
	    destinationAddress = 98,
	    subjectOfMail = 99,
	    tittleOfNotification = 100,
	    subtittleOfNotification = 101,
	    bodyOfMail = 102,
	    mailSignature = 103,
	    printServerVolume = 104
	}
	export interface Enum$EnumInterface {
	    outboundMessageVolume: 1;
	    inboundMessageVolume: 2;
	    archivedMessageVolume: 3;
	    failedMessageVolume: 4;
	    importVolume: 5;
	    volumeMustBeDefined: 6;
	    successful: 7;
	    warning: 8;
	    failed: 9;
	    statusUpdate: 10;
	    deletingTemporaryLog: 11;
	    deletingTemporaryStorageSpace: 12;
	    deletingDocumentTracking: 13;
	    copyOfTemporaryDocumentTracking1ToFinalDocumentTracking2: 14;
	    copyOfTemporaryStorageSpace1ToFinalStorageSpace2: 15;
	    readingNewStorageSpace: 16;
	    readingTemporaryStorageSpace: 17;
	    transferOfTemporaryStorageSpaces: 18;
	    noFilterDefined: 19;
	    noIndexDefinedInCategorySetup: 20;
	    noInstanceExported: 21;
	    noInstanceGenerated: 22;
	    noInstanceLoaded: 23;
	    errorCodeNonexistent: 24;
	    processing: 25;
	    endOfProcessing: 26;
	    summaryOfGlobalProcessing: 27;
	    processingDocumentList: 28;
	    noDocumentToProcess: 29;
	    flowControl: 30;
	    messageMappingControl: 31;
	    sequentialFileControl: 32;
	    recoveringCategoryFilters: 33;
	    recoveringFlowProperties: 34;
	    decoding: 35;
	    generatingPrototype: 36;
	    generatingDocumentListToProcess: 37;
	    insertionIntoTemporaryLog: 38;
	    serializingEntityUsingRepresentation: 39;
	    launchingEdiOutboundMessageProcessing: 40;
	    launchingEdiInboundProcessing: 41;
	    numberOfCheckedDocuments: 42;
	    numberOfDocumentsSuccessfullyGenerated: 43;
	    numberOfDocumentsSuccessfullyGeneratedInImportFile: 44;
	    numberOfDocumentsSuccessfullyInstantiated: 45;
	    numberOfDocumentsSuccessfullyProcessed: 46;
	    numberOfDocumentsSuccessfullySaved: 47;
	    numberOfDocumentsSuccessfullySavedInMongo: 48;
	    numberOfDocumentsSuccessfullySavedInStorageSpace: 49;
	    numberOfDocumentsSuccessfullySent: 50;
	    numberOfDocumentsToCheckFoundByTheQuery: 51;
	    numberOfDocumentsToProcess: 52;
	    numberOfValidAndActiveFlowsFound: 53;
	    creationOfALogLine: 54;
	    endOfLogFile: 55;
	    copyingEntityInCache: 56;
	    updatingEntityInCache: 57;
	    deletingEntityInCache: 58;
	    processingDocument: 59;
	    stage: 60;
	    testOutboundMessageVolume: 61;
	    testInboundMessageVolume: 62;
	    signedDocumentVolume: 63;
	    launchedSuccessfully: 64;
	    documentAlreadyInProgress: 65;
	    documentAlreadyProcessed: 66;
	    blindCopy: 67;
	    notificationMustBeIndicated: 68;
	    notificationDoesNotExist: 69;
	    processingRecords: 70;
	    preparingLogFile: 71;
	    launchingTheUpdateProcessingOfTheMongoDbBase: 72;
	    closingLogFile: 73;
	    numberOfWarnings: 74;
	    numberOfErrors: 75;
	    viewLogFile: 76;
	    noError: 77;
	    theProcessingFoundNoError: 78;
	    records: 79;
	    ediProtocolSetup: 80;
	    ediMessageMappingSetup: 81;
	    ediSequentialFileSetup: 82;
	    ediXsdFileSetup: 83;
	    ediXmlFileSetup: 84;
	    ediFlowSetup: 85;
	    objectNotFound: 86;
	    deletingUuidFromTheRecord: 87;
	    xsdPaths: 88;
	    dataClassDoesNotExist: 89;
	    readingRecord: 90;
	    checkingTheFileInTheMongoDbBase: 91;
	    testModeEnabledNoDocumentRecorded: 92;
	    numberOfRecordedDocuments: 93;
	    ediProcessCompleted: 94;
	    attachmentVolume: 95;
	    smtpServerNotification: 96;
	    notificationTheme: 97;
	    destinationAddress: 98;
	    subjectOfMail: 99;
	    tittleOfNotification: 100;
	    subtittleOfNotification: 101;
	    bodyOfMail: 102;
	    mailSignature: 103;
	    printServerVolume: 104;
	}
	export type Enum = keyof Enum$EnumInterface;
	export const enumDatatype: X3EnumDataType<keyof Enum$EnumInterface, unknown>;
	//# sourceMappingURL=enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/entry-of-grid-data.d.ts
declare module '@sage/x3-master-data/lib/enums/entry-of-grid-data' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryOfGridDataEnum {
	    gridAndRecord = 1,
	    grid = 2,
	    record = 3
	}
	export interface EntryOfGridData$EnumInterface {
	    gridAndRecord: 1;
	    grid: 2;
	    record: 3;
	}
	export type EntryOfGridData = keyof EntryOfGridData$EnumInterface;
	export const entryOfGridDataDatatype: X3EnumDataType<keyof EntryOfGridData$EnumInterface, unknown>;
	//# sourceMappingURL=entry-of-grid-data.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/entity-type-business-partner-site.d.ts
declare module '@sage/x3-master-data/lib/enums/entity-type-business-partner-site' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntityTypeBusinessPartnerSiteEnum {
	    businessPartners = 1,
	    company = 2,
	    site = 3,
	    user = 4,
	    accounts = 5
	}
	export interface EntityTypeBusinessPartnerSite$EnumInterface {
	    businessPartners: 1;
	    company: 2;
	    site: 3;
	    user: 4;
	    accounts: 5;
	}
	export type EntityTypeBusinessPartnerSite = keyof EntityTypeBusinessPartnerSite$EnumInterface;
	export const entityTypeBusinessPartnerSiteDatatype: X3EnumDataType<keyof EntityTypeBusinessPartnerSite$EnumInterface, unknown>;
	//# sourceMappingURL=entity-type-business-partner-site.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/entities.d.ts
declare module '@sage/x3-master-data/lib/enums/entities' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntitiesEnum {
	    product = 1,
	    customer = 2,
	    supplier = 3,
	    salesRep = 4,
	    user = 5,
	    overhead = 6,
	    expensesForExpenseNotes7 = 7,
	    currency = 8,
	    tax = 9,
	    salesInvoiceFooter = 10,
	    earlyDiscount = 11,
	    bank = 12,
	    paymentAttribute = 13,
	    purchaseInvoiceFooter = 14,
	    miscellaneousBp = 15,
	    costingDimension = 16,
	    purchaseCost = 17,
	    employee = 18,
	    department = 19,
	    profile = 20,
	    event = 21,
	    natureOfActivity = 22,
	    expensesForExpenseNotes = 23
	}
	export interface Entities$EnumInterface {
	    product: 1;
	    customer: 2;
	    supplier: 3;
	    salesRep: 4;
	    user: 5;
	    overhead: 6;
	    expensesForExpenseNotes7: 7;
	    currency: 8;
	    tax: 9;
	    salesInvoiceFooter: 10;
	    earlyDiscount: 11;
	    bank: 12;
	    paymentAttribute: 13;
	    purchaseInvoiceFooter: 14;
	    miscellaneousBp: 15;
	    costingDimension: 16;
	    purchaseCost: 17;
	    employee: 18;
	    department: 19;
	    profile: 20;
	    event: 21;
	    natureOfActivity: 22;
	    expensesForExpenseNotes: 23;
	}
	export type Entities = keyof Entities$EnumInterface;
	export const entitiesDatatype: X3EnumDataType<keyof Entities$EnumInterface, unknown>;
	//# sourceMappingURL=entities.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/entities-managed-by-company.d.ts
declare module '@sage/x3-master-data/lib/enums/entities-managed-by-company' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntitiesManagedByCompanyEnum {
	    businessPartner = 1,
	    customerProspect = 2,
	    shipToCustomer = 3,
	    supplier = 4,
	    product = 5,
	    productSales = 6,
	    productCustomer = 7,
	    productSupplier = 8,
	    salesInvoicingElements = 9,
	    purchaseInvoicingElements = 10,
	    secondaryRepresentatives = 11,
	    prospect = 12
	}
	export interface EntitiesManagedByCompany$EnumInterface {
	    businessPartner: 1;
	    customerProspect: 2;
	    shipToCustomer: 3;
	    supplier: 4;
	    product: 5;
	    productSales: 6;
	    productCustomer: 7;
	    productSupplier: 8;
	    salesInvoicingElements: 9;
	    purchaseInvoicingElements: 10;
	    secondaryRepresentatives: 11;
	    prospect: 12;
	}
	export type EntitiesManagedByCompany = keyof EntitiesManagedByCompany$EnumInterface;
	export const entitiesManagedByCompanyDatatype: X3EnumDataType<keyof EntitiesManagedByCompany$EnumInterface, unknown>;
	//# sourceMappingURL=entities-managed-by-company.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/end-of-month-calculation.d.ts
declare module '@sage/x3-master-data/lib/enums/end-of-month-calculation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EndOfMonthCalculationEnum {
	    no = 1,
	    endOfNextMonth = 2,
	    endOfCurrentMonth = 3
	}
	export interface EndOfMonthCalculation$EnumInterface {
	    no: 1;
	    endOfNextMonth: 2;
	    endOfCurrentMonth: 3;
	}
	export type EndOfMonthCalculation = keyof EndOfMonthCalculation$EnumInterface;
	export const endOfMonthCalculationDatatype: X3EnumDataType<keyof EndOfMonthCalculation$EnumInterface, unknown>;
	//# sourceMappingURL=end-of-month-calculation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/empty-or-main.d.ts
declare module '@sage/x3-master-data/lib/enums/empty-or-main' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EmptyOrMainEnum {
	    empty = 1,
	    main = 2
	}
	export interface EmptyOrMain$EnumInterface {
	    empty: 1;
	    main: 2;
	}
	export type EmptyOrMain = keyof EmptyOrMain$EnumInterface;
	export const emptyOrMainDatatype: X3EnumDataType<keyof EmptyOrMain$EnumInterface, unknown>;
	//# sourceMappingURL=empty-or-main.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/employee-type.d.ts
declare module '@sage/x3-master-data/lib/enums/employee-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EmployeeTypeEnum {
	    employee = 1,
	    detailedTeam = 2,
	    summaryTeam = 3
	}
	export interface EmployeeType$EnumInterface {
	    employee: 1;
	    detailedTeam: 2;
	    summaryTeam: 3;
	}
	export type EmployeeType = keyof EmployeeType$EnumInterface;
	export const employeeTypeDatatype: X3EnumDataType<keyof EmployeeType$EnumInterface, unknown>;
	//# sourceMappingURL=employee-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/employee-search-type.d.ts
declare module '@sage/x3-master-data/lib/enums/employee-search-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EmployeeSearchTypeEnum {
	    all = 1,
	    competent = 2
	}
	export interface EmployeeSearchType$EnumInterface {
	    all: 1;
	    competent: 2;
	}
	export type EmployeeSearchType = keyof EmployeeSearchType$EnumInterface;
	export const employeeSearchTypeDatatype: X3EnumDataType<keyof EmployeeSearchType$EnumInterface, unknown>;
	//# sourceMappingURL=employee-search-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/employee-availability.d.ts
declare module '@sage/x3-master-data/lib/enums/employee-availability' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EmployeeAvailabilityEnum {
	    available = 1,
	    proposal = 2,
	    unavailable = 3,
	    reserved = 4,
	    appointment = 5,
	    serviceResponse = 6,
	    absent = 7
	}
	export interface EmployeeAvailability$EnumInterface {
	    available: 1;
	    proposal: 2;
	    unavailable: 3;
	    reserved: 4;
	    appointment: 5;
	    serviceResponse: 6;
	    absent: 7;
	}
	export type EmployeeAvailability = keyof EmployeeAvailability$EnumInterface;
	export const employeeAvailabilityDatatype: X3EnumDataType<keyof EmployeeAvailability$EnumInterface, unknown>;
	//# sourceMappingURL=employee-availability.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/employee-availability-992.d.ts
declare module '@sage/x3-master-data/lib/enums/employee-availability-992' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EmployeeAvailability992Enum {
	    all = 1,
	    onlyWithAvailability = 2
	}
	export interface EmployeeAvailability992$EnumInterface {
	    all: 1;
	    onlyWithAvailability: 2;
	}
	export type EmployeeAvailability992 = keyof EmployeeAvailability992$EnumInterface;
	export const employeeAvailability992Datatype: X3EnumDataType<keyof EmployeeAvailability992$EnumInterface, unknown>;
	//# sourceMappingURL=employee-availability-992.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/elements-concerned.d.ts
declare module '@sage/x3-master-data/lib/enums/elements-concerned' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ElementsConcernedEnum {
	    all = 1,
	    serviceRequest = 2,
	    base = 3,
	    component = 4,
	    consumption = 5,
	    serviceResponse = 6
	}
	export interface ElementsConcerned$EnumInterface {
	    all: 1;
	    serviceRequest: 2;
	    base: 3;
	    component: 4;
	    consumption: 5;
	    serviceResponse: 6;
	}
	export type ElementsConcerned = keyof ElementsConcerned$EnumInterface;
	export const elementsConcernedDatatype: X3EnumDataType<keyof ElementsConcerned$EnumInterface, unknown>;
	//# sourceMappingURL=elements-concerned.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/electronic-invoice-type.d.ts
declare module '@sage/x3-master-data/lib/enums/electronic-invoice-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ElectronicInvoiceTypeEnum {
	    notUsed = 1,
	    xmlByMail = 2,
	    pdfByMail = 3,
	    eInvoiceFileByMail = 4,
	    xmlByPlatform = 5,
	    pdfByPlatform = 6,
	    eInvoiceFileByPlatform = 7
	}
	export interface ElectronicInvoiceType$EnumInterface {
	    notUsed: 1;
	    xmlByMail: 2;
	    pdfByMail: 3;
	    eInvoiceFileByMail: 4;
	    xmlByPlatform: 5;
	    pdfByPlatform: 6;
	    eInvoiceFileByPlatform: 7;
	}
	export type ElectronicInvoiceType = keyof ElectronicInvoiceType$EnumInterface;
	export const electronicInvoiceTypeDatatype: X3EnumDataType<keyof ElectronicInvoiceType$EnumInterface, unknown>;
	//# sourceMappingURL=electronic-invoice-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/einvoicing-status.d.ts
declare module '@sage/x3-master-data/lib/enums/einvoicing-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EinvoicingStatusEnum {
	    toBeMapped = 1,
	    incompleteMapping = 2,
	    mapped = 3,
	    generated = 4,
	    error = 5
	}
	export interface EinvoicingStatus$EnumInterface {
	    toBeMapped: 1;
	    incompleteMapping: 2;
	    mapped: 3;
	    generated: 4;
	    error: 5;
	}
	export type EinvoicingStatus = keyof EinvoicingStatus$EnumInterface;
	export const einvoicingStatusDatatype: X3EnumDataType<keyof EinvoicingStatus$EnumInterface, unknown>;
	//# sourceMappingURL=einvoicing-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/einvoicing-partial-matching.d.ts
declare module '@sage/x3-master-data/lib/enums/einvoicing-partial-matching' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EinvoicingPartialMatchingEnum {
	    no = 1,
	    yes = 2,
	    warning = 3
	}
	export interface EinvoicingPartialMatching$EnumInterface {
	    no: 1;
	    yes: 2;
	    warning: 3;
	}
	export type EinvoicingPartialMatching = keyof EinvoicingPartialMatching$EnumInterface;
	export const einvoicingPartialMatchingDatatype: X3EnumDataType<keyof EinvoicingPartialMatching$EnumInterface, unknown>;
	//# sourceMappingURL=einvoicing-partial-matching.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/einvoicing-mapping.d.ts
declare module '@sage/x3-master-data/lib/enums/einvoicing-mapping' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EinvoicingMappingEnum {
	    facturX = 1
	}
	export interface EinvoicingMapping$EnumInterface {
	    facturX: 1;
	}
	export type EinvoicingMapping = keyof EinvoicingMapping$EnumInterface;
	export const einvoicingMappingDatatype: X3EnumDataType<"facturX", unknown>;
	//# sourceMappingURL=einvoicing-mapping.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/efat-status.d.ts
declare module '@sage/x3-master-data/lib/enums/efat-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EfatStatusEnum {
	    notSent = 1,
	    sentWithError = 2,
	    pendingResponseFromEfat = 3,
	    pendingResponseFromBusinessPartner = 4,
	    communicationSuccessful = 5
	}
	export interface EfatStatus$EnumInterface {
	    notSent: 1;
	    sentWithError: 2;
	    pendingResponseFromEfat: 3;
	    pendingResponseFromBusinessPartner: 4;
	    communicationSuccessful: 5;
	}
	export type EfatStatus = keyof EfatStatus$EnumInterface;
	export const efatStatusDatatype: X3EnumDataType<keyof EfatStatus$EnumInterface, unknown>;
	//# sourceMappingURL=efat-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/edi-status.d.ts
declare module '@sage/x3-master-data/lib/enums/edi-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EdiStatusEnum {
	    pending = 1,
	    inProgress = 2,
	    completed = 3,
	    error = 4
	}
	export interface EdiStatus$EnumInterface {
	    pending: 1;
	    inProgress: 2;
	    completed: 3;
	    error: 4;
	}
	export type EdiStatus = keyof EdiStatus$EnumInterface;
	export const ediStatusDatatype: X3EnumDataType<keyof EdiStatus$EnumInterface, unknown>;
	//# sourceMappingURL=edi-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/edi-partner-type.d.ts
declare module '@sage/x3-master-data/lib/enums/edi-partner-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EdiPartnerTypeEnum {
	    companyControl = 1,
	    bpCompanyControl = 2,
	    noControl = 3
	}
	export interface EdiPartnerType$EnumInterface {
	    companyControl: 1;
	    bpCompanyControl: 2;
	    noControl: 3;
	}
	export type EdiPartnerType = keyof EdiPartnerType$EnumInterface;
	export const ediPartnerTypeDatatype: X3EnumDataType<keyof EdiPartnerType$EnumInterface, unknown>;
	//# sourceMappingURL=edi-partner-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/edi-events.d.ts
declare module '@sage/x3-master-data/lib/enums/edi-events' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EdiEventsEnum {
	    checkingEdiAuthorizationsForCompanies = 1,
	    checkingEdiAuthorizationsForSites = 2,
	    checkingEdiAuthorizationsForBpAddresses = 3,
	    checkingCombinationOfEdiFlowWithBpCompanies = 4,
	    recoveringEdiFlowInformation = 5,
	    checkingEdiFlowSetup = 6,
	    ediDocumentProcessing = 7,
	    ediDocumentStatus = 8,
	    newEdiDocumentProcessing = 9,
	    creatingEdiTemporaryStorageSpace = 10,
	    updatingStatusOfTheEdiTemporaryStorageSpace = 11,
	    accessingTheEdiTemporaryStorageSpace = 12,
	    instantiatingEdiRepresentation = 13,
	    updatingTheUuidOfTheEdiRepresentationInstance = 14,
	    processingEdiFileGeneration = 15,
	    sendingEdiFile = 16,
	    controlingEdiFlow = 17,
	    controlingEdiMessageMapping = 18,
	    controlingEdiSequentialFile = 19,
	    generatingEdiImportFile = 20,
	    copyingEdiTemporaryStorageSpaceAndDocumentTracking = 21,
	    checkingEdiFlow = 22,
	    checkingEdiMessageMapping = 23,
	    checkingEdiSequentialFile = 24,
	    incorrectEdiFlowParameters = 25,
	    loadingEdiRepresentationInstance = 26,
	    savingEdiRepresentationInstance = 27,
	    testMode = 28,
	    theDocumentHasAlreadyBeenProcessedSelectTheDuplicateOptionToProcessItAgain = 29,
	    theDocumentIsACopyAndCannotBeProcessed = 30,
	    generatingTheEdiRepresentationPrototype = 31,
	    processCompletedSuccessfully = 32,
	    processCompletedWithErrors = 33,
	    updatingTemporaryStorageSpace = 34,
	    signingEdiGeneratedFile = 35,
	    userCertificateOrPrivateKeyNotFound = 36
	}
	export interface EdiEvents$EnumInterface {
	    checkingEdiAuthorizationsForCompanies: 1;
	    checkingEdiAuthorizationsForSites: 2;
	    checkingEdiAuthorizationsForBpAddresses: 3;
	    checkingCombinationOfEdiFlowWithBpCompanies: 4;
	    recoveringEdiFlowInformation: 5;
	    checkingEdiFlowSetup: 6;
	    ediDocumentProcessing: 7;
	    ediDocumentStatus: 8;
	    newEdiDocumentProcessing: 9;
	    creatingEdiTemporaryStorageSpace: 10;
	    updatingStatusOfTheEdiTemporaryStorageSpace: 11;
	    accessingTheEdiTemporaryStorageSpace: 12;
	    instantiatingEdiRepresentation: 13;
	    updatingTheUuidOfTheEdiRepresentationInstance: 14;
	    processingEdiFileGeneration: 15;
	    sendingEdiFile: 16;
	    controlingEdiFlow: 17;
	    controlingEdiMessageMapping: 18;
	    controlingEdiSequentialFile: 19;
	    generatingEdiImportFile: 20;
	    copyingEdiTemporaryStorageSpaceAndDocumentTracking: 21;
	    checkingEdiFlow: 22;
	    checkingEdiMessageMapping: 23;
	    checkingEdiSequentialFile: 24;
	    incorrectEdiFlowParameters: 25;
	    loadingEdiRepresentationInstance: 26;
	    savingEdiRepresentationInstance: 27;
	    testMode: 28;
	    theDocumentHasAlreadyBeenProcessedSelectTheDuplicateOptionToProcessItAgain: 29;
	    theDocumentIsACopyAndCannotBeProcessed: 30;
	    generatingTheEdiRepresentationPrototype: 31;
	    processCompletedSuccessfully: 32;
	    processCompletedWithErrors: 33;
	    updatingTemporaryStorageSpace: 34;
	    signingEdiGeneratedFile: 35;
	    userCertificateOrPrivateKeyNotFound: 36;
	}
	export type EdiEvents = keyof EdiEvents$EnumInterface;
	export const ediEventsDatatype: X3EnumDataType<keyof EdiEvents$EnumInterface, unknown>;
	//# sourceMappingURL=edi-events.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/e-invoicing-status.d.ts
declare module '@sage/x3-master-data/lib/enums/e-invoicing-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EInvoicingStatusEnum {
	    pending = 1,
	    fileGenerated = 2,
	    pdfGenerated = 3,
	    documentGenerated = 4,
	    inError = 5
	}
	export interface EInvoicingStatus$EnumInterface {
	    pending: 1;
	    fileGenerated: 2;
	    pdfGenerated: 3;
	    documentGenerated: 4;
	    inError: 5;
	}
	export type EInvoicingStatus = keyof EInvoicingStatus$EnumInterface;
	export const eInvoicingStatusDatatype: X3EnumDataType<keyof EInvoicingStatus$EnumInterface, unknown>;
	//# sourceMappingURL=e-invoicing-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/duplicate-authorization.d.ts
declare module '@sage/x3-master-data/lib/enums/duplicate-authorization' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DuplicateAuthorizationEnum {
	    authorized = 1,
	    notAuthorized = 2
	}
	export interface DuplicateAuthorization$EnumInterface {
	    authorized: 1;
	    notAuthorized: 2;
	}
	export type DuplicateAuthorization = keyof DuplicateAuthorization$EnumInterface;
	export const duplicateAuthorizationDatatype: X3EnumDataType<keyof DuplicateAuthorization$EnumInterface, unknown>;
	//# sourceMappingURL=duplicate-authorization.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/due-date-in-discount-block.d.ts
declare module '@sage/x3-master-data/lib/enums/due-date-in-discount-block' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DueDateInDiscountBlockEnum {
	    activated = 1,
	    deactivated = 2
	}
	export interface DueDateInDiscountBlock$EnumInterface {
	    activated: 1;
	    deactivated: 2;
	}
	export type DueDateInDiscountBlock = keyof DueDateInDiscountBlock$EnumInterface;
	export const dueDateInDiscountBlockDatatype: X3EnumDataType<keyof DueDateInDiscountBlock$EnumInterface, unknown>;
	//# sourceMappingURL=due-date-in-discount-block.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/document-types.d.ts
declare module '@sage/x3-master-data/lib/enums/document-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentTypesEnum {
	    supplierInvoice = 1,
	    customerInvoice = 2
	}
	export interface DocumentTypes$EnumInterface {
	    supplierInvoice: 1;
	    customerInvoice: 2;
	}
	export type DocumentTypes = keyof DocumentTypes$EnumInterface;
	export const documentTypesDatatype: X3EnumDataType<keyof DocumentTypes$EnumInterface, unknown>;
	//# sourceMappingURL=document-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/document-type.d.ts
declare module '@sage/x3-master-data/lib/enums/document-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentTypeEnum {
	    siteTaxIdNumber = 1,
	    intracommunityTaxIdNumber = 2,
	    passport = 3,
	    officialDocument = 4,
	    fiscalResidenceCertificate = 5,
	    others = 6,
	    notRegistered = 7
	}
	export interface DocumentType$EnumInterface {
	    siteTaxIdNumber: 1;
	    intracommunityTaxIdNumber: 2;
	    passport: 3;
	    officialDocument: 4;
	    fiscalResidenceCertificate: 5;
	    others: 6;
	    notRegistered: 7;
	}
	export type DocumentType = keyof DocumentType$EnumInterface;
	export const documentTypeDatatype: X3EnumDataType<keyof DocumentType$EnumInterface, unknown>;
	//# sourceMappingURL=document-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/document-status.d.ts
declare module '@sage/x3-master-data/lib/enums/document-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentStatusEnum {
	    pending = 1,
	    dataSnapshot = 2,
	    outOfScope = 3,
	    sent = 4
	}
	export interface DocumentStatus$EnumInterface {
	    pending: 1;
	    dataSnapshot: 2;
	    outOfScope: 3;
	    sent: 4;
	}
	export type DocumentStatus = keyof DocumentStatus$EnumInterface;
	export const documentStatusDatatype: X3EnumDataType<keyof DocumentStatus$EnumInterface, unknown>;
	//# sourceMappingURL=document-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/document-source.d.ts
declare module '@sage/x3-master-data/lib/enums/document-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentSourceEnum {
	    purchasing = 1,
	    sales = 2,
	    stock = 3,
	    production = 4,
	    mps = 5,
	    mrp = 6,
	    projet = 7
	}
	export interface DocumentSource$EnumInterface {
	    purchasing: 1;
	    sales: 2;
	    stock: 3;
	    production: 4;
	    mps: 5;
	    mrp: 6;
	    projet: 7;
	}
	export type DocumentSource = keyof DocumentSource$EnumInterface;
	export const documentSourceDatatype: X3EnumDataType<keyof DocumentSource$EnumInterface, unknown>;
	//# sourceMappingURL=document-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/document-classification.d.ts
declare module '@sage/x3-master-data/lib/enums/document-classification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentClassificationEnum {
	    automatic = 1,
	    manual = 2
	}
	export interface DocumentClassification$EnumInterface {
	    automatic: 1;
	    manual: 2;
	}
	export type DocumentClassification = keyof DocumentClassification$EnumInterface;
	export const documentClassificationDatatype: X3EnumDataType<keyof DocumentClassification$EnumInterface, unknown>;
	//# sourceMappingURL=document-classification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/document-batch-status.d.ts
declare module '@sage/x3-master-data/lib/enums/document-batch-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentBatchStatusEnum {
	    accepted = 1,
	    partiallyAccepted = 2,
	    rejected = 3
	}
	export interface DocumentBatchStatus$EnumInterface {
	    accepted: 1;
	    partiallyAccepted: 2;
	    rejected: 3;
	}
	export type DocumentBatchStatus = keyof DocumentBatchStatus$EnumInterface;
	export const documentBatchStatusDatatype: X3EnumDataType<keyof DocumentBatchStatus$EnumInterface, unknown>;
	//# sourceMappingURL=document-batch-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/distribution-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/distribution-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DistributionRuleEnum {
	    periodDistribution = 1,
	    substituteValue2 = 2
	}
	export interface DistributionRule$EnumInterface {
	    periodDistribution: 1;
	    substituteValue2: 2;
	}
	export type DistributionRule = keyof DistributionRule$EnumInterface;
	export const distributionRuleDatatype: X3EnumDataType<keyof DistributionRule$EnumInterface, unknown>;
	//# sourceMappingURL=distribution-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/distribution-key-split.d.ts
declare module '@sage/x3-master-data/lib/enums/distribution-key-split' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DistributionKeySplitEnum {
	    group = 1,
	    accountingCode = 2,
	    coAAccount = 3,
	    ifrsAccount = 4
	}
	export interface DistributionKeySplit$EnumInterface {
	    group: 1;
	    accountingCode: 2;
	    coAAccount: 3;
	    ifrsAccount: 4;
	}
	export type DistributionKeySplit = keyof DistributionKeySplit$EnumInterface;
	export const distributionKeySplitDatatype: X3EnumDataType<keyof DistributionKeySplit$EnumInterface, unknown>;
	//# sourceMappingURL=distribution-key-split.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/distribution-key-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/distribution-key-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DistributionKeyRuleEnum {
	    netValueOfThePlan = 1,
	    coABalanceSheetValue = 2,
	    iasIfrsBalanceSheetValue = 3
	}
	export interface DistributionKeyRule$EnumInterface {
	    netValueOfThePlan: 1;
	    coABalanceSheetValue: 2;
	    iasIfrsBalanceSheetValue: 3;
	}
	export type DistributionKeyRule = keyof DistributionKeyRule$EnumInterface;
	export const distributionKeyRuleDatatype: X3EnumDataType<keyof DistributionKeyRule$EnumInterface, unknown>;
	//# sourceMappingURL=distribution-key-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/dispute-reason.d.ts
declare module '@sage/x3-master-data/lib/enums/dispute-reason' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DisputeReasonEnum {
	    revocation = 1,
	    reject = 2,
	    return = 3
	}
	export interface DisputeReason$EnumInterface {
	    revocation: 1;
	    reject: 2;
	    return: 3;
	}
	export type DisputeReason = keyof DisputeReason$EnumInterface;
	export const disputeReasonDatatype: X3EnumDataType<keyof DisputeReason$EnumInterface, unknown>;
	//# sourceMappingURL=dispute-reason.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/disposal-reason.d.ts
declare module '@sage/x3-master-data/lib/enums/disposal-reason' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DisposalReasonEnum {
	    sales = 1,
	    scrap = 2,
	    intraGroupSale = 3,
	    stolenOrDisappeared = 4,
	    leaseContractEnd5 = 5,
	    partialAcquisition = 6,
	    merger = 7,
	    split = 8,
	    leaseContractEnd = 9,
	    cancelledContract = 10,
	    importedAsset = 11,
	    renewal = 12,
	    transferredToGrantor = 13
	}
	export interface DisposalReason$EnumInterface {
	    sales: 1;
	    scrap: 2;
	    intraGroupSale: 3;
	    stolenOrDisappeared: 4;
	    leaseContractEnd5: 5;
	    partialAcquisition: 6;
	    merger: 7;
	    split: 8;
	    leaseContractEnd: 9;
	    cancelledContract: 10;
	    importedAsset: 11;
	    renewal: 12;
	    transferredToGrantor: 13;
	}
	export type DisposalReason = keyof DisposalReason$EnumInterface;
	export const disposalReasonDatatype: X3EnumDataType<keyof DisposalReason$EnumInterface, unknown>;
	//# sourceMappingURL=disposal-reason.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/disposal-reason-3175.d.ts
declare module '@sage/x3-master-data/lib/enums/disposal-reason-3175' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DisposalReason3175Enum {
	    notDisposed = 1,
	    stockCountIssue = 2,
	    sale = 3,
	    scrap = 4,
	    theftOrDisappearance = 5
	}
	export interface DisposalReason3175$EnumInterface {
	    notDisposed: 1;
	    stockCountIssue: 2;
	    sale: 3;
	    scrap: 4;
	    theftOrDisappearance: 5;
	}
	export type DisposalReason3175 = keyof DisposalReason3175$EnumInterface;
	export const disposalReason3175Datatype: X3EnumDataType<keyof DisposalReason3175$EnumInterface, unknown>;
	//# sourceMappingURL=disposal-reason-3175.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/discount-management-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/discount-management-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DiscountManagementModeEnum {
	    rebateOnVat = 1,
	    breakdownByVatInvoiceLevel = 2,
	    globalCalculation = 3,
	    breakdownByVatAccountLevel = 4,
	    rebateOnTaxExemptGlobal = 5
	}
	export interface DiscountManagementMode$EnumInterface {
	    rebateOnVat: 1;
	    breakdownByVatInvoiceLevel: 2;
	    globalCalculation: 3;
	    breakdownByVatAccountLevel: 4;
	    rebateOnTaxExemptGlobal: 5;
	}
	export type DiscountManagementMode = keyof DiscountManagementMode$EnumInterface;
	export const discountManagementModeDatatype: X3EnumDataType<keyof DiscountManagementMode$EnumInterface, unknown>;
	//# sourceMappingURL=discount-management-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/discount-date-type.d.ts
declare module '@sage/x3-master-data/lib/enums/discount-date-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DiscountDateTypeEnum {
	    earliestDiscountDate = 1,
	    latestDiscountDate = 2
	}
	export interface DiscountDateType$EnumInterface {
	    earliestDiscountDate: 1;
	    latestDiscountDate: 2;
	}
	export type DiscountDateType = keyof DiscountDateType$EnumInterface;
	export const discountDateTypeDatatype: X3EnumDataType<keyof DiscountDateType$EnumInterface, unknown>;
	//# sourceMappingURL=discount-date-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/discount-charge.d.ts
declare module '@sage/x3-master-data/lib/enums/discount-charge' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DiscountChargeEnum {
	    discount = 1,
	    charge = 2
	}
	export interface DiscountCharge$EnumInterface {
	    discount: 1;
	    charge: 2;
	}
	export type DiscountCharge = keyof DiscountCharge$EnumInterface;
	export const discountChargeDatatype: X3EnumDataType<keyof DiscountCharge$EnumInterface, unknown>;
	//# sourceMappingURL=discount-charge.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/discount-calculation.d.ts
declare module '@sage/x3-master-data/lib/enums/discount-calculation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DiscountCalculationEnum {
	    cumulated = 1,
	    compound = 2
	}
	export interface DiscountCalculation$EnumInterface {
	    cumulated: 1;
	    compound: 2;
	}
	export type DiscountCalculation = keyof DiscountCalculation$EnumInterface;
	export const discountCalculationDatatype: X3EnumDataType<keyof DiscountCalculation$EnumInterface, unknown>;
	//# sourceMappingURL=discount-calculation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/discount-calculation-rules.d.ts
declare module '@sage/x3-master-data/lib/enums/discount-calculation-rules' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DiscountCalculationRulesEnum {
	    amount = 1,
	    combined = 2,
	    series = 3
	}
	export interface DiscountCalculationRules$EnumInterface {
	    amount: 1;
	    combined: 2;
	    series: 3;
	}
	export type DiscountCalculationRules = keyof DiscountCalculationRules$EnumInterface;
	export const discountCalculationRulesDatatype: X3EnumDataType<keyof DiscountCalculationRules$EnumInterface, unknown>;
	//# sourceMappingURL=discount-calculation-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/direct-debit-type.d.ts
declare module '@sage/x3-master-data/lib/enums/direct-debit-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DirectDebitTypeEnum {
	    core = 1,
	    b2B = 2,
	    cor1 = 3
	}
	export interface DirectDebitType$EnumInterface {
	    core: 1;
	    b2B: 2;
	    cor1: 3;
	}
	export type DirectDebitType = keyof DirectDebitType$EnumInterface;
	export const directDebitTypeDatatype: X3EnumDataType<keyof DirectDebitType$EnumInterface, unknown>;
	//# sourceMappingURL=direct-debit-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/direct-debit-sequence.d.ts
declare module '@sage/x3-master-data/lib/enums/direct-debit-sequence' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DirectDebitSequenceEnum {
	    lastSequence = 1,
	    firstSequence = 2,
	    oneOffSequence = 3,
	    recurringSequence = 4
	}
	export interface DirectDebitSequence$EnumInterface {
	    lastSequence: 1;
	    firstSequence: 2;
	    oneOffSequence: 3;
	    recurringSequence: 4;
	}
	export type DirectDebitSequence = keyof DirectDebitSequence$EnumInterface;
	export const directDebitSequenceDatatype: X3EnumDataType<keyof DirectDebitSequence$EnumInterface, unknown>;
	//# sourceMappingURL=direct-debit-sequence.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/direct-associations.d.ts
declare module '@sage/x3-master-data/lib/enums/direct-associations' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DirectAssociationsEnum {
	    assetGroup = 1,
	    accountingCode = 2
	}
	export interface DirectAssociations$EnumInterface {
	    assetGroup: 1;
	    accountingCode: 2;
	}
	export type DirectAssociations = keyof DirectAssociations$EnumInterface;
	export const directAssociationsDatatype: X3EnumDataType<keyof DirectAssociations$EnumInterface, unknown>;
	//# sourceMappingURL=direct-associations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/dimension-types.d.ts
declare module '@sage/x3-master-data/lib/enums/dimension-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DimensionTypesEnum {
	    none = 1,
	    dimension1 = 2,
	    dimension2 = 3,
	    dimension3 = 4,
	    dimension4 = 5,
	    dimension5 = 6,
	    dimension6 = 7,
	    dimension7 = 8,
	    dimension8 = 9,
	    dimension9 = 10,
	    sectorOfActivity = 11,
	    geographicSector = 12,
	    toDefine = 13
	}
	export interface DimensionTypes$EnumInterface {
	    none: 1;
	    dimension1: 2;
	    dimension2: 3;
	    dimension3: 4;
	    dimension4: 5;
	    dimension5: 6;
	    dimension6: 7;
	    dimension7: 8;
	    dimension8: 9;
	    dimension9: 10;
	    sectorOfActivity: 11;
	    geographicSector: 12;
	    toDefine: 13;
	}
	export type DimensionTypes = keyof DimensionTypes$EnumInterface;
	export const dimensionTypesDatatype: X3EnumDataType<keyof DimensionTypes$EnumInterface, unknown>;
	//# sourceMappingURL=dimension-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/digital-signature-control.d.ts
declare module '@sage/x3-master-data/lib/enums/digital-signature-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DigitalSignatureControlEnum {
	    invoices = 1,
	    journalEntries = 2
	}
	export interface DigitalSignatureControl$EnumInterface {
	    invoices: 1;
	    journalEntries: 2;
	}
	export type DigitalSignatureControl = keyof DigitalSignatureControl$EnumInterface;
	export const digitalSignatureControlDatatype: X3EnumDataType<keyof DigitalSignatureControl$EnumInterface, unknown>;
	//# sourceMappingURL=digital-signature-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/detail-level-3635.d.ts
declare module '@sage/x3-master-data/lib/enums/detail-level-3635' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DetailLevel3635Enum {
	    total = 1,
	    forecastType = 2,
	    document = 3
	}
	export interface DetailLevel3635$EnumInterface {
	    total: 1;
	    forecastType: 2;
	    document: 3;
	}
	export type DetailLevel3635 = keyof DetailLevel3635$EnumInterface;
	export const detailLevel3635Datatype: X3EnumDataType<keyof DetailLevel3635$EnumInterface, unknown>;
	//# sourceMappingURL=detail-level-3635.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/destination-enum.d.ts
declare module '@sage/x3-master-data/lib/enums/destination-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DestinationEnumEnum {
	    blcstr = 1,
	    blcend = 2,
	    tbd = 3,
	    bsisns = 4
	}
	export interface DestinationEnum$EnumInterface {
	    blcstr: 1;
	    blcend: 2;
	    tbd: 3;
	    bsisns: 4;
	}
	export type DestinationEnum = keyof DestinationEnum$EnumInterface;
	export const destinationEnumDatatype: X3EnumDataType<keyof DestinationEnum$EnumInterface, unknown>;
	//# sourceMappingURL=destination-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/depreciation-stop-status.d.ts
declare module '@sage/x3-master-data/lib/enums/depreciation-stop-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DepreciationStopStatusEnum {
	    noStop = 1,
	    improvement = 2,
	    preservation = 3,
	    stoppedForImprovement = 4,
	    stoppedForPreservation = 5,
	    restartedAfterImprovement = 6,
	    restartedAfterPreservation = 7,
	    suspend = 8,
	    stopped = 9,
	    restartedAfterExtension = 10,
	    restarted = 11,
	    extensionDeprec = 12,
	    suspendedForExtension = 13
	}
	export interface DepreciationStopStatus$EnumInterface {
	    noStop: 1;
	    improvement: 2;
	    preservation: 3;
	    stoppedForImprovement: 4;
	    stoppedForPreservation: 5;
	    restartedAfterImprovement: 6;
	    restartedAfterPreservation: 7;
	    suspend: 8;
	    stopped: 9;
	    restartedAfterExtension: 10;
	    restarted: 11;
	    extensionDeprec: 12;
	    suspendedForExtension: 13;
	}
	export type DepreciationStopStatus = keyof DepreciationStopStatus$EnumInterface;
	export const depreciationStopStatusDatatype: X3EnumDataType<keyof DepreciationStopStatus$EnumInterface, unknown>;
	//# sourceMappingURL=depreciation-stop-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/depreciation-start-date-type.d.ts
declare module '@sage/x3-master-data/lib/enums/depreciation-start-date-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DepreciationStartDateTypeEnum {
	    onTheSpecifiedDay = 1,
	    fromFirstDayOfTheMonth = 2,
	    fromFirstDayOfTheNextMonth = 3,
	    fromFirstDayOfInvestmentFy = 4,
	    fromFirstDayOfNextFy = 5,
	    fromFirstDayOfInvestmentHalfYear = 6
	}
	export interface DepreciationStartDateType$EnumInterface {
	    onTheSpecifiedDay: 1;
	    fromFirstDayOfTheMonth: 2;
	    fromFirstDayOfTheNextMonth: 3;
	    fromFirstDayOfInvestmentFy: 4;
	    fromFirstDayOfNextFy: 5;
	    fromFirstDayOfInvestmentHalfYear: 6;
	}
	export type DepreciationStartDateType = keyof DepreciationStartDateType$EnumInterface;
	export const depreciationStartDateTypeDatatype: X3EnumDataType<keyof DepreciationStartDateType$EnumInterface, unknown>;
	//# sourceMappingURL=depreciation-start-date-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/depreciation-priority-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/depreciation-priority-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DepreciationPriorityRuleEnum {
	    depreciationRate = 1,
	    depreciationEndDate = 2
	}
	export interface DepreciationPriorityRule$EnumInterface {
	    depreciationRate: 1;
	    depreciationEndDate: 2;
	}
	export type DepreciationPriorityRule = keyof DepreciationPriorityRule$EnumInterface;
	export const depreciationPriorityRuleDatatype: X3EnumDataType<keyof DepreciationPriorityRule$EnumInterface, unknown>;
	//# sourceMappingURL=depreciation-priority-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/depreciation-plans.d.ts
declare module '@sage/x3-master-data/lib/enums/depreciation-plans' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DepreciationPlansEnum {
	    accounts = 1,
	    finance = 2,
	    minimum = 3,
	    source = 4,
	    reevaluation76 = 5,
	    iasIfrs = 6,
	    technical = 7,
	    reprocessed = 8,
	    subsidy = 9,
	    free1 = 10,
	    free2 = 11,
	    free3 = 12,
	    free4 = 13,
	    free5 = 14,
	    free6 = 15,
	    all = 16
	}
	export interface DepreciationPlans$EnumInterface {
	    accounts: 1;
	    finance: 2;
	    minimum: 3;
	    source: 4;
	    reevaluation76: 5;
	    iasIfrs: 6;
	    technical: 7;
	    reprocessed: 8;
	    subsidy: 9;
	    free1: 10;
	    free2: 11;
	    free3: 12;
	    free4: 13;
	    free5: 14;
	    free6: 15;
	    all: 16;
	}
	export type DepreciationPlans = keyof DepreciationPlans$EnumInterface;
	export const depreciationPlansDatatype: X3EnumDataType<keyof DepreciationPlans$EnumInterface, unknown>;
	//# sourceMappingURL=depreciation-plans.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/depreciation-plan-standards.d.ts
declare module '@sage/x3-master-data/lib/enums/depreciation-plan-standards' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DepreciationPlanStandardsEnum {
	    standard = 1,
	    crc200210 = 2,
	    iasIfrs = 3
	}
	export interface DepreciationPlanStandards$EnumInterface {
	    standard: 1;
	    crc200210: 2;
	    iasIfrs: 3;
	}
	export type DepreciationPlanStandards = keyof DepreciationPlanStandards$EnumInterface;
	export const depreciationPlanStandardsDatatype: X3EnumDataType<keyof DepreciationPlanStandards$EnumInterface, unknown>;
	//# sourceMappingURL=depreciation-plan-standards.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/depreciation-method-type.d.ts
declare module '@sage/x3-master-data/lib/enums/depreciation-method-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DepreciationMethodTypeEnum {
	    free = 1,
	    standard = 2
	}
	export interface DepreciationMethodType$EnumInterface {
	    free: 1;
	    standard: 2;
	}
	export type DepreciationMethodType = keyof DepreciationMethodType$EnumInterface;
	export const depreciationMethodTypeDatatype: X3EnumDataType<keyof DepreciationMethodType$EnumInterface, unknown>;
	//# sourceMappingURL=depreciation-method-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/depreciation-contexts.d.ts
declare module '@sage/x3-master-data/lib/enums/depreciation-contexts' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DepreciationContextsEnum {
	    finance = 1,
	    context2 = 2,
	    context3 = 3,
	    context4 = 4,
	    context5 = 5,
	    context6 = 6,
	    context7 = 7,
	    context8 = 8,
	    context9 = 9,
	    context10 = 10,
	    context11 = 11
	}
	export interface DepreciationContexts$EnumInterface {
	    finance: 1;
	    context2: 2;
	    context3: 3;
	    context4: 4;
	    context5: 5;
	    context6: 6;
	    context7: 7;
	    context8: 8;
	    context9: 9;
	    context10: 10;
	    context11: 11;
	}
	export type DepreciationContexts = keyof DepreciationContexts$EnumInterface;
	export const depreciationContextsDatatype: X3EnumDataType<keyof DepreciationContexts$EnumInterface, unknown>;
	//# sourceMappingURL=depreciation-contexts.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/depreciation-basis-type.d.ts
declare module '@sage/x3-master-data/lib/enums/depreciation-basis-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DepreciationBasisTypeEnum {
	    balanceSheetValue = 1,
	    netValue = 2,
	    balanceSheetValueDepreciationDuration = 3,
	    netValueResidualDuration4 = 4,
	    netValueTotalDuration = 5,
	    balanceSheetValueSalvageValue = 6,
	    netValueSalvageValue = 7,
	    netValueResidualDuration = 8
	}
	export interface DepreciationBasisType$EnumInterface {
	    balanceSheetValue: 1;
	    netValue: 2;
	    balanceSheetValueDepreciationDuration: 3;
	    netValueResidualDuration4: 4;
	    netValueTotalDuration: 5;
	    balanceSheetValueSalvageValue: 6;
	    netValueSalvageValue: 7;
	    netValueResidualDuration: 8;
	}
	export type DepreciationBasisType = keyof DepreciationBasisType$EnumInterface;
	export const depreciationBasisTypeDatatype: X3EnumDataType<keyof DepreciationBasisType$EnumInterface, unknown>;
	//# sourceMappingURL=depreciation-basis-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/deprec-end-and-disp-date-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/deprec-end-and-disp-date-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeprecEndAndDispDateRuleEnum {
	    onTheSpecifiedDay = 1,
	    fromTheLastDayOfThePreviousMonth = 2,
	    fromTheLastDayOfTheCurrentMonth = 3,
	    fromTheLastDayOfThePreviousFinancialYear = 4,
	    fromTheLastDayOfTheCurrentFinancialYear = 5,
	    fromTheLastDayOfThePreviousHalfYear = 6,
	    fromTheLastDayOfTheCurrentHalfYear = 7,
	    fromThePreviousDay = 8,
	    fromTheFirstDayOfTheNextHalfYear = 9,
	    fromTheLastDayOfTheCurrentQuarter = 10
	}
	export interface DeprecEndAndDispDateRule$EnumInterface {
	    onTheSpecifiedDay: 1;
	    fromTheLastDayOfThePreviousMonth: 2;
	    fromTheLastDayOfTheCurrentMonth: 3;
	    fromTheLastDayOfThePreviousFinancialYear: 4;
	    fromTheLastDayOfTheCurrentFinancialYear: 5;
	    fromTheLastDayOfThePreviousHalfYear: 6;
	    fromTheLastDayOfTheCurrentHalfYear: 7;
	    fromThePreviousDay: 8;
	    fromTheFirstDayOfTheNextHalfYear: 9;
	    fromTheLastDayOfTheCurrentQuarter: 10;
	}
	export type DeprecEndAndDispDateRule = keyof DeprecEndAndDispDateRule$EnumInterface;
	export const deprecEndAndDispDateRuleDatatype: X3EnumDataType<keyof DeprecEndAndDispDateRule$EnumInterface, unknown>;
	//# sourceMappingURL=deprec-end-and-disp-date-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/deprec-calculation-type-reques.d.ts
declare module '@sage/x3-master-data/lib/enums/deprec-calculation-type-reques' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeprecCalculationTypeRequesEnum {
	    noCalculation = 1,
	    fyCalculation = 2,
	    periodicProformaCalculation = 3,
	    periodicActualCalculation = 4
	}
	export interface DeprecCalculationTypeReques$EnumInterface {
	    noCalculation: 1;
	    fyCalculation: 2;
	    periodicProformaCalculation: 3;
	    periodicActualCalculation: 4;
	}
	export type DeprecCalculationTypeReques = keyof DeprecCalculationTypeReques$EnumInterface;
	export const deprecCalculationTypeRequesDatatype: X3EnumDataType<keyof DeprecCalculationTypeReques$EnumInterface, unknown>;
	//# sourceMappingURL=deprec-calculation-type-reques.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/deprec-calc-priority-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/deprec-calc-priority-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeprecCalcPriorityRuleEnum {
	    byDefault = 1,
	    periodPriority = 2,
	    fyPriority = 3
	}
	export interface DeprecCalcPriorityRule$EnumInterface {
	    byDefault: 1;
	    periodPriority: 2;
	    fyPriority: 3;
	}
	export type DeprecCalcPriorityRule = keyof DeprecCalcPriorityRule$EnumInterface;
	export const deprecCalcPriorityRuleDatatype: X3EnumDataType<keyof DeprecCalcPriorityRule$EnumInterface, unknown>;
	//# sourceMappingURL=deprec-calc-priority-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/deposit-rate.d.ts
declare module '@sage/x3-master-data/lib/enums/deposit-rate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DepositRateEnum {
	    invoiceRate = 1,
	    paymentRate = 2,
	    paymentRateRevalued = 3
	}
	export interface DepositRate$EnumInterface {
	    invoiceRate: 1;
	    paymentRate: 2;
	    paymentRateRevalued: 3;
	}
	export type DepositRate = keyof DepositRate$EnumInterface;
	export const depositRateDatatype: X3EnumDataType<keyof DepositRate$EnumInterface, unknown>;
	//# sourceMappingURL=deposit-rate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/dematerialization-status.d.ts
declare module '@sage/x3-master-data/lib/enums/dematerialization-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DematerializationStatusEnum {
	    disabled = 1,
	    accepted = 2,
	    closed = 3,
	    inProgress = 4,
	    rejected = 5,
	    inProcess = 6
	}
	export interface DematerializationStatus$EnumInterface {
	    disabled: 1;
	    accepted: 2;
	    closed: 3;
	    inProgress: 4;
	    rejected: 5;
	    inProcess: 6;
	}
	export type DematerializationStatus = keyof DematerializationStatus$EnumInterface;
	export const dematerializationStatusDatatype: X3EnumDataType<keyof DematerializationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=dematerialization-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/deferred-depreciation-type.d.ts
declare module '@sage/x3-master-data/lib/enums/deferred-depreciation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeferredDepreciationTypeEnum {
	    none = 1,
	    lossMakingDeferredDepreciation = 2,
	    profitMakingDeferredDepreciation = 3,
	    deferredDepreciationReversal = 4,
	    substituteValue5 = 5
	}
	export interface DeferredDepreciationType$EnumInterface {
	    none: 1;
	    lossMakingDeferredDepreciation: 2;
	    profitMakingDeferredDepreciation: 3;
	    deferredDepreciationReversal: 4;
	    substituteValue5: 5;
	}
	export type DeferredDepreciationType = keyof DeferredDepreciationType$EnumInterface;
	export const deferredDepreciationTypeDatatype: X3EnumDataType<keyof DeferredDepreciationType$EnumInterface, unknown>;
	//# sourceMappingURL=deferred-depreciation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/deferred-depreciation-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/deferred-depreciation-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeferredDepreciationRuleEnum {
	    none = 1,
	    percentage = 2,
	    noBookVsTaxDeferredDepreciation = 3,
	    reversalOnResidualDuration = 4
	}
	export interface DeferredDepreciationRule$EnumInterface {
	    none: 1;
	    percentage: 2;
	    noBookVsTaxDeferredDepreciation: 3;
	    reversalOnResidualDuration: 4;
	}
	export type DeferredDepreciationRule = keyof DeferredDepreciationRule$EnumInterface;
	export const deferredDepreciationRuleDatatype: X3EnumDataType<keyof DeferredDepreciationRule$EnumInterface, unknown>;
	//# sourceMappingURL=deferred-depreciation-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/default-dimension-type.d.ts
declare module '@sage/x3-master-data/lib/enums/default-dimension-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefaultDimensionTypeEnum {
	    product = 1,
	    customer = 2,
	    supplier = 3,
	    salesRep = 4,
	    buyer = 5,
	    document = 6,
	    company = 7,
	    site = 8,
	    currency = 9,
	    tax = 10,
	    salesFooter = 11,
	    discount = 12,
	    bank = 13,
	    account = 14,
	    fixedAsset = 15,
	    purchaseFooter = 16,
	    miscellaneousBusinessPartner = 17,
	    costingDimensions = 18,
	    overheadCosts = 19,
	    sourceDocument = 20,
	    previousDimensions = 21,
	    requester = 22,
	    purchaseCosts = 23,
	    project = 24,
	    projectCostType = 25,
	    employee = 26,
	    department = 27,
	    profile = 28,
	    user = 29,
	    event = 30,
	    activityNature = 31,
	    expenseCode = 32,
	    accountingContract = 33,
	    none = 34
	}
	export interface DefaultDimensionType$EnumInterface {
	    product: 1;
	    customer: 2;
	    supplier: 3;
	    salesRep: 4;
	    buyer: 5;
	    document: 6;
	    company: 7;
	    site: 8;
	    currency: 9;
	    tax: 10;
	    salesFooter: 11;
	    discount: 12;
	    bank: 13;
	    account: 14;
	    fixedAsset: 15;
	    purchaseFooter: 16;
	    miscellaneousBusinessPartner: 17;
	    costingDimensions: 18;
	    overheadCosts: 19;
	    sourceDocument: 20;
	    previousDimensions: 21;
	    requester: 22;
	    purchaseCosts: 23;
	    project: 24;
	    projectCostType: 25;
	    employee: 26;
	    department: 27;
	    profile: 28;
	    user: 29;
	    event: 30;
	    activityNature: 31;
	    expenseCode: 32;
	    accountingContract: 33;
	    none: 34;
	}
	export type DefaultDimensionType = keyof DefaultDimensionType$EnumInterface;
	export const defaultDimensionTypeDatatype: X3EnumDataType<keyof DefaultDimensionType$EnumInterface, unknown>;
	//# sourceMappingURL=default-dimension-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/default-currency.d.ts
declare module '@sage/x3-master-data/lib/enums/default-currency' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefaultCurrencyEnum {
	    fromPropsectCustomer = 1,
	    fromSalesRep = 2
	}
	export interface DefaultCurrency$EnumInterface {
	    fromPropsectCustomer: 1;
	    fromSalesRep: 2;
	}
	export type DefaultCurrency = keyof DefaultCurrency$EnumInterface;
	export const defaultCurrencyDatatype: X3EnumDataType<keyof DefaultCurrency$EnumInterface, unknown>;
	//# sourceMappingURL=default-currency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/deduction-type.d.ts
declare module '@sage/x3-master-data/lib/enums/deduction-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeductionTypeEnum {
	    finalInvoiceOnly = 1,
	    issuedInvoices = 2,
	    firstInvoice = 3
	}
	export interface DeductionType$EnumInterface {
	    finalInvoiceOnly: 1;
	    issuedInvoices: 2;
	    firstInvoice: 3;
	}
	export type DeductionType = keyof DeductionType$EnumInterface;
	export const deductionTypeDatatype: X3EnumDataType<keyof DeductionType$EnumInterface, unknown>;
	//# sourceMappingURL=deduction-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/debit-collection-type.d.ts
declare module '@sage/x3-master-data/lib/enums/debit-collection-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DebitCollectionTypeEnum {
	    onDebit = 1,
	    onPayment = 2
	}
	export interface DebitCollectionType$EnumInterface {
	    onDebit: 1;
	    onPayment: 2;
	}
	export type DebitCollectionType = keyof DebitCollectionType$EnumInterface;
	export const debitCollectionTypeDatatype: X3EnumDataType<keyof DebitCollectionType$EnumInterface, unknown>;
	//# sourceMappingURL=debit-collection-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/date-types.d.ts
declare module '@sage/x3-master-data/lib/enums/date-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DateTypesEnum {
	    purchaseDate = 1,
	    firstUseDate = 2,
	    postingDate = 3
	}
	export interface DateTypes$EnumInterface {
	    purchaseDate: 1;
	    firstUseDate: 2;
	    postingDate: 3;
	}
	export type DateTypes = keyof DateTypes$EnumInterface;
	export const dateTypesDatatype: X3EnumDataType<keyof DateTypes$EnumInterface, unknown>;
	//# sourceMappingURL=date-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/date-selection.d.ts
declare module '@sage/x3-master-data/lib/enums/date-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DateSelectionEnum {
	    accountingDate = 1,
	    invoiceDate = 2
	}
	export interface DateSelection$EnumInterface {
	    accountingDate: 1;
	    invoiceDate: 2;
	}
	export type DateSelection = keyof DateSelection$EnumInterface;
	export const dateSelectionDatatype: X3EnumDataType<keyof DateSelection$EnumInterface, unknown>;
	//# sourceMappingURL=date-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/date-selection-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/date-selection-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DateSelectionModeEnum {
	    dueDate = 1,
	    earlyDiscount = 2,
	    both = 3
	}
	export interface DateSelectionMode$EnumInterface {
	    dueDate: 1;
	    earlyDiscount: 2;
	    both: 3;
	}
	export type DateSelectionMode = keyof DateSelectionMode$EnumInterface;
	export const dateSelectionModeDatatype: X3EnumDataType<keyof DateSelectionMode$EnumInterface, unknown>;
	//# sourceMappingURL=date-selection-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/date-format.d.ts
declare module '@sage/x3-master-data/lib/enums/date-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DateFormatEnum {
	    yyyymmdd = 1,
	    yymmdd = 2,
	    ddmmyyyy = 3,
	    ddmmyy = 4,
	    yyyyMmDd = 5,
	    yyMmDd = 6,
	    ddMmYyyy = 7,
	    ddMmYy = 8,
	    mmddyyyy = 9,
	    mmddyy = 10,
	    mmDdYyyy = 11,
	    mmDdYy = 12
	}
	export interface DateFormat$EnumInterface {
	    yyyymmdd: 1;
	    yymmdd: 2;
	    ddmmyyyy: 3;
	    ddmmyy: 4;
	    yyyyMmDd: 5;
	    yyMmDd: 6;
	    ddMmYyyy: 7;
	    ddMmYy: 8;
	    mmddyyyy: 9;
	    mmddyy: 10;
	    mmDdYyyy: 11;
	    mmDdYy: 12;
	}
	export type DateFormat = keyof DateFormat$EnumInterface;
	export const dateFormatDatatype: X3EnumDataType<keyof DateFormat$EnumInterface, unknown>;
	//# sourceMappingURL=date-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/date-chosen-for-reevaluation.d.ts
declare module '@sage/x3-master-data/lib/enums/date-chosen-for-reevaluation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DateChosenForReevaluationEnum {
	    purchaseDate = 1,
	    postingDate = 2,
	    inServiceDate = 3
	}
	export interface DateChosenForReevaluation$EnumInterface {
	    purchaseDate: 1;
	    postingDate: 2;
	    inServiceDate: 3;
	}
	export type DateChosenForReevaluation = keyof DateChosenForReevaluation$EnumInterface;
	export const dateChosenForReevaluationDatatype: X3EnumDataType<keyof DateChosenForReevaluation$EnumInterface, unknown>;
	//# sourceMappingURL=date-chosen-for-reevaluation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/database-operation.d.ts
declare module '@sage/x3-master-data/lib/enums/database-operation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DatabaseOperationEnum {
	    unspecified = 1,
	    create = 2,
	    update = 3,
	    ignore = 4
	}
	export interface DatabaseOperation$EnumInterface {
	    unspecified: 1;
	    create: 2;
	    update: 3;
	    ignore: 4;
	}
	export type DatabaseOperation = keyof DatabaseOperation$EnumInterface;
	export const databaseOperationDatatype: X3EnumDataType<keyof DatabaseOperation$EnumInterface, unknown>;
	//# sourceMappingURL=database-operation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/data-type.d.ts
declare module '@sage/x3-master-data/lib/enums/data-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DataTypeEnum {
	    alphanumeric = 1,
	    numeric = 2,
	    date = 3
	}
	export interface DataType$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	    date: 3;
	}
	export type DataType = keyof DataType$EnumInterface;
	export const dataTypeDatatype: X3EnumDataType<keyof DataType$EnumInterface, unknown>;
	//# sourceMappingURL=data-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/daily.d.ts
declare module '@sage/x3-master-data/lib/enums/daily' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DailyEnum {
	    daily = 1,
	    weekdays = 2
	}
	export interface Daily$EnumInterface {
	    daily: 1;
	    weekdays: 2;
	}
	export type Daily = keyof Daily$EnumInterface;
	export const dailyDatatype: X3EnumDataType<keyof Daily$EnumInterface, unknown>;
	//# sourceMappingURL=daily.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/customs-file-doc-taken-into-ac.d.ts
declare module '@sage/x3-master-data/lib/enums/customs-file-doc-taken-into-ac' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomsFileDocTakenIntoAcEnum {
	    no = 1,
	    fiscalValue = 2,
	    statisticalValue = 3
	}
	export interface CustomsFileDocTakenIntoAc$EnumInterface {
	    no: 1;
	    fiscalValue: 2;
	    statisticalValue: 3;
	}
	export type CustomsFileDocTakenIntoAc = keyof CustomsFileDocTakenIntoAc$EnumInterface;
	export const customsFileDocTakenIntoAcDatatype: X3EnumDataType<keyof CustomsFileDocTakenIntoAc$EnumInterface, unknown>;
	//# sourceMappingURL=customs-file-doc-taken-into-ac.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/customers-statistics-groups.d.ts
declare module '@sage/x3-master-data/lib/enums/customers-statistics-groups' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomersStatisticsGroupsEnum {
	    group1 = 1,
	    group2 = 2,
	    group3 = 3,
	    group4 = 4,
	    group5 = 5
	}
	export interface CustomersStatisticsGroups$EnumInterface {
	    group1: 1;
	    group2: 2;
	    group3: 3;
	    group4: 4;
	    group5: 5;
	}
	export type CustomersStatisticsGroups = keyof CustomersStatisticsGroups$EnumInterface;
	export const customersStatisticsGroupsDatatype: X3EnumDataType<keyof CustomersStatisticsGroups$EnumInterface, unknown>;
	//# sourceMappingURL=customers-statistics-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/customer-source.d.ts
declare module '@sage/x3-master-data/lib/enums/customer-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomerSourceEnum {
	    invoiceCustomer = 1,
	    orderCustomer = 2
	}
	export interface CustomerSource$EnumInterface {
	    invoiceCustomer: 1;
	    orderCustomer: 2;
	}
	export type CustomerSource = keyof CustomerSource$EnumInterface;
	export const customerSourceDatatype: X3EnumDataType<keyof CustomerSource$EnumInterface, unknown>;
	//# sourceMappingURL=customer-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/customer-situation-risks.d.ts
declare module '@sage/x3-master-data/lib/enums/customer-situation-risks' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomerSituationRisksEnum {
	    onOrder = 1,
	    onLoanOrder = 2,
	    shipmentInProgress = 3,
	    shippedNotInvoiced = 4,
	    shippedOnLoan = 5,
	    nonPostedInvoices = 6,
	    unmatchedCreditMemos = 7,
	    invoices = 8,
	    temporaryPayments = 9,
	    notesPR1 = 10,
	    notesPR2 = 11,
	    notesPR3 = 12
	}
	export interface CustomerSituationRisks$EnumInterface {
	    onOrder: 1;
	    onLoanOrder: 2;
	    shipmentInProgress: 3;
	    shippedNotInvoiced: 4;
	    shippedOnLoan: 5;
	    nonPostedInvoices: 6;
	    unmatchedCreditMemos: 7;
	    invoices: 8;
	    temporaryPayments: 9;
	    notesPR1: 10;
	    notesPR2: 11;
	    notesPR3: 12;
	}
	export type CustomerSituationRisks = keyof CustomerSituationRisks$EnumInterface;
	export const customerSituationRisksDatatype: X3EnumDataType<keyof CustomerSituationRisks$EnumInterface, unknown>;
	//# sourceMappingURL=customer-situation-risks.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/customer-movement-type.d.ts
declare module '@sage/x3-master-data/lib/enums/customer-movement-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomerMovementTypeEnum {
	    quote = 1,
	    order = 2,
	    delivery = 3,
	    return = 4,
	    invoice = 5,
	    serviceContract = 6,
	    serviceRequest = 7,
	    serviceResponse = 8,
	    project = 9,
	    payment = 10,
	    paymentDue = 11,
	    reminder = 12,
	    withoutTypeTask = 13,
	    telephone = 14,
	    visit = 15
	}
	export interface CustomerMovementType$EnumInterface {
	    quote: 1;
	    order: 2;
	    delivery: 3;
	    return: 4;
	    invoice: 5;
	    serviceContract: 6;
	    serviceRequest: 7;
	    serviceResponse: 8;
	    project: 9;
	    payment: 10;
	    paymentDue: 11;
	    reminder: 12;
	    withoutTypeTask: 13;
	    telephone: 14;
	    visit: 15;
	}
	export type CustomerMovementType = keyof CustomerMovementType$EnumInterface;
	export const customerMovementTypeDatatype: X3EnumDataType<keyof CustomerMovementType$EnumInterface, unknown>;
	//# sourceMappingURL=customer-movement-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/customer-information-type.d.ts
declare module '@sage/x3-master-data/lib/enums/customer-information-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomerInformationTypeEnum {
	    firstContact = 1,
	    lastContact = 2,
	    nextContact = 3,
	    lastQuote = 4,
	    firstOrder = 5,
	    lastOrder = 6,
	    lastDelivery = 7,
	    lastReturn = 8,
	    lastInvoice = 9,
	    lastCreditMemo = 10,
	    lastServiceRequest = 11,
	    lastServiceResponse = 12,
	    lastProject = 13,
	    lastServiceContract = 14,
	    lastPayment = 15,
	    lastPaymentDue = 16,
	    numberOfPaymentsDue = 17,
	    lastReminder = 18,
	    lastReminderLevel = 19,
	    maximumReminderLevel = 20
	}
	export interface CustomerInformationType$EnumInterface {
	    firstContact: 1;
	    lastContact: 2;
	    nextContact: 3;
	    lastQuote: 4;
	    firstOrder: 5;
	    lastOrder: 6;
	    lastDelivery: 7;
	    lastReturn: 8;
	    lastInvoice: 9;
	    lastCreditMemo: 10;
	    lastServiceRequest: 11;
	    lastServiceResponse: 12;
	    lastProject: 13;
	    lastServiceContract: 14;
	    lastPayment: 15;
	    lastPaymentDue: 16;
	    numberOfPaymentsDue: 17;
	    lastReminder: 18;
	    lastReminderLevel: 19;
	    maximumReminderLevel: 20;
	}
	export type CustomerInformationType = keyof CustomerInformationType$EnumInterface;
	export const customerInformationTypeDatatype: X3EnumDataType<keyof CustomerInformationType$EnumInterface, unknown>;
	//# sourceMappingURL=customer-information-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/customer-hold-release.d.ts
declare module '@sage/x3-master-data/lib/enums/customer-hold-release' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomerHoldReleaseEnum {
	    creditControl = 1,
	    paymentDelayControl = 2
	}
	export interface CustomerHoldRelease$EnumInterface {
	    creditControl: 1;
	    paymentDelayControl: 2;
	}
	export type CustomerHoldRelease = keyof CustomerHoldRelease$EnumInterface;
	export const customerHoldReleaseDatatype: X3EnumDataType<keyof CustomerHoldRelease$EnumInterface, unknown>;
	//# sourceMappingURL=customer-hold-release.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/customer-categories.d.ts
declare module '@sage/x3-master-data/lib/enums/customer-categories' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomerCategoriesEnum {
	    directCustomer = 1,
	    reseller = 2,
	    wholesaler = 3,
	    endUser = 4,
	    other = 5
	}
	export interface CustomerCategories$EnumInterface {
	    directCustomer: 1;
	    reseller: 2;
	    wholesaler: 3;
	    endUser: 4;
	    other: 5;
	}
	export type CustomerCategories = keyof CustomerCategories$EnumInterface;
	export const customerCategoriesDatatype: X3EnumDataType<keyof CustomerCategories$EnumInterface, unknown>;
	//# sourceMappingURL=customer-categories.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/crystal-reports-lists.d.ts
declare module '@sage/x3-master-data/lib/enums/crystal-reports-lists' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrystalReportsListsEnum {
	    blocked = 1,
	    exceeded = 2,
	    both = 3
	}
	export interface CrystalReportsLists$EnumInterface {
	    blocked: 1;
	    exceeded: 2;
	    both: 3;
	}
	export type CrystalReportsLists = keyof CrystalReportsLists$EnumInterface;
	export const crystalReportsListsDatatype: X3EnumDataType<keyof CrystalReportsLists$EnumInterface, unknown>;
	//# sourceMappingURL=crystal-reports-lists.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/crystal-reports-common.d.ts
declare module '@sage/x3-master-data/lib/enums/crystal-reports-common' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrystalReportsCommonEnum {
	    accordingToDatabase = 1,
	    january = 2,
	    february = 3,
	    march = 4,
	    april = 5,
	    may = 6,
	    june = 7,
	    july = 8,
	    august = 9,
	    september = 10,
	    october = 11,
	    november = 12,
	    december = 13,
	    firstLevel = 14,
	    lastLevel = 15,
	    multilevel = 16,
	    processedBy = 17,
	    anyLatePaymentWillRequireThatAFixedAllowanceBePaidForTheRecoveryCostsOf = 18,
	    specialCashVatTaxRule = 19,
	    transportCode = 20,
	    freightChargeTermsFreightChargesArePrepaidUnlessMarkedOtherwise = 21,
	    noteLiabilityLimitationForLossOrDamageInThisShipmentMayBeApplicableSee49USC14706C1AAndB = 22,
	    theCarrierShallNotMakeDeliveryOfThisShipmentWithoutPaymentOfFreightAndAllOtherLawfulCharges = 23,
	    prepaid = 24,
	    collect = 25,
	    thirdParty = 26,
	    codAmount = 27,
	    feeTerms = 28,
	    customerCheckAcceptable = 29,
	    shipperSignature = 30,
	    shipperSignatureAndDate = 31,
	    trailerLoaded = 32,
	    freightCounted = 33,
	    byShipper = 34,
	    byDriver = 35,
	    byDriverPalletsSaidToContain = 36,
	    byDriverPieces = 37,
	    carrierSignatureAndPickupDate = 38,
	    propertyDescribedAboveIsReceivedInGoodOrderExceptAsNoted = 39,
	    fob = 40,
	    customerTotal = 41,
	    agedTotal = 42,
	    statementDate = 43,
	    cutoffDate = 44,
	    originalAmount = 45,
	    openAmount = 46,
	    progressiveBalance = 47,
	    substituteValue48 = 48,
	    substituteValue49 = 49,
	    substituteValue50 = 50,
	    over90Days = 51,
	    registrationNumber = 52,
	    trailerRegistrationNo = 53,
	    departureDate = 54,
	    departureTime = 55,
	    arrivalDate = 56,
	    arrivalTime = 57,
	    type = 58,
	    documentForInternalUsageOnly = 59,
	    thisDocumentIsOnlyAReferenceToAPreviousRevisionOfAFinalSalesQuote = 60,
	    salesQuoteRevisionReport = 61,
	    totalWithoutVatExcludingTaxes = 62,
	    totalWithoutVat = 63,
	    internalReference = 64,
	    cashVatRule = 65,
	    qtyIssued = 66,
	    ending = 67,
	    qtyReceived = 68,
	    valuationMethodTotal = 69,
	    versionTotal = 70,
	    valuationMethodChanged = 71,
	    controlSystem = 72,
	    veriFactu = 73,
	    firstRecord = 74,
	    lastRecord = 75,
	    doYouWantToExportOnlyNonExportedEvents = 76,
	    noVeriFactu = 77,
	    sendingWithoutRequestNumberIsOnlyAllowedInTestMode = 78,
	    optionForThePaymentOfTheTaxAccordingToTheDebits = 79
	}
	export interface CrystalReportsCommon$EnumInterface {
	    accordingToDatabase: 1;
	    january: 2;
	    february: 3;
	    march: 4;
	    april: 5;
	    may: 6;
	    june: 7;
	    july: 8;
	    august: 9;
	    september: 10;
	    october: 11;
	    november: 12;
	    december: 13;
	    firstLevel: 14;
	    lastLevel: 15;
	    multilevel: 16;
	    processedBy: 17;
	    anyLatePaymentWillRequireThatAFixedAllowanceBePaidForTheRecoveryCostsOf: 18;
	    specialCashVatTaxRule: 19;
	    transportCode: 20;
	    freightChargeTermsFreightChargesArePrepaidUnlessMarkedOtherwise: 21;
	    noteLiabilityLimitationForLossOrDamageInThisShipmentMayBeApplicableSee49USC14706C1AAndB: 22;
	    theCarrierShallNotMakeDeliveryOfThisShipmentWithoutPaymentOfFreightAndAllOtherLawfulCharges: 23;
	    prepaid: 24;
	    collect: 25;
	    thirdParty: 26;
	    codAmount: 27;
	    feeTerms: 28;
	    customerCheckAcceptable: 29;
	    shipperSignature: 30;
	    shipperSignatureAndDate: 31;
	    trailerLoaded: 32;
	    freightCounted: 33;
	    byShipper: 34;
	    byDriver: 35;
	    byDriverPalletsSaidToContain: 36;
	    byDriverPieces: 37;
	    carrierSignatureAndPickupDate: 38;
	    propertyDescribedAboveIsReceivedInGoodOrderExceptAsNoted: 39;
	    fob: 40;
	    customerTotal: 41;
	    agedTotal: 42;
	    statementDate: 43;
	    cutoffDate: 44;
	    originalAmount: 45;
	    openAmount: 46;
	    progressiveBalance: 47;
	    substituteValue48: 48;
	    substituteValue49: 49;
	    substituteValue50: 50;
	    over90Days: 51;
	    registrationNumber: 52;
	    trailerRegistrationNo: 53;
	    departureDate: 54;
	    departureTime: 55;
	    arrivalDate: 56;
	    arrivalTime: 57;
	    type: 58;
	    documentForInternalUsageOnly: 59;
	    thisDocumentIsOnlyAReferenceToAPreviousRevisionOfAFinalSalesQuote: 60;
	    salesQuoteRevisionReport: 61;
	    totalWithoutVatExcludingTaxes: 62;
	    totalWithoutVat: 63;
	    internalReference: 64;
	    cashVatRule: 65;
	    qtyIssued: 66;
	    ending: 67;
	    qtyReceived: 68;
	    valuationMethodTotal: 69;
	    versionTotal: 70;
	    valuationMethodChanged: 71;
	    controlSystem: 72;
	    veriFactu: 73;
	    firstRecord: 74;
	    lastRecord: 75;
	    doYouWantToExportOnlyNonExportedEvents: 76;
	    noVeriFactu: 77;
	    sendingWithoutRequestNumberIsOnlyAllowedInTestMode: 78;
	    optionForThePaymentOfTheTaxAccordingToTheDebits: 79;
	}
	export type CrystalReportsCommon = keyof CrystalReportsCommon$EnumInterface;
	export const crystalReportsCommonDatatype: X3EnumDataType<keyof CrystalReportsCommon$EnumInterface, unknown>;
	//# sourceMappingURL=crystal-reports-common.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/crystal-report-support-cli.d.ts
declare module '@sage/x3-master-data/lib/enums/crystal-report-support-cli' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrystalReportSupportCliEnum {
	    dummyValue = 0
	}
	export interface CrystalReportSupportCli$EnumInterface {
	    dummyValue: 0;
	}
	export type CrystalReportSupportCli = keyof CrystalReportSupportCli$EnumInterface;
	export const crystalReportSupportCliDatatype: X3EnumDataType<"dummyValue", unknown>;
	//# sourceMappingURL=crystal-report-support-cli.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/crm.d.ts
declare module '@sage/x3-master-data/lib/enums/crm' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrmEnum {
	    dummyValue = 0
	}
	export interface Crm$EnumInterface {
	    dummyValue: 0;
	}
	export type Crm = keyof Crm$EnumInterface;
	export const crmDatatype: X3EnumDataType<"dummyValue", unknown>;
	//# sourceMappingURL=crm.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/crm-entry-transactions.d.ts
declare module '@sage/x3-master-data/lib/enums/crm-entry-transactions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrmEntryTransactionsEnum {
	    base = 1,
	    serviceRequest = 2,
	    serviceResponse = 3,
	    hotlinePlanningCalendar = 5
	}
	export interface CrmEntryTransactions$EnumInterface {
	    base: 1;
	    serviceRequest: 2;
	    serviceResponse: 3;
	    hotlinePlanningCalendar: 5;
	}
	export type CrmEntryTransactions = keyof CrmEntryTransactions$EnumInterface;
	export const crmEntryTransactionsDatatype: X3EnumDataType<keyof CrmEntryTransactions$EnumInterface, unknown>;
	//# sourceMappingURL=crm-entry-transactions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/crm-activities-entry-trxs.d.ts
declare module '@sage/x3-master-data/lib/enums/crm-activities-entry-trxs' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrmActivitiesEntryTrxsEnum {
	    crmActivitiesPlanningCalendar = 1
	}
	export interface CrmActivitiesEntryTrxs$EnumInterface {
	    crmActivitiesPlanningCalendar: 1;
	}
	export type CrmActivitiesEntryTrxs = keyof CrmActivitiesEntryTrxs$EnumInterface;
	export const crmActivitiesEntryTrxsDatatype: X3EnumDataType<"crmActivitiesPlanningCalendar", unknown>;
	//# sourceMappingURL=crm-activities-entry-trxs.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/crm-activities-counters.d.ts
declare module '@sage/x3-master-data/lib/enums/crm-activities-counters' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrmActivitiesCountersEnum {
	    crmActivities = 1,
	    projects = 2,
	    marketingOperations = 3,
	    callsScripts = 4,
	    marketingCampaigns = 5,
	    competitorProducts = 6,
	    contacts = 7,
	    reservationOfResources = 8,
	    recoveryData = 9,
	    transcodification = 10,
	    crmImageFiles = 11,
	    outlookContacts = 12
	}
	export interface CrmActivitiesCounters$EnumInterface {
	    crmActivities: 1;
	    projects: 2;
	    marketingOperations: 3;
	    callsScripts: 4;
	    marketingCampaigns: 5;
	    competitorProducts: 6;
	    contacts: 7;
	    reservationOfResources: 8;
	    recoveryData: 9;
	    transcodification: 10;
	    crmImageFiles: 11;
	    outlookContacts: 12;
	}
	export type CrmActivitiesCounters = keyof CrmActivitiesCounters$EnumInterface;
	export const crmActivitiesCountersDatatype: X3EnumDataType<keyof CrmActivitiesCounters$EnumInterface, unknown>;
	//# sourceMappingURL=crm-activities-counters.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/creator-email-text.d.ts
declare module '@sage/x3-master-data/lib/enums/creator-email-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CreatorEmailTextEnum {
	    changeRequest1AwaitsClosureConfirmation = 1,
	    thisChangeRequestRequiresYourConfirmationToClose = 2,
	    theChangeRequestIsAtStatus = 3,
	    toViewTheChangeRequestClickTheLink = 4
	}
	export interface CreatorEmailText$EnumInterface {
	    changeRequest1AwaitsClosureConfirmation: 1;
	    thisChangeRequestRequiresYourConfirmationToClose: 2;
	    theChangeRequestIsAtStatus: 3;
	    toViewTheChangeRequestClickTheLink: 4;
	}
	export type CreatorEmailText = keyof CreatorEmailText$EnumInterface;
	export const creatorEmailTextDatatype: X3EnumDataType<keyof CreatorEmailText$EnumInterface, unknown>;
	//# sourceMappingURL=creator-email-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/creation-modification.d.ts
declare module '@sage/x3-master-data/lib/enums/creation-modification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CreationModificationEnum {
	    creation = 1,
	    modification = 2,
	    deletion = 3
	}
	export interface CreationModification$EnumInterface {
	    creation: 1;
	    modification: 2;
	    deletion: 3;
	}
	export type CreationModification = keyof CreationModification$EnumInterface;
	export const creationModificationDatatype: X3EnumDataType<keyof CreationModification$EnumInterface, unknown>;
	//# sourceMappingURL=creation-modification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/country-location.d.ts
declare module '@sage/x3-master-data/lib/enums/country-location' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CountryLocationEnum {
	    domestic = 1,
	    otherEu = 2,
	    outsideEu = 3
	}
	export interface CountryLocation$EnumInterface {
	    domestic: 1;
	    otherEu: 2;
	    outsideEu: 3;
	}
	export type CountryLocation = keyof CountryLocation$EnumInterface;
	export const countryLocationDatatype: X3EnumDataType<keyof CountryLocation$EnumInterface, unknown>;
	//# sourceMappingURL=country-location.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/count.d.ts
declare module '@sage/x3-master-data/lib/enums/count' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CountEnum {
	    cycleCount = 1,
	    annualCount = 2,
	    noCount = 3
	}
	export interface Count$EnumInterface {
	    cycleCount: 1;
	    annualCount: 2;
	    noCount: 3;
	}
	export type Count = keyof Count$EnumInterface;
	export const countDatatype: X3EnumDataType<keyof Count$EnumInterface, unknown>;
	//# sourceMappingURL=count.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/costs-payable-by.d.ts
declare module '@sage/x3-master-data/lib/enums/costs-payable-by' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostsPayableByEnum {
	    neitherTheBuyerNorTheSeller = 1,
	    buyer = 2,
	    seller = 3,
	    buyerAndSeller = 4
	}
	export interface CostsPayableBy$EnumInterface {
	    neitherTheBuyerNorTheSeller: 1;
	    buyer: 2;
	    seller: 3;
	    buyerAndSeller: 4;
	}
	export type CostsPayableBy = keyof CostsPayableBy$EnumInterface;
	export const costsPayableByDatatype: X3EnumDataType<keyof CostsPayableBy$EnumInterface, unknown>;
	//# sourceMappingURL=costs-payable-by.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/costing-method.d.ts
declare module '@sage/x3-master-data/lib/enums/costing-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostingMethodEnum {
	    standardCost = 1,
	    revisedStandard = 2,
	    lastCost = 3,
	    cumulativeAuc = 4,
	    fifoCost = 5,
	    lotAuc = 6,
	    orderCost = 7,
	    lifoCost = 8,
	    lastPurchasePrice = 9
	}
	export interface CostingMethod$EnumInterface {
	    standardCost: 1;
	    revisedStandard: 2;
	    lastCost: 3;
	    cumulativeAuc: 4;
	    fifoCost: 5;
	    lotAuc: 6;
	    orderCost: 7;
	    lifoCost: 8;
	    lastPurchasePrice: 9;
	}
	export type CostingMethod = keyof CostingMethod$EnumInterface;
	export const costingMethodDatatype: X3EnumDataType<keyof CostingMethod$EnumInterface, unknown>;
	//# sourceMappingURL=costing-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/cost-type-enum.d.ts
declare module '@sage/x3-master-data/lib/enums/cost-type-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostTypeEnumEnum {
	    standard = 1,
	    revised = 2,
	    budgeted = 3,
	    simulated = 4
	}
	export interface CostTypeEnum$EnumInterface {
	    standard: 1;
	    revised: 2;
	    budgeted: 3;
	    simulated: 4;
	}
	export type CostTypeEnum = keyof CostTypeEnum$EnumInterface;
	export const costTypeEnumDatatype: X3EnumDataType<keyof CostTypeEnum$EnumInterface, unknown>;
	//# sourceMappingURL=cost-type-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/cost-type-482.d.ts
declare module '@sage/x3-master-data/lib/enums/cost-type-482' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostType482Enum {
	    standard = 1,
	    forecast = 2,
	    costPrice = 3
	}
	export interface CostType482$EnumInterface {
	    standard: 1;
	    forecast: 2;
	    costPrice: 3;
	}
	export type CostType482 = keyof CostType482$EnumInterface;
	export const costType482Datatype: X3EnumDataType<keyof CostType482$EnumInterface, unknown>;
	//# sourceMappingURL=cost-type-482.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/cost-nature.d.ts
declare module '@sage/x3-master-data/lib/enums/cost-nature' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostNatureEnum {
	    packaging = 1,
	    loading = 2,
	    preTransport = 3,
	    exportCustomsFormality = 4,
	    mainTransportLoading = 5,
	    mainTransport = 6,
	    mainTransportUnloading = 7,
	    importCustomsFormalities = 8,
	    postTransport = 9,
	    unloading = 10,
	    insurance = 11,
	    others = 12
	}
	export interface CostNature$EnumInterface {
	    packaging: 1;
	    loading: 2;
	    preTransport: 3;
	    exportCustomsFormality: 4;
	    mainTransportLoading: 5;
	    mainTransport: 6;
	    mainTransportUnloading: 7;
	    importCustomsFormalities: 8;
	    postTransport: 9;
	    unloading: 10;
	    insurance: 11;
	    others: 12;
	}
	export type CostNature = keyof CostNature$EnumInterface;
	export const costNatureDatatype: X3EnumDataType<keyof CostNature$EnumInterface, unknown>;
	//# sourceMappingURL=cost-nature.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/cost-distribution.d.ts
declare module '@sage/x3-master-data/lib/enums/cost-distribution' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostDistributionEnum {
	    no = 1,
	    netAmountProRata = 2,
	    netWeightProRata = 3,
	    grossWeightProRata = 4,
	    volumeProRata = 5,
	    costAmountProRata = 6
	}
	export interface CostDistribution$EnumInterface {
	    no: 1;
	    netAmountProRata: 2;
	    netWeightProRata: 3;
	    grossWeightProRata: 4;
	    volumeProRata: 5;
	    costAmountProRata: 6;
	}
	export type CostDistribution = keyof CostDistribution$EnumInterface;
	export const costDistributionDatatype: X3EnumDataType<keyof CostDistribution$EnumInterface, unknown>;
	//# sourceMappingURL=cost-distribution.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/cost-calculation-method.d.ts
declare module '@sage/x3-master-data/lib/enums/cost-calculation-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostCalculationMethodEnum {
	    percentagePerNetPrice = 1,
	    fixedAmount = 2,
	    amountPerUnit = 3,
	    amountByFixedBracket = 4,
	    schedule = 5,
	    weightedAmount = 6,
	    formula = 7
	}
	export interface CostCalculationMethod$EnumInterface {
	    percentagePerNetPrice: 1;
	    fixedAmount: 2;
	    amountPerUnit: 3;
	    amountByFixedBracket: 4;
	    schedule: 5;
	    weightedAmount: 6;
	    formula: 7;
	}
	export type CostCalculationMethod = keyof CostCalculationMethod$EnumInterface;
	export const costCalculationMethodDatatype: X3EnumDataType<keyof CostCalculationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=cost-calculation-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/control-type-253.d.ts
declare module '@sage/x3-master-data/lib/enums/control-type-253' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlType253Enum {
	    valueList = 1,
	    ranges = 2,
	    noControl = 3
	}
	export interface ControlType253$EnumInterface {
	    valueList: 1;
	    ranges: 2;
	    noControl: 3;
	}
	export type ControlType253 = keyof ControlType253$EnumInterface;
	export const controlType253Datatype: X3EnumDataType<keyof ControlType253$EnumInterface, unknown>;
	//# sourceMappingURL=control-type-253.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/control-system-status.d.ts
declare module '@sage/x3-master-data/lib/enums/control-system-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlSystemStatusEnum {
	    accepted = 1,
	    inError = 2,
	    canceled = 3,
	    lroeMonitor = 4,
	    waiting = 5,
	    generated = 6
	}
	export interface ControlSystemStatus$EnumInterface {
	    accepted: 1;
	    inError: 2;
	    canceled: 3;
	    lroeMonitor: 4;
	    waiting: 5;
	    generated: 6;
	}
	export type ControlSystemStatus = keyof ControlSystemStatus$EnumInterface;
	export const controlSystemStatusDatatype: X3EnumDataType<keyof ControlSystemStatus$EnumInterface, unknown>;
	//# sourceMappingURL=control-system-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/control-level.d.ts
declare module '@sage/x3-master-data/lib/enums/control-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlLevelEnum {
	    folder = 1,
	    company = 2
	}
	export interface ControlLevel$EnumInterface {
	    folder: 1;
	    company: 2;
	}
	export type ControlLevel = keyof ControlLevel$EnumInterface;
	export const controlLevelDatatype: X3EnumDataType<keyof ControlLevel$EnumInterface, unknown>;
	//# sourceMappingURL=control-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/control-3668.d.ts
declare module '@sage/x3-master-data/lib/enums/control-3668' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Control3668Enum {
	    noControl = 1,
	    debitCredit = 2,
	    bankAccountId = 3
	}
	export interface Control3668$EnumInterface {
	    noControl: 1;
	    debitCredit: 2;
	    bankAccountId: 3;
	}
	export type Control3668 = keyof Control3668$EnumInterface;
	export const control3668Datatype: X3EnumDataType<keyof Control3668$EnumInterface, unknown>;
	//# sourceMappingURL=control-3668.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/contract-type.d.ts
declare module '@sage/x3-master-data/lib/enums/contract-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ContractTypeEnum {
	    warranty = 1,
	    maintenance = 2,
	    point = 3
	}
	export interface ContractType$EnumInterface {
	    warranty: 1;
	    maintenance: 2;
	    point: 3;
	}
	export type ContractType = keyof ContractType$EnumInterface;
	export const contractTypeDatatype: X3EnumDataType<keyof ContractType$EnumInterface, unknown>;
	//# sourceMappingURL=contract-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/contract-statistics-group.d.ts
declare module '@sage/x3-master-data/lib/enums/contract-statistics-group' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ContractStatisticsGroupEnum {
	    contractGroupNo1 = 1,
	    contractGroupNo2 = 2,
	    contractGroupNo3 = 3,
	    contractGroupNo4 = 4,
	    contractGroupNo5 = 5
	}
	export interface ContractStatisticsGroup$EnumInterface {
	    contractGroupNo1: 1;
	    contractGroupNo2: 2;
	    contractGroupNo3: 3;
	    contractGroupNo4: 4;
	    contractGroupNo5: 5;
	}
	export type ContractStatisticsGroup = keyof ContractStatisticsGroup$EnumInterface;
	export const contractStatisticsGroupDatatype: X3EnumDataType<keyof ContractStatisticsGroup$EnumInterface, unknown>;
	//# sourceMappingURL=contract-statistics-group.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/contract-selection-date.d.ts
declare module '@sage/x3-master-data/lib/enums/contract-selection-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ContractSelectionDateEnum {
	    onStartDate = 1,
	    onEndDate = 2
	}
	export interface ContractSelectionDate$EnumInterface {
	    onStartDate: 1;
	    onEndDate: 2;
	}
	export type ContractSelectionDate = keyof ContractSelectionDate$EnumInterface;
	export const contractSelectionDateDatatype: X3EnumDataType<keyof ContractSelectionDate$EnumInterface, unknown>;
	//# sourceMappingURL=contract-selection-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/context.d.ts
declare module '@sage/x3-master-data/lib/enums/context' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ContextEnum {
	    labor = 1,
	    products = 2,
	    expenses = 3,
	    finance = 4,
	    timeEntry = 5
	}
	export interface Context$EnumInterface {
	    labor: 1;
	    products: 2;
	    expenses: 3;
	    finance: 4;
	    timeEntry: 5;
	}
	export type Context = keyof Context$EnumInterface;
	export const contextDatatype: X3EnumDataType<keyof Context$EnumInterface, unknown>;
	//# sourceMappingURL=context.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/context-recalculation.d.ts
declare module '@sage/x3-master-data/lib/enums/context-recalculation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ContextRecalculationEnum {
	    no = 1,
	    yes = 2,
	    yesAfterClosing = 3
	}
	export interface ContextRecalculation$EnumInterface {
	    no: 1;
	    yes: 2;
	    yesAfterClosing: 3;
	}
	export type ContextRecalculation = keyof ContextRecalculation$EnumInterface;
	export const contextRecalculationDatatype: X3EnumDataType<keyof ContextRecalculation$EnumInterface, unknown>;
	//# sourceMappingURL=context-recalculation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/consignment-goods-type.d.ts
declare module '@sage/x3-master-data/lib/enums/consignment-goods-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConsignmentGoodsTypeEnum {
	    delivery = 1,
	    initialRecipientSubstitution = 2,
	    deliveryToInitialOrSubstituteRecipient = 3,
	    otherDeliveryToInitialOrSubstituteRecipient = 4,
	    deliveryToAnotherCountry = 5,
	    destructionLossTheft = 6,
	    returnToTai = 7,
	    substituteValue8 = 8,
	    madeAvailableToTheDeclarant = 9
	}
	export interface ConsignmentGoodsType$EnumInterface {
	    delivery: 1;
	    initialRecipientSubstitution: 2;
	    deliveryToInitialOrSubstituteRecipient: 3;
	    otherDeliveryToInitialOrSubstituteRecipient: 4;
	    deliveryToAnotherCountry: 5;
	    destructionLossTheft: 6;
	    returnToTai: 7;
	    substituteValue8: 8;
	    madeAvailableToTheDeclarant: 9;
	}
	export type ConsignmentGoodsType = keyof ConsignmentGoodsType$EnumInterface;
	export const consignmentGoodsTypeDatatype: X3EnumDataType<keyof ConsignmentGoodsType$EnumInterface, unknown>;
	//# sourceMappingURL=consignment-goods-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/concession-status.d.ts
declare module '@sage/x3-master-data/lib/enums/concession-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConcessionStatusEnum {
	    underPreparation = 1,
	    active = 2,
	    ended = 3
	}
	export interface ConcessionStatus$EnumInterface {
	    underPreparation: 1;
	    active: 2;
	    ended: 3;
	}
	export type ConcessionStatus = keyof ConcessionStatus$EnumInterface;
	export const concessionStatusDatatype: X3EnumDataType<keyof ConcessionStatus$EnumInterface, unknown>;
	//# sourceMappingURL=concession-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/concession-management-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/concession-management-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConcessionManagementModeEnum {
	    substituteValue1 = 1,
	    renewal = 2
	}
	export interface ConcessionManagementMode$EnumInterface {
	    substituteValue1: 1;
	    renewal: 2;
	}
	export type ConcessionManagementMode = keyof ConcessionManagementMode$EnumInterface;
	export const concessionManagementModeDatatype: X3EnumDataType<keyof ConcessionManagementMode$EnumInterface, unknown>;
	//# sourceMappingURL=concession-management-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/concession-info-modification.d.ts
declare module '@sage/x3-master-data/lib/enums/concession-info-modification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConcessionInfoModificationEnum {
	    provisionalDate = 1,
	    contractualObligation = 2,
	    transferredAgainstIndemnity = 3,
	    updateCode = 4
	}
	export interface ConcessionInfoModification$EnumInterface {
	    provisionalDate: 1;
	    contractualObligation: 2;
	    transferredAgainstIndemnity: 3;
	    updateCode: 4;
	}
	export type ConcessionInfoModification = keyof ConcessionInfoModification$EnumInterface;
	export const concessionInfoModificationDatatype: X3EnumDataType<keyof ConcessionInfoModification$EnumInterface, unknown>;
	//# sourceMappingURL=concession-info-modification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/component-type.d.ts
declare module '@sage/x3-master-data/lib/enums/component-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ComponentTypeEnum {
	    normal = 1,
	    option = 2,
	    variant = 3,
	    byProduct = 4,
	    text = 5,
	    costing = 6,
	    service = 7,
	    multipleOption = 8,
	    normalWithFormula = 9
	}
	export interface ComponentType$EnumInterface {
	    normal: 1;
	    option: 2;
	    variant: 3;
	    byProduct: 4;
	    text: 5;
	    costing: 6;
	    service: 7;
	    multipleOption: 8;
	    normalWithFormula: 9;
	}
	export type ComponentType = keyof ComponentType$EnumInterface;
	export const componentTypeDatatype: X3EnumDataType<keyof ComponentType$EnumInterface, unknown>;
	//# sourceMappingURL=component-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/component-type-3513.d.ts
declare module '@sage/x3-master-data/lib/enums/component-type-3513' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ComponentType3513Enum {
	    existingMaterial = 1,
	    newMaterial = 2,
	    existingAssembly = 3,
	    designAssembly = 4,
	    genericProduct = 5,
	    costing = 6,
	    text = 7
	}
	export interface ComponentType3513$EnumInterface {
	    existingMaterial: 1;
	    newMaterial: 2;
	    existingAssembly: 3;
	    designAssembly: 4;
	    genericProduct: 5;
	    costing: 6;
	    text: 7;
	}
	export type ComponentType3513 = keyof ComponentType3513$EnumInterface;
	export const componentType3513Datatype: X3EnumDataType<keyof ComponentType3513$EnumInterface, unknown>;
	//# sourceMappingURL=component-type-3513.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/component-rounded.d.ts
declare module '@sage/x3-master-data/lib/enums/component-rounded' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ComponentRoundedEnum {
	    roundToTheNearest = 1,
	    greaterThan = 2,
	    lessThan = 3
	}
	export interface ComponentRounded$EnumInterface {
	    roundToTheNearest: 1;
	    greaterThan: 2;
	    lessThan: 3;
	}
	export type ComponentRounded = keyof ComponentRounded$EnumInterface;
	export const componentRoundedDatatype: X3EnumDataType<keyof ComponentRounded$EnumInterface, unknown>;
	//# sourceMappingURL=component-rounded.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/complete-name-of-contact.d.ts
declare module '@sage/x3-master-data/lib/enums/complete-name-of-contact' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CompleteNameOfContactEnum {
	    titleFirstNameSurname = 1,
	    titleSurnameFirstName = 2,
	    firstNameSurnameTitle = 3,
	    firstNameTitleSurname = 4,
	    surnameFirstNameTitle = 5,
	    surnameTitleFirstName = 6
	}
	export interface CompleteNameOfContact$EnumInterface {
	    titleFirstNameSurname: 1;
	    titleSurnameFirstName: 2;
	    firstNameSurnameTitle: 3;
	    firstNameTitleSurname: 4;
	    surnameFirstNameTitle: 5;
	    surnameTitleFirstName: 6;
	}
	export type CompleteNameOfContact = keyof CompleteNameOfContact$EnumInterface;
	export const completeNameOfContactDatatype: X3EnumDataType<keyof CompleteNameOfContact$EnumInterface, unknown>;
	//# sourceMappingURL=complete-name-of-contact.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/communication-type.d.ts
declare module '@sage/x3-master-data/lib/enums/communication-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CommunicationTypeEnum {
	    creation = 1,
	    modification = 2,
	    cancellation = 3
	}
	export interface CommunicationType$EnumInterface {
	    creation: 1;
	    modification: 2;
	    cancellation: 3;
	}
	export type CommunicationType = keyof CommunicationType$EnumInterface;
	export const communicationTypeDatatype: X3EnumDataType<keyof CommunicationType$EnumInterface, unknown>;
	//# sourceMappingURL=communication-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/communication-type-2427.d.ts
declare module '@sage/x3-master-data/lib/enums/communication-type-2427' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CommunicationType2427Enum {
	    saft = 1,
	    electronicInvoice = 2
	}
	export interface CommunicationType2427$EnumInterface {
	    saft: 1;
	    electronicInvoice: 2;
	}
	export type CommunicationType2427 = keyof CommunicationType2427$EnumInterface;
	export const communicationType2427Datatype: X3EnumDataType<keyof CommunicationType2427$EnumInterface, unknown>;
	//# sourceMappingURL=communication-type-2427.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/communication-provider.d.ts
declare module '@sage/x3-master-data/lib/enums/communication-provider' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CommunicationProviderEnum {
	    ama = 1,
	    digitalSign = 2,
	    undefined = 3
	}
	export interface CommunicationProvider$EnumInterface {
	    ama: 1;
	    digitalSign: 2;
	    undefined: 3;
	}
	export type CommunicationProvider = keyof CommunicationProvider$EnumInterface;
	export const communicationProviderDatatype: X3EnumDataType<keyof CommunicationProvider$EnumInterface, unknown>;
	//# sourceMappingURL=communication-provider.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/common-data-sequence-numbers.d.ts
declare module '@sage/x3-master-data/lib/enums/common-data-sequence-numbers' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CommonDataSequenceNumbersEnum {
	    mtoNetwork = 1,
	    vcsNumber = 2,
	    employeeIdNumber = 3,
	    arrivalOfANewEmployee = 4,
	    employmentContract = 5,
	    costStructure = 6,
	    costs = 7,
	    project = 8,
	    ediFileName = 9,
	    billOfLading = 10,
	    place = 11,
	    hazardousConditionsRecord = 12,
	    pjmProjectTask = 13,
	    pjmProjectBudget = 14,
	    pjmSoldProducts = 15,
	    pjmFinancialSnapshots = 16,
	    pjmProjectSnapshots = 17,
	    externalPayments = 18,
	    pjmTimeReport = 19,
	    pjmProgressBillingPlan = 20,
	    pjmTaskCode = 21,
	    pjmBudgetCode = 22,
	    pjmTimeBillingPlan = 23
	}
	export interface CommonDataSequenceNumbers$EnumInterface {
	    mtoNetwork: 1;
	    vcsNumber: 2;
	    employeeIdNumber: 3;
	    arrivalOfANewEmployee: 4;
	    employmentContract: 5;
	    costStructure: 6;
	    costs: 7;
	    project: 8;
	    ediFileName: 9;
	    billOfLading: 10;
	    place: 11;
	    hazardousConditionsRecord: 12;
	    pjmProjectTask: 13;
	    pjmProjectBudget: 14;
	    pjmSoldProducts: 15;
	    pjmFinancialSnapshots: 16;
	    pjmProjectSnapshots: 17;
	    externalPayments: 18;
	    pjmTimeReport: 19;
	    pjmProgressBillingPlan: 20;
	    pjmTaskCode: 21;
	    pjmBudgetCode: 22;
	    pjmTimeBillingPlan: 23;
	}
	export type CommonDataSequenceNumbers = keyof CommonDataSequenceNumbers$EnumInterface;
	export const commonDataSequenceNumbersDatatype: X3EnumDataType<keyof CommonDataSequenceNumbers$EnumInterface, unknown>;
	//# sourceMappingURL=common-data-sequence-numbers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/commission-type.d.ts
declare module '@sage/x3-master-data/lib/enums/commission-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CommissionTypeEnum {
	    yes = 1,
	    no = 2,
	    initialization = 3
	}
	export interface CommissionType$EnumInterface {
	    yes: 1;
	    no: 2;
	    initialization: 3;
	}
	export type CommissionType = keyof CommissionType$EnumInterface;
	export const commissionTypeDatatype: X3EnumDataType<keyof CommissionType$EnumInterface, unknown>;
	//# sourceMappingURL=commission-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/commission-category.d.ts
declare module '@sage/x3-master-data/lib/enums/commission-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CommissionCategoryEnum {
	    category1 = 1,
	    category2 = 2,
	    category3 = 3
	}
	export interface CommissionCategory$EnumInterface {
	    category1: 1;
	    category2: 2;
	    category3: 3;
	}
	export type CommissionCategory = keyof CommissionCategory$EnumInterface;
	export const commissionCategoryDatatype: X3EnumDataType<keyof CommissionCategory$EnumInterface, unknown>;
	//# sourceMappingURL=commission-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/commercial-action-type.d.ts
declare module '@sage/x3-master-data/lib/enums/commercial-action-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CommercialActionTypeEnum {
	    task = 1,
	    call = 2,
	    appointment = 3
	}
	export interface CommercialActionType$EnumInterface {
	    task: 1;
	    call: 2;
	    appointment: 3;
	}
	export type CommercialActionType = keyof CommercialActionType$EnumInterface;
	export const commercialActionTypeDatatype: X3EnumDataType<keyof CommercialActionType$EnumInterface, unknown>;
	//# sourceMappingURL=commercial-action-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/code-to-serve.d.ts
declare module '@sage/x3-master-data/lib/enums/code-to-serve' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CodeToServeEnum {
	    componentNotWeighedOnWeighingStations = 1,
	    componentWeighedOnWeighingStations = 2,
	    componentWeighedInProduction = 3,
	    excipientPhaseOnWeighingStations = 4,
	    excipientPhaseInManufacturing = 5,
	    finalWorkOrderExcipientPhaseOnWeighingStations = 6,
	    finalWorkOrderExcipientPhaseInManufacturing = 7,
	    materialCorrectionOnWeighingStations = 8,
	    materialCorrectionInManufacturing = 9,
	    qsfAtEndOfManufacture = 10
	}
	export interface CodeToServe$EnumInterface {
	    componentNotWeighedOnWeighingStations: 1;
	    componentWeighedOnWeighingStations: 2;
	    componentWeighedInProduction: 3;
	    excipientPhaseOnWeighingStations: 4;
	    excipientPhaseInManufacturing: 5;
	    finalWorkOrderExcipientPhaseOnWeighingStations: 6;
	    finalWorkOrderExcipientPhaseInManufacturing: 7;
	    materialCorrectionOnWeighingStations: 8;
	    materialCorrectionInManufacturing: 9;
	    qsfAtEndOfManufacture: 10;
	}
	export type CodeToServe = keyof CodeToServe$EnumInterface;
	export const codeToServeDatatype: X3EnumDataType<keyof CodeToServe$EnumInterface, unknown>;
	//# sourceMappingURL=code-to-serve.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/code-description-extraction.d.ts
declare module '@sage/x3-master-data/lib/enums/code-description-extraction' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CodeDescriptionExtractionEnum {
	    codeOnly = 1,
	    descriptionOnly = 2,
	    codeAndDescription = 3
	}
	export interface CodeDescriptionExtraction$EnumInterface {
	    codeOnly: 1;
	    descriptionOnly: 2;
	    codeAndDescription: 3;
	}
	export type CodeDescriptionExtraction = keyof CodeDescriptionExtraction$EnumInterface;
	export const codeDescriptionExtractionDatatype: X3EnumDataType<keyof CodeDescriptionExtraction$EnumInterface, unknown>;
	//# sourceMappingURL=code-description-extraction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/closed-status.d.ts
declare module '@sage/x3-master-data/lib/enums/closed-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ClosedStatusEnum {
	    select = 1,
	    rejected = 2,
	    completed = 3
	}
	export interface ClosedStatus$EnumInterface {
	    select: 1;
	    rejected: 2;
	    completed: 3;
	}
	export type ClosedStatus = keyof ClosedStatus$EnumInterface;
	export const closedStatusDatatype: X3EnumDataType<keyof ClosedStatus$EnumInterface, unknown>;
	//# sourceMappingURL=closed-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/clause-selection.d.ts
declare module '@sage/x3-master-data/lib/enums/clause-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ClauseSelectionEnum {
	    criteria = 1,
	    formula = 2,
	    criteriaAndFormula = 3
	}
	export interface ClauseSelection$EnumInterface {
	    criteria: 1;
	    formula: 2;
	    criteriaAndFormula: 3;
	}
	export type ClauseSelection = keyof ClauseSelection$EnumInterface;
	export const clauseSelectionDatatype: X3EnumDataType<keyof ClauseSelection$EnumInterface, unknown>;
	//# sourceMappingURL=clause-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/civility-type.d.ts
declare module '@sage/x3-master-data/lib/enums/civility-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CivilityTypeEnum {
	    mr = 1,
	    mrs = 2,
	    miss = 3
	}
	export interface CivilityType$EnumInterface {
	    mr: 1;
	    mrs: 2;
	    miss: 3;
	}
	export type CivilityType = keyof CivilityType$EnumInterface;
	export const civilityTypeDatatype: X3EnumDataType<keyof CivilityType$EnumInterface, unknown>;
	//# sourceMappingURL=civility-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/check-type-2761.d.ts
declare module '@sage/x3-master-data/lib/enums/check-type-2761' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CheckType2761Enum {
	    manual = 1,
	    normal = 2
	}
	export interface CheckType2761$EnumInterface {
	    manual: 1;
	    normal: 2;
	}
	export type CheckType2761 = keyof CheckType2761$EnumInterface;
	export const checkType2761Datatype: X3EnumDataType<keyof CheckType2761$EnumInterface, unknown>;
	//# sourceMappingURL=check-type-2761.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/check-status.d.ts
declare module '@sage/x3-master-data/lib/enums/check-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CheckStatusEnum {
	    unissued = 1,
	    issued = 2,
	    voided = 3,
	    posted = 4,
	    cleared = 5
	}
	export interface CheckStatus$EnumInterface {
	    unissued: 1;
	    issued: 2;
	    voided: 3;
	    posted: 4;
	    cleared: 5;
	}
	export type CheckStatus = keyof CheckStatus$EnumInterface;
	export const checkStatusDatatype: X3EnumDataType<keyof CheckStatus$EnumInterface, unknown>;
	//# sourceMappingURL=check-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/check-format.d.ts
declare module '@sage/x3-master-data/lib/enums/check-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CheckFormatEnum {
	    notUsed = 1,
	    checkStubStub = 2,
	    stubCheckStub = 3,
	    checkStub = 4
	}
	export interface CheckFormat$EnumInterface {
	    notUsed: 1;
	    checkStubStub: 2;
	    stubCheckStub: 3;
	    checkStub: 4;
	}
	export type CheckFormat = keyof CheckFormat$EnumInterface;
	export const checkFormatDatatype: X3EnumDataType<keyof CheckFormat$EnumInterface, unknown>;
	//# sourceMappingURL=check-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/check-document-type.d.ts
declare module '@sage/x3-master-data/lib/enums/check-document-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CheckDocumentTypeEnum {
	    check = 1,
	    draft = 2
	}
	export interface CheckDocumentType$EnumInterface {
	    check: 1;
	    draft: 2;
	}
	export type CheckDocumentType = keyof CheckDocumentType$EnumInterface;
	export const checkDocumentTypeDatatype: X3EnumDataType<keyof CheckDocumentType$EnumInterface, unknown>;
	//# sourceMappingURL=check-document-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/charge-discount-calculation.d.ts
declare module '@sage/x3-master-data/lib/enums/charge-discount-calculation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ChargeDiscountCalculationEnum {
	    byUnit = 1,
	    byLine = 2,
	    byDocument = 3
	}
	export interface ChargeDiscountCalculation$EnumInterface {
	    byUnit: 1;
	    byLine: 2;
	    byDocument: 3;
	}
	export type ChargeDiscountCalculation = keyof ChargeDiscountCalculation$EnumInterface;
	export const chargeDiscountCalculationDatatype: X3EnumDataType<keyof ChargeDiscountCalculation$EnumInterface, unknown>;
	//# sourceMappingURL=charge-discount-calculation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/change-status.d.ts
declare module '@sage/x3-master-data/lib/enums/change-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ChangeStatusEnum {
	    new = 1,
	    inReview = 2,
	    rejected = 3,
	    inPlanning = 4,
	    beingImplemented = 5,
	    completed = 6,
	    closed = 7
	}
	export interface ChangeStatus$EnumInterface {
	    new: 1;
	    inReview: 2;
	    rejected: 3;
	    inPlanning: 4;
	    beingImplemented: 5;
	    completed: 6;
	    closed: 7;
	}
	export type ChangeStatus = keyof ChangeStatus$EnumInterface;
	export const changeStatusDatatype: X3EnumDataType<keyof ChangeStatus$EnumInterface, unknown>;
	//# sourceMappingURL=change-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/change-request-status.d.ts
declare module '@sage/x3-master-data/lib/enums/change-request-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ChangeRequestStatusEnum {
	    select = 1,
	    newRequirement = 2,
	    enhancement = 3,
	    defect = 4,
	    other = 5
	}
	export interface ChangeRequestStatus$EnumInterface {
	    select: 1;
	    newRequirement: 2;
	    enhancement: 3;
	    defect: 4;
	    other: 5;
	}
	export type ChangeRequestStatus = keyof ChangeRequestStatus$EnumInterface;
	export const changeRequestStatusDatatype: X3EnumDataType<keyof ChangeRequestStatus$EnumInterface, unknown>;
	//# sourceMappingURL=change-request-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/certificate.d.ts
declare module '@sage/x3-master-data/lib/enums/certificate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CertificateEnum {
	    toBeDefined = 1
	}
	export interface Certificate$EnumInterface {
	    toBeDefined: 1;
	}
	export type Certificate = keyof Certificate$EnumInterface;
	export const certificateDatatype: X3EnumDataType<"toBeDefined", unknown>;
	//# sourceMappingURL=certificate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/category.d.ts
declare module '@sage/x3-master-data/lib/enums/category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CategoryEnum {
	    purchaseInvoice = 1,
	    salesInvoice = 2,
	    purchaseOrder = 3,
	    salesOrder = 4,
	    salesDelivery = 5,
	    intrastatDeclaration = 6,
	    salesDeliveryNotification = 7
	}
	export interface Category$EnumInterface {
	    purchaseInvoice: 1;
	    salesInvoice: 2;
	    purchaseOrder: 3;
	    salesOrder: 4;
	    salesDelivery: 5;
	    intrastatDeclaration: 6;
	    salesDeliveryNotification: 7;
	}
	export type Category = keyof Category$EnumInterface;
	export const categoryDatatype: X3EnumDataType<keyof Category$EnumInterface, unknown>;
	//# sourceMappingURL=category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/cash-forecast-types.d.ts
declare module '@sage/x3-master-data/lib/enums/cash-forecast-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CashForecastTypesEnum {
	    purchaseRequests = 1,
	    purchaseContracts = 2,
	    purchaseOrders = 3,
	    receiptsNotes = 4,
	    quotes = 5,
	    salesOrders = 6,
	    salesContracts = 7,
	    crmContracts = 8,
	    packingSlips = 9,
	    leasing = 10,
	    reserved11 = 11,
	    reserved12 = 12,
	    reserved13 = 13,
	    reserved14 = 14,
	    reserved15 = 15,
	    reserved16 = 16,
	    reserved17 = 17,
	    reserved18 = 18,
	    reserved = 19,
	    userType1 = 20,
	    userType2 = 21
	}
	export interface CashForecastTypes$EnumInterface {
	    purchaseRequests: 1;
	    purchaseContracts: 2;
	    purchaseOrders: 3;
	    receiptsNotes: 4;
	    quotes: 5;
	    salesOrders: 6;
	    salesContracts: 7;
	    crmContracts: 8;
	    packingSlips: 9;
	    leasing: 10;
	    reserved11: 11;
	    reserved12: 12;
	    reserved13: 13;
	    reserved14: 14;
	    reserved15: 15;
	    reserved16: 16;
	    reserved17: 17;
	    reserved18: 18;
	    reserved: 19;
	    userType1: 20;
	    userType2: 21;
	}
	export type CashForecastTypes = keyof CashForecastTypes$EnumInterface;
	export const cashForecastTypesDatatype: X3EnumDataType<keyof CashForecastTypes$EnumInterface, unknown>;
	//# sourceMappingURL=cash-forecast-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/carbon-emission-rate.d.ts
declare module '@sage/x3-master-data/lib/enums/carbon-emission-rate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CarbonEmissionRateEnum {
	    lessThanOrEqualTo100 = 1,
	    higherThan100AndLessThanOrEqualTo120 = 2,
	    higherThan120AndLessThanOrEqualTo140 = 3,
	    higherThan140AndLessThanOrEqualTo160 = 4,
	    higherThan160AndLessThanOrEqualTo200 = 5,
	    higherThan200AndLessThanOrEqualTo250 = 6,
	    higherThan250 = 7
	}
	export interface CarbonEmissionRate$EnumInterface {
	    lessThanOrEqualTo100: 1;
	    higherThan100AndLessThanOrEqualTo120: 2;
	    higherThan120AndLessThanOrEqualTo140: 3;
	    higherThan140AndLessThanOrEqualTo160: 4;
	    higherThan160AndLessThanOrEqualTo200: 5;
	    higherThan200AndLessThanOrEqualTo250: 6;
	    higherThan250: 7;
	}
	export type CarbonEmissionRate = keyof CarbonEmissionRate$EnumInterface;
	export const carbonEmissionRateDatatype: X3EnumDataType<keyof CarbonEmissionRate$EnumInterface, unknown>;
	//# sourceMappingURL=carbon-emission-rate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/cancellation-status.d.ts
declare module '@sage/x3-master-data/lib/enums/cancellation-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CancellationStatusEnum {
	    canceledInvoice = 1,
	    invoiceCancellation = 2,
	    normal = 3
	}
	export interface CancellationStatus$EnumInterface {
	    canceledInvoice: 1;
	    invoiceCancellation: 2;
	    normal: 3;
	}
	export type CancellationStatus = keyof CancellationStatus$EnumInterface;
	export const cancellationStatusDatatype: X3EnumDataType<keyof CancellationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=cancellation-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/campaign-display.d.ts
declare module '@sage/x3-master-data/lib/enums/campaign-display' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CampaignDisplayEnum {
	    includeCallsLinkedToACampaign = 1,
	    excludeCallsLinkedToACampaign = 2,
	    onlyCallsLinkedToACampaign = 3
	}
	export interface CampaignDisplay$EnumInterface {
	    includeCallsLinkedToACampaign: 1;
	    excludeCallsLinkedToACampaign: 2;
	    onlyCallsLinkedToACampaign: 3;
	}
	export type CampaignDisplay = keyof CampaignDisplay$EnumInterface;
	export const campaignDisplayDatatype: X3EnumDataType<keyof CampaignDisplay$EnumInterface, unknown>;
	//# sourceMappingURL=campaign-display.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/call-type.d.ts
declare module '@sage/x3-master-data/lib/enums/call-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CallTypeEnum {
	    incomingCall = 1,
	    outgoingCall = 2
	}
	export interface CallType$EnumInterface {
	    incomingCall: 1;
	    outgoingCall: 2;
	}
	export type CallType = keyof CallType$EnumInterface;
	export const callTypeDatatype: X3EnumDataType<keyof CallType$EnumInterface, unknown>;
	//# sourceMappingURL=call-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/call-run-later.d.ts
declare module '@sage/x3-master-data/lib/enums/call-run-later' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CallRunLaterEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    halfHour = 3,
	    substituteValue4 = 4,
	    tomorrow = 5,
	    customized = 6
	}
	export interface CallRunLater$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    halfHour: 3;
	    substituteValue4: 4;
	    tomorrow: 5;
	    customized: 6;
	}
	export type CallRunLater = keyof CallRunLater$EnumInterface;
	export const callRunLaterDatatype: X3EnumDataType<keyof CallRunLater$EnumInterface, unknown>;
	//# sourceMappingURL=call-run-later.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/call-run-later-2980.d.ts
declare module '@sage/x3-master-data/lib/enums/call-run-later-2980' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CallRunLater2980Enum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    customized = 6
	}
	export interface CallRunLater2980$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    customized: 6;
	}
	export type CallRunLater2980 = keyof CallRunLater2980$EnumInterface;
	export const callRunLater2980Datatype: X3EnumDataType<keyof CallRunLater2980$EnumInterface, unknown>;
	//# sourceMappingURL=call-run-later-2980.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/call-origin.d.ts
declare module '@sage/x3-master-data/lib/enums/call-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CallOriginEnum {
	    manualCreation = 1,
	    massMail = 2,
	    callCampaign = 3,
	    tradeShow = 4,
	    mediaCampaign = 5,
	    marketingCampaign = 6
	}
	export interface CallOrigin$EnumInterface {
	    manualCreation: 1;
	    massMail: 2;
	    callCampaign: 3;
	    tradeShow: 4;
	    mediaCampaign: 5;
	    marketingCampaign: 6;
	}
	export type CallOrigin = keyof CallOrigin$EnumInterface;
	export const callOriginDatatype: X3EnumDataType<keyof CallOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=call-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/call-cover.d.ts
declare module '@sage/x3-master-data/lib/enums/call-cover' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CallCoverEnum {
	    byServiceContract = 1,
	    byOrder = 2,
	    byCommercialDecision = 3,
	    byDirectInvoicing = 4,
	    byLoanContract = 5,
	    substituteValue6 = 6
	}
	export interface CallCover$EnumInterface {
	    byServiceContract: 1;
	    byOrder: 2;
	    byCommercialDecision: 3;
	    byDirectInvoicing: 4;
	    byLoanContract: 5;
	    substituteValue6: 6;
	}
	export type CallCover = keyof CallCover$EnumInterface;
	export const callCoverDatatype: X3EnumDataType<keyof CallCover$EnumInterface, unknown>;
	//# sourceMappingURL=call-cover.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/calendar-information.d.ts
declare module '@sage/x3-master-data/lib/enums/calendar-information' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalendarInformationEnum {
	    appointment = 1,
	    call = 2,
	    task = 3,
	    project = 4,
	    contract = 5
	}
	export interface CalendarInformation$EnumInterface {
	    appointment: 1;
	    call: 2;
	    task: 3;
	    project: 4;
	    contract: 5;
	}
	export type CalendarInformation = keyof CalendarInformation$EnumInterface;
	export const calendarInformationDatatype: X3EnumDataType<keyof CalendarInformation$EnumInterface, unknown>;
	//# sourceMappingURL=calendar-information.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/calendar-information-3048.d.ts
declare module '@sage/x3-master-data/lib/enums/calendar-information-3048' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalendarInformation3048Enum {
	    appointment = 1,
	    call = 2,
	    task = 3,
	    serviceResponse = 4,
	    request = 5
	}
	export interface CalendarInformation3048$EnumInterface {
	    appointment: 1;
	    call: 2;
	    task: 3;
	    serviceResponse: 4;
	    request: 5;
	}
	export type CalendarInformation3048 = keyof CalendarInformation3048$EnumInterface;
	export const calendarInformation3048Datatype: X3EnumDataType<keyof CalendarInformation3048$EnumInterface, unknown>;
	//# sourceMappingURL=calendar-information-3048.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/calendar-display-type.d.ts
declare module '@sage/x3-master-data/lib/enums/calendar-display-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalendarDisplayTypeEnum {
	    task = 1,
	    call = 2,
	    appointment = 3
	}
	export interface CalendarDisplayType$EnumInterface {
	    task: 1;
	    call: 2;
	    appointment: 3;
	}
	export type CalendarDisplayType = keyof CalendarDisplayType$EnumInterface;
	export const calendarDisplayTypeDatatype: X3EnumDataType<keyof CalendarDisplayType$EnumInterface, unknown>;
	//# sourceMappingURL=calendar-display-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/calendar-display-type-3052.d.ts
declare module '@sage/x3-master-data/lib/enums/calendar-display-type-3052' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalendarDisplayType3052Enum {
	    serviceResponse = 1
	}
	export interface CalendarDisplayType3052$EnumInterface {
	    serviceResponse: 1;
	}
	export type CalendarDisplayType3052 = keyof CalendarDisplayType3052$EnumInterface;
	export const calendarDisplayType3052Datatype: X3EnumDataType<"serviceResponse", unknown>;
	//# sourceMappingURL=calendar-display-type-3052.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/calculation-methods.d.ts
declare module '@sage/x3-master-data/lib/enums/calculation-methods' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalculationMethodsEnum {
	    dailyRate = 1,
	    actual365 = 2,
	    actual360 = 3,
	    actualActualIsda = 4,
	    substituteValue5 = 5
	}
	export interface CalculationMethods$EnumInterface {
	    dailyRate: 1;
	    actual365: 2;
	    actual360: 3;
	    actualActualIsda: 4;
	    substituteValue5: 5;
	}
	export type CalculationMethods = keyof CalculationMethods$EnumInterface;
	export const calculationMethodsDatatype: X3EnumDataType<keyof CalculationMethods$EnumInterface, unknown>;
	//# sourceMappingURL=calculation-methods.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/calculation-method.d.ts
declare module '@sage/x3-master-data/lib/enums/calculation-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalculationMethodEnum {
	    singleRate = 1,
	    ratePerInstallment = 2,
	    minMaxThreshold = 3
	}
	export interface CalculationMethod$EnumInterface {
	    singleRate: 1;
	    ratePerInstallment: 2;
	    minMaxThreshold: 3;
	}
	export type CalculationMethod = keyof CalculationMethod$EnumInterface;
	export const calculationMethodDatatype: X3EnumDataType<keyof CalculationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=calculation-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/calculation-closing-status.d.ts
declare module '@sage/x3-master-data/lib/enums/calculation-closing-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalculationClosingStatusEnum {
	    notCalculated = 1,
	    calculated = 2,
	    closed = 3
	}
	export interface CalculationClosingStatus$EnumInterface {
	    notCalculated: 1;
	    calculated: 2;
	    closed: 3;
	}
	export type CalculationClosingStatus = keyof CalculationClosingStatus$EnumInterface;
	export const calculationClosingStatusDatatype: X3EnumDataType<keyof CalculationClosingStatus$EnumInterface, unknown>;
	//# sourceMappingURL=calculation-closing-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/calculation-chronology.d.ts
declare module '@sage/x3-master-data/lib/enums/calculation-chronology' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalculationChronologyEnum {
	    beforeTaxCalculation = 1,
	    afterTaxCalculation = 2,
	    action = 3
	}
	export interface CalculationChronology$EnumInterface {
	    beforeTaxCalculation: 1;
	    afterTaxCalculation: 2;
	    action: 3;
	}
	export type CalculationChronology = keyof CalculationChronology$EnumInterface;
	export const calculationChronologyDatatype: X3EnumDataType<keyof CalculationChronology$EnumInterface, unknown>;
	//# sourceMappingURL=calculation-chronology.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/business-partner-sequence-nos.d.ts
declare module '@sage/x3-master-data/lib/enums/business-partner-sequence-nos' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BusinessPartnerSequenceNosEnum {
	    payments = 1,
	    paymentsReceivable = 2,
	    depositSlips = 3,
	    paymentOrders4 = 4,
	    statementsOfItemsDue = 5,
	    bankStatements = 6,
	    paymentEntryBatches = 7,
	    supplierProformas = 8,
	    draftNumbers = 9,
	    paymentOrders = 10,
	    receipt = 11,
	    reminderManagement = 12,
	    sepaMessageReference = 13,
	    mandateReference = 14,
	    recurringSupplierInvoice = 15,
	    recurringCustomerInvoice = 16,
	    positivePay = 17,
	    cashForecastManagement = 18,
	    variableMessageReference = 19,
	    cashRegister = 20,
	    bankRegister = 21,
	    prepaymentsInvoiceManagement = 22,
	    remittanceGroups = 23
	}
	export interface BusinessPartnerSequenceNos$EnumInterface {
	    payments: 1;
	    paymentsReceivable: 2;
	    depositSlips: 3;
	    paymentOrders4: 4;
	    statementsOfItemsDue: 5;
	    bankStatements: 6;
	    paymentEntryBatches: 7;
	    supplierProformas: 8;
	    draftNumbers: 9;
	    paymentOrders: 10;
	    receipt: 11;
	    reminderManagement: 12;
	    sepaMessageReference: 13;
	    mandateReference: 14;
	    recurringSupplierInvoice: 15;
	    recurringCustomerInvoice: 16;
	    positivePay: 17;
	    cashForecastManagement: 18;
	    variableMessageReference: 19;
	    cashRegister: 20;
	    bankRegister: 21;
	    prepaymentsInvoiceManagement: 22;
	    remittanceGroups: 23;
	}
	export type BusinessPartnerSequenceNos = keyof BusinessPartnerSequenceNos$EnumInterface;
	export const businessPartnerSequenceNosDatatype: X3EnumDataType<keyof BusinessPartnerSequenceNos$EnumInterface, unknown>;
	//# sourceMappingURL=business-partner-sequence-nos.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/business-partner-rule.d.ts
declare module '@sage/x3-master-data/lib/enums/business-partner-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BusinessPartnerRuleEnum {
	    customer = 1,
	    supplier = 2,
	    carrier = 3,
	    factor = 4,
	    salesRep = 5,
	    miscellaneousBPs = 6
	}
	export interface BusinessPartnerRule$EnumInterface {
	    customer: 1;
	    supplier: 2;
	    carrier: 3;
	    factor: 4;
	    salesRep: 5;
	    miscellaneousBPs: 6;
	}
	export type BusinessPartnerRule = keyof BusinessPartnerRule$EnumInterface;
	export const businessPartnerRuleDatatype: X3EnumDataType<keyof BusinessPartnerRule$EnumInterface, unknown>;
	//# sourceMappingURL=business-partner-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/business-object.d.ts
declare module '@sage/x3-master-data/lib/enums/business-object' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BusinessObjectEnum {
	    expense = 1,
	    asset = 2,
	    subsidy = 3,
	    leaseContract = 4,
	    physicalAssetCount = 5,
	    physicalAsset = 6,
	    concession = 7
	}
	export interface BusinessObject$EnumInterface {
	    expense: 1;
	    asset: 2;
	    subsidy: 3;
	    leaseContract: 4;
	    physicalAssetCount: 5;
	    physicalAsset: 6;
	    concession: 7;
	}
	export type BusinessObject = keyof BusinessObject$EnumInterface;
	export const businessObjectDatatype: X3EnumDataType<keyof BusinessObject$EnumInterface, unknown>;
	//# sourceMappingURL=business-object.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/bp-risk-initialization.d.ts
declare module '@sage/x3-master-data/lib/enums/bp-risk-initialization' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BpRiskInitializationEnum {
	    invoiceBp = 1,
	    payByBp = 2,
	    groupBp = 3
	}
	export interface BpRiskInitialization$EnumInterface {
	    invoiceBp: 1;
	    payByBp: 2;
	    groupBp: 3;
	}
	export type BpRiskInitialization = keyof BpRiskInitialization$EnumInterface;
	export const bpRiskInitializationDatatype: X3EnumDataType<keyof BpRiskInitialization$EnumInterface, unknown>;
	//# sourceMappingURL=bp-risk-initialization.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/bp-concerned-by-price-list.d.ts
declare module '@sage/x3-master-data/lib/enums/bp-concerned-by-price-list' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BpConcernedByPriceListEnum {
	    outsideGroup = 1,
	    group = 2,
	    all = 3
	}
	export interface BpConcernedByPriceList$EnumInterface {
	    outsideGroup: 1;
	    group: 2;
	    all: 3;
	}
	export type BpConcernedByPriceList = keyof BpConcernedByPriceList$EnumInterface;
	export const bpConcernedByPriceListDatatype: X3EnumDataType<keyof BpConcernedByPriceList$EnumInterface, unknown>;
	//# sourceMappingURL=bp-concerned-by-price-list.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/bom-quantity-link.d.ts
declare module '@sage/x3-master-data/lib/enums/bom-quantity-link' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BomQuantityLinkEnum {
	    proportional = 1,
	    fixed = 2
	}
	export interface BomQuantityLink$EnumInterface {
	    proportional: 1;
	    fixed: 2;
	}
	export type BomQuantityLink = keyof BomQuantityLink$EnumInterface;
	export const bomQuantityLinkDatatype: X3EnumDataType<keyof BomQuantityLink$EnumInterface, unknown>;
	//# sourceMappingURL=bom-quantity-link.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/bom-code-type.d.ts
declare module '@sage/x3-master-data/lib/enums/bom-code-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BomCodeTypeEnum {
	    salesKit = 1,
	    manufacturing = 2,
	    subcontracting = 3
	}
	export interface BomCodeType$EnumInterface {
	    salesKit: 1;
	    manufacturing: 2;
	    subcontracting: 3;
	}
	export type BomCodeType = keyof BomCodeType$EnumInterface;
	export const bomCodeTypeDatatype: X3EnumDataType<keyof BomCodeType$EnumInterface, unknown>;
	//# sourceMappingURL=bom-code-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/bi-line-type.d.ts
declare module '@sage/x3-master-data/lib/enums/bi-line-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BiLineTypeEnum {
	    normal = 1,
	    invoicingElement = 2,
	    parentProduct = 3,
	    component = 4,
	    free = 5,
	    openItem = 6
	}
	export interface BiLineType$EnumInterface {
	    normal: 1;
	    invoicingElement: 2;
	    parentProduct: 3;
	    component: 4;
	    free: 5;
	    openItem: 6;
	}
	export type BiLineType = keyof BiLineType$EnumInterface;
	export const biLineTypeDatatype: X3EnumDataType<keyof BiLineType$EnumInterface, unknown>;
	//# sourceMappingURL=bi-line-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/bi-flow.d.ts
declare module '@sage/x3-master-data/lib/enums/bi-flow' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BiFlowEnum {
	    standard = 1,
	    intercompany = 2,
	    intersite = 3
	}
	export interface BiFlow$EnumInterface {
	    standard: 1;
	    intercompany: 2;
	    intersite: 3;
	}
	export type BiFlow = keyof BiFlow$EnumInterface;
	export const biFlowDatatype: X3EnumDataType<keyof BiFlow$EnumInterface, unknown>;
	//# sourceMappingURL=bi-flow.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/below-exceed-all.d.ts
declare module '@sage/x3-master-data/lib/enums/below-exceed-all' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BelowExceedAllEnum {
	    below = 1,
	    exceeded = 2,
	    all = 3
	}
	export interface BelowExceedAll$EnumInterface {
	    below: 1;
	    exceeded: 2;
	    all: 3;
	}
	export type BelowExceedAll = keyof BelowExceedAll$EnumInterface;
	export const belowExceedAllDatatype: X3EnumDataType<keyof BelowExceedAll$EnumInterface, unknown>;
	//# sourceMappingURL=below-exceed-all.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/belgian-bank-statement-format.d.ts
declare module '@sage/x3-master-data/lib/enums/belgian-bank-statement-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BelgianBankStatementFormatEnum {
	    coda = 1,
	    manual = 2
	}
	export interface BelgianBankStatementFormat$EnumInterface {
	    coda: 1;
	    manual: 2;
	}
	export type BelgianBankStatementFormat = keyof BelgianBankStatementFormat$EnumInterface;
	export const belgianBankStatementFormatDatatype: X3EnumDataType<keyof BelgianBankStatementFormat$EnumInterface, unknown>;
	//# sourceMappingURL=belgian-bank-statement-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/begin-search-at.d.ts
declare module '@sage/x3-master-data/lib/enums/begin-search-at' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BeginSearchAtEnum {
	    firstCharacter = 1,
	    lastCharacter = 2,
	    startPosition = 3
	}
	export interface BeginSearchAt$EnumInterface {
	    firstCharacter: 1;
	    lastCharacter: 2;
	    startPosition: 3;
	}
	export type BeginSearchAt = keyof BeginSearchAt$EnumInterface;
	export const beginSearchAtDatatype: X3EnumDataType<keyof BeginSearchAt$EnumInterface, unknown>;
	//# sourceMappingURL=begin-search-at.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/basis.d.ts
declare module '@sage/x3-master-data/lib/enums/basis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BasisEnum {
	    quantity = 1,
	    volume = 2,
	    weight = 3
	}
	export interface Basis$EnumInterface {
	    quantity: 1;
	    volume: 2;
	    weight: 3;
	}
	export type Basis = keyof Basis$EnumInterface;
	export const basisDatatype: X3EnumDataType<keyof Basis$EnumInterface, unknown>;
	//# sourceMappingURL=basis.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/base-type-2983.d.ts
declare module '@sage/x3-master-data/lib/enums/base-type-2983' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BaseType2983Enum {
	    listedBase = 1,
	    filteredBase = 2
	}
	export interface BaseType2983$EnumInterface {
	    listedBase: 1;
	    filteredBase: 2;
	}
	export type BaseType2983 = keyof BaseType2983$EnumInterface;
	export const baseType2983Datatype: X3EnumDataType<keyof BaseType2983$EnumInterface, unknown>;
	//# sourceMappingURL=base-type-2983.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/base-rule-value-comp-target.d.ts
declare module '@sage/x3-master-data/lib/enums/base-rule-value-comp-target' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BaseRuleValueCompTargetEnum {
	    contributionValue = 1,
	    renewalToPreviousBasis = 2
	}
	export interface BaseRuleValueCompTarget$EnumInterface {
	    contributionValue: 1;
	    renewalToPreviousBasis: 2;
	}
	export type BaseRuleValueCompTarget = keyof BaseRuleValueCompTarget$EnumInterface;
	export const baseRuleValueCompTargetDatatype: X3EnumDataType<keyof BaseRuleValueCompTarget$EnumInterface, unknown>;
	//# sourceMappingURL=base-rule-value-comp-target.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/base-record-source.d.ts
declare module '@sage/x3-master-data/lib/enums/base-record-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BaseRecordSourceEnum {
	    manualCreation = 1,
	    split = 2,
	    shipmentValidation = 3,
	    invoiceValidation = 4,
	    warrantyRequest = 5,
	    manualModificationOfTheInstallation = 6,
	    salesReturn = 7,
	    loanReturn = 8
	}
	export interface BaseRecordSource$EnumInterface {
	    manualCreation: 1;
	    split: 2;
	    shipmentValidation: 3;
	    invoiceValidation: 4;
	    warrantyRequest: 5;
	    manualModificationOfTheInstallation: 6;
	    salesReturn: 7;
	    loanReturn: 8;
	}
	export type BaseRecordSource = keyof BaseRecordSource$EnumInterface;
	export const baseRecordSourceDatatype: X3EnumDataType<keyof BaseRecordSource$EnumInterface, unknown>;
	//# sourceMappingURL=base-record-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/base-of-expression.d.ts
declare module '@sage/x3-master-data/lib/enums/base-of-expression' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BaseOfExpressionEnum {
	    hours = 1,
	    days = 2,
	    weeks = 3,
	    months = 4,
	    years = 5,
	    substituteValue6 = 6
	}
	export interface BaseOfExpression$EnumInterface {
	    hours: 1;
	    days: 2;
	    weeks: 3;
	    months: 4;
	    years: 5;
	    substituteValue6: 6;
	}
	export type BaseOfExpression = keyof BaseOfExpression$EnumInterface;
	export const baseOfExpressionDatatype: X3EnumDataType<keyof BaseOfExpression$EnumInterface, unknown>;
	//# sourceMappingURL=base-of-expression.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/bank-statement-import.d.ts
declare module '@sage/x3-master-data/lib/enums/bank-statement-import' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BankStatementImportEnum {
	    documentNo = 1,
	    sourceDocumentNo = 2
	}
	export interface BankStatementImport$EnumInterface {
	    documentNo: 1;
	    sourceDocumentNo: 2;
	}
	export type BankStatementImport = keyof BankStatementImport$EnumInterface;
	export const bankStatementImportDatatype: X3EnumDataType<keyof BankStatementImport$EnumInterface, unknown>;
	//# sourceMappingURL=bank-statement-import.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/bank-sign.d.ts
declare module '@sage/x3-master-data/lib/enums/bank-sign' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BankSignEnum {
	    expense = 1,
	    revenue = 2,
	    expenseReversal = 3,
	    revenueReversal = 4
	}
	export interface BankSign$EnumInterface {
	    expense: 1;
	    revenue: 2;
	    expenseReversal: 3;
	    revenueReversal: 4;
	}
	export type BankSign = keyof BankSign$EnumInterface;
	export const bankSignDatatype: X3EnumDataType<keyof BankSign$EnumInterface, unknown>;
	//# sourceMappingURL=bank-sign.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/bank-file-generation-mode.d.ts
declare module '@sage/x3-master-data/lib/enums/bank-file-generation-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BankFileGenerationModeEnum {
	    create = 1,
	    regenerate = 2
	}
	export interface BankFileGenerationMode$EnumInterface {
	    create: 1;
	    regenerate: 2;
	}
	export type BankFileGenerationMode = keyof BankFileGenerationMode$EnumInterface;
	export const bankFileGenerationModeDatatype: X3EnumDataType<keyof BankFileGenerationMode$EnumInterface, unknown>;
	//# sourceMappingURL=bank-file-generation-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/bank-file-field-type.d.ts
declare module '@sage/x3-master-data/lib/enums/bank-file-field-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BankFileFieldTypeEnum {
	    alphanumeric = 1,
	    numeric = 2,
	    dateDdmmyy = 3,
	    dateYymmdd = 4,
	    year = 5,
	    month = 6,
	    day = 7,
	    binary = 8,
	    centAmount = 9
	}
	export interface BankFileFieldType$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	    dateDdmmyy: 3;
	    dateYymmdd: 4;
	    year: 5;
	    month: 6;
	    day: 7;
	    binary: 8;
	    centAmount: 9;
	}
	export type BankFileFieldType = keyof BankFileFieldType$EnumInterface;
	export const bankFileFieldTypeDatatype: X3EnumDataType<keyof BankFileFieldType$EnumInterface, unknown>;
	//# sourceMappingURL=bank-file-field-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/bank-cash.d.ts
declare module '@sage/x3-master-data/lib/enums/bank-cash' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BankCashEnum {
	    bank = 1,
	    cash = 2
	}
	export interface BankCash$EnumInterface {
	    bank: 1;
	    cash: 2;
	}
	export type BankCash = keyof BankCash$EnumInterface;
	export const bankCashDatatype: X3EnumDataType<keyof BankCash$EnumInterface, unknown>;
	//# sourceMappingURL=bank-cash.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/automatic-numbers.d.ts
declare module '@sage/x3-master-data/lib/enums/automatic-numbers' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AutomaticNumbersEnum {
	    none = 1,
	    mandatory = 2,
	    optional = 3
	}
	export interface AutomaticNumbers$EnumInterface {
	    none: 1;
	    mandatory: 2;
	    optional: 3;
	}
	export type AutomaticNumbers = keyof AutomaticNumbers$EnumInterface;
	export const automaticNumbersDatatype: X3EnumDataType<keyof AutomaticNumbers$EnumInterface, unknown>;
	//# sourceMappingURL=automatic-numbers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/automatic-journal-type.d.ts
declare module '@sage/x3-master-data/lib/enums/automatic-journal-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AutomaticJournalTypeEnum {
	    general = 1,
	    payments = 2
	}
	export interface AutomaticJournalType$EnumInterface {
	    general: 1;
	    payments: 2;
	}
	export type AutomaticJournalType = keyof AutomaticJournalType$EnumInterface;
	export const automaticJournalTypeDatatype: X3EnumDataType<keyof AutomaticJournalType$EnumInterface, unknown>;
	//# sourceMappingURL=automatic-journal-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/automatic-journal-enum.d.ts
declare module '@sage/x3-master-data/lib/enums/automatic-journal-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AutomaticJournalEnumEnum {
	    substituteValue1 = 1,
	    groupedJournal = 2
	}
	export interface AutomaticJournalEnum$EnumInterface {
	    substituteValue1: 1;
	    groupedJournal: 2;
	}
	export type AutomaticJournalEnum = keyof AutomaticJournalEnum$EnumInterface;
	export const automaticJournalEnumDatatype: X3EnumDataType<keyof AutomaticJournalEnum$EnumInterface, unknown>;
	//# sourceMappingURL=automatic-journal-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/authorization-step.d.ts
declare module '@sage/x3-master-data/lib/enums/authorization-step' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AuthorizationStepEnum {
	    orderEntry = 1,
	    postOrder = 2
	}
	export interface AuthorizationStep$EnumInterface {
	    orderEntry: 1;
	    postOrder: 2;
	}
	export type AuthorizationStep = keyof AuthorizationStep$EnumInterface;
	export const authorizationStepDatatype: X3EnumDataType<keyof AuthorizationStep$EnumInterface, unknown>;
	//# sourceMappingURL=authorization-step.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/attachment-categories.d.ts
declare module '@sage/x3-master-data/lib/enums/attachment-categories' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AttachmentCategoriesEnum {
	    select = 1,
	    requestDetail = 2,
	    approval = 3,
	    recommendation = 4,
	    planning = 5,
	    implementation = 6,
	    rejection = 7,
	    other = 8
	}
	export interface AttachmentCategories$EnumInterface {
	    select: 1;
	    requestDetail: 2;
	    approval: 3;
	    recommendation: 4;
	    planning: 5;
	    implementation: 6;
	    rejection: 7;
	    other: 8;
	}
	export type AttachmentCategories = keyof AttachmentCategories$EnumInterface;
	export const attachmentCategoriesDatatype: X3EnumDataType<keyof AttachmentCategories$EnumInterface, unknown>;
	//# sourceMappingURL=attachment-categories.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/attachement.d.ts
declare module '@sage/x3-master-data/lib/enums/attachement' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AttachementEnum {
	    no = 1,
	    yes = 2,
	    all = 3
	}
	export interface Attachement$EnumInterface {
	    no: 1;
	    yes: 2;
	    all: 3;
	}
	export type Attachement = keyof Attachement$EnumInterface;
	export const attachementDatatype: X3EnumDataType<keyof Attachement$EnumInterface, unknown>;
	//# sourceMappingURL=attachement.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/at-record-type.d.ts
declare module '@sage/x3-master-data/lib/enums/at-record-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AtRecordTypeEnum {
	    manual = 1,
	    saftT = 2,
	    webService = 3
	}
	export interface AtRecordType$EnumInterface {
	    manual: 1;
	    saftT: 2;
	    webService: 3;
	}
	export type AtRecordType = keyof AtRecordType$EnumInterface;
	export const atRecordTypeDatatype: X3EnumDataType<keyof AtRecordType$EnumInterface, unknown>;
	//# sourceMappingURL=at-record-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/assignment-type-sre.d.ts
declare module '@sage/x3-master-data/lib/enums/assignment-type-sre' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssignmentTypeSreEnum {
	    accordingToMarketSector = 1,
	    dispatching = 2,
	    queue = 3,
	    nominal = 4,
	    personOnTheBase = 5,
	    externalServiceProvider = 6
	}
	export interface AssignmentTypeSre$EnumInterface {
	    accordingToMarketSector: 1;
	    dispatching: 2;
	    queue: 3;
	    nominal: 4;
	    personOnTheBase: 5;
	    externalServiceProvider: 6;
	}
	export type AssignmentTypeSre = keyof AssignmentTypeSre$EnumInterface;
	export const assignmentTypeSreDatatype: X3EnumDataType<keyof AssignmentTypeSre$EnumInterface, unknown>;
	//# sourceMappingURL=assignment-type-sre.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/asset-status.d.ts
declare module '@sage/x3-master-data/lib/enums/asset-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssetStatusEnum {
	    autonomous = 1,
	    principal = 2,
	    component = 3,
	    componentWaitingAssignment = 4,
	    pool = 5,
	    lva = 6
	}
	export interface AssetStatus$EnumInterface {
	    autonomous: 1;
	    principal: 2;
	    component: 3;
	    componentWaitingAssignment: 4;
	    pool: 5;
	    lva: 6;
	}
	export type AssetStatus = keyof AssetStatus$EnumInterface;
	export const assetStatusDatatype: X3EnumDataType<keyof AssetStatus$EnumInterface, unknown>;
	//# sourceMappingURL=asset-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/asset-status-at-purchase.d.ts
declare module '@sage/x3-master-data/lib/enums/asset-status-at-purchase' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssetStatusAtPurchaseEnum {
	    new = 1,
	    secondHand = 2
	}
	export interface AssetStatusAtPurchase$EnumInterface {
	    new: 1;
	    secondHand: 2;
	}
	export type AssetStatusAtPurchase = keyof AssetStatusAtPurchase$EnumInterface;
	export const assetStatusAtPurchaseDatatype: X3EnumDataType<keyof AssetStatusAtPurchase$EnumInterface, unknown>;
	//# sourceMappingURL=asset-status-at-purchase.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/asset-stability-type.d.ts
declare module '@sage/x3-master-data/lib/enums/asset-stability-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssetStabilityTypeEnum {
	    fixed = 1,
	    generalInstallation = 2,
	    mobile = 3
	}
	export interface AssetStabilityType$EnumInterface {
	    fixed: 1;
	    generalInstallation: 2;
	    mobile: 3;
	}
	export type AssetStabilityType = keyof AssetStabilityType$EnumInterface;
	export const assetStabilityTypeDatatype: X3EnumDataType<keyof AssetStabilityType$EnumInterface, unknown>;
	//# sourceMappingURL=asset-stability-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/asset-split-method.d.ts
declare module '@sage/x3-master-data/lib/enums/asset-split-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssetSplitMethodEnum {
	    quantity = 1,
	    amount = 2,
	    expense = 3
	}
	export interface AssetSplitMethod$EnumInterface {
	    quantity: 1;
	    amount: 2;
	    expense: 3;
	}
	export type AssetSplitMethod = keyof AssetSplitMethod$EnumInterface;
	export const assetSplitMethodDatatype: X3EnumDataType<keyof AssetSplitMethod$EnumInterface, unknown>;
	//# sourceMappingURL=asset-split-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/asset-split-method-3139.d.ts
declare module '@sage/x3-master-data/lib/enums/asset-split-method-3139' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssetSplitMethod3139Enum {
	    splitByPhysicalAsset = 1,
	    splitByPendingMovement = 2,
	    splitByExpense = 3
	}
	export interface AssetSplitMethod3139$EnumInterface {
	    splitByPhysicalAsset: 1;
	    splitByPendingMovement: 2;
	    splitByExpense: 3;
	}
	export type AssetSplitMethod3139 = keyof AssetSplitMethod3139$EnumInterface;
	export const assetSplitMethod3139Datatype: X3EnumDataType<keyof AssetSplitMethod3139$EnumInterface, unknown>;
	//# sourceMappingURL=asset-split-method-3139.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/asset-receipt-nature.d.ts
declare module '@sage/x3-master-data/lib/enums/asset-receipt-nature' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssetReceiptNatureEnum {
	    purchase = 1,
	    internalProduction = 2,
	    partialProvisionForAsset = 3,
	    merger = 4,
	    split = 5,
	    intraGroupSales = 6,
	    leaseBuyback = 7
	}
	export interface AssetReceiptNature$EnumInterface {
	    purchase: 1;
	    internalProduction: 2;
	    partialProvisionForAsset: 3;
	    merger: 4;
	    split: 5;
	    intraGroupSales: 6;
	    leaseBuyback: 7;
	}
	export type AssetReceiptNature = keyof AssetReceiptNature$EnumInterface;
	export const assetReceiptNatureDatatype: X3EnumDataType<keyof AssetReceiptNature$EnumInterface, unknown>;
	//# sourceMappingURL=asset-receipt-nature.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/asset-nature-for-the-tp-tf.d.ts
declare module '@sage/x3-master-data/lib/enums/asset-nature-for-the-tp-tf' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssetNatureForTheTpTfEnum {
	    bnptf = 1,
	    bptf = 2,
	    exField = 3
	}
	export interface AssetNatureForTheTpTf$EnumInterface {
	    bnptf: 1;
	    bptf: 2;
	    exField: 3;
	}
	export type AssetNatureForTheTpTf = keyof AssetNatureForTheTpTf$EnumInterface;
	export const assetNatureForTheTpTfDatatype: X3EnumDataType<keyof AssetNatureForTheTpTf$EnumInterface, unknown>;
	//# sourceMappingURL=asset-nature-for-the-tp-tf.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/asset-holding-type.d.ts
declare module '@sage/x3-master-data/lib/enums/asset-holding-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssetHoldingTypeEnum {
	    owned = 1,
	    rented = 2,
	    leased = 3,
	    provisional = 4,
	    concession = 5,
	    template = 6,
	    cancelled = 7
	}
	export interface AssetHoldingType$EnumInterface {
	    owned: 1;
	    rented: 2;
	    leased: 3;
	    provisional: 4;
	    concession: 5;
	    template: 6;
	    cancelled: 7;
	}
	export type AssetHoldingType = keyof AssetHoldingType$EnumInterface;
	export const assetHoldingTypeDatatype: X3EnumDataType<keyof AssetHoldingType$EnumInterface, unknown>;
	//# sourceMappingURL=asset-holding-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/approver-rejection-email-text.d.ts
declare module '@sage/x3-master-data/lib/enums/approver-rejection-email-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ApproverRejectionEmailTextEnum {
	    approverRejectionOfChangeRequest1 = 1,
	    anApproverHasRejectedThisChangeRequest = 2,
	    theApproverAndRejectedEntitiesAre = 3,
	    toViewTheChangeRequestClickTheLink = 4
	}
	export interface ApproverRejectionEmailText$EnumInterface {
	    approverRejectionOfChangeRequest1: 1;
	    anApproverHasRejectedThisChangeRequest: 2;
	    theApproverAndRejectedEntitiesAre: 3;
	    toViewTheChangeRequestClickTheLink: 4;
	}
	export type ApproverRejectionEmailText = keyof ApproverRejectionEmailText$EnumInterface;
	export const approverRejectionEmailTextDatatype: X3EnumDataType<keyof ApproverRejectionEmailText$EnumInterface, unknown>;
	//# sourceMappingURL=approver-rejection-email-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/approval-status.d.ts
declare module '@sage/x3-master-data/lib/enums/approval-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ApprovalStatusEnum {
	    pending = 1,
	    approved = 2,
	    rejected = 3
	}
	export interface ApprovalStatus$EnumInterface {
	    pending: 1;
	    approved: 2;
	    rejected: 3;
	}
	export type ApprovalStatus = keyof ApprovalStatus$EnumInterface;
	export const approvalStatusDatatype: X3EnumDataType<keyof ApprovalStatus$EnumInterface, unknown>;
	//# sourceMappingURL=approval-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/approval-status-3510.d.ts
declare module '@sage/x3-master-data/lib/enums/approval-status-3510' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ApprovalStatus3510Enum {
	    approvalPending = 1,
	    approvalSubmitted = 2,
	    approvalInProgress = 3,
	    approvalRejected = 4,
	    approvedForPrototype = 5,
	    approvedForPilot = 6,
	    approvedForProduction = 7
	}
	export interface ApprovalStatus3510$EnumInterface {
	    approvalPending: 1;
	    approvalSubmitted: 2;
	    approvalInProgress: 3;
	    approvalRejected: 4;
	    approvedForPrototype: 5;
	    approvedForPilot: 6;
	    approvedForProduction: 7;
	}
	export type ApprovalStatus3510 = keyof ApprovalStatus3510$EnumInterface;
	export const approvalStatus3510Datatype: X3EnumDataType<keyof ApprovalStatus3510$EnumInterface, unknown>;
	//# sourceMappingURL=approval-status-3510.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/appointments-origins.d.ts
declare module '@sage/x3-master-data/lib/enums/appointments-origins' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AppointmentsOriginsEnum {
	    manualCreation = 1,
	    massMail = 2,
	    callCampaign = 3,
	    tradeShow = 4,
	    mediaCampaign = 5,
	    marketingCampaign = 6
	}
	export interface AppointmentsOrigins$EnumInterface {
	    manualCreation: 1;
	    massMail: 2;
	    callCampaign: 3;
	    tradeShow: 4;
	    mediaCampaign: 5;
	    marketingCampaign: 6;
	}
	export type AppointmentsOrigins = keyof AppointmentsOrigins$EnumInterface;
	export const appointmentsOriginsDatatype: X3EnumDataType<keyof AppointmentsOrigins$EnumInterface, unknown>;
	//# sourceMappingURL=appointments-origins.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/applicable-rule-upon-disposal.d.ts
declare module '@sage/x3-master-data/lib/enums/applicable-rule-upon-disposal' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ApplicableRuleUponDisposalEnum {
	    disposalOnTheSpecifiedDay = 1,
	    disposalAtTheEndOfThePreviousMonth = 2,
	    disposalAtTheEndOfTheCurrentMonth = 3,
	    disposalAtTheEndOfThePreviousFy = 4,
	    disposalAtTheEndOfTheCurrentFy = 5,
	    disposalAtTheEndOfThePreviousHalfYear = 6,
	    disposalAtTheEndOfTheCurrentHalfYear = 7,
	    noDepreciationChargeOnTheDisposalDay = 8,
	    substituteValue9 = 9,
	    excepDeprecNetValue = 10
	}
	export interface ApplicableRuleUponDisposal$EnumInterface {
	    disposalOnTheSpecifiedDay: 1;
	    disposalAtTheEndOfThePreviousMonth: 2;
	    disposalAtTheEndOfTheCurrentMonth: 3;
	    disposalAtTheEndOfThePreviousFy: 4;
	    disposalAtTheEndOfTheCurrentFy: 5;
	    disposalAtTheEndOfThePreviousHalfYear: 6;
	    disposalAtTheEndOfTheCurrentHalfYear: 7;
	    noDepreciationChargeOnTheDisposalDay: 8;
	    substituteValue9: 9;
	    excepDeprecNetValue: 10;
	}
	export type ApplicableRuleUponDisposal = keyof ApplicableRuleUponDisposal$EnumInterface;
	export const applicableRuleUponDisposalDatatype: X3EnumDataType<keyof ApplicableRuleUponDisposal$EnumInterface, unknown>;
	//# sourceMappingURL=applicable-rule-upon-disposal.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/applicable-rate.d.ts
declare module '@sage/x3-master-data/lib/enums/applicable-rate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ApplicableRateEnum {
	    contract = 1,
	    invoice = 2
	}
	export interface ApplicableRate$EnumInterface {
	    contract: 1;
	    invoice: 2;
	}
	export type ApplicableRate = keyof ApplicableRate$EnumInterface;
	export const applicableRateDatatype: X3EnumDataType<keyof ApplicableRate$EnumInterface, unknown>;
	//# sourceMappingURL=applicable-rate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/annual-operation-type.d.ts
declare module '@sage/x3-master-data/lib/enums/annual-operation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnnualOperationTypeEnum {
	    cashCollections = 1,
	    insuranceOperations = 2,
	    travelAgency = 3
	}
	export interface AnnualOperationType$EnumInterface {
	    cashCollections: 1;
	    insuranceOperations: 2;
	    travelAgency: 3;
	}
	export type AnnualOperationType = keyof AnnualOperationType$EnumInterface;
	export const annualOperationTypeDatatype: X3EnumDataType<keyof AnnualOperationType$EnumInterface, unknown>;
	//# sourceMappingURL=annual-operation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/and-or-not.d.ts
declare module '@sage/x3-master-data/lib/enums/and-or-not' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AndOrNotEnum {
	    substituteValue1 = 1,
	    and = 2,
	    or = 3,
	    andNot = 4,
	    orNot = 5
	}
	export interface AndOrNot$EnumInterface {
	    substituteValue1: 1;
	    and: 2;
	    or: 3;
	    andNot: 4;
	    orNot: 5;
	}
	export type AndOrNot = keyof AndOrNot$EnumInterface;
	export const andOrNotDatatype: X3EnumDataType<keyof AndOrNot$EnumInterface, unknown>;
	//# sourceMappingURL=and-or-not.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/and-or-not-3024.d.ts
declare module '@sage/x3-master-data/lib/enums/and-or-not-3024' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AndOrNot3024Enum {
	    and = 1,
	    or = 2,
	    andNot = 3,
	    orNot = 4
	}
	export interface AndOrNot3024$EnumInterface {
	    and: 1;
	    or: 2;
	    andNot: 3;
	    orNot: 4;
	}
	export type AndOrNot3024 = keyof AndOrNot3024$EnumInterface;
	export const andOrNot3024Datatype: X3EnumDataType<keyof AndOrNot3024$EnumInterface, unknown>;
	//# sourceMappingURL=and-or-not-3024.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/and-or-2955.d.ts
declare module '@sage/x3-master-data/lib/enums/and-or-2955' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AndOr2955Enum {
	    substituteValue1 = 1,
	    and = 2,
	    or = 3
	}
	export interface AndOr2955$EnumInterface {
	    substituteValue1: 1;
	    and: 2;
	    or: 3;
	}
	export type AndOr2955 = keyof AndOr2955$EnumInterface;
	export const andOr2955Datatype: X3EnumDataType<keyof AndOr2955$EnumInterface, unknown>;
	//# sourceMappingURL=and-or-2955.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/analytical-sort.d.ts
declare module '@sage/x3-master-data/lib/enums/analytical-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnalyticalSortEnum {
	    date = 1,
	    document = 2,
	    dimension = 3
	}
	export interface AnalyticalSort$EnumInterface {
	    date: 1;
	    document: 2;
	    dimension: 3;
	}
	export type AnalyticalSort = keyof AnalyticalSort$EnumInterface;
	export const analyticalSortDatatype: X3EnumDataType<keyof AnalyticalSort$EnumInterface, unknown>;
	//# sourceMappingURL=analytical-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/analytical-init-type.d.ts
declare module '@sage/x3-master-data/lib/enums/analytical-init-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnalyticalInitTypeEnum {
	    fixed = 1,
	    user = 2
	}
	export interface AnalyticalInitType$EnumInterface {
	    fixed: 1;
	    user: 2;
	}
	export type AnalyticalInitType = keyof AnalyticalInitType$EnumInterface;
	export const analyticalInitTypeDatatype: X3EnumDataType<keyof AnalyticalInitType$EnumInterface, unknown>;
	//# sourceMappingURL=analytical-init-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/amount-for-asset-split.d.ts
declare module '@sage/x3-master-data/lib/enums/amount-for-asset-split' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AmountForAssetSplitEnum {
	    coAReceiptExTaxValue = 1,
	    iasIfrsReceiptExTaxValue = 2,
	    coABalanceSheetValue = 3,
	    iasIfrsBalanceSheetValue = 4,
	    coAReevaluatedBalanceSheetValue = 5,
	    iasIfrsReevaluatedBalanceSheetValue = 6
	}
	export interface AmountForAssetSplit$EnumInterface {
	    coAReceiptExTaxValue: 1;
	    iasIfrsReceiptExTaxValue: 2;
	    coABalanceSheetValue: 3;
	    iasIfrsBalanceSheetValue: 4;
	    coAReevaluatedBalanceSheetValue: 5;
	    iasIfrsReevaluatedBalanceSheetValue: 6;
	}
	export type AmountForAssetSplit = keyof AmountForAssetSplit$EnumInterface;
	export const amountForAssetSplitDatatype: X3EnumDataType<keyof AmountForAssetSplit$EnumInterface, unknown>;
	//# sourceMappingURL=amount-for-asset-split.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/almacom-protocols.d.ts
declare module '@sage/x3-master-data/lib/enums/almacom-protocols' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AlmacomProtocolsEnum {
	    etebac3 = 1,
	    pesit = 2,
	    xmodem = 3,
	    etebac5 = 4
	}
	export interface AlmacomProtocols$EnumInterface {
	    etebac3: 1;
	    pesit: 2;
	    xmodem: 3;
	    etebac5: 4;
	}
	export type AlmacomProtocols = keyof AlmacomProtocols$EnumInterface;
	export const almacomProtocolsDatatype: X3EnumDataType<keyof AlmacomProtocols$EnumInterface, unknown>;
	//# sourceMappingURL=almacom-protocols.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/allocation-type.d.ts
declare module '@sage/x3-master-data/lib/enums/allocation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocationTypeEnum {
	    global = 1,
	    detailed = 2
	}
	export interface AllocationType$EnumInterface {
	    global: 1;
	    detailed: 2;
	}
	export type AllocationType = keyof AllocationType$EnumInterface;
	export const allocationTypeDatatype: X3EnumDataType<keyof AllocationType$EnumInterface, unknown>;
	//# sourceMappingURL=allocation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/allocation-type-3621.d.ts
declare module '@sage/x3-master-data/lib/enums/allocation-type-3621' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocationType3621Enum {
	    none = 1,
	    account = 2
	}
	export interface AllocationType3621$EnumInterface {
	    none: 1;
	    account: 2;
	}
	export type AllocationType3621 = keyof AllocationType3621$EnumInterface;
	export const allocationType3621Datatype: X3EnumDataType<keyof AllocationType3621$EnumInterface, unknown>;
	//# sourceMappingURL=allocation-type-3621.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/allocation-status.d.ts
declare module '@sage/x3-master-data/lib/enums/allocation-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocationStatusEnum {
	    notAllocated = 1,
	    partlyAllocated = 2,
	    allocated = 3
	}
	export interface AllocationStatus$EnumInterface {
	    notAllocated: 1;
	    partlyAllocated: 2;
	    allocated: 3;
	}
	export type AllocationStatus = keyof AllocationStatus$EnumInterface;
	export const allocationStatusDatatype: X3EnumDataType<keyof AllocationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=allocation-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/all-approver-email-text.d.ts
declare module '@sage/x3-master-data/lib/enums/all-approver-email-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllApproverEmailTextEnum {
	    approvalStatusSetForAllApproversForChangeRequest1 = 1,
	    allApproversHaveSetApprovalStatusToApprovedOrRejectedForThisChangeRequest = 2,
	    toViewTheChangeRequestClickTheLink = 3
	}
	export interface AllApproverEmailText$EnumInterface {
	    approvalStatusSetForAllApproversForChangeRequest1: 1;
	    allApproversHaveSetApprovalStatusToApprovedOrRejectedForThisChangeRequest: 2;
	    toViewTheChangeRequestClickTheLink: 3;
	}
	export type AllApproverEmailText = keyof AllApproverEmailText$EnumInterface;
	export const allApproverEmailTextDatatype: X3EnumDataType<keyof AllApproverEmailText$EnumInterface, unknown>;
	//# sourceMappingURL=all-approver-email-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/aggregation-level.d.ts
declare module '@sage/x3-master-data/lib/enums/aggregation-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AggregationLevelEnum {
	    detail = 1,
	    date = 2,
	    week = 3,
	    month = 4
	}
	export interface AggregationLevel$EnumInterface {
	    detail: 1;
	    date: 2;
	    week: 3;
	    month: 4;
	}
	export type AggregationLevel = keyof AggregationLevel$EnumInterface;
	export const aggregationLevelDatatype: X3EnumDataType<keyof AggregationLevel$EnumInterface, unknown>;
	//# sourceMappingURL=aggregation-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/after-sales-service-departments.d.ts
declare module '@sage/x3-master-data/lib/enums/after-sales-service-departments' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AfterSalesServiceDepartmentsEnum {
	    units = 1,
	    days = 2,
	    hours = 3,
	    minutes = 4,
	    other = 5
	}
	export interface AfterSalesServiceDepartments$EnumInterface {
	    units: 1;
	    days: 2;
	    hours: 3;
	    minutes: 4;
	    other: 5;
	}
	export type AfterSalesServiceDepartments = keyof AfterSalesServiceDepartments$EnumInterface;
	export const afterSalesServiceDepartmentsDatatype: X3EnumDataType<keyof AfterSalesServiceDepartments$EnumInterface, unknown>;
	//# sourceMappingURL=after-sales-service-departments.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/after-sales-service-action-typ.d.ts
declare module '@sage/x3-master-data/lib/enums/after-sales-service-action-typ' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AfterSalesServiceActionTypEnum {
	    noGeographicIncidence = 1,
	    atTheCustomerSite = 2,
	    atOurPremises = 3
	}
	export interface AfterSalesServiceActionTyp$EnumInterface {
	    noGeographicIncidence: 1;
	    atTheCustomerSite: 2;
	    atOurPremises: 3;
	}
	export type AfterSalesServiceActionTyp = keyof AfterSalesServiceActionTyp$EnumInterface;
	export const afterSalesServiceActionTypDatatype: X3EnumDataType<keyof AfterSalesServiceActionTyp$EnumInterface, unknown>;
	//# sourceMappingURL=after-sales-service-action-typ.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/addressee-types.d.ts
declare module '@sage/x3-master-data/lib/enums/addressee-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AddresseeTypesEnum {
	    user = 1,
	    businessPartners = 2,
	    contact = 3,
	    other = 4
	}
	export interface AddresseeTypes$EnumInterface {
	    user: 1;
	    businessPartners: 2;
	    contact: 3;
	    other: 4;
	}
	export type AddresseeTypes = keyof AddresseeTypes$EnumInterface;
	export const addresseeTypesDatatype: X3EnumDataType<keyof AddresseeTypes$EnumInterface, unknown>;
	//# sourceMappingURL=addressee-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/active-inactive.d.ts
declare module '@sage/x3-master-data/lib/enums/active-inactive' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActiveInactiveEnum {
	    active = 1,
	    inactive = 2
	}
	export interface ActiveInactive$EnumInterface {
	    active: 1;
	    inactive: 2;
	}
	export type ActiveInactive = keyof ActiveInactive$EnumInterface;
	export const activeInactiveDatatype: X3EnumDataType<keyof ActiveInactive$EnumInterface, unknown>;
	//# sourceMappingURL=active-inactive.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/actions.d.ts
declare module '@sage/x3-master-data/lib/enums/actions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionsEnum {
	    select = 1,
	    scrap = 2,
	    useUp = 3,
	    modify = 4,
	    moveToSpares = 5,
	    complete = 6,
	    completeAndModify = 7,
	    disassemble = 8,
	    change = 9,
	    remove = 10,
	    block = 11,
	    delay = 12,
	    cancel = 13,
	    returnToSupplier = 14,
	    receiveAndModify = 15,
	    deleteLines = 16,
	    concessions = 17,
	    close = 18,
	    consult = 19,
	    inform = 20,
	    addOperations = 21,
	    modifyOperations = 22,
	    createNewForecast = 23,
	    updateForecast = 24
	}
	export interface Actions$EnumInterface {
	    select: 1;
	    scrap: 2;
	    useUp: 3;
	    modify: 4;
	    moveToSpares: 5;
	    complete: 6;
	    completeAndModify: 7;
	    disassemble: 8;
	    change: 9;
	    remove: 10;
	    block: 11;
	    delay: 12;
	    cancel: 13;
	    returnToSupplier: 14;
	    receiveAndModify: 15;
	    deleteLines: 16;
	    concessions: 17;
	    close: 18;
	    consult: 19;
	    inform: 20;
	    addOperations: 21;
	    modifyOperations: 22;
	    createNewForecast: 23;
	    updateForecast: 24;
	}
	export type Actions = keyof Actions$EnumInterface;
	export const actionsDatatype: X3EnumDataType<keyof Actions$EnumInterface, unknown>;
	//# sourceMappingURL=actions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/actions-on-disposal.d.ts
declare module '@sage/x3-master-data/lib/enums/actions-on-disposal' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionsOnDisposalEnum {
	    disposal = 1,
	    disposalCancellation = 2,
	    stopCancellation = 3
	}
	export interface ActionsOnDisposal$EnumInterface {
	    disposal: 1;
	    disposalCancellation: 2;
	    stopCancellation: 3;
	}
	export type ActionsOnDisposal = keyof ActionsOnDisposal$EnumInterface;
	export const actionsOnDisposalDatatype: X3EnumDataType<keyof ActionsOnDisposal$EnumInterface, unknown>;
	//# sourceMappingURL=actions-on-disposal.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/actions-of-navigation.d.ts
declare module '@sage/x3-master-data/lib/enums/actions-of-navigation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionsOfNavigationEnum {
	    new = 1,
	    filter = 2
	}
	export interface ActionsOfNavigation$EnumInterface {
	    new: 1;
	    filter: 2;
	}
	export type ActionsOfNavigation = keyof ActionsOfNavigation$EnumInterface;
	export const actionsOfNavigationDatatype: X3EnumDataType<keyof ActionsOfNavigation$EnumInterface, unknown>;
	//# sourceMappingURL=actions-of-navigation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/actioner-email-text.d.ts
declare module '@sage/x3-master-data/lib/enums/actioner-email-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionerEmailTextEnum {
	    planForChangeRequest1ToAction = 1,
	    youAreAssignedAsAnActionerForThePlan = 2,
	    toViewTheChangeRequestClickTheLink = 3
	}
	export interface ActionerEmailText$EnumInterface {
	    planForChangeRequest1ToAction: 1;
	    youAreAssignedAsAnActionerForThePlan: 2;
	    toViewTheChangeRequestClickTheLink: 3;
	}
	export type ActionerEmailText = keyof ActionerEmailText$EnumInterface;
	export const actionerEmailTextDatatype: X3EnumDataType<keyof ActionerEmailText$EnumInterface, unknown>;
	//# sourceMappingURL=actioner-email-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/action-origins.d.ts
declare module '@sage/x3-master-data/lib/enums/action-origins' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionOriginsEnum {
	    manualCreation = 1,
	    agenda = 2
	}
	export interface ActionOrigins$EnumInterface {
	    manualCreation: 1;
	    agenda: 2;
	}
	export type ActionOrigins = keyof ActionOrigins$EnumInterface;
	export const actionOriginsDatatype: X3EnumDataType<keyof ActionOrigins$EnumInterface, unknown>;
	//# sourceMappingURL=action-origins.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/action-on-physical-asset-count.d.ts
declare module '@sage/x3-master-data/lib/enums/action-on-physical-asset-count' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionOnPhysicalAssetCountEnum {
	    newNote = 1,
	    pendingDecision = 2,
	    validated = 3,
	    rejected = 4,
	    assetUpdated = 5,
	    matchingAsset = 6,
	    rejectedNote = 7
	}
	export interface ActionOnPhysicalAssetCount$EnumInterface {
	    newNote: 1;
	    pendingDecision: 2;
	    validated: 3;
	    rejected: 4;
	    assetUpdated: 5;
	    matchingAsset: 6;
	    rejectedNote: 7;
	}
	export type ActionOnPhysicalAssetCount = keyof ActionOnPhysicalAssetCount$EnumInterface;
	export const actionOnPhysicalAssetCountDatatype: X3EnumDataType<keyof ActionOnPhysicalAssetCount$EnumInterface, unknown>;
	//# sourceMappingURL=action-on-physical-asset-count.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/action-2070.d.ts
declare module '@sage/x3-master-data/lib/enums/action-2070' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Action2070Enum {
	    send = 1,
	    receive = 2,
	    all = 3
	}
	export interface Action2070$EnumInterface {
	    send: 1;
	    receive: 2;
	    all: 3;
	}
	export type Action2070 = keyof Action2070$EnumInterface;
	export const action2070Datatype: X3EnumDataType<keyof Action2070$EnumInterface, unknown>;
	//# sourceMappingURL=action-2070.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/action-2011.d.ts
declare module '@sage/x3-master-data/lib/enums/action-2011' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Action2011Enum {
	    send = 1,
	    receive = 2
	}
	export interface Action2011$EnumInterface {
	    send: 1;
	    receive: 2;
	}
	export type Action2011 = keyof Action2011$EnumInterface;
	export const action2011Datatype: X3EnumDataType<keyof Action2011$EnumInterface, unknown>;
	//# sourceMappingURL=action-2011.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/accounting-referential.d.ts
declare module '@sage/x3-master-data/lib/enums/accounting-referential' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountingReferentialEnum {
	    undetermined = 1,
	    companyAccounting = 2,
	    groupAccounting = 3
	}
	export interface AccountingReferential$EnumInterface {
	    undetermined: 1;
	    companyAccounting: 2;
	    groupAccounting: 3;
	}
	export type AccountingReferential = keyof AccountingReferential$EnumInterface;
	export const accountingReferentialDatatype: X3EnumDataType<keyof AccountingReferential$EnumInterface, unknown>;
	//# sourceMappingURL=accounting-referential.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/accounting-nature.d.ts
declare module '@sage/x3-master-data/lib/enums/accounting-nature' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountingNatureEnum {
	    fixedAssetsInProgress = 1,
	    fixedAssetsInService = 2,
	    cost = 3,
	    others = 4
	}
	export interface AccountingNature$EnumInterface {
	    fixedAssetsInProgress: 1;
	    fixedAssetsInService: 2;
	    cost: 3;
	    others: 4;
	}
	export type AccountingNature = keyof AccountingNature$EnumInterface;
	export const accountingNatureDatatype: X3EnumDataType<keyof AccountingNature$EnumInterface, unknown>;
	//# sourceMappingURL=accounting-nature.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/accounting-journal-category.d.ts
declare module '@sage/x3-master-data/lib/enums/accounting-journal-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountingJournalCategoryEnum {
	    actual = 1,
	    activeSimulation = 2,
	    inactiveSimulation = 3,
	    offBalanceSheet = 4,
	    template = 5
	}
	export interface AccountingJournalCategory$EnumInterface {
	    actual: 1;
	    activeSimulation: 2;
	    inactiveSimulation: 3;
	    offBalanceSheet: 4;
	    template: 5;
	}
	export type AccountingJournalCategory = keyof AccountingJournalCategory$EnumInterface;
	export const accountingJournalCategoryDatatype: X3EnumDataType<keyof AccountingJournalCategory$EnumInterface, unknown>;
	//# sourceMappingURL=accounting-journal-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/accounting-date-rules.d.ts
declare module '@sage/x3-master-data/lib/enums/accounting-date-rules' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountingDateRulesEnum {
	    automaticJournal = 1,
	    startOfProcessedPeriod = 2,
	    endOfProcessedPeriod = 3,
	    startOfProcessedFy = 4,
	    endOfProcessedFy = 5,
	    startOfCurrentPeriod = 6,
	    endOfCurrentPeriod = 7,
	    enteredDate = 8,
	    specificDate = 9
	}
	export interface AccountingDateRules$EnumInterface {
	    automaticJournal: 1;
	    startOfProcessedPeriod: 2;
	    endOfProcessedPeriod: 3;
	    startOfProcessedFy: 4;
	    endOfProcessedFy: 5;
	    startOfCurrentPeriod: 6;
	    endOfCurrentPeriod: 7;
	    enteredDate: 8;
	    specificDate: 9;
	}
	export type AccountingDateRules = keyof AccountingDateRules$EnumInterface;
	export const accountingDateRulesDatatype: X3EnumDataType<keyof AccountingDateRules$EnumInterface, unknown>;
	//# sourceMappingURL=accounting-date-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/accounting-code-type.d.ts
declare module '@sage/x3-master-data/lib/enums/accounting-code-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountingCodeTypeEnum {
	    product = 1,
	    customer = 2,
	    supplier = 3,
	    salesRep = 4,
	    buyer = 5,
	    journal = 6,
	    company = 7,
	    site = 8,
	    currency = 9,
	    tax = 10,
	    salesFooter = 11,
	    discount = 12,
	    bank = 13,
	    payment = 14,
	    fixedAssets = 15,
	    purchaseFooter = 16,
	    miscellaneousBusinessPartners = 17,
	    costCenter = 18,
	    overheads = 19,
	    expensesCosts = 20,
	    factor = 21,
	    leaseContract = 22,
	    grant = 23,
	    concessionAgreement = 24,
	    cost = 25,
	    interface = 26,
	    employee = 27,
	    department = 28,
	    profile = 29,
	    user = 30,
	    fund = 31,
	    allocation = 32,
	    contribution = 33,
	    expenseNote = 34,
	    accountingContract = 35,
	    projectCostType = 36,
	    project = 37
	}
	export interface AccountingCodeType$EnumInterface {
	    product: 1;
	    customer: 2;
	    supplier: 3;
	    salesRep: 4;
	    buyer: 5;
	    journal: 6;
	    company: 7;
	    site: 8;
	    currency: 9;
	    tax: 10;
	    salesFooter: 11;
	    discount: 12;
	    bank: 13;
	    payment: 14;
	    fixedAssets: 15;
	    purchaseFooter: 16;
	    miscellaneousBusinessPartners: 17;
	    costCenter: 18;
	    overheads: 19;
	    expensesCosts: 20;
	    factor: 21;
	    leaseContract: 22;
	    grant: 23;
	    concessionAgreement: 24;
	    cost: 25;
	    interface: 26;
	    employee: 27;
	    department: 28;
	    profile: 29;
	    user: 30;
	    fund: 31;
	    allocation: 32;
	    contribution: 33;
	    expenseNote: 34;
	    accountingContract: 35;
	    projectCostType: 36;
	    project: 37;
	}
	export type AccountingCodeType = keyof AccountingCodeType$EnumInterface;
	export const accountingCodeTypeDatatype: X3EnumDataType<keyof AccountingCodeType$EnumInterface, unknown>;
	//# sourceMappingURL=accounting-code-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/account-type.d.ts
declare module '@sage/x3-master-data/lib/enums/account-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountTypeEnum {
	    normal = 1,
	    control = 2
	}
	export interface AccountType$EnumInterface {
	    normal: 1;
	    control: 2;
	}
	export type AccountType = keyof AccountType$EnumInterface;
	export const accountTypeDatatype: X3EnumDataType<keyof AccountType$EnumInterface, unknown>;
	//# sourceMappingURL=account-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/account-structure.d.ts
declare module '@sage/x3-master-data/lib/enums/account-structure' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountStructureEnum {
	    bankBp = 1,
	    bankAccount = 2,
	    accountBp = 3
	}
	export interface AccountStructure$EnumInterface {
	    bankBp: 1;
	    bankAccount: 2;
	    accountBp: 3;
	}
	export type AccountStructure = keyof AccountStructure$EnumInterface;
	export const accountStructureDatatype: X3EnumDataType<keyof AccountStructure$EnumInterface, unknown>;
	//# sourceMappingURL=account-structure.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/account-field.d.ts
declare module '@sage/x3-master-data/lib/enums/account-field' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountFieldEnum {
	    alphanumeric = 1,
	    numeric = 2
	}
	export interface AccountField$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	}
	export type AccountField = keyof AccountField$EnumInterface;
	export const accountFieldDatatype: X3EnumDataType<keyof AccountField$EnumInterface, unknown>;
	//# sourceMappingURL=account-field.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/acceptable-quality-level.d.ts
declare module '@sage/x3-master-data/lib/enums/acceptable-quality-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AcceptableQualityLevelEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    substituteValue9 = 9,
	    substituteValue10 = 10,
	    substituteValue11 = 11,
	    substituteValue12 = 12
	}
	export interface AcceptableQualityLevel$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    substituteValue9: 9;
	    substituteValue10: 10;
	    substituteValue11: 11;
	    substituteValue12: 12;
	}
	export type AcceptableQualityLevel = keyof AcceptableQualityLevel$EnumInterface;
	export const acceptableQualityLevelDatatype: X3EnumDataType<keyof AcceptableQualityLevel$EnumInterface, unknown>;
	//# sourceMappingURL=acceptable-quality-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/acc-source-type.d.ts
declare module '@sage/x3-master-data/lib/enums/acc-source-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccSourceTypeEnum {
	    event = 1,
	    depreciation = 2,
	    otherTable = 3,
	    provisionsForRenewal = 4,
	    varianceBetweenPlans = 5
	}
	export interface AccSourceType$EnumInterface {
	    event: 1;
	    depreciation: 2;
	    otherTable: 3;
	    provisionsForRenewal: 4;
	    varianceBetweenPlans: 5;
	}
	export type AccSourceType = keyof AccSourceType$EnumInterface;
	export const accSourceTypeDatatype: X3EnumDataType<keyof AccSourceType$EnumInterface, unknown>;
	//# sourceMappingURL=acc-source-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-master-data/build/lib/enums/abel-entreprise-plans.d.ts
declare module '@sage/x3-master-data/lib/enums/abel-entreprise-plans' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AbelEntreprisePlansEnum {
	    technical = 1,
	    reprocessed = 2,
	    grant = 3,
	    free1 = 4,
	    free2 = 5,
	    free3 = 6,
	    free4 = 7,
	    free5 = 8,
	    free6 = 9,
	    none = 10
	}
	export interface AbelEntreprisePlans$EnumInterface {
	    technical: 1;
	    reprocessed: 2;
	    grant: 3;
	    free1: 4;
	    free2: 5;
	    free3: 6;
	    free4: 7;
	    free5: 8;
	    free6: 9;
	    none: 10;
	}
	export type AbelEntreprisePlans = keyof AbelEntreprisePlans$EnumInterface;
	export const abelEntreprisePlansDatatype: X3EnumDataType<keyof AbelEntreprisePlans$EnumInterface, unknown>;
	//# sourceMappingURL=abel-entreprise-plans.d.ts.map
}
declare module '@sage/x3-master-data' {
	export * from '@sage/x3-master-data/index';
}
