"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Supplier = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        code: {
            code: 'code',
        },
        category: {
            code: 'category',
        },
        payToBusinessPartner: {
            code: 'payToBusinessPartner',
        },
        payToBusinessPartnerAddress: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'payToBusinessPartner',
            code: 'payToBusinessPartnerAddress',
        },
        billBySupplier: {
            code: 'billBySupplier',
        },
        billBySupplierAddress: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'billBySupplier',
            code: 'billBySupplierAddress',
        },
        groupSupplier: {
            code: 'groupSupplier',
        },
        riskSupplier: {
            code: 'riskSupplier',
        },
        carrier: {
            code: 'carrier',
        },
        defaultContact: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'code',
            code: 'defaultContact',
        },
        incoterm: {
            code: 'incoterm',
        },
        addressByDefault: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'code',
            code: 'addressByDefault',
        },
        contact: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'code',
            code: 'contact',
        },
        businessPartner: {
            code: 'code',
        },
        purchaseOrderTextRef: {
            code: 'purchaseOrderTextKey',
        },
        returnOrderTextRef: {
            code: 'returnOrderTextKey',
        },
    },
    collectionJoins: {
        addresses: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'code',
        },
        contacts: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'code',
        },
    },
};
const compositeReferences = {
    businessPartner: {
        acronym: 'acronym',
        businessPartnerSite: 'businessPartnerSite',
        cfonbPaymentMethod: 'cfonbPaymentMethod',
        companyName1: 'companyName1',
        companyName2: 'companyName2',
        companyNames: 'companyNames',
        consolidationCode: 'consolidationCode',
        consolidationGroup: 'consolidationGroup',
        consolidationPartner: 'consolidationPartner',
        country: 'country',
        customerOrSupplierOriginCategory: 'customerOrSupplierOriginCategory',
        documentType: 'documentType',
        economicOperatorRegistrationAndIdNumber: 'economicOperatorRegistrationAndIdNumber',
        europeanUnionVatNumber: 'europeanUnionVatNumber',
        fiscalCode: 'fiscalCode',
        isCashExcluded: 'isCashExcluded',
        isIntersite: 'isIntersite',
        isMailingProhibited: 'isMailingProhibited',
        isPhysicalPerson: 'isPhysicalPerson',
        isPublicSector: 'isPublicSector',
        isServiceCaller: 'isServiceCaller',
        isServiceSupplier: 'isServiceSupplier',
        italianTaxNumber: 'italianTaxNumber',
        language: 'language',
        nonResidentAccount: 'nonResidentAccount',
        registrationNumber: 'registrationNumber',
        relatedCompany: 'relatedCompany',
        reportAccessCode: 'reportAccessCode',
        shortCompanyName: 'shortCompanyName',
        siteIdentificationNumber: 'siteIdentificationNumber',
        standardIndustrialClassificationCode: 'standardIndustrialClassificationCode',
        vatNumber: 'vatNumber',
    },
    purchaseOrderTextRef: {
        purchaseOrderText: 'text',
    },
    returnOrderTextRef: {
        returnOrderText: 'text',
    },
};
let Supplier = class Supplier extends xtrem_core_1.Node {
};
exports.Supplier = Supplier;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], Supplier.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BSGCOD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SupplierCategory,
    })
], Supplier.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRPAY',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], Supplier.prototype, "payToBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAPAY',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], Supplier.prototype, "payToBusinessPartnerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPSINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], Supplier.prototype, "billBySupplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAINV',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], Supplier.prototype, "billBySupplierAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPSGRU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], Supplier.prototype, "groupSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPSRSK',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], Supplier.prototype, "riskSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCNUMBPS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Supplier.prototype, "ourCustomerNumberForSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPTNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], Supplier.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTNAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierContact,
    })
], Supplier.prototype, "defaultContact", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Supplier.prototype, "location", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ABCCLS',
        dataType: () => sageX3MasterData.enums.productAbcClassDatatype,
    })
], Supplier.prototype, "supplierABCClass", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHGTYP',
        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
    })
], Supplier.prototype, "rateType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECICT',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Incoterm,
    })
], Supplier.prototype, "incoterm", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECLOC',
        dataType: () => sageX3MasterData.enums.countryLocationDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], Supplier.prototype, "intrastatTransportLocation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], Supplier.prototype, "addressByDefault", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SEVLIN',
    })
], Supplier.prototype, "isMultiLineOrder", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'ORDTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Supplier.prototype, "purchaseOrderTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'RTNTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Supplier.prototype, "returnOrderTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LTIMRKCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Supplier.prototype, "leadTimeRankingCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRIMRKCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Supplier.prototype, "priceRankingCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QLYMRKCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Supplier.prototype, "qualityRankingCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYMRKCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Supplier.prototype, "quantityRankingCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RSKMRKCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Supplier.prototype, "freeRankingCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LTIMRK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Supplier.prototype, "leadTimeRanking", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRIMRK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Supplier.prototype, "priceRanking", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QLYMRK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Supplier.prototype, "qualityRanking", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYMRK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Supplier.prototype, "quantityRanking", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RSKMRK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Supplier.prototype, "freeRanking", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GENMRK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Supplier.prototype, "totalRanking", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OSTCTL',
        dataType: () => sageX3MasterData.enums.workInProgressControlDatatype,
    })
], Supplier.prototype, "creditControl", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECINCRAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], Supplier.prototype, "intrastatIncreaseCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FUPFLG',
    })
], Supplier.prototype, "mustRemindDelivery", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OCNFLG',
    })
], Supplier.prototype, "mustRemindAcknowledgment", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DADFLG',
        serviceOptions: () => [sageX3System.serviceOptions.DasActivityCode],
    })
], Supplier.prototype, "isDas2Submitted", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
    })
], Supplier.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PAYLOKFLG',
    })
], Supplier.prototype, "isPaymentHeld", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NORPRNFLG',
    })
], Supplier.prototype, "mustPrintOrderForm", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NREPRNFLG',
    })
], Supplier.prototype, "mustPrintReceiptNote", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NRTPRNFLG',
    })
], Supplier.prototype, "mustPrintReturnSlip", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KdeActivityCode],
    })
], Supplier.prototype, "ourCustomerNameForSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLG281',
        serviceOptions: () => [sageX3System.serviceOptions.Be281ActivityCode],
    })
], Supplier.prototype, "is281Submitted", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PURPRITYP',
        dataType: () => sageX3MasterData.enums.priceAmountTaxTaxDatatype,
    })
], Supplier.prototype, "amountType", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSHVAT',
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], Supplier.prototype, "isCashVat", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CSHDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], Supplier.prototype, "cashVatDeadline", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUTINVCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], Supplier.prototype, "selfBillingCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'REXNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.RexActivityCode],
    })
], Supplier.prototype, "rexNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WLFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KplActivityCode],
    })
], Supplier.prototype, "hasNoWhiteListVerification", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ELECTINV',
        serviceOptions: () => [sageX3System.serviceOptions.EfatActivityCode],
    })
], Supplier.prototype, "isElectronicInvoicingAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTEFAT',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierContact,
        serviceOptions: () => [sageX3System.serviceOptions.EfatActivityCode],
    })
], Supplier.prototype, "contact", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDATEFAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.EfatActivityCode],
    })
], Supplier.prototype, "startDateForElectronicInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.SupplierAddress,
        isMutable: true,
        dependsOn: ['code'],
    })
], Supplier.prototype, "addresses", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], Supplier.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.SupplierContact,
        isMutable: true,
        dependsOn: ['code'],
    })
], Supplier.prototype, "contacts", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], Supplier.prototype, "purchaseOrderTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], Supplier.prototype, "returnOrderTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRLOG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Supplier.prototype, "acronym", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], Supplier.prototype, "businessPartnerSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MODPAM',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], Supplier.prototype, "cfonbPaymentMethod", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Supplier.prototype, "companyName1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Supplier.prototype, "companyName2", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.BusinessPartnerCompanyNames,
        isMutable: true,
    })
], Supplier.prototype, "companyNames", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GRUCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.CslActivityCode],
    })
], Supplier.prototype, "consolidationCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GRUGPY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.SiteGroupings,
    })
], Supplier.prototype, "consolidationGroup", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CSLBPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
        serviceOptions: () => [sageX3System.serviceOptions.PrcslActivityCode],
    })
], Supplier.prototype, "consolidationPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], Supplier.prototype, "country", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BRGOBJ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Supplier.prototype, "customerOrSupplierOriginCategory", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DOCTYP',
        dataType: () => sageX3MasterData.enums.documentTypeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], Supplier.prototype, "documentType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EORINUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EoriActivityCode],
    })
], Supplier.prototype, "economicOperatorRegistrationAndIdNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], Supplier.prototype, "europeanUnionVatNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FISCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KitActivityCode],
    })
], Supplier.prototype, "fiscalCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CFOEXD',
        serviceOptions: () => [sageX3System.serviceOptions.CfomActivityCode],
    })
], Supplier.prototype, "isCashExcluded", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BETFCY',
    })
], Supplier.prototype, "isIntersite", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRFBDMAG',
    })
], Supplier.prototype, "isMailingProhibited", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEGETT',
    })
], Supplier.prototype, "isPhysicalPerson", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPPFLG',
    })
], Supplier.prototype, "isPublicSector", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DOOFLG',
    })
], Supplier.prototype, "isServiceCaller", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRVFLG',
    })
], Supplier.prototype, "isServiceSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VATNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KitActivityCode],
    })
], Supplier.prototype, "italianTaxNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], Supplier.prototype, "language", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCNONREI',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], Supplier.prototype, "nonResidentAccount", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], Supplier.prototype, "purchaseOrderText", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'REGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KzaActivityCode],
    })
], Supplier.prototype, "registrationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPYREL',
        dataType: () => sageX3MasterData.enums.relatedCompanySettingsDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PbdpoActivityCode],
    })
], Supplier.prototype, "relatedCompany", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACS',
        columnType: 'string',
        node: () => sageX3System.nodes.Access,
    })
], Supplier.prototype, "reportAccessCode", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], Supplier.prototype, "returnOrderText", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRSHO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Supplier.prototype, "shortCompanyName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Supplier.prototype, "siteIdentificationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NAF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KfrActivityCode],
    })
], Supplier.prototype, "standardIndustrialClassificationCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VATNO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KzaActivityCode],
    })
], Supplier.prototype, "vatNumber", void 0);
exports.Supplier = Supplier = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BPSUPPLIER',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            denormalizedPropertyColumnSuffix: {
                companyName1: 0,
                companyName2: 1,
            },
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Supplier);
//# sourceMappingURL=supplier.js.map