import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, decimal, date, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class Supplier extends Node {
    readonly code: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly category: Reference<sageX3MasterData.nodes.SupplierCategory | null>;
    readonly payToBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly payToBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier | null>;
    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly groupSupplier: Reference<sageX3MasterData.nodes.Supplier | null>;
    readonly riskSupplier: Reference<sageX3MasterData.nodes.Supplier | null>;
    readonly ourCustomerNumberForSupplier: Promise<string>;
    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly defaultContact: Reference<sageX3MasterData.nodes.SupplierContact | null>;
    readonly location: Promise<string>;
    readonly supplierABCClass: Promise<sageX3MasterData.enums.ProductAbcClass | null>;
    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
    readonly addressByDefault: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly isMultiLineOrder: Promise<boolean>;
    readonly purchaseOrderTextKey: Promise<string>;
    readonly returnOrderTextKey: Promise<string>;
    readonly leadTimeRankingCoefficient: Promise<decimal | null>;
    readonly priceRankingCoefficient: Promise<decimal | null>;
    readonly qualityRankingCoefficient: Promise<decimal | null>;
    readonly quantityRankingCoefficient: Promise<decimal | null>;
    readonly freeRankingCoefficient: Promise<decimal | null>;
    readonly leadTimeRanking: Promise<decimal | null>;
    readonly priceRanking: Promise<decimal | null>;
    readonly qualityRanking: Promise<decimal | null>;
    readonly quantityRanking: Promise<decimal | null>;
    readonly freeRanking: Promise<decimal | null>;
    readonly totalRanking: Promise<decimal | null>;
    readonly creditControl: Promise<sageX3MasterData.enums.WorkInProgressControl | null>;
    readonly intrastatIncreaseCoefficient: Promise<decimal | null>;
    readonly mustRemindDelivery: Promise<boolean>;
    readonly mustRemindAcknowledgment: Promise<boolean>;
    readonly isDas2Submitted: Promise<boolean>;
    readonly isActive: Promise<boolean>;
    readonly isPaymentHeld: Promise<boolean>;
    readonly mustPrintOrderForm: Promise<boolean>;
    readonly mustPrintReceiptNote: Promise<boolean>;
    readonly mustPrintReturnSlip: Promise<boolean>;
    readonly ourCustomerNameForSupplier: Promise<string>;
    readonly is281Submitted: Promise<boolean>;
    readonly amountType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
    readonly isCashVat: Promise<boolean>;
    readonly cashVatDeadline: Promise<date | null>;
    readonly selfBillingCode: Promise<string>;
    readonly rexNumber: Promise<string>;
    readonly hasNoWhiteListVerification: Promise<boolean>;
    readonly isElectronicInvoicingAllowed: Promise<boolean>;
    readonly contact: Reference<sageX3MasterData.nodes.SupplierContact | null>;
    readonly startDateForElectronicInvoice: Promise<date | null>;
    readonly addresses: Collection<sageX3MasterData.nodes.SupplierAddress>;
    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly contacts: Collection<sageX3MasterData.nodes.SupplierContact>;
    readonly purchaseOrderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly returnOrderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly acronym: Promise<string>;
    readonly businessPartnerSite: Reference<sageX3System.nodes.Site | null>;
    readonly cfonbPaymentMethod: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly companyName1: Promise<string>;
    readonly companyName2: Promise<string>;
    readonly companyNames: Collection<sageX3MasterData.nodes.BusinessPartnerCompanyNames>;
    readonly consolidationCode: Promise<string>;
    readonly consolidationGroup: Reference<sageX3Structure.nodes.SiteGroupings | null>;
    readonly consolidationPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly country: Reference<sageX3Structure.nodes.Country | null>;
    readonly customerOrSupplierOriginCategory: Promise<string>;
    readonly documentType: Promise<sageX3MasterData.enums.DocumentType | null>;
    readonly economicOperatorRegistrationAndIdNumber: Promise<string>;
    readonly europeanUnionVatNumber: Promise<string>;
    readonly fiscalCode: Promise<string>;
    readonly isCashExcluded: Promise<boolean>;
    readonly isIntersite: Promise<boolean>;
    readonly isMailingProhibited: Promise<boolean>;
    readonly isPhysicalPerson: Promise<boolean>;
    readonly isPublicSector: Promise<boolean>;
    readonly isServiceCaller: Promise<boolean>;
    readonly isServiceSupplier: Promise<boolean>;
    readonly italianTaxNumber: Promise<string>;
    readonly language: Reference<sageX3System.nodes.Language>;
    readonly nonResidentAccount: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly purchaseOrderText: Promise<TextStream>;
    readonly registrationNumber: Promise<string>;
    readonly relatedCompany: Promise<sageX3MasterData.enums.RelatedCompanySettings | null>;
    readonly reportAccessCode: Reference<sageX3System.nodes.Access | null>;
    readonly returnOrderText: Promise<TextStream>;
    readonly shortCompanyName: Promise<string>;
    readonly siteIdentificationNumber: Promise<string>;
    readonly standardIndustrialClassificationCode: Promise<string>;
    readonly vatNumber: Promise<string>;
}
//# sourceMappingURL=supplier.d.ts.map