"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SiteContact = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        code: {
            code: 'code',
        },
        role: {
            glossaryId() {
                return 906;
            },
            code: 'role',
        },
        contactRelationship: {
            code: 'code',
        },
    },
};
const compositeReferences = {
    contactRelationship: {
        addressLines: 'addressLines',
        relationshipCellPhone: 'cellPhone',
        relationshipCity: 'city',
        relationshipCountry: 'country',
        relationshipCountryName: 'countryName',
        relationshipDateOfBirth: 'dateOfBirth',
        relationshipEmail: 'email',
        relationshipFax: 'fax',
        relationshipFirstName: 'firstName',
        relationshipFullNameSearchKey: 'fullNameSearchKey',
        relationshipIsMailingProhibited: 'isMailingProhibited',
        relationshipLandline: 'landline',
        relationshipLanguage: 'language',
        relationshipLastName: 'lastName',
        relationshipProfessionalCategory: 'professionalCategory',
        relationshipState: 'state',
        relationshipTitle: 'title',
        relationshipType: 'type',
        relationshipZipCode: 'zipCode',
    },
};
let SiteContact = class SiteContact extends xtrem_core_1.Node {
};
exports.SiteContact = SiteContact;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPATYP',
        dataType: () => sageX3Structure.enums.entityTypeDatatype,
    })
], SiteContact.prototype, "entityType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPANUM',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SiteContact.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCNCRM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ContactRelationship,
    })
], SiteContact.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTFNC',
        dataType: () => sageX3MasterData.enums.functionContactDatatype,
    })
], SiteContact.prototype, "position", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTSRV',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "department", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTMSS',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 906,
            },
            control: {
                glossaryId: 906,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SiteContact.prototype, "role", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "defaultAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "landline", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "fax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WEB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "email", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MOB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "cellPhone", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DPO',
    })
], SiteContact.prototype, "isDataProtectionOfficer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ContactRelationship,
    })
], SiteContact.prototype, "contactRelationship", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.ContactRelationshipAddressLines,
        isMutable: true,
    })
], SiteContact.prototype, "addressLines", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTMOB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "relationshipCellPhone", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "relationshipCity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SiteContact.prototype, "relationshipCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "relationshipCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTBIR',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SiteContact.prototype, "relationshipDateOfBirth", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTEMA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "relationshipEmail", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "relationshipFax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFNA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "relationshipFirstName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFULNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "relationshipFullNameSearchKey", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFBDMAG',
    })
], SiteContact.prototype, "relationshipIsMailingProhibited", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTETS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "relationshipLandline", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTLAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], SiteContact.prototype, "relationshipLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTLNA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "relationshipLastName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTCSP',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SiteContact.prototype, "relationshipProfessionalCategory", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "relationshipState", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTTTL',
        dataType: () => sageX3System.enums.titleDatatype,
    })
], SiteContact.prototype, "relationshipTitle", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTTYP',
        dataType: () => sageX3System.enums.contactTypeDatatype,
    })
], SiteContact.prototype, "relationshipType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ZIP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteContact.prototype, "relationshipZipCode", void 0);
exports.SiteContact = SiteContact = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CONTACT',
        keyPropertyNames: ['entityType', 'site', 'code'],
        indexes: [
            {
                orderBy: {
                    entityType: 1,
                    site: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['entityType', 'site'],
        }),
        getFilters() {
            return [{ entityType: 'site' }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SiteContact);
//# sourceMappingURL=site-contact.js.map