import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, Collection, date } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class SiteContact extends Node {
    readonly entityType: Promise<sageX3Structure.enums.EntityType | null>;
    readonly site: Reference<sageX3System.nodes.Site | null>;
    readonly code: Reference<sageX3MasterData.nodes.ContactRelationship>;
    readonly position: Promise<sageX3MasterData.enums.FunctionContact | null>;
    readonly department: Promise<string>;
    readonly role: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly defaultAddress: Promise<string>;
    readonly landline: Promise<string>;
    readonly fax: Promise<string>;
    readonly email: Promise<string>;
    readonly cellPhone: Promise<string>;
    readonly isDataProtectionOfficer: Promise<boolean>;
    readonly contactRelationship: Reference<sageX3MasterData.nodes.ContactRelationship>;
    readonly addressLines: Collection<sageX3MasterData.nodes.ContactRelationshipAddressLines>;
    readonly relationshipCellPhone: Promise<string>;
    readonly relationshipCity: Promise<string>;
    readonly relationshipCountry: Reference<sageX3Structure.nodes.Country>;
    readonly relationshipCountryName: Promise<string>;
    readonly relationshipDateOfBirth: Promise<date | null>;
    readonly relationshipEmail: Promise<string>;
    readonly relationshipFax: Promise<string>;
    readonly relationshipFirstName: Promise<string>;
    readonly relationshipFullNameSearchKey: Promise<string>;
    readonly relationshipIsMailingProhibited: Promise<boolean>;
    readonly relationshipLandline: Promise<string>;
    readonly relationshipLanguage: Reference<sageX3System.nodes.Language | null>;
    readonly relationshipLastName: Promise<string>;
    readonly relationshipProfessionalCategory: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly relationshipState: Promise<string>;
    readonly relationshipTitle: Promise<sageX3System.enums.Title | null>;
    readonly relationshipType: Promise<sageX3System.enums.ContactType | null>;
    readonly relationshipZipCode: Promise<string>;
}
//# sourceMappingURL=site-contact.d.ts.map